<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */

if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

class Ctl_Staff_Index extends Ctl
{
   public function index()
   {    
       $name = $this->GP('keyword');
		$this->tmpl = 'staff/items.html';  
   }
   
   public function order(){
       $order = $this->GP('order');
        if($order){
            $this->pagedata['order'] = $order;
        }
       $this->tmpl = 'staff/order.html';  
   }
   
   
   public function order_items(){
       $order = $this->GP('order');
       $filter = $staff_ids = $cate_lists = array();
         $filter['cate_id'] = $order;
         $page = max((int) $this->GP('page'), 1);
         $pager['limit'] = $limit = 10;
         $count = 0;
         $cates = K::M('cate/cate')->fetch_all();
         if (!$items = K::M('staff/staff')->items($filter, null, $page, $limit, $count)) {
            $items= array();
        }else{
            foreach($items as $k=>$val){
                $staff_ids[$val['staff_id']] = $val['staff_id'];
            }
            $attrs = K::M('staff/attr')->items(array('staff_id'=>$staff_ids));
            foreach ($attrs as $k=>$val){
                $cate_lists[$val['staff_id']][] = $cates[$val['cate_id']]['title'];
            }
            $lng = $this->GP('lng');
            $lat = $this->GP('lat');
            if(!$lng || !$lat){
                $lng = $this->request['UxLocation']['lng'];
                $lat = $this->request['UxLocation']['lat'];
            }
            foreach($items as $k=>$val){
                $items[$val['staff_id']]['skill'] = $cate_lists[$val['staff_id']];
                $items[$k]['dateline'] = date('Y-m-d',$val['dateline']);
                $items[$k]['rate'] = round($val['praise_num']/$val['comments'],2)*100;
                $items[$k]['d'] = K::M('helper/round')->getdistances($val['lng'], $val['lat'], $lng, $lat);  //距离
            }
            foreach ($items as $k=>$val){
                $items[$k] = $this->filter_fields('staff_id,city_id,mobile,orders,name,face,d,rate,skill,title,lat,lng,score,comments,praise_num,year_num', $val);
            }
        }
        $this->msgbox->set_data('data', array('items' => array_values($items)));
   }
   public function detail($staff_id)
   {
      $staff_id = (int)$staff_id;
      if(!$staff_id){
        $this->msgbox->add('参数错误！', 212);
      }else{
        $detail = K::M('staff/staff')->detail($staff_id);
        if(!$detail){
          $this->msgbox->add('该师傅不存在！', 212);
        }else{
          $cates = K::M('cate/cate')->fetch_all();
          $attrs = K::M('staff/attr')->items(array('staff_id'=>$staff_id));
          foreach ($attrs as $k=>$val){
                $cate_lists[$val['staff_id']][] = $cates[$val['cate_id']]['title'];
                $catelist[] =  $cates[$val['cate_id']];
            }
            $lng = $this->GP('lng');
            $lat = $this->GP('lat');
            if(!$lng || !$lat){
                $lng = $this->request['UxLocation']['lng'];
                $lat = $this->request['UxLocation']['lat'];
            }
            $map = array();
            $map['staff_id'] = $staff_id;
            $map['uid'] = $this->uid;
            if(!$this->uid){
              $detail['is_shoucang'] = 0;
            }else{
              $shoucang = K::M('member/mystaff')->items($map);
              if(!$shoucang){
                $detail['is_shoucang'] = 0;
              }else{
                $detail['is_shoucang'] = 1;
              }
            }
            $detail['skill'] = $cate_lists[$detail['staff_id']];
            $detail['dateline'] = date('Y-m-d',$detail['dateline']);
            $detail['rate'] = round($detail['praise_num']/$detail['comments'],2)*100;
            $detail['d'] = K::M('helper/round')->getdistances($detail['lng'], $detail['lat'], $lng, $lat);  //距离
            $items = $this->filter_fields('staff_id,is_shoucang,city_id,intro,mobile,orders,name,face,d,rate,skill,title,lat,lng,score,comments,praise_num,year_num', $detail);
          $this->pagedata['items'] = $items;
          $this->pagedata['catelist'] = $catelist;
          print_r($catelist);die;
        }
      }

      $this->tmpl = 'staff/detail.html';  
   }
  public function pinglist() 
  {
    $staff_id = $this->GP('staff_id');
    $filter  = array();
    $filter['staff_id'] = $staff_id;
    $page = max((int) $this->GP('page'), 1);
    $pager['limit'] = $limit = 10;
    $count = 0;
    if (!$items = K::M('staff/comment')->items($filter, null, $page, $limit, $count)) {
          $items= array();
    }else{
      foreach ($items as $k=>$val){
        if($val['uid']){
          $member = K::M('member/member')->detail($val['uid']);
          $val['dateline'] = date('Y-m-d',$val['dateline']);
          $val['reply_time'] = date('Y-m-d',$val['reply_time']);
          $val['face'] = $member['face'];
          $val['nickname'] = $member['nickname'];
          $items[$k] = $val;
        }
        $items[$k] = $this->filter_fields('comment_id,staff_id,nickname,face,uid,order_id,score,score_fuwu,score_xiaolv,content,have_photo,reply,reply_ip,reply_time,closed,clientip,dateline', $val);
      }
    }
    $this->msgbox->set_data('data', array('items' => array_values($items)));
  }



    public function shoucang()
  {
    $staff_id = $this->GP('staff_id');
    $uid = $this->uid;
    $filter = array();
    if(!$uid){
      $this->msgbox->add('请先登录！', 300);
    }else if($staff_id && $uid){
      $filter['staff_id'] = $staff_id;
      $filter['uid'] = $uid;
      $detail = K::M('member/mystaff')->items($filter);
      if($detail){
        if(K::M('member/mystaff')->del($uid, $staff_id)){
          $this->msgbox->add('取消收藏成功！', 302);
        }else{
          $this->msgbox->add('取消收藏失败！', 302);
        }
      }else{
        $data = array();
        $data = array('staff_id'=>$staff_id,'uid'=>$uid);
        if(K::M('member/mystaff')->create($data)){
        $this->msgbox->add('收藏成功！', 302);
        }else{
            $this->msgbox->add('收藏失败！', 302);
        }
      }
    }else{
        $this->msgbox->add('参数错误！', 301);
    }
  }
   
}