<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */

class Ctl_Trade_Payment extends Ctl
{

    public function __construct(&$system)
    {
        parent::__construct($system);
        $uri = $this->request['uri'];
        if(preg_match('/(return|notify)-(\w+)(-(app))?\.html/i', $uri, $match)){
            $system->request['act'] = $match[1].'_verify';
            $system->request['args'] = array($match[2], $match[4]);
        }
    }

    public function return_verify($code, $from=null)
    {
        if($from && strtolower($from) == 'app' && !defined('IN_APP')){
            define('IN_APP', 'api');
        }
        $forward = $this->mklink('ucenter/money:index');
        if($obj = K::M('trade/payment')->loadPayment($code)){
            if($trade = $obj->return_verify()){
                if(!$log = K::M('payment/log')->log_by_no($trade['trade_no'])){
                    $this->msgbox->add('支付的订单不存在', 211);
                }else if(K::M('payment/log')->set_payed($trade['trade_no'])){
                    if($log['from'] == 'money'){ //余额充值
                        K::M('trade/payment')->payed_money($log, $trade);
                        $this->msgbox->add('充值余额成功');
                    }else{ //订单支付
                        K::M('trade/payment')->payed_order($log, $trade);
                        $this->pagedata['order'] = K::M('order/order')->detail($log['order_id']);
                        $this->msgbox->add('支付订单成功');
                        $forward = $this->mklink('order:detail', array($log['order_id']));
                    }
                }else{
                    if($log['from'] == 'money'){
                        $this->msgbox->add('已经充值成功，请不要重复提交', 214);
                    }else{
                        $this->msgbox->add('该订单已经支付过了', 213);
                    }
                }
            }else{
                $this->msgbox->add('支付验证签名失败', 215);
            }
            if(defined('IN_WEIXIN') && $code == 'alipay'){
                $this->msgbox->set_js('window.top.location.href="'.$forward.'";'); 
            }else{
                $this->msgbox->set_data('forward', $forward); 
            }            
        }
    }

    public function notify_verify($code, $from=null)
    {
        if($from && strtolower($from) == 'app' && !defined('IN_APP')){
            define('IN_APP', 'api');
        }        
        $success = false;
        if($obj = K::M('trade/payment')->loadPayment($code)){
            if($trade = $obj->notify_verify()){
                if(!$log = K::M('payment/log')->log_by_no($trade['trade_no'])){
                    $this->msgbox->add('支付的订单不存在', 211);
                }else if(K::M('payment/log')->set_payed($trade['trade_no'])){
                    if($log['from'] == 'money'){ //金币充值
                        if(K::M('trade/payment')->payed_money($log, $trade)){
                            $success = true;
                        }
                    }else{
                        if(K::M('trade/payment')->payed_order($log, $trade)){
                            $success = true;
                        }
                    }
                }
            }
            $obj->notify_success($success);
        }
    }

    public function deposit($code=null, $order_id=null)
    { //支付定金
        if(!($order_id = (int)$order_id) && !($order_id = (int)$this->GP('order_id'))){
            $this->error(404);
        }else if(empty($code) && !($code = $this->GP('code'))){
            $this->error(404);
        }else if($this->check_login()){
            if(!$order = K::M('order/order')->detail($order_id)){
                $this->msgbox->add('您的订单不存在或已经删除', 211);
            }else if($order['order_status'] < 0){
                $this->msgbox->add('订单已经取消不可支付', 212);
            }else if((!$order['staff_id']&&$order['order_status'] >0)||($order['staff_id']&&$order['order_status'] >1)){
                $this->msgbox->add('当前订单状态不可支付', 212);
            }else if($order['pay_status'] == 1){
                $this->msgbox->add('该订单已经支付过了', 213);
            }else{
               // print_r($order);die;
                $amount = $order['deposit'];
                if($code == 'money'){
                    //使用余额支付
                    if($this->MEMBER['money'] < $order['deposit']){
                        $this->msgbox->add('账户余额不足！',555);
                    }else if(K::M('member/member')->update_money($this->uid, -$amount, '支付订单(ID:'.$order_id.')')){
                        $this->MEMBER['money'] = $this->MEMBER['money'] - $amount;      
                        if(!$order['staff_id']){
                            $date_t = array('pay_status'=>1, 'pay_time'=>__TIME, 'pay_code'=>'money','lasttime'=>__TIME);
                        }else{
                            $date_t = array('order_status'=>1,'pay_status'=>1, 'pay_time'=>__TIME, 'pay_code'=>'money','lasttime'=>__TIME);
                        }
                        
                        if($res = K::M('order/order')->update($order['order_id'],$date_t)){                  
                            if ($this->MEMBER['wx_openid']) {
                                //获取模版消息配置
                                $wx_config = $this->system->config->get('wx_config');
                                $config = $this->system->config->get('site');
                                $a = array('title'=>'恭喜您！订单支付定金成功！', 'items' => array('OrderSn' => $order['order_id'], 'OrderStatus' => '订单支付定金成功'), 'remark' =>'恭喜,您的订单于'.date('Y-m-d H:i:s',time()).'支付定金成功，请等待师傅上门！');
                                $url = K::M('helper/link')->mklink('order:detail',array($detail['order_id']), array(), 'www');
                                K::M('weixin/wechat')->wechat_client($config)->sendTempMsg($this->MEMBER['wx_openid'], $wx_config['tmpl_order_status'], $url, $a);
                                $b = array('title'=>'编号：#'.$order['order_id'].'订单支付定金成功！余额减少'.$amount, 'items' => array('keyword1' => '普通会员', 'keyword2' => '订单支付定金','keyword3' => '余额减少'.$oprice,'keyword4' =>$oprice,'keyword5' => $money), 'remark' =>'恭喜,您的账户于'.date('Y-m-d H:i:s',time()).'支付定金成功！');
                                K::M('weixin/wechat')->wechat_client($config)->sendTempMsg($this->MEMBER['wx_openid'], $wx_config['tmpl_member_money'], $url, $b);
                            }
                            $this->msgbox->add('订单支付定金成功');
                            $this->msgbox->set_data('forward', $this->mklink('order:detail', array($order_id)));
                        }
                    }
                }else{
                    if($url = K::M('trade/payment')->deposit($code, $order)){
                        if(!defined('IN_WEIXIN') && ($code == 'wxpay')){
                            $qrurl = $this->mklink('trade/payment:wxqrcode', array(), array('codeurl'=>$url, 'amount'=>$amount,'order_id'=>$order['order_id']));
                            header("Location:{$qrurl}");
                        }else if(defined('IN_WEIXIN') && ($code == 'alipay')){
                            $this->pagedata['payurl'] = $url;
                            $this->tmpl = 'trade/payment/wxalipay.html';
                        }else{
                            header("Location:{$url}");
                        }
                    }
                }
            }
        }
    }
    
    
    
    public function order($code=null, $order_id=null)
    {
        if(!($order_id = (int)$order_id) && !($order_id = (int)$this->GP('order_id'))){
            $this->error(404);
        }else if(empty($code) && !($code = $this->GP('code'))){
            $this->error(404);
        }else if($this->check_login()){
            if(!$order = K::M('order/order')->detail($order_id)){
                $this->msgbox->add('您的订单不存在或已经删除', 211);
            }else if($order['order_status'] < 0){
                $this->msgbox->add('订单已经取消不可支付', 212);
            }else if($order['order_status'] == 8){
                $this->msgbox->add('订单已经完成不可支付', 212);
            }else if($order['pay_status'] == 1){
                $this->msgbox->add('该订单已经支付过了,不需要重复支付', 213);
            }else if($order['order_status'] != 2){
                $this->msgbox->add('订单状态不正确', 215);
            }else{
                $amount = $order['amount'] - $order['deposit'] - $order['hongbao'];
                //$amount = $order['amount'];
                if($code == 'money'){
                    if($order['order_status'] == 2 && $order['pay_status'] == 0) {
                    //使用余额支付
                        if($amount > 0) {
                            if($this->MEMBER['money'] < $amount){    
                                $this->msgbox->add('账户余额不足！',555);
                            }else if(K::M('member/member')->update_money($this->uid, -$amount, '支付订单(ID:'.$order_id.')')){
                                $this->MEMBER['money'] = $this->MEMBER['money'] - $amount;      
                                if($res = K::M('order/order')->update($order_id, array('order_status'=>8, 'pay_status'=>1, 'pay_time'=>__TIME, 'pay_code'=>'money'))){ 
                                    K::M('staff/staff')->update_money($order['staff_id'], $order['amount'], "订单结算(ID:{$order_id})");      
                                }
                                    if ($this->MEMBER['wx_openid']) {
                                        //获取模版消息配置
                                        $wx_config = $this->system->config->get('wx_config');
                                        $config = $this->system->config->get('site');
                                        $a = array('title'=>'恭喜您！订单支付成功！订单完成！', 'items' => array('OrderSn' => $order['order_id'], 'OrderStatus' => '订单支付成功'), 'remark' =>'恭喜,您的订单于'.date('Y-m-d H:i:s',time()).'支付成功，订单交易完成！');
                                        $url = K::M('helper/link')->mklink('order:detail',array($order_id), array(), 'www');
                                        K::M('weixin/wechat')->wechat_client($config)->sendTempMsg($this->MEMBER['wx_openid'], $wx_config['tmpl_order_status'], $url, $a);
                                        $b = array('title'=>'编号：#'.$order['order_id'].'订单支付成功！余额减少'.$amount, 'items' => array('keyword1' => '普通会员', 'keyword2' => '订单支付','keyword3' => '余额减少'.$oprice,'keyword4' =>$oprice,'keyword5' => $money), 'remark' =>'恭喜,您的账户于'.date('Y-m-d H:i:s',time()).'支付订单成功！');
                                        K::M('weixin/wechat')->wechat_client($config)->sendTempMsg($this->MEMBER['wx_openid'], $wx_config['tmpl_member_money'], $url, $b);
                                    }
                                    K::M('order/log')->create(array('order_id'=>$order_id,'from'=>'member','log'=>'订单已完成','type'=>8));
                                    $this->msgbox->add('订单支付成功');
                                    $this->msgbox->set_data('forward', $this->mklink('order:detail', array($order_id)));
                            }
                        }else{
                            $this->msgbox->add('差价金额不正确',216);
                        }
                    }
                }else{
                    if($url = K::M('trade/payment')->order($code, $order)){
                        if(!defined('IN_WEIXIN') && ($code == 'wxpay')){
                            $qrurl = $this->mklink('trade/payment:wxqrcode', array(), array('codeurl'=>$url, 'amount'=>$amount,'order_id'=>$order['order_id']));
                            header("Location:{$qrurl}");
                        }else if(defined('IN_WEIXIN') && ($code == 'alipay')){
                            $this->pagedata['payurl'] = $url;
                            $this->tmpl = 'trade/payment/wxalipay.html';
                        }else{
                            header("Location:{$url}");
                        }
                    }
                }
            }
        }
    }
    
  
    public function money($code=null,$amount=null)
    {
        $code = $this->GP('code');
        $amount = $this->GP('amount');
        if(!$code){
            $this->msgbox->add('没有选择支付方式',212);
        }else if(empty($amount)){
            $this->msgbox->add('付款金额不合法', 211);
        }else if($this->check_login()){
            if($ret = K::M('trade/payment')->money($this->uid, $code, $amount)){
                $url = $ret['url'];
                $trade_no = $ret['trade_no'];
                if(!defined('IN_WEIXIN') && strpos($url, 'wxpay')){
                    $qrurl = $this->mklink('trade/payment:wxqrcode', array(), array('codeurl'=>$url, 'amount'=>$amount,'order_no'=>$trade_no));
                    header("Location:{$qrurl}");
                }else if(defined('IN_WEIXIN') && ($code == 'alipay')){
                    $this->pagedata['payurl'] = $url;
                    $this->tmpl = 'trade/payment/wxalipay.html';
                }else{
                    header("Location:{$url}");
                }
            }
        }
    }

    
    public function get_payed($from=null,$order_id=null)
    {
        $from = $this->GP('from');
        $order_id = $this->GP('order_id');
        if(!$from || !$order_id){
            $this->ajaxReturn(array('status'=>'error'));
        }else if($from != 'order' && $from != 'money'){
            $this->ajaxReturn(array('status'=>'error'));
        }

        $uid = $this->MEMBER['uid'];
        $r = K::M('payment/log') -> find(array('uid'=>$uid,'payment'=>'wxpay','from'=>$from,'trade_no'=>$order_id),array('log_id'=>'desc'));

        if($r){
            if($r['payed'] == 1){
                $this->ajaxReturn(array('status'=>'success','payed'=>1));
            }else{
                $this->ajaxReturn(array('status'=>'error'));
            }
        }else{
            $this->ajaxReturn(array('status'=>'error'));
        }

    }

    public function wxqrcode()
    {
        if(!$codeurl = $this->GP('codeurl')){
            exit('params error');
        }
        if(!$amount = $this->GP('amount')){
            exit('params error');
        }
        if(!$order_id = $this->GP('order_id')){
            exit('params error');
        }
        $amount = sprintf("%.2f", $amount);
        $this->pagedata['codeurl'] = $codeurl;
        $this->pagedata['amount'] = $amount;
        $this->pagedata['order_id'] = $order_id;
        $this->tmpl = 'trade/payment/wxqrcode.html';
    }

    public function redirect($trade_no)
    {
        $url = K::M('helper/link')->mklink('ucenter/money:index', null, null, 'base');
        if($log = K::M('payment/log')->log_by_no($trade_no)){
            if($log['from'] == 'order'){
                $url = K::M('helper/link')->mklink('order:detail', array($log['order_id']), array(), 'base');
            }
        }
        header("Location:{$url}");
        exit;
    }

}
