<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 */

if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

/*余额明细*/
class Ctl_Ucenter_Jifen extends Ctl_Ucenter
{
   
    public function index()
    {
        $this->check_login();
        $this->tmpl = "ucenter/jifen/index.html";
    }

    public function order_items()
    {
        $this->check_login();
        $filter = $pager = array();
        $page = max((int) $this->GP('page'), 1);
        $pager['limit'] = $limit = 10;
        $filter['uid'] = $this->uid;
        $orderby = array('order_id'=>'desc');
        $count = 0;
        if(!$items = K::M('mall/order')->items($filter, $orderby, $page, $limit, $count)){
            $items = array();
        }else{
            $product_ids = array();
            foreach ($items as $k => $val) {
                $product_ids[$val['product_id']] = $val['product_id'];
            }
            if($product_ids){
                $products = K::M('mall/product')->items_by_ids($product_ids);
            }
            foreach($items as $k=>$val){
                foreach($products as $kk=>$v){
                    if($v['product_id'] == $val['product_id']){
                        $items[$k]['photo'] = $v['photo'];
                        $items[$k]['price'] = $v['jifen'];
                    }
                }
            }
        }
        $this->msgbox->set_data('data', array('items' => array_values($items)));
    }
    
    public function logs()
    {
        $this->check_login();
        $this->tmpl = "ucenter/jifen/logs.html";
    }

    public function loglist()
    {
        $this->check_login();
        $cates = K::M('cate/cate')->fetch_all();
        $filter = $pager = array();
        $page = max((int) $this->GP('page'), 1);
        $pager['limit'] = $limit = 10;
        $filter['uid'] = $this->uid;
        $filter['type'] = 'jifen'; 
        $orderby = array('dateline'=>'desc');
        $count = 0;
        $tyd = strtotime(date('Y-m-d', time()-30*86400));  //30天前
        $filter['dateline'] = $tyd.'~'.time();// 今天
        if(!$items = K::M('member/log')->items($filter, $orderby, $page, $limit, $count)){
            $items = array();
        }else{
            foreach ($items as $key => $value) {
                $product = K::M('mall/product')->detail($value['product_id']);
                $items[$key]['pic'] = $product['photo'];
                $items[$key]['dateline'] = date('Y-m-d H:i:s',$value['dateline']);
            }
        }
        $this->pagedata['items'] = $items;
        $this->msgbox->set_data('data', array('items' => array_values($items)));
    }
}