<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id$
 */

if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

class Mdl_Order_Order extends Mdl_Table
{   
  
    protected $_table = 'order';
    protected $_pk = 'order_id';
    protected $_cols = 'order_id,city_id,uid,cate_id,money,amount,hongbao,hongbao_id,contact,mobile,addr,house,lat,lng,service_time,note,deposit,order_status,pay_status,pay_code,comment_status,pay_ip,pay_time,staff_id,order_from,day,closed,clientip,dateline,lasttime';
    protected $_orderby = array('order_id'=>'DESC');

    public function create($data, $checked=false)
    {
 
        if(!$checked && !$data = $this->_check_schema($data)){
            return false;
        }
        $data['clientip'] = $data['clientip'] ? $data['clientip'] : __IP;
        $data['dateline'] = $data['dateline'] ? $data['dateline'] : __TIME;
        $data['day'] = date('Ymd', $data['dateline']);
        if($id = $this->db->insert($this->_table, $data, true)){
            $this->flush();
        }
        return $id;
    }

    public function set_payed($order_id, $trade=array())
    {        
        if(!$order = $this->detail($order_id)){
            return false;
        }else if($res = $this->db->update($this->_table, array('pay_status'=>1), "order_id='{$order_id}'", true)){
            $a = array('pay_ip'=>__IP,'pay_time'=>__TIME, 'pay_code'=>$trade['pay_code']);
            $this->update($order_id, $a, true);
            K::M('order/log')->create(array('order_id'=>$order_id,'from'=>'payment','log'=>'订单支付成功','type'=>2));
        }
        return $res;
    }

    
    //确认订单 ，结算订单
    public function confirm($order_id=null, $order=null, $from='member')
    {
        $order_id = (int)$order_id;
        if(!$order && !($order = $this->detail($order_id))){
            return false;
        }else if($order['order_status']){ ////-1:已取消，0：未处理，1：已接单，2：补差价，8：订单完成
            $order_id = $order['order_id'];
            if($this->update($order_id, array('order_status'=>8), true)){
                $staff_amount = $shop_amount = 0;
                if($order['online_pay']){
                    if($order['pei_type'] && $order['staff_id']){
                        if($order['pei_type'] == 2){//代购订单，全部结算给配送员
                            $staff_amount = $order['amount'] + $order['hongbao'] + $order['money'];
                            $log = '订单代购完成结算(ID:'.$order_id.')';
                        }else{
                            $staff_amount = $order['pei_amount'];
                            $shop_amount = $order['amount'] + $order['hongbao'] + $order['money'] - $staff_amount;
                            $log = '订单配送完成结算(ID:'.$order_id.')';
                        }
                        if($staff_amount){
                            K::M('staff/staff')->update_money($order['staff_id'], $staff_amount, $log);
                        }
                    }else{
                        $shop_amount = $order['amount'] + $order['hongbao'] + $order['money'];
                    }
                    if($shop_amount){
                        K::M('shop/shop')->update_money($order['shop_id'], $shop_amount, '订单完成结算(ID:'.$order_id.')');
                    }
                }
                if($from == 'admin'){
                    $log = '管理员确认订单完成';
                }else if($from == 'system'){
                    $log = '超过3小时系统自动确认订单完成';
                }else if($from == 'shop'){
                    $log = '商家确认订单完成';
                }else{
                    $log = '用户确认订单完成';
                }
                K::M('order/log')->create(array('order_id'=>$order_id, 'type'=>6, 'from'=>$from, 'log'=>$log));
                return true;
            }
        }
        return false;
    }


    //取消/退单 退回余额+在线支付金额到余额，退回红包
    public function cancel($order_id=null, $order=null, $from='member')
    {
        $order_id = (int)$order_id;
        if(!$order && !($order = $this->detail($order_id))){
            return false;
        }else if(in_array($order['order_status'], array(0, 1, 2))){ ////-1:已取消，0：未处理，1：已接单，2：补差价，8：订单完成
            if($from == 'member' && $order['order_status'] == 1){//用户可以在未接单时直接退单
                $this->msgbox->add('师傅已接单不可取消', 451);
                return false;
            }
            if($this->update($order['order_id'], array('order_status'=>-1))){
                if($order['order_status'] == 0&&$order['pay_status'] == 0){
                    $money = 0;
                }elseif($order['order_status'] == 0&&$order['pay_status'] == 1){
                    $money = $order['deposit'];
                }elseif($order['order_status'] == 2&&$order['pay_status'] == 0){
                    $money = $order['deposit'];
                }elseif($order['order_status'] == 2&&$order['pay_status'] == 1){
                    if($order['hongbao_id']){
                        $money = $order['amount'] - $order['hongbao'];
                    }else{
                        $money = $order['amount'];
                    }
                }
                if($money > 0){ //退回到余额
                    K::M('member/member')->update_money($order['uid'], $money, '订单(ID:'.$order['order_id'].')取消退回到余额');
                }
                if($order['hongbao_id']){ //退还红包
                    K::M('hongbao/hongbao')->update($order['hongbao_id'], array('order_id'=>0, 'used_time'=>0, 'used_ip'=>''));
                }
                //商品库存放在后继版本处理
                if($from == 'admin'){
                    $log = '管理员取消订单(ID:'.$order['order_id'].')';
                }else if($from == 'staff'){
                    $log = '师傅取消订单(ID:'.$order['order_id'].')';
                }else if($from == 'system'){
                    $log = '订单接单时间已过，系统自动取消订单(ID:'.$order['order_id'].')';
                }else{
                    $log = '用户取消订单(ID:'.$order['order_id'].')';
                }
                K::M('order/log')->create(array('type'=>-1, 'from'=>$from, 'log'=>$log, 'order_id'=>$order['order_id']));
                return true;
            }
        }
        return false;
    }

    public function plqx($order=null){
        if($order){
            foreach ($order as $k=>$val){
                if($val &&$val['order_id']){
                    $this->cancel($val['order_id'],$val,$from='system');
                    return true;
                }
            }
        }
    }

    

    public function get_time()
    {
        $return_array = array();
        $start_quarter = 0;
        $start = date('H',__TIME+3600);
        $q = date('i',__TIME+3600);
        if($q <15){
            $start_quarter =0;
        }else if($q <30 &&$q>=15){
            $start_quarter=1;
        }else if($q <45 &&$q>=30){
            $start_quarter=2;
        }else{
            $start_quarter=3;
        }
        $return_array['start'] = $start;
        $return_array['start_quarter'] = $start_quarter;
        return $return_array;
    }

    /**
     * 根据天统计订单
     * param $filter 订单条件
     * param $limit 开始 
     */
    public function count_by_day($filter=null, $page=1,$limit=30)
    {
        if($day = (int)$day){
            return array();
        }
        $where = $this->where($filter);
        $limit = $this->limit($page, $limit);
        $sql = "SELECT `day`, COUNT(1) as day_order, SUM(`amount`) as day_amount, SUM(`money`) as day_money, SUM(`hongbao`) as day_hongbao, SUM(`pei_amount`) as day_pei_money  FROM ".$this->table($this->_table)." WHERE {$where} GROUP BY `day` ORDER BY day ASC $limit";      
        $items = array();
        if($rs = $this->db->Execute($sql)){
            while($row = $rs->fetch()){
                $items[$row['day']] = $row;
            }
        }
        return $items;
    }

    public function count_by_shopid($filter=null, $page=1,$limit=30)
    {
        if($day = (int)$day){
            return array();
        }
        $where = $this->where($filter);
        $limit = $this->limit($page, $limit);
        $sql = "SELECT `shop_id`, COUNT(1) as day_order, SUM(`amount`) as day_amount, SUM(`money`) as day_money, SUM(`hongbao`) as day_hongbao, SUM(`pei_amount`) as day_pei_money  FROM ".$this->table($this->_table)." WHERE {$where} GROUP BY `shop_id` ORDER BY shop_id ASC $limit";      
        $items = array();
        if($rs = $this->db->Execute($sql)){
            while($row = $rs->fetch()){
                $items[$row['shop_id']] = $row;
            }
        }
        return $items;
    }
    public function get_order_status(){
        return array(
            '-1' => '已取消',
            '0' => '未处理',
            '1' => '已接单',
            '2' => '补差价',
            '8' => '订单完成',
        );
    }
	
	public function  get_payments(){
        return array(
            'wxpay' => '微信支付',
            'alipay' => '支付宝支付',
            'money' => '余额支付',
        );
    }
    
    // 订单来源
    public function orderfrom($filter) 
    {
        $where = $this->where($filter);
        $sql = "SELECT order_from, COUNT(1) as nums FROM {$this->table($this->_table)} WHERE {$where} GROUP BY order_from ORDER BY order_from";   
        $items = array();
        if($rs = $this->db->Execute($sql)){
            while($row = $rs->fetch()){
                $items[] = $row;
            }
        }
        return $items;
    }

    public function customs_by_shop($filter, $page=1, $limit=50, $count)
    {
        $where = $this->where($filter);
        $limit = $this->limit($page, $limit);
        $items = array();
        $sql = "SELECT uid, SUM(`amount`+`money`) as total_amount, COUNT(1) total_order FROM ".$this->table($this->_table)." WHERE $where GROUP BY `uid` ORDER BY `uid` $limit";
        if($rs = $this->db->Execute($sql)){
            while($row = $rs->fetch()){
                $items[$row['uid']] = $row;
            }
        }
        return $items;    
    }

    protected function _format_row($row)
    {
        
        if($row['order_status'] < 0){
            $label = '已取消';
            $next = '订单已取消';
        }else if(empty($row['order_status']) && !$row['pay_status']){
            $label = '待付定金';
            $action = '去付定金'; 
            $next = '订单已提交';
            $action_url = K::M('helper/link')->mklink('order/pay',array($row['order_id']));
        }else if(empty($row['order_status']) && $row['pay_status']){
            $label = '待接单';
            $next = '定金已支付';
        }else if($row['order_status']==1 && $row['pay_status']){
            $label = '已接单';
            $next = '等待师傅上门';
        }else if($row['order_status'] == 2 && !$row['pay_status']){
            $label = '待付全款';
            $next = '等待支付全款';
            $action = '去付全款'; 
            $action_url = K::M('helper/link')->mklink('order/detail',array($row['order_id']));
        }else if($row['order_status'] == 8 && !$row['comment_status']){
            $label = '已完成';
            $next = '订单已完成';
            $action = '去评价'; 
            $action_url = K::M('helper/link')->mklink('order/comment',array($row['order_id']));
        }else{
            $label = '已完成';
            $next = '订单已完成';
            $action = '已评价';
            $action_url = "javascript:void(0);";
            $disable = 1;
        }
        $row['order_status_label'] = $label;
        $row['order_action'] = $action;
        $row['action_url'] = $action_url;
        $row['disable'] = $disable;
        $row['next'] = $next;
        return $row;
        
    }

}