<?php
/**
 * Copy Right IJH.CC
 * Each engineer has a duty to keep the code elegant
 * $Id: payment.mdl.php 9343 2015-03-24 07:07:00Z youyi $
 */

if(!defined('__CORE_DIR')){
    exit("Access Denied");
}

class Mdl_Trade_Payment extends Model
{

    public function deposit($code, $order, $from=false)
    {
        if(!$oPayApi = $this->loadPayment($code)){
            return false;
        }
        if(!$log = K::M('payment/log')->log_by_order_id($order['order_id'])){
            $log = array('uid'=>$order['uid'], 'from'=>'order', 'order_id'=>$order['order_id'], 'trade_no'=>$order['order_id'], 'payment'=>$code, 'amount'=>$order['deposit']); //插入订单记录表
            if(!$log_id = K::M('payment/log')->create($log)){
                return false;
            }
            $log = K::M('payment/log')->detail($log_id);
        }
        
        $paycount = K::M('payment/log')->count(array('order_id'=>$order['order_id']));
        if($log['payed'] == 1 && $paycount == 1){
            $this->msgbox->add('该订单已经支付成功', 211);
            return false;
        }
        $a = array();
        if($log['amount'] != $order['deposit']){
            $a['amount'] = $order['deposit'];
        }
        if($log['from'] != 'order'){
            $a['from'] = 'order';
        }
        if($log['payment'] != $code){
            $a['payment'] = $code;
        }
        if($a){
            K::M('payment/log')->update($log['log_id'], $a,  true);
        }
        $params = array();
        $params['order_id'] = $order['order_id'];
        if($paycount > 1) {
            $paylog2 = K::M('payment/log')->find(array('order_id'=>$order['order_id'], 'from'=>'order', 'uid'=>$order['uid'], 'payed'=>2));
            $params['trade_no'] = $paylog2['trade_no'];    
        }else {
            $params['trade_no'] = $log['trade_no'];
        }
        $site = K::$system->config->get('site');
        $params['title'] = $site['title'].'订单';
        $params['body'] = $order['addr'].'('.$order['contact'].','.$order['mobile'].')';
        $params['amount'] = $order['deposit'];
        $params['contact'] = $order['contact'];
        $params['mobile'] = $order['mobile'];
        $params['addr'] = $order['addr'];
        if($from == 'APP'){
            return $oPayApi->build_app($params);
        }else if($from){
            return $oPayApi->build_form($params);
        }else{
            return $oPayApi->build_url($params);
        }
    }
    
    public function order($code, $order, $from=false)
    {
        if(!$oPayApi = $this->loadPayment($code)){
            return false;
        }
        $amount = $order['amount'] - $order['deposit'] - $order['hongbao'];
        if(!$log = K::M('payment/log')->log_by_order_id($order['order_id'])){
            $log = array('uid'=>$order['uid'], 'from'=>'order', 'order_id'=>$order['order_id'], 'trade_no'=>$order['order_id'], 'payment'=>$code, 'amount'=>$amount); //插入订单记录表
            if(!$log_id = K::M('payment/log')->create($log)){
                return false;
            }
            $log = K::M('payment/log')->detail($log_id);
        }
        $paycount = K::M('payment/log')->count(array('order_id'=>$order['order_id']));
        if($log['payed'] == 1 && $paycount == 1){
            $this->msgbox->add('该订单已经支付成功', 211);
            return false;
        }
        $a = array();
        if($log['amount'] != $amount){
            $a['amount'] = $amount;
        }
        if($log['from'] != 'order'){
            $a['from'] = 'order';
        }
        if($log['payment'] != $code){
            $a['payment'] = $code;
        }
        if($a){
            K::M('payment/log')->update($log['log_id'], $a,  true);
        }
        $params = array();
        $params['order_id'] = $order['order_id'];
        if($paycount > 1) {
            $paylog2 = K::M('payment/log')->find(array('order_id'=>$order['order_id'], 'from'=>'order', 'uid'=>$order['uid'], 'payed'=>2));
            $params['trade_no'] = $paylog2['trade_no'];    
        }else {
            $params['trade_no'] = $log['trade_no'];
        }
        $site = K::$system->config->get('site');
        $params['title'] = $site['title'].'订单';
        $params['body'] = $order['addr'].'('.$order['contact'].','.$order['mobile'].')';
        $params['amount'] = $amount;
        $params['contact'] = $order['contact'];
        $params['mobile'] = $order['mobile'];
        $params['addr'] = $order['addr'];
        if($from == 'APP'){
            return $oPayApi->build_app($params);
        }else if($from){
            return $oPayApi->build_form($params);
        }else{
            return $oPayApi->build_url($params);
        }
    }

    public function payed_order($log, $trade)
    {
        if($log['order_id']){
            if(K::M('order/order')->set_payed($log['order_id'], $trade)){
                $order = K::M('order/order')->detail($log['order_id']);
                if($order['staff_id']>0){
                    K::M('order/order')->update($log['order_id'],array('order_status'=>1,'lasttime'=>__TIME));
                }
                if($log['uid']){
                    K::M('member/member')->update_total_money($log['uid'], $log['amount']);
                }
                return true;
            }
        }
        return false;
    }

    
    public function money($uid, $code, $amount, $from=false)
    {
        if(!$uid = (int)$uid){
            return false;
        }else if(!$member = K::M('member/member')->detail($uid)){
            return false;
        }else if(!$oPayApi = $this->loadPayment($code)){
            return false;
        }
        $log = array('uid'=>$uid,'amount'=>$amount,'payment'=>$code,'from'=>'money');
        if(!$log_id = K::M('payment/log')->create($log, true)){
            return false;
        }
        $log = K::M('payment/log')->detail($log_id);
        $site = K::$system->config->get('site');
        $params = array();
        $params['title'] = $site['title'].'-充值余额';
        $params['body'] = '会员:'.$member['nickname'].'('.$uid.')';
        $params['amount'] = $amount;
        $params['trade_no'] = $log['trade_no'];
        if($from == 'APP'){
            return $oPayApi->build_app($params);
        }else{
            //return $oPayApi->build_url($params);
            return array('url'=>$oPayApi->build_url($params),'trade_no'=>$log['trade_no']);
        }
    }

    public function payed_money($log, $trade)
    {
        $package = K::M('member/money')->package();
        if($smoney = $package[$log['amount']]){
            $money = (float)$log['amount'] + (float)$smoney;
            $intro = "在线充值￥{$log['amount']},送￥{$smoney}";
        }else{
            $money = (float)$log['amount'];
            $intro = "在线充值￥{$log['amount']}";
        }
        return K::M('member/money')->update($log['uid'], $money, $intro);
    }

    public function loadPayment($code)
    {

        static $_PayApiObj = array();
        if(!is_object($_PayApiObj[$code])){
            $file = __CFG::DIR."plugins/payments/{$code}/{$code}.php";
            if(!file_exists($file)){
                $this->msgbox->add('您选择的支付接口不存在', 311);
                return false;
            }else if(!$payment = K::M('payment/payment')->payment($code)){
                $this->msgbox->add('您选择的支付接口不存在', 312);
                return false;
            }else if(empty($payment['status'])){
                $this->msgbox->add('您选择的支付接口不可用', 313);
                return false;
            }
            if (defined('IN_WEIXIN') && $code == 'wxpay') {
                $file = __CFG::DIR."plugins/payments/{$code}/jsapi.php";
                include($file);
                $clsName = "Weixin_".ucfirst('jsapi');
            }else{
                include($file);
                $clsName = "Payment_".ucfirst($code);
            }
            $config = $payment['config'];
            $site = K::$system->config->get('site');
            if(/*$code == 'wxpay' && */defined('IN_APP')){
                $config['return_url'] = K::M('helper/link')->mklink('trade/payment:return', array($code, 'app'), null, 'www');
                $config['notify_url'] = K::M('helper/link')->mklink('trade/payment:notify', array($code, 'app'), null, 'www');
            }else{
                $config['return_url'] = K::M('helper/link')->mklink('trade/payment:return', array($code), null, 'www');
                $config['notify_url'] = K::M('helper/link')->mklink('trade/payment:notify', array($code), null, 'www');
            }
            $config['show_url'] = $site['siteurl'];
            $_PayApiObj[$code] = new $clsName($config);
        }
        return $_PayApiObj[$code];
    }
}
