/* This file is created by MySQLReback 2017-02-28 13:50:43 */
 /* 创建表结构 `renshi_admin` */
 DROP TABLE IF EXISTS `renshi_admin`;/* MySQLReback Separation */ CREATE TABLE `renshi_admin` (
  `aId` int(3) NOT NULL AUTO_INCREMENT COMMENT '管理员ID',
  `aUser` varchar(16) NOT NULL COMMENT '管理员用户名',
  `aName` varchar(10) NOT NULL COMMENT '管理员姓名',
  `aPwd` varchar(32) NOT NULL COMMENT '管理员密码',
  `aTel` varchar(11) NOT NULL COMMENT '管理员手机',
  `aEmail` varchar(40) DEFAULT NULL COMMENT '管理员邮箱',
  `aSex` int(1) NOT NULL COMMENT '管理员性别',
  `aPowers` int(1) NOT NULL DEFAULT '0' COMMENT '管理员级别',
  `aDid` int(8) NOT NULL DEFAULT '0' COMMENT '管理员的管理部门ID',
  `aLoginNum` int(9) NOT NULL DEFAULT '0' COMMENT '记录登陆次数',
  `aStatic` int(1) NOT NULL DEFAULT '1' COMMENT '管理员状态',
  `aErrorPwdNum` int(2) NOT NULL DEFAULT '0' COMMENT '记录密码登陆错误次数',
  PRIMARY KEY (`aId`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;/* MySQLReback Separation */
 /* 插入数据 `renshi_admin` */
 INSERT INTO `renshi_admin` VALUES ('1','system','系统管理员','e10adc3949ba59abbe56e057f20f883e','15887835880','309091579@qq.com','1','0','0','123','1','0'),('2','admin','超级管理员','e10adc3949ba59abbe56e057f20f883e','13888218888','','2','1','0','0','1','0'),('3','zhangsan','张三','e10adc3949ba59abbe56e057f20f883e','13629442122','','1','4','0','2','1','0'),('4','lisi','李四','e10adc3949ba59abbe56e057f20f883e','15900000000','15900000000@139.com','1','6','0','2','1','0'),('5','wangwu','王五','e10adc3949ba59abbe56e057f20f883e','15911111111','15911111111@139.com','1','6','1','3','1','0');/* MySQLReback Separation */
 /* 创建表结构 `renshi_admin_role` */
 DROP TABLE IF EXISTS `renshi_admin_role`;/* MySQLReback Separation */ CREATE TABLE `renshi_admin_role` (
  `arId` int(2) NOT NULL AUTO_INCREMENT COMMENT '角色ID',
  `arName` varchar(16) NOT NULL COMMENT '角色名称',
  `arInfo` varchar(200) NOT NULL COMMENT '角色描述',
  `arPowers` varchar(60) NOT NULL COMMENT '角色值',
  PRIMARY KEY (`arId`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;/* MySQLReback Separation */
 /* 插入数据 `renshi_admin_role` */
 INSERT INTO `renshi_admin_role` VALUES ('1','超级管理组','除系统管理员外，本组拥有至高无上的权限','A-A1-A2-A3-B'),('2','系统维护组','拥有系统设置，数据库备份等功能','A-A1-0-0-0'),('3','行政人事组','具有管理多门店多打印机的权限组','A-0-A2-A3-0'),('4','门店管理组','具有管理多个门店的权限组','A-0-0-A3-0'),('5','打印机信息组','具有录入打印机信息的权限组','A-0-A2-0-0'),('6','单门店管理组','只具有添加修改所属门店组的打印机信息','0-0-0-0-B');/* MySQLReback Separation */
 /* 创建表结构 `renshi_department` */
 DROP TABLE IF EXISTS `renshi_department`;/* MySQLReback Separation */ CREATE TABLE `renshi_department` (
  `dId` int(3) NOT NULL AUTO_INCREMENT COMMENT '部门ID',
  `dPid` int(9) NOT NULL COMMENT '下级部门',
  `dPsid` int(9) NOT NULL COMMENT '二级部门ID',
  `dName` varchar(20) NOT NULL COMMENT '部门名称',
  `dDirector` varchar(10) NOT NULL COMMENT '部门负责人',
  `dDirectorTel` varchar(15) NOT NULL COMMENT '部门负责人电话',
  `dDirectorQQ` varchar(11) NOT NULL COMMENT '部门负责人QQ',
  `dDirectorEmail` varchar(50) NOT NULL COMMENT '部门负责人邮箱',
  `dInfo` text NOT NULL COMMENT '部门简介',
  PRIMARY KEY (`dId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;/* MySQLReback Separation */
 /* 创建表结构 `renshi_printinfo` */
 DROP TABLE IF EXISTS `renshi_printinfo`;/* MySQLReback Separation */ CREATE TABLE `renshi_printinfo` (
  `prId` int(6) NOT NULL AUTO_INCREMENT COMMENT '打印机Id',
  `prDid` int(5) NOT NULL COMMENT '打印机所属门店',
  `prNumber` varchar(20) NOT NULL COMMENT '打印机自编号',
  `prName` varchar(20) NOT NULL COMMENT '打印机名称',
  `prXinghao` varchar(20) DEFAULT NULL COMMENT '打印机型号',
  `prUnit` varchar(12) NOT NULL DEFAULT '张' COMMENT '打印机印量单位',
  `prWeixiuName` varchar(5) DEFAULT NULL COMMENT '打印机维修人',
  `prWXTel` varchar(16) DEFAULT NULL COMMENT '打印机维修人电话',
  `prDefaultN` int(9) NOT NULL DEFAULT '0' COMMENT '打印机的初始值',
  `prState` int(1) NOT NULL DEFAULT '1' COMMENT '打印机工作状态',
  `prInputDate` date DEFAULT NULL COMMENT '打印机的录入时间',
  PRIMARY KEY (`prId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;/* MySQLReback Separation */
 /* 创建表结构 `renshi_printnumber` */
 DROP TABLE IF EXISTS `renshi_printnumber`;/* MySQLReback Separation */ CREATE TABLE `renshi_printnumber` (
  `pinId` int(8) NOT NULL AUTO_INCREMENT COMMENT '打印机打印数量的Id',
  `pinPRid` int(6) NOT NULL COMMENT '打印机的ID',
  `pinNowNumber` int(9) NOT NULL COMMENT '打印机的本月打印值',
  `pinDate` date NOT NULL COMMENT '打印机的本月录入日期',
  PRIMARY KEY (`pinId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;/* MySQLReback Separation */
 /* 创建表结构 `renshi_system` */
 DROP TABLE IF EXISTS `renshi_system`;/* MySQLReback Separation */ CREATE TABLE `renshi_system` (
  `sId` int(1) NOT NULL AUTO_INCREMENT COMMENT '系统设置ID',
  `sName` varchar(50) NOT NULL COMMENT '系统名称',
  `sUrl` varchar(100) NOT NULL COMMENT '系统网址',
  `sCompany` varchar(40) NOT NULL COMMENT '公司名称',
  `sCompanyTel` varchar(15) NOT NULL COMMENT '公司电话',
  `sCompanyIntroduce` text NOT NULL COMMENT '公司介绍',
  `sCheckCodeSwitch` int(1) NOT NULL COMMENT '验证码开关',
  `sErrorPwdLockNum` int(3) NOT NULL DEFAULT '3' COMMENT '密码登陆错误几次锁定',
  `sLoginTimeout` int(8) NOT NULL DEFAULT '30' COMMENT '登陆超时（分钟）',
  `sDepartment` varchar(16) NOT NULL DEFAULT '部门' COMMENT '部门别名',
  `sCopyrightName` varchar(100) NOT NULL DEFAULT '云南爱之情信息科技有限公司' COMMENT '版权名称',
  `sCopyrightAuthor` varchar(30) NOT NULL DEFAULT '阮金波' COMMENT '版权作者',
  `sCopyrightAuthorTel` varchar(15) NOT NULL DEFAULT '15887835880' COMMENT '版权作者电话',
  `sCopyrightAuthorQQ` varchar(11) NOT NULL DEFAULT '309091579' COMMENT '版权作者QQ',
  `sLogo` varchar(250) NOT NULL COMMENT '企业LOGO',
  `sVersion` varchar(30) NOT NULL COMMENT '版本号',
  PRIMARY KEY (`sId`),
  KEY `sId` (`sId`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;/* MySQLReback Separation */
 /* 插入数据 `renshi_system` */
 INSERT INTO `renshi_system` VALUES ('1','云南爱之情科技办公文档打印系统','http://www.izhiqing.com','云南爱之情信息科技有限公司','15887835880','云南爱之情信息科技有限公司主营网站开发，软件开发及APP开发等 联系QQ:309091579','0','20','500','部门','云南爱之情信息科技有限公司','阮金波','15887835880','309091579','Uploads/Logo/20160810/57aab6adc0b88.png','PRINTS-20161119-V1.0.0');/* MySQLReback Separation */