<?php

class Goods extends MY_Controller{
    
    public function __construct(){
        parent::__construct();
        $this->load->model('manage/goods_model');
    }
    public function index(){
        $_data ['button']=$this->navButton('Manage');
        $_data ['url'] = $this->url;
        $_data ['type']=$this->get_goods_type('array');
        $this->load->view('manage/goods',$_data); 
    }
    
    public function get_one_goods($_id,$_status){
        if(isset($_id)){
            if($this->goods_model->get_one_goods($_id)){
                $_row = $this->goods_model->get_one_goods($_id);

                $_attr=$this->property($_row,$_status);
                $_attr= array_values($_attr);
                $_str='['.substr(json_encode($_attr),1,-1).']';
                echo '{"total":'.count($_row).',"rows":'.$_str.'}';                
                
            }else{
                echo'{"success":false,"message":"货品不存在"}';
            }
        }else{
            echo'{"success":false,"message":"非法访问"}';
        }

    }
    
    public function get_goods_attr(){
        
            $_row = $this->goods_model->get_goods_attr();
            $_num=count($_row)-1;
           $_attr=$this->property($_row,'a');
           $_attr= array_values($_attr);
            $_str='['.substr(json_encode($_attr),1,-1).']';
            echo '{"total":'.$_num.',"rows":'.$_str.'}';            
    }
    
    public function property($_row,$_str){
        
        foreach($_row as $_key=>$_value){
                if($_str=='e'||$_str=='l') $_one=$_key;
                if($_str=='a') $_one=$_value->name;
                switch ($_one){
                    case 'goods_id':
                        if($_str=='a'){
                            break;
                        }
                        if($_str=='e'||$_str=='l'){
                            $_attr[$_key]['name']='货品ID';
                            $_attr[$_key]['group']='必填';
                            $_attr[$_key]['value']=$_value;
                            break;
                        }
                    case 'goods_name':
                        $_attr[$_key]['name']='货品名称';
                        if($_str!='l'){
                            $_attr[$_key]['editor']=array('type'=>'validatebox','options'=>array('validType'=>'text','required'=>true));
                        }
                        $_attr[$_key]['group']='必填';
                        if($_str=='e'||$_str=='l'){
                            $_attr[$_key]['value']=$_value;
                        }
                        break;
                    case 'goods_code':
                        $_attr[$_key]['name']='货品编号';
                        if($_str!='l'){
                            $_attr[$_key]['editor']=array('type'=>'validatebox','options'=>array('validType'=>'text','required'=>true));
                        }
                        $_attr[$_key]['group']='必填';
                        if($_str=='e'||$_str=='l'){
                            $_attr[$_key]['value']=$_value;
                        }                        
                        break;
                    case 'goods_unit':
                        $_attr[$_key]['name']='基本单位';
                        if($_str!='l'){
                            $_attr[$_key]['editor']=array('type'=>'validatebox','options'=>array('validType'=>'text','required'=>true));
                        }
                        $_attr[$_key]['group']='必填';
                        if($_str=='e'||$_str=='l'){
                            $_attr[$_key]['value']=$_value;
                        }                        
                        break;
                    case 'goods_type':
                        $_attr[$_key]['name']='货品类别';
                        if($_str!='l'){
                            $_attr[$_key]['editor']=array('type'=>'combobox','options'=>array('validType'=>'text','data'=>$this->get_goods_type('array'),'valueField'=>'id','textField'=>'text'));
                        }
                        $_attr[$_key]['group']='非必填';
                        if($_str=='e'||$_str=='l'){
                            $_attr[$_key]['value']=$_value;
                        }                        
                        break;
                    case 'goods_weight':
                        $_attr[$_key]['name']='货品重量g';
                        if($_str!='l'){
                            $_attr[$_key]['editor']='text';
                        }
                        $_attr[$_key]['group']='非必填';
                        if($_str=='e'||$_str=='l'){
                            $_attr[$_key]['value']=$_value;
                        }                        
                        break;
                    default:
                        $_attr[$_key]['name']='Error';
                }        
            }
        return $_attr;
    }
    
     public function add_goods(){
              
            $_data ["goods_name"]=$this->input->post('货品名称');
            $_data ["goods_unit"]=$this->input->post('基本单位');
            $_data ["goods_code"]=$this->input->post('货品编号'); 
             if(empty($_data ["goods_name"])||empty($_data ["goods_unit"])||empty($_data ["goods_code"])){
                 echo'{"success":false,"message":"非法访问"}';exit;
             }   
             if($_data ["goods_code"]){
                 $_row = $this->goods_model->get_goods_code($_data ["goods_code"]);
                 if($_row){
                     echo'{"success":false,"message":"添加失败,货品编号已经存在！"}';exit;
                 }
             }else{
                     echo'{"success":false,"message":"非法访问"}';exit;
             }
             $_goods=$this->input->post();unset($_goods[0]);
             foreach($_goods as $_key=>$_value){
                 if($_key=='货品名称') $_data ["goods_name"]=$_value;
                 if($_key=='货品编号') $_data ["goods_code"]=$_value;
                 if($_key=='基本单位') $_data ["goods_unit"]=$_value;
                 if($_key=='货品类别') $_data ["goods_type"]=$_value;
                 if($_key=='货品重量g') $_data ["goods_weight"]=$_value;
             }
             if($this->goods_model->add_goods($_data)){
                 echo'{"success":true,"message":"添加成功"}';
             }else{
                 echo'{"success":false,"message":"添加失败"}';
             }

     }     
    
     public function update_goods(){
         if($this->input->post('货品ID')){
             $_id=$this->input->post('货品ID');
             
             $_data ["goods_name"]=$this->input->post('货品名称');
             $_data ["goods_unit"]=$this->input->post('基本单位');
             $_data ["goods_code"]=$this->input->post('货品编号');
             if(empty($_data ["goods_name"])||empty($_data ["goods_unit"])||empty($_data ["goods_code"])){
                 echo'{"success":false,"message":"非法访问"}';exit;
             }
             if($_data ["goods_code"]){
                 $_row = $this->goods_model->get_goods_code($_data ["goods_code"]);
                 if($_row['goods_id']!=$_id and isset($_row['goods_id'])){
                     echo'{"success":false,"message":"修改失败,货品编号已经存在！"}';exit;
                 }
             }else{
                 echo'{"success":false,"message":"非法访问"}';exit;
             }             
             
             $_goods=$this->input->post();unset($_goods[0]);
             foreach($_goods as $_key=>$_value){
                 if($_key=='货品名称') $_data ["goods_name"]=$_value;
                 if($_key=='货品编号') $_data ["goods_code"]=$_value;
                 if($_key=='基本单位') $_data ["goods_unit"]=$_value;
                 if($_key=='货品类别') $_data ["goods_type"]=$_value;
                 if($_key=='货品重量g') $_data ["goods_weight"]=$_value;
             }
             if($this->goods_model->update_goods($_id,$_data)){
                 echo'{"success":true,"message":"修改成功"}';
             }else{
                 echo'{"success":false,"message":"修改失败"}';
             }
         }else{
             echo'{"success":false,"message":"非法访问"}';
         }        
     }
   
    
    public function get_goods(){
       $_page=$this->input->post('page');
       $_num=$this->input->post('rows');
       $_offset = ($_page-1)*$_num;
       $_result["total"] =count($this->goods_model->get_goods());
       $_row = $this->goods_model->get_goods($_offset,$_num);
       $_row=array_values($_row);
       $_result["rows"]=$_row;
        echo json_encode($_result);
    }

    public function get_goods_type($_attr){
        $_row = $this->goods_model->get_goods_type();
        foreach ($_row as $_key=>$_value){
            $_rows[$_key]->id=$_value->type_id;
            $_rows[$_key]->text=$_value->type_name;
        }
        $_row=array_values($_rows);
        $_str='['.substr(json_encode($_row),1,-1).']';
        if($_attr=='array'){
            return  $_row;
        }else{
            echo $_str;
        }
    }    
     
}