<?php
class Docput_model extends CI_Model {

    public function __construct()
    {
        $this->load->database();
    }
    
    public function get_goods_attr()
    {  
        $fields = $this->db->field_data('goods');
         return $fields;
    }    

    public function get_goods_status()
    {
        $this->db->order_by ( 'status_id', "asc" );
        $query = $this->db->get('status');
         return $query->result ();
    }   
    
    public function get_docput($_docput_nums=null,$_docin_nums=null,$_send_nums=null,$_from=null,$_to=null,$_offset=null,$_num=null){
        $this->db->order_by ( 'docput_id', "desc" );
        if(!empty($_offset) and !empty($_num)) $this->db->limit($_num,$_offset);
        if(!empty($_docput_nums)) $this->db->where('docput_number', $_docput_nums);        
        if(!empty($_docin_nums)) $this->db->where('docin_number', $_docin_nums);
        if(!empty($_send_nums)) $this->db->where('docin_send_number', $_send_nums);
        if(!empty($_from)) $this->db->where('docput_datetime >=', $_from);
        if(!empty($_to)) $this->db->where('docput_datetime <=', $_to);
        $query = $this->db->get('docput');
         return $query->result ();
    }
    
    public function get_all_goods(){
        $query = $this->db->select('goods_id, goods_name, goods_code,goods_unit')->get('goods');
        return $query->result ();
    }
    
    public function get_all_status(){
        $query = $this->db->get('status');
        return $query->result ();
    }    
    
    public function get_all_area(){
        $query = $this->db->get('area');
        return $query->result ();
    }    
    
    public function get_all_position(){
        $query = $this->db->get('position');
        return $query->result ();
    }    
    
    public function get_one_docin($_id){
        $query = $this->db->get_where('docin', array('docin_id' => $_id));
        return $query->row_array();
    }
    
    public function get_one_docput($_id){
        $query = $this->db->get_where('docput', array('docput_id' => $_id));
        return $query->row_array();
    }
    
    public function get_one_inventory($_id){
        $query = $this->db->get_where('inventory', array('docput_id' => $_id));
        return $query->row_array();
    }    
    
    public function get_docputlist($_id){
        $this->db->select('*');
        $this->db->from('docputlist');
        $this->db->join('goods', 'goods.goods_id = docputlist.goods_id');
        $this->db->where('docputlist.docput_id',$_id);
        $this->db->order_by ( 'docputlist.docputlist_id', "asc" );
        $query = $this->db->get();
        return $query->result ();
    }    
    
    public function update_docput($_id,$_data){
        $this->db->where('docput_id',$_id);
        $this->db->update("docput",$_data);
//         return $this->db->last_query();
        return $this->db->affected_rows();
    }
    public function add_docin($_data){
        $this->db->insert("docin",$_data);
        return $this->db->insert_id();        
    }
    public function add_inventory($_data){
        $this->db->insert_batch("inventory",$_data);
        return $this->db->affected_rows();        
    }    
    public function del_docinlist($_id){
        $this->db->where('docin_id', $_id);
        $this->db->delete('docinlist');
        return $this->db->affected_rows();        
    }
    public function add_docput($_data){
        $this->db->insert("docput",$_data);
        return $this->db->insert_id();
    }
    public function add_docputlist($_data){
        $this->db->insert_batch("docputlist",$_data);
        return $this->db->affected_rows();
    }   
    public function del_docput($_id){
        $this->db->where('docin_id', $_id);
        $this->db->delete('docput');
        return $this->db->affected_rows();
    }  
    public function del_docputlist($_id){
        $this->db->where('docput_id', $_id);
        $this->db->delete('docputlist');
        return $this->db->affected_rows();
    }    
    public function del_inventory($_id){
        $this->db->where('docput_id', $_id);
        $this->db->delete('inventory');
        return $this->db->affected_rows();
    }    
}

