<?php
/**
 * Author:echo
 * Email:sqlgun@qq.com
 * Date: 2018-7-17
 * 有偿二次开发，邮件联系
 */
class Docout_model extends CI_Model {

    public function __construct()
    {
        $this->load->database();
    }
    
    public function get_goods_attr()
    {  
        $fields = $this->db->field_data('goods');
         return $fields;
    }    

    public function get_goods_status()
    {
        $this->db->order_by ( 'status_id', "asc" );
        $query = $this->db->get('status');
         return $query->result ();
    }   
    
    public function get_docout($_docout_nums=null,$_get_nums=null,$_from=null,$_to=null,$_offset=null,$_num=null){
        $this->db->order_by ( 'docout_id', "desc" );
        if(!empty($_offset) and !empty($_num)) $this->db->limit($_num,$_offset);
        if(!empty($_docout_nums)) $this->db->where('docout_number', $_docout_nums);
        if(!empty($_get_nums)) $this->db->where('docout_get_number', $_get_nums);
        if(!empty($_from)) $this->db->where('docout_datetime >=', $_from);
        if(!empty($_to)) $this->db->where('docout_datetime <=', $_to);
        $query = $this->db->get('docout');
         return $query->result ();
    }
    
    public function get_all_goods(){
        $query = $this->db->select('goods_id, goods_name, goods_code,goods_unit')->get('goods');
        return $query->result ();
    }
    
    public function get_all_status(){
        $query = $this->db->get('status');
        return $query->result ();
    }    
    
    public function get_one_docout($_id){
        $query = $this->db->get_where('docout', array('docout_id' => $_id));
        return $query->row_array();
    }
    
    public function get_one_docput($_id){
        $query = $this->db->get_where('docput', array('docout_id' => $_id));
        return $query->row_array();
    }
    
    public function get_docoutlist($_id){
        $this->db->select('*');
        $this->db->from('docoutlist');
        $this->db->join('goods', 'goods.goods_id = docoutlist.goods_id');
        $this->db->where('docoutlist.docout_id',$_id);
        $this->db->order_by ( 'docoutlist.docoutlist_id', "asc" );
        $query = $this->db->get();
        return $query->result ();
    }    
    
    public function update_docout($_id,$_data){
        $this->db->where('docout_id',$_id);
        $this->db->update("docout",$_data);
//         return $this->db->last_query();
        return $this->db->affected_rows();
    }
 
    public function update_docput($_id,$_data){
        $this->db->where('docout_id',$_id);
        $this->db->update("docput",$_data);
        //         return $this->db->last_query();
        return $this->db->affected_rows();
    }    
    
    public function add_docout($_data){
        $this->db->insert("docout",$_data);
        return $this->db->insert_id();        
    }
    public function add_docoutlist($_data){
        $this->db->insert_batch("docoutlist",$_data);
        return $this->db->affected_rows();        
    }    
    public function del_docoutlist($_id){
        $this->db->where('docout_id', $_id);
        $this->db->delete('docoutlist');
        return $this->db->affected_rows();        
    }
    public function add_docput($_data){
        $this->db->insert("docput",$_data);
        return $this->db->insert_id();
    }
    public function add_docputlist($_data){
        $this->db->insert_batch("docputlist",$_data);
        return $this->db->affected_rows();
    }   
    public function del_docput($_id){
        $this->db->where('docout_id', $_id);
        $this->db->delete('docput');
        return $this->db->affected_rows();
    }  
    public function del_docputlist($_id){
        $this->db->where('docput_id', $_id);
        $this->db->delete('docputlist');
        return $this->db->affected_rows();
    } 
    public function del_inventory($_id){
        $this->db->where('docput_id', $_id);
        $this->db->delete('inventory');
        return $this->db->affected_rows();
    }    
    public function get_inventory($_attr){
        $this->db->order_by( 'inventory_id', "asc" );
        $this->db->order_by( 'inventory_datetime', "asc" );
        $query = $this->db->get_where('inventory', $_attr);
//       return $this->db->last_query();
        return $query->result ();
    }    
    public function get_inventory_nums($_id){
        $query = $this->db->get_where('inventory', array('inventory_id' => $_id));
        return $query->row_array();
    }
    public function update_inventory($_id,$_data){
        $this->db->where('inventory_id',$_id);
        $this->db->update("inventory",$_data);
        //         return $this->db->last_query();
        return $this->db->affected_rows();
    }    
    public function update_inventory_batch($_table, $_array,$_key){
        return  $this->db->update_batch($_table, $_array,$_key);
    }

    public function rollback_get_id($_ids){
        $this->db->select('inventory_id,goods_nums');
        $this->db->from('inventory');
        $this->db->where_in('inventory_id', $_ids);
        $query = $this->db->get();
        return $query->result ();
    }
    public function get_docoutlog($_id){
        $query = $this->db->get_where('docoutlog', array('docout_id' => $_id));
        return $query->row_array();
    }    
    public function add_docoutlog($_data){
        $this->db->insert("docoutlog",$_data);
        return $this->db->affected_rows();
    }
    public function update_docoutlog($_id,$_data){
        $this->db->where('docout_id',$_id);
        $this->db->update("docoutlog",$_data);
        return $this->db->affected_rows();
    }    
    public function get_inventory_area_position($_arr){
        $_block = explode(',',$_arr);
        $this->db->select('area.area_id,area.area_name,position.position_id,position.position_name');
        $this->db->from('inventory');
        $this->db->join('area', 'area.area_id = inventory.area_id');
        $this->db->join('position', 'position.position_id = inventory.position_id');
        $this->db->where_in('inventory.inventory_id', $_block);
        $query = $this->db->get();
        return $query->result ();        
//         return $this->db->last_query();
    }
}

