<script>

$(function () {
	
	$('#basebutton').datagrid({
		url : '<?php echo $url?>base/button/get_button',
		fit : true,
		fitColumns : true,
		striped : true,
		rownumbers : true,
		border : false,
		toolbar : '#button_tool',
        singleSelect:true,  
		columns : [[
			{
				field : 'button_id',
				title : '自动编号',
				width : 100,
				checkbox : true,
			},
			{
				field : 'button_name',
				title : '名称',
				width : 100,
			},
			{
				field : 'button_icon',
				title : '图标',
				width : 100,
			},
			{
				field : 'button_way',
				title : '方法',
				width : 100,
			},
			{
				field : 'button_level',
				title : '优先级',
				width : 100,
			}							
		]]
	});

	<?php foreach ($button as $item): ?>
	<?php if($item->button_way=='add'){ ?>					
	$('#basebutton_add').dialog({
		width : 350,
		title : '新增按钮',
		modal : true,
		closed : true,
		iconCls : 'icon-add',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				if ($('#basebutton_add').form('validate')) {
					$.ajax({
						url : '<?php echo $url?>base/button/add_button',
						type : 'post',
						data : {
							button_name : $('#abutton_name').val(),
							button_icon: $('#abutton_icon').val(),
							button_level :$('#abutton_level').val(),
							button_way : $('#abutton_way').val()
						},
						beforeSend : function () {
							$.messager.progress({
								text : '正在新增中...',
							});
						},
						success : function (data, response, status) {
							$.messager.progress('close');
							 var data = eval('(' + data + ')');     
//								console.log(data);
//								alert(data.success);
							if (data.success) {
								$.messager.show({
									title : '提示',
									msg : '新增按钮成功',
								});
								$('#basebutton_add').dialog('close').form('reset');
								$('#basebutton').datagrid('reload');
							} else {
								$.messager.alert('新增失败！', '未知错误导致失败，请重试！', 'warning');
							}
						}
					});
				}
			},
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#basebutton_add').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
	<?php if($item->button_way=='edit'){ ?>				
	
	$('#basebutton_edit').dialog({
		width : 350,
		title : '按钮修改',
		modal : true,
		closed : true,
		iconCls : 'icon-edit',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
// 				console.log( $('#ebutton_url').val());return false;
				$.ajax({
					url : '<?php echo $url?>base/button/update_button',
					type : 'post',
					data : {
						button_id : $('#basebutton_edit > input[name="button_id"]').val(),
						button_icon : $('#ebutton_icon').val(),
						button_level :$('#ebutton_level').val(),
						button_way : $('#ebutton_way').val()
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在修改中...',
						});
					},
					success : function (data, response, status) {
						$.messager.progress('close');
						 var data = eval('(' + data + ')');     
//							console.log(data);
//							alert(data.success);
						if (data.success) {
							$.messager.show({
								title : '提示',
								msg : '修改按钮成功',
							});
							$('#basebutton_edit').dialog('close').form('reset');
							$('#basebutton').datagrid('reload');
						} else {
							$.messager.alert('修改失败！', '未知错误或没有任何修改，请重试！', 'warning');
						}
					}
				});
			}
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#basebutton_edit').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
    <?php endforeach; ?>			
	
	//管理帐号
	$('input[name="button_name"]').validatebox({
		required : true,
		validType : 'length[2,20]',
		missingMessage : '请输入按钮名称',
		invalidMessage : '按钮名称在 2-20 位',
	});

	button_tool = {
		reload : function () {
			$('#basebutton').datagrid('reload');
		},
		remove : function () {
			$('#basebutton').datagrid('unselectAll');
		},
		<?php foreach ($button as $item): ?>
		<?php if($item->button_way=='add'){ ?>			
		add : function () {
			$('#basebutton_add').dialog('open');
			$('input[name="button_name"]').focus();
		},
		<?php }?>
		<?php if($item->button_way=='edit'){ ?>	
		edit : function () {
			var rows = $('#basebutton').datagrid('getSelections');
			if (rows.length > 1) {
				$.messager.alert('警告操作！', '编辑记录只能选定一条数据！', 'warning');
			} else if (rows.length == 1) {
				$.ajax({
					url : '<?php echo $url?>base/button/get_one_button',
					type : 'post',
					data : {
						id : rows[0].button_id
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在获取中...',
						});
					},
					success : function (data, response, status) {
						$.messager.progress('close');						
						if (data) {
							var obj = $.parseJSON(data);
							$('#basebutton_edit').form('load', {
								button_id : obj[0].button_id,
								button_name : obj[0].button_name,
								button_icon: obj[0].button_icon,
								button_level : obj[0].button_level,
								button_way:obj[0].button_way
							}).dialog('open');				
						} else {
							$.messager.alert('获取失败！', '未知错误导致失败，请重试！', 'warning');
						}
					}
				});
			} else if (rows.length == 0) {
				$.messager.alert('警告操作！', '编辑记录至少选定一条数据！', 'warning');
			}
		},
		<?php }?>
	    <?php endforeach; ?>
	};
	
	
	
});
</script>
<table id="basebutton"></table>

<div id="button_tool" style="padding:5px;">
	<div style="margin-bottom:5px;">
	<?php foreach ($button as $item): ?>
    	<a href="#" class="easyui-linkbutton" iconCls="icon-<?=$item->button_icon?>" plain="true" onclick="button_tool.<?=$item->button_way ?>()"><?php echo $item->button_name?></a>
    <?php endforeach; ?>
		<a href="#" class="easyui-linkbutton" iconCls="icon-reload" plain="true"  onclick="button_tool.reload();">刷新</a>
		<a href="#" class="easyui-linkbutton" iconCls="icon-remove" plain="true" onclick="button_tool.remove();">取消选择</a>		
	</div>
</div>


<form id="basebutton_add" style="margin:0;padding:5px 0 0 25px;color:#333;">
	<p>　按钮名称：<input id="abutton_name" type="text" name="button_name" class="textbox" style="width:200px;"></p>
	<p>　按钮图标：<input id="abutton_icon" type="text" name="button_icon" class="textbox" style="width:200px;"></p>
	<p>　按钮方法：<input id="abutton_level" type="text" class="textbox" name="button_level" style="width:200px;"></p>
	<p>按钮优先级：<input id="abutton_way" type="text" class="textbox" name="button_way" style="width:200px;"></p>
</form>


<form id="basebutton_edit" style="margin:0;padding:5px 0 0 25px;color:#333;">
	<input type="hidden" name="button_id" class="textbox" style="width:200px;">
	<p>　按钮名称：<input id="ebutton_name" type="text" name="button_name" disabled="true" class="textbox" style="width:200px;"></p>
	<p>　按钮图标：<input id="ebutton_icon" type="text" name="button_icon" class="textbox" style="width:200px;"></p>
	<p>　按钮方法：<input id="ebutton_way" type="text" class="textbox" name="button_way" style="width:200px;"></p>
	<p>按钮优先级：<input id="ebutton_level" type="text" class="textbox" name="button_level" style="width:200px;"></p>
</form>

