<script>

$(function () {
	
	$('#basenav').datagrid({
		url : '<?php echo $url?>base/Nav/get_nav',
		fit : true,
		fitColumns : true,
		striped : true,
		rownumbers : true,
		border : false,
		toolbar : '#nav_tool',
        singleSelect:true,
        collapsible:true,
        view:groupview,
        groupField:'nav_father_name',
        groupFormatter:function(value,rows){
            return value + ' - ' + rows.length ;
        },
		columns : [[
			{
				field : 'nav_id',
				title : '自动编号',
				width : 100,
				checkbox : true,
			},
			{
				field : 'nav_name',
				title : '导航名称',
				width : 100,
			},
			{
				field : 'nav_status',
				title : '状态',
				width : 100,
			},
			{
				field : 'nav_url',
				title : '控制器',
				width : 100,
			},
			{
				field : 'nav_level',
				title : '优先级',
				width : 100,
			}							
		]]
	});

	$('#anav_fid').combotree({    
	    url: '<?php echo $url?>base/Nav/get_father_nav',
	    required: true   
	});  

	<?php foreach ($button as $item): ?>
	<?php if($item->button_way=='add'){ ?>		
	
	$('#basenav_add').dialog({
		width : 350,
		title : '新增导航',
		modal : true,
		closed : true,
		iconCls : 'icon-add',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				if ($('#basenav_add').form('validate')) {
					$.ajax({
						url : '<?php echo $url?>base/Nav/add_nav',
						type : 'post',
						data : {
							nav_fid : $('#anav_fid').val(),
							nav_name : $('#anav_name').val(),
							nav_url : $('#anav_url').val(),
							nav_level :$('#anav_level').val(),
							nav_status : $('#anav_status').val()
						},
						beforeSend : function () {
							$.messager.progress({
								text : '正在新增中...',
							});
						},
						success : function (data, response, status) {
							$.messager.progress('close');
							 var data = eval('(' + data + ')');     
//								console.log(data);
//								alert(data.success);
							if (data.success) {
								$.messager.show({
									title : '提示',
									msg : '新增导航成功',
								});
								$('#basenav_add').dialog('close').form('reset');
								$('#basenav').datagrid('reload');
							} else {
								$.messager.alert('新增失败！', '未知错误导致失败，请重试！', 'warning');
							}
						}
					});
				}
			},
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#basenav_add').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
	<?php if($item->button_way=='edit'){ ?>				
	
	$('#basenav_edit').dialog({
		width : 350,
		title : '导航修改',
		modal : true,
		closed : true,
		iconCls : 'icon-edit',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
// 				console.log( $('#enav_url').val());return false;
				$.ajax({
					url : '<?php echo $url?>base/Nav/update_nav',
					type : 'post',
					data : {
						nav_id : $('#basenav_edit > input[name="nav_id"]').val(),
						nav_url : $('#enav_url').val(),
						nav_level :$('#enav_level').val(),
						nav_status : $('#enav_status').val()
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在修改中...',
						});
					},
					success : function (data, response, status) {
						$.messager.progress('close');
						 var data = eval('(' + data + ')');     
//							console.log(data);
//							alert(data.success);
						if (data.success) {
							$.messager.show({
								title : '提示',
								msg : '修改导航成功',
							});
							$('#basenav_edit').dialog('close').form('reset');
							$('#basenav').datagrid('reload');
						} else {
							$.messager.alert('修改失败！', '未知错误或没有任何修改，请重试！', 'warning');
						}
					}
				});
			}
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#basenav_edit').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
    <?php endforeach; ?>			
	
	//管理帐号
	$('input[name="nav_name"]').validatebox({
		required : true,
		validType : 'length[2,20]',
		missingMessage : '请输入导航名称',
		invalidMessage : '导航名称在 2-20 位',
	});

	nav_tool = {
		reload : function () {
			$('#basenav').datagrid('reload');
		},
		remove : function () {
			$('#basenav').datagrid('unselectAll');
		},
		<?php foreach ($button as $item): ?>
		<?php if($item->button_way=='add'){ ?>					
		add : function () {
			$('#basenav_add').dialog('open');
		},
		<?php }?>
		<?php if($item->button_way=='edit'){ ?>			
		edit : function () {
			var rows = $('#basenav').datagrid('getSelections');
			if (rows.length > 1) {
				$.messager.alert('警告操作！', '编辑记录只能选定一条数据！', 'warning');
			} else if (rows.length == 1) {
				$.ajax({
					url : '<?php echo $url?>base/Nav/get_one_nav',
					type : 'post',
					data : {
						id : rows[0].nav_id
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在获取中...',
						});
					},
					success : function (data, response, status) {
						$.messager.progress('close');						
						if (data) {
							var obj = $.parseJSON(data);
							$('#basenav_edit').form('load', {
								nav_id : obj[0].nav_id,
								nav_name : obj[0].nav_name,
								nav_url : obj[0].nav_url,
								nav_level : obj[0].nav_level,
								nav_status:obj[0].nav_status
							}).dialog('open');				
						} else {
							$.messager.alert('获取失败！', '未知错误导致失败，请重试！', 'warning');
						}
					}
				});
			} else if (rows.length == 0) {
				$.messager.alert('警告操作！', '编辑记录至少选定一条数据！', 'warning');
			}
		},
		<?php }?>
	    <?php endforeach; ?>		
	};
	
});
</script>
<table id="basenav"></table>

<div id="nav_tool" style="padding:5px;">
	<div style="margin-bottom:5px;">
	<?php foreach ($button as $item): ?>
    	<a href="#" class="easyui-linkbutton" iconCls="icon-<?=$item->button_icon?>" plain="true" onclick="nav_tool.<?=$item->button_way ?>()"><?php echo $item->button_name?></a>
    <?php endforeach; ?>
		<a href="#" class="easyui-linkbutton" iconCls="icon-reload" plain="true"  onclick="nav_tool.reload();">刷新</a>
		<a href="#" class="easyui-linkbutton" iconCls="icon-remove" plain="true" onclick="nav_tool.remove();">取消选择</a>		
	</div>
</div>


<form id="basenav_add" style="margin:0;padding:5px 0 0 25px;color:#333;">
    <p>导航栏父类：<input id="anav_fid" style="width:200px;" name="nav_fid"></p>
	<p>导航栏名称：<input id="anav_name" type="text" name="nav_name" class="textbox" style="width:200px;"></p>
	<p>导航控制器：<input id="anav_url" type="text" name="nav_url" class="textbox" style="width:200px;"></p>
	<p>导航优先级：<input id="anav_level" type="text" class="textbox" name="nav_level" style="width:200px;"></p>
	<p>导航UI状态：<input id="anav_status" type="text" class="textbox" name="nav_status" style="width:200px;"></p>
</form>


<form id="basenav_edit" style="margin:0;padding:5px 0 0 25px;color:#333;">
	<input type="hidden" name="nav_id" class="textbox" style="width:200px;">
	<p>导航栏名称：<input id="enav_name" type="text" name="nav_name" disabled="true" class="textbox" style="width:200px;"></p>
	<p>导航控制器：<input id="enav_url" type="text" name="nav_url" class="textbox" style="width:200px;"></p>
	<p>导航优先级：<input id="enav_level" type="text" class="textbox" name="nav_level" style="width:200px;"></p>
	<p>导航UI状态：<input id="enav_status" type="text" class="textbox" name="nav_status" style="width:200px;"></p>
</form>

