<script>
$(function () {

	$('#indocinalist').datagrid({
		title: '入库单明细',
		fitColumns : true,
		striped : true,
		rownumbers : true,
		border : false,
		toolbar : '#indocinalist_tool',
        singleSelect:true,  
        fitColumns: false,       
		columns : [[
			{
				field : 'goods_id',
				title : '自动编号',
				width : 100,
				checkbox : true,
			},
			{
				field : 'goods_name',
				title : '货品名称',
				width : 100,
			},
			{
				field : 'goods_code',
				title : '货品编号',
				width : 150,
			},
			{
				field : 'goods_unit',
				title : '基本单位',
				width : 100,
			},
			{
				field : 'goods_status',
				title : '货品状态',
				width : 100,
			},
			{
				field : 'goods_nums',
				title : '货品数量',
				width : 100,
			},
			{
				field : 'goods_postil',
				title : '批注',
				width : 200,
			}									
		]]
	});

	$('#indocinalist_date').dialog({
		width : 400,
		title : '新增货品',
		modal : true,
		closed : true,
		iconCls : 'icon-add',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				if ($('#indocinalist_date').form('validate')) {
					var data = {
							goods_id : $('#adocin_goods_name').val(),
							goods_name : $('#adocin_goods_id').val(),
							goods_code :$('#adocin_goods_code').val(),
							goods_unit :$('#adocin_goods_unit').val(),
							goods_status :$('#adocin_goods_status_name').val(),
							goods_nums :$('#adocin_goods_nums').val(),							
							goods_postil :checkDouhao($('#adocin_goods_postil').val())
					};
					$('#indocinalist').datagrid('appendRow',data);
				}
			}
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#indocinalist_date').dialog('close').form('reset');
			},
		}],
	});

	$('#adocin_goods_name').combobox({    
		url : '<?php echo $url?>in/docin/get_all_goods',
	    valueField:'goods_id',    
	    textField:'goods_name',
	    required:true,
	    onSelect:function(rec){    
            $("#adocin_goods_id").val(rec.goods_name);
            $("#adocin_goods_code").val(rec.goods_code);
            $("#adocin_goods_unit").val(rec.goods_unit);
        }
	});

	$('#adocin_goods_nums').numberbox({
	    required:true,
	});
	$('#adocin_goods_status').combobox({    
		url : '<?php echo $url?>in/docin/get_all_status',
	    valueField:'status_id',    
	    textField:'status_name',
	    required:true,
	    onLoadSuccess: function () { 
            var val = $(this).combobox("getData");
            $(this).combobox("select", val[0]['status_id']);
        },
	    onSelect:function(rec){    
            $("#adocin_goods_status_name").val(rec.status_name);
        }    
	});	
	
	indocinalist_tool = {
			add : function () {
				$('#indocinalist_date').dialog('open');
			},
			cut : function () {
				var rows = $('#indocinalist').datagrid('getSelected');
				var indexnums=$('#indocinalist').datagrid('getRowIndex',rows);
				$('#indocinalist').datagrid('deleteRow',indexnums);
			}
	};
	
});
function sendadocin(){
	var rows = $('#indocinalist').datagrid('getRows');
	if(rows.length==0){
		$.messager.alert('提示','请添加入库明细后再提交！','info');
	}else{		
		var docin_date={
			docin_number:$("#adocin_number").val(),
			docin_send_number:$("#adocin_send_number").val()
		};
		var docinlist_date=[];
		$.each(rows,function(r,m){
			docinlist_date. push(m);
		});
		docin_date.docinlist_date=docinlist_date;
		$.ajax({
			url : '<?php echo $url?>in/docin/add_docin',
			type : 'post',
			data : docin_date,
			beforeSend : function () {
				$.messager.progress({
					text : '正在提交中...',
				});
			},
			success : function (data, response, docin) {
				$.messager.progress('close');
				 var data = eval('(' + data + ')');     
//						console.log(data);
				if (data.success) {
					$.messager.show({
						title : '提示',
						msg : data.message,
					});
					$("#adocin_number").val("");
					$("#adocin_send_number").val("");
					$('#indocinalist').datagrid('loadData',{total:0,rows:[]});					
				} else {
					$.messager.alert('添加失败！', data.message, 'warning');					
				}
			}
		});
	}
}
function checkDouhao(val){ 
    var reg = new RegExp("[\uff0c]"); 
    var rs = ""; 
    for (var i = 0, l = val.length; i < val.length; i++) { 
        rs = rs + val.substr(i, 1).replace(reg, ','); 
    } 
    return $.trim(rs); 
}
</script>

<div id="indocinahead" class="easyui-panel" title="入库单头" border="false" style="background:#f4f4f4;width:100%;height:160px;padding:5px;">
   <form id="docina_add" style="margin:0;padding:5px 0 0 25px;color:#333;">
        <p>入库单号：<input id="adocin_number" type="text" class="textbox" style="width:200px;" ></p>
    	<p>送货单号：<input id="adocin_send_number" type="text"  class="textbox" style="width:200px;"></p>
    	<p style="text-align:center;"><a id="sendadocin" href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="return sendadocin();">提交</a></p>
    </form>
</div>

<table id="indocinalist"></table>
<div id="indocinalist_tool" style="padding:5px;">
	<div style="margin-bottom:5px;">
    	<a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="indocinalist_tool.add()">添加</a>
		<a href="#" class="easyui-linkbutton" iconCls="icon-no" plain="true"  onclick="indocinalist_tool.cut();">移除</a>
	</div>
</div>

<form id="indocinalist_date" style="margin:0;padding:5px 0 0 25px;color:#333;">
    <p>货品名称：<input id="adocin_goods_name" style="width:200px;"></p>
    <input type="hidden" id="adocin_goods_id" class="textbox" style="width:200px;">
    <input type="hidden" id="adocin_goods_code" class="textbox" style="width:200px;">
	<p>货品单位：<input id="adocin_goods_unit" type="text" disabled="true"   class="textbox" style="width:200px;"></p>
	<p>货品状态：<input id="adocin_goods_status" style="width:200px;"></p>
	<input type="hidden" id="adocin_goods_status_name" class="textbox" style="width:200px;">
	<p>货品数量：<input id="adocin_goods_nums" type="text"   class="textbox" style="width:200px;"></p>
	<p>货品批注：<input placeholder="批注以英文逗号,分割 例如 : 红色,NT3500" id="adocin_goods_postil" type="text"   class="textbox" style="width:250px;"></p>
</form>

