<!--
/**
 * Author:echo
 * Email:sqlgun@qq.com
 * Date: 2018-7-17
 * 有偿二次开发，邮件联系
 */
-->
<script>
$(function () {

	$('#indocinelist').datagrid({
		title: '入库单明细',
		url : '<?php echo $url?>in/docin/get_docinlist/'+<?=$id?>,		
		fitColumns : true,
		striped : true,
		rownumbers : true,
		border : false,
		toolbar : '#indocinelist_tool',
        singleSelect:true,  
        fitColumns: false,       
		columns : [[
			{
				field : 'goods_id',
				title : '自动编号',
				width : 100,
				checkbox : true,
			},
			{
				field : 'goods_name',
				title : '货品名称',
				width : 100,
			},
			{
				field : 'goods_code',
				title : '货品编号',
				width : 150,
			},
			{
				field : 'goods_unit',
				title : '基本单位',
				width : 100,
			},
			{
				field : 'goods_status',
				title : '货品状态',
				width : 100,
			},
			{
				field : 'goods_nums',
				title : '货品数量',
				width : 100,
			},
			{
				field : 'goods_postil',
				title : '批注',
				width : 200,
			}									
		]]
	});

	$('#indocinelist_date').dialog({
		width : 400,
		title : '新增货品',
		modal : true,
		closed : true,
		iconCls : 'icon-add',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				if ($('#indocinelist_date').form('validate')) {
					var data = {
							goods_id : $('#edocin_goods_name').val(),
							goods_name : $('#edocin_goods_id').val(),
							goods_code :$('#edocin_goods_code').val(),
							goods_unit :$('#edocin_goods_unit').val(),
							goods_status :$('#edocin_goods_status_name').val(),
							goods_nums :$('#edocin_goods_nums').val(),							
							goods_postil :checkDouhao($('#edocin_goods_postil').val())
					};
					$('#indocinelist').datagrid('appendRow',data);
				}
			}
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#indocinelist_date').dialog('close').form('reset');
			},
		}],
	});

	$('#edocin_goods_name').combobox({    
		url : '<?php echo $url?>in/docin/get_all_goods',
	    valueField:'goods_id',    
	    textField:'goods_name',
	    required:true,
	    onSelect:function(rec){    
            $("#edocin_goods_id").val(rec.goods_name);
            $("#edocin_goods_code").val(rec.goods_code);
            $("#edocin_goods_unit").val(rec.goods_unit);
        }
	});

	$('#edocin_goods_nums').numberbox({
	    required:true,
	});
	$('#edocin_goods_status').combobox({    
		url : '<?php echo $url?>in/docin/get_all_status',
	    valueField:'status_id',    
	    textField:'status_name',
	    required:true,
	    onLoadSuccess: function () { 
            var val = $(this).combobox("getData");
            $(this).combobox("select", val[0]['status_id']);
        },
	    onSelect:function(rec){    
            $("#edocin_goods_status_name").val(rec.status_name);
        }    
	});	
	
	indocinelist_tool = {
			add : function () {
				$('#indocinelist_date').dialog('open');
			},
			cut : function () {
				var rows = $('#indocinelist').datagrid('getSelected');
				var indexnums=$('#indocinelist').datagrid('getRowIndex',rows);
				$('#indocinelist').datagrid('deleteRow',indexnums);
			}
	};
	
});
function sendedocin(){
	var rows = $('#indocinelist').datagrid('getRows');
	if(rows.length==0){
		$.messager.alert('提示','请添加入库明细后再提交！','info');
	}else{		
		var docin_date={
			docin_number:$("#edocin_number").val(),
			docin_send_number:$("#edocin_send_number").val()
		};
		var docinlist_date=[];
		$.each(rows,function(r,m){
			docinlist_date. push(m);
		});
		docin_date.docinlist_date=docinlist_date;
		$.ajax({
			url : '<?php echo $url?>in/docin/update_docin/'+<?=$id?>,
			type : 'post',
			data : docin_date,
			beforeSend : function () {
				$.messager.progress({
					text : '正在提交中...',
				});
			},
			success : function (data, response, docin) {
				$.messager.progress('close');
				 var data = eval('(' + data + ')');     
//						console.log(data);
				if (data.success) {
					$.messager.show({
						title : '提示',
						msg : data.message,
					});	
				} else {
					$.messager.alert('添加失败！', data.message, 'warning');					
				}
			}
		});
	}
}
function checkDouhao(val){ 
    var reg = new RegExp("[\uff0c]"); 
    var rs = ""; 
    for (var i = 0, l = val.length; i < val.length; i++) { 
        rs = rs + val.substr(i, 1).replace(reg, ','); 
    } 
    return $.trim(rs); 
}
</script>

<div id="indocinehead" class="easyui-panel" title="入库单头" border="false" style="background:#f4f4f4;width:100%;height:160px;padding:5px;">
   <form id="docine_edit" style="margin:0;padding:5px 0 0 25px;color:#333;">
        <p>入库单号：<input id="edocin_number" value="<?=$docinhead['docin_number']?>" type="text" class="textbox" style="width:200px;" ></p>
    	<p>送货单号：<input id="edocin_send_number" value="<?=$docinhead['docin_send_number']?>" type="text"  class="textbox" style="width:200px;"></p>
    	<p style="text-align:center;"><a id="sendedocin" href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="return sendedocin();">提交</a></p>
    </form>
</div>

<table id="indocinelist"></table>
<div id="indocinelist_tool" style="padding:5px;">
	<div style="margin-bottom:5px;">
    	<a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="indocinelist_tool.add()">添加</a>
		<a href="#" class="easyui-linkbutton" iconCls="icon-no" plain="true"  onclick="indocinelist_tool.cut();">移除</a>
	</div>
</div>

<form id="indocinelist_date" style="margin:0;padding:5px 0 0 25px;color:#333;">
    <p>货品名称：<input id="edocin_goods_name" style="width:200px;"></p>
    <input type="hidden" id="edocin_goods_id" class="textbox" style="width:200px;">
    <input type="hidden" id="edocin_goods_code" class="textbox" style="width:200px;">
	<p>货品单位：<input id="edocin_goods_unit" type="text" disabled="true"   class="textbox" style="width:200px;"></p>
	<p>货品状态：<input id="edocin_goods_status" style="width:200px;"></p>
	<input type="hidden" id="edocin_goods_status_name" class="textbox" style="width:200px;">
	<p>货品数量：<input id="edocin_goods_nums" type="text"   class="textbox" style="width:200px;"></p>
	<p>货品批注：<input placeholder="批注以英文逗号,分割 例如 : 红色,NT3500" id="edocin_goods_postil" type="text"   class="textbox" style="width:250px;"></p>
</form>

