<script>
$.extend($.fn.datagrid.methods, {
	editCell: function(jq,param){
		return jq.each(function(){
			var opts = $(this).datagrid('options');
			var fields = $(this).datagrid('getColumnFields',true).concat($(this).datagrid('getColumnFields'));
			for(var i=0; i<fields.length; i++){
				var col = $(this).datagrid('getColumnOption', fields[i]);
				col.editor1 = col.editor;
				if (fields[i] != param.field){
					col.editor = null;
				}
			}
			$(this).datagrid('beginEdit', param.index);
			for(var i=0; i<fields.length; i++){
				var col = $(this).datagrid('getColumnOption', fields[i]);
				col.editor = col.editor1;
			}
		});
	}
});

var editIndex_docpute = undefined;
function endEditing(){
	if (editIndex_docpute == undefined){return true}
	if ($('#indocputelist').datagrid('validateRow', editIndex_docpute)){
		$('#indocputelist').datagrid('endEdit', editIndex_docpute);
		editIndex_docpute = undefined;
		return true;
	} else {
		return false;
	}
}
function onClickCell(index, field){
	if (endEditing()){
		$('#indocputelist').datagrid('selectRow', index)
				.datagrid('editCell', {index:index,field:field});
		editIndex_docpute = index;
	}
}

$(function () {

	$('#indocputelist').datagrid({
		title: '上架单明细',
		url : '<?php echo $url?>in/docput/get_docputlist/'+<?=$id?>,		
		fitColumns : true,
		striped : true,
		onClickCell: onClickCell,    
		rownumbers : true,
		border : false,
		toolbar : '#indocputelist_tool',
        singleSelect:true,  
        fitColumns: false,       
		columns : [[
			{
				field : 'goods_id',
				title : '自动编号',
				width : 100,
				checkbox : true,
			},
			{
				field : 'goods_name',
				title : '货品名称',
				width : 200,
			},
			{
				field : 'goods_code',
				title : '货品编号',
				width : 150,
			},
			{
				field : 'goods_unit',
				title : '基本单位',
				width : 100,
			},
			{
				field : 'goods_status',
				title : '货品状态',
				width : 100,
			},
			{
				field : 'goods_nums',
				title : '货品数量',
				width : 100,
			},
			{
				field : 'goods_postil',
				title : '批注',
				width : 100,
			},
			{
				field : 'area_id',
				title : '库区',
				width : 100,
				editor:{
					type:'combobox',
					options:{
						valueField:'area_id',
						textField:'area_name',
						method:'post',
						url:'<?php echo $url?>in/docput/get_all_area',	
						required:true
					}
				},
				formatter: function(value,row,index){
			        <?php foreach ($area as $key=>$value): ?>               
					if (row.area_id==<?= $value->area_id?>){
						return '<?=$value->area_name?>';
					} 		        
		        <?php endforeach; ?>         						
				}					
			},
			{
				field : 'position_id',
				title : '储位',
				width : 150,
				editor:{
					type:'combobox',
					options:{
						valueField:'position_id',
						textField:'position_name',
						method:'post',
						url:'<?php echo $url?>in/docput/get_all_position',	
						required:true
					}
				},
				formatter: function(value,row,index){
			        <?php foreach ($position as $key=>$value): ?>               
					if (row.position_id==<?= $value->position_id?>){
						return '<?=$value->position_name?>';
					} 		        
		        <?php endforeach; ?>         						
				}			
			}									
		]]
	});

	$('#indocputelist_date').dialog({
		width : 400,
		title : '新增货品',
		modal : true,
		closed : true,
		iconCls : 'icon-add',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				if ($('#indocputelist_date').form('validate')) {
					var data = {
							goods_id : $('#edocput_goods_name').val(),
							goods_name : $('#edocput_goods_id').val(),
							goods_code :$('#edocput_goods_code').val(),
							goods_unit :$('#edocput_goods_unit').val(),
							goods_status :$('#edocput_goods_status_name').val(),
							goods_nums :$('#edocput_goods_nums').val(),							
							goods_postil :checkDouhao($('#edocput_goods_postil').val())
					};
					$('#indocputelist').datagrid('appendRow',data);
				}
			}
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#indocputelist_date').dialog('close').form('reset');
			},
		}],
	});

	$('#edocput_number').validatebox({
		required : true,
		missingMessage : '上架单号可以自定义填写',
	});

	$('#edocput_goods_name').combobox({    
		url : '<?php echo $url?>in/docput/get_all_goods',
	    valueField:'goods_id',    
	    textField:'goods_name',
	    required:true,
	    onSelect:function(rec){    
            $("#edocput_goods_id").val(rec.goods_name);
            $("#edocput_goods_code").val(rec.goods_code);
            $("#edocput_goods_unit").val(rec.goods_unit);
        }
	});

	$('#edocput_goods_nums').numberbox({
	    required:true,
	});
	$('#edocput_goods_status').combobox({    
		url : '<?php echo $url?>in/docput/get_all_status',
	    valueField:'status_id',    
	    textField:'status_name',
	    required:true,
	    onLoadSuccess: function () { 
            var val = $(this).combobox("getData");
            $(this).combobox("select", val[0]['status_id']);
        },
	    onSelect:function(rec){    
            $("#edocput_goods_status_name").val(rec.status_name);
        }    
	});	
	
	indocputelist_tool = {
			add : function () {
				$('#indocputelist_date').dialog('open');
			},
			cut : function () {
				var rows = $('#indocputelist').datagrid('getSelected');
				var indexnums=$('#indocputelist').datagrid('getRowIndex',rows);
				$('#indocputelist').datagrid('deleteRow',indexnums);
			}
	};
	
});
function sendedocput(){
	var rows = $('#indocputelist').datagrid('getRows');
	if(rows.length==0){
		$.messager.alert('提示','请添加上架明细后再提交！','info');return false;
	}

	var docput_date={
		docput_number:$("#edocput_number").val(),
// 		docin_number:$("#edocput_docin_number").val(),
// 		docin_send_number:$("#edocput_docin_send_number").val()
	};
	var docputlist_date=[];
	var fff=false;
	$.each(rows,function(r,m){
		if(m.area_id=="" ||m.position_id==""||m.area_id==null || m.position_id==null){
			fff=true;
		}
		docputlist_date. push(m);
	});
	if(fff){
		$.messager.alert('提示','请正确填写完整库区储位信息后再提交！','info');return false;
	}		
	docput_date.docputlist_date=docputlist_date;
// 	console.log(docput_date);
	$.ajax({
		url : '<?php echo $url?>in/docput/update_docput/'+<?=$id?>,
			type : 'post',
			data : docput_date,
			beforeSend : function () {
				$.messager.progress({
					text : '正在提交中...',
				});
			},
			success : function (data, response, docput) {
				$.messager.progress('close');
				 var data = eval('(' + data + ')');     
//						console.log(data);
				if (data.success) {
					$.messager.show({
						title : '提示',
						msg : data.message,
					});	
				} else {
					$.messager.alert('添加失败！', data.message, 'warning');					
				}
			}
		});

}
function checkDouhao(val){ 
    var reg = new RegExp("[\uff0c]"); 
    var rs = ""; 
    for (var i = 0, l = val.length; i < val.length; i++) { 
        rs = rs + val.substr(i, 1).replace(reg, ','); 
    } 
    return $.trim(rs); 
}

</script>

<div id="indocputehead" class="easyui-panel" title="上架单头" border="false" style="background:#f4f4f4;width:100%;height:210px;padding:5px;">
   <form id="docpute_edit" style="margin:0;padding:5px 0 0 25px;color:#333;">
        <p>上架单号：<input id="edocput_number" value="<?=$docputhead['docput_number']?>" type="text" class="textbox" style="width:200px;" ></p>
        <p>入库单号：<input id="edocput_docin_number" disabled="true"  value="<?=$docputhead['docin_number']?>" type="text" class="textbox" style="width:200px;" ></p>
    	<p>送货单号：<input id="edocput_docin_send_number" disabled="true"  value="<?=$docputhead['docin_send_number']?>" type="text"  class="textbox" style="width:200px;"></p>
    	<p style="text-align:center;"><a id="sendedocput" href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="return sendedocput();">提交</a></p>
    </form>
</div>

<table id="indocputelist"></table>
<div id="indocputelist_tool" style="padding:5px;">
	<div style="margin-bottom:5px;">
    	<a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="indocputelist_tool.add()">添加</a>
		<a href="#" class="easyui-linkbutton" iconCls="icon-no" plain="true"  onclick="indocputelist_tool.cut();">移除</a>
	</div>
</div>

<form id="indocputelist_date" style="margin:0;padding:5px 0 0 25px;color:#333;">
    <p>货品名称：<input id="edocput_goods_name" style="width:200px;"></p>
    <input type="hidden" id="edocput_goods_id" class="textbox" style="width:200px;">
    <input type="hidden" id="edocput_goods_code" class="textbox" style="width:200px;">
	<p>货品单位：<input id="edocput_goods_unit" type="text" disabled="true"   class="textbox" style="width:200px;"></p>
	<p>货品状态：<input id="edocput_goods_status" style="width:200px;"></p>
	<input type="hidden" id="edocput_goods_status_name" class="textbox" style="width:200px;">
	<p>货品数量：<input id="edocput_goods_nums" type="text"   class="textbox" style="width:200px;"></p>
	<p>货品批注：<input placeholder="批注以英文逗号,分割 例如 : 红色,NT3500" id="edocput_goods_postil" type="text"   class="textbox" style="width:250px;"></p>
</form>

