<script>

$(function () {
	
	$('#kpiinventory').datagrid({
		url : '<?php echo $url?>kpi/inventory/get_inventory',
		fit : true,
		fitColumns : true,
		striped : true,
		rownumbers : true,
		border : false,
		pagination : true,
	    pageSize:10,
	    pageList: [10, 20, 30,50], 
		toolbar : '#inventory_tool',
        singleSelect:true,
		columns : [[
			{
				field : 'inventory_id',
				title : '自动编号',
				width : 300,
				checkbox : true,
			},
			{
				field : 'goods_name',
				title : '货品名称',
			},
			{
				field : 'goods_code',
				title : '货品编号',
				width : 300,
			},
			{
				field : 'goods_status',
				title : '状态',
				width : 150,
				formatter: function(value,row,index){
			        <?php foreach ($status as $key=>$value): ?>               
					if (row.goods_status==<?= $value->id?>){
						return '<?=$value->text?>';
					} 		        
		        <?php endforeach; ?>         						
				}					
			},
			{
				field : 'goods_unit',
				title : '单位',
				width : 150,
			},			
			{
				field : 'goods_nums',
				title : '数量',
				width : 200,
			},
			{
				field : 'goods_postil',
				title : '批注',
				width :400,
			},			
			{
				field : 'area_id',
				title : '库区',
				width : 300,
				formatter: function(value,row,index){
			        <?php foreach ($area as $key=>$value): ?>               
					if (row.area_id==<?= $value->area_id?>){
						return '<?=$value->area_name?>';
					} 		        
		        <?php endforeach; ?>         						
				}					
			},
			{
				field : 'position_id',
				title : '储位',
				width : 300,
				formatter: function(value,row,index){
			        <?php foreach ($position as $key=>$value): ?>               
					if (row.position_id==<?= $value->position_id?>){
						return '<?=$value->position_name?>';
					} 		        
		        <?php endforeach; ?>         						
				}						
			},			
			{
				field : 'docput_number',
				title : '上架单号',
				width : 300,
			},
			{
				field : 'docin_number',
				title : '入库单号',
				width : 300,
			},			
			{
				field : 'docin_send_number',
				title : '送货单号',
				width : 400,
			},
			{
				field : 'inventory_datetime',
				title : '时间',
				width : 600,					
			}										
		]]
	});



	inventory_tool = {
		reload : function () {
			$('#kpiinventory').datagrid('reload');
		},
		remove : function () {
			$('#kpiinventory').datagrid('unselectAll');
		},
		<?php foreach ($button as $item): ?>
		<?php if($item->button_way=='print'){ ?>			
		print : function () {
			var rows = $('#kpiinventory').datagrid('getSelections');
			if (rows.length > 1) {
				$.messager.alert('警告操作！', '打印记录只能选定一条数据！', 'warning');
			} else if (rows.length == 1) {
				window.open("kpi/inventory/inventory_print/"+rows[0].inventory_id);      
			} else if (rows.length == 0) {
				$.messager.alert('警告操作！', '打印记录至少选定一条数据！', 'warning');
			}
		},
		<?php }?>												
	    <?php endforeach; ?>		
	};
	
});
function inventorySearch(){
	$('#kpiinventory').datagrid('load',{
		goods_name: $.trim($('input[name="inventory_goods_name"]').val()),
		goods_code: $.trim($('input[name="inventory_goods_code"]').val()),		
		goods_postil: $.trim($('input[name="inventory_goods_postil"]').val()),
		docput_number: $.trim($('input[name="inventory_docput_number"]').val()),
		docin_number: $.trim($('input[name="inventory_docin_number"]').val()),
		docin_send_number: $.trim($('input[name="inventory_docin_send_number"]').val()),
		inventory_date_from: $('input[name="inventory_date_from"]').val(),
		inventory_date_to: $('input[name="inventory_date_to"]').val()
	});
}
</script>
<table id="kpiinventory"></table>

<div id="inventory_tool" style="padding:5px;">
	<div style="margin-bottom:5px;">
	<?php foreach ($button as $item): ?>
    	<a href="#" class="easyui-linkbutton" iconCls="icon-<?=$item->button_icon?>" plain="true" onclick="inventory_tool.<?=$item->button_way ?>()"><?php echo $item->button_name?></a>
    <?php endforeach; ?>
		<a href="#" class="easyui-linkbutton" iconCls="icon-reload" plain="true"  onclick="inventory_tool.reload();">刷新</a>
		<a href="#" class="easyui-linkbutton" iconCls="icon-remove" plain="true" onclick="inventory_tool.remove();">取消选择</a>		
	</div>
	<div style="padding:0 0 0 7px;color:#333;">
    	<p>
    	   货品名称：<input type="text" class="textbox" name="inventory_goods_name" style="width:110px">
    	   货品编号：<input type="text" class="textbox" name="inventory_goods_code" style="width:110px">
    	   批注：<input type="text" class="textbox" name="inventory_goods_postil" style="width:110px">
    	</p>   
	   上架单号：<input type="text" class="textbox" name="inventory_docput_number" style="width:110px">
		入库单号：<input type="text" class="textbox" name="inventory_docin_number" style="width:110px">
		送货单号：<input type="text" class="textbox" name="inventory_docin_send_number" style="width:110px">
		　创建时间从：<input type="text" name="inventory_date_from" class="easyui-datebox" editable="false" style="width:110px">
		到：<input type="text" name="inventory_date_to" class="easyui-datebox" editable="false" style="width:110px">
		<a href="#" class="easyui-linkbutton" iconCls="icon-search" onclick="inventorySearch();">查询</a>
	</div>	
</div>

