<script>

$(function () {
	
	$('#managearea').datagrid({
		url : '<?php echo $url?>manage/area/get_area',
		fit : true,
		fitColumns : true,
		striped : true,
		rownumbers : true,
		border : false,
		toolbar : '#area_tool',
        singleSelect:true,
		columns : [[
			{
				field : 'area_id',
				title : '自动编号',
				width : 100,
				checkbox : true,
			},
			{
				field : 'area_name',
				title : '库区名',
				width : 100,
			}						
		]]
	});


	<?php foreach ($button as $item): ?>
	<?php if($item->button_way=='add'){ ?>				
	$('#managearea_add').dialog({
		width : 350,
		title : '新增库区',
		modal : true,
		closed : true,
		iconCls : 'icon-add',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				if ($('#managearea_add').form('validate')) {
					$.ajax({
						url : '<?php echo $url?>manage/area/add_area',
						type : 'post',
						data : {
							area_name : $('#aarea_name').val(),
							area_role :$('#aarea_role').val(),
						},
						beforeSend : function () {
							$.messager.progress({
								text : '正在新增中...',
							});
						},
						success : function (data, response, area) {
							$.messager.progress('close');
							 var data = eval('(' + data + ')');     
							if (data.success) {
								$.messager.show({
									title : '提示',
									msg : '新增库区成功',
								});
								$('#managearea_add').dialog('close').form('reset');
								$('#managearea').datagrid('reload');
							} else {
								$.messager.alert('新增失败！', '库区名重复或者未知错误导致失败，请重试！', 'warning');
							}
						}
					});
				}
			},
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#managearea_add').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
	<?php if($item->button_way=='edit'){ ?>				
	
	$('#managearea_edit').dialog({
		width : 350,
		title : '库区修改',
		modal : true,
		closed : true,
		iconCls : 'icon-edit',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				$.ajax({
					url : '<?php echo $url?>manage/area/update_area',
					type : 'post',
					data : {
						area_id : $('#managearea_edit > input[name="area_id"]').val(),
						area_name : $('#earea_name').val()
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在修改中...',
						});
					},
					success : function (data, response, area) {
						$.messager.progress('close');
						 var data = eval('(' + data + ')');     
// 							console.log(data);
						if (data.success) {
							$.messager.show({
								title : '提示',
								msg : '修改库区成功',
							});
							$('#managearea_edit').dialog('close').form('reset');
							$('#managearea').datagrid('reload');
						} else {
							$.messager.alert('修改失败！', '未知错误或没有任何修改，请重试！', 'warning');
						}
					}
				});
			}
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#managearea_edit').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
    <?php endforeach; ?>		
	
	//管理帐号
	$('input[name="area_name"]').validatebox({
		required : true,
		validType : 'length[2,20]',
		missingMessage : '请输入库区名',
		invalidMessage : '库区名在 2-20 位',
	});

	area_tool = {
		reload : function () {
			$('#managearea').datagrid('reload');
		},
		remove : function () {
			$('#managearea').datagrid('unselectAll');
		},
		<?php foreach ($button as $item): ?>
		<?php if($item->button_way=='add'){ ?>					
		add : function () {
			$('#managearea_add').dialog('open');
		},
		<?php }?>
		<?php if($item->button_way=='edit'){ ?>			
		edit : function () {
			var rows = $('#managearea').datagrid('getSelections');
			if (rows.length > 1) {
				$.messager.alert('警告操作！', '编辑记录只能选定一条数据！', 'warning');
			} else if (rows.length == 1) {
				$.ajax({
					url : '<?php echo $url?>manage/area/get_one_area',
					type : 'post',
					data : {
						id : rows[0].area_id
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在获取中...',
						});
					},
					success : function (data, response, area) {
						$.messager.progress('close');				
// 						console.log(data);		
						if (data) {
							var obj = $.parseJSON(data);
							$('#managearea_edit').form('load', {
								area_id : obj[0].area_id,
								area_name : obj[0].area_name,
							}).dialog('open');
				
						} else {
							$.messager.alert('获取失败！', '未知错误导致失败，请重试！', 'warning');
						}
					}
				});
			} else if (rows.length == 0) {
				$.messager.alert('警告操作！', '编辑记录至少选定一条数据！', 'warning');
			}
		},
		<?php }?>
	    <?php endforeach; ?>		
	};
	
});
</script>
<table id="managearea"></table>

<div id="area_tool" style="padding:5px;">
	<div style="margin-bottom:5px;">
	<?php foreach ($button as $item): ?>
    	<a href="#" class="easyui-linkbutton" iconCls="icon-<?=$item->button_icon?>" plain="true" onclick="area_tool.<?=$item->button_way ?>()"><?php echo $item->button_name?></a>
    <?php endforeach; ?>
		<a href="#" class="easyui-linkbutton" iconCls="icon-reload" plain="true"  onclick="area_tool.reload();">刷新</a>
		<a href="#" class="easyui-linkbutton" iconCls="icon-remove" plain="true" onclick="area_tool.remove();">取消选择</a>		
	</div>
</div>


<form id="managearea_add" style="margin:0;padding:5px 0 0 25px;color:#333;">
	<p>库区名：<input id="aarea_name" type="text" name="area_name" class="textbox" style="width:200px;"></p>
</form>


<form id="managearea_edit" style="margin:0;padding:5px 0 0 25px;color:#333;">
	<input type="hidden" name="area_id" class="textbox" style="width:200px;">
	<p>库区名：<input id="earea_name" type="text" name="area_name"  class="textbox" style="width:200px;"></p>
</form>

