<script>

$(function () {
	
	$('#manageposition').datagrid({
		url : '<?php echo $url?>manage/position/get_position',
		fit : true,
		fitColumns : true,
		striped : true,
		rownumbers : true,
		border : false,
		toolbar : '#position_tool',
        singleSelect:true,
		columns : [[
			{
				field : 'position_id',
				title : '自动编号',
				width : 100,
				checkbox : true,
			},
			{
				field : 'position_name',
				title : '储位名',
				width : 100,
			},
			{
				field : 'area_id',
				title : '库区名',
				width : 100,
				formatter: function(value,row,index){
			        <?php foreach ($area as $key=>$value): ?>               
			        
					if (row.area_id==<?= $value->area_id?>){
						return '<?=$value->area_name ?>';
					} 
			        
		        <?php endforeach; ?>         			
				}					
			}									
		]]
	});


	<?php foreach ($button as $item): ?>
	<?php if($item->button_way=='add'){ ?>				
	$('#manageposition_add').dialog({
		width : 350,
		title : '新增储位',
		modal : true,
		closed : true,
		iconCls : 'icon-add',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				if ($('#manageposition_add').form('validate')) {
					$.ajax({
						url : '<?php echo $url?>manage/position/add_position',
						type : 'post',
						data : {
							position_name : $('#aposition_name').val(),
							area_id :$('#aposition_area_id').val(),
						},
						beforeSend : function () {
							$.messager.progress({
								text : '正在新增中...',
							});
						},
						success : function (data, response, position) {
							$.messager.progress('close');
							 var data = eval('(' + data + ')');     
							if (data.success) {
								$.messager.show({
									title : '提示',
									msg : '新增储位成功',
								});
								$('#manageposition_add').dialog('close').form('reset');
								$('#manageposition').datagrid('reload');
							} else {
								$.messager.alert('新增失败！', '储位名重复或者未知错误导致失败，请重试！', 'warning');
							}
						}
					});
				}
			},
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#manageposition_add').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
	<?php if($item->button_way=='edit'){ ?>				
	
	$('#manageposition_edit').dialog({
		width : 350,
		title : '储位修改',
		modal : true,
		closed : true,
		iconCls : 'icon-edit',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				$.ajax({
					url : '<?php echo $url?>manage/position/update_position',
					type : 'post',
					data : {
						position_id : $('#manageposition_edit > input[name="position_id"]').val(),
						position_name : $('#eposition_name').val(),
						area_id : $('#eposition_area_id').val()
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在修改中...',
						});
					},
					success : function (data, response, position) {
						$.messager.progress('close');
						 var data = eval('(' + data + ')');     
// 							console.log(data);
						if (data.success) {
							$.messager.show({
								title : '提示',
								msg : '修改储位成功',
							});
							$('#manageposition_edit').dialog('close').form('reset');
							$('#manageposition').datagrid('reload');
						} else {
							$.messager.alert('修改失败！', '未知错误或没有任何修改，请重试！', 'warning');
						}
					}
				});
			}
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#manageposition_edit').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
    <?php endforeach; ?>		
	
	//管理帐号
	$('input[name="position_name"]').validatebox({
		required : true,
		validType : 'length[2,30]',
		missingMessage : '请输入储位名',
		invalidMessage : '储位名在 2-30 位',
	});

	position_tool = {
		reload : function () {
			$('#manageposition').datagrid('reload');
		},
		remove : function () {
			$('#manageposition').datagrid('unselectAll');
		},
		<?php foreach ($button as $item): ?>
		<?php if($item->button_way=='add'){ ?>					
		add : function () {
			$('#manageposition_add').dialog('open');
			$('#aposition_area_id').combotree({    
			    url: '<?php echo $url?>manage/position/get_area_tree',
			    required: true,
			}); 
		},
		<?php }?>
		<?php if($item->button_way=='edit'){ ?>			
		edit : function () {
			var rows = $('#manageposition').datagrid('getSelections');
			if (rows.length > 1) {
				$.messager.alert('警告操作！', '编辑记录只能选定一条数据！', 'warning');
			} else if (rows.length == 1) {
				$.ajax({
					url : '<?php echo $url?>manage/position/get_one_position',
					type : 'post',
					data : {
						id : rows[0].position_id
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在获取中...',
						});
					},
					success : function (data, response, position) {
						$.messager.progress('close');				
// 						console.log(data);		
						if (data) {
							var obj = $.parseJSON(data);
							$('#manageposition_edit').form('load', {
								position_id : obj[0].position_id,
								position_name : obj[0].position_name,
								area_id : obj[0].area_id,
							}).dialog('open');
							$('#eposition_area_id').combotree({    
							    url: '<?php echo $url?>manage/position/get_area_tree',
							    required: true,
								onLoadSuccess : function (node, data) {
// 						    			var _this = this;
						    			if (data) {
						    				$(data).each(function (index, value) {
												if (value.id==obj[0].area_id) {
// 													$(_this).tree('check', value.target);
													$('#eposition_area_id').combotree('setValue',value.id);
												}
						    				});
						    			}
						    	}	    
							});  	
							
						} else {
							$.messager.alert('获取失败！', '未知错误导致失败，请重试！', 'warning');
						}
					}
				});
			} else if (rows.length == 0) {
				$.messager.alert('警告操作！', '编辑记录至少选定一条数据！', 'warning');
			}
		},
		<?php }?>
	    <?php endforeach; ?>		
	};
	
});
</script>
<table id="manageposition"></table>

<div id="position_tool" style="padding:5px;">
	<div style="margin-bottom:5px;">
	<?php foreach ($button as $item): ?>
    	<a href="#" class="easyui-linkbutton" iconCls="icon-<?=$item->button_icon?>" plain="true" onclick="position_tool.<?=$item->button_way ?>()"><?php echo $item->button_name?></a>
    <?php endforeach; ?>
		<a href="#" class="easyui-linkbutton" iconCls="icon-reload" plain="true"  onclick="position_tool.reload();">刷新</a>
		<a href="#" class="easyui-linkbutton" iconCls="icon-remove" plain="true" onclick="position_tool.remove();">取消选择</a>		
	</div>
</div>


<form id="manageposition_add" style="margin:0;padding:5px 0 0 25px;color:#333;">
	<p>储位名：<input id="aposition_name" type="text" name="position_name" class="textbox" style="width:200px;"></p>
	<p>库区名：<input id="aposition_area_id" style="width:200px;" ></p>
</form>


<form id="manageposition_edit" style="margin:0;padding:5px 0 0 25px;color:#333;">
	<input type="hidden" name="position_id" class="textbox" style="width:200px;">
	<p>储位名：<input id="eposition_name" type="text" name="position_name"  class="textbox" style="width:200px;"></p>
	<p>库区名：<input id="eposition_area_id" style="width:200px;" name="area_id"></p>
</form>

