<script>

$(function () {
	
	$('#managestatus').datagrid({
		url : '<?php echo $url?>manage/status/get_status',
		fit : true,
		fitColumns : true,
		striped : true,
		rownumbers : true,
		border : false,
		toolbar : '#status_tool',
        singleSelect:true,
		columns : [[
			{
				field : 'status_id',
				title : '自动编号',
				width : 100,
				checkbox : true,
			},
			{
				field : 'status_name',
				title : '状态名',
				width : 100,
			}						
		]]
	});


	<?php foreach ($button as $item): ?>
	<?php if($item->button_way=='add'){ ?>				
	$('#managestatus_add').dialog({
		width : 350,
		title : '新增状态',
		modal : true,
		closed : true,
		iconCls : 'icon-add',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				if ($('#managestatus_add').form('validate')) {
					$.ajax({
						url : '<?php echo $url?>manage/status/add_status',
						type : 'post',
						data : {
							status_name : $('#astatus_name').val(),
							status_role :$('#astatus_role').val(),
						},
						beforeSend : function () {
							$.messager.progress({
								text : '正在新增中...',
							});
						},
						success : function (data, response, status) {
							$.messager.progress('close');
							 var data = eval('(' + data + ')');     
							if (data.success) {
								$.messager.show({
									title : '提示',
									msg : '新增状态成功',
								});
								$('#managestatus_add').dialog('close').form('reset');
								$('#managestatus').datagrid('reload');
							} else {
								$.messager.alert('新增失败！', '状态名重复或者未知错误导致失败，请重试！', 'warning');
							}
						}
					});
				}
			},
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#managestatus_add').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
	<?php if($item->button_way=='edit'){ ?>				
	
	$('#managestatus_edit').dialog({
		width : 350,
		title : '状态修改',
		modal : true,
		closed : true,
		iconCls : 'icon-edit',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				$.ajax({
					url : '<?php echo $url?>manage/status/update_status',
					type : 'post',
					data : {
						status_id : $('#managestatus_edit > input[name="status_id"]').val(),
						status_name : $('#estatus_name').val()
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在修改中...',
						});
					},
					success : function (data, response, status) {
						$.messager.progress('close');
						 var data = eval('(' + data + ')');     
// 							console.log(data);
						if (data.success) {
							$.messager.show({
								title : '提示',
								msg : '修改状态成功',
							});
							$('#managestatus_edit').dialog('close').form('reset');
							$('#managestatus').datagrid('reload');
						} else {
							$.messager.alert('修改失败！', '未知错误或没有任何修改，请重试！', 'warning');
						}
					}
				});
			}
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#managestatus_edit').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
    <?php endforeach; ?>		
	
	//管理帐号
	$('input[name="status_name"]').validatebox({
		required : true,
		validType : 'length[2,20]',
		missingMessage : '请输入状态名',
		invalidMessage : '状态名在 2-20 位',
	});

	status_tool = {
		reload : function () {
			$('#managestatus').datagrid('reload');
		},
		remove : function () {
			$('#managestatus').datagrid('unselectAll');
		},
		<?php foreach ($button as $item): ?>
		<?php if($item->button_way=='add'){ ?>					
		add : function () {
			$('#managestatus_add').dialog('open');
		},
		<?php }?>
		<?php if($item->button_way=='edit'){ ?>			
		edit : function () {
			var rows = $('#managestatus').datagrid('getSelections');
			if (rows.length > 1) {
				$.messager.alert('警告操作！', '编辑记录只能选定一条数据！', 'warning');
			} else if (rows.length == 1) {
				$.ajax({
					url : '<?php echo $url?>manage/status/get_one_status',
					type : 'post',
					data : {
						id : rows[0].status_id
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在获取中...',
						});
					},
					success : function (data, response, status) {
						$.messager.progress('close');				
// 						console.log(data);		
						if (data) {
							var obj = $.parseJSON(data);
							$('#managestatus_edit').form('load', {
								status_id : obj[0].status_id,
								status_name : obj[0].status_name,
							}).dialog('open');
				
						} else {
							$.messager.alert('获取失败！', '未知错误导致失败，请重试！', 'warning');
						}
					}
				});
			} else if (rows.length == 0) {
				$.messager.alert('警告操作！', '编辑记录至少选定一条数据！', 'warning');
			}
		},
		<?php }?>
	    <?php endforeach; ?>		
	};
	
});
</script>
<table id="managestatus"></table>

<div id="status_tool" style="padding:5px;">
	<div style="margin-bottom:5px;">
	<?php foreach ($button as $item): ?>
    	<a href="#" class="easyui-linkbutton" iconCls="icon-<?=$item->button_icon?>" plain="true" onclick="status_tool.<?=$item->button_way ?>()"><?php echo $item->button_name?></a>
    <?php endforeach; ?>
		<a href="#" class="easyui-linkbutton" iconCls="icon-reload" plain="true"  onclick="status_tool.reload();">刷新</a>
		<a href="#" class="easyui-linkbutton" iconCls="icon-remove" plain="true" onclick="status_tool.remove();">取消选择</a>		
	</div>
</div>


<form id="managestatus_add" style="margin:0;padding:5px 0 0 25px;color:#333;">
	<p>状态名：<input id="astatus_name" type="text" name="status_name" class="textbox" style="width:200px;"></p>
</form>


<form id="managestatus_edit" style="margin:0;padding:5px 0 0 25px;color:#333;">
	<input type="hidden" name="status_id" class="textbox" style="width:200px;">
	<p>状态名：<input id="estatus_name" type="text" name="status_name"  class="textbox" style="width:200px;"></p>
</form>

