<script>

$(function () {
	
	$('#managetype').datagrid({
		url : '<?php echo $url?>manage/type/get_type',
		fit : true,
		fitColumns : true,
		striped : true,
		rownumbers : true,
		border : false,
		toolbar : '#type_tool',
        singleSelect:true,
		columns : [[
			{
				field : 'type_id',
				title : '自动编号',
				width : 100,
				checkbox : true,
			},
			{
				field : 'type_name',
				title : '类型名',
				width : 100,
			}						
		]]
	});


	<?php foreach ($button as $item): ?>
	<?php if($item->button_way=='add'){ ?>				
	$('#managetype_add').dialog({
		width : 350,
		title : '新增类型',
		modal : true,
		closed : true,
		iconCls : 'icon-add',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				if ($('#managetype_add').form('validate')) {
					$.ajax({
						url : '<?php echo $url?>manage/type/add_type',
						type : 'post',
						data : {
							type_name : $('#atype_name').val(),
							type_role :$('#atype_role').val(),
						},
						beforeSend : function () {
							$.messager.progress({
								text : '正在新增中...',
							});
						},
						success : function (data, response, type) {
							$.messager.progress('close');
							 var data = eval('(' + data + ')');     
							if (data.success) {
								$.messager.show({
									title : '提示',
									msg : '新增类型成功',
								});
								$('#managetype_add').dialog('close').form('reset');
								$('#managetype').datagrid('reload');
							} else {
								$.messager.alert('新增失败！', '类型名重复或者未知错误导致失败，请重试！', 'warning');
							}
						}
					});
				}
			},
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#managetype_add').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
	<?php if($item->button_way=='edit'){ ?>				
	
	$('#managetype_edit').dialog({
		width : 350,
		title : '类型修改',
		modal : true,
		closed : true,
		iconCls : 'icon-edit',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				$.ajax({
					url : '<?php echo $url?>manage/type/update_type',
					type : 'post',
					data : {
						type_id : $('#managetype_edit > input[name="type_id"]').val(),
						type_name : $('#etype_name').val()
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在修改中...',
						});
					},
					success : function (data, response, type) {
						$.messager.progress('close');
						 var data = eval('(' + data + ')');     
// 							console.log(data);
						if (data.success) {
							$.messager.show({
								title : '提示',
								msg : '修改类型成功',
							});
							$('#managetype_edit').dialog('close').form('reset');
							$('#managetype').datagrid('reload');
						} else {
							$.messager.alert('修改失败！', '未知错误或没有任何修改，请重试！', 'warning');
						}
					}
				});
			}
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#managetype_edit').dialog('close').form('reset');
			},
		}],
	});

	<?php }?>
    <?php endforeach; ?>		
	
	//管理帐号
	$('input[name="type_name"]').validatebox({
		required : true,
		validType : 'length[2,20]',
		missingMessage : '请输入类型名',
		invalidMessage : '类型名在 2-20 位',
	});

	type_tool = {
		reload : function () {
			$('#managetype').datagrid('reload');
		},
		remove : function () {
			$('#managetype').datagrid('unselectAll');
		},
		<?php foreach ($button as $item): ?>
		<?php if($item->button_way=='add'){ ?>					
		add : function () {
			$('#managetype_add').dialog('open');
		},
		<?php }?>
		<?php if($item->button_way=='edit'){ ?>			
		edit : function () {
			var rows = $('#managetype').datagrid('getSelections');
			if (rows.length > 1) {
				$.messager.alert('警告操作！', '编辑记录只能选定一条数据！', 'warning');
			} else if (rows.length == 1) {
				$.ajax({
					url : '<?php echo $url?>manage/type/get_one_type',
					type : 'post',
					data : {
						id : rows[0].type_id
					},
					beforeSend : function () {
						$.messager.progress({
							text : '正在获取中...',
						});
					},
					success : function (data, response, type) {
						$.messager.progress('close');				
// 						console.log(data);		
						if (data) {
							var obj = $.parseJSON(data);
							$('#managetype_edit').form('load', {
								type_id : obj[0].type_id,
								type_name : obj[0].type_name,
							}).dialog('open');
				
						} else {
							$.messager.alert('获取失败！', '未知错误导致失败，请重试！', 'warning');
						}
					}
				});
			} else if (rows.length == 0) {
				$.messager.alert('警告操作！', '编辑记录至少选定一条数据！', 'warning');
			}
		},
		<?php }?>
	    <?php endforeach; ?>		
	};
	
});
</script>
<table id="managetype"></table>

<div id="type_tool" style="padding:5px;">
	<div style="margin-bottom:5px;">
	<?php foreach ($button as $item): ?>
    	<a href="#" class="easyui-linkbutton" iconCls="icon-<?=$item->button_icon?>" plain="true" onclick="type_tool.<?=$item->button_way ?>()"><?php echo $item->button_name?></a>
    <?php endforeach; ?>
		<a href="#" class="easyui-linkbutton" iconCls="icon-reload" plain="true"  onclick="type_tool.reload();">刷新</a>
		<a href="#" class="easyui-linkbutton" iconCls="icon-remove" plain="true" onclick="type_tool.remove();">取消选择</a>		
	</div>
</div>


<form id="managetype_add" style="margin:0;padding:5px 0 0 25px;color:#333;">
	<p>类型名：<input id="atype_name" type="text" name="type_name" class="textbox" style="width:200px;"></p>
</form>


<form id="managetype_edit" style="margin:0;padding:5px 0 0 25px;color:#333;">
	<input type="hidden" name="type_id" class="textbox" style="width:200px;">
	<p>类型名：<input id="etype_name" type="text" name="type_name"  class="textbox" style="width:200px;"></p>
</form>

