<script>
$(function () {

	$('#outdocoutalist').datagrid({
		title: '出库单明细',
		fitColumns : true,
		striped : true,
		rownumbers : true,
		border : false,
		toolbar : '#outdocoutalist_tool',
        singleSelect:true,  
        fitColumns: false,       
		columns : [[
			{
				field : 'goods_id',
				title : '自动编号',
				width : 100,
				checkbox : true,
			},
			{
				field : 'goods_name',
				title : '货品名称',
				width : 100,
			},
			{
				field : 'goods_code',
				title : '货品编号',
				width : 150,
			},
			{
				field : 'goods_unit',
				title : '基本单位',
				width : 100,
			},
			{
				field : 'goods_status',
				title : '货品状态',
				width : 100,
			},
			{
				field : 'goods_nums',
				title : '货品数量',
				width : 100,
			},
			{
				field : 'goods_postil',
				title : '批注',
				width : 200,
			}									
		]]
	});

	$('#outdocoutalist_date').dialog({
		width : 400,
		title : '新增货品',
		modal : true,
		closed : true,
		iconCls : 'icon-add',
		buttons : [{
			text : '提交',
			iconCls : 'icon-ok',
			handler : function () {
				if ($('#outdocoutalist_date').form('validate')) {
					var data = {
							goods_id : $('#adocout_goods_name').val(),
							goods_name : $('#adocout_goods_id').val(),
							goods_code :$('#adocout_goods_code').val(),
							goods_unit :$('#adocout_goods_unit').val(),
							goods_status :$('#adocout_goods_status_name').val(),
							goods_nums :$('#adocout_goods_nums').val(),							
							goods_postil :checkDouhao($('#adocout_goods_postil').val())
					};
					$('#outdocoutalist').datagrid('appendRow',data);
				}
			}
		},{
			text : '取消',
			iconCls : 'icon-redo',
			handler : function () {
				$('#outdocoutalist_date').dialog('close').form('reset');
			},
		}],
	});

	$('#adocout_goods_name').combobox({    
		url : '<?php echo $url?>out/docout/get_all_goods',
	    valueField:'goods_id',    
	    textField:'goods_name',
	    required:true,
	    onSelect:function(rec){    
            $("#adocout_goods_id").val(rec.goods_name);
            $("#adocout_goods_code").val(rec.goods_code);
            $("#adocout_goods_unit").val(rec.goods_unit);
        }
	});

	$('#adocout_goods_nums').numberbox({
	    required:true,
	});
	$('#adocout_goods_status').combobox({    
		url : '<?php echo $url?>out/docout/get_all_status',
	    valueField:'status_id',    
	    textField:'status_name',
	    required:true,
	    onLoadSuccess: function () { 
            var val = $(this).combobox("getData");
            $(this).combobox("select", val[0]['status_id']);
        },
	    onSelect:function(rec){    
            $("#adocout_goods_status_name").val(rec.status_name);
        }    
	});	
	
	outdocoutalist_tool = {
			add : function () {
				$('#outdocoutalist_date').dialog('open');
			},
			cut : function () {
				var rows = $('#outdocoutalist').datagrid('getSelected');
				var indexnums=$('#outdocoutalist').datagrid('getRowIndex',rows);
				$('#outdocoutalist').datagrid('deleteRow',indexnums);
			}
	};
	
});
function sendadocout(){
	var rows = $('#outdocoutalist').datagrid('getRows');
	if(rows.length==0){
		$.messager.alert('提示','请添加出库明细后再提交！','info');
	}else{		
		var docout_date={
			docout_number:$("#adocout_number").val(),
			docout_get_number:$("#adocout_get_number").val(),
			send_name:$("#adocout_send_name").val(),
			send_phone:$("#adocout_send_phone").val(),
			send_address:$("#adocout_send_address").val()
		};
		var docoutlist_date=[];
		$.each(rows,function(r,m){
			docoutlist_date. push(m);
		});
		docout_date.docoutlist_date=docoutlist_date;
		$.ajax({
			url : '<?php echo $url?>out/docout/add_docout',
			type : 'post',
			data : docout_date,
			beforeSend : function () {
				$.messager.progress({
					text : '正在提交中...',
				});
			},
			success : function (data, response, docout) {
				$.messager.progress('close');
				 var data = eval('(' + data + ')');     
//						console.log(data);
				if (data.success) {
					$.messager.show({						
						title : '提示',
						msg : data.message,
					});
					$("#adocout_number").val("");
					$("#adocout_send_number").val("");
					$('#outdocoutalist').datagrid('loadData',{total:0,rows:[]});					
				} else {
					$.messager.alert('添加失败！', data.message, 'warning').window({ width: 400 });					
				}
			}
		});
	}
}
function checkDouhao(val){ 
    var reg = new RegExp("[\uff0c]"); 
    var rs = ""; 
    for (var i = 0, l = val.length; i < val.length; i++) { 
        rs = rs + val.substr(i, 1).replace(reg, ','); 
    } 
    return $.trim(rs); 
}
</script>

<div id="outdocoutahead" class="easyui-panel" title="出库单头" border="false" style="background:#f4f4f4;width:100%;height:170px;padding:5px;">
   <form id="docouta_add" style="margin:0;padding:5px 0 0 25px;color:#333;">
        <p>出库单号：<input id="adocout_number" type="text" class="textbox" style="width:200px;" >　　要货单号：<input id="adocout_get_number" type="text"  class="textbox" style="width:200px;"></p>
    	<p>　收货人：<input id="adocout_send_name" type="text" class="textbox" style="width:200px;" >　　　　电话：<input id="adocout_send_phone" type="text"  class="textbox" style="width:200px;"></p>
    	<p>　　地址：<input id="adocout_send_address" type="text" class="textbox" style="width:500px;" >　　<a id="sendadocout" href="#" class="easyui-linkbutton" iconCls="icon-ok" onclick="return sendadocout();">提交</a></p>    	
    </form>
</div>

<table id="outdocoutalist"></table>
<div id="outdocoutalist_tool" style="padding:5px;">
	<div style="margin-bottom:5px;">
    	<a href="#" class="easyui-linkbutton" iconCls="icon-add" plain="true" onclick="outdocoutalist_tool.add()">添加</a>
		<a href="#" class="easyui-linkbutton" iconCls="icon-no" plain="true"  onclick="outdocoutalist_tool.cut();">移除</a>
	</div>
</div>

<form id="outdocoutalist_date" style="margin:0;padding:5px 0 0 25px;color:#333;">
    <p>货品名称：<input id="adocout_goods_name" style="width:200px;"></p>
    <input type="hidden" id="adocout_goods_id" class="textbox" style="width:200px;">
    <input type="hidden" id="adocout_goods_code" class="textbox" style="width:200px;">
	<p>货品单位：<input id="adocout_goods_unit" type="text" disabled="true"   class="textbox" style="width:200px;"></p>
	<p>货品状态：<input id="adocout_goods_status" style="width:200px;"></p>
	<input type="hidden" id="adocout_goods_status_name" class="textbox" style="width:200px;">
	<p>货品数量：<input id="adocout_goods_nums" type="text"   class="textbox" style="width:200px;"></p>
	<p>货品批注：<input placeholder="批注以英文逗号,分割 例如 : 红色,NT3500" id="adocout_goods_postil" type="text"   class="textbox" style="width:250px;"></p>
</form>

