/*
Navicat MySQL Data Transfer

Source Server         : localhost
Source Server Version : 50547
Source Host           : localhost:3306
Source Database       : ci

Target Server Type    : MYSQL
Target Server Version : 50547
File Encoding         : 65001

Date: 2018-09-21 13:52:12
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `area`
-- ----------------------------
DROP TABLE IF EXISTS `area`;
CREATE TABLE `area` (
  `area_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `area_name` varchar(50) NOT NULL,
  PRIMARY KEY (`area_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of area
-- ----------------------------
INSERT INTO `area` VALUES ('1', '线边库');
INSERT INTO `area` VALUES ('2', '缓冲库');

-- ----------------------------
-- Table structure for `button`
-- ----------------------------
DROP TABLE IF EXISTS `button`;
CREATE TABLE `button` (
  `button_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自动编号',
  `button_name` char(20) NOT NULL COMMENT '按钮名',
  `button_icon` varchar(20) DEFAULT NULL,
  `button_way` varchar(20) NOT NULL COMMENT '方法',
  `button_level` smallint(5) NOT NULL COMMENT '优先级',
  PRIMARY KEY (`button_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of button
-- ----------------------------
INSERT INTO `button` VALUES ('1', '新增', 'add', 'add', '1');
INSERT INTO `button` VALUES ('2', '修改', 'edit', 'edit', '2');
INSERT INTO `button` VALUES ('3', '导入', 'undo', 'undo', '6');
INSERT INTO `button` VALUES ('4', '后退', 'back', 'back', '4');
INSERT INTO `button` VALUES ('5', '查看', 'tip', 'look', '0');
INSERT INTO `button` VALUES ('6', '打印', 'print', 'print', '10');
INSERT INTO `button` VALUES ('7', '审核', 'ok', 'ok', '3');
INSERT INTO `button` VALUES ('8', '导出', 'redo', 'redo', '7');
INSERT INTO `button` VALUES ('9', '关闭', 'no', 'no', '12');

-- ----------------------------
-- Table structure for `docin`
-- ----------------------------
DROP TABLE IF EXISTS `docin`;
CREATE TABLE `docin` (
  `docin_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `docin_number` varchar(50) NOT NULL COMMENT '入库单号',
  `docin_send_number` varchar(50) DEFAULT '' COMMENT '送货单号',
  `docin_status` tinyint(3) NOT NULL DEFAULT '0' COMMENT '0编辑1审核2关闭',
  `docin_datetime` char(10) NOT NULL,
  `docin_update_datetime` char(10) DEFAULT NULL,
  PRIMARY KEY (`docin_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of docin
-- ----------------------------
INSERT INTO `docin` VALUES ('4', '1534390748', 'sn20180816', '2', '1534390748', null);
INSERT INTO `docin` VALUES ('5', '1534391925', 'iphone20180816', '1', '1534391925', null);
INSERT INTO `docin` VALUES ('6', 'poi20180816', 'poi20180816', '0', '1534392131', null);
INSERT INTO `docin` VALUES ('7', 'poi20180816', 'poi20180816', '0', '1534392253', null);
INSERT INTO `docin` VALUES ('8', 'poi20180817', '20180818', '0', '1534392472', '1534561985');
INSERT INTO `docin` VALUES ('9', '1534489685', '1534489685', '0', '1534489685', '1534561809');
INSERT INTO `docin` VALUES ('10', '1534391925', 'iphone20180818', '0', '1534559382', '1534562301');
INSERT INTO `docin` VALUES ('11', '1534562383', '1534562383', '1', '1534562383', '1535811930');
INSERT INTO `docin` VALUES ('12', '1534992711', '', '2', '1534992711', '1535818653');

-- ----------------------------
-- Table structure for `docinlist`
-- ----------------------------
DROP TABLE IF EXISTS `docinlist`;
CREATE TABLE `docinlist` (
  `docinlist_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `docin_id` int(11) unsigned NOT NULL,
  `goods_id` int(11) NOT NULL,
  `goods_unit` char(10) NOT NULL,
  `goods_status` smallint(5) unsigned NOT NULL,
  `goods_nums` int(11) NOT NULL,
  `goods_postil` varchar(255) DEFAULT NULL COMMENT '批注',
  PRIMARY KEY (`docinlist_id`)
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of docinlist
-- ----------------------------
INSERT INTO `docinlist` VALUES ('5', '4', '1', '台', '1', '100', '');
INSERT INTO `docinlist` VALUES ('6', '4', '1', '台', '1', '100', '联强');
INSERT INTO `docinlist` VALUES ('7', '4', '1', '台', '1', '100', '联强,黑色');
INSERT INTO `docinlist` VALUES ('8', '5', '2', '台', '1', '100', '黑,港版');
INSERT INTO `docinlist` VALUES ('9', '5', '2', '台', '2', '5', '');
INSERT INTO `docinlist` VALUES ('10', '6', '3', '袋', '1', '100', '');
INSERT INTO `docinlist` VALUES ('11', '6', '6', '个', '1', '100', '');
INSERT INTO `docinlist` VALUES ('12', '7', '4', '个', '1', '100', '');
INSERT INTO `docinlist` VALUES ('24', '8', '7', '台', '2', '5', '');
INSERT INTO `docinlist` VALUES ('23', '8', '7', '台', '1', '100', '联强,热敏');
INSERT INTO `docinlist` VALUES ('22', '9', '5', '个', '1', '100', '');
INSERT INTO `docinlist` VALUES ('34', '10', '4', '个', '1', '100', '');
INSERT INTO `docinlist` VALUES ('33', '10', '2', '台', '1', '100', '黑,港版');
INSERT INTO `docinlist` VALUES ('48', '11', '7', '台', '1', '100', '');
INSERT INTO `docinlist` VALUES ('50', '12', '3', '袋', '1', '10', 'asd水电费,sadf@');
INSERT INTO `docinlist` VALUES ('47', '11', '8', '个', '1', '100', '学院,北大');
INSERT INTO `docinlist` VALUES ('49', '11', '2', '台', '1', '1', '');

-- ----------------------------
-- Table structure for `docout`
-- ----------------------------
DROP TABLE IF EXISTS `docout`;
CREATE TABLE `docout` (
  `docout_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `docout_number` varchar(50) NOT NULL,
  `docout_get_number` varchar(50) DEFAULT NULL,
  `docout_status` tinyint(3) NOT NULL DEFAULT '0' COMMENT '0编辑1审核2关闭',
  `send_name` varchar(50) DEFAULT NULL,
  `send_phone` varchar(50) DEFAULT NULL,
  `send_address` varchar(255) DEFAULT NULL,
  `docout_datetime` char(10) NOT NULL,
  `docout_update_datetime` char(10) DEFAULT NULL,
  PRIMARY KEY (`docout_id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of docout
-- ----------------------------
INSERT INTO `docout` VALUES ('17', '1536512015', '', '0', '', '', '', '1536512015', '1536652041');
INSERT INTO `docout` VALUES ('20', '1536721288', '', '0', '', '', '', '1536721288', '1536723743');
INSERT INTO `docout` VALUES ('19', '1536652394', '', '0', '', '', '', '1536652394', '1536655679');

-- ----------------------------
-- Table structure for `docoutlist`
-- ----------------------------
DROP TABLE IF EXISTS `docoutlist`;
CREATE TABLE `docoutlist` (
  `docoutlist_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `docout_id` int(11) NOT NULL,
  `goods_id` int(11) NOT NULL,
  `goods_unit` char(10) NOT NULL,
  `goods_status` smallint(5) NOT NULL,
  `goods_nums` int(11) NOT NULL,
  `goods_postil` varchar(255) DEFAULT NULL,
  `inventory_id` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`docoutlist_id`)
) ENGINE=MyISAM AUTO_INCREMENT=158 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of docoutlist
-- ----------------------------
INSERT INTO `docoutlist` VALUES ('148', '19', '2', '台', '2', '2', '', '40,44');
INSERT INTO `docoutlist` VALUES ('147', '19', '2', '台', '1', '4', '', '41,43');
INSERT INTO `docoutlist` VALUES ('139', '17', '2', '台', '1', '5', '港版,黑', '42,45');
INSERT INTO `docoutlist` VALUES ('137', '17', '2', '台', '1', '3', '', '41,43');
INSERT INTO `docoutlist` VALUES ('138', '17', '2', '台', '2', '5', '', '40,44');
INSERT INTO `docoutlist` VALUES ('146', '19', '2', '台', '1', '3', '港版,黑', '42,45');
INSERT INTO `docoutlist` VALUES ('156', '20', '2', '台', '1', '2', '港版,黑', '42');
INSERT INTO `docoutlist` VALUES ('155', '20', '2', '台', '2', '2', '', '40,44');
INSERT INTO `docoutlist` VALUES ('154', '20', '2', '台', '1', '2', '', '41,43');
INSERT INTO `docoutlist` VALUES ('157', '20', '2', '台', '1', '1', '港版,黑色', '45');

-- ----------------------------
-- Table structure for `docoutlog`
-- ----------------------------
DROP TABLE IF EXISTS `docoutlog`;
CREATE TABLE `docoutlog` (
  `docoutlog_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `docout_id` int(11) NOT NULL,
  `subtract_log` text NOT NULL,
  PRIMARY KEY (`docoutlog_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of docoutlog
-- ----------------------------
INSERT INTO `docoutlog` VALUES ('1', '20', 'a:6:{i:0;a:1:{i:41;s:1:\"1\";}i:1;a:1:{i:43;i:1;}i:2;a:1:{i:40;s:1:\"1\";}i:3;a:1:{i:44;i:1;}i:4;a:1:{i:42;s:1:\"2\";}i:5;a:1:{i:45;s:1:\"1\";}}');

-- ----------------------------
-- Table structure for `docput`
-- ----------------------------
DROP TABLE IF EXISTS `docput`;
CREATE TABLE `docput` (
  `docput_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `docput_number` varchar(50) NOT NULL COMMENT '上架单号',
  `docin_id` int(11) NOT NULL,
  `docin_number` varchar(50) NOT NULL COMMENT '入库单号',
  `docin_send_number` varchar(50) DEFAULT NULL COMMENT '送货单号',
  `docput_status` tinyint(3) NOT NULL DEFAULT '0' COMMENT '0编辑1审核2关闭',
  `docput_datetime` char(10) NOT NULL,
  `docput_update_datetime` char(10) DEFAULT NULL,
  PRIMARY KEY (`docput_id`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of docput
-- ----------------------------
INSERT INTO `docput` VALUES ('27', '1535872150', '12', '1534992711', null, '2', '1535872150', null);
INSERT INTO `docput` VALUES ('28', '1535872620', '4', '1534390748', 'sn20180816', '2', '1535872620', '1535872674');
INSERT INTO `docput` VALUES ('29', '1535873427', '5', '1534391925', 'iphone20180816', '1', '1535873427', '1536648855');
INSERT INTO `docput` VALUES ('31', '1536471715', '11', '1534562383', '1534562383', '0', '1536471715', null);

-- ----------------------------
-- Table structure for `docputlist`
-- ----------------------------
DROP TABLE IF EXISTS `docputlist`;
CREATE TABLE `docputlist` (
  `docputlist_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `docput_id` int(11) NOT NULL,
  `goods_id` int(11) NOT NULL,
  `goods_unit` char(10) NOT NULL,
  `goods_status` smallint(5) NOT NULL,
  `goods_nums` int(11) NOT NULL,
  `goods_postil` varchar(255) DEFAULT NULL,
  `area_id` int(11) DEFAULT NULL,
  `position_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`docputlist_id`)
) ENGINE=MyISAM AUTO_INCREMENT=91 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of docputlist
-- ----------------------------
INSERT INTO `docputlist` VALUES ('59', '28', '1', '台', '1', '100', '', '1', '3');
INSERT INTO `docputlist` VALUES ('58', '28', '1', '台', '1', '100', '联强', '1', '3');
INSERT INTO `docputlist` VALUES ('53', '27', '3', '袋', '1', '10', 'asd水电费,sadf@', null, null);
INSERT INTO `docputlist` VALUES ('57', '28', '1', '台', '1', '100', '联强,黑色', '1', '1');
INSERT INTO `docputlist` VALUES ('89', '29', '2', '台', '2', '4', '', '2', '2');
INSERT INTO `docputlist` VALUES ('88', '29', '2', '台', '1', '4', '', '2', '2');
INSERT INTO `docputlist` VALUES ('67', '31', '7', '台', '1', '100', '', null, null);
INSERT INTO `docputlist` VALUES ('68', '31', '8', '个', '1', '100', '学院,北大', null, null);
INSERT INTO `docputlist` VALUES ('69', '31', '2', '台', '1', '1', '', null, null);
INSERT INTO `docputlist` VALUES ('87', '29', '2', '台', '1', '1', '黑,港版', '1', '1');
INSERT INTO `docputlist` VALUES ('86', '29', '2', '台', '1', '1', '', '1', '1');
INSERT INTO `docputlist` VALUES ('85', '29', '2', '台', '2', '1', '', '1', '1');
INSERT INTO `docputlist` VALUES ('90', '29', '2', '台', '1', '4', '黑,港版', '2', '2');

-- ----------------------------
-- Table structure for `goods`
-- ----------------------------
DROP TABLE IF EXISTS `goods`;
CREATE TABLE `goods` (
  `goods_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `goods_name` varchar(255) NOT NULL,
  `goods_code` varchar(255) NOT NULL,
  `goods_unit` char(10) NOT NULL COMMENT '基本单位',
  `goods_type` smallint(5) DEFAULT NULL,
  `goods_weight` mediumint(8) DEFAULT NULL,
  PRIMARY KEY (`goods_id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of goods
-- ----------------------------
INSERT INTO `goods` VALUES ('1', '联想笔记本E330', 'lenovoe330', '台', '1', '1000');
INSERT INTO `goods` VALUES ('2', '苹果6P', 'apple6pxl', '台', '1', '500');
INSERT INTO `goods` VALUES ('3', '茉莉花茶', 'flowermoli-tea', '袋', '2', '250');
INSERT INTO `goods` VALUES ('4', '充电线', 'powerline', '个', '1', '50');
INSERT INTO `goods` VALUES ('5', '雷柏光电鼠标', 'mouseoodal', '个', '1', '100');
INSERT INTO `goods` VALUES ('6', '茶道杯', 'teacup', '个', '2', '100');
INSERT INTO `goods` VALUES ('7', '斑马打印机', 'printBM', '台', '1', '500');
INSERT INTO `goods` VALUES ('8', '老鹰风筝', 'Eaglekite', '个', '2', '50');

-- ----------------------------
-- Table structure for `inventory`
-- ----------------------------
DROP TABLE IF EXISTS `inventory`;
CREATE TABLE `inventory` (
  `inventory_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `goods_unit` char(10) NOT NULL,
  `goods_status` smallint(5) NOT NULL,
  `goods_nums` int(11) NOT NULL,
  `goods_postil` varchar(255) DEFAULT NULL,
  `docin_id` int(11) NOT NULL,
  `docin_number` varchar(50) NOT NULL,
  `docin_send_number` varchar(50) DEFAULT NULL,
  `docput_id` int(11) NOT NULL,
  `docput_number` varchar(50) NOT NULL,
  `area_id` int(11) DEFAULT NULL,
  `position_id` int(11) DEFAULT NULL,
  `inventory_datetime` char(10) NOT NULL,
  `inventory_used_datetime` char(10) DEFAULT NULL,
  PRIMARY KEY (`inventory_id`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of inventory
-- ----------------------------
INSERT INTO `inventory` VALUES ('44', '2', '台', '2', '4', '', '5', '1534391925', 'iphone20180816', '29', '1535873427', '2', '2', '1536648912', '1537087366');
INSERT INTO `inventory` VALUES ('42', '2', '台', '1', '4', '黑,港版', '5', '1534391925', 'iphone20180816', '29', '1535873427', '1', '1', '1536648912', '1537087366');
INSERT INTO `inventory` VALUES ('43', '2', '台', '1', '5', '', '5', '1534391925', 'iphone20180816', '29', '1535873427', '2', '2', '1536648912', '1537087366');
INSERT INTO `inventory` VALUES ('41', '2', '台', '1', '1', '', '5', '1534391925', 'iphone20180816', '29', '1535873427', '1', '1', '1536648912', '1537087366');
INSERT INTO `inventory` VALUES ('40', '2', '台', '2', '1', '', '5', '1534391925', 'iphone20180816', '29', '1535873427', '1', '1', '1536648912', '1537087366');
INSERT INTO `inventory` VALUES ('45', '2', '台', '1', '1', '黑色,港版', '5', '1534391925', 'iphone20180816', '29', '1535873427', '2', '2', '1536648912', '1537087366');

-- ----------------------------
-- Table structure for `nav`
-- ----------------------------
DROP TABLE IF EXISTS `nav`;
CREATE TABLE `nav` (
  `nav_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '自动编号',
  `nav_name` char(20) NOT NULL COMMENT '导航名称',
  `nav_status` char(10) NOT NULL DEFAULT '' COMMENT '导航状态',
  `nav_url` char(50) NOT NULL DEFAULT '' COMMENT '导航链接',
  `nav_fid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父节点',
  `nav_code` char(20) DEFAULT NULL,
  `nav_level` smallint(5) DEFAULT NULL COMMENT '优先级',
  PRIMARY KEY (`nav_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of nav
-- ----------------------------
INSERT INTO `nav` VALUES ('1', '入库管理', 'open', '', '0', 'In', '1');
INSERT INTO `nav` VALUES ('2', '出库管理', 'open', '', '0', 'Out', '2');
INSERT INTO `nav` VALUES ('3', '库内管理', 'open', '', '0', 'Manage', '3');
INSERT INTO `nav` VALUES ('4', '统计报表', 'open', '', '0', 'Kpi', '4');
INSERT INTO `nav` VALUES ('5', '系统设置', 'open', '', '0', 'Base', '5');
INSERT INTO `nav` VALUES ('6', '入库单', 'open', 'in/Docin', '1', null, '1');
INSERT INTO `nav` VALUES ('7', '出库单', 'open', 'out/Docout', '2', null, '1');
INSERT INTO `nav` VALUES ('8', '库存查询', 'open', 'kpi/Inventory', '4', null, '1');
INSERT INTO `nav` VALUES ('9', '上架单', 'open', 'in/Docput', '1', null, '4');
INSERT INTO `nav` VALUES ('10', '角色管理', 'open', 'base/Role', '5', null, '3');
INSERT INTO `nav` VALUES ('11', '用户管理', 'open', 'base/User', '5', null, '4');
INSERT INTO `nav` VALUES ('12', '导航管理', 'open', 'base/Nav', '5', null, '1');
INSERT INTO `nav` VALUES ('13', '按钮管理', 'open', 'base/Button', '5', null, '2');
INSERT INTO `nav` VALUES ('14', '货品档案', 'open', 'manage/Goods', '3', null, '1');
INSERT INTO `nav` VALUES ('15', '货品类别', 'open', 'manage/Type', '3', null, '2');
INSERT INTO `nav` VALUES ('16', '货品状态', 'open', 'manage/Status', '3', null, '3');
INSERT INTO `nav` VALUES ('17', '库区设置', 'open', 'manage/Area', '3', null, '4');
INSERT INTO `nav` VALUES ('18', '储位设置', 'open', 'manage/Position', '3', null, '5');

-- ----------------------------
-- Table structure for `position`
-- ----------------------------
DROP TABLE IF EXISTS `position`;
CREATE TABLE `position` (
  `position_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `position_name` varchar(255) NOT NULL,
  `area_id` int(11) NOT NULL,
  PRIMARY KEY (`position_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of position
-- ----------------------------
INSERT INTO `position` VALUES ('1', 'cw-xbk-01', '1');
INSERT INTO `position` VALUES ('2', 'cw-hck-01', '2');
INSERT INTO `position` VALUES ('3', 'cw-xbk-02', '1');
INSERT INTO `position` VALUES ('4', 'cw-hck-02', '2');

-- ----------------------------
-- Table structure for `role`
-- ----------------------------
DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
  `role_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `role_name` varchar(50) NOT NULL,
  `role_nav_button_rang` text NOT NULL COMMENT '导航权限',
  PRIMARY KEY (`role_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of role
-- ----------------------------
INSERT INTO `role` VALUES ('1', '管理员', 'all');
INSERT INTO `role` VALUES ('2', '操作员', 'a:5:{i:1;a:2:{s:6:\"nav_id\";s:1:\"1\";s:5:\"child\";a:2:{i:0;a:2:{s:6:\"nav_id\";i:6;s:6:\"button\";a:9:{i:0;s:1:\"5\";i:1;s:1:\"1\";i:2;s:1:\"2\";i:3;s:1:\"7\";i:4;s:1:\"4\";i:5;s:1:\"3\";i:6;s:1:\"8\";i:7;s:1:\"6\";i:8;s:1:\"9\";}}i:1;a:2:{s:6:\"nav_id\";i:9;s:6:\"button\";a:7:{i:0;s:1:\"5\";i:1;s:1:\"2\";i:2;s:1:\"7\";i:3;s:1:\"4\";i:4;s:1:\"3\";i:5;s:1:\"8\";i:6;s:1:\"6\";}}}}i:2;a:2:{s:6:\"nav_id\";s:1:\"2\";s:5:\"child\";a:1:{i:0;a:2:{s:6:\"nav_id\";i:7;s:6:\"button\";a:9:{i:0;s:1:\"5\";i:1;s:1:\"1\";i:2;s:1:\"2\";i:3;s:1:\"7\";i:4;s:1:\"4\";i:5;s:1:\"3\";i:6;s:1:\"8\";i:7;s:1:\"6\";i:8;s:1:\"9\";}}}}i:3;a:2:{s:6:\"nav_id\";s:1:\"3\";s:5:\"child\";a:5:{i:0;a:2:{s:6:\"nav_id\";i:14;s:6:\"button\";a:3:{i:0;s:1:\"5\";i:1;s:1:\"1\";i:2;s:1:\"2\";}}i:1;a:2:{s:6:\"nav_id\";i:15;s:6:\"button\";a:2:{i:0;s:1:\"1\";i:1;s:1:\"2\";}}i:2;a:2:{s:6:\"nav_id\";i:16;s:6:\"button\";a:3:{i:0;s:1:\"5\";i:1;s:1:\"1\";i:2;s:1:\"2\";}}i:3;a:2:{s:6:\"nav_id\";i:17;s:6:\"button\";a:3:{i:0;s:1:\"5\";i:1;s:1:\"1\";i:2;s:1:\"2\";}}i:4;a:2:{s:6:\"nav_id\";i:18;s:6:\"button\";a:3:{i:0;s:1:\"5\";i:1;s:1:\"1\";i:2;s:1:\"2\";}}}}i:4;a:2:{s:6:\"nav_id\";s:1:\"4\";s:5:\"child\";a:1:{i:0;a:2:{s:6:\"nav_id\";i:8;s:6:\"button\";a:9:{i:0;s:1:\"5\";i:1;s:1:\"1\";i:2;s:1:\"2\";i:3;s:1:\"7\";i:4;s:1:\"4\";i:5;s:1:\"3\";i:6;s:1:\"8\";i:7;s:1:\"6\";i:8;s:1:\"9\";}}}}i:5;a:2:{s:6:\"nav_id\";s:1:\"5\";s:5:\"child\";a:4:{i:0;a:2:{s:6:\"nav_id\";i:12;s:6:\"button\";a:2:{i:0;s:1:\"1\";i:1;s:1:\"2\";}}i:1;a:2:{s:6:\"nav_id\";i:13;s:6:\"button\";a:2:{i:0;s:1:\"1\";i:1;s:1:\"2\";}}i:2;a:2:{s:6:\"nav_id\";i:10;s:6:\"button\";a:2:{i:0;s:1:\"1\";i:1;s:1:\"2\";}}i:3;a:2:{s:6:\"nav_id\";i:11;s:6:\"button\";a:2:{i:0;s:1:\"1\";i:1;s:1:\"2\";}}}}}');
INSERT INTO `role` VALUES ('3', '审核员', 'a:1:{i:1;a:2:{s:6:\"nav_id\";s:1:\"1\";s:5:\"child\";a:1:{i:0;a:2:{s:6:\"nav_id\";i:8;s:6:\"button\";a:9:{i:0;s:1:\"5\";i:1;s:1:\"1\";i:2;s:1:\"2\";i:3;s:1:\"7\";i:4;s:1:\"4\";i:5;s:1:\"3\";i:6;s:1:\"8\";i:7;s:1:\"6\";i:8;s:1:\"9\";}}}}}');
INSERT INTO `role` VALUES ('4', '大声道', 'a:3:{i:1;a:2:{s:6:\"nav_id\";s:1:\"1\";s:5:\"child\";a:1:{i:0;a:2:{s:6:\"nav_id\";i:6;s:6:\"button\";a:9:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"6\";i:5;s:1:\"7\";i:6;s:1:\"9\";i:7;s:1:\"8\";i:8;s:1:\"5\";}}}}i:2;a:2:{s:6:\"nav_id\";s:1:\"2\";s:5:\"child\";a:1:{i:0;a:2:{s:6:\"nav_id\";i:14;s:6:\"button\";a:9:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"6\";i:5;s:1:\"7\";i:6;s:1:\"9\";i:7;s:1:\"8\";i:8;s:1:\"5\";}}}}i:5;a:2:{s:6:\"nav_id\";s:1:\"5\";s:5:\"child\";a:1:{i:0;a:2:{s:6:\"nav_id\";i:12;s:6:\"button\";a:9:{i:0;s:1:\"1\";i:1;s:1:\"2\";i:2;s:1:\"3\";i:3;s:1:\"4\";i:4;s:1:\"6\";i:5;s:1:\"7\";i:6;s:1:\"9\";i:7;s:1:\"8\";i:8;s:1:\"5\";}}}}}');

-- ----------------------------
-- Table structure for `status`
-- ----------------------------
DROP TABLE IF EXISTS `status`;
CREATE TABLE `status` (
  `status_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `status_name` varchar(50) NOT NULL,
  PRIMARY KEY (`status_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of status
-- ----------------------------
INSERT INTO `status` VALUES ('1', '好货');
INSERT INTO `status` VALUES ('2', '坏货');

-- ----------------------------
-- Table structure for `type`
-- ----------------------------
DROP TABLE IF EXISTS `type`;
CREATE TABLE `type` (
  `type_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `type_name` varchar(50) NOT NULL,
  PRIMARY KEY (`type_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of type
-- ----------------------------
INSERT INTO `type` VALUES ('1', '电子数码');
INSERT INTO `type` VALUES ('2', '服装百货');

-- ----------------------------
-- Table structure for `user`
-- ----------------------------
DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `user_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `user_name` varchar(255) NOT NULL,
  `user_password` char(40) NOT NULL,
  `user_role` smallint(5) NOT NULL COMMENT '角色',
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of user
-- ----------------------------
INSERT INTO `user` VALUES ('1', 'admin', 'd033e22ae348aeb5660fc2140aec35850c4da997', '1');
INSERT INTO `user` VALUES ('2', 'tom', 'cd3f0c85b158c08a2b113464991810cf2cdfc387', '2');
INSERT INTO `user` VALUES ('3', 'jack', 'cd3f0c85b158c08a2b113464991810cf2cdfc387', '3');
INSERT INTO `user` VALUES ('4', 'tony', 'cd3f0c85b158c08a2b113464991810cf2cdfc387', '4');
