<?php

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class DatabaseSeeder extends Seeder
{
    /**
     * 数据库初始化
     *
     * @return void
     */
    public function run()
    {

        /*添加默认权限组*/
        DB::table('roles')->insert([
            ['id' => '1','name' => '后台管理员','slug' => 'admin','description' => '后台管理员，具有最高权限','level'=>1,'created_at'=>'2016-02-16 09:52:13','updated_at'=>'2016-02-16 09:52:13'],
            ['id' => '2','name' => '普通会员','slug' => 'member','description' => '普通会员，不可管理后台','level'=>1,'created_at'=>'2016-02-16 09:52:13','updated_at'=>'2016-02-16 09:52:13'],
        ]);



        DB::table('permissions')->insert([
            ['id' => '1','name' => '后台管理首页','slug' => 'admin.index.index','description' => '后台管理首页','created_at'=>'2016-02-16 17:57:51','updated_at'=>'2016-02-16 17:57:51'],
        ]);

        DB::table('permission_role')->insert([
            ['id' => '1','permission_id' => '1','role_id' => '1','created_at'=>'2016-02-16 17:37:51','updated_at'=>'2016-04-16 17:57:51'],
        ]);


        /*友情连接*/
        DB::table('friendship_links')->insert([
            ['id' => '1','name' => 'tipask问答网','slogan' => '国内最好PHP开源的问答系统','url' => 'http://wenda.tipask.com','sort' => '1','status' => '1','created_at' => '2016-05-10 18:25:54','updated_at' => '2016-05-10 18:28:05'],
        ]);


        /*系统默认配置*/
        DB::table('settings')->insert([
            ['name' => 'coins_write_article','value' => '0'],
            ['name' => 'coins_adopted','value' => '0'],
            ['name' => 'coins_answer','value' => '0'],
            ['name' => 'coins_ask','value' => '0'],
            ['name' => 'coins_login','value' => '0'],
            ['name' => 'coins_register','value' => '20'],
            ['name' => 'credits_write_article','value' => '0'],
            ['name' => 'credits_adopted','value' => '20'],
            ['name' => 'credits_answer','value' => '10'],
            ['name' => 'credits_ask','value' => '0'],
            ['name' => 'credits_login','value' => '10'],
            ['name' => 'credits_register','value' => '20'],
            ['name' => 'date_format','value' => 'Y-m-d'],
            ['name' => 'time_diff','value' => '0'],
            ['name' => 'time_format','value' => 'H:i'],
            ['name' => 'time_friendly','value' => '1'],
            ['name' => 'time_offset','value' => '8'],
            ['name' => 'website_admin_email','value' => 'admin@tipask.com'],
            ['name' => 'website_footer','value' => ''],
            ['name' => 'website_header','value' => ''],
            ['name' => 'website_icp','value' => ''],
            ['name' => 'website_cache_time','value' => '1'],
            ['name' => 'website_name','value' => 'Tipask问答网'],
            ['name' => 'website_url','value' => '']
        ]);

        /*地区字典表*/
        DB::table('areas')->insert([
            ['id' => '1','parent_id' => '0','name' => '北京','grade' => '1'],
            ['id' => '2','parent_id' => '0','name' => '上海','grade' => '1'],
            ['id' => '3','parent_id' => '0','name' => '天津','grade' => '1'],
            ['id' => '4','parent_id' => '0','name' => '重庆','grade' => '1'],
            ['id' => '5','parent_id' => '0','name' => '辽宁','grade' => '1'],
            ['id' => '6','parent_id' => '0','name' => '吉林','grade' => '1'],
            ['id' => '7','parent_id' => '0','name' => '黑龙江','grade' => '1'],
            ['id' => '8','parent_id' => '0','name' => '河北','grade' => '1'],
            ['id' => '9','parent_id' => '0','name' => '山西','grade' => '1'],
            ['id' => '10','parent_id' => '0','name' => '山东','grade' => '1'],
            ['id' => '11','parent_id' => '0','name' => '河南','grade' => '1'],
            ['id' => '12','parent_id' => '0','name' => '内蒙古','grade' => '1'],
            ['id' => '13','parent_id' => '0','name' => '陕西','grade' => '1'],
            ['id' => '14','parent_id' => '0','name' => '甘肃','grade' => '1'],
            ['id' => '15','parent_id' => '0','name' => '宁夏','grade' => '1'],
            ['id' => '16','parent_id' => '0','name' => '青海','grade' => '1'],
            ['id' => '17','parent_id' => '0','name' => '新疆','grade' => '1'],
            ['id' => '18','parent_id' => '0','name' => '福建','grade' => '1'],
            ['id' => '19','parent_id' => '0','name' => '湖南','grade' => '1'],
            ['id' => '20','parent_id' => '0','name' => '广东','grade' => '1'],
            ['id' => '21','parent_id' => '0','name' => '广西','grade' => '1'],
            ['id' => '22','parent_id' => '0','name' => '海南','grade' => '1'],
            ['id' => '23','parent_id' => '0','name' => '江苏','grade' => '1'],
            ['id' => '24','parent_id' => '0','name' => '浙江','grade' => '1'],
            ['id' => '25','parent_id' => '0','name' => '安徽','grade' => '1'],
            ['id' => '26','parent_id' => '0','name' => '江西','grade' => '1'],
            ['id' => '27','parent_id' => '0','name' => '湖北','grade' => '1'],
            ['id' => '28','parent_id' => '0','name' => '四川','grade' => '1'],
            ['id' => '29','parent_id' => '0','name' => '贵州','grade' => '1'],
            ['id' => '30','parent_id' => '0','name' => '云南','grade' => '1'],
            ['id' => '31','parent_id' => '0','name' => '西藏','grade' => '1'],
            ['id' => '32','parent_id' => '1','name' => '北京市','grade' => '2'],
            ['id' => '33','parent_id' => '2','name' => '上海市','grade' => '2'],
            ['id' => '34','parent_id' => '3','name' => '天津市','grade' => '2'],
            ['id' => '35','parent_id' => '4','name' => '重庆市','grade' => '2'],
            ['id' => '36','parent_id' => '5','name' => '抚顺','grade' => '2'],
            ['id' => '37','parent_id' => '5','name' => '本溪','grade' => '2'],
            ['id' => '38','parent_id' => '5','name' => '丹东','grade' => '2'],
            ['id' => '39','parent_id' => '5','name' => '锦州','grade' => '2'],
            ['id' => '40','parent_id' => '5','name' => '营口','grade' => '2'],
            ['id' => '41','parent_id' => '5','name' => '阜新','grade' => '2'],
            ['id' => '42','parent_id' => '5','name' => '辽阳','grade' => '2'],
            ['id' => '43','parent_id' => '5','name' => '铁岭','grade' => '2'],
            ['id' => '44','parent_id' => '5','name' => '朝阳','grade' => '2'],
            ['id' => '45','parent_id' => '5','name' => '盘锦','grade' => '2'],
            ['id' => '46','parent_id' => '5','name' => '葫芦岛','grade' => '2'],
            ['id' => '47','parent_id' => '5','name' => '大连','grade' => '2'],
            ['id' => '48','parent_id' => '5','name' => '沈阳','grade' => '2'],
            ['id' => '49','parent_id' => '5','name' => '鞍山','grade' => '2'],
            ['id' => '50','parent_id' => '6','name' => '长春','grade' => '2'],
            ['id' => '51','parent_id' => '6','name' => '吉林','grade' => '2'],
            ['id' => '52','parent_id' => '6','name' => '四平','grade' => '2'],
            ['id' => '53','parent_id' => '6','name' => '辽源','grade' => '2'],
            ['id' => '54','parent_id' => '6','name' => '通化','grade' => '2'],
            ['id' => '55','parent_id' => '6','name' => '白城','grade' => '2'],
            ['id' => '56','parent_id' => '6','name' => '延边','grade' => '2'],
            ['id' => '57','parent_id' => '6','name' => '白山','grade' => '2'],
            ['id' => '58','parent_id' => '6','name' => '松原','grade' => '2'],
            ['id' => '59','parent_id' => '7','name' => '哈尔滨','grade' => '2'],
            ['id' => '60','parent_id' => '7','name' => '齐齐哈尔','grade' => '2'],
            ['id' => '61','parent_id' => '7','name' => '鹤岗','grade' => '2'],
            ['id' => '62','parent_id' => '7','name' => '双鸭山','grade' => '2'],
            ['id' => '63','parent_id' => '7','name' => '鸡西','grade' => '2'],
            ['id' => '64','parent_id' => '7','name' => '大庆','grade' => '2'],
            ['id' => '65','parent_id' => '7','name' => '伊春','grade' => '2'],
            ['id' => '66','parent_id' => '7','name' => '牡丹江','grade' => '2'],
            ['id' => '67','parent_id' => '7','name' => '佳木斯','grade' => '2'],
            ['id' => '68','parent_id' => '7','name' => '七台河','grade' => '2'],
            ['id' => '69','parent_id' => '7','name' => '绥化','grade' => '2'],
            ['id' => '70','parent_id' => '7','name' => '黑河','grade' => '2'],
            ['id' => '71','parent_id' => '7','name' => '大兴安岭','grade' => '2'],
            ['id' => '72','parent_id' => '8','name' => '石家庄','grade' => '2'],
            ['id' => '73','parent_id' => '8','name' => '唐山','grade' => '2'],
            ['id' => '74','parent_id' => '8','name' => '秦皇岛','grade' => '2'],
            ['id' => '75','parent_id' => '8','name' => '邯郸','grade' => '2'],
            ['id' => '76','parent_id' => '8','name' => '邢台','grade' => '2'],
            ['id' => '77','parent_id' => '8','name' => '张家口','grade' => '2'],
            ['id' => '78','parent_id' => '8','name' => '承德','grade' => '2'],
            ['id' => '79','parent_id' => '8','name' => '廊坊','grade' => '2'],
            ['id' => '80','parent_id' => '8','name' => '沧州','grade' => '2'],
            ['id' => '81','parent_id' => '8','name' => '保定','grade' => '2'],
            ['id' => '82','parent_id' => '8','name' => '衡水','grade' => '2'],
            ['id' => '83','parent_id' => '9','name' => '太原','grade' => '2'],
            ['id' => '84','parent_id' => '9','name' => '大同','grade' => '2'],
            ['id' => '85','parent_id' => '9','name' => '阳泉','grade' => '2'],
            ['id' => '86','parent_id' => '9','name' => '长治','grade' => '2'],
            ['id' => '87','parent_id' => '9','name' => '晋城','grade' => '2'],
            ['id' => '88','parent_id' => '9','name' => '朔州','grade' => '2'],
            ['id' => '89','parent_id' => '9','name' => '晋中','grade' => '2'],
            ['id' => '90','parent_id' => '9','name' => '忻州','grade' => '2'],
            ['id' => '91','parent_id' => '9','name' => '吕梁','grade' => '2'],
            ['id' => '92','parent_id' => '9','name' => '临汾','grade' => '2'],
            ['id' => '93','parent_id' => '9','name' => '运城','grade' => '2'],
            ['id' => '94','parent_id' => '10','name' => '济南','grade' => '2'],
            ['id' => '95','parent_id' => '10','name' => '青岛','grade' => '2'],
            ['id' => '96','parent_id' => '10','name' => '淄博','grade' => '2'],
            ['id' => '97','parent_id' => '10','name' => '枣庄','grade' => '2'],
            ['id' => '98','parent_id' => '10','name' => '东营','grade' => '2'],
            ['id' => '99','parent_id' => '10','name' => '潍坊','grade' => '2'],
            ['id' => '100','parent_id' => '10','name' => '烟台','grade' => '2'],
            ['id' => '101','parent_id' => '10','name' => '威海','grade' => '2'],
            ['id' => '102','parent_id' => '10','name' => '济宁','grade' => '2'],
            ['id' => '103','parent_id' => '10','name' => '泰安','grade' => '2'],
            ['id' => '104','parent_id' => '10','name' => '日照','grade' => '2'],
            ['id' => '105','parent_id' => '10','name' => '莱芜','grade' => '2'],
            ['id' => '106','parent_id' => '10','name' => '德州','grade' => '2'],
            ['id' => '107','parent_id' => '10','name' => '滨州','grade' => '2'],
            ['id' => '108','parent_id' => '10','name' => '临沂','grade' => '2'],
            ['id' => '109','parent_id' => '10','name' => '荷泽','grade' => '2'],
            ['id' => '110','parent_id' => '10','name' => '聊城','grade' => '2'],
            ['id' => '111','parent_id' => '11','name' => '郑州','grade' => '2'],
            ['id' => '112','parent_id' => '11','name' => '开封','grade' => '2'],
            ['id' => '113','parent_id' => '11','name' => '洛阳','grade' => '2'],
            ['id' => '114','parent_id' => '11','name' => '平顶山','grade' => '2'],
            ['id' => '115','parent_id' => '11','name' => '焦作','grade' => '2'],
            ['id' => '116','parent_id' => '11','name' => '鹤壁','grade' => '2'],
            ['id' => '117','parent_id' => '11','name' => '新乡','grade' => '2'],
            ['id' => '118','parent_id' => '11','name' => '安阳','grade' => '2'],
            ['id' => '119','parent_id' => '11','name' => '濮阳','grade' => '2'],
            ['id' => '120','parent_id' => '11','name' => '许昌','grade' => '2'],
            ['id' => '121','parent_id' => '11','name' => '漯河','grade' => '2'],
            ['id' => '122','parent_id' => '11','name' => '三门峡','grade' => '2'],
            ['id' => '123','parent_id' => '11','name' => '商丘','grade' => '2'],
            ['id' => '124','parent_id' => '11','name' => '周口','grade' => '2'],
            ['id' => '125','parent_id' => '11','name' => '驻马店','grade' => '2'],
            ['id' => '126','parent_id' => '11','name' => '信阳','grade' => '2'],
            ['id' => '127','parent_id' => '11','name' => '南阳','grade' => '2'],
            ['id' => '128','parent_id' => '11','name' => '济源','grade' => '2'],
            ['id' => '129','parent_id' => '12','name' => '呼和浩特','grade' => '2'],
            ['id' => '130','parent_id' => '12','name' => '包头','grade' => '2'],
            ['id' => '131','parent_id' => '12','name' => '乌海','grade' => '2'],
            ['id' => '132','parent_id' => '12','name' => '赤峰','grade' => '2'],
            ['id' => '133','parent_id' => '12','name' => '呼伦贝尔','grade' => '2'],
            ['id' => '134','parent_id' => '12','name' => '巴彦淖尔','grade' => '2'],
            ['id' => '135','parent_id' => '12','name' => '通辽','grade' => '2'],
            ['id' => '136','parent_id' => '12','name' => '鄂尔多斯','grade' => '2'],
            ['id' => '137','parent_id' => '12','name' => '乌兰察布','grade' => '2'],
            ['id' => '138','parent_id' => '12','name' => '锡林郭勒盟','grade' => '2'],
            ['id' => '139','parent_id' => '12','name' => '阿拉善盟','grade' => '2'],
            ['id' => '140','parent_id' => '12','name' => '兴安盟','grade' => '2'],
            ['id' => '141','parent_id' => '13','name' => '西安','grade' => '2'],
            ['id' => '142','parent_id' => '13','name' => '铜川','grade' => '2'],
            ['id' => '143','parent_id' => '13','name' => '宝鸡','grade' => '2'],
            ['id' => '144','parent_id' => '13','name' => '咸阳','grade' => '2'],
            ['id' => '145','parent_id' => '13','name' => '榆林','grade' => '2'],
            ['id' => '146','parent_id' => '13','name' => '延安','grade' => '2'],
            ['id' => '147','parent_id' => '13','name' => '渭南','grade' => '2'],
            ['id' => '148','parent_id' => '13','name' => '汉中','grade' => '2'],
            ['id' => '149','parent_id' => '13','name' => '商洛','grade' => '2'],
            ['id' => '150','parent_id' => '13','name' => '安康','grade' => '2'],
            ['id' => '151','parent_id' => '13','name' => '杨凌示范区','grade' => '2'],
            ['id' => '152','parent_id' => '14','name' => '兰州','grade' => '2'],
            ['id' => '153','parent_id' => '14','name' => '金昌','grade' => '2'],
            ['id' => '154','parent_id' => '14','name' => '白银','grade' => '2'],
            ['id' => '155','parent_id' => '14','name' => '天水','grade' => '2'],
            ['id' => '156','parent_id' => '14','name' => '临夏回族自治州','grade' => '2'],
            ['id' => '157','parent_id' => '14','name' => '定西','grade' => '2'],
            ['id' => '158','parent_id' => '14','name' => '平凉','grade' => '2'],
            ['id' => '159','parent_id' => '14','name' => '庆阳','grade' => '2'],
            ['id' => '160','parent_id' => '14','name' => '陇南','grade' => '2'],
            ['id' => '161','parent_id' => '14','name' => '武威','grade' => '2'],
            ['id' => '162','parent_id' => '14','name' => '张掖','grade' => '2'],
            ['id' => '163','parent_id' => '14','name' => '酒泉','grade' => '2'],
            ['id' => '164','parent_id' => '14','name' => '甘南藏族自治州','grade' => '2'],
            ['id' => '165','parent_id' => '14','name' => '嘉峪关','grade' => '2'],
            ['id' => '166','parent_id' => '15','name' => '银川','grade' => '2'],
            ['id' => '167','parent_id' => '15','name' => '石嘴山','grade' => '2'],
            ['id' => '168','parent_id' => '15','name' => '吴忠','grade' => '2'],
            ['id' => '169','parent_id' => '15','name' => '固原','grade' => '2'],
            ['id' => '170','parent_id' => '15','name' => '中卫','grade' => '2'],
            ['id' => '171','parent_id' => '16','name' => '西宁','grade' => '2'],
            ['id' => '172','parent_id' => '16','name' => '海东地区','grade' => '2'],
            ['id' => '173','parent_id' => '16','name' => '海北藏族自治州','grade' => '2'],
            ['id' => '174','parent_id' => '16','name' => '黄南藏族自治州','grade' => '2'],
            ['id' => '175','parent_id' => '16','name' => '海南藏族自治州','grade' => '2'],
            ['id' => '176','parent_id' => '16','name' => '果洛藏族自治州','grade' => '2'],
            ['id' => '177','parent_id' => '16','name' => '玉树藏族自治州','grade' => '2'],
            ['id' => '178','parent_id' => '16','name' => '海西蒙古族藏族自治州','grade' => '2'],
            ['id' => '179','parent_id' => '17','name' => '乌鲁木齐','grade' => '2'],
            ['id' => '180','parent_id' => '17','name' => '克拉玛依','grade' => '2'],
            ['id' => '181','parent_id' => '17','name' => '石河子','grade' => '2'],
            ['id' => '182','parent_id' => '17','name' => '吐鲁番地区','grade' => '2'],
            ['id' => '183','parent_id' => '17','name' => '哈密地区','grade' => '2'],
            ['id' => '184','parent_id' => '17','name' => '昌吉回族自治州','grade' => '2'],
            ['id' => '185','parent_id' => '17','name' => '和田地区','grade' => '2'],
            ['id' => '186','parent_id' => '17','name' => '阿克苏地区','grade' => '2'],
            ['id' => '187','parent_id' => '17','name' => '喀什地区','grade' => '2'],
            ['id' => '188','parent_id' => '17','name' => '克孜勒苏柯尔克孜自治州','grade' => '2'],
            ['id' => '189','parent_id' => '17','name' => '巴音郭楞蒙古自治州','grade' => '2'],
            ['id' => '190','parent_id' => '17','name' => '塔城地区','grade' => '2'],
            ['id' => '191','parent_id' => '17','name' => '阿勒泰地区','grade' => '2'],
            ['id' => '192','parent_id' => '17','name' => '博尔塔拉蒙古自治州','grade' => '2'],
            ['id' => '193','parent_id' => '17','name' => '伊犁哈萨克自治州','grade' => '2'],
            ['id' => '194','parent_id' => '17','name' => '阿拉尔','grade' => '2'],
            ['id' => '195','parent_id' => '17','name' => '图木舒克','grade' => '2'],
            ['id' => '196','parent_id' => '17','name' => '五家渠','grade' => '2'],
            ['id' => '197','parent_id' => '18','name' => '福州','grade' => '2'],
            ['id' => '198','parent_id' => '18','name' => '厦门','grade' => '2'],
            ['id' => '199','parent_id' => '18','name' => '三明','grade' => '2'],
            ['id' => '200','parent_id' => '18','name' => '莆田','grade' => '2'],
            ['id' => '201','parent_id' => '18','name' => '泉州','grade' => '2'],
            ['id' => '202','parent_id' => '18','name' => '漳州','grade' => '2'],
            ['id' => '203','parent_id' => '18','name' => '南平','grade' => '2'],
            ['id' => '204','parent_id' => '18','name' => '宁德','grade' => '2'],
            ['id' => '205','parent_id' => '18','name' => '龙岩','grade' => '2'],
            ['id' => '206','parent_id' => '19','name' => '长沙','grade' => '2'],
            ['id' => '207','parent_id' => '19','name' => '株洲','grade' => '2'],
            ['id' => '208','parent_id' => '19','name' => '湘潭','grade' => '2'],
            ['id' => '209','parent_id' => '19','name' => '衡阳','grade' => '2'],
            ['id' => '210','parent_id' => '19','name' => '邵阳','grade' => '2'],
            ['id' => '211','parent_id' => '19','name' => '岳阳','grade' => '2'],
            ['id' => '212','parent_id' => '19','name' => '常德','grade' => '2'],
            ['id' => '213','parent_id' => '19','name' => '张家界','grade' => '2'],
            ['id' => '214','parent_id' => '19','name' => '娄底','grade' => '2'],
            ['id' => '215','parent_id' => '19','name' => '郴州','grade' => '2'],
            ['id' => '216','parent_id' => '19','name' => '永州','grade' => '2'],
            ['id' => '217','parent_id' => '19','name' => '怀化','grade' => '2'],
            ['id' => '218','parent_id' => '19','name' => '益阳','grade' => '2'],
            ['id' => '219','parent_id' => '19','name' => '湘西自治州','grade' => '2'],
            ['id' => '220','parent_id' => '20','name' => '广州','grade' => '2'],
            ['id' => '221','parent_id' => '20','name' => '深圳','grade' => '2'],
            ['id' => '222','parent_id' => '20','name' => '珠海','grade' => '2'],
            ['id' => '223','parent_id' => '20','name' => '佛山','grade' => '2'],
            ['id' => '224','parent_id' => '20','name' => '东莞','grade' => '2'],
            ['id' => '225','parent_id' => '20','name' => '惠州','grade' => '2'],
            ['id' => '226','parent_id' => '20','name' => '江门','grade' => '2'],
            ['id' => '227','parent_id' => '20','name' => '湛江','grade' => '2'],
            ['id' => '228','parent_id' => '20','name' => '茂名','grade' => '2'],
            ['id' => '229','parent_id' => '20','name' => '中山','grade' => '2'],
            ['id' => '230','parent_id' => '20','name' => '汕头','grade' => '2'],
            ['id' => '231','parent_id' => '20','name' => '揭阳','grade' => '2'],
            ['id' => '232','parent_id' => '20','name' => '潮州','grade' => '2'],
            ['id' => '233','parent_id' => '20','name' => '汕尾','grade' => '2'],
            ['id' => '234','parent_id' => '20','name' => '韶关','grade' => '2'],
            ['id' => '235','parent_id' => '20','name' => '肇庆','grade' => '2'],
            ['id' => '236','parent_id' => '20','name' => '清远','grade' => '2'],
            ['id' => '237','parent_id' => '20','name' => '梅州','grade' => '2'],
            ['id' => '238','parent_id' => '20','name' => '河源','grade' => '2'],
            ['id' => '239','parent_id' => '20','name' => '云浮','grade' => '2'],
            ['id' => '240','parent_id' => '20','name' => '阳江','grade' => '2'],
            ['id' => '241','parent_id' => '21','name' => '南宁','grade' => '2'],
            ['id' => '242','parent_id' => '21','name' => '柳州','grade' => '2'],
            ['id' => '243','parent_id' => '21','name' => '桂林','grade' => '2'],
            ['id' => '244','parent_id' => '21','name' => '梧州','grade' => '2'],
            ['id' => '245','parent_id' => '21','name' => '北海','grade' => '2'],
            ['id' => '246','parent_id' => '21','name' => '玉林','grade' => '2'],
            ['id' => '247','parent_id' => '21','name' => '百色','grade' => '2'],
            ['id' => '248','parent_id' => '21','name' => '防城港','grade' => '2'],
            ['id' => '249','parent_id' => '21','name' => '钦州','grade' => '2'],
            ['id' => '250','parent_id' => '21','name' => '贵港','grade' => '2'],
            ['id' => '251','parent_id' => '21','name' => '贺州','grade' => '2'],
            ['id' => '252','parent_id' => '21','name' => '河池','grade' => '2'],
            ['id' => '253','parent_id' => '21','name' => '来宾','grade' => '2'],
            ['id' => '254','parent_id' => '21','name' => '崇左','grade' => '2'],
            ['id' => '255','parent_id' => '22','name' => '海口','grade' => '2'],
            ['id' => '256','parent_id' => '22','name' => '三亚','grade' => '2'],
            ['id' => '257','parent_id' => '22','name' => '琼海','grade' => '2'],
            ['id' => '258','parent_id' => '22','name' => '五指山','grade' => '2'],
            ['id' => '259','parent_id' => '22','name' => '儋州','grade' => '2'],
            ['id' => '260','parent_id' => '22','name' => '文昌','grade' => '2'],
            ['id' => '261','parent_id' => '22','name' => '万宁','grade' => '2'],
            ['id' => '262','parent_id' => '22','name' => '东方','grade' => '2'],
            ['id' => '263','parent_id' => '22','name' => '其他','grade' => '2'],
            ['id' => '264','parent_id' => '23','name' => '南京','grade' => '2'],
            ['id' => '265','parent_id' => '23','name' => '徐州','grade' => '2'],
            ['id' => '266','parent_id' => '23','name' => '连云港','grade' => '2'],
            ['id' => '267','parent_id' => '23','name' => '淮安','grade' => '2'],
            ['id' => '268','parent_id' => '23','name' => '盐城','grade' => '2'],
            ['id' => '269','parent_id' => '23','name' => '扬州','grade' => '2'],
            ['id' => '270','parent_id' => '23','name' => '南通','grade' => '2'],
            ['id' => '271','parent_id' => '23','name' => '镇江','grade' => '2'],
            ['id' => '272','parent_id' => '23','name' => '常州','grade' => '2'],
            ['id' => '273','parent_id' => '23','name' => '泰州','grade' => '2'],
            ['id' => '274','parent_id' => '23','name' => '无锡','grade' => '2'],
            ['id' => '275','parent_id' => '23','name' => '苏州','grade' => '2'],
            ['id' => '276','parent_id' => '23','name' => '宿迁','grade' => '2'],
            ['id' => '277','parent_id' => '24','name' => '杭州','grade' => '2'],
            ['id' => '278','parent_id' => '24','name' => '湖州','grade' => '2'],
            ['id' => '279','parent_id' => '24','name' => '宁波','grade' => '2'],
            ['id' => '280','parent_id' => '24','name' => '温州','grade' => '2'],
            ['id' => '281','parent_id' => '24','name' => '嘉兴','grade' => '2'],
            ['id' => '282','parent_id' => '24','name' => '绍兴','grade' => '2'],
            ['id' => '283','parent_id' => '24','name' => '金华','grade' => '2'],
            ['id' => '284','parent_id' => '24','name' => '衢州','grade' => '2'],
            ['id' => '285','parent_id' => '24','name' => '舟山','grade' => '2'],
            ['id' => '286','parent_id' => '24','name' => '台州','grade' => '2'],
            ['id' => '287','parent_id' => '24','name' => '丽水','grade' => '2'],
            ['id' => '288','parent_id' => '25','name' => '合肥','grade' => '2'],
            ['id' => '289','parent_id' => '25','name' => '淮南','grade' => '2'],
            ['id' => '290','parent_id' => '25','name' => '淮北','grade' => '2'],
            ['id' => '291','parent_id' => '25','name' => '芜湖','grade' => '2'],
            ['id' => '292','parent_id' => '25','name' => '铜陵','grade' => '2'],
            ['id' => '293','parent_id' => '25','name' => '蚌埠','grade' => '2'],
            ['id' => '294','parent_id' => '25','name' => '马鞍山','grade' => '2'],
            ['id' => '295','parent_id' => '25','name' => '安庆','grade' => '2'],
            ['id' => '296','parent_id' => '25','name' => '黄山','grade' => '2'],
            ['id' => '297','parent_id' => '25','name' => '宿州','grade' => '2'],
            ['id' => '298','parent_id' => '25','name' => '滁州','grade' => '2'],
            ['id' => '299','parent_id' => '25','name' => '巢湖','grade' => '2'],
            ['id' => '300','parent_id' => '25','name' => '宣城','grade' => '2'],
            ['id' => '301','parent_id' => '25','name' => '池州','grade' => '2'],
            ['id' => '302','parent_id' => '25','name' => '六安','grade' => '2'],
            ['id' => '303','parent_id' => '25','name' => '阜阳','grade' => '2'],
            ['id' => '304','parent_id' => '25','name' => '毫州','grade' => '2'],
            ['id' => '305','parent_id' => '26','name' => '南昌','grade' => '2'],
            ['id' => '306','parent_id' => '26','name' => '景德镇','grade' => '2'],
            ['id' => '307','parent_id' => '26','name' => '萍乡','grade' => '2'],
            ['id' => '308','parent_id' => '26','name' => '新余','grade' => '2'],
            ['id' => '309','parent_id' => '26','name' => '九江','grade' => '2'],
            ['id' => '310','parent_id' => '26','name' => '鹰潭','grade' => '2'],
            ['id' => '311','parent_id' => '26','name' => '上饶','grade' => '2'],
            ['id' => '312','parent_id' => '26','name' => '宜春','grade' => '2'],
            ['id' => '313','parent_id' => '26','name' => '抚州','grade' => '2'],
            ['id' => '314','parent_id' => '26','name' => '吉安','grade' => '2'],
            ['id' => '315','parent_id' => '26','name' => '赣州','grade' => '2'],
            ['id' => '316','parent_id' => '27','name' => '武汉','grade' => '2'],
            ['id' => '317','parent_id' => '27','name' => '黄石','grade' => '2'],
            ['id' => '318','parent_id' => '27','name' => '襄阳','grade' => '2'],
            ['id' => '319','parent_id' => '27','name' => '十堰','grade' => '2'],
            ['id' => '320','parent_id' => '27','name' => '宜昌','grade' => '2'],
            ['id' => '321','parent_id' => '27','name' => '荆州','grade' => '2'],
            ['id' => '322','parent_id' => '27','name' => '鄂州','grade' => '2'],
            ['id' => '323','parent_id' => '27','name' => '孝感','grade' => '2'],
            ['id' => '324','parent_id' => '27','name' => '黄冈','grade' => '2'],
            ['id' => '325','parent_id' => '27','name' => '咸宁','grade' => '2'],
            ['id' => '326','parent_id' => '27','name' => '荆门','grade' => '2'],
            ['id' => '327','parent_id' => '27','name' => '随州','grade' => '2'],
            ['id' => '328','parent_id' => '27','name' => '天门','grade' => '2'],
            ['id' => '329','parent_id' => '27','name' => '仙桃','grade' => '2'],
            ['id' => '330','parent_id' => '27','name' => '潜江','grade' => '2'],
            ['id' => '331','parent_id' => '27','name' => '神农架林区','grade' => '2'],
            ['id' => '332','parent_id' => '27','name' => '恩施自治州','grade' => '2'],
            ['id' => '333','parent_id' => '28','name' => '成都','grade' => '2'],
            ['id' => '334','parent_id' => '28','name' => '自贡','grade' => '2'],
            ['id' => '335','parent_id' => '28','name' => '广安','grade' => '2'],
            ['id' => '336','parent_id' => '28','name' => '攀枝花','grade' => '2'],
            ['id' => '337','parent_id' => '28','name' => '泸州','grade' => '2'],
            ['id' => '338','parent_id' => '28','name' => '德阳','grade' => '2'],
            ['id' => '339','parent_id' => '28','name' => '绵阳','grade' => '2'],
            ['id' => '340','parent_id' => '28','name' => '广元','grade' => '2'],
            ['id' => '341','parent_id' => '28','name' => '遂宁','grade' => '2'],
            ['id' => '342','parent_id' => '28','name' => '内江','grade' => '2'],
            ['id' => '343','parent_id' => '28','name' => '乐山','grade' => '2'],
            ['id' => '344','parent_id' => '28','name' => '宜宾','grade' => '2'],
            ['id' => '345','parent_id' => '28','name' => '南充','grade' => '2'],
            ['id' => '346','parent_id' => '28','name' => '资阳','grade' => '2'],
            ['id' => '347','parent_id' => '28','name' => '雅安','grade' => '2'],
            ['id' => '348','parent_id' => '28','name' => '巴中','grade' => '2'],
            ['id' => '349','parent_id' => '28','name' => '达州','grade' => '2'],
            ['id' => '350','parent_id' => '28','name' => '眉山','grade' => '2'],
            ['id' => '351','parent_id' => '28','name' => '甘孜','grade' => '2'],
            ['id' => '352','parent_id' => '28','name' => '凉山','grade' => '2'],
            ['id' => '353','parent_id' => '28','name' => '阿坝','grade' => '2'],
            ['id' => '354','parent_id' => '29','name' => '贵阳','grade' => '2'],
            ['id' => '355','parent_id' => '29','name' => '六盘水','grade' => '2'],
            ['id' => '356','parent_id' => '29','name' => '遵义','grade' => '2'],
            ['id' => '357','parent_id' => '29','name' => '铜仁','grade' => '2'],
            ['id' => '358','parent_id' => '29','name' => '毕节','grade' => '2'],
            ['id' => '359','parent_id' => '29','name' => '安顺','grade' => '2'],
            ['id' => '360','parent_id' => '29','name' => '黔东南苗族侗族自治州','grade' => '2'],
            ['id' => '361','parent_id' => '29','name' => '黔南布依族苗族自治州','grade' => '2'],
            ['id' => '362','parent_id' => '29','name' => '黔西南布依族苗族自治州','grade' => '2'],
            ['id' => '363','parent_id' => '30','name' => '昆明','grade' => '2'],
            ['id' => '364','parent_id' => '30','name' => '昭通','grade' => '2'],
            ['id' => '365','parent_id' => '30','name' => '曲靖','grade' => '2'],
            ['id' => '366','parent_id' => '30','name' => '玉溪','grade' => '2'],
            ['id' => '367','parent_id' => '30','name' => '普洱','grade' => '2'],
            ['id' => '368','parent_id' => '30','name' => '临沧','grade' => '2'],
            ['id' => '369','parent_id' => '30','name' => '保山','grade' => '2'],
            ['id' => '370','parent_id' => '30','name' => '丽江','grade' => '2'],
            ['id' => '371','parent_id' => '30','name' => '文山','grade' => '2'],
            ['id' => '372','parent_id' => '30','name' => '红河','grade' => '2'],
            ['id' => '373','parent_id' => '30','name' => '西双版纳','grade' => '2'],
            ['id' => '374','parent_id' => '30','name' => '楚雄','grade' => '2'],
            ['id' => '375','parent_id' => '30','name' => '大理','grade' => '2'],
            ['id' => '376','parent_id' => '30','name' => '德宏','grade' => '2'],
            ['id' => '377','parent_id' => '30','name' => '怒江','grade' => '2'],
            ['id' => '378','parent_id' => '30','name' => '迪庆','grade' => '2'],
            ['id' => '379','parent_id' => '31','name' => '拉萨','grade' => '2'],
            ['id' => '380','parent_id' => '31','name' => '那曲','grade' => '2'],
            ['id' => '381','parent_id' => '31','name' => '昌都','grade' => '2'],
            ['id' => '382','parent_id' => '31','name' => '山南','grade' => '2'],
            ['id' => '383','parent_id' => '31','name' => '日喀则','grade' => '2'],
            ['id' => '384','parent_id' => '31','name' => '阿里','grade' => '2'],
            ['id' => '385','parent_id' => '31','name' => '林芝','grade' => '2']
        ]);




    }
}
