/*!
 * Chart.js
 * http://chartjs.org/
 * Version: 2.0.0-alpha
 *
 * Copyright 2015 Nick Downie
 * Released under the MIT license
 * https://github.com/nnnick/Chart.js/blob/master/LICENSE.md
 */
(function(){"use strict";var t=this,e=t.Chart,i=function(t,e){this.config=e,t.length&&t[0].getContext&&(t=t[0]),t.getContext&&(t=t.getContext("2d")),this.canvas=t.canvas,this.ctx=t;var a=function(t,e){return t["offset"+e]?t["offset"+e]:document.defaultView.getComputedStyle(t).getPropertyValue(e)},o=this.width=a(t.canvas,"Width")||t.canvas.width,s=this.height=a(t.canvas,"Height")||t.canvas.height;return t.canvas.width=o,t.canvas.height=s,o=this.width=t.canvas.width,s=this.height=t.canvas.height,this.aspectRatio=this.width/this.height,i.helpers.retinaScale(this),e?(this.controller=new i.Controller(this),this.controller):this};i.defaults={global:{responsive:!0,responsiveAnimationDuration:0,maintainAspectRatio:!0,events:["mousemove","mouseout","click","touchstart","touchmove","touchend"],hover:{onHover:null,mode:"single",animationDuration:400},onClick:null,defaultColor:"rgba(0,0,0,0.1)",elements:{}}},"undefined"!=typeof amd?define(function(){return i}):"object"==typeof module&&module.exports&&(module.exports=i),t.Chart=i,i.noConflict=function(){return t.Chart=e,i}}).call(this),function(){"use strict";var t=this,e=(t.Chart,Chart.helpers={}),i=e.each=function(t,e,i,a){var o=Array.prototype.slice.call(arguments,3);if(t)if(t.length===+t.length){var s;if(a)for(s=t.length-1;s>=0;s--)e.apply(i,[t[s],s].concat(o));else for(s=0;s<t.length;s++)e.apply(i,[t[s],s].concat(o))}else for(var n in t)e.apply(i,[t[n],n].concat(o))},a=e.clone=function(t){var o={};return i(t,function(i,s){t.hasOwnProperty(s)&&(e.isArray(i)?o[s]=i.slice(0):"object"==typeof i&&null!==i?o[s]=a(i):o[s]=i)}),o},o=e.extend=function(t){return i(Array.prototype.slice.call(arguments,1),function(e){i(e,function(i,a){e.hasOwnProperty(a)&&(t[a]=i)})}),t},s=(e.merge=function(t,e){var i=Array.prototype.slice.call(arguments,0);return i.unshift({}),o.apply(null,i)},e.configMerge=function(t){var i=a(t);return e.each(Array.prototype.slice.call(arguments,1),function(t){e.each(t,function(a,o){if(t.hasOwnProperty(o))if("scales"===o)i[o]=e.scaleMerge(i.hasOwnProperty(o)?i[o]:{},a);else if("scale"===o)i[o]=e.configMerge(i.hasOwnProperty(o)?i[o]:{},Chart.scaleService.getScaleDefaults(a.type),a);else if(i.hasOwnProperty(o)&&e.isArray(i[o])&&e.isArray(a)){var s=i[o];e.each(a,function(t,i){i<s.length?s[i]=e.configMerge(s[i],t):s.push(t)})}else i.hasOwnProperty(o)&&"object"==typeof i[o]&&null!==i[o]&&"object"==typeof a?i[o]=e.configMerge(i[o],a):i[o]=a})}),i},e.scaleMerge=function(t,i){var o=a(t);return e.each(i,function(t,a){i.hasOwnProperty(a)&&("xAxes"===a||"yAxes"===a?o.hasOwnProperty(a)?e.each(t,function(t,i){i>=o[a].length||!o[a][i].type?o[a].push(e.configMerge(t.type?Chart.scaleService.getScaleDefaults(t.type):{},t)):t.type!==o[a][i].type?o[a][i]=e.configMerge(o[a][i],t.type?Chart.scaleService.getScaleDefaults(t.type):{},t):o[a][i]=e.configMerge(o[a][i],t)}):(o[a]=[],e.each(t,function(t){o[a].push(e.configMerge(t.type?Chart.scaleService.getScaleDefaults(t.type):{},t))})):o.hasOwnProperty(a)&&"object"==typeof o[a]&&null!==o[a]&&"object"==typeof t?o[a]=e.configMerge(o[a],t):o[a]=t)}),o},e.getValueAtIndexOrDefault=function(t,i,a){return t?e.isArray(t)&&i<t.length?t[i]:t:a},e.indexOf=function(t,e){if(Array.prototype.indexOf)return t.indexOf(e);for(var i=0;i<t.length;i++)if(t[i]===e)return i;return-1},e.where=function(t,i){var a=[];return e.each(t,function(t){i(t)&&a.push(t)}),a},e.findNextWhere=function(t,e,i){i||(i=-1);for(var a=i+1;a<t.length;a++){var o=t[a];if(e(o))return o}},e.findPreviousWhere=function(t,e,i){i||(i=t.length);for(var a=i-1;a>=0;a--){var o=t[a];if(e(o))return o}},e.inherits=function(t){var e=this,i=t&&t.hasOwnProperty("constructor")?t.constructor:function(){return e.apply(this,arguments)},a=function(){this.constructor=i};return a.prototype=e.prototype,i.prototype=new a,i.extend=s,t&&o(i.prototype,t),i.__super__=e.prototype,i}),n=e.noop=function(){},r=(e.uid=function(){var t=0;return function(){return"chart-"+t++}}(),e.warn=function(t){window.console&&"function"==typeof window.console.warn&&console.warn(t)},e.amd="function"==typeof define&&define.amd,e.isNumber=function(t){return!isNaN(parseFloat(t))&&isFinite(t)}),h=e.max=function(t){return Math.max.apply(Math,t)},l=e.min=function(t){return Math.min.apply(Math,t)},c=(e.sign=function(t){return Math.sign?Math.sign(t):(t=+t,0===t||isNaN(t)?t:t>0?1:-1)},e.log10=function(t){return Math.log10?Math.log10(t):Math.log(t)/Math.LN10},e.cap=function(t,e,i){if(r(e)){if(t>e)return e}else if(r(i)&&i>t)return i;return t},e.getDecimalPlaces=function(t){if(t%1!==0&&r(t)){var e=t.toString();if(e.indexOf("e-")<0)return e.split(".")[1].length;if(e.indexOf(".")<0)return parseInt(e.split("e-")[1]);var i=e.split(".")[1].split("e-");return i[0].length+parseInt(i[1])}return 0},e.toRadians=function(t){return t*(Math.PI/180)},e.toDegrees=function(t){return t*(180/Math.PI)},e.getAngleFromPoint=function(t,e){var i=e.x-t.x,a=e.y-t.y,o=Math.sqrt(i*i+a*a),s=Math.atan2(a,i);return s<-.5*Math.PI&&(s+=2*Math.PI),{angle:s,distance:o}},e.aliasPixel=function(t){return t%2===0?0:.5},e.splineCurve=function(t,e,i,a){var o=Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2)),s=Math.sqrt(Math.pow(i.x-e.x,2)+Math.pow(i.y-e.y,2)),n=a*o/(o+s),r=a*s/(o+s);return{previous:{x:e.x-n*(i.x-t.x),y:e.y-n*(i.y-t.y)},next:{x:e.x+r*(i.x-t.x),y:e.y+r*(i.y-t.y)}}},e.nextItem=function(t,e,i){return i?t[e+1]||t[0]:t[e+1]||t[t.length-1]},e.previousItem=function(t,e,i){return i?t[e-1]||t[t.length-1]:t[e-1]||t[0]},e.calculateOrderOfMagnitude=function(t){return Math.floor(Math.log(t)/Math.LN10)}),u=(e.calculateScaleRange=function(t,e,i,a,o){var s=2,n=Math.floor(e/(1.5*i)),r=s>=n,u=h(t),d=l(t);u===d&&(u+=.5,d>=.5&&!a?d-=.5:u+=.5);for(var g=Math.abs(u-d),m=c(g),f=Math.ceil(u/(1*Math.pow(10,m)))*Math.pow(10,m),p=a?0:Math.floor(d/(1*Math.pow(10,m)))*Math.pow(10,m),v=f-p,b=Math.pow(10,m),x=Math.round(v/b);(x>n||n>2*x)&&!r;)if(x>n)b*=2,x=Math.round(v/b),x%1!==0&&(r=!0);else if(o&&m>=0){if(b/2%1!==0)break;b/=2,x=Math.round(v/b)}else b/=2,x=Math.round(v/b);return r&&(x=s,b=v/x),{steps:x,stepValue:b,min:p,max:p+x*b}},e.niceNum=function(t,i){var a,o=Math.floor(e.log10(t)),s=t/Math.pow(10,o);return a=i?1.5>s?1:3>s?2:7>s?5:10:1>=s?1:2>=s?2:5>=s?5:10,a*Math.pow(10,o)},e.template=function(t,e){function i(t,e){var i=/\W/.test(t)?new Function("obj","var p=[],print=function(){p.push.apply(p,arguments);};with(obj){p.push('"+t.replace(/[\r\t\n]/g," ").split("<%").join("	").replace(/((^|%>)[^\t]*)'/g,"$1\r").replace(/\t=(.*?)%>/g,"',$1,'").split("	").join("');").split("%>").join("p.push('").split("\r").join("\\'")+"');}return p.join('');"):a[t]=a[t];return e?i(e):i}if(t instanceof Function)return t(e);var a={};return i(t,e)}),d=(e.generateLabels=function(t,e,a,o){var s=new Array(e);return t&&i(s,function(e,i){s[i]=u(t,{value:a+o*(i+1)})}),s},e.easingEffects={linear:function(t){return t},easeInQuad:function(t){return t*t},easeOutQuad:function(t){return-1*t*(t-2)},easeInOutQuad:function(t){return(t/=.5)<1?.5*t*t:-0.5*(--t*(t-2)-1)},easeInCubic:function(t){return t*t*t},easeOutCubic:function(t){return 1*((t=t/1-1)*t*t+1)},easeInOutCubic:function(t){return(t/=.5)<1?.5*t*t*t:.5*((t-=2)*t*t+2)},easeInQuart:function(t){return t*t*t*t},easeOutQuart:function(t){return-1*((t=t/1-1)*t*t*t-1)},easeInOutQuart:function(t){return(t/=.5)<1?.5*t*t*t*t:-0.5*((t-=2)*t*t*t-2)},easeInQuint:function(t){return 1*(t/=1)*t*t*t*t},easeOutQuint:function(t){return 1*((t=t/1-1)*t*t*t*t+1)},easeInOutQuint:function(t){return(t/=.5)<1?.5*t*t*t*t*t:.5*((t-=2)*t*t*t*t+2)},easeInSine:function(t){return-1*Math.cos(t/1*(Math.PI/2))+1},easeOutSine:function(t){return 1*Math.sin(t/1*(Math.PI/2))},easeInOutSine:function(t){return-0.5*(Math.cos(Math.PI*t/1)-1)},easeInExpo:function(t){return 0===t?1:1*Math.pow(2,10*(t/1-1))},easeOutExpo:function(t){return 1===t?1:1*(-Math.pow(2,-10*t/1)+1)},easeInOutExpo:function(t){return 0===t?0:1===t?1:(t/=.5)<1?.5*Math.pow(2,10*(t-1)):.5*(-Math.pow(2,-10*--t)+2)},easeInCirc:function(t){return t>=1?t:-1*(Math.sqrt(1-(t/=1)*t)-1)},easeOutCirc:function(t){return 1*Math.sqrt(1-(t=t/1-1)*t)},easeInOutCirc:function(t){return(t/=.5)<1?-0.5*(Math.sqrt(1-t*t)-1):.5*(Math.sqrt(1-(t-=2)*t)+1)},easeInElastic:function(t){var e=1.70158,i=0,a=1;return 0===t?0:1==(t/=1)?1:(i||(i=.3),a<Math.abs(1)?(a=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/a),-(a*Math.pow(2,10*(t-=1))*Math.sin(2*(1*t-e)*Math.PI/i)))},easeOutElastic:function(t){var e=1.70158,i=0,a=1;return 0===t?0:1==(t/=1)?1:(i||(i=.3),a<Math.abs(1)?(a=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/a),a*Math.pow(2,-10*t)*Math.sin(2*(1*t-e)*Math.PI/i)+1)},easeInOutElastic:function(t){var e=1.70158,i=0,a=1;return 0===t?0:2==(t/=.5)?1:(i||(i=.3*1.5),a<Math.abs(1)?(a=1,e=i/4):e=i/(2*Math.PI)*Math.asin(1/a),1>t?-.5*a*Math.pow(2,10*(t-=1))*Math.sin(2*(1*t-e)*Math.PI/i):a*Math.pow(2,-10*(t-=1))*Math.sin(2*(1*t-e)*Math.PI/i)*.5+1)},easeInBack:function(t){var e=1.70158;return 1*(t/=1)*t*((e+1)*t-e)},easeOutBack:function(t){var e=1.70158;return 1*((t=t/1-1)*t*((e+1)*t+e)+1)},easeInOutBack:function(t){var e=1.70158;return(t/=.5)<1?.5*t*t*(((e*=1.525)+1)*t-e):.5*((t-=2)*t*(((e*=1.525)+1)*t+e)+2)},easeInBounce:function(t){return 1-d.easeOutBounce(1-t)},easeOutBounce:function(t){return(t/=1)<1/2.75?7.5625*t*t:2/2.75>t?1*(7.5625*(t-=1.5/2.75)*t+.75):2.5/2.75>t?1*(7.5625*(t-=2.25/2.75)*t+.9375):1*(7.5625*(t-=2.625/2.75)*t+.984375)},easeInOutBounce:function(t){return.5>t?.5*d.easeInBounce(2*t):.5*d.easeOutBounce(2*t-1)+.5}}),g=(e.requestAnimFrame=function(){return window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(t){return window.setTimeout(t,1e3/60)}}(),e.cancelAnimFrame=function(){return window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame||window.oCancelAnimationFrame||window.msCancelAnimationFrame||function(t){return window.clearTimeout(t,1e3/60)}}(),e.getRelativePosition=function(t){var e,i,a=t.originalEvent||t,o=t.currentTarget||t.srcElement,s=o.getBoundingClientRect();return a.touches?(e=a.touches[0].clientX-s.left,i=a.touches[0].clientY-s.top):(e=a.clientX-s.left,i=a.clientY-s.top),{x:e,y:i}},e.addEvent=function(t,e,i){t.addEventListener?t.addEventListener(e,i):t.attachEvent?t.attachEvent("on"+e,i):t["on"+e]=i}),m=e.removeEvent=function(t,e,i){t.removeEventListener?t.removeEventListener(e,i,!1):t.detachEvent?t.detachEvent("on"+e,i):t["on"+e]=n},f=(e.bindEvents=function(t,e,a){t.events||(t.events={}),i(e,function(e){t.events[e]=function(){a.apply(t,arguments)},g(t.chart.canvas,e,t.events[e])})},e.unbindEvents=function(t,e){i(e,function(e,i){m(t.chart.canvas,i,e)})},e.getMaximumWidth=function(t){var e=t.parentNode,i=parseInt(f(e,"padding-left"))+parseInt(f(e,"padding-right"));return e.clientWidth-i},e.getMaximumHeight=function(t){var e=t.parentNode,i=parseInt(f(e,"padding-bottom"))+parseInt(f(e,"padding-top"));return e.clientHeight-i},e.getStyle=function(t,e){return t.currentStyle?t.currentStyle[e]:document.defaultView.getComputedStyle(t,null).getPropertyValue(e)});e.getMaximumSize=e.getMaximumWidth,e.retinaScale=function(t){var e=t.ctx,i=t.canvas.width,a=t.canvas.height;window.devicePixelRatio&&(e.canvas.style.width=i+"px",e.canvas.style.height=a+"px",e.canvas.height=a*window.devicePixelRatio,e.canvas.width=i*window.devicePixelRatio,e.scale(window.devicePixelRatio,window.devicePixelRatio))},e.clear=function(t){t.ctx.clearRect(0,0,t.width,t.height)},e.fontString=function(t,e,i){return e+" "+t+"px "+i},e.longestText=function(t,e,a){t.font=e;var o=0;return i(a,function(e){var i=t.measureText(e).width;o=i>o?i:o}),o},e.drawRoundedRectangle=function(t,e,i,a,o,s){t.beginPath(),t.moveTo(e+s,i),t.lineTo(e+a-s,i),t.quadraticCurveTo(e+a,i,e+a,i+s),t.lineTo(e+a,i+o-s),t.quadraticCurveTo(e+a,i+o,e+a-s,i+o),t.lineTo(e+s,i+o),t.quadraticCurveTo(e,i+o,e,i+o-s),t.lineTo(e,i+s),t.quadraticCurveTo(e,i,e+s,i),t.closePath()},e.color=function(t){return window.Color?window.Color(t):(console.log("Color.js not found!"),t)},e.isArray=function(t){return Array.isArray?Array.isArray(t):"[object Array]"===Object.prototype.toString.call(arg)}}.call(this),function(){"use strict";var t=this,e=(t.Chart,Chart.helpers);Chart.elements={},Chart.Element=function(t){e.extend(this,t),this.initialize.apply(this,arguments)},e.extend(Chart.Element.prototype,{initialize:function(){},pivot:function(){return this._view||(this._view=e.clone(this._model)),this._start=e.clone(this._view),this},transition:function(t){return this._view||(this._view=e.clone(this._model)),this._start||this.pivot(),e.each(this._model,function(i,a){if("_"!==a[0]&&this._model.hasOwnProperty(a))if(this._view[a])if(this._model[a]===this._view[a]);else if("string"==typeof i)try{var o=e.color(this._start[a]).mix(e.color(this._model[a]),t);this._view[a]=o.rgbString()}catch(s){this._view[a]=i}else if("number"==typeof i){var n=void 0!==this._start[a]?this._start[a]:0;this._view[a]=(this._model[a]-n)*t+n}else this._view[a]=i;else"number"==typeof i?this._view[a]=i*t:this._view[a]=i||null;else;},this),1===t&&delete this._start,this},tooltipPosition:function(){return{x:this._model.x,y:this._model.y}},hasValue:function(){return e.isNumber(this._model.x)&&e.isNumber(this._model.y)}}),Chart.Element.extend=e.inherits}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.defaults.global.animation={duration:1e3,easing:"easeOutQuart",onProgress:function(){},onComplete:function(){}},e.Animation=e.Element.extend({currentStep:null,numSteps:60,easing:"",render:null,onAnimationProgress:null,onAnimationComplete:null}),e.animationService={frameDuration:17,animations:[],dropFrames:0,addAnimation:function(t,e,a){("number"!=typeof a||0===a)&&(t.animating=!0);for(var o=0;o<this.animations.length;++o)if(this.animations[o].chartInstance===t)return void(this.animations[o].animationObject=e);this.animations.push({chartInstance:t,animationObject:e}),1==this.animations.length&&i.requestAnimFrame.call(window,this.digestWrapper)},cancelAnimation:function(t){var e=i.findNextWhere(this.animations,function(e){return e.chartInstance===t});e&&(this.animations.splice(e,1),t.animating=!1)},digestWrapper:function(){e.animationService.startDigest.call(e.animationService)},startDigest:function(){var t=Date.now(),e=0;this.dropFrames>1&&(e=Math.floor(this.dropFrames),this.dropFrames-=e);for(var a=0;a<this.animations.length;a++)null===this.animations[a].animationObject.currentStep&&(this.animations[a].animationObject.currentStep=0),this.animations[a].animationObject.currentStep+=1+e,this.animations[a].animationObject.currentStep>this.animations[a].animationObject.numSteps&&(this.animations[a].animationObject.currentStep=this.animations[a].animationObject.numSteps),this.animations[a].animationObject.render(this.animations[a].chartInstance,this.animations[a].animationObject),this.animations[a].animationObject.currentStep==this.animations[a].animationObject.numSteps&&(this.animations[a].chartInstance.animating=!1,this.animations.splice(a,1),a--);var o=Date.now(),s=o-t-this.frameDuration,n=s/this.frameDuration;n>1&&(this.dropFrames+=n),this.animations.length>0&&i.requestAnimFrame.call(window,this.digestWrapper)}}}.call(this),function(){"use strict";var t=this,e=(t.Chart,Chart.helpers);Chart.types={},Chart.instances={},Chart.controllers={},Chart.Controller=function(t){return this.chart=t,this.config=t.config,this.data=this.config.data,this.options=this.config.options=e.configMerge(Chart.defaults.global,Chart.defaults[this.config.type],this.config.options||{}),this.id=e.uid(),Chart.instances[this.id]=this,this.options.responsive&&this.resize(!0),this.initialize.call(this),this},e.extend(Chart.Controller.prototype,{initialize:function(){return this.bindEvents(),this.buildControllers(),this.buildScales(),this.resetElements(),this.initToolTip(),this.update(),this},clear:function(){return e.clear(this.chart),this},stop:function(){return Chart.animationService.cancelAnimation(this),this},resize:function(t){this.stop();var i=this.chart.canvas,a=e.getMaximumWidth(this.chart.canvas),o=this.options.maintainAspectRatio?a/this.chart.aspectRatio:e.getMaximumHeight(this.chart.canvas);return i.width=this.chart.width=a,i.height=this.chart.height=o,e.retinaScale(this.chart),t||this.update(this.options.responsiveAnimationDuration),this},buildScales:function(){if(this.scales={},this.options.scales&&(this.options.scales.xAxes&&this.options.scales.xAxes.length&&e.each(this.options.scales.xAxes,function(t){var e=Chart.scaleService.getScaleConstructor(t.type),i=new e({ctx:this.chart.ctx,options:t,data:this.data,id:t.id});this.scales[i.id]=i},this),this.options.scales.yAxes&&this.options.scales.yAxes.length&&e.each(this.options.scales.yAxes,function(t){var e=Chart.scaleService.getScaleConstructor(t.type),i=new e({ctx:this.chart.ctx,options:t,data:this.data,id:t.id});this.scales[i.id]=i},this)),this.options.scale){var t=Chart.scaleService.getScaleConstructor(this.options.scale.type),i=new t({ctx:this.chart.ctx,options:this.options.scale,data:this.data,chart:this.chart});this.scale=i}Chart.scaleService.fitScalesForChart(this,this.chart.width,this.chart.height)},buildControllers:function(){e.each(this.data.datasets,function(t,e){var i=t.type||this.config.type;return t.controller?void t.controller.updateIndex(e):void(t.controller=new Chart.controllers[i](this,e))},this)},resetElements:function(){e.each(this.data.datasets,function(t,e){t.controller.reset()},this)},update:function(t){Chart.scaleService.fitScalesForChart(this,this.chart.width,this.chart.height),e.each(this.data.datasets,function(t,e){t.controller.update()},this),this.render(t)},render:function(t){if(0!==this.options.animation.duration||t){var i=new Chart.Animation;i.numSteps=(t||this.options.animation.duration)/16.66,i.easing=this.options.animation.easing,i.render=function(t,i){var a=e.easingEffects[i.easing],o=i.currentStep/i.numSteps,s=a(o);t.draw(s,o,i.currentStep)},i.onAnimationProgress=this.options.onAnimationProgress,i.onAnimationComplete=this.options.onAnimationComplete,Chart.animationService.addAnimation(this,i,t)}else this.draw(),this.options.onAnimationComplete.call(this);return this},draw:function(t){var i=t||1;this.clear(),e.each(this.scales,function(t){t.draw(this.chartArea)},this),this.scale&&this.scale.draw(),e.each(this.data.datasets,function(e,i){e.controller.draw(t)},this,!0),this.tooltip.transition(i).draw()},getElementAtEvent:function(t){var i=e.getRelativePosition(t),a=[];return e.each(this.data.datasets,function(t,o){e.each(t.metaData,function(t,e){return t.inRange(i.x,i.y)?(a.push(t),a):void 0},this)},this),a},getElementsAtEvent:function(t){var i=e.getRelativePosition(t),a=[];return e.each(this.data.datasets,function(t,o){e.each(t.metaData,function(t,e){t.inLabelRange(i.x,i.y)&&a.push(t)},this)},this),a},getDatasetAtEvent:function(t){for(var i=e.getRelativePosition(t),a=[],o=0;o<this.chart.data.datasets.length;o++)for(elementIndex=0;elementIndex<this.chart.data.datasets[o].metaData.length;elementIndex++)this.chart.data.datasets[o].metaData[elementIndex].inLabelRange(i.x,i.y)&&e.each(this.chart.data.datasets,datasetIterator);return a.length?a:[]},generateLegend:function(){return template(this.options.legendTemplate,this)},destroy:function(){this.clear(),e.unbindEvents(this,this.events);var t=this.chart.canvas;t.width=this.chart.width,t.height=this.chart.height,t.style.removeProperty?(t.style.removeProperty("width"),t.style.removeProperty("height")):(t.style.removeAttribute("width"),t.style.removeAttribute("height")),delete Chart.instances[this.id]},toBase64Image:function(){return this.chart.canvas.toDataURL.apply(this.chart.canvas,arguments)},initToolTip:function(){this.tooltip=new Chart.Tooltip({_chart:this.chart,_data:this.data,_options:this.options},this)},bindEvents:function(){e.bindEvents(this,this.options.events,function(t){this.eventHandler(t)})},eventHandler:function(t){this.lastActive=this.lastActive||[],"mouseout"==t.type?this.active=[]:this.active=function(){switch(this.options.hover.mode){case"single":return this.getElementAtEvent(t);case"label":return this.getElementsAtEvent(t);case"dataset":return this.getDatasetAtEvent(t);default:return t}}.call(this),this.options.hover.onHover&&this.options.hover.onHover.call(this,this.active),("mouseup"==t.type||"click"==t.type)&&this.options.onClick&&this.options.onClick.call(this,t,this.active);if(this.lastActive.length)switch(this.options.hover.mode){case"single":this.data.datasets[this.lastActive[0]._datasetIndex].controller.removeHoverStyle(this.lastActive[0],this.lastActive[0]._datasetIndex,this.lastActive[0]._index);break;case"label":for(var i=0;i<this.lastActive.length;i++)this.data.datasets[this.lastActive[i]._datasetIndex].controller.removeHoverStyle(this.lastActive[i],this.lastActive[i]._datasetIndex,this.lastActive[i]._index);break;case"dataset":}if(this.active.length&&this.options.hover.mode)switch(this.options.hover.mode){case"single":this.data.datasets[this.active[0]._datasetIndex].controller.setHoverStyle(this.active[0]);break;case"label":for(var i=0;i<this.active.length;i++)this.data.datasets[this.active[i]._datasetIndex].controller.setHoverStyle(this.active[i]);break;case"dataset":}if(this.options.tooltips.enabled&&(this.tooltip.initialize(),this.active.length?(this.tooltip._model.opacity=1,e.extend(this.tooltip,{_active:this.active}),this.tooltip.update()):this.tooltip._model.opacity=0),this.tooltip.pivot(),!this.animating){var a;e.each(this.active,function(t,e){t!==this.lastActive[e]&&(a=!0)},this),(!this.lastActive.length&&this.active.length||this.lastActive.length&&!this.active.length||this.lastActive.length&&this.active.length&&a)&&(this.stop(),this.render(this.options.hover.animationDuration))}return this.lastActive=this.active,this}})}.call(this),function(){"use strict";var t=this,e=(t.Chart,Chart.helpers);e.addEvent(window,"resize",function(){var t;return function(){clearTimeout(t),t=setTimeout(function(){e.each(Chart.instances,function(t){t.options.responsive&&t.resize()})},16)}}())}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.scaleService={constructors:{},defaults:{},registerScaleType:function(t,e,i){this.constructors[t]=e,this.defaults[t]=i},getScaleConstructor:function(t){return this.constructors.hasOwnProperty(t)?this.constructors[t]:void 0},getScaleDefaults:function(t){return this.defaults.hasOwnProperty(t)?this.defaults[t]:{}},fitScalesForChart:function(t,e,a){var o=e>30?5:2,s=a>30?5:2;if(t){var n=i.where(t.scales,function(t){return"left"==t.options.position}),r=i.where(t.scales,function(t){return"right"==t.options.position}),h=i.where(t.scales,function(t){return"top"==t.options.position}),l=i.where(t.scales,function(t){return"bottom"==t.options.position}),c=e/2,u=a/2;c-=2*o,u-=2*s;var d=(e-c)/(n.length+r.length),g=(a-u)/(h.length+l.length),m=[],f=function(t){var e=t.fit(d,u);m.push({horizontal:!1,minSize:e,scale:t})},p=function(t){var e=t.fit(c,g);m.push({horizontal:!0,minSize:e,scale:t})};i.each(n,f),i.each(r,f),i.each(h,p),i.each(l,p);var v=a-2*s,b=e-2*o;i.each(m,function(t){t.horizontal?v-=t.minSize.height:b-=t.minSize.width});var x=function(t){var e=i.findNextWhere(m,function(e){return e.scale===t});e&&t.fit(e.minSize.width,v)},y=function(t){var e=i.findNextWhere(m,function(e){return e.scale===t}),a={left:w,right:C,top:0,bottom:0};e&&t.fit(b,e.minSize.height,a)},w=o,C=o,_=s,k=s;i.each(n,x),i.each(r,x),i.each(n,function(t){w+=t.width}),i.each(r,function(t){C+=t.width}),i.each(h,y),i.each(l,y),i.each(h,function(t){_+=t.height}),i.each(l,function(t){k+=t.height}),i.each(n,function(t){var e=i.findNextWhere(m,function(e){return e.scale===t}),a={left:0,right:0,top:_,bottom:k};e&&t.fit(e.minSize.width,v,a)}),i.each(r,function(t){var e=i.findNextWhere(m,function(e){return e.scale===t}),a={left:0,right:0,top:_,bottom:k};e&&t.fit(e.minSize.width,v,a)});var D=o,A=s,S=function(t){t.left=D,t.right=D+t.width,t.top=_,t.bottom=_+v,D=t.right},P=function(t){t.left=w,t.right=w+b,t.top=A,t.bottom=A+t.height,A=t.bottom};i.each(n,S),i.each(h,P),D+=b,A+=v,i.each(r,S),i.each(l,P),t.chartArea={left:w,top:_,right:w+b,bottom:_+v}}}}}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.defaults.global.tooltips={enabled:!0,custom:null,backgroundColor:"rgba(0,0,0,0.8)",fontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",fontSize:10,fontStyle:"normal",fontColor:"#fff",titleFontFamily:"'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",titleFontSize:12,titleFontStyle:"bold",titleFontColor:"#fff",yPadding:6,xPadding:6,caretSize:8,cornerRadius:6,xOffset:10,template:["<% if(label){ %>","<%=label %>: ","<% } %>","<%=value %>"].join(""),multiTemplate:["<%if (datasetLabel){ %>","<%=datasetLabel %>: ","<% } %>","<%=value %>"].join(""),multiKeyBackground:"#fff"},e.Tooltip=e.Element.extend({initialize:function(){var t=this._options;i.extend(this,{_model:{xPadding:t.tooltips.xPadding,yPadding:t.tooltips.yPadding,xOffset:t.tooltips.xOffset,textColor:t.tooltips.fontColor,_fontFamily:t.tooltips.fontFamily,_fontStyle:t.tooltips.fontStyle,fontSize:t.tooltips.fontSize,titleTextColor:t.tooltips.titleFontColor,_titleFontFamily:t.tooltips.titleFontFamily,_titleFontStyle:t.tooltips.titleFontStyle,titleFontSize:t.tooltips.titleFontSize,caretHeight:t.tooltips.caretSize,cornerRadius:t.tooltips.cornerRadius,backgroundColor:t.tooltips.backgroundColor,opacity:0,legendColorBackground:t.tooltips.multiKeyBackground}})},update:function(){var t=this._chart.ctx;switch(this._options.hover.mode){case"single":i.extend(this._model,{text:i.template(this._options.tooltips.template,{element:this._active[0],value:this._data.datasets[this._active[0]._datasetIndex].data[this._active[0]._index],label:this._data.labels?this._data.labels[this._active[0]._index]:""})});var e=this._active[0].tooltipPosition();i.extend(this._model,{x:Math.round(e.x),y:Math.round(e.y),caretPadding:e.padding});break;case"label":for(var a,o,s=[],n=[],r=this._data.datasets.length-1;r>=0&&(a=this._data.datasets[r].metaData,o=i.indexOf(a,this._active[0]),-1===o);r--);var h=function(t){var e,a,r,h,l,c=[],u=[],d=[];return i.each(this._data.datasets,function(t){e=t.metaData,e[o]&&e[o].hasValue()&&c.push(e[o])},this),i.each(this._options.stacked?c.reverse():c,function(t){u.push(t._view.x),d.push(t._view.y),s.push(i.template(this._options.tooltips.multiTemplate,{element:t,datasetLabel:this._data.datasets[t._datasetIndex].label,value:this._data.datasets[t._datasetIndex].data[t._index]})),n.push({fill:t._view.backgroundColor,stroke:t._view.borderColor})},this),l=i.min(d),r=i.max(d),h=i.min(u),a=i.max(u),{x:h>this._chart.width/2?h:a,y:(l+r)/2}}.call(this,o);i.extend(this._model,{x:h.x,y:h.y,labels:s,title:this._data.labels&&this._data.labels.length?this._data.labels[this._active[0]._index]:"",legendColors:n,legendBackgroundColor:this._options.tooltips.multiKeyBackground}),this._model.height=s.length*this._model.fontSize+(s.length-1)*(this._model.fontSize/2)+2*this._model.yPadding+1.5*this._model.titleFontSize;var l=t.measureText(this.title).width,c=i.longestText(t,this.font,s)+this._model.fontSize+3,u=i.max([c,l]);this._model.width=u+2*this._model.xPadding;var d=this._model.height/2;this._model.y-d<0?this._model.y=d:this._model.y+d>this._chart.height&&(this._model.y=this._chart.height-d),this._model.x>this._chart.width/2?this._model.x-=this._model.xOffset+this._model.width:this._model.x+=this._model.xOffset}return this},draw:function(){var t=this._chart.ctx,e=this._view;switch(this._options.hover.mode){case"single":t.font=i.fontString(e.fontSize,e._fontStyle,e._fontFamily),e.xAlign="center",e.yAlign="above";var a=e.caretPadding||2,o=t.measureText(e.text).width+2*e.xPadding,s=e.fontSize+2*e.yPadding,n=s+e.caretHeight+a;e.x+o/2>this._chart.width?e.xAlign="left":e.x-o/2<0&&(e.xAlign="right"),e.y-n<0&&(e.yAlign="below");var r=e.x-o/2,h=e.y-n;if(t.fillStyle=i.color(e.backgroundColor).alpha(e.opacity).rgbString(),this._custom)this._custom(this._view);else{switch(e.yAlign){case"above":t.beginPath(),t.moveTo(e.x,e.y-a),t.lineTo(e.x+e.caretHeight,e.y-(a+e.caretHeight)),t.lineTo(e.x-e.caretHeight,e.y-(a+e.caretHeight)),t.closePath(),t.fill();break;case"below":h=e.y+a+e.caretHeight,t.beginPath(),t.moveTo(e.x,e.y+a),t.lineTo(e.x+e.caretHeight,e.y+a+e.caretHeight),t.lineTo(e.x-e.caretHeight,e.y+a+e.caretHeight),t.closePath(),t.fill()}switch(e.xAlign){case"left":r=e.x-o+(e.cornerRadius+e.caretHeight);break;case"right":r=e.x-(e.cornerRadius+e.caretHeight)}i.drawRoundedRectangle(t,r,h,o,s,e.cornerRadius),t.fill(),t.fillStyle=i.color(e.textColor).alpha(e.opacity).rgbString(),t.textAlign="center",t.textBaseline="middle",t.fillText(e.text,r+o/2,h+s/2)}break;case"label":i.drawRoundedRectangle(t,e.x,e.y-e.height/2,e.width,e.height,e.cornerRadius),t.fillStyle=i.color(e.backgroundColor).alpha(e.opacity).rgbString(),t.fill(),t.closePath(),t.textAlign="left",t.textBaseline="middle",t.fillStyle=i.color(e.titleTextColor).alpha(e.opacity).rgbString(),t.font=i.fontString(e.fontSize,e._titleFontStyle,e._titleFontFamily),t.fillText(e.title,e.x+e.xPadding,this.getLineHeight(0)),t.font=i.fontString(e.fontSize,e._fontStyle,e._fontFamily),i.each(e.labels,function(a,o){t.fillStyle=i.color(e.textColor).alpha(e.opacity).rgbString(),t.fillText(a,e.x+e.xPadding+e.fontSize+3,this.getLineHeight(o+1)),t.fillStyle=i.color(e.legendColors[o].stroke).alpha(e.opacity).rgbString(),t.fillRect(e.x+e.xPadding-1,this.getLineHeight(o+1)-e.fontSize/2-1,e.fontSize+2,e.fontSize+2),t.fillStyle=i.color(e.legendColors[o].fill).alpha(e.opacity).rgbString(),t.fillRect(e.x+e.xPadding,this.getLineHeight(o+1)-e.fontSize/2,e.fontSize,e.fontSize)},this)}},getLineHeight:function(t){var e=this._view.y-this._view.height/2+this._view.yPadding,i=t-1;return 0===t?e+this._view.titleFontSize/2:e+(1.5*this._view.fontSize*i+this._view.fontSize/2)+1.5*this._view.titleFontSize}})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.defaults.bar={hover:{mode:"label"},scales:{xAxes:[{type:"category",categorySpacing:10,spacing:1,gridLines:{offsetGridLines:!0}}],yAxes:[{type:"linear"}]}},e.controllers.bar=function(t,e){this.initialize.call(this,t,e)},i.extend(e.controllers.bar.prototype,{initialize:function(t,e){this.chart=t,this.index=e,this.linkScales(),this.addElements()},linkScales:function(){this.getDataset().xAxisID||(this.getDataset().xAxisID=this.chart.options.scales.xAxes[0].id),this.getDataset().yAxisID||(this.getDataset().yAxisID=this.chart.options.scales.yAxes[0].id)},getDataset:function(){return this.chart.data.datasets[this.index]},getScaleForId:function(t){return this.chart.scales[t]},addElements:function(){this.getDataset().metaData=this.getDataset().metaData||[],i.each(this.getDataset().data,function(t,i){this.getDataset().metaData[i]=this.getDataset().metaData[i]||new e.elements.Rectangle({_chart:this.chart.chart,_datasetIndex:this.index,_index:i})},this)},reset:function(){this.update(!0)},update:function(t){var e=this.getScaleForId(this.getDataset().xAxisID),a=this.getScaleForId(this.getDataset().yAxisID);i.each(this.getDataset().metaData,function(o,s){var n;n=a.getPixelForValue(a.min<0&&a.max<0?a.max:a.min>0&&a.max>0?a.min:0),i.extend(o,{_chart:this.chart.chart,_xScale:e,_yScale:a,_datasetIndex:this.index,_index:s,_model:{x:e.calculateBarX(this.chart.data.datasets.length,this.index,s),y:t?n:a.calculateBarY(this.index,s),label:this.chart.data.labels[s],datasetLabel:this.getDataset().label,base:a.calculateBarBase(this.index,s),width:e.calculateBarWidth(this.chart.data.datasets.length),backgroundColor:o.custom&&o.custom.backgroundColor?o.custom.backgroundColor:i.getValueAtIndexOrDefault(this.getDataset().backgroundColor,s,this.chart.options.elements.rectangle.backgroundColor),borderColor:o.custom&&o.custom.borderColor?o.custom.borderColor:i.getValueAtIndexOrDefault(this.getDataset().borderColor,s,this.chart.options.elements.rectangle.borderColor),borderWidth:o.custom&&o.custom.borderWidth?o.custom.borderWidth:i.getValueAtIndexOrDefault(this.getDataset().borderWidth,s,this.chart.options.elements.rectangle.borderWidth)
}}),o.pivot()},this)},draw:function(t){var e=t||1;i.each(this.getDataset().metaData,function(t,i){t.transition(e).draw()},this)},setHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],a=t._index;t._model.backgroundColor=t.custom&&t.custom.hoverBackgroundColor?t.custom.hoverBackgroundColor:i.getValueAtIndexOrDefault(e.hoverBackgroundColor,a,i.color(t._model.backgroundColor).saturate(.5).darken(.1).rgbString()),t._model.borderColor=t.custom&&t.custom.hoverBorderColor?t.custom.hoverBorderColor:i.getValueAtIndexOrDefault(e.hoverBorderColor,a,i.color(t._model.borderColor).saturate(.5).darken(.1).rgbString()),t._model.borderWidth=t.custom&&t.custom.hoverBorderWidth?t.custom.hoverBorderWidth:i.getValueAtIndexOrDefault(e.borderWidth,a,t._model.borderWidth)},removeHoverStyle:function(t){var e=(this.chart.data.datasets[t._datasetIndex],t._index);t._model.backgroundColor=t.custom&&t.custom.backgroundColor?t.custom.backgroundColor:i.getValueAtIndexOrDefault(this.getDataset().backgroundColor,e,this.chart.options.elements.rectangle.backgroundColor),t._model.borderColor=t.custom&&t.custom.borderColor?t.custom.borderColor:i.getValueAtIndexOrDefault(this.getDataset().borderColor,e,this.chart.options.elements.rectangle.borderColor),t._model.borderWidth=t.custom&&t.custom.borderWidth?t.custom.borderWidth:i.getValueAtIndexOrDefault(this.getDataset().borderWidth,e,this.chart.options.elements.rectangle.borderWidth)}})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.defaults.doughnut={animation:{animateRotate:!0,animateScale:!1},hover:{mode:"single"},cutoutPercentage:50},e.defaults.pie=i.clone(e.defaults.doughnut),i.extend(e.defaults.pie,{cutoutPercentage:0}),e.controllers.doughnut=e.controllers.pie=function(t,e){this.initialize.call(this,t,e)},i.extend(e.controllers.doughnut.prototype,{initialize:function(t,e){this.chart=t,this.index=e,this.linkScales(),this.addElements()},linkScales:function(){},getDataset:function(){return this.chart.data.datasets[this.index]},getScaleForId:function(t){return this.chart.scales[t]},addElements:function(){this.getDataset().metaData=this.getDataset().metaData||[],i.each(this.getDataset().data,function(t,i){this.getDataset().metaData[i]=this.getDataset().metaData[i]||new e.elements.Arc({_chart:this.chart.chart,_datasetIndex:this.index,_index:i})},this)},reset:function(){this.update(!0)},update:function(t){this.chart.outerRadius=(i.min([this.chart.chart.width,this.chart.chart.height])-this.chart.options.elements.arc.borderWidth/2)/2,this.chart.innerRadius=this.chart.options.cutoutPercentage?this.chart.outerRadius/100*this.chart.options.cutoutPercentage:1,this.chart.radiusLength=(this.chart.outerRadius-this.chart.innerRadius)/this.chart.data.datasets.length,this.getDataset().total=0,i.each(this.getDataset().data,function(t){this.getDataset().total+=Math.abs(t)},this),this.outerRadius=this.chart.outerRadius-this.chart.radiusLength*this.index,this.innerRadius=this.outerRadius-this.chart.radiusLength,i.each(this.getDataset().metaData,function(e,a){var o={x:this.chart.chart.width/2,y:this.chart.chart.height/2,startAngle:Math.PI*-.5,circumference:this.chart.options.animation.animateRotate?0:this.calculateCircumference(this.getDataset().data[a]),outerRadius:this.chart.options.animation.animateScale?0:this.outerRadius,innerRadius:this.chart.options.animation.animateScale?0:this.innerRadius};i.extend(e,{_chart:this.chart.chart,_datasetIndex:this.index,_index:a,_model:t?o:{x:this.chart.chart.width/2,y:this.chart.chart.height/2,circumference:this.calculateCircumference(this.getDataset().data[a]),outerRadius:this.outerRadius,innerRadius:this.innerRadius,backgroundColor:e.custom&&e.custom.backgroundColor?e.custom.backgroundColor:i.getValueAtIndexOrDefault(this.getDataset().backgroundColor,a,this.chart.options.elements.arc.backgroundColor),hoverBackgroundColor:e.custom&&e.custom.hoverBackgroundColor?e.custom.hoverBackgroundColor:i.getValueAtIndexOrDefault(this.getDataset().hoverBackgroundColor,a,this.chart.options.elements.arc.hoverBackgroundColor),borderWidth:e.custom&&e.custom.borderWidth?e.custom.borderWidth:i.getValueAtIndexOrDefault(this.getDataset().borderWidth,a,this.chart.options.elements.arc.borderWidth),borderColor:e.custom&&e.custom.borderColor?e.custom.borderColor:i.getValueAtIndexOrDefault(this.getDataset().borderColor,a,this.chart.options.elements.arc.borderColor),label:i.getValueAtIndexOrDefault(this.getDataset().label,a,this.chart.data.labels[a])}}),t||(0===a?e._model.startAngle=Math.PI*-.5:e._model.startAngle=this.getDataset().metaData[a-1]._model.endAngle,e._model.endAngle=e._model.startAngle+e._model.circumference,a<this.getDataset().data.length-1&&(this.getDataset().metaData[a+1]._model.startAngle=e._model.endAngle)),e.pivot()},this)},draw:function(t){var e=t||1;i.each(this.getDataset().metaData,function(t,i){t.transition(e).draw()},this)},setHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],a=t._index;t._model.backgroundColor=t.custom&&t.custom.hoverBackgroundColor?t.custom.hoverBackgroundColor:i.getValueAtIndexOrDefault(e.hoverBackgroundColor,a,i.color(t._model.backgroundColor).saturate(.5).darken(.1).rgbString()),t._model.borderColor=t.custom&&t.custom.hoverBorderColor?t.custom.hoverBorderColor:i.getValueAtIndexOrDefault(e.hoverBorderColor,a,i.color(t._model.borderColor).saturate(.5).darken(.1).rgbString()),t._model.borderWidth=t.custom&&t.custom.hoverBorderWidth?t.custom.hoverBorderWidth:i.getValueAtIndexOrDefault(e.borderWidth,a,t._model.borderWidth)},removeHoverStyle:function(t){var e=(this.chart.data.datasets[t._datasetIndex],t._index);t._model.backgroundColor=t.custom&&t.custom.backgroundColor?t.custom.backgroundColor:i.getValueAtIndexOrDefault(this.getDataset().backgroundColor,e,this.chart.options.elements.arc.backgroundColor),t._model.borderColor=t.custom&&t.custom.borderColor?t.custom.borderColor:i.getValueAtIndexOrDefault(this.getDataset().borderColor,e,this.chart.options.elements.arc.borderColor),t._model.borderWidth=t.custom&&t.custom.borderWidth?t.custom.borderWidth:i.getValueAtIndexOrDefault(this.getDataset().borderWidth,e,this.chart.options.elements.arc.borderWidth)},calculateCircumference:function(t){return this.getDataset().total>0?1.999999*Math.PI*(t/this.getDataset().total):0}})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.defaults.line={hover:{mode:"label"},scales:{xAxes:[{type:"category"}],yAxes:[{type:"linear"}]}},e.controllers.line=function(t,e){this.initialize.call(this,t,e)},i.extend(e.controllers.line.prototype,{initialize:function(t,e){this.chart=t,this.index=e,this.linkScales(),this.addElements()},linkScales:function(){this.getDataset().xAxisID||(this.getDataset().xAxisID=this.chart.options.scales.xAxes[0].id),this.getDataset().yAxisID||(this.getDataset().yAxisID=this.chart.options.scales.yAxes[0].id)},getDataset:function(){return this.chart.data.datasets[this.index]},getScaleForId:function(t){return this.chart.scales[t]},addElements:function(){this.getDataset().metaData=this.getDataset().metaData||[],this.getDataset().metaDataset=this.getDataset().metaDataset||new e.elements.Line({_chart:this.chart.chart,_datasetIndex:this.index,_points:this.getDataset().metaData}),i.each(this.getDataset().data,function(t,i){this.getDataset().metaData[i]=this.getDataset().metaData[i]||new e.elements.Point({_chart:this.chart.chart,_datasetIndex:this.index,_index:i})},this)},reset:function(){this.update(!0)},update:function(t){var e,a=this.getDataset().metaDataset,o=this.getDataset().metaData,s=this.getScaleForId(this.getDataset().yAxisID),n=this.getScaleForId(this.getDataset().xAxisID);e=s.getPixelForValue(s.min<0&&s.max<0?s.max:s.min>0&&s.max>0?s.min:0),i.extend(a,{_scale:s,_datasetIndex:this.index,_children:o,_model:{tension:a.custom&&a.custom.tension?a.custom.tension:this.getDataset().tension||this.chart.options.elements.line.tension,backgroundColor:a.custom&&a.custom.backgroundColor?a.custom.backgroundColor:this.getDataset().backgroundColor||this.chart.options.elements.line.backgroundColor,borderWidth:a.custom&&a.custom.borderWidth?a.custom.borderWidth:this.getDataset().borderWidth||this.chart.options.elements.line.borderWidth,borderColor:a.custom&&a.custom.borderColor?a.custom.borderColor:this.getDataset().borderColor||this.chart.options.elements.line.borderColor,fill:a.custom&&a.custom.fill?a.custom.fill:void 0!==this.getDataset().fill?this.getDataset().fill:this.chart.options.elements.line.fill,skipNull:void 0!==this.getDataset().skipNull?this.getDataset().skipNull:this.chart.options.elements.line.skipNull,drawNull:void 0!==this.getDataset().drawNull?this.getDataset().drawNull:this.chart.options.elements.line.drawNull,scaleTop:s.top,scaleBottom:s.bottom,scaleZero:e}}),a.pivot(),i.each(o,function(a,o){i.extend(a,{_chart:this.chart.chart,_xScale:n,_yScale:s,_datasetIndex:this.index,_index:o,_model:{x:n.getPointPixelForValue(this.getDataset().data[o],o,this.index),y:t?e:s.getPointPixelForValue(this.getDataset().data[o],o,this.index),tension:a.custom&&a.custom.tension?a.custom.tension:this.chart.options.elements.line.tension,radius:a.custom&&a.custom.radius?a.custom.radius:i.getValueAtIndexOrDefault(this.getDataset().radius,o,this.chart.options.elements.point.radius),backgroundColor:a.custom&&a.custom.backgroundColor?a.custom.backgroundColor:i.getValueAtIndexOrDefault(this.getDataset().pointBackgroundColor,o,this.chart.options.elements.point.backgroundColor),borderColor:a.custom&&a.custom.borderColor?a.custom.borderColor:i.getValueAtIndexOrDefault(this.getDataset().pointBorderColor,o,this.chart.options.elements.point.borderColor),borderWidth:a.custom&&a.custom.borderWidth?a.custom.borderWidth:i.getValueAtIndexOrDefault(this.getDataset().pointBorderWidth,o,this.chart.options.elements.point.borderWidth),skip:null===this.getDataset().data[o],hitRadius:a.custom&&a.custom.hitRadius?a.custom.hitRadius:i.getValueAtIndexOrDefault(this.getDataset().hitRadius,o,this.chart.options.elements.point.hitRadius)}})},this),i.each(this.getDataset().metaData,function(t,e){var a=i.splineCurve(i.previousItem(this.getDataset().metaData,e)._model,t._model,i.nextItem(this.getDataset().metaData,e)._model,t._model.tension);t._model.controlPointPreviousX=a.previous.x,t._model.controlPointNextX=a.next.x,a.next.y>this.chart.chartArea.bottom?t._model.controlPointNextY=this.chart.chartArea.bottom:a.next.y<this.chart.chartArea.top?t._model.controlPointNextY=this.chart.chartArea.top:t._model.controlPointNextY=a.next.y,a.previous.y>this.chart.chartArea.bottom?t._model.controlPointPreviousY=this.chart.chartArea.bottom:a.previous.y<this.chart.chartArea.top?t._model.controlPointPreviousY=this.chart.chartArea.top:t._model.controlPointPreviousY=a.previous.y,t.pivot()},this)},draw:function(t){var e=t||1;i.each(this.getDataset().metaData,function(t,i){t.transition(e)},this),this.getDataset().metaDataset.transition(e).draw(),i.each(this.getDataset().metaData,function(t){t.draw()})},setHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],a=t._index;t._model.radius=t.custom&&t.custom.radius?t.custom.radius:i.getValueAtIndexOrDefault(e.pointHoverRadius,a,this.chart.options.elements.point.hoverRadius),t._model.backgroundColor=t.custom&&t.custom.hoverBackgroundColor?t.custom.hoverBackgroundColor:i.getValueAtIndexOrDefault(e.pointHoverBackgroundColor,a,i.color(t._model.backgroundColor).saturate(.5).darken(.1).rgbString()),t._model.borderColor=t.custom&&t.custom.hoverBorderColor?t.custom.hoverBorderColor:i.getValueAtIndexOrDefault(e.pointHoverBorderColor,a,i.color(t._model.borderColor).saturate(.5).darken(.1).rgbString()),t._model.borderWidth=t.custom&&t.custom.hoverBorderWidth?t.custom.hoverBorderWidth:i.getValueAtIndexOrDefault(e.pointBorderWidth,a,t._model.borderWidth)},removeHoverStyle:function(t){var e=(this.chart.data.datasets[t._datasetIndex],t._index);t._model.radius=t.custom&&t.custom.radius?t.custom.radius:i.getValueAtIndexOrDefault(this.getDataset().radius,e,this.chart.options.elements.point.radius),t._model.backgroundColor=t.custom&&t.custom.backgroundColor?t.custom.backgroundColor:i.getValueAtIndexOrDefault(this.getDataset().pointBackgroundColor,e,this.chart.options.elements.point.backgroundColor),t._model.borderColor=t.custom&&t.custom.borderColor?t.custom.borderColor:i.getValueAtIndexOrDefault(this.getDataset().pointBorderColor,e,this.chart.options.elements.point.borderColor),t._model.borderWidth=t.custom&&t.custom.borderWidth?t.custom.borderWidth:i.getValueAtIndexOrDefault(this.getDataset().pointBorderWidth,e,this.chart.options.elements.point.borderWidth)}})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.defaults.polarArea={scale:{type:"radialLinear",lineArc:!0},animateRotate:!0},e.controllers.polarArea=function(t,e){this.initialize.call(this,t,e)},i.extend(e.controllers.polarArea.prototype,{initialize:function(t,e){this.chart=t,this.index=e,this.linkScales(),this.addElements()},linkScales:function(){},getDataset:function(){return this.chart.data.datasets[this.index]},getScaleForId:function(t){return this.chart.scales[t]},addElements:function(){this.getDataset().metaData=this.getDataset().metaData||[],i.each(this.getDataset().data,function(t,i){this.getDataset().metaData[i]=this.getDataset().metaData[i]||new e.elements.Arc({_chart:this.chart.chart,_datasetIndex:this.index,_index:i})},this)},reset:function(){this.update(!0)},update:function(t){e.scaleService.fitScalesForChart(this,this.chart.width,this.chart.height),this.chart.scale.calculateRange(),this.chart.scale.generateTicks(),this.chart.scale.buildYLabels(),this.chart.outerRadius=(i.min([this.chart.chart.width,this.chart.chart.height])-this.chart.options.elements.arc.borderWidth/2)/2,this.chart.innerRadius=this.chart.options.cutoutPercentage?this.chart.outerRadius/100*this.chart.options.cutoutPercentage:1,this.chart.radiusLength=(this.chart.outerRadius-this.chart.innerRadius)/this.chart.data.datasets.length,this.getDataset().total=0,i.each(this.getDataset().data,function(t){this.getDataset().total+=Math.abs(t)},this),this.outerRadius=this.chart.outerRadius-this.chart.radiusLength*this.index,this.innerRadius=this.outerRadius-this.chart.radiusLength,i.each(this.getDataset().metaData,function(e,a){var o={x:this.chart.chart.width/2,y:this.chart.chart.height/2,innerRadius:0,outerRadius:0,startAngle:Math.PI*-.5,endAngle:Math.PI*-.5,backgroundColor:e.custom&&e.custom.backgroundColor?e.custom.backgroundColor:i.getValueAtIndexOrDefault(this.getDataset().backgroundColor,a,this.chart.options.elements.arc.backgroundColor),hoverBackgroundColor:e.custom&&e.custom.hoverBackgroundColor?e.custom.hoverBackgroundColor:i.getValueAtIndexOrDefault(this.getDataset().hoverBackgroundColor,a,this.chart.options.elements.arc.hoverBackgroundColor),borderWidth:e.custom&&e.custom.borderWidth?e.custom.borderWidth:i.getValueAtIndexOrDefault(this.getDataset().borderWidth,a,this.chart.options.elements.arc.borderWidth),borderColor:e.custom&&e.custom.borderColor?e.custom.borderColor:i.getValueAtIndexOrDefault(this.getDataset().borderColor,a,this.chart.options.elements.arc.borderColor),label:i.getValueAtIndexOrDefault(this.chart.data.labels,a,this.chart.data.labels[a])},s=1/this.getDataset().data.length*2,n=-.5*Math.PI+Math.PI*s*a,r=n+s*Math.PI;console.log(),i.extend(e,{_chart:this.chart.chart,_datasetIndex:this.index,_index:a,_model:t?o:{x:this.chart.chart.width/2,y:this.chart.chart.height/2,innerRadius:0,outerRadius:this.chart.scale.getDistanceFromCenterForValue(this.getDataset().data[a]),startAngle:n,endAngle:r,backgroundColor:e.custom&&e.custom.backgroundColor?e.custom.backgroundColor:i.getValueAtIndexOrDefault(this.getDataset().backgroundColor,a,this.chart.options.elements.arc.backgroundColor),hoverBackgroundColor:e.custom&&e.custom.hoverBackgroundColor?e.custom.hoverBackgroundColor:i.getValueAtIndexOrDefault(this.getDataset().hoverBackgroundColor,a,this.chart.options.elements.arc.hoverBackgroundColor),borderWidth:e.custom&&e.custom.borderWidth?e.custom.borderWidth:i.getValueAtIndexOrDefault(this.getDataset().borderWidth,a,this.chart.options.elements.arc.borderWidth),borderColor:e.custom&&e.custom.borderColor?e.custom.borderColor:i.getValueAtIndexOrDefault(this.getDataset().borderColor,a,this.chart.options.elements.arc.borderColor),label:i.getValueAtIndexOrDefault(this.chart.data.labels,a,this.chart.data.labels[a])}}),e.pivot()},this)},draw:function(t){var e=t||1;i.each(this.getDataset().metaData,function(t,i){t.transition(e).draw(),console.log(t)},this)},setHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],a=t._index;t._model.backgroundColor=t.custom&&t.custom.hoverBackgroundColor?t.custom.hoverBackgroundColor:i.getValueAtIndexOrDefault(e.hoverBackgroundColor,a,i.color(t._model.backgroundColor).saturate(.5).darken(.1).rgbString()),t._model.borderColor=t.custom&&t.custom.hoverBorderColor?t.custom.hoverBorderColor:i.getValueAtIndexOrDefault(e.hoverBorderColor,a,i.color(t._model.borderColor).saturate(.5).darken(.1).rgbString()),t._model.borderWidth=t.custom&&t.custom.hoverBorderWidth?t.custom.hoverBorderWidth:i.getValueAtIndexOrDefault(e.borderWidth,a,t._model.borderWidth)},removeHoverStyle:function(t){var e=(this.chart.data.datasets[t._datasetIndex],t._index);t._model.backgroundColor=t.custom&&t.custom.backgroundColor?t.custom.backgroundColor:i.getValueAtIndexOrDefault(this.getDataset().backgroundColor,e,this.chart.options.elements.arc.backgroundColor),t._model.borderColor=t.custom&&t.custom.borderColor?t.custom.borderColor:i.getValueAtIndexOrDefault(this.getDataset().borderColor,e,this.chart.options.elements.arc.borderColor),t._model.borderWidth=t.custom&&t.custom.borderWidth?t.custom.borderWidth:i.getValueAtIndexOrDefault(this.getDataset().borderWidth,e,this.chart.options.elements.arc.borderWidth)},calculateCircumference:function(t){return this.getDataset().total>0?2*Math.PI*(t/this.getDataset().total):0},updateScaleRange:function(){i.extend(this.chart.scale,{size:i.min([this.chart.width,this.chart.height]),xCenter:this.chart.width/2,yCenter:this.chart.height/2})}})}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.defaults.radar={scale:{type:"radialLinear"},elements:{line:{tension:0}}},e.controllers.radar=function(t,e){this.initialize.call(this,t,e)},i.extend(e.controllers.radar.prototype,{initialize:function(t,e){this.chart=t,this.index=e,this.linkScales(),this.addElements()},linkScales:function(){},getDataset:function(){return this.chart.data.datasets[this.index]},getScaleForId:function(t){return this.chart.scales[t]},addElements:function(){this.getDataset().metaData=this.getDataset().metaData||[],this.getDataset().metaDataset=this.getDataset().metaDataset||new e.elements.Line({_chart:this.chart.chart,_datasetIndex:this.index,_points:this.getDataset().metaData,_loop:!0}),i.each(this.getDataset().data,function(t,i){this.getDataset().metaData[i]=this.getDataset().metaData[i]||new e.elements.Point({_chart:this.chart.chart,_datasetIndex:this.index,_index:i,_model:{x:0,y:0}})},this)},reset:function(){this.update(!0)},update:function(t){var e,a=(this.getDataset().metaDataset,this.getDataset().metaData),o=this.chart.scale;o.setScaleSize(),o.calculateRange(),o.generateTicks(),o.buildYLabels(),e=o.min<0&&o.max<0?o.getPointPositionForValue(0,o.max):o.min>0&&o.max>0?o.getPointPositionForValue(0,o.min):o.getPointPositionForValue(0,0),i.extend(this.getDataset().metaDataset,{_datasetIndex:this.index,_children:this.getDataset().metaData,_model:{tension:this.getDataset().tension||this.chart.options.elements.line.tension,backgroundColor:this.getDataset().backgroundColor||this.chart.options.elements.line.backgroundColor,borderWidth:this.getDataset().borderWidth||this.chart.options.elements.line.borderWidth,borderColor:this.getDataset().borderColor||this.chart.options.elements.line.borderColor,fill:void 0!==this.getDataset().fill?this.getDataset().fill:this.chart.options.elements.line.fill,skipNull:void 0!==this.getDataset().skipNull?this.getDataset().skipNull:this.chart.options.elements.line.skipNull,drawNull:void 0!==this.getDataset().drawNull?this.getDataset().drawNull:this.chart.options.elements.line.drawNull,scaleTop:o.top,scaleBottom:o.bottom,scaleZero:e}}),this.getDataset().metaDataset.pivot(),i.each(a,function(e,a){var s=o.getPointPositionForValue(a,this.getDataset().data[a]);i.extend(e,{_datasetIndex:this.index,_index:a,_model:{x:t?o.xCenter:s.x,y:t?o.yCenter:s.y,tension:e.custom&&e.custom.tension?e.custom.tension:this.chart.options.elements.line.tension,radius:e.custom&&e.custom.radius?e.custom.pointRadius:i.getValueAtIndexOrDefault(this.getDataset().pointRadius,a,this.chart.options.elements.point.radius),backgroundColor:e.custom&&e.custom.backgroundColor?e.custom.backgroundColor:i.getValueAtIndexOrDefault(this.getDataset().pointBackgroundColor,a,this.chart.options.elements.point.backgroundColor),borderColor:e.custom&&e.custom.borderColor?e.custom.borderColor:i.getValueAtIndexOrDefault(this.getDataset().pointBorderColor,a,this.chart.options.elements.point.borderColor),borderWidth:e.custom&&e.custom.borderWidth?e.custom.borderWidth:i.getValueAtIndexOrDefault(this.getDataset().pointBorderWidth,a,this.chart.options.elements.point.borderWidth),skip:null===this.getDataset().data[a],hitRadius:e.custom&&e.custom.hitRadius?e.custom.hitRadius:i.getValueAtIndexOrDefault(this.getDataset().hitRadius,a,this.chart.options.elements.point.hitRadius)}})},this),i.each(this.getDataset().metaData,function(t,e){var a=i.splineCurve(i.previousItem(this.getDataset().metaData,e,!0)._model,t._model,i.nextItem(this.getDataset().metaData,e,!0)._model,t._model.tension);t._model.controlPointPreviousX=a.previous.x,t._model.controlPointNextX=a.next.x,a.next.y>this.chart.chartArea.bottom?t._model.controlPointNextY=this.chart.chartArea.bottom:a.next.y<this.chart.chartArea.top?t._model.controlPointNextY=this.chart.chartArea.top:t._model.controlPointNextY=a.next.y,a.previous.y>this.chart.chartArea.bottom?t._model.controlPointPreviousY=this.chart.chartArea.bottom:a.previous.y<this.chart.chartArea.top?t._model.controlPointPreviousY=this.chart.chartArea.top:t._model.controlPointPreviousY=a.previous.y,t.pivot()},this)},draw:function(t){var e=t||1;i.each(this.getDataset().metaData,function(t,i){t.transition(e)},this),this.getDataset().metaDataset.transition(e).draw(),i.each(this.getDataset().metaData,function(t){t.draw()})},setHoverStyle:function(t){var e=this.chart.data.datasets[t._datasetIndex],a=t._index;t._model.radius=t.custom&&t.custom.radius?t.custom.radius:i.getValueAtIndexOrDefault(e.pointHoverRadius,a,this.chart.options.elements.point.hoverRadius),t._model.backgroundColor=t.custom&&t.custom.hoverBackgroundColor?t.custom.hoverBackgroundColor:i.getValueAtIndexOrDefault(e.pointHoverBackgroundColor,a,i.color(t._model.backgroundColor).saturate(.5).darken(.1).rgbString()),t._model.borderColor=t.custom&&t.custom.hoverBorderColor?t.custom.hoverBorderColor:i.getValueAtIndexOrDefault(e.pointHoverBorderColor,a,i.color(t._model.borderColor).saturate(.5).darken(.1).rgbString()),t._model.borderWidth=t.custom&&t.custom.hoverBorderWidth?t.custom.hoverBorderWidth:i.getValueAtIndexOrDefault(e.pointBorderWidth,a,t._model.borderWidth)},removeHoverStyle:function(t){var e=(this.chart.data.datasets[t._datasetIndex],t._index);t._model.radius=t.custom&&t.custom.radius?t.custom.radius:i.getValueAtIndexOrDefault(this.getDataset().radius,e,this.chart.options.elements.point.radius),t._model.backgroundColor=t.custom&&t.custom.backgroundColor?t.custom.backgroundColor:i.getValueAtIndexOrDefault(this.getDataset().pointBackgroundColor,e,this.chart.options.elements.point.backgroundColor),t._model.borderColor=t.custom&&t.custom.borderColor?t.custom.borderColor:i.getValueAtIndexOrDefault(this.getDataset().pointBorderColor,e,this.chart.options.elements.point.borderColor),t._model.borderWidth=t.custom&&t.custom.borderWidth?t.custom.borderWidth:i.getValueAtIndexOrDefault(this.getDataset().pointBorderWidth,e,this.chart.options.elements.point.borderWidth)}})}.call(this),function(){"use strict";return}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers,a={display:!0,position:"bottom",id:"x-axis-1",gridLines:{show:!0,color:"rgba(0, 0, 0, 0.1)",lineWidth:1,drawOnChartArea:!0,drawTicks:!0,zeroLineWidth:1,zeroLineColor:"rgba(0,0,0,0.25)",offsetGridLines:!1},labels:{show:!0,template:"<%=value%>",fontSize:12,fontStyle:"normal",fontColor:"#666",fontFamily:"Helvetica Neue"}},o=e.Element.extend({isHorizontal:function(){return"top"==this.options.position||"bottom"==this.options.position},getPixelForValue:function(t,e,i,a){if(this.isHorizontal()){var o=(this.labelRotation>0,this.width-(this.paddingLeft+this.paddingRight)),s=o/Math.max(this.data.labels.length-(this.options.gridLines.offsetGridLines?0:1),1),n=s*e+this.paddingLeft;return this.options.gridLines.offsetGridLines&&a&&(n+=s/2),this.left+Math.round(n)}return this.top+e*(this.height/this.data.labels.length)},getPointPixelForValue:function(t,e,i){return this.getPixelForValue(t,e,i,!0)},calculateBaseWidth:function(){return this.getPixelForValue(null,1,0,!0)-this.getPixelForValue(null,0,0,!0)-2*this.options.categorySpacing},calculateBarWidth:function(t){var e=this.calculateBaseWidth()-(t-1)*this.options.spacing;return this.options.stacked?e:e/t},calculateBarX:function(t,e,i){var a=this.calculateBaseWidth(),o=this.getPixelForValue(null,i,e,!0)-a/2,s=this.calculateBarWidth(t);return this.options.stacked?o+s/2:o+s*e+e*this.options.spacing+s/2},calculateLabelRotation:function(t,e){var a=i.fontString(this.options.labels.fontSize,this.options.labels.fontStyle,this.options.labels.fontFamily);this.ctx.font=a;var o,s,n=this.ctx.measureText(this.data.labels[0]).width,r=this.ctx.measureText(this.data.labels[this.data.labels.length-1]).width;if(this.paddingRight=r/2+3,this.paddingLeft=n/2+3,this.labelRotation=0,this.options.display){var h,l,c=i.longestText(this.ctx,a,this.data.labels);this.labelWidth=c;for(var u=Math.floor(this.getPixelForValue(0,1)-this.getPixelForValue(0,0))-6;this.labelWidth>u&&0===this.labelRotation||this.labelWidth>u&&this.labelRotation<=90&&this.labelRotation>0;){if(h=Math.cos(i.toRadians(this.labelRotation)),l=Math.sin(i.toRadians(this.labelRotation)),o=h*n,s=h*r,o+this.options.labels.fontSize/2>this.yLabelWidth&&(this.paddingLeft=o+this.options.labels.fontSize/2),this.paddingRight=this.options.labels.fontSize/2,l*c>t){this.labelRotation--;break}this.labelRotation++,this.labelWidth=h*c}}else this.labelWidth=0,this.paddingRight=0,this.paddingLeft=0;e&&(this.paddingLeft-=e.left,this.paddingRight-=e.right,this.paddingLeft=Math.max(this.paddingLeft,0),this.paddingRight=Math.max(this.paddingRight,0))},fit:function(t,e,a){this.calculateLabelRotation(e,a);var o={width:0,height:0},s=i.fontString(this.options.labels.fontSize,this.options.labels.fontStyle,this.options.labels.fontFamily),n=i.longestText(this.ctx,s,this.data.labels);if(this.isHorizontal()?(o.width=t,this.width=t):this.options.display&&(o.width=Math.min(n+6,t)),this.isHorizontal()&&this.options.display){var r=Math.cos(i.toRadians(this.labelRotation))*n+1.5*this.options.labels.fontSize;o.height=Math.min(r,e)}else this.options.display&&(o.width=Math.min(n+6,t));return this.width=o.width,this.height=o.height,o},draw:function(t){if(this.options.display){var e;if(this.ctx.fillStyle=this.options.labels.fontColor,this.isHorizontal()){e=!0;var a="bottom"==this.options.position?this.top:this.bottom-10,o="bottom"==this.options.position?this.top+10:this.bottom,s=0!==this.labelRotation;i.each(this.data.labels,function(n,r){var h=this.getPixelForValue(n,r,null,!1),l=this.getPixelForValue(n,r,null,!0);this.options.gridLines.show&&(0===r?(this.ctx.lineWidth=this.options.gridLines.zeroLineWidth,this.ctx.strokeStyle=this.options.gridLines.zeroLineColor,e=!0):e&&(this.ctx.lineWidth=this.options.gridLines.lineWidth,this.ctx.strokeStyle=this.options.gridLines.color,e=!1),h+=i.aliasPixel(this.ctx.lineWidth),this.ctx.beginPath(),this.options.gridLines.drawTicks&&(this.ctx.moveTo(h,a),this.ctx.lineTo(h,o)),this.options.gridLines.drawOnChartArea&&(this.ctx.moveTo(h,t.top),this.ctx.lineTo(h,t.bottom)),this.ctx.stroke()),this.options.labels.show&&(this.ctx.save(),this.ctx.translate(l,s?this.top+12:this.top+8),this.ctx.rotate(-1*i.toRadians(this.labelRotation)),this.ctx.font=this.font,this.ctx.textAlign=s?"right":"center",this.ctx.textBaseline=s?"middle":"top",this.ctx.fillText(n,0,0),this.ctx.restore())},this)}else this.options.gridLines.show,this.options.labels.show}}});e.scaleService.registerScaleType("category",o,a)}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers,a={display:!0,position:"left",id:"y-axis-1",gridLines:{show:!0,color:"rgba(0, 0, 0, 0.1)",lineWidth:1,drawOnChartArea:!0,drawTicks:!0,zeroLineWidth:1,zeroLineColor:"rgba(0,0,0,0.25)"},reverse:!1,beginAtZero:!1,override:null,labels:{show:!0,template:"<%=value.toLocaleString()%>",fontSize:12,fontStyle:"normal",fontColor:"#666",fontFamily:"Helvetica Neue"}},o=e.Element.extend({isHorizontal:function(){return"top"==this.options.position||"bottom"==this.options.position},generateTicks:function(t,e){if(this.ticks=[],this.options.override)for(var a=0;a<=this.options.override.steps;++a){var o=this.options.override.start+a*this.options.override.stepWidth;ticks.push(o)}else{var s;if(s=this.isHorizontal()?Math.min(11,Math.ceil(t/50)):Math.min(11,Math.ceil(e/(2*this.options.labels.fontSize))),s=Math.max(2,s),this.options.beginAtZero){var n=i.sign(this.min),r=i.sign(this.max);0>n&&0>r?this.max=0:n>0&&r>0&&(this.min=0)}for(var h=i.niceNum(this.max-this.min,!1),l=i.niceNum(h/(s-1),!0),c=Math.floor(this.min/l)*l,u=Math.ceil(this.max/l)*l,d=c;u>=d;d+=l)this.ticks.push(d)}("left"==this.options.position||"right"==this.options.position)&&this.ticks.reverse(),this.max=i.max(this.ticks),this.min=i.min(this.ticks),this.options.reverse?(this.ticks.reverse(),this.start=this.max,this.end=this.min):(this.start=this.min,this.end=this.max)},buildLabels:function(){this.labels=[],i.each(this.ticks,function(t,e,a){var o;this.options.labels.userCallback?o=this.options.labels.userCallback(t,e,a):this.options.labels.template&&(o=i.template(this.options.labels.template,{value:t})),this.labels.push(o?o:"")},this)},getRightValue:function(t){return"object"==typeof t?this.isHorizontal()?t.x:t.y:t},getPixelForValue:function(t){var e,i=this.end-this.start;return e=this.isHorizontal()?this.left+this.width/i*(t-this.start):this.bottom-this.height/i*(t-this.start)},calculateRange:function(){this.min=null,this.max=null;var t=[],e=[];if(this.options.stacked){i.each(this.data.datasets,function(a){(this.isHorizontal()?a.xAxisID===this.id:a.yAxisID===this.id)&&i.each(a.data,function(i,a){var o=this.getRightValue(i);t[a]=t[a]||0,e[a]=e[a]||0,this.options.relativePoints?t[a]=100:0>o?e[a]+=o:t[a]+=o},this)},this);var a=t.concat(e);this.min=i.min(a),this.max=i.max(a)}else i.each(this.data.datasets,function(t){(this.isHorizontal()?t.xAxisID===this.id:t.yAxisID===this.id)&&i.each(t.data,function(t,e){var i=this.getRightValue(t);null===this.min?this.min=i:i<this.min&&(this.min=i),null===this.max?this.max=i:i>this.max&&(this.max=i)},this)},this);this.min===this.max&&(this.min--,this.max++)},getPointPixelForValue:function(t,e,i){var a=this.getRightValue(t);if(this.options.stacked){for(var o=0,s=0,n=0;i>n;++n)this.data.datasets[n].data[e]<0?s+=this.data.datasets[n].data[e]:o+=this.data.datasets[n].data[e];return this.getPixelForValue(0>a?s+a:o+a)}return this.getPixelForValue(a)},calculateBarBase:function(t,e){var i=0;if(this.options.stacked){var a=this.data.datasets[t].data[e];if(0>a)for(var o=0;t>o;o++)this.data.datasets[o].yAxisID===this.id&&(i+=this.data.datasets[o].data[e]<0?this.data.datasets[o].data[e]:0);else for(var s=0;t>s;s++)this.data.datasets[s].yAxisID===this.id&&(i+=this.data.datasets[s].data[e]>0?this.data.datasets[s].data[e]:0);return this.getPixelForValue(i)}return i=this.getPixelForValue(this.min),this.beginAtZero||this.min<=0&&this.max>=0||this.min>=0&&this.max<=0?(i=this.getPixelForValue(0),
i+=this.options.gridLines.lineWidth):this.min<0&&this.max<0&&(i=this.getPixelForValue(this.max)),i},calculateBarY:function(t,e){var i=this.data.datasets[t].data[e];if(this.options.stacked){for(var a=0,o=0,s=0;t>s;s++)this.data.datasets[s].data[e]<0?o+=this.data.datasets[s].data[e]||0:a+=this.data.datasets[s].data[e]||0;return this.getPixelForValue(0>i?o+i:a+i)}for(var n=0,r=t;r<this.data.datasets.length;r++)n+=r===t&&i?i:i;return this.getPixelForValue(i)},fit:function(t,e){this.calculateRange(),this.generateTicks(t,e),this.buildLabels();var a={width:0,height:0};if(this.isHorizontal()?a.width=t:a.width=this.options.gridLines.show&&this.options.display?10:0,this.isHorizontal()?a.height=this.options.gridLines.show&&this.options.display?10:0:a.height=e,this.options.labels.show&&this.options.display){var o=i.fontString(this.options.labels.fontSize,this.options.labels.fontStyle,this.options.labels.fontFamily);if(this.isHorizontal()){var s=(e-a.height,1.5*this.options.labels.fontSize);a.height=Math.min(e,a.height+s)}else{var n=t-a.width,r=i.longestText(this.ctx,o,this.labels);n>r?a.width+=r:a.width=t}}return this.width=a.width,this.height=a.height,a},draw:function(t){if(this.options.display){var e,a;if(this.ctx.fillStyle=this.options.labels.fontColor,this.isHorizontal()){if(this.options.gridLines.show){e=!0,a=void 0!==i.findNextWhere(this.ticks,function(t){return 0===t});var o="bottom"==this.options.position?this.top:this.bottom-5,s="bottom"==this.options.position?this.top+5:this.bottom;i.each(this.ticks,function(n,r){var h=this.getPixelForValue(n);0===n||!a&&0===r?(this.ctx.lineWidth=this.options.gridLines.zeroLineWidth,this.ctx.strokeStyle=this.options.gridLines.zeroLineColor,e=!0):e&&(this.ctx.lineWidth=this.options.gridLines.lineWidth,this.ctx.strokeStyle=this.options.gridLines.color,e=!1),h+=i.aliasPixel(this.ctx.lineWidth),this.ctx.beginPath(),this.options.gridLines.drawTicks&&(this.ctx.moveTo(h,o),this.ctx.lineTo(h,s)),this.options.gridLines.drawOnChartArea&&(this.ctx.moveTo(h,t.top),this.ctx.lineTo(h,t.bottom)),this.ctx.stroke()},this)}if(this.options.labels.show){var n;"top"==this.options.position?(n=this.bottom-10,this.ctx.textBaseline="bottom"):(n=this.top+10,this.ctx.textBaseline="top"),this.ctx.textAlign="center",this.ctx.font=i.fontString(this.options.labels.fontSize,this.options.labels.fontStyle,this.options.labels.fontFamily),i.each(this.labels,function(t,e){var i=this.getPixelForValue(this.ticks[e]);this.ctx.fillText(t,i,n)},this)}}else{if(this.options.gridLines.show){e=!0,a=void 0!==i.findNextWhere(this.ticks,function(t){return 0===t});var r="right"==this.options.position?this.left:this.right-5,h="right"==this.options.position?this.left+5:this.right;i.each(this.ticks,function(o,s){var n=this.getPixelForValue(o);0===o||!a&&0===s?(this.ctx.lineWidth=this.options.gridLines.zeroLineWidth,this.ctx.strokeStyle=this.options.gridLines.zeroLineColor,e=!0):e&&(this.ctx.lineWidth=this.options.gridLines.lineWidth,this.ctx.strokeStyle=this.options.gridLines.color,e=!1),n+=i.aliasPixel(this.ctx.lineWidth),this.ctx.beginPath(),this.options.gridLines.drawTicks&&(this.ctx.moveTo(r,n),this.ctx.lineTo(h,n)),this.options.gridLines.drawOnChartArea&&(this.ctx.moveTo(t.left,n),this.ctx.lineTo(t.right,n)),this.ctx.stroke()},this)}if(this.options.labels.show){var l;"left"==this.options.position?(l=this.right-10,this.ctx.textAlign="right"):(l=this.left+5,this.ctx.textAlign="left"),this.ctx.textBaseline="middle",this.ctx.font=i.fontString(this.options.labels.fontSize,this.options.labels.fontStyle,this.options.labels.fontFamily),i.each(this.labels,function(t,e){var i=this.getPixelForValue(this.ticks[e]);this.ctx.fillText(t,l,i)},this)}}}}});e.scaleService.registerScaleType("linear",o,a)}.call(this),function(){"use strict";var t=this,e=t.Chart,i=e.helpers,a={display:!0,animate:!0,lineArc:!1,gridLines:{show:!0,color:"rgba(0, 0, 0, 0.1)",lineWidth:1},angleLines:{show:!0,color:"rgba(0,0,0, 0.1)",lineWidth:1},beginAtZero:!0,labels:{show:!0,template:"<%=value.toLocaleString()%>",fontSize:12,fontStyle:"normal",fontColor:"#666",fontFamily:"Helvetica Neue",showLabelBackdrop:!0,backdropColor:"rgba(255,255,255,0.75)",backdropPaddingY:2,backdropPaddingX:2},pointLabels:{fontFamily:"'Arial'",fontStyle:"normal",fontSize:10,fontColor:"#666"}},o=e.Element.extend({initialize:function(){this.height=this.chart.height,this.width=this.chart.width,this.xCenter=this.chart.width/2,this.yCenter=this.chart.height/2,this.size=i.min([this.height,this.width]),this.valuesCount=this.data.labels.length,this.labels=this.data.labels,this.drawingArea=this.options.display?this.size/2-(this.options.labels.fontSize/2+this.options.labels.backdropPaddingY):this.size/2},update:function(){this.options.lineArc?this.drawingArea=this.options.display?this.size/2-(this.fontSize/2+this.backdropPaddingY):this.size/2:this.setScaleSize(),this.buildYLabels()},calculateRange:function(){this.min=null,this.max=null,i.each(this.data.datasets,function(t){i.each(t.data,function(t,e){null===this.min?this.min=t:t<this.min&&(this.min=t),null===this.max?this.max=t:t>this.max&&(this.max=t)},this)},this)},generateTicks:function(){if(this.ticks=[],this.options.override)for(var t=0;t<=this.options.override.steps;++t){var e=this.options.override.start+t*this.options.override.stepWidth;ticks.push(e)}else{var a=Math.min(11,Math.ceil(this.drawingArea/(2*this.options.labels.fontSize)));if(a=Math.max(2,a),this.options.beginAtZero){var o=i.sign(this.min),s=i.sign(this.max);0>o&&0>s?this.max=0:o>0&&s>0&&(this.min=0)}for(var n=i.niceNum(this.max-this.min,!1),r=i.niceNum(n/(a-1),!0),h=Math.floor(this.min/r)*r,l=Math.ceil(this.max/r)*r,c=h;l>=c;c+=r)this.ticks.push(c)}("left"==this.options.position||"right"==this.options.position)&&this.ticks.reverse(),this.max=i.max(this.ticks),this.min=i.min(this.ticks)},buildYLabels:function(){this.yLabels=[],i.each(this.ticks,function(t,e,a){var o;this.options.labels.userCallback?o=this.options.labels.userCallback(t,e,a):this.options.labels.template&&(o=i.template(this.options.labels.template,{value:t})),this.yLabels.push(o?o:"")},this)},getCircumference:function(){return 2*Math.PI/this.valuesCount},setScaleSize:function(){var t,e,a,o,s,n,r,h,l,c,u,d,g=i.min([this.height/2-this.options.pointLabels.fontSize-5,this.width/2]),m=this.width,f=0;for(this.ctx.font=i.fontString(this.options.pointLabels.fontSize,this.options.pointLabels.fontStyle,this.options.pointLabels.fontFamily),e=0;e<this.valuesCount;e++)t=this.getPointPosition(e,g),a=this.ctx.measureText(i.template(this.options.labels.template,{value:this.labels[e]})).width+5,0===e||e===this.valuesCount/2?(o=a/2,t.x+o>m&&(m=t.x+o,s=e),t.x-o<f&&(f=t.x-o,r=e)):e<this.valuesCount/2?t.x+a>m&&(m=t.x+a,s=e):e>this.valuesCount/2&&t.x-a<f&&(f=t.x-a,r=e);l=f,c=Math.ceil(m-this.width),n=this.getIndexAngle(s),h=this.getIndexAngle(r),u=c/Math.sin(n+Math.PI/2),d=l/Math.sin(h+Math.PI/2),u=i.isNumber(u)?u:0,d=i.isNumber(d)?d:0,this.drawingArea=g-(d+u)/2,this.setCenterPoint(d,u)},setCenterPoint:function(t,e){var i=this.width-e-this.drawingArea,a=t+this.drawingArea;this.xCenter=(a+i)/2,this.yCenter=this.height/2},getIndexAngle:function(t){var e=2*Math.PI/this.valuesCount;return t*e-Math.PI/2},getDistanceFromCenterForValue:function(t){var e=this.drawingArea/(this.max-this.min);return(t-this.min)*e},getPointPosition:function(t,e){var i=this.getIndexAngle(t);return{x:Math.cos(i)*e+this.xCenter,y:Math.sin(i)*e+this.yCenter}},getPointPositionForValue:function(t,e){return this.getPointPosition(t,this.getDistanceFromCenterForValue(e))},draw:function(){if(this.options.display){var t=this.ctx;if(i.each(this.yLabels,function(e,a){if(a>0){var o=this.getDistanceFromCenterForValue(this.ticks[a]),s=this.yCenter-o;if(this.options.gridLines.show)if(t.strokeStyle=this.options.gridLines.color,t.lineWidth=this.options.gridLines.lineWidth,this.options.lineArc)t.beginPath(),t.arc(this.xCenter,this.yCenter,o,0,2*Math.PI),t.closePath(),t.stroke();else{t.beginPath();for(var n=0;n<this.valuesCount;n++){var r=this.getPointPosition(n,this.getDistanceFromCenterForValue(this.ticks[a]));0===n?t.moveTo(r.x,r.y):t.lineTo(r.x,r.y)}t.closePath(),t.stroke()}if(this.options.labels.show){if(t.font=i.fontString(this.options.labels.fontSize,this.options.labels.fontStyle,this.options.labels.fontFamily),this.options.labels.showLabelBackdrop){var h=t.measureText(e).width;t.fillStyle=this.options.labels.backdropColor,t.fillRect(this.xCenter-h/2-this.options.labels.backdropPaddingX,s-this.fontSize/2-this.options.labels.backdropPaddingY,h+2*this.options.labels.backdropPaddingX,this.options.labels.fontSize+2*this.options.labels.backdropPaddingY)}t.textAlign="center",t.textBaseline="middle",t.fillStyle=this.options.labels.fontColor,t.fillText(e,this.xCenter,s)}}},this),!this.options.lineArc){t.lineWidth=this.options.angleLines.lineWidth,t.strokeStyle=this.options.angleLines.color;for(var e=this.valuesCount-1;e>=0;e--){if(this.options.angleLines.show){var a=this.getPointPosition(e,this.getDistanceFromCenterForValue(this.max));t.beginPath(),t.moveTo(this.xCenter,this.yCenter),t.lineTo(a.x,a.y),t.stroke(),t.closePath()}var o=this.getPointPosition(e,this.getDistanceFromCenterForValue(this.max)+5);t.font=i.fontString(this.options.pointLabels.fontSize,this.options.pointLabels.fontStyle,this.options.pointLabels.fontFamily),t.fillStyle=this.options.pointLabels.fontColor;var s=this.labels.length,n=this.labels.length/2,r=n/2,h=r>e||e>s-r,l=e===r||e===s-r;0===e?t.textAlign="center":e===n?t.textAlign="center":n>e?t.textAlign="left":t.textAlign="right",l?t.textBaseline="middle":h?t.textBaseline="bottom":t.textBaseline="top",t.fillText(this.labels[e],o.x,o.y)}}}}});e.scaleService.registerScaleType("radialLinear",o,a)}.call(this),/*!
 * Chart.js
 * http://chartjs.org/
 * Version: 2.0.0-alpha
 *
 * Copyright 2015 Nick Downie
 * Released under the MIT license
 * https://github.com/nnnick/Chart.js/blob/master/LICENSE.md
 */
function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.defaults.global.elements.arc={backgroundColor:e.defaults.global.defaultColor,borderColor:"#fff",borderWidth:2},e.elements.Arc=e.Element.extend({inLabelRange:function(t){var e=this._view;return e?Math.pow(t-e.x,2)<Math.pow(e.radius+e.hoverRadius,2):!1},inRange:function(t,e){var a=this._view,o=i.getAngleFromPoint(a,{x:t,y:e}),s=a.startAngle<-.5*Math.PI?a.startAngle+2*Math.PI:a.startAngle>1.5*Math.PI?a.startAngle-2*Math.PI:a.startAngle,n=a.endAngle<-.5*Math.PI?a.endAngle+2*Math.PI:a.endAngle>1.5*Math.PI?a.endAngle-2*Math.PI:a.endAngle,r=o.angle>=s&&o.angle<=n,h=o.distance>=a.innerRadius&&o.distance<=a.outerRadius;return r&&h},tooltipPosition:function(){var t=this._view,e=t.startAngle+(t.endAngle-t.startAngle)/2,i=(t.outerRadius-t.innerRadius)/2+t.innerRadius;return{x:t.x+Math.cos(e)*i,y:t.y+Math.sin(e)*i}},draw:function(){var t=this._chart.ctx,e=this._view;t.beginPath(),t.arc(e.x,e.y,e.outerRadius,e.startAngle,e.endAngle),t.arc(e.x,e.y,e.innerRadius,e.endAngle,e.startAngle,!0),t.closePath(),t.strokeStyle=e.borderColor,t.lineWidth=e.borderWidth,t.fillStyle=e.backgroundColor,t.fill(),t.lineJoin="bevel",e.borderWidth&&t.stroke()}})}.call(this),/*!
 * Chart.js
 * http://chartjs.org/
 * Version: 2.0.0-alpha
 *
 * Copyright 2015 Nick Downie
 * Released under the MIT license
 * https://github.com/nnnick/Chart.js/blob/master/LICENSE.md
 */
function(){"use strict";var t=this,e=t.Chart,i=e.helpers;e.defaults.global.elements.line={tension:.4,backgroundColor:e.defaults.global.defaultColor,borderWidth:3,borderColor:e.defaults.global.defaultColor,fill:!0,skipNull:!0,drawNull:!1},e.elements.Line=e.Element.extend({draw:function(){var t=this._view,a=this._chart.ctx,o=this._children[0],s=this._children[this._children.length-1];i.each(this._children,function(e,o){var s=i.previousItem(this._children,o),n=i.nextItem(this._children,o);return 0===o?void a.moveTo(e._view.x,e._view.y):(e._view.skip&&t.skipNull&&!this._loop?(a.lineTo(s._view.x,e._view.y),a.moveTo(n._view.x,e._view.y)):s._view.skip&&t.skipNull&&!this._loop&&(a.moveTo(e._view.x,s._view.y),a.lineTo(e._view.x,e._view.y)),void(s._view.skip&&t.skipNull?a.moveTo(e._view.x,e._view.y):t.tension>0?a.bezierCurveTo(s._view.controlPointNextX,s._view.controlPointNextY,e._view.controlPointPreviousX,e._view.controlPointPreviousY,e._view.x,e._view.y):a.lineTo(e._view.x,e._view.y)))},this),this._loop&&(t.tension>0&&!o._view.skip?a.bezierCurveTo(s._view.controlPointNextX,s._view.controlPointNextY,o._view.controlPointPreviousX,o._view.controlPointPreviousY,o._view.x,o._view.y):a.lineTo(o._view.x,o._view.y)),this._children.length>0&&t.fill&&(a.lineTo(this._children[this._children.length-1]._view.x,t.scaleZero),a.lineTo(this._children[0]._view.x,t.scaleZero),a.fillStyle=t.backgroundColor||e.defaults.global.defaultColor,a.closePath(),a.fill()),a.lineWidth=t.borderWidth||e.defaults.global.defaultColor,a.strokeStyle=t.borderColor||e.defaults.global.defaultColor,a.beginPath(),i.each(this._children,function(e,o){var s=i.previousItem(this._children,o),n=i.nextItem(this._children,o);return 0===o?void a.moveTo(e._view.x,e._view.y):e._view.skip&&t.skipNull&&!this._loop?(a.moveTo(s._view.x,e._view.y),void a.moveTo(n._view.x,e._view.y)):s._view.skip&&t.skipNull&&!this._loop?(a.moveTo(e._view.x,s._view.y),void a.moveTo(e._view.x,e._view.y)):s._view.skip&&t.skipNull?void a.moveTo(e._view.x,e._view.y):void(t.tension>0?a.bezierCurveTo(s._view.controlPointNextX,s._view.controlPointNextY,e._view.controlPointPreviousX,e._view.controlPointPreviousY,e._view.x,e._view.y):a.lineTo(e._view.x,e._view.y))},this),this._loop&&!o._view.skip&&(t.tension>0?a.bezierCurveTo(s._view.controlPointNextX,s._view.controlPointNextY,o._view.controlPointPreviousX,o._view.controlPointPreviousY,o._view.x,o._view.y):a.lineTo(o._view.x,o._view.y)),a.stroke()}})}.call(this),/*!
 * Chart.js
 * http://chartjs.org/
 * Version: 2.0.0-alpha
 *
 * Copyright 2015 Nick Downie
 * Released under the MIT license
 * https://github.com/nnnick/Chart.js/blob/master/LICENSE.md
 */
function(){"use strict";var t=this,e=t.Chart;e.helpers;e.defaults.global.elements.point={radius:3,backgroundColor:e.defaults.global.defaultColor,borderWidth:1,borderColor:e.defaults.global.defaultColor,hitRadius:1,hoverRadius:4,hoverBorderWidth:1},e.elements.Point=e.Element.extend({inRange:function(t,e){var i=this._view,a=i.hitRadius+i.radius;return Math.pow(t-i.x,2)+Math.pow(e-i.y,2)<Math.pow(a,2)},inLabelRange:function(t){var e=this._view;return e?Math.pow(t-e.x,2)<Math.pow(e.radius+e.hitRadius,2):!1},tooltipPosition:function(){var t=this._view;return{x:t.x,y:t.y,padding:t.radius+t.borderWidth}},draw:function(){var t=this._view,i=this._chart.ctx;t.skip||(t.radius>0||t.borderWidth>0)&&(i.beginPath(),i.arc(t.x,t.y,t.radius||e.defaults.global.elements.point.radius,0,2*Math.PI),i.closePath(),i.strokeStyle=t.borderColor||e.defaults.global.defaultColor,i.lineWidth=t.borderWidth||e.defaults.global.elements.point.borderWidth,i.fillStyle=t.backgroundColor||e.defaults.global.defaultColor,i.fill(),i.stroke())}})}.call(this),function(){"use strict";var t=this,e=t.Chart;e.helpers;e.defaults.global.elements.rectangle={backgroundColor:e.defaults.global.defaultColor,borderWidth:0,borderColor:e.defaults.global.defaultColor},e.elements.Rectangle=e.Element.extend({draw:function(){var t=this._chart.ctx,e=this._view,i=e.width/2,a=e.x-i,o=e.x+i,s=e.base-(e.base-e.y),n=e.borderWidth/2;e.borderWidth&&(a+=n,o-=n,s+=n),t.beginPath(),t.fillStyle=e.backgroundColor,t.strokeStyle=e.borderColor,t.lineWidth=e.borderWidth,t.moveTo(a,e.base),t.lineTo(a,s),t.lineTo(o,s),t.lineTo(o,e.base),t.fill(),e.borderWidth&&t.stroke()},height:function(){var t=this._view;return t.base-t.y},inRange:function(t,e){var i=this._view;return i.y<i.base?t>=i.x-i.width/2&&t<=i.x+i.width/2&&e>=i.y&&e<=i.base:t>=i.x-i.width/2&&t<=i.x+i.width/2&&e>=i.base&&e<=i.y},inLabelRange:function(t){var e=this._view;return t>=e.x-e.width/2&&t<=e.x+e.width/2},tooltipPosition:function(){var t=this._view;return t.y<t.base?{x:t.x,y:t.y}:{x:t.x,y:t.base}}})}.call(this),!function t(e,i,a){function o(n,r){if(!i[n]){if(!e[n]){var h="function"==typeof require&&require;if(!r&&h)return h(n,!0);if(s)return s(n,!0);var l=new Error("Cannot find module '"+n+"'");throw l.code="MODULE_NOT_FOUND",l}var c=i[n]={exports:{}};e[n][0].call(c.exports,function(t){var i=e[n][1][t];return o(i?i:t)},c,c.exports,t,e,i,a)}return i[n].exports}for(var s="function"==typeof require&&require,n=0;n<a.length;n++)o(a[n]);return o}({1:[function(t,e,i){!function(){var i=t("color-convert"),a=t("color-string"),o=function(t){if(t instanceof o)return t;if(!(this instanceof o))return new o(t);if(this.values={rgb:[0,0,0],hsl:[0,0,0],hsv:[0,0,0],hwb:[0,0,0],cmyk:[0,0,0,0],alpha:1},"string"==typeof t){var e=a.getRgba(t);if(e)this.setValues("rgb",e);else if(e=a.getHsla(t))this.setValues("hsl",e);else{if(!(e=a.getHwb(t)))throw new Error('Unable to parse color from string "'+t+'"');this.setValues("hwb",e)}}else if("object"==typeof t){var e=t;if(void 0!==e.r||void 0!==e.red)this.setValues("rgb",e);else if(void 0!==e.l||void 0!==e.lightness)this.setValues("hsl",e);else if(void 0!==e.v||void 0!==e.value)this.setValues("hsv",e);else if(void 0!==e.w||void 0!==e.whiteness)this.setValues("hwb",e);else{if(void 0===e.c&&void 0===e.cyan)throw new Error("Unable to parse color from object "+JSON.stringify(t));this.setValues("cmyk",e)}}};o.prototype={rgb:function(t){return this.setSpace("rgb",arguments)},hsl:function(t){return this.setSpace("hsl",arguments)},hsv:function(t){return this.setSpace("hsv",arguments)},hwb:function(t){return this.setSpace("hwb",arguments)},cmyk:function(t){return this.setSpace("cmyk",arguments)},rgbArray:function(){return this.values.rgb},hslArray:function(){return this.values.hsl},hsvArray:function(){return this.values.hsv},hwbArray:function(){return 1!==this.values.alpha?this.values.hwb.concat([this.values.alpha]):this.values.hwb},cmykArray:function(){return this.values.cmyk},rgbaArray:function(){var t=this.values.rgb;return t.concat([this.values.alpha])},hslaArray:function(){var t=this.values.hsl;return t.concat([this.values.alpha])},alpha:function(t){return void 0===t?this.values.alpha:(this.setValues("alpha",t),this)},red:function(t){return this.setChannel("rgb",0,t)},green:function(t){return this.setChannel("rgb",1,t)},blue:function(t){return this.setChannel("rgb",2,t)},hue:function(t){return this.setChannel("hsl",0,t)},saturation:function(t){return this.setChannel("hsl",1,t)},lightness:function(t){return this.setChannel("hsl",2,t)},saturationv:function(t){return this.setChannel("hsv",1,t)},whiteness:function(t){return this.setChannel("hwb",1,t)},blackness:function(t){return this.setChannel("hwb",2,t)},value:function(t){return this.setChannel("hsv",2,t)},cyan:function(t){return this.setChannel("cmyk",0,t)},magenta:function(t){return this.setChannel("cmyk",1,t)},yellow:function(t){return this.setChannel("cmyk",2,t)},black:function(t){return this.setChannel("cmyk",3,t)},hexString:function(){return a.hexString(this.values.rgb)},rgbString:function(){return a.rgbString(this.values.rgb,this.values.alpha)},rgbaString:function(){return a.rgbaString(this.values.rgb,this.values.alpha)},percentString:function(){return a.percentString(this.values.rgb,this.values.alpha)},hslString:function(){return a.hslString(this.values.hsl,this.values.alpha)},hslaString:function(){return a.hslaString(this.values.hsl,this.values.alpha)},hwbString:function(){return a.hwbString(this.values.hwb,this.values.alpha)},keyword:function(){return a.keyword(this.values.rgb,this.values.alpha)},rgbNumber:function(){return this.values.rgb[0]<<16|this.values.rgb[1]<<8|this.values.rgb[2]},luminosity:function(){for(var t=this.values.rgb,e=[],i=0;i<t.length;i++){var a=t[i]/255;e[i]=.03928>=a?a/12.92:Math.pow((a+.055)/1.055,2.4)}return.2126*e[0]+.7152*e[1]+.0722*e[2]},contrast:function(t){var e=this.luminosity(),i=t.luminosity();return e>i?(e+.05)/(i+.05):(i+.05)/(e+.05)},level:function(t){var e=this.contrast(t);return e>=7.1?"AAA":e>=4.5?"AA":""},dark:function(){var t=this.values.rgb,e=(299*t[0]+587*t[1]+114*t[2])/1e3;return 128>e},light:function(){return!this.dark()},negate:function(){for(var t=[],e=0;3>e;e++)t[e]=255-this.values.rgb[e];return this.setValues("rgb",t),this},lighten:function(t){return this.values.hsl[2]+=this.values.hsl[2]*t,this.setValues("hsl",this.values.hsl),this},darken:function(t){return this.values.hsl[2]-=this.values.hsl[2]*t,this.setValues("hsl",this.values.hsl),this},saturate:function(t){return this.values.hsl[1]+=this.values.hsl[1]*t,this.setValues("hsl",this.values.hsl),this},desaturate:function(t){return this.values.hsl[1]-=this.values.hsl[1]*t,this.setValues("hsl",this.values.hsl),this},whiten:function(t){return this.values.hwb[1]+=this.values.hwb[1]*t,this.setValues("hwb",this.values.hwb),this},blacken:function(t){return this.values.hwb[2]+=this.values.hwb[2]*t,this.setValues("hwb",this.values.hwb),this},greyscale:function(){var t=this.values.rgb,e=.3*t[0]+.59*t[1]+.11*t[2];return this.setValues("rgb",[e,e,e]),this},clearer:function(t){return this.setValues("alpha",this.values.alpha-this.values.alpha*t),this},opaquer:function(t){return this.setValues("alpha",this.values.alpha+this.values.alpha*t),this},rotate:function(t){var e=this.values.hsl[0];return e=(e+t)%360,e=0>e?360+e:e,this.values.hsl[0]=e,this.setValues("hsl",this.values.hsl),this},mix:function(t,e){e=1-(null==e?.5:e);for(var i=2*e-1,a=this.alpha()-t.alpha(),o=((i*a==-1?i:(i+a)/(1+i*a))+1)/2,s=1-o,n=this.rgbArray(),r=t.rgbArray(),h=0;h<n.length;h++)n[h]=n[h]*o+r[h]*s;this.setValues("rgb",n);var l=this.alpha()*e+t.alpha()*(1-e);return this.setValues("alpha",l),this},toJSON:function(){return this.rgb()},clone:function(){return new o(this.rgb())}},o.prototype.getValues=function(t){for(var e={},i=0;i<t.length;i++)e[t.charAt(i)]=this.values[t][i];return 1!=this.values.alpha&&(e.a=this.values.alpha),e},o.prototype.setValues=function(t,e){var a={rgb:["red","green","blue"],hsl:["hue","saturation","lightness"],hsv:["hue","saturation","value"],hwb:["hue","whiteness","blackness"],cmyk:["cyan","magenta","yellow","black"]},o={rgb:[255,255,255],hsl:[360,100,100],hsv:[360,100,100],hwb:[360,100,100],cmyk:[100,100,100,100]},s=1;if("alpha"==t)s=e;else if(e.length)this.values[t]=e.slice(0,t.length),s=e[t.length];else if(void 0!==e[t.charAt(0)]){for(var n=0;n<t.length;n++)this.values[t][n]=e[t.charAt(n)];s=e.a}else if(void 0!==e[a[t][0]]){for(var r=a[t],n=0;n<t.length;n++)this.values[t][n]=e[r[n]];s=e.alpha}if(this.values.alpha=Math.max(0,Math.min(1,void 0!==s?s:this.values.alpha)),"alpha"!=t){for(var n=0;n<t.length;n++){var h=Math.max(0,Math.min(o[t][n],this.values[t][n]));this.values[t][n]=Math.round(h)}for(var l in a){l!=t&&(this.values[l]=i[t][l](this.values[t]));for(var n=0;n<l.length;n++){var h=Math.max(0,Math.min(o[l][n],this.values[l][n]));this.values[l][n]=Math.round(h)}}return!0}},o.prototype.setSpace=function(t,e){var i=e[0];return void 0===i?this.getValues(t):("number"==typeof i&&(i=Array.prototype.slice.call(e)),this.setValues(t,i),this)},o.prototype.setChannel=function(t,e,i){return void 0===i?this.values[t][e]:(this.values[t][e]=i,this.setValues(t,this.values[t]),this)},window.Color=e.exports=o}()},{"color-convert":3,"color-string":4}],2:[function(t,e,i){function a(t){var e,i,a,o=t[0]/255,s=t[1]/255,n=t[2]/255,r=Math.min(o,s,n),h=Math.max(o,s,n),l=h-r;return h==r?e=0:o==h?e=(s-n)/l:s==h?e=2+(n-o)/l:n==h&&(e=4+(o-s)/l),e=Math.min(60*e,360),0>e&&(e+=360),a=(r+h)/2,i=h==r?0:.5>=a?l/(h+r):l/(2-h-r),[e,100*i,100*a]}function o(t){var e,i,a,o=t[0],s=t[1],n=t[2],r=Math.min(o,s,n),h=Math.max(o,s,n),l=h-r;return i=0==h?0:l/h*1e3/10,h==r?e=0:o==h?e=(s-n)/l:s==h?e=2+(n-o)/l:n==h&&(e=4+(o-s)/l),e=Math.min(60*e,360),0>e&&(e+=360),a=h/255*1e3/10,[e,i,a]}function s(t){var e=t[0],i=t[1],o=t[2],s=a(t)[0],n=1/255*Math.min(e,Math.min(i,o)),o=1-1/255*Math.max(e,Math.max(i,o));return[s,100*n,100*o]}function n(t){var e,i,a,o,s=t[0]/255,n=t[1]/255,r=t[2]/255;return o=Math.min(1-s,1-n,1-r),e=(1-s-o)/(1-o)||0,i=(1-n-o)/(1-o)||0,a=(1-r-o)/(1-o)||0,[100*e,100*i,100*a,100*o]}function h(t){return J[JSON.stringify(t)]}function l(t){var e=t[0]/255,i=t[1]/255,a=t[2]/255;e=e>.04045?Math.pow((e+.055)/1.055,2.4):e/12.92,i=i>.04045?Math.pow((i+.055)/1.055,2.4):i/12.92,a=a>.04045?Math.pow((a+.055)/1.055,2.4):a/12.92;var o=.4124*e+.3576*i+.1805*a,s=.2126*e+.7152*i+.0722*a,n=.0193*e+.1192*i+.9505*a;return[100*o,100*s,100*n]}function c(t){var e,i,a,o=l(t),s=o[0],n=o[1],r=o[2];return s/=95.047,n/=100,r/=108.883,s=s>.008856?Math.pow(s,1/3):7.787*s+16/116,n=n>.008856?Math.pow(n,1/3):7.787*n+16/116,r=r>.008856?Math.pow(r,1/3):7.787*r+16/116,e=116*n-16,i=500*(s-n),a=200*(n-r),[e,i,a]}function u(t){return B(c(t))}function d(t){var e,i,a,o,s,n=t[0]/360,r=t[1]/100,h=t[2]/100;if(0==r)return s=255*h,[s,s,s];i=.5>h?h*(1+r):h+r-h*r,e=2*h-i,o=[0,0,0];for(var l=0;3>l;l++)a=n+1/3*-(l-1),0>a&&a++,a>1&&a--,s=1>6*a?e+6*(i-e)*a:1>2*a?i:2>3*a?e+(i-e)*(2/3-a)*6:e,o[l]=255*s;return o}function m(t){var e,i,a=t[0],o=t[1]/100,s=t[2]/100;return s*=2,o*=1>=s?s:2-s,i=(s+o)/2,e=2*o/(s+o),[a,100*e,100*i]}function f(t){return s(d(t))}function p(t){return n(d(t))}function v(t){return h(d(t))}function x(t){var e=t[0]/60,i=t[1]/100,a=t[2]/100,o=Math.floor(e)%6,s=e-Math.floor(e),n=255*a*(1-i),r=255*a*(1-i*s),h=255*a*(1-i*(1-s)),a=255*a;switch(o){case 0:return[a,h,n];case 1:return[r,a,n];case 2:return[n,a,h];case 3:return[n,r,a];case 4:return[h,n,a];case 5:return[a,n,r]}}function y(t){var e,i,a=t[0],o=t[1]/100,s=t[2]/100;return i=(2-o)*s,e=o*s,e/=1>=i?i:2-i,e=e||0,i/=2,[a,100*e,100*i]}function w(t){return s(x(t))}function C(t){return n(x(t))}function _(t){return h(x(t))}function k(t){var e,i,a,o,s=t[0]/360,n=t[1]/100,h=t[2]/100,l=n+h;switch(l>1&&(n/=l,h/=l),e=Math.floor(6*s),i=1-h,a=6*s-e,0!=(1&e)&&(a=1-a),o=n+a*(i-n),e){default:case 6:case 0:r=i,g=o,b=n;break;case 1:r=o,g=i,b=n;break;case 2:r=n,g=i,b=o;break;case 3:r=n,g=o,b=i;break;case 4:r=o,g=n,b=i;break;case 5:r=i,g=n,b=o}return[255*r,255*g,255*b]}function D(t){return a(k(t))}function A(t){return o(k(t))}function S(t){return n(k(t))}function P(t){return h(k(t))}function M(t){var e,i,a,o=t[0]/100,s=t[1]/100,n=t[2]/100,r=t[3]/100;return e=1-Math.min(1,o*(1-r)+r),i=1-Math.min(1,s*(1-r)+r),a=1-Math.min(1,n*(1-r)+r),[255*e,255*i,255*a]}function I(t){return a(M(t))}function W(t){return o(M(t))}function R(t){return s(M(t))}function V(t){return h(M(t))}function O(t){var e,i,a,o=t[0]/100,s=t[1]/100,n=t[2]/100;return e=3.2406*o+-1.5372*s+n*-.4986,i=o*-.9689+1.8758*s+.0415*n,a=.0557*o+s*-.204+1.057*n,e=e>.0031308?1.055*Math.pow(e,1/2.4)-.055:e=12.92*e,i=i>.0031308?1.055*Math.pow(i,1/2.4)-.055:i=12.92*i,a=a>.0031308?1.055*Math.pow(a,1/2.4)-.055:a=12.92*a,e=Math.min(Math.max(0,e),1),i=Math.min(Math.max(0,i),1),a=Math.min(Math.max(0,a),1),[255*e,255*i,255*a]}function F(t){var e,i,a,o=t[0],s=t[1],n=t[2];return o/=95.047,s/=100,n/=108.883,o=o>.008856?Math.pow(o,1/3):7.787*o+16/116,s=s>.008856?Math.pow(s,1/3):7.787*s+16/116,n=n>.008856?Math.pow(n,1/3):7.787*n+16/116,e=116*s-16,i=500*(o-s),a=200*(s-n),[e,i,a]}function z(t){return B(F(t))}function L(t){var e,i,a,o,s=t[0],n=t[1],r=t[2];return 8>=s?(i=100*s/903.3,o=7.787*(i/100)+16/116):(i=100*Math.pow((s+16)/116,3),o=Math.pow(i/100,1/3)),e=.008856>=e/95.047?e=95.047*(n/500+o-16/116)/7.787:95.047*Math.pow(n/500+o,3),a=.008859>=a/108.883?a=108.883*(o-r/200-16/116)/7.787:108.883*Math.pow(o-r/200,3),[e,i,a]}function B(t){var e,i,a,o=t[0],s=t[1],n=t[2];return e=Math.atan2(n,s),i=360*e/2/Math.PI,0>i&&(i+=360),a=Math.sqrt(s*s+n*n),[o,a,i]}function T(t){return O(L(t))}function N(t){var e,i,a,o=t[0],s=t[1],n=t[2];return a=n/360*2*Math.PI,e=s*Math.cos(a),i=s*Math.sin(a),[o,e,i]}function H(t){return L(N(t))}function E(t){return T(N(t))}function q(t){return $[t]}function j(t){return a(q(t))}function Y(t){return o(q(t))}function X(t){return s(q(t))}function Q(t){return n(q(t))}function Z(t){return c(q(t))}function U(t){return l(q(t))}e.exports={rgb2hsl:a,rgb2hsv:o,rgb2hwb:s,rgb2cmyk:n,rgb2keyword:h,rgb2xyz:l,rgb2lab:c,rgb2lch:u,hsl2rgb:d,hsl2hsv:m,hsl2hwb:f,hsl2cmyk:p,hsl2keyword:v,hsv2rgb:x,hsv2hsl:y,hsv2hwb:w,hsv2cmyk:C,hsv2keyword:_,hwb2rgb:k,hwb2hsl:D,hwb2hsv:A,hwb2cmyk:S,hwb2keyword:P,cmyk2rgb:M,cmyk2hsl:I,cmyk2hsv:W,cmyk2hwb:R,cmyk2keyword:V,keyword2rgb:q,keyword2hsl:j,keyword2hsv:Y,keyword2hwb:X,keyword2cmyk:Q,keyword2lab:Z,keyword2xyz:U,xyz2rgb:O,xyz2lab:F,xyz2lch:z,lab2xyz:L,lab2rgb:T,lab2lch:B,lch2lab:N,lch2xyz:H,lch2rgb:E};var $={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]},J={};for(var G in $)J[JSON.stringify($[G])]=G},{}],3:[function(t,e,i){var a=t("./conversions"),o=function(){return new l};for(var s in a){o[s+"Raw"]=function(t){return function(e){return"number"==typeof e&&(e=Array.prototype.slice.call(arguments)),a[t](e)}}(s);var n=/(\w+)2(\w+)/.exec(s),r=n[1],h=n[2];o[r]=o[r]||{},o[r][h]=o[s]=function(t){return function(e){"number"==typeof e&&(e=Array.prototype.slice.call(arguments));var i=a[t](e);if("string"==typeof i||void 0===i)return i;for(var o=0;o<i.length;o++)i[o]=Math.round(i[o]);return i}}(s)}var l=function(){this.convs={}};l.prototype.routeSpace=function(t,e){var i=e[0];return void 0===i?this.getValues(t):("number"==typeof i&&(i=Array.prototype.slice.call(e)),this.setValues(t,i))},l.prototype.setValues=function(t,e){return this.space=t,this.convs={},this.convs[t]=e,this},l.prototype.getValues=function(t){var e=this.convs[t];if(!e){var i=this.space,a=this.convs[i];e=o[i][t](a),this.convs[t]=e}return e},["rgb","hsl","hsv","cmyk","keyword"].forEach(function(t){l.prototype[t]=function(e){return this.routeSpace(t,arguments)}}),e.exports=o},{"./conversions":2}],4:[function(t,e,i){function a(t){if(t){var e=/^#([a-fA-F0-9]{3})$/,i=/^#([a-fA-F0-9]{6})$/,a=/^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/,o=/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/,s=/(\D+)/,n=[0,0,0],r=1,h=t.match(e);if(h){h=h[1];for(var l=0;l<n.length;l++)n[l]=parseInt(h[l]+h[l],16)}else if(h=t.match(i)){h=h[1];for(var l=0;l<n.length;l++)n[l]=parseInt(h.slice(2*l,2*l+2),16)}else if(h=t.match(a)){for(var l=0;l<n.length;l++)n[l]=parseInt(h[l+1]);r=parseFloat(h[4])}else if(h=t.match(o)){for(var l=0;l<n.length;l++)n[l]=Math.round(2.55*parseFloat(h[l+1]));r=parseFloat(h[4])}else if(h=t.match(s)){if("transparent"==h[1])return[0,0,0,0];if(n=y[h[1]],!n)return}for(var l=0;l<n.length;l++)n[l]=b(n[l],0,255);return r=r||0==r?b(r,0,1):1,n[3]=r,n}}function o(t){if(t){var e=/^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/,i=t.match(e);if(i){var a=parseFloat(i[4]),o=b(parseInt(i[1]),0,360),s=b(parseFloat(i[2]),0,100),n=b(parseFloat(i[3]),0,100),r=b(isNaN(a)?1:a,0,1);return[o,s,n,r]}}}function s(t){if(t){var e=/^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/,i=t.match(e);if(i){var a=parseFloat(i[4]),o=b(parseInt(i[1]),0,360),s=b(parseFloat(i[2]),0,100),n=b(parseFloat(i[3]),0,100),r=b(isNaN(a)?1:a,0,1);return[o,s,n,r]}}}function n(t){var e=a(t);return e&&e.slice(0,3)}function r(t){var e=o(t);return e&&e.slice(0,3)}function h(t){var e=a(t);return e?e[3]:(e=o(t))?e[3]:(e=s(t))?e[3]:void 0}function l(t){return"#"+x(t[0])+x(t[1])+x(t[2])}function c(t,e){return 1>e||t[3]&&t[3]<1?u(t,e):"rgb("+t[0]+", "+t[1]+", "+t[2]+")"}function u(t,e){return void 0===e&&(e=void 0!==t[3]?t[3]:1),"rgba("+t[0]+", "+t[1]+", "+t[2]+", "+e+")"}function d(t,e){if(1>e||t[3]&&t[3]<1)return g(t,e);var i=Math.round(t[0]/255*100),a=Math.round(t[1]/255*100),o=Math.round(t[2]/255*100);return"rgb("+i+"%, "+a+"%, "+o+"%)"}function g(t,e){var i=Math.round(t[0]/255*100),a=Math.round(t[1]/255*100),o=Math.round(t[2]/255*100);return"rgba("+i+"%, "+a+"%, "+o+"%, "+(e||t[3]||1)+")"}function m(t,e){return 1>e||t[3]&&t[3]<1?f(t,e):"hsl("+t[0]+", "+t[1]+"%, "+t[2]+"%)"}function f(t,e){return void 0===e&&(e=void 0!==t[3]?t[3]:1),"hsla("+t[0]+", "+t[1]+"%, "+t[2]+"%, "+e+")"}function p(t,e){return void 0===e&&(e=void 0!==t[3]?t[3]:1),"hwb("+t[0]+", "+t[1]+"%, "+t[2]+"%"+(void 0!==e&&1!==e?", "+e:"")+")"}function v(t){return w[t.slice(0,3)]}function b(t,e,i){return Math.min(Math.max(e,t),i)}function x(t){var e=t.toString(16).toUpperCase();return e.length<2?"0"+e:e}var y=t("color-name");e.exports={getRgba:a,getHsla:o,getRgb:n,getHsl:r,getHwb:s,getAlpha:h,hexString:l,rgbString:c,rgbaString:u,percentString:d,percentaString:g,hslString:m,hslaString:f,hwbString:p,keyword:v};var w={};for(var C in y)w[y[C]]=C},{"color-name":5}],5:[function(t,e,i){e.exports={aliceblue:[240,248,255],antiquewhite:[250,235,215],aqua:[0,255,255],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],black:[0,0,0],blanchedalmond:[255,235,205],blue:[0,0,255],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],fuchsia:[255,0,255],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],gray:[128,128,128],green:[0,128,0],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],lime:[0,255,0],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],maroon:[128,0,0],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],navy:[0,0,128],oldlace:[253,245,230],olive:[128,128,0],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],purple:[128,0,128],rebeccapurple:[102,51,153],red:[255,0,0],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],silver:[192,192,192],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],teal:[0,128,128],thistle:[216,191,216],tomato:[255,99,71],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],white:[255,255,255],whitesmoke:[245,245,245],yellow:[255,255,0],yellowgreen:[154,205,50]}},{}]},{},[1]);