<?php
/**
* cp基本设置
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
* @version $Id: setting.inc.php 2 2007-12-20 14:16 $
*/

(!defined('IN_ADMIN') || !defined('IN_MUDDER')) && exit('Access Denied');

$query = $db->query("SELECT * FROM {$dbpre}config");
while($row = $db->fetch_array($query)) {
	$config[$row['variable']] = $row['value'];
}
if(!check_submit('settingsubmit')) {

    if($op == 'access') {

        $tplname = 'access';

    } elseif($op == 'display') {

        $tplname = 'display';
        $query = $db->query("SELECT * FROM {$dbpre}templates WHERE tpltype='main'");
        $templates_option = '';
        while($template = $db->fetch_array($query)) {
            $selected = $template['templateid'] == $config['templateid'] ? 'selected="selected"' : '';
            $templates_option .= '<option value="'.$template['templateid'].'" '.$selected.'>'.$template['name'].'</option>';
        }

    } elseif($op == 'webfunc') {

        $tplname = 'webfunc';
        $auditing = unserialize($config['auditing']);
        if($auditing && is_array($auditing)) {
            extract($auditing, EXTR_SKIP);
        }
        $seccode = unserialize($config['seccode']);
        if($seccode && is_array($seccode)) {
            extract($seccode, EXTR_SKIP);
        }
        $video = unserialize($config['video']);
        $video['width'] = $video['width'] ? intval($video['width']) : 250;
        $video['height'] = $video['height'] ? intval($video['height']) : 200;
        $picture_thumb = unserialize($config['picture_thumb']);
        $config['tplext'] = empty($config['tplext']) ? '.htm' : $config['tplext'];
        $googlesearch = $config['googlesearch'] ? unserialize($config['googlesearch']) : array();
    
    } elseif($op == 'mail') {

        $tplname = 'mail';
        $mail = $config['mail'] ? unserialize($config['mail']) : array();
        $mail && extract($mail, EXTR_SKIP);

    } elseif($op == 'seo') {

        $tplname = 'seo';

        $rewrite = $config['rewrite'] ? unserialize($config['rewrite']) : array();
        if($rewrite) foreach($rewrite as $key => $val) {
            $rewrite[$key] = $val ? 'checked="checked"' : '';
        }

    } elseif($op == 'optimize' ) {

        $tplname = 'optimize';

        $config['datacall_dir'] = empty($config['datacall_dir'])?'./data/datacall':$config['datacall_dir'];
        $cache = $config['cache'] ? unserialize($config['cache']) : array();
        $cache_num = $config['cache_num'] ? unserialize($config['cache_num']) : array();
        $search = $config['search'] ? unserialize($config['search']) : array();

    } elseif($op == 'point') {

        $tplname = 'point';
        $expleve = unserialize($config['expleve']);
        if(!$expleve) {
            unset($expleve);
        } else {
            extract($expleve, EXTR_SKIP);
        }
    
    } elseif($op == 'inputlimit') {

        $tplname = 'inputlimit';
        $inputlimit = unserialize($config['inputlimit']);
        if(!$inputlimit) {
            unset($inputlimit);
        } else {
            extract($inputlimit, EXTR_SKIP);
        }

    } elseif($op == 'space') {

        $tplname = 'space';
        $space = unserialize($config['space']);
        if(!$space) {
            unset($space);
        } else {
            extract($space, EXTR_SKIP);
            $record_guest[0] = empty($recordguest)||!$recordguest ? 'checked' : '';
            $record_guest[1] = $recordguest ? 'checked' : '';
        }

        if($_templates['space']) foreach($_templates['space'] as $key => $val) {
            $selected = $key == $config['space_styleid'] ? 'selected="selected"' : '';
            $space_styles_option .= '<option value="'.$key.'" '.$selected.'>'.$val['name'].'</option>';
        }

    } elseif($op == 'ucenter') {

        $tplname = 'ucenter';

        $uc_enable[1] = $config['ucenter_enable'] ? ' checked="checked"' : '';
        $uc_enable[0] = !$config['ucenter_enable'] ? ' checked="checked"' : '';
        $uc_exange[1] = $config['uc_exange'] ? ' checked="checked"' : '';
        $uc_exange[0] = !$config['uc_exange'] ? ' checked="checked"' : '';

        $disabled = is_writeable(MUDDER_ROOT.'config.inc.php') ? '' : 'disabled ';

        $ucdbpw = '********';
        list($ucdbname, $uctablepre) = explode('.', str_replace('`', '', UC_DBTABLEPRE));

    } elseif($op == 'discuz') {
        $tplname = 'discuz';
        $passport_discuz_enable[0] = !$config['passport_discuz_enable'] ? 'checked="checked"' : '';
        $passport_discuz_enable[1] = $config['passport_discuz_enable'] ? 'checked="checked"' : '';

    } elseif($op == 'passport') {

        $tplname = 'passport';
        $passport = unserialize($config['passport']);
        if(!$passport) {
            unset($passport);
        } else {
            extract($passport, EXTR_SKIP);
            $passport_enable[0] = !$enable ? 'checked="checked"' : '';
            $passport_enable[1] = $enable ? 'checked="checked"' : '';
        }

    } else {

        $op = 'basic';
        $tplname = 'basic';
        $siteclose_0 = $config['siteclose'] ? 'checked' : '';
        $siteclose_1 = empty($config['siteclose'])||!$config['siteclose'] ? 'checked' : '';
        // sitename,siteurl,icpno,siteclose,clodenote

    }

    include cptpl('setting_'.$tplname);

} else {

    $newconfig = array();

    if($op == 'basic') {

        // basic
        $newconfig['sitename'] = html_special_chars_ex($sitename);
        $newconfig['siteurl'] = trim($siteurl);
        $newconfig['icpno'] = html_special_chars_ex($icpno);
        $newconfig['siteclose'] = intval($siteclose);
        $newconfig['closenote'] = trim($closenote);

    } elseif($op == 'access') {

        $newconfig['authkey'] = trim($authkey);
        if(strlen($newconfig['authkey']) < 10) cpmsg('网站加密码不能小于10个字符，请返回修改。');

        //access
        $newconfig['closereg'] = intval($closereg);
        $newconfig['existsemailreg'] = intval($existsemailreg);
        $newconfig['salutatory'] = intval($salutatory);
        $newconfig['salutatory_msg'] = nl_textarea($salutatory_msg);
        $newconfig['showregrule'] = intval($showregrule);
        $newconfig['regrule'] = $regrule;
        $newconfig['censoruser'] = html_special_chars_ex(preg_replace("/\s*(\r\n|\n\r|\n|\r)\s*/", "\r\n", $censoruser));
        $newconfig['useripaccess'] = html_special_chars_ex(preg_replace("/\s*(\r\n|\n\r|\n|\r)\s*/", "\r\n", $useripaccess));
        $newconfig['adminipaccess'] = html_special_chars_ex(preg_replace("/\s*(\r\n|\n\r|\n|\r)\s*/", "\r\n", $adminipaccess));
        $newconfig['ban_ip'] = html_special_chars_ex(preg_replace("/\s*(\r\n|\n\r|\n|\r)\s*/", "\r\n", $ban_ip));

    } elseif($op == 'display' ) {

        //display
        $newconfig['templateid'] = intval($templateid);
        $newconfig['templatemenu'] = intval($templatemenu);
        $newconfig['item_styleid'] = intval($item_styleid);
        $newconfig['space_styleid'] = intval($space_styleid);
        $newconfig['dpshopnumber'] = intval($dpshopnumber);
        $newconfig['dpreviewnumber'] = intval($dpreviewnumber);
        $newconfig['dpdetail_reviewnumber'] = intval($dpdetail_reviewnumber);
        $newconfig['dpreview_respondnumber'] = intval($dpreview_respondnumber);
        $newconfig['default_panel'] = $default_panel;
        $newconfig['dpnewreviewnumber'] = $dpnewreviewnumber;
        $newconfig['default_city'] = $default_city;
        $newconfig['shopthumb'] = intval($shopthumb);
        $newconfig['classorder'] = trim($classorder) == 'total' ? 'total' : 'order';
        $newconfig['thumbdisplay'] = trim($thumbdisplay) == 'fixed' ? 'fixed' : 'auto';
        $newconfig['detail_allthumb_enable'] = intval($detail_allthumb_enable) ? 1 : 0;
        $newconfig['detail_allthumb_sort'] = $detail_allthumb_sort == 'big' ? 'big' : 'small';

    } elseif($op == 'webfunc') {

        //webfunc
        $newconfig['gzipcompress'] = intval($gzipcompress);

        $seccode['login'] = intval($seccode['login']);
        $seccode['registry'] = intval($seccode['registry']);
        $seccode['newreview'] = intval($seccode['newreview']);
        $seccode['newshop'] = intval($seccode['newshop']);
        $seccode['adminlogin'] = intval($seccode['adminlogin']);
        $newconfig['seccode'] = addslashes(serialize($seccode));

        $newconfig['watermark'] = intval($watermark);

        $picture_thumb['small']['width'] = intval($picture_thumb['small']['width']);
        $picture_thumb['small']['height'] = intval($picture_thumb['small']['height']);
        $picture_thumb['big']['width'] = intval($picture_thumb['big']['width']);
        $picture_thumb['big']['height'] = intval($picture_thumb['big']['height']);
        $newconfig['picture_thumb'] = addslashes(serialize($picture_thumb));

        $newconfig['picture_upload_size'] = intval($picture_upload_size);

        $newconfig['debug'] = intval($debug) ? 1 : 0;

        $auditing['auditing'] = intval($auditing['addshop']) ? 1 : 0;
        $auditing['auditing'] = intval($auditing['addreview']) ? 1 : 0;
        $auditing['auditing'] = intval($auditing['addrespond']) ? 1 : 0;
        $auditing['auditing'] = intval($auditing['uploadpicture']) ? 1 : 0;
        $newconfig['auditing'] = addslashes(serialize($auditing));

        $video['width'] = intval($video['width']);
        $video['height'] = intval($video['height']);
        $newconfig['video'] = addslashes(serialize($video));

        $newconfig['tplext'] = trim($tplext);

        //google
        $googlesearch['enable'] = intval($googlesearch['enable']) ? 1 : 0;
        $googlesearch['website'] = html_special_chars_ex($googlesearch['website']);
        $newconfig['googlesearch'] = addslashes(serialize($googlesearch));
    
    } elseif($op == 'mail') {

        if(!$admin->is_founder) cpmsg('您不是网站创始人，无法修改此处信息，请返回。');
        if($mail) {
            foreach($mail as $key => $val) {
                $mail[$key] = trim($val);
            }
            $newconfig['mail'] = addslashes(serialize($mail));
            unset($key, $val);
        }
        
    
    } elseif($op == 'seo') {

        //seo
        $newconfig['subname'] = html_special_chars_ex($subname);
        $newconfig['meta_keywords'] = html_special_chars_ex($meta_keywords);
        $newconfig['meta_description'] = html_special_chars_ex($meta_description);
        $newconfig['headhtml'] = trim($headhtml);

        if($rewrite) foreach($rewrite as $key => $val) {
            $rewrite[$key] = intval($val) ? 1 : 0;
        }
        $newconfig['rewrite'] = addslashes(serialize($rewrite));

    } elseif($op == 'optimize') {

        $newconfig['datacall_dir'] = $datacall_dir;
        $datacall_dir = empty($datacall_dir)?'./data/datacall':$datacall_dir;
        $datacall_dir = MUDDER_ROOT.$datacall_dir;
        if(!file_exists($datacall_dir)) {
        	if(!@mkdir($datacall_dir, 0777)) {
        		cpmsg('没有权限创建数据调用目录('.$datacall_dir.')，请检查您的权限，请返回。');
        	}
        }

    	if($cache) foreach($cache as $key => $val) {
            $cache[$key] = intval($val);
        }
        $newconfig['cache'] = addslashes(serialize($cache));

        if($cache_num) foreach($cache_num as $key => $val) {
            $cache_num[$key] = intval($val);
        }
        $newconfig['cache_num'] = addslashes(serialize($cache_num));

        if($search) foreach($search as $key => $val) {
            $search[$key] = intval($val);
        }
        $newconfig['search'] = addslashes(serialize($search));

    } elseif($op == 'point') {

        //point
        $expleve = array();
        $expleve['reg']['point'] = intval($reg['point']);
        $expleve['reg']['coin'] = intval($reg['coin']);
        $expleve['addshop']['point'] = intval($addshop['point']);
        $expleve['addshop']['coin'] = intval($addshop['coin']);
        $expleve['updateshop']['point'] = intval($updateshop['point']);
        $expleve['updateshop']['coin'] = intval($updateshop['coin']);
        $expleve['addreview']['point'] = intval($addreview['point']);
        $expleve['addreview']['coin'] = intval($addreview['coin']);
        $expleve['addrespond']['point'] = intval($addrespond['point']);
        $expleve['addrespond']['coin'] = intval($addrespond['coin']);
        $expleve['addpicture']['point'] = intval($addpicture['point']);
        $expleve['addpicture']['coin'] = intval($addpicture['coin']);
        $expleve['deleteshop']['point'] = intval($deleteshop['point']);
        $expleve['deleteshop']['coin'] = intval($deleteshop['coin']);
        $expleve['deletereview']['point'] = intval($deletereview['point']);
        $expleve['deletereview']['coin'] = intval($deletereview['coin']);
        $expleve['deleterespond']['point'] = intval($deleterespond['point']);
        $expleve['deleterespond']['coin'] = intval($deleterespond['coin']);
        $expleve['deletepicture']['point'] = intval($deletepicture['point']);
        $expleve['deletepicture']['coin'] = intval($deletepicture['coin']);
        $newconfig['expleve'] = addslashes(serialize($expleve));

    } elseif($op == 'inputlimit') {

        $inputlimit = array();
        (!is_numeric($review['min']) || $review['min'] <= 0) && cpmsg('点评内容字符最小限制格式不正确。');
        (!is_numeric($review['max']) || $review['max'] <= 1) && cpmsg('点评内容字符最大限制格式不正确。');
        (!is_numeric($respond['min']) || $respond['min'] <= 0) && cpmsg('回应内容字符最小限制格式不正确。');
        (!is_numeric($respond['max']) || $respond['max'] <= 1) && cpmsg('回应内容字符最大限制格式不正确。');
        $inputlimit['review']['min'] = intval($review['min']);
        $inputlimit['review']['max'] = intval($review['max']);
        $inputlimit['respond']['min'] = intval($respond['min']);
        $inputlimit['respond']['max'] = intval($respond['max']);
        $newconfig['inputlimit'] = addslashes(serialize($inputlimit));

    } elseif($op == 'space') {

        $newconfig['space_styleid'] = $space_styleid;
        $space['recordguest'] = intval($space['recordguest']);
        $space['index_reviews'] = intval($space['index_reviews']);
        $space['index_gbooks'] = intval($space['index_gbooks']);
        $space['reviews'] = intval($space['reviews']);
        $space['gbooks'] = intval($space['gbooks']);
        $space['friends'] = intval($space['friends']);
        $space['spacename'] = $space['spacename'];
        $space['spacedescribe'] = $space['spacedescribe'];
        $newconfig['space'] = addslashes(serialize($space));

    } elseif($op == 'ucenter') {

        if(!$admin->is_founder) cpmsg('您不是网站创始人，无法修改此处信息，请返回。');
        $cfgfile = MUDDER_ROOT.'/config.inc.php';
        if(!is_writeable($cfgfile)) cpmsg('配置信息不可写，请返回检测。');
        
        $newconfig['ucenter_enable'] = intval($uc_enable) ? 1 : 0;
        $newconfig['uc_exange'] = intval($uc_exange) ? 1 : 0;
        $newconfig['uc_feed'] = intval($uc_feed) ? 1 : 0;
        $newconfig['uc_uch'] = intval($uc_uch) ? 1 : 0;
        $newconfig['uc_uch_url'] = trim($uc_uch_url);

        if($newconfig['ucenter_enable']) {

            if($uc['connect']) {
                $ucdbpw_new = $uc['dbpw'] == '********' ? UC_DBPW : $uc['dbpw'];
                $uc_db_link = @mysql_connect($uc['dbhost'], $uc['dbuser'], $ucdbpw_new, 1);
                if(!$uc_db_link) {
                    cpmsg('UC服务器数据库连接失败，请返回修改。');
                } else {
                    mysql_close($uc_db_link);
                }
            }
            
            $fp = fopen($cfgfile, 'r');
            $configfile = fread($fp, filesize($cfgfile));
            $configfile = trim($configfile);
            $configfile = substr($configfile, -2) == '?>' ? substr($configfile, 0, -2) : $configfile;
            fclose($fp);

            $connect = '';
            if($uc['connect']) {
                require $cfgfile;
                $connect = 'mysql';
                $configfile = insertconfig($configfile, "/define\('UC_DBHOST',\s*'.*?'\);/i", "define('UC_DBHOST', '".$uc['dbhost']."');");
                $configfile = insertconfig($configfile, "/define\('UC_DBUSER',\s*'.*?'\);/i", "define('UC_DBUSER', '".$uc['dbuser']."');");
                $configfile = insertconfig($configfile, "/define\('UC_DBPW',\s*'.*?'\);/i", "define('UC_DBPW', '".$ucdbpw_new."');");
                $configfile = insertconfig($configfile, "/define\('UC_DBNAME',\s*'.*?'\);/i", "define('UC_DBNAME', '".$uc['dbname']."');");
                $configfile = insertconfig($configfile, "/define\('UC_DBCHARSET',\s*'.*?'\);/i", "define('UC_DBCHARSET', '".$uc['dbcharset']."');");
                $configfile = insertconfig($configfile, "/define\('UC_DBTABLEPRE',\s*'.*?'\);/i", "define('UC_DBTABLEPRE', '`".$uc['dbname'].'`.'.$uc['dbtablepre']."');");
            }
            $configfile = insertconfig($configfile, "/define\('UC_CONNECT',\s*'.*?'\);/i", "define('UC_CONNECT', '$connect');");
            $configfile = insertconfig($configfile, "/define\('UC_KEY',\s*'.*?'\);/i", "define('UC_KEY', '".$uc['key']."');");
            $configfile = insertconfig($configfile, "/define\('UC_API',\s*'.*?'\);/i", "define('UC_API', '".$uc['api']."');");
            $configfile = insertconfig($configfile, "/define\('UC_IP',\s*'.*?'\);/i", "define('UC_IP', '".$uc['ip']."');");
            $configfile = insertconfig($configfile, "/define\('UC_APPID',\s*'?.*?'?\);/i", "define('UC_APPID', '".$uc['appid']."');");

            $fp = fopen($cfgfile, 'w');
            if(!($fp = @fopen($cfgfile, 'w'))) {
                cpmsg('配置文件写入失败，请返回检查文件权限。');
            }
            @fwrite($fp, trim($configfile));
            @fclose($fp);

        }

    } elseif($op == 'discuz') {

        //passport_discuz_enable
        $newconfig['passport_discuz_enable'] = intval($passport_discuz_enable);

        $passport_discuz_passportkey = trim($passport_discuz_passportkey);
        if(strlen($passport_discuz_passportkey) < 10 && $passport_discuz_passportkey != '') {
            cpmsg('Discuz！通行证私有密匙不能小于10个字节，请返回修改。');
        }
        $newconfig['passport_discuz_passportkey'] = $passport_discuz_passportkey;

        $passport_discuz_passportpath = trim($passport_discuz_passportpath);
        if($passport_discuz_passportkey != '') {
            if(!is_file($passport_discuz_passportpath)) {
                cpmsg('Discuz!认证处理文件不是个有效的文件(可能是路径错误)，请返回修改。');
            } elseif(!file_exists($passport_discuz_passportpath)) {
                cpmsg('Discuz!认证处理文件不存在(可能是路径错误)，请返回修改。');
            }
        }
        $newconfig['passport_discuz_passportpath'] = $passport_discuz_passportpath;

    } elseif($op == 'passport') {

        $passport['enable'] = intval($passport['enable']);
        $passport['systemname'] = html_special_chars_ex($passport['systemname']);
        $passport['index_url'] = trim($passport['index_url']);
        $passport['reg_url'] = trim($passport['reg_url']);
        $passport['login_url'] = trim($passport['login_url']);
        $passport['logout_url'] = trim($passport['logout_url']);
        $passport['cpwd_url'] = trim($passport['cpwd_url']);

        if(!$passport['systemname']) cpmsg('未填写系统名称，请返回修改。');
        if(!$passport['index_url']) cpmsg('未填写整合系统主页，请返回修改。');
        if(!$passport['reg_url']) cpmsg('未填写会员注册网址，请返回修改。');
        if(!$passport['login_url']) cpmsg('未填写会员登陆网址，请返回修改。');
        if(!$passport['logout_url']) cpmsg('未填写会员退出网址，请返回修改。');
        if(!$passport['cpwd_url']) cpmsg('未填写更改密码网址，请返回修改。');

        $newconfig['passport'] = addslashes(serialize($passport));

    } else {
        cpmsg('未定义操作。','stop');
    }

    if($newconfig && is_array($newconfig)) {
        foreach($newconfig as $key => $val) {
            $db->query("REPLACE INTO {$dbpre}config (variable, value) VALUES ('$key', '$val')");
        }
    }

    cache_config();
    $op == 'inputlimit' && cache('inputlimit');

    cpmsg('更新完毕。',"admincp.php?action=$action&file=$file&op=$op");
}

function insertconfig($s, $find, $replace) {
	if(preg_match($find, $s)) {
		$s = preg_replace($find, $replace, $s);
	} else {
		$s .= "\r\n".$replace;
	}
	return $s;
}
?>

