<?php
namespace app\index\controller;
use think\Controller;
use think\Db;

/**
 * 用户控制器
 * 包括用户中心，用户登录及注册
 */
class User extends Home {
	
	/* 验证码，用于登录和注册 */
	public function verify(){
		$Verify =     new \think\Verify();  
        $Verify->fontSize = 30;
		$Verify->length   = 4;
        $Verify->entry(1);
	}
	/* 注册页面 */
	public function register($username = "", $password = "", $repassword = "", $email = "", $verify = ""){
		
		$username =safe_replace($username);//过滤
       
		if(!C("USER_ALLOW_REGISTER")){
            $this->error("注册已关闭");
        }
	
		if($_POST){ //注册用户
			 if(!$username){
                $this->error("用户名不能为空！");
            }
			if($verify){
		       if(!check_verify($verify)){
		         $this->error("验证码不正确！"); 
		       }
		    }
			$data['username']=$username;
			$res =Db::name('UcenterMember')->where($data)->select();
            if($res){
                $this->error("用户已存在！");
            }
			/* 检测密码 */
			if($password != $repassword){
				$this->error("密码和重复密码不一致！");
			}			
            $key=config('database.key');
            $data['password']=ucenter_md5($password,$key);
			$data['email']=safe_replace($email);//过滤
			$uid=Db::name('UcenterMember')->insertGetId($data);
			
            $Member=new \app\index\model\Member;
				if($Member->login($uid)){ //登录用户
					//TODO:跳转到登录前页面            
					 $url= session("url")?session("url"):url('index/index');
				     
					 addCount("member","会员注册数+1");
				    $this->success("注册成功",$url);
			       
				
				} else {
					$this->error("密码或账号错误");
				}

		} 
		else { 	
	      $meta_title = '会员注册';  
		  $this->assign('meta_title',$meta_title);
		  return $this->fetch();
		}
	}

	/* 登录页面 */
	public function login($username = "", $password = "", $verify = "",$type=1){
		
		if($_POST){ //登录验证
			 
              $username =safe_replace($username);//过滤

			  /* 检测验证码 */
			//if(!check_verify($verify)){
				//$this->error("验证码输入错误！");
			//}
			/* 调用UC登录接口登录 */
			//$user = new UserApi;
		    $key=config('database.key');
			
			$map = array();
		switch ($type) {
			case 1:
				$map['username'] = $username;
				break;
			case 2:
				$map['email'] = $username;
				break;
			case 3:
				$map['mobile'] = $username;
				break;
			case 4:
				$map['id'] = $username;
				break;
			default:
				return 0; //参数错误
		}
      $map["password"]=ucenter_md5($password, $key);
		/* 获取用户数据 */
		$user =Db::name('UcenterMember')->where($map)->find();
		if($user){
			$uid = $user["id"];
            if(0 < $uid){ //UC登录成功
				 if(input('post.remember')){ 
					   Cookie::set('username',$username,2592000); // 指定cookie保存30天时间
					   Cookie::set('password',$password,2592000); // 指定cookie保存30天时间		 
				 }
				/* 登录用户 */
				$Member=new \app\index\model\Member;
				if($Member->login($uid)){ //登录用户
					//TODO:跳转到登录前页面            
					 $url= session("url")?session("url"):url('index/index');
				    $this->success("登陆成功",$url);
			       
				
				} else {
					$this->error("密码或账号错误");
				}
			  }

			} else { //登录失败
				$this->error("密码或账号错误");
			}

		} else {  	
		    $meta_title = '会员登录';	
		    $this->assign('meta_title',$meta_title);			
			 session("url",null);
		     $url=input('server')["HTTP_REFFER"];
             session("url",$url);
			// echo config('DATA_AUTH_KEY');
			 //显示登录表单
			return $this->fetch();
		}
	}

    public function forget($username = "", $password = ""){
		if(Request::instance()->isPost()){ //登录验证
			/* 调用UC登录接口登录 */
			$username =safe_replace($username);//过滤
			$user = new UserApi;
			$uid = $user->login($username, $password);
			if(0 < $uid){ //UC登录成功
				/* 登录用户 */
				$Member = model("Member");
				if($Member->login($uid)){ //登录用户
					//TODO:跳转到登录前页面
		           $data["status"] =1;
                   $data["info"] = "登录成功";
                   $this->ajaxReturn($data);
				} else {
					$this->error($Member->getError());
				}

			} else { //登录失败
				switch($uid) {
					case -1: $error = "用户不存在或被禁用！"; break; //系统级别禁用
					case -2: $error = "密码错误！"; break;
					default: $error ="未知错误！"; break; // 0-接口参数错误（调试阶段使用）
				}
				$this->error($error);
			}

		} else { //显示登录表单
		
		    session("send_code",$this->random());
			$this->assign('code',session("send_code"));
			return $this->fetch();
		}
	}

	/* 退出登录 */
	public function logout(){
		if(is_login()){
			$Member =new \app\index\model\Member;
			$Member->logout();
			$this->success("退出成功！");
		} else {
			$this->redirect("User/login");
		}
	}

  public   function Post($curlPost,$url){
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_HEADER, false);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($curl, CURLOPT_NOBODY, true);
		curl_setopt($curl, CURLOPT_POST, true);
		curl_setopt($curl, CURLOPT_POSTFIELDS, $curlPost);
		$return_str = curl_exec($curl);
		curl_close($curl);
		return $return_str;
}

public  function random($length = 6 , $numeric = 0) {
	PHP_VERSION < '4.2.0' && mt_srand((double)microtime() * 1000000);
	if($numeric) {
		$hash = sprintf('%0'.$length.'d', mt_rand(0, pow(10, $length) - 1));
	} else {
		$hash = '';
		$chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789abcdefghjkmnpqrstuvwxyz';
		$max = strlen($chars) - 1;
		for($i = 0; $i < $length; $i++) {
			$hash .= $chars[mt_rand(0, $max)];
		}
	}
	return $hash;
}
//发送验证码
public function sendSms($length = 6 , $numeric = 0,$verify="") {
	if(!check_verify($verify)){
		$this->error("验证码输入错误！");
	}
	$mobile = $_POST['mobile'];
    $map["mobile"]=$mobile;
	$info=M("UcenterMember")->where($map)->find();	
	if(!$info){
		//防用户恶意请求
		$this->error('账号不存在');
	}
	$target = "http://106.ihuyi.cn/webservice/sms.php?method=Submit";
	
	$send_code = $_POST['send_code'];
	$mobile_code =$this-> random(4,1);
	if(empty($mobile)){
		exit('手机号码不能为空');
	}
	if(!session('send_code')||$send_code!=session('send_code')){
		//防用户恶意请求
		exit('请求超时，请刷新页面后重试');
	}
    $u=C('HUYIUSERNAME');$p=C('HUYIPASSWORD');
	$post_data = "account={$u}&password={$p}&mobile=".$mobile."&content=".rawurlencode("您的验证码是：".$mobile_code."。请不要把验证码泄露给其他人。");

	//密码可以使用明文密码或使用32位MD5加密
	$gets = $this->xml_to_array($this->Post($post_data, $target));
	if($gets['SubmitResult']['code']==2){
		$_SESSION['mobile'] = $mobile;
		$_SESSION['mobile_code'] = $mobile_code;
	}
	echo $gets['SubmitResult']['msg'];

}
public function confirm($mobile = '', $verify = ''){
		
		if(Request::instance()->isPost()){ //注册用户
			/* 检测验证码 */
			if(($mobile!==$_SESSION['mobile'])&&($verify!==$_SESSION['mobile_code'])){
				$this->error("动态码输入错误！");
			} 
			else{
                $this->success("验证成功！");
            }
			
		}
	}

public function xml_to_array($xml){
	$reg = "/<(\w+)[^>]*>([\\x00-\\xFF]*)<\\/\\1>/";
	if(preg_match_all($reg, $xml, $matches)){
		$count = count($matches[0]);
		for($i = 0; $i < $count; $i++){
		$subxml= $matches[2][$i];
		$key = $matches[1][$i];
			if(preg_match( $reg, $subxml )){
				$arr[$key] = $this->xml_to_array( $subxml );
			}else{
				$arr[$key] = $subxml;
			}
		}
	}
	return $arr;
}
    
     /*修改资料*/
     public  function update() {
        if(!is_login()) {
			$this->error( "您还没有登陆",U("User/login") );
		}		
	    if($_POST){ //提交表单
		   $id=input('id'); 	
           if(!($id && is_numeric($id))){
		       $this->error('用户ID错误！');
		   }
		   $map["id"]=$id;
		   $info=db("UcenterMember")->where($map)->find();
		   if(!$info){
			   $this->error( "无对应的用户" );
		   }
		   $UcenterMember= new \app\index\model\UcenterMember;
		   $res=$UcenterMember->validate(true)->allowField(true)->save($_POST, ['id' =>$_POST['id']]);
            if(false !== $res){
                $this->success('更新成功！');
            } else {
               $error= $UcenterMember->getError();
                $this->error(empty($error) ? '未知错误！' : $error);
            }
        } 	    
    }
     /*修改密码*/
    public function modify(){
		if ( !is_login() ) {
			$this->error( "您还没有登陆",url("User/login") );
		}
        if (Request::instance()->isPost()) {
            //获取参数
            $uid = is_login();
            $password   =   input("post.old");
            $repassword = input("post.repassword");
            $data["password"] = input("post.password");
            empty($password) && $this->error("请输入原密码");
            empty($data["password"]) && $this->error("请输入新密码");
            empty($repassword) && $this->error("请输入确认密码");
            if($data["password"] !== $repassword){
                $this->error("您输入的新密码与确认密码不一致");
            }
            $data_auth_key=config("database.key");
			$map['id']=is_login();
            $data['password']=md5(sha1($repassword).$data_auth_key);
			$res =db('UcenterMember')->where($map)->update($data);
            if($res){
                $this->success("修改密码成功！");
            }else{
                $this->error($res["info"]);
            }
        }else{    
		     $this->meta_title = '修改密码';
			 $this->assign('meta_title', $this->meta_title);
             return $this->fetch();
        }
    }

}
