﻿IF OBJECT_ID(N'[dbo].[ResQuestionType]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResQuestionType];
GO
IF OBJECT_ID(N'[dbo].[ResQuestion]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResQuestion];
GO
IF OBJECT_ID(N'[dbo].[ResPaper]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResPaper];
GO
IF OBJECT_ID(N'[dbo].[ResPaperNode]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResPaperNode];
GO
IF OBJECT_ID(N'[dbo].[ResPaperNodeQuestion]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResPaperNodeQuestion];
GO
IF OBJECT_ID(N'[dbo].[ResPaperItem]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResPaperItem];
GO
IF OBJECT_ID(N'[dbo].[ResRandPaper]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResRandPaper];
GO
IF OBJECT_ID(N'[dbo].[ProTrainType]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProTrainType];
GO
IF OBJECT_ID(N'[dbo].[ProTrain]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProTrain];
GO
IF OBJECT_ID(N'[dbo].[ProTrainTest]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProTrainTest];
GO
IF OBJECT_ID(N'[dbo].[ProTrainAccount]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProTrainAccount];
GO
IF OBJECT_ID(N'[dbo].[ResLesson]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResLesson];
GO
IF OBJECT_ID(N'[dbo].[ProTrainLesson]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProTrainLesson];
GO
IF OBJECT_ID(N'[dbo].[ResLectuer]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResLectuer];
GO
IF OBJECT_ID(N'[dbo].[LibraryTask]', 'U') IS NOT NULL
    DROP TABLE [dbo].[LibraryTask];
GO
IF OBJECT_ID(N'[dbo].[ProTestGrade]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProTestGrade];
GO
IF OBJECT_ID(N'[dbo].[ProTestAnswer]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProTestAnswer];
GO
IF OBJECT_ID(N'[dbo].[ProGrade]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProGrade];
GO
IF OBJECT_ID(N'[dbo].[ProTrainGrade]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProTrainGrade];
GO
IF OBJECT_ID(N'[dbo].[ProTrainGradeDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProTrainGradeDetail];
GO
IF OBJECT_ID(N'[dbo].[HgNote]', 'U') IS NOT NULL
    DROP TABLE [dbo].HgNote;
GO
IF OBJECT_ID(N'[dbo].[ResForum]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResForum];
GO
IF OBJECT_ID(N'[dbo].[ResReply]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResReply];
GO
IF OBJECT_ID(N'[dbo].[ResComment]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResComment];
GO
IF OBJECT_ID(N'[dbo].[ResLike]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResLike];
GO
IF OBJECT_ID(N'[dbo].[ResFavorite]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResFavorite];
GO
IF OBJECT_ID(N'[dbo].[ResRead]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ResRead];
GO

IF OBJECT_ID(N'[dbo].[ProHistoryRecord]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ProHistoryRecord];
GO

IF OBJECT_ID(N'[dbo].[CmsSoftWareService]', 'U') IS NOT NULL
    DROP TABLE [dbo].[CmsSoftWareService];
GO
-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'ResQuestionType'
CREATE TABLE [dbo].[ResQuestionType] (
    [QuestionTypeId] int IDENTITY(1,1) NOT NULL,
    [TypeCode] nvarchar(16)  NOT NULL,
    [TypeName] nvarchar(32)  NOT NULL,
    [OrderFiled] int  NOT NULL,
    [Creator] bigint  NOT NULL,
    [CreateTime] datetime  NOT NULL
);
GO

-- Creating table 'ResQuestion'
CREATE TABLE [dbo].[ResQuestion] (
    [QuestionId] bigint IDENTITY(1,1) NOT NULL,
    [CatalogId] int  NOT NULL,
    [ParentQuestionId] bigint  NOT NULL,
    [QuestionTypeId] int  NOT NULL,
    [QuestionCode] nvarchar(64)  NOT NULL,
    [Source] nvarchar(36)  NULL,
    [QuestionBaseTypeCode] nvarchar(16)  NOT NULL,
    [OperateTypeCode] nvarchar(16)  NULL,
    [ExamTime] smallint  NOT NULL,
    [QuestionText] nvarchar(max)  NOT NULL,
    [HardGrade] nvarchar(16)  NOT NULL,
    [Score] decimal(18,2)  NOT NULL,
    [SelectAnswer] nvarchar(2000)  NULL,
    [SelectAnswerScore] nvarchar(50)  NULL,
    [EachOptionScore] decimal(18,2)  NOT NULL,
    [AnswerNum] smallint  NOT NULL,
    [StandardAnswer] nvarchar(max)  NOT NULL,
    [QuestionAnalysis] nvarchar(max) NULL,
    [OutdatedDate] datetime  NULL,
    [QuestionStatusCode] nvarchar(16)  NOT NULL,
    [ListOrder] int  NOT NULL,
    [Creator] bigint  NOT NULL,
    [CreateTime] datetime  NOT NULL,
    [Modifier] bigint  NULL,
    [ModifyTime] datetime  NOT NULL,
    [QuestionExt01] nvarchar(64)  NULL,
    [QuestionExt02] nvarchar(64)  NULL,
    [QuestionExt03] nvarchar(64)  NULL,
    [QuestionExt04] nvarchar(64)  NULL,
    [QuestionExt05] nvarchar(64)  NULL,
    [QuestionExt06] nvarchar(64)  NULL,
    [QuestionExt07] nvarchar(64)  NULL,
    [QuestionExt08] nvarchar(64)  NULL,
    [QuestionExt09] nvarchar(64)  NULL,
    [QuestionExt10] nvarchar(64)  NULL
);
GO

-- Creating table 'ResPaper'
CREATE TABLE [dbo].[ResPaper] (
    [PaperId] bigint IDENTITY(1,1) NOT NULL,
    [CatalogId] int  NOT NULL,
    [PaperNo] nvarchar(64)  NOT NULL,
    [PaperName] nvarchar(255)  NOT NULL,
    [SelectQuestionModeCode] int  NOT NULL,
    [StatusCode] int  NULL,
    [IsSingleAsMulti] smallint  NOT NULL,
    [EachOptionScore] decimal(18,2)  NOT NULL,
    [IsShowScore] smallint  NOT NULL,
    [PaperClassCode] nvarchar(16)  NULL,
    [ParentPaperId] bigint  NOT NULL,
    [TotalScore] decimal(18,2)  NOT NULL,
    [QuestionNum] int  NOT NULL,
    [Remarks] nvarchar(255)  NULL,
    [Creator] bigint  NOT NULL,
    [CreateTime] datetime  NOT NULL,
    [PlanTotalScore] decimal(18,2)  NOT NULL,
    [PaperXml] nvarchar(max)  NULL,
    [PaperHardGrade] int  NOT NULL,
    [OutdatedDate] datetime  NULL,
    [TestTime] int  NOT NULL,
    [IsOpenBook] smallint  NOT NULL,
    [IsAutoPass] smallint  NOT NULL,
    [PassGradeRate] decimal(18,2)  NOT NULL,
    [PassGradeScore] decimal(18,2)  NOT NULL,
    [IsDisruptOrder] smallint  NOT NULL,
    [UseStatus] smallint  NOT NULL,
    [PaperExt01] nvarchar(64)  NULL,
    [PaperExt02] nvarchar(64)  NULL,
    [PaperExt03] nvarchar(64)  NULL,
    [PaperExt04] nvarchar(64)  NULL,
    [PaperExt05] nvarchar(64)  NULL,
    [PaperExt06] nvarchar(64)  NULL,
    [PaperExt07] nvarchar(64)  NULL,
    [PaperExt08] nvarchar(64)  NULL,
    [PaperExt09] nvarchar(64)  NULL,
    [PaperExt010] nvarchar(max)  NULL,
    [PaperNote] nvarchar(640)  NOT NULL
);
GO

-- Creating table 'ResPaperNode'
CREATE TABLE [dbo].[ResPaperNode] (
    [PaperNodeId] bigint IDENTITY(1,1) NOT NULL,
    [PaperId] bigint  NOT NULL,
    [QuestionTypeId] int  NOT NULL,
    [PaperNodeName] nvarchar(64)  NOT NULL,
    [PaperNodeDesc] nvarchar(512)  NULL,
    [QuestionNum] int  NOT NULL,
    [QuestionScore] decimal(18,2)  NOT NULL,
    [QuestionTestTime] int  NOT NULL,
    [TotalScore] decimal(18,2)  NOT NULL,
    [ListOrder] int  NOT NULL
);
GO

-- Creating table 'ResPaperNodeQuestion'
CREATE TABLE [dbo].[ResPaperNodeQuestion] (
    [PaperNodeIdIndex] bigint IDENTITY(1,1) NOT NULL,
    [QuestionId] bigint  NOT NULL,
    [PaperId] bigint  NOT NULL,
    [PaperQuestionScore] decimal(18,2)  NOT NULL,
    [PaperQuestionExamTime] smallint  NOT NULL,
    [ListOrder] bigint  NOT NULL,
    [PaperNodeId] bigint  NOT NULL,
    [ExtendInfo] nvarchar(640)  NULL
);
GO

-- Creating table 'ResPaperItem'
CREATE TABLE [dbo].[ResPaperItem] (
    [PaperItemId] bigint IDENTITY(1,1) NOT NULL,
    [PaperId] bigint  NOT NULL,
    [PaperNodeId] bigint  NOT NULL,
    [QuestionTypeId] bigint  NOT NULL,
    [CatalogId] nvarchar(max)  NOT NULL,
    [QuestionNum] int  NOT NULL,
    [QuestionScore] decimal(18,2)  NOT NULL,
    [NotLimit] smallint  NOT NULL,
    [RubOne] int  NOT NULL,
    [RubTwo] int  NOT NULL,
    [RubThree] int  NOT NULL,
    [RubFour] int  NOT NULL,
    [RubFive] int  NOT NULL,
    [ExamTime] int  NOT NULL,
    [ListOrder] nvarchar(max)  NULL,
    [CatalogName] nvarchar(max)  NULL,
    [CatalogIds] nvarchar(1200)  NULL
);
GO

-- Creating table 'ResRandPaper'
CREATE TABLE [dbo].[ResRandPaper] (
    [Id] bigint IDENTITY(1,1) NOT NULL,
    [PaperId] bigint  NOT NULL,
    [RealQcount] int  NOT NULL,
    [DesignQcount] int  NOT NULL,
    [RandJsonPaerId] nvarchar(max)  NOT NULL,
    [Opeater] bigint  NOT NULL,
    [OperateDate] datetime  NOT NULL,
    [PaperSource] decimal(18,0)  NULL
);
GO

-- Creating table 'ProTrainType'
CREATE TABLE [dbo].[ProTrainType] (
    [TrainTypeId] bigint IDENTITY(1,1) NOT NULL,
    [TrainTypeName] nvarchar(64)  NOT NULL,
    [TrainTypeNo] nvarchar(36)  NOT NULL,
    [StatusCode] smallint  NOT NULL,
    [IsSystem] nvarchar(1)  NOT NULL,
    [Remarks] nvarchar(256)  NULL,
    [CreateTime] datetime  NOT NULL,
    [Creator] bigint  NOT NULL,
    [PreposeRule] nvarchar(max)  NULL,
    [PassRule] nvarchar(max)  NULL,
    [IntegralRule] nvarchar(max)  NULL,
    [PreposeRuleView] nvarchar(max)  NULL,
    [PassRuleView] nvarchar(max)  NULL,
    [IntegralRuleView] nvarchar(max)  NULL,
    [IsEditableRule] smallint  NOT NULL,
    [IsNote] smallint  NOT NULL,
    [IsQuestion] smallint  NOT NULL,
    [ProItem] nvarchar(64)  NULL
);
GO

-- Creating table 'ProTrain'
CREATE TABLE [dbo].[ProTrain] (
    [TrainId] bigint IDENTITY(1,1) NOT NULL,
    [CatalogId] int  NOT NULL,
    [TrainNo] nvarchar(64)  NOT NULL,
    [TrainName] nvarchar(max)  NOT NULL,
    [TmplateId] bigint  NOT NULL,
    [TrainTypeId] bigint  NOT NULL,
    [EnableIntegral] nvarchar(1)  NOT NULL,
    [Remark] nvarchar(256)  NULL,
    [Introduction] nvarchar(max)  NULL,
    [StatusCode] nvarchar(16)  NOT NULL,
    [ListOrder] int  NOT NULL,
    [PreposeRule] nvarchar(max)  NULL,
    [PreposeRuleView] nvarchar(max)  NULL,
    [PassRule] nvarchar(max)  NULL,
    [PassRuleView] nvarchar(max)  NULL,
    [IntegralRule] nvarchar(max)  NULL,
    [IntegralRuleView] nvarchar(max)  NULL,
    [BeginTime] datetime  NULL,
    [EndTime] datetime  NULL,
    [Creator] bigint  NOT NULL,
    [CreateTime] datetime  NOT NULL,
    [UpdateTime] datetime  NOT NULL,
    [TrainExt01] nvarchar(64)  NULL,
    [TrainExt02] nvarchar(64)  NULL,
    [TrainExt03] nvarchar(64)  NULL,
    [TrainExt04] nvarchar(64)  NULL,
    [TrainExt05] nvarchar(64)  NULL,
    [TrainExt06] nvarchar(64)  NULL,
    [TrainExt07] nvarchar(64)  NULL,
    [TrainExt08] nvarchar(64)  NULL,
    [TrainExt09] nvarchar(64)  NULL,
    [TrainExt10] nvarchar(64)  NULL
);
GO

-- Creating table 'ProTrainTest'
CREATE TABLE [dbo].[ProTrainTest] (
    [ItemId] bigint IDENTITY(1,1) NOT NULL,
    [TrainId] bigint  NOT NULL,
    [PaperId] bigint  NOT NULL,
    [PaperName] nvarchar(64)  NOT NULL,
    [TestTime] int  NOT NULL,
    [AllowTimes] int  NOT NULL,
    [AllowReexamTimes] int  NOT NULL,
    [beginTime] datetime  NOT NULL,
    [EndTime] datetime  NOT NULL,
    [IsOpenBook] nvarchar(1)  NOT NULL,
    [TestModel] nvarchar(16)  NOT NULL,
    [IsOrderQuestion] nvarchar(1)  NOT NULL,
    [AccountId] bigint  NOT NULL,
    [AccountName] nvarchar(64)  NOT NULL,
    [PassGradeRate] decimal(18,2)  NOT NULL,
    [PassGradeScore] decimal(18,2)  NOT NULL,
    [ListOrder] int  NOT NULL,
    [Integral] decimal(18,2)  NOT NULL,
    [AllowShowPaper] nvarchar(1)  NOT NULL,
    [IsEndTime] nvarchar(1)  NOT NULL,
    [IsAllowBatch] nvarchar(1)  NOT NULL,
    [TestType] nvarchar(16)  NOT NULL,
    [GetScoreRule] nvarchar(640)  NULL,
    [IsViewGrade] nvarchar(1)  NULL,
    [LateTime] int  NULL,
    [ProhibitTime] int  NULL
);
GO

-- Creating table 'ProTrainAccount'
CREATE TABLE [dbo].[ProTrainAccount] (
    [TrainAccountId] bigint IDENTITY(1,1) NOT NULL,
    [TrainId] bigint  NOT NULL,
    [OwnerId] int  NOT NULL,
    [IsFromBatch] nvarchar(1)  NOT NULL,
    [IsReexam] nvarchar(1)  NOT NULL,
    [OwnerTypeCode] smallint  NOT NULL
);
GO

-- Creating table 'ResLesson'
CREATE TABLE [dbo].[ResLesson] (
    [LessonId] bigint IDENTITY(1,1) NOT NULL,
    [LessonCode] nvarchar(64)  NOT NULL,
    [LessonName] nvarchar(64)  NOT NULL,
    [CatalogId] int  NOT NULL,
    [ContenType] nvarchar(64)  NOT NULL,
    [LessonIntegral] decimal(18,2)  NOT NULL,
    [LessonHour] decimal(18,2)  NOT NULL,
    [LectuerId] bigint  NULL,
    [LectuerName] nvarchar(64)  NULL,
    [TrainOrgId] bigint  NOT NULL,
    [LessonStatusCode] smallint  NOT NULL,
    [LessonTypeCode] nvarchar(32)  NULL,
    [EntranceFile] nvarchar(255)  NULL,
    [Version] nvarchar(255)  NULL,
    [LessonInTroduction] nvarchar(640)  NULL,
    [SourceUrl] nvarchar(256)  NULL,
    [ViewUrl] nvarchar(256)  NULL,
    [CreateTime] datetime  NULL,
    [Creator] bigint  NOT NULL,
    [Remarks] nvarchar(4000)  NULL,
    [OldFileName] nvarchar(64)  NULL,
    [LessonType] nvarchar(64)  NULL,
    [LearnCount] int  NULL,
    [Recommend] bit  NULL,
    [LessonExt01] nvarchar(256)  NULL,
    [LessonExt02] nvarchar(256)  NULL,
    [LessonExt03] nvarchar(256)  NULL,
    [LessonExt04] nvarchar(256)  NULL,
    [LessonExt05] nvarchar(256)  NULL,
    [BrowseCount] int  NULL,
    [CommentCount] int  NULL,
    [OPens] bit  NULL
);
GO

-- Creating table 'ProTrainLesson'
CREATE TABLE [dbo].[ProTrainLesson] (
    [ItemId] bigint IDENTITY(1,1) NOT NULL,
    [TrainId] bigint  NOT NULL,
    [LessonId] bigint  NOT NULL,
    [LessonName] nvarchar(32)  NOT NULL,
    [Integral] decimal(18,2)  NOT NULL,
    [LessonType] nvarchar(16)  NOT NULL,
    [BeginTime] datetime  NULL,
    [EndTime] datetime  NULL,
    [ListOrder] int  NOT NULL,
	[LessonHours] decimal(18,2) NULL
);
GO

-- Creating table 'ResLectuer'
CREATE TABLE [dbo].[ResLectuer] (
    [LectuerId] bigint IDENTITY(1,1) NOT NULL,
    [LectuerCode] nvarchar(64)  NOT NULL,
    [LectuerName] nvarchar(64)  NOT NULL,
    [CatalogId] int  NOT NULL,
    [Telephone] nvarchar(32)  NOT NULL,
    [Sex] nvarchar(8)  NOT NULL,
    [LectuerLevel] nvarchar(36)  NOT NULL,
    [LectuerTitle] nvarchar(64)  NULL,
    [Intruduction] nvarchar(1600)  NULL,
    [Creator] bigint  NOT NULL,
    [CreateTime] datetimeoffset  NULL,
    [LectuerExt01] nvarchar(256)  NULL,
    [LectuerExt02] nvarchar(256)  NULL,
    [LectuerExt03] nvarchar(256)  NULL,
    [LectuerExt04] nvarchar(256)  NULL,
    [LectuerExt05] nvarchar(256)  NULL,
    [LectuerExt06] nvarchar(256)  NULL,
    [LectuerExt07] nvarchar(256)  NULL,
    [LectuerExt08] nvarchar(256)  NULL,
    [LectuerExt09] nvarchar(256)  NULL,
    [LectuerExt10] nvarchar(256)  NULL
);
GO

-- Creating table 'LibraryTask'
CREATE TABLE [dbo].[LibraryTask] (
    [TaskId] int IDENTITY(1,1) NOT NULL,
    [RelationId] int  NOT NULL,
    [CaseCode] nvarchar(64)  NULL,
    [FileName] nvarchar(512)  NOT NULL,
    [StorageDirectory] nvarchar(512)  NOT NULL,
    [UserId] int  NOT NULL,
    [imageName] nvarchar(128)  NULL,
    [CreateTime] datetime  NULL
);
GO

-- Creating table 'ProTestGrade'
CREATE TABLE [dbo].[ProTestGrade] (
    [GradeId] nvarchar(64)  NOT NULL,
    [AccountId] bigint  NOT NULL,
    [TrainId] bigint  NOT NULL,
    [PaperId] bigint  NOT NULL,
    [AttendPaperId] bigint  NOT NULL,
    [TotalScore] decimal(18,2)  NOT NULL,
    [BeginTime] datetime  NOT NULL,
    [EndTime] datetime  NOT NULL,
    [LastUpdateTime] datetime  NOT NULL,
    [TestTime] decimal(18,0) NULL,
    [GradeScore] decimal(18,2)  NOT NULL,
    [GradeRate] decimal(18,2)  NOT NULL,
    [IsPass] nvarchar(1)  NOT NULL,
    [StatusCode] smallint  NOT NULL,
    [HasSaveAnswerToDb] nvarchar(1)  NOT NULL,
    [IsReExam] nvarchar(1)  NOT NULL,
    [UserAnswer] nvarchar(max) NULL,
    [LastTestIp] nvarchar(36)  NULL,
    [IsValid] nvarchar(1)  NOT NULL,
    [EarnIntegral] decimal(18,2)  NOT NULL
);
GO

-- Creating table 'ProTestAnswer'
CREATE TABLE [dbo].[ProTestAnswer] (
    [GradeId] bigint IDENTITY(1,1) NOT NULL,
    [QuestionId] bigint  NOT NULL,
    [AnswerText] nvarchar(max)  NOT NULL,
    [AnswerTime] int  NOT NULL,
    [JudgeScore] decimal(18,2)  NOT NULL,
    [JudgeResult] nvarchar(16)  NOT NULL,
    [JudgeRemarks] nvarchar(255)  NOT NULL,
    [TestGradeid] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'ProGrade'
CREATE TABLE [dbo].[ProGrade] (
    [GradeId] bigint IDENTITY(1,1) NOT NULL,
    [AccountId] bigint  NOT NULL,
    [TrainId] bigint  NOT NULL,
    [BeginTime] datetime  NOT NULL,
    [EndTime] datetime  NOT NULL,
    [IntegralScore] decimal(18,2)  NOT NULL,
    [StatusCode] nvarchar(16)  NOT NULL,
    [IsReport] nvarchar(1)  NOT NULL,
    [Remark] nvarchar(max)  NOT NULL
);
GO

-- Creating table 'ProTrainGrade'
CREATE TABLE [dbo].[ProTrainGrade] (
    [TrainGradeId] bigint IDENTITY(1,1) NOT NULL,
    [AccountId] bigint  NOT NULL,
    [TrainId] bigint  NOT NULL,
    [LessonId] bigint  NOT NULL,
    [AttendTimes] int  NOT NULL,
    [AttendHour] decimal(18,2)  NOT NULL,
    [BeginTime] datetime  NULL,
    [EndTime] datetime  NULL,
    [SrcomScore] decimal(18,2)  NOT NULL,
    [TestScore] decimal(18,2)  NOT NULL,
    [IsPassTest] nvarchar(1)  NOT NULL,
    [LessonGrade] nvarchar(36)  NULL,
    [GradeStatusCode] nvarchar(16)  NOT NULL,
    [IsTeatcherJudged] nvarchar(1)  NOT NULL,
    [IsPass] nvarchar(1)  NOT NULL,
    [GradeRemark] nvarchar(max)  NULL,
    [EarnIntegral] decimal(18,2)  NOT NULL,
    [TrainFee] decimal(18,2)  NOT NULL,
    [Creator] bigint  NOT NULL,
    [CreateTime] datetime  NULL,
    [RestudyNum] int  NOT NULL,
    [LessonUpdateTime] datetime  NULL,
    [QnsResult] nvarchar(255)  NULL
);
GO

-- Creating table 'ProTrainGradeDetail'
CREATE TABLE [dbo].[ProTrainGradeDetail] (
    [Id] bigint IDENTITY(1,1) NOT NULL,
    [TrainGradeId] bigint  NOT NULL,
    [BeginTime] datetime  NULL,
    [EndTime] datetime  NULL,
    [AttendHour] decimal(18,2)  NOT NULL,
    [IsOnline] nvarchar(max)  NULL,
    [CurrentPoint] decimal(18,2)  NOT NULL
);
GO

-- Creating table 'HgNote'
CREATE TABLE [dbo].[HgNote] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [LessionId] int  NOT NULL,
    [MemberId] int  NOT NULL,
    [NoteContent] nvarchar(max)  NOT NULL,
    [NoteUrl] nvarchar(max)  NULL,
    [PlayTime] nvarchar(max) NULL,
    [NoteCustomer1] nvarchar(max)  NULL,
    [NoteCustomer2] nvarchar(max)  NULL,
    [NoteCustomer3] nvarchar(max)  NULL
);
Go

-- Creating table 'ResForum'
CREATE TABLE [dbo].[ResForum] (
    [ForumId] int IDENTITY(1,1) NOT NULL,
    [Subject] nvarchar(256)  NOT NULL,
    [Content] nvarchar(max)  NOT NULL,
    [PostId] int  NOT NULL,
    [PostName] nvarchar(64)  NOT NULL,
    [PostIP] nvarchar(32)  NULL,
    [PostTime] datetime  NOT NULL,
    [ReturnID] int  NULL,
    [ReturnNumber] int  NULL,
    [LabelCode] nvarchar(32)  NULL,
    [LookCount] int  NULL,
    [ReplyCount] int  NULL,
    [Accusation] nvarchar(128)  NULL
);
GO

-- Creating table 'ResReply'
CREATE TABLE [dbo].[ResReply] (
    [ReplyId] int IDENTITY(1,1) NOT NULL,
    [ReplyCode] nvarchar(32)  NULL,
    [ReplyCodeId] int  NOT NULL,
    [Content] nvarchar(max)  NOT NULL,
    [ReplyUserId] int  NOT NULL,
    [ReplyUserName] nvarchar(32)  NOT NULL,
    [ReplyIp] nvarchar(32)  NULL,
    [ReplyTime] datetime  NOT NULL,
    [Remaark] nvarchar(256)  NULL,
    [Accusation] nvarchar(128)  NULL
);
GO

-- Creating table 'ResComment'
CREATE TABLE [dbo].[ResComment] (
    [CommentId] int IDENTITY(1,1) NOT NULL,
    [Content] nvarchar(max)  NOT NULL,
    [CommentName] nvarchar(200)  NULL,
    [CommentUserId] int  NULL,
    [CommentIp] nvarchar(100)  NULL,
    [CommentTime] datetime  NULL,
    [TrainId] int  NULL,
    [CommentType] nvarchar(50)  NOT NULL,
    [Custom1] nvarchar(200)  NULL,
    [Custom2] nvarchar(200)  NULL,
    [Custom3] nvarchar(200)  NULL
);
GO

-- Creating table 'ResLike'
CREATE TABLE [dbo].[ResLike] (
    [LikeId] int IDENTITY(1,1) NOT NULL,
    [LikeType] nvarchar(32)  NOT NULL,
    [RelatId] int  NOT NULL,
    [LikeTime] datetime  NOT NULL,
    [LikeState] bit  NOT NULL,
    [LikeExtend1] nvarchar(256)  NULL,
    [LikeExtend2] nvarchar(256)  NULL,
    [LikeExtend3] nvarchar(256)  NULL,
    [LikeUserId] int  NOT NULL
);
GO

-- Creating table 'ResFavorite'
CREATE TABLE [dbo].[ResFavorite] (
    [FavoriteId] int IDENTITY(1,1) NOT NULL,
    [FavoriteType] nvarchar(32)  NOT NULL,
    [RelatId] int  NOT NULL,
    [FavoriteUserId] int  NOT NULL,
    [FavoriteTime] datetime  NOT NULL,
    [FavoriteState] bit  NOT NULL,
    [FavoriteExtend1] nvarchar(256)  NULL,
    [FavoriteExtend2] nvarchar(256)  NULL,
    [FavoriteExtend3] nvarchar(256)  NULL
);
GO

-- Creating table 'ResRead'
CREATE TABLE [dbo].[ResRead] (
    [ReadId] int IDENTITY(1,1) NOT NULL,
    [ReadType] nvarchar(max)  NOT NULL,
    [RelatId] int  NOT NULL,
    [ReadUserId] int  NOT NULL,
    [ReadTime] nvarchar(max)  NOT NULL,
    [ReadCount] nvarchar(max)  NOT NULL,
    [ReadExtend1] nvarchar(256)  NULL,
    [ReadExtend2] nvarchar(256)  NULL,
    [ReadExtend3] nvarchar(256)  NULL
);
GO

-- Creating table 'ProHistoryRecord'
CREATE TABLE [dbo].[ProHistoryRecord] (
    [RecordId] int IDENTITY(1,1) NOT NULL,
    [RecordName] nvarchar(256)  NULL,
    [RecordType] nvarchar(56)  NULL,
    [TypeCodeId] int  NULL,
    [UserId] int  NULL,
    [UserName] nvarchar(56)  NULL,
    [RecordTime] datetime  NULL,
    [Record1] nvarchar(256)  NULL,
    [Record2] nvarchar(256)  NULL,
    [RecordCount] bigint  NULL
);
GO

-- Creating table 'CmsSoftWareService'
CREATE TABLE [dbo].[CmsSoftWareService] (
    [SoftId] int IDENTITY(1,1) NOT NULL,
    [SoftName] nvarchar(256)  NULL,
    [Picurl] nvarchar(256)  NULL,
    [Introduction] nvarchar(max)  NULL,
    [ApplicationUrl] nvarchar(256)  NULL,
    [Remark] nvarchar(max)  NULL,
    [OrderByNum] int  NULL,
    [ReleaseDate] datetime  NOT NULL,
    [RealName] nvarchar(256)  NULL,
    [UserId] int  NULL,
    [NewPath] nvarchar(20)  NULL,
    [Content] nvarchar(max)  NULL,
    [Custome1] nvarchar(max)  NULL,
    [Custome2] nvarchar(max)  NULL
);
GO
-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------
-- Creating primary key on [CommentId] in table 'ResComment'
ALTER TABLE [dbo].[ResComment]
ADD CONSTRAINT [PK_ResComment]
    PRIMARY KEY CLUSTERED ([CommentId] ASC);
GO

-- Creating primary key on [QuestionTypeId] in table 'ResQuestionType'
ALTER TABLE [dbo].[ResQuestionType]
ADD CONSTRAINT [PK_ResQuestionType]
    PRIMARY KEY CLUSTERED ([QuestionTypeId] ASC);
GO

-- Creating primary key on [QuestionId] in table 'ResQuestion'
ALTER TABLE [dbo].[ResQuestion]
ADD CONSTRAINT [PK_ResQuestion]
    PRIMARY KEY CLUSTERED ([QuestionId] ASC);
GO

-- Creating primary key on [PaperId] in table 'ResPaper'
ALTER TABLE [dbo].[ResPaper]
ADD CONSTRAINT [PK_ResPaper]
    PRIMARY KEY CLUSTERED ([PaperId] ASC);
GO


-- Creating primary key on [ForumId] in table 'ResForum'
ALTER TABLE [dbo].[ResForum]
ADD CONSTRAINT [PK_ResForum]
    PRIMARY KEY CLUSTERED ([ForumId] ASC);
GO

-- Creating primary key on [PaperNodeId] in table 'ResPaperNode'
ALTER TABLE [dbo].[ResPaperNode]
ADD CONSTRAINT [PK_ResPaperNode]
    PRIMARY KEY CLUSTERED ([PaperNodeId] ASC);
GO

-- Creating primary key on [PaperNodeIdIndex] in table 'ResPaperNodeQuestion'
ALTER TABLE [dbo].[ResPaperNodeQuestion]
ADD CONSTRAINT [PK_ResPaperNodeQuestion]
    PRIMARY KEY CLUSTERED ([PaperNodeIdIndex] ASC);
GO

-- Creating primary key on [PaperItemId] in table 'ResPaperItem'
ALTER TABLE [dbo].[ResPaperItem]
ADD CONSTRAINT [PK_ResPaperItem]
    PRIMARY KEY CLUSTERED ([PaperItemId] ASC);
GO

-- Creating primary key on [Id] in table 'ResRandPaper'
ALTER TABLE [dbo].[ResRandPaper]
ADD CONSTRAINT [PK_ResRandPaper]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [TrainTypeId] in table 'ProTrainType'
ALTER TABLE [dbo].[ProTrainType]
ADD CONSTRAINT [PK_ProTrainType]
    PRIMARY KEY CLUSTERED ([TrainTypeId] ASC);
GO

-- Creating primary key on [TrainId] in table 'ProTrain'
ALTER TABLE [dbo].[ProTrain]
ADD CONSTRAINT [PK_ProTrain]
    PRIMARY KEY CLUSTERED ([TrainId] ASC);
GO

-- Creating primary key on [ItemId] in table 'ProTrainTest'
ALTER TABLE [dbo].[ProTrainTest]
ADD CONSTRAINT [PK_ProTrainTest]
    PRIMARY KEY CLUSTERED ([ItemId] ASC);
GO

-- Creating primary key on [TrainAccountId] in table 'ProTrainAccount'
ALTER TABLE [dbo].[ProTrainAccount]
ADD CONSTRAINT [PK_ProTrainAccount]
    PRIMARY KEY CLUSTERED ([TrainAccountId] ASC);
GO

-- Creating primary key on [LessonId] in table 'ResLesson'
ALTER TABLE [dbo].[ResLesson]
ADD CONSTRAINT [PK_ResLesson]
    PRIMARY KEY CLUSTERED ([LessonId] ASC);
GO

-- Creating primary key on [ItemId] in table 'ProTrainLesson'
ALTER TABLE [dbo].[ProTrainLesson]
ADD CONSTRAINT [PK_ProTrainLesson]
    PRIMARY KEY CLUSTERED ([ItemId] ASC);
GO

-- Creating primary key on [LectuerId] in table 'ResLectuer'
ALTER TABLE [dbo].[ResLectuer]
ADD CONSTRAINT [PK_ResLectuer]
    PRIMARY KEY CLUSTERED ([LectuerId] ASC);
GO

-- Creating primary key on [TaskId] in table 'LibraryTask'
ALTER TABLE [dbo].[LibraryTask]
ADD CONSTRAINT [PK_LibraryTask]
    PRIMARY KEY CLUSTERED ([TaskId] ASC);
GO

-- Creating primary key on [GradeId] in table 'ProTestGrade'
ALTER TABLE [dbo].[ProTestGrade]
ADD CONSTRAINT [PK_ProTestGrade]
    PRIMARY KEY CLUSTERED ([GradeId] ASC);
GO

-- Creating primary key on [GradeId] in table 'ProTestAnswer'
ALTER TABLE [dbo].[ProTestAnswer]
ADD CONSTRAINT [PK_ProTestAnswer]
    PRIMARY KEY CLUSTERED ([GradeId] ASC);
GO

-- Creating primary key on [GradeId] in table 'ProGrade'
ALTER TABLE [dbo].[ProGrade]
ADD CONSTRAINT [PK_ProGrade]
    PRIMARY KEY CLUSTERED ([GradeId] ASC);
GO

-- Creating primary key on [TrainGradeId] in table 'ProTrainGrade'
ALTER TABLE [dbo].[ProTrainGrade]
ADD CONSTRAINT [PK_ProTrainGrade]
    PRIMARY KEY CLUSTERED ([TrainGradeId] ASC);
GO

-- Creating primary key on [Id] in table 'ProTrainGradeDetail'
ALTER TABLE [dbo].[ProTrainGradeDetail]
ADD CONSTRAINT [PK_ProTrainGradeDetail]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'HgNote'
ALTER TABLE [dbo].[HgNote]
ADD CONSTRAINT [PK_HgNote]
    PRIMARY KEY CLUSTERED ([Id] ASC);
Go

-- Creating primary key on [ReplyId] in table 'ResReply'
ALTER TABLE [dbo].[ResReply]
ADD CONSTRAINT [PK_ResReply]
    PRIMARY KEY CLUSTERED ([ReplyId] ASC);
GO


-- Creating primary key on [LikeId] in table 'ResLike'
ALTER TABLE [dbo].[ResLike]
ADD CONSTRAINT [PK_ResLike]
    PRIMARY KEY CLUSTERED ([LikeId] ASC);
GO

-- Creating primary key on [FavoriteId] in table 'ResFavorite'
ALTER TABLE [dbo].[ResFavorite]
ADD CONSTRAINT [PK_ResFavorite]
    PRIMARY KEY CLUSTERED ([FavoriteId] ASC);
GO

-- Creating primary key on [ReadId] in table 'ResRead'
ALTER TABLE [dbo].[ResRead]
ADD CONSTRAINT [PK_ResRead]
    PRIMARY KEY CLUSTERED ([ReadId] ASC);
GO

-- Creating primary key on [RecordId] in table 'ProHistoryRecord'
ALTER TABLE [dbo].[ProHistoryRecord]
ADD CONSTRAINT [PK_ProHistoryRecord]
    PRIMARY KEY CLUSTERED ([RecordId] ASC);
GO
-- Creating primary key on [SoftId] in table 'CmsSoftWareService'
ALTER TABLE [dbo].[CmsSoftWareService]
ADD CONSTRAINT [PK_CmsSoftWareService]
    PRIMARY KEY CLUSTERED ([SoftId] ASC);
GO
-- Creating table 'HgCatalogLink'
CREATE TABLE [dbo].[HgCatalogLink] (
    [IndexId] int IDENTITY(1,1) NOT NULL,
    [CatalogId] int  NOT NULL,
    [RelateCatalogId] int  NOT NULL,
    [RelateDate] datetime  NOT NULL
);