﻿
IF OBJECT_ID(N'[dbo].[CmsNews]', 'U') IS NOT NULL
    DROP TABLE [dbo].[CmsNews];
GO
IF OBJECT_ID(N'[dbo].[CmsFiles]', 'U') IS NOT NULL
    DROP TABLE [dbo].[CmsFiles];
GO

IF OBJECT_ID(N'[dbo].[CmsWeChatInfo]', 'U') IS NOT NULL
    DROP TABLE [dbo].[CmsWeChatInfo];
GO

IF OBJECT_ID(N'[dbo].[CmsWeChatUser]', 'U') IS NOT NULL
    DROP TABLE [dbo].[CmsWeChatUser];
GO
IF OBJECT_ID(N'[dbo].[CmsSoftWareService]', 'U') IS NOT NULL
    DROP TABLE [dbo].[CmsSoftWareService];
GO
-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------
-- Creating table 'WeChatUser'
CREATE TABLE [dbo].[CmsWeChatUser] (
    [UserId] int IDENTITY(1,1) NOT NULL,
    [OpenId] nvarchar(100)  NULL,
    [Subscribe] nvarchar(100)  NULL,
    [Nickname] nvarchar(100)  NULL,
    [Sex] nvarchar(100)  NULL,
    [Language] nvarchar(100)  NULL,
    [City] nvarchar(100)  NULL,
    [Province] nvarchar(100)  NULL,
    [Country] nvarchar(100)  NULL,
    [Headimgurl] nvarchar(MAX)  NULL,
    [Subscribe_time] nvarchar(100)  NULL,
    [Remark] nvarchar(max)  NULL,
    [Groupid] nvarchar(100)  NULL
);
GO
-- Creating table 'CmsNews'
CREATE TABLE [dbo].[CmsNews] (
    [NewId] int IDENTITY(1,1) NOT NULL,
    [CatalogId] int  NOT NULL,
    [Title] nvarchar(200)  NULL,
    [NewPath] nvarchar(20)  NULL,
    [KeyBoard] nvarchar(max)  NULL,
    [ContactId] nvarchar(max)  NULL,
    [UserId] nvarchar(max)  NULL,
    [SubjectId] int  NULL,
    [Checked] bit  NULL,
    [TopLevel] int  NULL,
    [ReleaseDate] nvarchar(20)  NULL,
    [ReleaseTime] nvarchar(20)  NULL,
    [IsComment] bit  NULL,
    [CommentCount] int  NULL,
    [BrowseNumber] int  NULL,
    [FirstTitle] bit  NULL,
    [Summary] nvarchar(2000)  NULL,
    [Subtitle] nvarchar(200)  NULL,
    [Custom1] nvarchar(200)  NULL,
    [Custom2] nvarchar(200)  NULL,
    [Custom3] nvarchar(200)  NULL,
    [Custom4] nvarchar(200)  NULL,
    [Custom5] nvarchar(200)  NULL,
    [NewImg] nvarchar(200)  NULL
);
GO

-- Creating table 'CmsFiles'
CREATE TABLE [dbo].[CmsFiles] (
    [FileId] int IDENTITY(1,1) NOT NULL,
    [CatalogId] int  NOT NULL,
    [Title] nvarchar(200)  NOT NULL,
    [FilePath] nvarchar(20)  NULL,
    [KeyBoard] nvarchar(200)  NULL,
    [Checked] bit  NULL,
    [UpDateTime] nvarchar(20)  NULL,
    [UpTrueDate] nvarchar(20)  NULL,
    [DownCount] int  NULL,
    [FileSize] float  NULL,
    [Language] nvarchar(20)  NULL,
    [BeginDate] nvarchar(20)  NULL,
    [EndDate] nvarchar(20)  NULL,
    [FileTypeCode] nvarchar(20)  NULL,
    [FileNo] nvarchar(20)  NULL,
    [ContactId] nvarchar(200)  NULL,
    [FileImg] nvarchar(100)  NULL,
    [CreateUserName] nvarchar(20)  NULL,
    [SubjectId] int  NULL,
    [TopLevel] int  NULL,
    [IsComment] bit  NULL,
    [CommentCoun] int  NULL,
    [IsArchived] bit  NULL,
    [Summary] nvarchar(2000)  NULL,
    [DesPath] nvarchar(20)  NULL,
    [Subtitle] nvarchar(200)  NULL,
    [Custom1] nvarchar(200)  NULL,
    [Custom2] nvarchar(200)  NULL,
    [Custom3] nvarchar(200)  NULL,
    [Custom4] nvarchar(200)  NULL,
    [Custom5] nvarchar(200)  NULL,
    [CreateUserId] int  NOT NULL,
    [CommentCount] int  NULL
);
GO
-- Creating table 'CmsWeChatInfo'
CREATE TABLE [dbo].[CmsWeChatInfo] (
    [WeChatInfoId] bigint IDENTITY(1,1) NOT NULL,
    [ToUserName] varchar(50)  NULL,
    [FromUserName] varchar(50)  NULL,
    [CreateTime] datetime  NULL,
    [WeChatContent] varchar(max)  NULL,
    [MsgType] varchar(50)  NULL,
    [EventName] varchar(50)  NULL,
    [PublicName] nvarchar(50)  NULL,
    [NickName] nvarchar(50)  NULL
);
GO
-- Creating table 'WeChatMsgRecord'
CREATE TABLE [dbo].[CmsWeChatMsgRecord] (
    [MsgRecordId] int IDENTITY(1,1) NOT NULL,
    [FromUserId] nvarchar(255)  NULL,
    [ToUserId] nvarchar(255)  NULL,
    [CreateTime] datetime  NULL,
    [Content] nvarchar(2000)  NULL,
    [FromUserName] nvarchar(128)  NULL,
    [ToUserName] nvarchar(128)  NULL
);
GO

-- Creating table 'CmsSoftWareService'
CREATE TABLE [dbo].[CmsSoftWareService] (
    [SoftId] int IDENTITY(1,1) NOT NULL,
    [SoftName] nvarchar(256)  NULL,
    [Picurl] nvarchar(256)  NULL,
    [Introduction] nvarchar(max)  NULL,
    [ApplicationUrl] nvarchar(256)  NULL,
    [Remark] nvarchar(max)  NULL,
    [OrderByNum] int  NULL,
    [ReleaseDate] datetime  NOT NULL,
    [RealName] nvarchar(256)  NULL,
    [UserId] int  NULL,
    [NewPath] nvarchar(20)  NULL,
    [Content] nvarchar(max)  NULL,
    [Custome1] nvarchar(max)  NULL,
    [Custome2] nvarchar(max)  NULL
);
GO
-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [NewId] in table 'CmsNews'
ALTER TABLE [dbo].[CmsNews]
ADD CONSTRAINT [PK_CmsNews]
    PRIMARY KEY CLUSTERED ([NewId] ASC);
GO

-- Creating primary key on [FileId] in table 'CmsFiles'
ALTER TABLE [dbo].[CmsFiles]
ADD CONSTRAINT [PK_CmsFiles]
    PRIMARY KEY CLUSTERED ([FileId] ASC);
GO
-- Creating primary key on [WeChatInfoId] in table 'CmsWeChatInfo'
ALTER TABLE [dbo].[CmsWeChatInfo]
ADD CONSTRAINT [PK_CmsWeChatInfo]
    PRIMARY KEY CLUSTERED ([WeChatInfoId] ASC);
GO

-- Creating primary key on [UserId] in table 'WeChatUser'
ALTER TABLE [dbo].[CmsWeChatUser]
ADD CONSTRAINT [PK_CmsWeChatUser]
    PRIMARY KEY CLUSTERED ([UserId] ASC);
GO

-- Creating primary key on [MsgRecordId] in table 'WeChatMsgRecord'
ALTER TABLE [dbo].[CmsWeChatMsgRecord]
ADD CONSTRAINT [PK_CmsWeChatMsgRecord]
    PRIMARY KEY CLUSTERED ([MsgRecordId] ASC);
GO
-- Creating primary key on [SoftId] in table 'CmsSoftWareService'
ALTER TABLE [dbo].[CmsSoftWareService]
ADD CONSTRAINT [PK_CmsSoftWareService]
    PRIMARY KEY CLUSTERED ([SoftId] ASC);
GO