﻿
-- --------------------------------------------------
-- Dropping existing FOREIGN KEY constraints
-- --------------------------------------------------
IF OBJECT_ID(N'[dbo].[FK_ErpReCustomerOrder]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpOrder] DROP CONSTRAINT [FK_ErpReCustomerOrder];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReOrderDetail]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpOrderDetail] DROP CONSTRAINT [FK_ErpReOrderDetail];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReOrderPaymentRecord]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpPaymentRecord] DROP CONSTRAINT [FK_ErpReOrderPaymentRecord];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReAddressOrder]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpOrder] DROP CONSTRAINT [FK_ErpReAddressOrder];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReOrderDelivery]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpDelivery] DROP CONSTRAINT [FK_ErpReOrderDelivery];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReCustomerAddress]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpAddress] DROP CONSTRAINT [FK_ErpReCustomerAddress];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReOnlineProductAttr]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpOnlineProductAttr] DROP CONSTRAINT [FK_ErpReOnlineProductAttr];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReOnlineProductSpec]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpOnlineProductSpec] DROP CONSTRAINT [FK_ErpReOnlineProductSpec];
GO
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ErpCatalogAttribute]') AND name = N'index_catalog_relation')
DROP INDEX [index_catalog_relation] ON [dbo].[ErpCatalogAttribute] WITH ( ONLINE = OFF )
GO
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ErpAttributeValue]') AND name = N'index_attribute_relation')
DROP INDEX [index_attribute_relation] ON [dbo].[ErpAttributeValue] WITH ( ONLINE = OFF )
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReCatalogAttributeValue]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpAttributeValue] DROP CONSTRAINT [FK_ErpReCatalogAttributeValue];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReProductLogistic]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpProductLogistic] DROP CONSTRAINT [FK_ErpReProductLogistic];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReProductSpec]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpProductSpec] DROP CONSTRAINT [FK_ErpReProductSpec];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReProductSupplier]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpProductSupplier] DROP CONSTRAINT [FK_ErpReProductSupplier];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpRESupplierProduct]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpProductSupplier] DROP CONSTRAINT [FK_ErpRESupplierProduct];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReProductSpecTem]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpProduct] DROP CONSTRAINT [FK_ErpReProductSpecTem];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReProductSupplierOffer]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpProductSupplierOffer] DROP CONSTRAINT [FK_ErpReProductSupplierOffer];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReSupplierProductOffer]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpProductSupplierOffer] DROP CONSTRAINT [FK_ErpReSupplierProductOffer];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpReMessageGroup]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpMessage] DROP CONSTRAINT [FK_ErpReMessageGroup];
GO
IF OBJECT_ID(N'[dbo].[FK_ErpRePackageTrackItem]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[ErpPackageTrackItem] DROP CONSTRAINT [FK_ErpRePackageTrackItem];
GO
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ErpPackageTrack]') AND name = N'index_tracking_no')
DROP INDEX [index_tracking_no] ON [dbo].[ErpPackageTrack] WITH ( ONLINE = OFF )
GO
-- --------------------------------------------------
-- Dropping existing tables
-- --------------------------------------------------
IF OBJECT_ID(N'[dbo].[ErpProduct]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpProduct];
GO
IF OBJECT_ID(N'[dbo].[ErpInStore]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpInStore];
GO
IF OBJECT_ID(N'[dbo].[ErpOutStore]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpOutStore];
GO
IF OBJECT_ID(N'[dbo].[ErpInStoreDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpInStoreDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpOutStoreDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpOutStoreDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpStock]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpStock];
GO
IF OBJECT_ID(N'[dbo].[ErpCheck]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpCheck];
GO
IF OBJECT_ID(N'[dbo].[ErpCheckAdd]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpCheckAdd];
GO
IF OBJECT_ID(N'[dbo].[ErpCheckAddDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpCheckAddDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpCheckDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpCheckDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpCheckSub]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpCheckSub];
GO
IF OBJECT_ID(N'[dbo].[ErpCheckSubDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpCheckSubDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpStore]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpStore];
GO
IF OBJECT_ID(N'[dbo].[ErpCustomer]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpCustomer];
GO
IF OBJECT_ID(N'[dbo].[ErpSupplier]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpSupplier];
GO
IF OBJECT_ID(N'[dbo].[ErpTransfer]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpTransfer];
GO
IF OBJECT_ID(N'[dbo].[ErpTransferDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpTransferDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpProductSpec]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpProductSpec];
GO
IF OBJECT_ID(N'[dbo].[ErpProductSpecTem]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpProductSpecTem];
GO
IF OBJECT_ID(N'[dbo].[ErpApiUser]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpApiUser];
GO
IF OBJECT_ID(N'[dbo].[ErpOrder]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpOrder];
GO
IF OBJECT_ID(N'[dbo].[ErpOrderDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpOrderDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpBank]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpBank];
GO
IF OBJECT_ID(N'[dbo].[ErpInvoice]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpInvoice];
GO
IF OBJECT_ID(N'[dbo].[ErpAddress]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpAddress];
GO
IF OBJECT_ID(N'[dbo].[ErpPaymentRecord]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpPaymentRecord];
GO
IF OBJECT_ID(N'[dbo].[ErpDelivery]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpDelivery];
GO
IF OBJECT_ID(N'[dbo].[ErpLogistic]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpLogistic];
GO
IF OBJECT_ID(N'[dbo].[ErpReturnOrder]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpReturnOrder];
GO
IF OBJECT_ID(N'[dbo].[ErpReturnOrderDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpReturnOrderDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpRefund]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpRefund];
GO
IF OBJECT_ID(N'[dbo].[ErpProductLogistic]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpProductLogistic];
GO
IF OBJECT_ID(N'[dbo].[ErpPurOrder]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpPurOrder];
GO
IF OBJECT_ID(N'[dbo].[ErpPurOrderDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpPurOrderDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpPurReturnOrder]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpPurReturnOrder];
GO
IF OBJECT_ID(N'[dbo].[ErpPurReturnOrderDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpPurReturnOrderDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpLogisticMode]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpLogisticMode];
GO
IF OBJECT_ID(N'[dbo].[ErpProductSupplier]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpProductSupplier];
GO
IF OBJECT_ID(N'[dbo].[ErpMessage]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpMessage];
GO
IF OBJECT_ID(N'[dbo].[ErpLogisticParam]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpLogisticParam];
GO
IF OBJECT_ID(N'[dbo].[ErpLogisticPlan]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpLogisticPlan];
GO
IF OBJECT_ID(N'[dbo].[ErpMessageTemplate]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpMessageTemplate];
GO
IF OBJECT_ID(N'[dbo].[ErpLogisticPrintTem]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpLogisticPrintTem];
GO
IF OBJECT_ID(N'[dbo].[ErpApiUserRole]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpApiUserRole];
GO

IF OBJECT_ID(N'[dbo].[ErpTrackingNumPool]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpTrackingNumPool];
GO

IF OBJECT_ID(N'[dbo].[ErpTrackingNum]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpTrackingNum];
GO
IF OBJECT_ID(N'[dbo].[ErpOrderChange]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpOrderChange];
GO

IF OBJECT_ID(N'[dbo].[ErpShelfPosition]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpShelfPosition];
GO

IF OBJECT_ID(N'[dbo].[ErpLogisticModeParam]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpLogisticModeParam];
GO
IF OBJECT_ID(N'[dbo].[ErpSupProduct]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpSupProduct];
GO
IF OBJECT_ID(N'[dbo].[ErpOnlineCatalog]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpOnlineCatalog];
GO
IF OBJECT_ID(N'[dbo].[ErpCatalogAttribute]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpCatalogAttribute];
GO
IF OBJECT_ID(N'[dbo].[ErpAttributeValue]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpAttributeValue];
GO
IF OBJECT_ID(N'[dbo].[ErpOnlineProduct]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpOnlineProduct];
GO
IF OBJECT_ID(N'[dbo].[ErpOnlineProductSpec]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpOnlineProductSpec];
GO
IF OBJECT_ID(N'[dbo].[ErpOnlineProductAttr]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpOnlineProductAttr];
GO
IF OBJECT_ID(N'[dbo].[ErpSKURelation]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpSKURelation];
GO
IF OBJECT_ID(N'[dbo].[ErpOrderLogisticCache]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpOrderLogisticCache];
GO

IF OBJECT_ID(N'[dbo].[ErpArrivalRecord]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpArrivalRecord];
GO
IF OBJECT_ID(N'[dbo].[ErpArrivalRecordDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpArrivalRecordDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpAllocation]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpAllocation];
GO
IF OBJECT_ID(N'[dbo].[ErpPurPlan]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpPurPlan];
GO
IF OBJECT_ID(N'[dbo].[ErpPurPlanDetail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpPurPlanDetail];
GO
IF OBJECT_ID(N'[dbo].[ErpMessageGroup]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpMessageGroup];
GO
IF OBJECT_ID(N'[dbo].[ErpWaitEvaluated]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpWaitEvaluated];
GO
IF OBJECT_ID(N'[dbo].[ErpPackageTrackItem]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpPackageTrackItem];
GO
IF OBJECT_ID(N'[dbo].[ErpPackageTrack]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpPackageTrack];
GO

IF OBJECT_ID(N'[dbo].[ErpPurProposal]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpPurProposal];
GO
IF OBJECT_ID(N'[dbo].[ErpSaleSiteMessage]', 'U') IS NOT NULL
    DROP TABLE [dbo].[ErpSaleSiteMessage];
GO
-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'ErpProduct'
CREATE TABLE [dbo].[ErpProduct] (
    [ProductId] int IDENTITY(1,1) NOT NULL,
    [CatalogId] int  NOT NULL,
    [ProductCode] nvarchar(64)  NOT NULL,
    [ProductName] nvarchar(512)  NOT NULL,
    [ProductType] nvarchar(32)  NULL,
    [ProductStyle] nvarchar(255)  NULL,
    [ProductUnit] nvarchar(64)  NOT NULL,
    [ProductSNMgr] nvarchar(64)  NULL,
    [StandardSalePrice] decimal(18,2)  NOT NULL,
    [StandarPurPrice] decimal(18,2)  NOT NULL,
    [ProductTime] datetime  NULL,
    [ProductFactory] nvarchar(255)  NULL,
    [ProductLink] nvarchar(max)  NULL,
    [CostAlgorithm] nvarchar(32)  NULL,
    [Remarks] nvarchar(max)  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [SCycle] nvarchar(32)  NULL,
    [SCycleDateNum] int  NULL,
    [SCycleDateType] nvarchar(32)  NULL,
    [MCycle] nvarchar(32)  NULL,
    [MCycleDateNum] int  NULL,
    [MCycleDateType] nvarchar(32)  NULL,
    [TCycle] nvarchar(32)  NULL,
    [TCycleDateNum] int  NULL,
    [TCycleDateType] nvarchar(32)  NULL,
    [MainPic] nvarchar(max)  NULL,
    [StatusCode] smallint  NULL,
    [OrderNo] int  NULL,
    [SpecTemId] int  NULL,
    [ProductColumn1] nvarchar(64)  NULL,
    [ProductColumn2] nvarchar(64)  NULL,
    [ProductColumn3] nvarchar(64)  NULL,
    [ProductColumn4] nvarchar(64)  NULL,
    [ProductColumn5] nvarchar(64)  NULL,
    [ProductColumn6] nvarchar(64)  NULL,
    [ProductColumn7] nvarchar(64)  NULL,
    [ProductColumn8] nvarchar(64)  NULL,
    [ProductColumn9] nvarchar(64)  NULL,
    [ProductColumn10] nvarchar(64)  NULL,
    [ProductColumn11] nvarchar(64)  NULL,
    [ProductColumn12] nvarchar(64)  NULL,
    [ProductColumn13] nvarchar(64)  NULL,
    [ProductColumn14] nvarchar(64)  NULL,
    [ProductColumn15] nvarchar(64)  NULL,
    [ProductColumn16] nvarchar(64)  NULL,
    [ProductColumn17] nvarchar(64)  NULL,
    [ProductColumn18] nvarchar(64)  NULL,
    [ProductColumn19] nvarchar(64)  NULL,
    [ProductColumn20] nvarchar(64)  NULL,
    [PictureAttrType] nvarchar(64)  NULL,
    [RelationId] nvarchar(64)  NULL,
    [RelationType] nvarchar(32)  NULL,
    [Shelves] nvarchar(256)  NULL,
    [DeliveryDay] int  NULL,
    [SafetyThreshold] int  NULL,
    [SafetyThresholdEnd] int  NULL,
    [UpcCode] nvarchar(256)  NULL,
    [PurChaserId] int  NOT NULL,
    [KeyWord1] nvarchar(256)  NULL,
    [KeyWord2] nvarchar(256)  NULL,
    [KeyWord3] nvarchar(256)  NULL,
    [KeyWord4] nvarchar(256)  NULL,
    [KeyWord5] nvarchar(256)  NULL
);
GO

-- Creating table 'ErpInStore'
CREATE TABLE [dbo].[ErpInStore] (
    [InStoreId] int IDENTITY(1,1) NOT NULL,
    [InStoreNo] nvarchar(32)  NULL,
    [InStoreDate] datetime  NULL,
    [InStoreType] nvarchar(32)  NULL,
    [SupplyId] int  NULL,
    [SupplyName] nvarchar(255)  NULL,
    [StoreId] int  NULL,
    [Remarks] nvarchar(max)  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [Approver] nvarchar(64)  NULL,
    [ApproveTime] datetime  NULL,
    [RelationId] int  NULL,
    [RelationNo] nvarchar(32)  NULL,
    [RelationType] nvarchar(max)  NULL,
    [TotalNum] int  NOT NULL,
    [TotalAmount] decimal(18,2)  NOT NULL,
    [StatusCode] smallint  NULL,
    [OrderNo] int  NULL,
    [InStoreColumn1] nvarchar(64)  NULL,
    [InStoreColumn2] nvarchar(64)  NULL,
    [InStoreColumn3] nvarchar(64)  NULL,
    [InStoreColumn4] nvarchar(64)  NULL,
    [InStoreColumn5] nvarchar(64)  NULL,
    [InStoreColumn6] nvarchar(64)  NULL,
    [InStoreColumn7] nvarchar(64)  NULL,
    [InStoreColumn8] nvarchar(64)  NULL,
    [InStoreColumn9] nvarchar(64)  NULL,
    [InStoreColumn10] nvarchar(64)  NULL,
    [InStoreColumn11] nvarchar(64)  NULL,
    [InStoreColumn12] nvarchar(64)  NULL,
    [InStoreColumn13] nvarchar(64)  NULL,
    [InStoreColumn14] nvarchar(64)  NULL,
    [InStoreColumn15] nvarchar(64)  NULL,
    [InStoreColumn16] nvarchar(64)  NULL,
    [InStoreColumn17] nvarchar(64)  NULL,
    [InStoreColumn18] nvarchar(64)  NULL,
    [InStoreColumn19] nvarchar(64)  NULL,
    [InStoreColumn20] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpOutStore'
CREATE TABLE [dbo].[ErpOutStore] (
    [OutStoreId] int IDENTITY(1,1) NOT NULL,
    [OutStoreNo] nvarchar(32)  NOT NULL,
    [OutStoreDate] datetime  NULL,
    [OutStoreType] nvarchar(32)  NULL,
    [CustId] int  NULL,
    [CustName] nvarchar(255)  NULL,
    [StoreId] int  NULL,
    [Remarks] nvarchar(max)  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [Approver] nvarchar(64)  NULL,
    [ApproveTime] datetime  NULL,
    [RelationId] int  NULL,
    [RelationNo] nvarchar(32)  NULL,
    [RelationType] nvarchar(max)  NULL,
    [DeliveryDate] datetime  NULL,
    [RecvAddr] nvarchar(255)  NULL,
    [RecvPostNo] nvarchar(16)  NULL,
    [RecvMan] nvarchar(64)  NULL,
    [RecvLinkTel] nvarchar(64)  NULL,
    [RecvEmail] nvarchar(128)  NULL,
    [TotalNum] int  NOT NULL,
    [TotalAmount] decimal(18,2)  NOT NULL,
    [StatusCode] smallint  NULL,
    [OrderNo] int  NULL,
    [OutStoreColumn1] nvarchar(64)  NULL,
    [OutStoreColumn2] nvarchar(64)  NULL,
    [OutStoreColumn3] nvarchar(64)  NULL,
    [OutStoreColumn4] nvarchar(64)  NULL,
    [OutStoreColumn5] nvarchar(64)  NULL,
    [OutStoreColumn6] nvarchar(64)  NULL,
    [OutStoreColumn7] nvarchar(64)  NULL,
    [OutStoreColumn8] nvarchar(64)  NULL,
    [OutStoreColumn9] nvarchar(64)  NULL,
    [OutStoreColumn10] nvarchar(64)  NULL,
    [OutStoreColumn11] nvarchar(64)  NULL,
    [OutStoreColumn12] nvarchar(64)  NULL,
    [OutStoreColumn13] nvarchar(64)  NULL,
    [OutStoreColumn14] nvarchar(64)  NULL,
    [OutStoreColumn15] nvarchar(64)  NULL,
    [OutStoreColumn16] nvarchar(64)  NULL,
    [OutStoreColumn17] nvarchar(64)  NULL,
    [OutStoreColumn18] nvarchar(64)  NULL,
    [OutStoreColumn19] nvarchar(64)  NULL,
    [OutStoreColumn20] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpInStoreDetail'
CREATE TABLE [dbo].[ErpInStoreDetail] (
    [InStoreDetailId] bigint IDENTITY(1,1) NOT NULL,
    [InStoreId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [Sku] nvarchar(64)  NULL,
    [Num] int  NOT NULL,
    [OutNum] int  NOT NULL,
    [DefectiveNum] int  NOT NULL,
    [DefectiveOutNum] int  NOT NULL,
    [Price] decimal(18,2)  NOT NULL,
    [Amount] decimal(18,2)  NOT NULL,
    [BatchNo] nvarchar(64)  NULL,
    [Memo] nvarchar(max)  NULL,
    [SNDetailed] nvarchar(max)  NULL,
    [InStoreDate] datetime  NULL,
    [ProductTime] datetime  NULL,
    [InStoreDetailColumn1] nvarchar(64)  NULL,
    [InStoreDetailColumn2] nvarchar(64)  NULL,
    [InStoreDetailColumn3] nvarchar(64)  NULL,
    [InStoreDetailColumn4] nvarchar(64)  NULL,
    [InStoreDetailColumn5] nvarchar(64)  NULL,
    [InStoreDetailColumn6] nvarchar(64)  NULL,
    [InStoreDetailColumn7] nvarchar(64)  NULL,
    [InStoreDetailColumn8] nvarchar(64)  NULL,
    [InStoreDetailColumn9] nvarchar(64)  NULL,
    [InStoreDetailColumn10] nvarchar(64)  NULL,
    [InStoreDetailColumn11] nvarchar(64)  NULL,
    [InStoreDetailColumn12] nvarchar(64)  NULL,
    [InStoreDetailColumn13] nvarchar(64)  NULL,
    [InStoreDetailColumn14] nvarchar(64)  NULL,
    [InStoreDetailColumn15] nvarchar(64)  NULL,
    [InStoreDetailColumn16] nvarchar(64)  NULL,
    [InStoreDetailColumn17] nvarchar(64)  NULL,
    [InStoreDetailColumn18] nvarchar(64)  NULL,
    [InStoreDetailColumn19] nvarchar(64)  NULL,
    [InStoreDetailColumn20] nvarchar(64)  NULL,
    [ProductSpecId] int  NOT NULL,
    [ShelfPositionId] int  NOT NULL
);
GO

-- Creating table 'ErpOutStoreDetail'
CREATE TABLE [dbo].[ErpOutStoreDetail] (
    [OutStoreDetailId] bigint IDENTITY(1,1) NOT NULL,
    [OutStoreId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [Sku] nvarchar(64)  NULL,
    [Num] int  NOT NULL,
    [DefectiveNum] int  NOT NULL,
    [Price] decimal(18,2)  NOT NULL,
    [Amount] decimal(18,2)  NOT NULL,
    [BatchNo] nvarchar(64)  NULL,
    [Memo] nvarchar(max)  NULL,
    [SNDetailed] nvarchar(max)  NULL,
    [OutStoreDate] datetime  NULL,
    [OutStoreDetailColumn1] nvarchar(64)  NULL,
    [OutStoreDetailColumn2] nvarchar(64)  NULL,
    [OutStoreDetailColumn3] nvarchar(64)  NULL,
    [OutStoreDetailColumn4] nvarchar(64)  NULL,
    [OutStoreDetailColumn5] nvarchar(64)  NULL,
    [OutStoreDetailColumn6] nvarchar(64)  NULL,
    [OutStoreDetailColumn7] nvarchar(64)  NULL,
    [OutStoreDetailColumn8] nvarchar(64)  NULL,
    [OutStoreDetailColumn9] nvarchar(64)  NULL,
    [OutStoreDetailColumn10] nvarchar(64)  NULL,
    [OutStoreDetailColumn11] nvarchar(64)  NULL,
    [OutStoreDetailColumn12] nvarchar(64)  NULL,
    [OutStoreDetailColumn13] nvarchar(64)  NULL,
    [OutStoreDetailColumn14] nvarchar(64)  NULL,
    [OutStoreDetailColumn15] nvarchar(64)  NULL,
    [OutStoreDetailColumn16] nvarchar(64)  NULL,
    [OutStoreDetailColumn17] nvarchar(64)  NULL,
    [OutStoreDetailColumn18] nvarchar(64)  NULL,
    [OutStoreDetailColumn19] nvarchar(64)  NULL,
    [OutStoreDetailColumn20] nvarchar(64)  NULL,
    [ProductSpecId] int  NOT NULL,
    [ShelfPositionId] int  NOT NULL,
    [InStoreDetailIds] nvarchar(max)  NULL
);
GO

-- Creating table 'ErpStock'
CREATE TABLE [dbo].[ErpStock] (
    [StockId] int IDENTITY(1,1) NOT NULL,
    [ProductId] int  NOT NULL,
    [ProductSpecId] int  NOT NULL,
    [SKU] nvarchar(64)  NULL,
    [StoreId] int  NOT NULL,
    [ShelfPositionId] int  NOT NULL,
    [TotalNum] int  NOT NULL,
    [LockNum] int  NOT NULL,
    [DefectiveNum] int  NOT NULL,
    [StockAvgPrice] decimal(18,2)  NOT NULL,
    [UpdateTime] datetime  NULL,
    [PurInNum] int  NOT NULL,
    [IsPurIn] bit  NOT NULL,
    [SafetyStockTo] int  NULL,
    [SafetyStockEnd] int  NULL
);
GO

-- Creating table 'ErpCheck'
CREATE TABLE [dbo].[ErpCheck] (
    [CheckId] int IDENTITY(1,1) NOT NULL,
    [CheckNo] nvarchar(32)  NULL,
    [StoreId] int  NOT NULL,
    [StoreName] nvarchar(64)  NULL,
    [CheckDate] datetime  NULL,
    [IsCheckAdd] nvarchar(2)  NULL,
    [IsCheckSubtract] nvarchar(2)  NULL,
    [Creator] nvarchar(64)  NULL,
    [Remarks] nvarchar(max)  NULL
);
GO

-- Creating table 'ErpCheckAdd'
CREATE TABLE [dbo].[ErpCheckAdd] (
    [CheckAddId] int IDENTITY(1,1) NOT NULL,
    [CheckAddNo] nvarchar(32)  NULL,
    [CheckTime] datetime  NULL,
    [StoreId] int  NOT NULL,
    [StoreName] nvarchar(max)  NULL,
    [TotalNum] int  NOT NULL,
    [TotalAmount] decimal(18,2)  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [Approver] nvarchar(64)  NULL,
    [ApproveTime] datetime  NULL,
    [StatusCode] smallint  NULL,
    [Remarks] nvarchar(max)  NULL,
    [CheckAddColumn1] nvarchar(64)  NULL,
    [CheckAddColumn2] nvarchar(64)  NULL,
    [CheckAddColumn3] nvarchar(64)  NULL,
    [CheckAddColumn4] nvarchar(64)  NULL,
    [CheckAddColumn5] nvarchar(64)  NULL,
    [CheckAddlColumn6] nvarchar(64)  NULL,
    [CheckAddColumn7] nvarchar(64)  NULL,
    [CheckAddColumn8] nvarchar(64)  NULL,
    [CheckAddColumn9] nvarchar(64)  NULL,
    [CheckAddColumn10] nvarchar(64)  NULL,
    [CheckAddColumn11] nvarchar(64)  NULL,
    [CheckAddColumn12] nvarchar(64)  NULL,
    [CheckAddColumn13] nvarchar(64)  NULL,
    [CheckAddColumn14] nvarchar(64)  NULL,
    [CheckAddColumn15] nvarchar(64)  NULL,
    [CheckAddColumn16] nvarchar(64)  NULL,
    [CheckAddColumn17] nvarchar(64)  NULL,
    [CheckAddColumn18] nvarchar(64)  NULL,
    [CheckAddColumn19] nvarchar(64)  NULL,
    [CheckAddColumn20] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpCheckAddDetail'
CREATE TABLE [dbo].[ErpCheckAddDetail] (
    [CheckAddDetailId] bigint IDENTITY(1,1) NOT NULL,
    [CheckAddId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [Sku] nvarchar(64)  NULL,
    [BatchNo] nvarchar(max)  NULL,
    [Num] int  NOT NULL,
    [Price] decimal(18,2)  NOT NULL,
    [Amount] decimal(18,2)  NOT NULL,
    [DefectiveNum] int  NOT NULL,
    [Memo] nvarchar(max)  NULL,
    [CheckAddDetailColumn1] nvarchar(64)  NULL,
    [CheckAddDetailColumn2] nvarchar(64)  NULL,
    [CheckAddDetailColumn3] nvarchar(64)  NULL,
    [CheckAddDetailColumn4] nvarchar(64)  NULL,
    [CheckAddDetailColumn5] nvarchar(64)  NULL,
    [CheckAddDetailColumn6] nvarchar(64)  NULL,
    [CheckAddDetailColumn7] nvarchar(64)  NULL,
    [CheckAddDetailColumn8] nvarchar(64)  NULL,
    [CheckAddDetailColumn9] nvarchar(64)  NULL,
    [CheckAddDetailColumn10] nvarchar(64)  NULL,
    [CheckAddDetailColumn11] nvarchar(64)  NULL,
    [CheckAddDetailColumn12] nvarchar(64)  NULL,
    [CheckAddDetailColumn13] nvarchar(64)  NULL,
    [CheckAddDetailColumn14] nvarchar(64)  NULL,
    [CheckAddDetailColumn15] nvarchar(64)  NULL,
    [CheckAddDetailColumn16] nvarchar(64)  NULL,
    [CheckAddDetailColumn17] nvarchar(64)  NULL,
    [CheckAddDetailColumn18] nvarchar(64)  NULL,
    [CheckAddDetailColumn19] nvarchar(64)  NULL,
    [CheckAddDetailColumn20] nvarchar(64)  NULL,
    [ProductSpecId] int  NOT NULL,
    [ShelfPositionId] int  NOT NULL
);
GO

-- Creating table 'ErpCheckDetail'
CREATE TABLE [dbo].[ErpCheckDetail] (
    [CheckDetailId] bigint IDENTITY(1,1) NOT NULL,
    [CheckId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [Sku] nvarchar(64)  NULL,
    [RecordNum] int  NOT NULL,
    [ActualNum] int  NOT NULL,
    [BatchNo] nvarchar(max)  NULL,
    [Remarks] nvarchar(max)  NULL,
    [CheckDetailColumn1] nvarchar(64)  NULL,
    [CheckDetailColumn2] nvarchar(64)  NULL,
    [CheckDetailColumn3] nvarchar(64)  NULL,
    [CheckDetailColumn4] nvarchar(64)  NULL,
    [CheckDetailColumn5] nvarchar(64)  NULL,
    [CheckDetailColumn6] nvarchar(64)  NULL,
    [CheckDetailColumn7] nvarchar(64)  NULL,
    [CheckDetailColumn8] nvarchar(64)  NULL,
    [CheckDetailColumn9] nvarchar(64)  NULL,
    [CheckDetailColumn10] nvarchar(64)  NULL,
    [CheckDetailColumn11] nvarchar(64)  NULL,
    [CheckDetailColumn12] nvarchar(64)  NULL,
    [CheckDetailColumn13] nvarchar(64)  NULL,
    [CheckDetailColumn14] nvarchar(64)  NULL,
    [CheckDetailColumn15] nvarchar(64)  NULL,
    [CheckDetailColumn16] nvarchar(64)  NULL,
    [CheckDetailColumn17] nvarchar(64)  NULL,
    [CheckDetailColumn18] nvarchar(64)  NULL,
    [CheckDetailColumn19] nvarchar(64)  NULL,
    [CheckDetailColumn20] nvarchar(64)  NULL,
    [ShelfPositionId] int  NOT NULL,
    [ProductSpecId] int  NOT NULL
);
GO

-- Creating table 'ErpCheckSub'
CREATE TABLE [dbo].[ErpCheckSub] (
    [CheckSubId] int IDENTITY(1,1) NOT NULL,
    [CheckSubNo] nvarchar(32)  NULL,
    [CheckTime] datetime  NULL,
    [StoreId] int  NOT NULL,
    [StoreName] nvarchar(max)  NULL,
    [TotalNum] int  NOT NULL,
    [TotalAmount] decimal(18,2)  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [Approver] nvarchar(64)  NULL,
    [ApproveTime] datetime  NULL,
    [StatusCode] smallint  NULL,
    [Remarks] nvarchar(max)  NULL,
    [CheckSubColumn1] nvarchar(64)  NULL,
    [CheckSubColumn2] nvarchar(64)  NULL,
    [CheckSubColumn3] nvarchar(64)  NULL,
    [CheckSubColumn4] nvarchar(64)  NULL,
    [CheckSubColumn5] nvarchar(64)  NULL,
    [CheckSubColumn6] nvarchar(64)  NULL,
    [CheckSubColumn7] nvarchar(64)  NULL,
    [CheckSubColumn8] nvarchar(64)  NULL,
    [CheckSubColumn9] nvarchar(64)  NULL,
    [CheckSubColumn10] nvarchar(64)  NULL,
    [CheckSubColumn11] nvarchar(64)  NULL,
    [CheckSubColumn12] nvarchar(64)  NULL,
    [CheckSubColumn13] nvarchar(64)  NULL,
    [CheckSubColumn14] nvarchar(64)  NULL,
    [CheckSubColumn15] nvarchar(64)  NULL,
    [CheckSubColumn16] nvarchar(64)  NULL,
    [CheckSubColumn17] nvarchar(64)  NULL,
    [CheckSubColumn18] nvarchar(64)  NULL,
    [CheckSubColumn19] nvarchar(64)  NULL,
    [CheckSubColumn20] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpCheckSubDetail'
CREATE TABLE [dbo].[ErpCheckSubDetail] (
    [CheckSubDetailId] bigint IDENTITY(1,1) NOT NULL,
    [CheckSubId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [Sku] nvarchar(64)  NULL,
    [BatchNo] nvarchar(max)  NULL,
    [Num] int  NOT NULL,
    [DefectiveNum] int  NOT NULL,
    [Price] decimal(18,2)  NOT NULL,
    [Amount] decimal(18,2)  NOT NULL,
    [Memo] nvarchar(max)  NULL,
    [CheckSubDetailColumn1] nvarchar(64)  NULL,
    [CheckSubDetailColumn2] nvarchar(64)  NULL,
    [CheckSubDetailColumn3] nvarchar(64)  NULL,
    [CheckSubDetailColumn4] nvarchar(64)  NULL,
    [CheckSubDetailColumn5] nvarchar(64)  NULL,
    [CheckSubDetailColumn6] nvarchar(64)  NULL,
    [CheckSubDetailColumn7] nvarchar(64)  NULL,
    [CheckSubDetailColumn8] nvarchar(64)  NULL,
    [CheckSubDetailColumn9] nvarchar(64)  NULL,
    [CheckSubDetailColumn10] nvarchar(64)  NULL,
    [CheckSubDetailColumn11] nvarchar(64)  NULL,
    [CheckSubDetailColumn12] nvarchar(64)  NULL,
    [CheckSubDetailColumn13] nvarchar(64)  NULL,
    [CheckSubDetailColumn14] nvarchar(64)  NULL,
    [CheckSubDetailColumn15] nvarchar(64)  NULL,
    [CheckSubDetailColumn16] nvarchar(64)  NULL,
    [CheckSubDetailColumn17] nvarchar(64)  NULL,
    [CheckSubDetailColumn18] nvarchar(64)  NULL,
    [CheckSubDetailColumn19] nvarchar(64)  NULL,
    [CheckSubDetailColumn20] nvarchar(64)  NULL,
    [ProductSpecId] int  NOT NULL,
    [ShelfPositionId] int  NOT NULL
);
GO
-- Creating table 'ErpStore'
CREATE TABLE [dbo].[ErpStore] (
    [StoreId] int IDENTITY(1,1) NOT NULL,
    [StoreNo] nvarchar(32)  NULL,
    [StoreName] nvarchar(64)  NULL,
    [Head] nvarchar(64)  NULL,
    [Address] nvarchar(255)  NULL,
    [Telephone] nvarchar(64)  NULL,
    [StoreType] nvarchar(32)  NULL,
    [Remarks] nvarchar(max)  NULL,
    [StoreColumn1] nvarchar(64)  NULL,
    [StoreColumn2] nvarchar(64)  NULL,
    [StoreColumn3] nvarchar(64)  NULL,
    [StoreColumn4] nvarchar(64)  NULL,
    [StoreColumn5] nvarchar(64)  NULL,
    [StoreColumn6] nvarchar(64)  NULL,
    [StoreColumn7] nvarchar(64)  NULL,
    [StoreColumn8] nvarchar(64)  NULL,
    [StoreColumn9] nvarchar(64)  NULL,
    [StoreColumn10] nvarchar(64)  NULL,
    [StoreColumn11] nvarchar(64)  NULL,
    [StoreColumn12] nvarchar(64)  NULL,
    [StoreColumn13] nvarchar(64)  NULL,
    [StoreColumn14] nvarchar(64)  NULL,
    [StoreColumn15] nvarchar(64)  NULL,
    [StoreColumn16] nvarchar(64)  NULL,
    [StoreColumn17] nvarchar(64)  NULL,
    [StoreColumn18] nvarchar(64)  NULL,
    [StoreColumn19] nvarchar(64)  NULL,
    [StoreColumn20] nvarchar(64)  NULL,
    [ManageState] bit  NOT NULL,
    [IsActive] bit  NOT NULL
);
GO

-- Creating table 'ErpCustomer'
CREATE TABLE [dbo].[ErpCustomer] (
    [CustomerId] int IDENTITY(1,1) NOT NULL,
    [CustomerSignId] nvarchar(32)  NOT NULL,
    [CatalogId] int  NOT NULL,
    [CustomerNo] nvarchar(32)  NULL,
    [CustomerName] nvarchar(256)  NULL,
    [CustomerShortName] nvarchar(256)  NULL,
    [EnglishName] nvarchar(256)  NULL,
    [EnglishShortName] nvarchar(256)  NULL,
    [CustomerType] nvarchar(32)  NULL,
    [Country] nvarchar(32)  NULL,
    [Province] nvarchar(128)  NULL,
    [City] nvarchar(128)  NULL,
    [Area] nvarchar(32)  NULL,
    [Address] nvarchar(255)  NULL,
    [CustomerSource] nvarchar(32)  NULL,
    [CustomerOwner] int  NULL,
    [IndustryIParent] nvarchar(32)  NULL,
    [Industry] nvarchar(max)  NULL,
    [Importance] nvarchar(32)  NULL,
    [Honor] nvarchar(32)  NULL,
    [GrandLimit] decimal(18,2)  NULL,
    [Character] nvarchar(32)  NULL,
    [LegalRepresentative] nvarchar(64)  NULL,
    [CompanySize] nvarchar(64)  NULL,
    [Telphone] nvarchar(256)  NULL,
    [Fax] nvarchar(32)  NULL,
    [ZipCode] nvarchar(32)  NULL,
    [Website] nvarchar(max)  NULL,
    [Head] nvarchar(256)  NULL,
    [Contact] nvarchar(256)  NULL,
    [Sex] nvarchar(2)  NULL,
    [Birthday] nvarchar(10)  NULL,
    [MobilePhone] nvarchar(256)  NULL,
    [Email] nvarchar(128)  NULL,
    [StatusCode] nvarchar(32)  NULL,
    [Remarks] nvarchar(max)  NULL,
    [Creator] nvarchar(256)  NULL,
    [CreateTime] datetime  NULL,
    [CustomerColumn1] nvarchar(64)  NULL,
    [CustomerColumn2] nvarchar(64)  NULL,
    [CustomerColumn3] nvarchar(64)  NULL,
    [CustomerColumn4] nvarchar(64)  NULL,
    [CustomerColumn5] nvarchar(64)  NULL,
    [CustomerColumn6] nvarchar(64)  NULL,
    [CustomerColumn7] nvarchar(64)  NULL,
    [CustomerColumn8] nvarchar(64)  NULL,
    [CustomerColumn9] nvarchar(64)  NULL,
    [CustomerColumn10] nvarchar(64)  NULL,
    [CustomerColumn11] nvarchar(64)  NULL,
    [CustomerColumn12] nvarchar(64)  NULL,
    [CustomerColumn13] nvarchar(64)  NULL,
    [CustomerColumn14] nvarchar(64)  NULL,
    [CustomerColumn15] nvarchar(64)  NULL,
    [CustomerColumn16] nvarchar(64)  NULL,
    [CustomerColumn17] nvarchar(64)  NULL,
    [CustomerColumn18] nvarchar(64)  NULL,
    [CustomerColumn19] nvarchar(64)  NULL,
    [CustomerColumn20] nvarchar(64)  NULL,
    [RelationId] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpSupplier'
CREATE TABLE [dbo].[ErpSupplier] (
    [SupplierId] int IDENTITY(1,1) NOT NULL,
    [SupplierSignId] nvarchar(32)  NOT NULL,
    [CatalogId] int  NOT NULL,
    [SupplierNo] nvarchar(32)  NULL,
    [SupplierName] nvarchar(64)  NULL,
    [SupplierShortName] nvarchar(64)  NULL,
    [EnglishName] nvarchar(64)  NULL,
    [EnglishShortName] nvarchar(64)  NULL,
    [SupplierType] nvarchar(32)  NULL,
    [Country] nvarchar(32)  NULL,
    [Province] nvarchar(32)  NULL,
    [City] nvarchar(32)  NULL,
    [Area] nvarchar(32)  NULL,
    [Address] nvarchar(255)  NULL,
    [SupplierSource] nvarchar(32)  NULL,
    [SupplierOwner] int  NULL,
    [IndustryIParent] nvarchar(32)  NULL,
    [Industry] nvarchar(255)  NULL,
    [Importance] nvarchar(32)  NULL,
    [Character] nvarchar(32)  NULL,
    [Honor] nvarchar(32)  NULL,
    [GrandLimit] decimal(18,2)  NULL,
    [LegalRepresentative] nvarchar(64)  NULL,
    [CompanySize] nvarchar(64)  NULL,
    [Telphone] nvarchar(32)  NULL,
    [Fax] nvarchar(32)  NULL,
    [ZipCode] nvarchar(32)  NULL,
    [Website] nvarchar(max)  NULL,
    [Head] nvarchar(64)  NULL,
    [Contact] nvarchar(64)  NULL,
    [Sex] nvarchar(2)  NULL,
    [Birthday] nvarchar(10)  NULL,
    [MobilePhone] nvarchar(32)  NULL,
    [Email] nvarchar(128)  NULL,
    [StatusCode] nvarchar(32)  NULL,
    [Remarks] nvarchar(max)  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [SupplierColumn1] nvarchar(64)  NULL,
    [SupplierColumn2] nvarchar(64)  NULL,
    [SupplierColumn3] nvarchar(64)  NULL,
    [SupplierColumn4] nvarchar(64)  NULL,
    [SupplierColumn5] nvarchar(64)  NULL,
    [SupplierColumn6] nvarchar(64)  NULL,
    [SupplierColumn7] nvarchar(64)  NULL,
    [SupplierColumn8] nvarchar(64)  NULL,
    [SupplierColumn9] nvarchar(64)  NULL,
    [SupplierColumn10] nvarchar(64)  NULL,
    [SupplierColumn11] nvarchar(64)  NULL,
    [SupplierColumn12] nvarchar(64)  NULL,
    [SupplierColumn13] nvarchar(64)  NULL,
    [SupplierColumn14] nvarchar(64)  NULL,
    [SupplierColumn15] nvarchar(64)  NULL,
    [SupplierColumn16] nvarchar(64)  NULL,
    [SupplierColumn17] nvarchar(64)  NULL,
    [SupplierColumn18] nvarchar(64)  NULL,
    [SupplierColumn19] nvarchar(64)  NULL,
    [SupplierColumn20] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpTransfer'
CREATE TABLE [dbo].[ErpTransfer] (
    [TransferId] int IDENTITY(1,1) NOT NULL,
    [TransferNo] nvarchar(32)  NULL,
    [TransferDate] datetime  NULL,
    [InStore] int  NOT NULL,
    [OutStore] int  NOT NULL,
    [TotalNum] int  NOT NULL,
    [TotalAmount] decimal(18,2)  NOT NULL,
    [Remarks] nvarchar(max)  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [Approver] nvarchar(64)  NULL,
    [ApproveTime] datetime  NULL,
    [TransferColumn1] nvarchar(64)  NULL,
    [TransferColumn2] nvarchar(64)  NULL,
    [TransferColumn3] nvarchar(64)  NULL,
    [TransferColumn4] nvarchar(64)  NULL,
    [TransferColumn5] nvarchar(64)  NULL,
    [StatusCode] smallint  NULL
);
GO

-- Creating table 'ErpTransferDetail'
CREATE TABLE [dbo].[ErpTransferDetail] (
    [TransferDetailId] int IDENTITY(1,1) NOT NULL,
    [TransferId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [BatchNo] nvarchar(max)  NULL,
    [Num] int  NOT NULL,
    [Price] decimal(18,2)  NOT NULL,
    [Amount] decimal(18,2)  NOT NULL,
    [Memo] nvarchar(max)  NULL,
    [TransferDetailColumn1] nvarchar(64)  NULL,
    [TransferDetailColumn2] nvarchar(64)  NULL,
    [TransferDetailColumn3] nvarchar(64)  NULL,
    [TransferDetailColumn4] nvarchar(64)  NULL,
    [TransferDetailColumn5] nvarchar(64)  NULL,
    [Sku] nvarchar(64)  NULL,
    [DefectiveNum] int  NOT NULL,
    [ProductSpecId] int  NOT NULL,
    [InShelfPositionId] int  NOT NULL,
    [OutShelfPositionId] int  NOT NULL
);
GO

-- Creating table 'ErpProductSpec'
CREATE TABLE [dbo].[ErpProductSpec] (
    [ProductSpecId] bigint IDENTITY(1,1) NOT NULL,
    [ProductId] int  NOT NULL,
    [SKU] nvarchar(64)  NULL,
    [Spec1] nvarchar(64)  NULL,
    [Spec2] nvarchar(64)  NULL,
    [Spec3] nvarchar(64)  NULL,
    [Spec4] nvarchar(64)  NULL,
    [Spec5] nvarchar(64)  NULL,
    [Spec1Short] nvarchar(64)  NULL,
    [Spec2Short] nvarchar(64)  NULL,
    [Spec3Short] nvarchar(64)  NULL,
    [Spec4Short] nvarchar(64)  NULL,
    [Spec5Short] nvarchar(64)  NULL,
    [PackingWeight] decimal(18,2)  NOT NULL,
    [StandardSalePrice] decimal(18,2)  NULL,
    [StatusCode] smallint  NULL
);
GO

-- Creating table 'ErpProductSpecTem'
CREATE TABLE [dbo].[ErpProductSpecTem] (
    [SpecTemId] int IDENTITY(1,1) NOT NULL,
    [SpecTemName] nvarchar(64)  NULL,
    [Spec1] nvarchar(64)  NULL,
    [Spec2] nvarchar(64)  NULL,
    [Spec3] nvarchar(64)  NULL,
    [Spec4] nvarchar(64)  NULL,
    [Spec5] nvarchar(64)  NULL,
    [SpecTemColumn1] nvarchar(255)  NULL,
    [SpecTemColumn2] nvarchar(255)  NULL,
    [SpecTemColumn3] nvarchar(255)  NULL,
    [SpecTemColumn4] nvarchar(255)  NULL,
    [SpecTemColumn5] nvarchar(255)  NULL
);
GO

-- Creating table 'ErpApiUser'
CREATE TABLE [dbo].[ErpApiUser] (
    [ApiUserId] int IDENTITY(1,1) NOT NULL,
    [UserId] nvarchar(64)  NOT NULL,
    [UserName] nvarchar(64)  NULL,
    [ExpirationDate] nvarchar(10)  NULL,
    [UserToken] nvarchar(max)  NULL,
    [UserFrom] nvarchar(64)  NULL,
    [Status] smallint  NOT NULL,
    [ApiUserColumn1] nvarchar(256)  NULL,
    [ApiUserColumn2] nvarchar(256)  NULL,
    [ApiUserColumn3] nvarchar(256)  NULL,
    [ApiUserColumn4] nvarchar(256)  NULL,
    [ApiUserColumn5] nvarchar(256)  NULL,
    [ApiUserColumn6] nvarchar(256)  NULL,
    [ApiUserColumn7] nvarchar(256)  NULL,
    [ApiUserColumn8] nvarchar(256)  NULL,
    [ApiUserColumn9] nvarchar(256)  NULL,
    [ApiUserColumn10] nvarchar(256)  NULL,
    [ApiUserColumn11] nvarchar(256)  NULL,
    [ApiUserColumn12] nvarchar(256)  NULL,
    [ApiUserColumn13] nvarchar(256)  NULL,
    [ApiUserColumn14] nvarchar(256)  NULL,
    [ApiUserColumn15] nvarchar(256)  NULL,
    [ApiUserColumn16] nvarchar(256)  NULL,
    [ApiUserColumn17] nvarchar(256)  NULL,
    [ApiUserColumn18] nvarchar(256)  NULL,
    [ApiUserColumn19] nvarchar(256)  NULL,
    [ApiUserColumn20] nvarchar(256)  NULL,
    [Creator] nvarchar(50)  NULL,
    [CreateTime] datetime  NOT NULL,
    [UserHashCode] bigint  NULL
);
GO

-- Creating table 'ErpOrder'
CREATE TABLE [dbo].[ErpOrder] (
    [OrderId] int IDENTITY(1,1) NOT NULL,
    [OrderNo] nvarchar(32)  NOT NULL,
    [CustId] int  NOT NULL,
    [OrderTime] datetime  NULL,
    [DeliveryDate] datetime  NULL,
    [TotalNum] int  NOT NULL,
    [OutTotalNum] int  NOT NULL,
    [TotalAmount] decimal(18,2)  NOT NULL,
    [IsDiscountOrder] bit  NULL,
    [DiscountAmount] decimal(18,2)  NULL,
    [PayableAmount] decimal(18,2)  NULL,
    [InvoiceId] int  NULL,
    [InvoiceTitle] nvarchar(255)  NULL,
    [InvoiceContent] nvarchar(max)  NULL,
    [Remarks] nvarchar(max)  NULL,
    [AddressId] int  NULL,
    [RelationId] nvarchar(64)  NULL,
    [RelationType] nvarchar(32)  NULL,
    [InVoiceType] smallint  NULL,
    [LogisticsAmount] decimal(18,2)  NOT NULL,
    [PriceCurrency] nvarchar(32)  NULL,
    [LogisticStatus] smallint  NULL,
    [OutStoreStatus] smallint  NULL,
    [PaymentStatus] smallint  NULL,
    [AllocationStatus] smallint  NOT NULL,
    [IsPrint] bit  NOT NULL,
    [PrintTime] datetime  NULL,
    [IsPrintDeclare] bit  NOT NULL,
    [PrintDeclareTime] datetime  NULL,
    [CustServiceName] nvarchar(64)  NULL,
    [UserId] nvarchar(max)  NULL,
    [UserHashCode] bigint  NULL,
    [OrderMark] nvarchar(64)  NOT NULL,
    [IsAbandoned] bit  NOT NULL,
    [ParentOrderId] nvarchar(256)  NULL,
    [FirstAllocation] bit  NOT NULL,
    [Creator] nvarchar(256)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [Approver] nvarchar(64)  NULL,
    [ApproveTime] datetime  NULL,
    [StatusCode] smallint  NULL,
    [ShippingCost] decimal(18,2)  NOT NULL,
    [CounterFee] decimal(18,2)  NOT NULL,
    [OrderColumn1] nvarchar(256)  NULL,
    [OrderColumn2] nvarchar(256)  NULL,
    [OrderColumn3] nvarchar(256)  NULL,
    [OrderColumn4] nvarchar(256)  NULL,
    [OrderColumn5] nvarchar(256)  NULL,
    [OrderColumn6] nvarchar(256)  NULL,
    [OrderColumn7] nvarchar(256)  NULL,
    [OrderColumn8] nvarchar(256)  NULL,
    [OrderColumn9] nvarchar(256)  NULL,
    [OrderColumn10] nvarchar(256)  NULL,
    [OutStoreId] int  NULL,
    [ProductsCost] decimal(18,2)  NULL,
    [IsRemindPayment] bit  NOT NULL,
    [RemindPaymentTime] datetime  NULL
);
GO

-- Creating table 'ErpOrderDetail'
CREATE TABLE [dbo].[ErpOrderDetail] (
    [OrderDetailId] bigint IDENTITY(1,1) NOT NULL,
    [OrderId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [ProductName] nvarchar(512)  NULL,
    [Sku] nvarchar(64)  NULL,
    [ProductSpecId] int  NULL,
    [ProductRealSku] nvarchar(64)  NULL,
    [Price] decimal(18,2)  NOT NULL,
    [Amount] decimal(18,2)  NOT NULL,
    [PriceCurrency] nvarchar(32)  NULL,
    [Num] int  NOT NULL,
    [AllocationNum] int  NOT NULL,
    [OutNum] int  NOT NULL,
    [Memo] nvarchar(max)  NULL,
    [RelationId] nvarchar(64)  NULL,
    [ProductPictureUrl] nvarchar(256)  NULL,
    [ProductViewUrl] nvarchar(256)  NULL,
    [CustServiceName] nvarchar(64)  NULL,
    [DeclareCNName] nvarchar(64)  NULL,
    [DeclareENName] nvarchar(64)  NULL,
    [DeclareWeight] decimal(18,2)  NOT NULL,
    [DeclaredPrice] decimal(18,2)  NOT NULL,
    [Spec1] nvarchar(64)  NULL,
    [Spec2] nvarchar(64)  NULL,
    [Spec3] nvarchar(64)  NULL,
    [Spec4] nvarchar(64)  NULL,
    [Spec5] nvarchar(64)  NULL,
	[ProductFailed] bit  NULL,
    [FailedString] nvarchar(max)  NULL,
    [OrderDetailColumn1] nvarchar(256)  NULL,
    [OrderDetailColumn2] nvarchar(256)  NULL,
    [OrderDetailColumn3] nvarchar(256)  NULL,
    [OrderDetailColumn4] nvarchar(256)  NULL,
    [OrderDetailColumn5] nvarchar(256)  NULL,
    [OrderDetailColumn6] nvarchar(256)  NULL,
    [OrderDetailColumn7] nvarchar(256)  NULL,
    [OrderDetailColumn8] nvarchar(256)  NULL,
    [OrderDetailColumn9] nvarchar(256)  NULL,
    [OrderDetailColumn10] nvarchar(256)  NULL
);
GO

-- Creating table 'ErpBank'
CREATE TABLE [dbo].[ErpBank] (
    [BankId] int IDENTITY(1,1) NOT NULL,
    [BankName] nvarchar(64)  NOT NULL,
    [BankAccount] nvarchar(32)  NOT NULL,
    [AccountName] nvarchar(64)  NOT NULL,
    [RelationId] int  NOT NULL,
    [RelationType] nvarchar(32)  NOT NULL,
    [IsDefault] bit  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL
);
GO

-- Creating table 'ErpInvoice'
CREATE TABLE [dbo].[ErpInvoice] (
    [InvoiceId] int IDENTITY(1,1) NOT NULL,
    [InVoiceType] smallint  NOT NULL,
    [InvoiceTitle] nvarchar(255)  NULL,
    [InvoiceContent] nvarchar(max)  NULL,
    [TaxpayerNo] nvarchar(64)  NULL,
    [VatAddress] nvarchar(255)  NULL,
    [VatPhone] nvarchar(32)  NULL,
    [BankName] nvarchar(64)  NULL,
    [BankAccount] nvarchar(32)  NULL,
    [RelationId] int  NOT NULL,
    [RelationType] nvarchar(32)  NOT NULL,
    [IsDefault] bit  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL
);
GO

-- Creating table 'ErpAddress'
CREATE TABLE [dbo].[ErpAddress] (
    [AddressId] int IDENTITY(1,1) NOT NULL,
    [Contact] nvarchar(256)  NOT NULL,
    [Email] nvarchar(128)  NULL,
    [MobilePhone] nvarchar(256)  NULL,
    [TelePhone] nvarchar(256)  NULL,
    [Company] nvarchar(255)  NULL,
    [Country] nvarchar(100)  NULL,
    [Province] nvarchar(100)  NULL,
    [City] nvarchar(100)  NULL,
    [Area] nvarchar(100)  NULL,
    [Address] nvarchar(500)  NULL,
    [Address2] nvarchar(500)  NULL,
    [ZipCode] nvarchar(32)  NULL,
    [RelationId] int  NOT NULL,
    [RelationType] nvarchar(32)  NOT NULL,
    [IsDefault] bit  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(256)  NULL,
    [OperateTime] datetime  NULL,
    [FullAddress] nvarchar(600)  NULL
);
GO

-- Creating table 'ErpPaymentRecord'
CREATE TABLE [dbo].[ErpPaymentRecord] (
    [PaymentRecordId] int IDENTITY(1,1) NOT NULL,
    [PaymentDate] datetime  NOT NULL,
    [PaymentAmount] decimal(18,2)  NOT NULL,
    [BankId] int  NULL,
    [Remarks] nvarchar(max)  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [OrderId] int  NOT NULL,
    [StatusCode] smallint  NOT NULL,
    [PriceCurrency] nvarchar(32)  NULL,
    [SerialNumber] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpDelivery'
CREATE TABLE [dbo].[ErpDelivery] (
    [DeliveryId] int IDENTITY(1,1) NOT NULL,
    [OrderId] int  NOT NULL,
    [Num] int  NOT NULL,
    [LogisticId] int  NOT NULL,
    [LogisticModeId] int  NOT NULL,
    [LogisticModeCode] nvarchar(64)  NULL,
    [LogisticNo] nvarchar(32)  NULL,
    [LogisticTransitNo] nvarchar(32)  NULL,
    [ServiceName] nvarchar(64)  NULL,
    [OldLogisticTransitNo] nvarchar(32)  NULL,
    [OldServiceName] nvarchar(64)  NULL,
    [ShippedErrorInfo] nvarchar(512)  NULL,
    [DeliveryDate] datetime  NULL,
    [StoreId] int  NULL,
    [OutStoreId] int  NOT NULL,
    [GrossWeight] decimal(18,2)  NOT NULL,
    [EstimateWeight] decimal(18,2)  NOT NULL,
    [Weight] decimal(18,2)  NOT NULL,
    [EstimateFreight] decimal(18,2)  NOT NULL,
    [Freight] decimal(18,2)  NOT NULL,
    [DeliveryNo] nvarchar(32)  NULL,
    [DeclareWeight] decimal(18,2)  NOT NULL,
    [DeclaredPrice] decimal(18,2)  NOT NULL,
    [DeclareCNName] nvarchar(64)  NULL,
    [DeclareENName] nvarchar(64)  NULL,
    [PackageWidth] decimal(18,2)  NOT NULL,
    [PackageHeight] decimal(18,2)  NOT NULL,
    [PackageLength] decimal(18,2)  NOT NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [IsCheckGoods] bit  NOT NULL,
    [CheckUser] nvarchar(256)  NULL,
    [CheckTime] datetime  NULL,
	[PackageStatus] int  NULL,
    [DomesticLogisticsCompanyId] bigint  NOT NULL,
    [DomesticLogisticsCompany] nvarchar(256)  NULL,
    [DomesticTrackingNo] nvarchar(256)  NULL,
    [DeliveryColumn1] nvarchar(64)  NULL,
    [DeliveryColumn2] nvarchar(64)  NULL,
    [DeliveryColumn3] nvarchar(64)  NULL,
    [DeliveryColumn4] nvarchar(64)  NULL,
    [DeliveryColumn5] nvarchar(64)  NULL,
    [DeliveryColumn6] nvarchar(64)  NULL,
    [DeliveryColumn7] nvarchar(64)  NULL,
    [DeliveryColumn8] nvarchar(64)  NULL,
    [DeliveryColumn9] nvarchar(64)  NULL,
    [DeliveryColumn10] nvarchar(64)  NULL,
    [LogisticColumn1] nvarchar(64)  NULL,
    [LogisticColumn2] nvarchar(64)  NULL,
    [LogisticColumn3] nvarchar(64)  NULL,
    [LogisticColumn4] nvarchar(64)  NULL,
    [LogisticColumn5] nvarchar(64)  NULL,
    [LogisticColumn6] nvarchar(64)  NULL,
    [ExtendsBuyerAcceptGoodsTime] int  NULL
);
GO

-- Creating table 'ErpLogistic'
CREATE TABLE [dbo].[ErpLogistic] (
    [LogisticId] int IDENTITY(1,1) NOT NULL,
    [LogisticName] nvarchar(64)  NOT NULL,
    [StatusCode] smallint  NOT NULL,
    [LogisticCode] nvarchar(64)  NULL,
    [LogisticColumn1] nvarchar(300)  NULL,
    [LogisticColumn2] nvarchar(300)  NULL,
    [LogisticColumn3] nvarchar(300)  NULL,
    [LogisticColumn4] nvarchar(max)  NULL,
    [LogisticColumn5] nvarchar(300)  NULL,
    [LogisticColumn6] nvarchar(300)  NULL,
    [LogisticColumn7] nvarchar(300)  NULL,
    [LogisticColumn8] nvarchar(300)  NULL,
    [LogisticColumn9] nvarchar(300)  NULL,
    [LogisticColumn10] nvarchar(300)  NULL,
    [LogisticColumn11] nvarchar(300)  NULL,
    [LogisticColumn12] nvarchar(300)  NULL,
    [LogisticColumn13] nvarchar(300)  NULL,
    [LogisticColumn14] nvarchar(300)  NULL,
    [LogisticColumn15] nvarchar(300)  NULL,
    [LogisticColumn16] nvarchar(max)  NULL,
    [LogisticColumn17] nvarchar(max)  NULL,
    [LogisticColumn18] nvarchar(max)  NULL,
    [LogisticColumn19] nvarchar(max)  NULL,
    [LogisticColumn20] nvarchar(max)  NULL,
    [SortNumber] int  NOT NULL
);
GO

-- Creating table 'ErpReturnOrder'
CREATE TABLE [dbo].[ErpReturnOrder] (
    [ReturnOrderId] int IDENTITY(1,1) NOT NULL,
    [ReturnOrderNo] nvarchar(32)  NOT NULL,
    [CustId] nvarchar(32)  NOT NULL,
    [ReturnOrderTime] datetime  NULL,
    [TotalNum] int  NOT NULL,
    [TotalAmount] decimal(18,2)  NOT NULL,
    [ApproveAmount] decimal(18,2)  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [Approver] nvarchar(64)  NULL,
    [ApproveTime] datetime  NULL,
    [StatusCode] smallint  NULL,
    [Remarks] nvarchar(max)  NULL,
    [StoreId] int  NOT NULL
);
GO

-- Creating table 'ErpReturnOrderDetail'
CREATE TABLE [dbo].[ErpReturnOrderDetail] (
    [ReturnOrderDetailId] int IDENTITY(1,1) NOT NULL,
    [ReturnOrderId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [Sku] nvarchar(64)  NULL,
    [Price] decimal(18,2)  NOT NULL,
    [Amount] decimal(18,0)  NOT NULL,
    [Num] int  NOT NULL,
    [Memo] nvarchar(max)  NULL,
    [BatchNo] nvarchar(64)  NULL,
    [ProductSpecId] int  NOT NULL
);
GO

-- Creating table 'ErpRefund'
CREATE TABLE [dbo].[ErpRefund] (
    [RefundId] int IDENTITY(1,1) NOT NULL,
    [ReturnOrderId] int  NOT NULL,
    [Contact] nvarchar(64)  NULL,
    [Telephone] nvarchar(32)  NULL,
    [AccountName] nvarchar(64)  NULL,
    [BankAccount] nvarchar(32)  NULL,
    [BankName] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpProductLogistic'
CREATE TABLE [dbo].[ErpProductLogistic] (
    [ProductLogisticId] int IDENTITY(1,1) NOT NULL,
    [ProductId] int  NOT NULL,
    [GrossWeight] decimal(18,2)  NOT NULL,
    [Weight] decimal(18,2)  NOT NULL,
    [ProductLength] decimal(18,2)  NOT NULL,
    [ProductWidth] decimal(18,2)  NOT NULL,
    [ProductHeight] decimal(18,2)  NOT NULL,
    [DeclareWeight] decimal(18,2)  NOT NULL,
    [DeclaredPrice] decimal(18,2)  NOT NULL,
    [DeclareCNName] nvarchar(64)  NULL,
    [DeclareENName] nvarchar(64)  NULL,
    [HsCode] nvarchar(32)  NULL
);
GO

-- Creating table 'ErpPurOrder'
CREATE TABLE [dbo].[ErpPurOrder] (
    [PurOrderId] int IDENTITY(1,1) NOT NULL,
    [PurOrderNo] nvarchar(64)  NULL,
    [PurDate] datetime  NULL,
    [PurUserId] int  NOT NULL,
    [SupplyId] int  NOT NULL,
    [Contact] nvarchar(64)  NULL,
    [TelePhone] nvarchar(64)  NULL,
    [ArrivalDate] datetime  NULL,
    [ArrivalPlace] nvarchar(255)  NULL,
    [StoreId] int  NOT NULL,
    [StatusCode] smallint  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [ApproveTime] datetime  NULL,
    [Approver] nvarchar(64)  NULL,
    [TotalNum] int  NOT NULL,
    [TotalAmount] decimal(18,2)  NOT NULL,
    [Remarks] nvarchar(max)  NULL,
    [Discount] decimal(18,2)  NOT NULL,
    [DiscountAmount] decimal(18,2)  NOT NULL,
	[RelationType] nvarchar(64)  NULL,
    [RelationNo] nvarchar(32)  NULL,
    [RelationId] int  NOT NULL,
    [PurOrderTitle] nvarchar(256)  NULL,
    [RelationName] nvarchar(256)  NULL
);
GO

-- Creating table 'ErpPurOrderDetail'
CREATE TABLE [dbo].[ErpPurOrderDetail] (
    [PurOrderDetailId] int IDENTITY(1,1) NOT NULL,
    [PurOrderId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [Sku] nvarchar(64)  NULL,
    [Price] decimal(18,2)  NOT NULL,
    [Amount] decimal(18,0)  NOT NULL,
    [Num] int  NOT NULL,
    [Memo] nvarchar(max)  NULL,
    [BatchNo] nvarchar(64)  NULL,
    [ProductTime] datetime  NULL,
    [ArrivedNum] int  NOT NULL,
    [ProductSpecId] int  NOT NULL
);
GO

-- Creating table 'ErpPurReturnOrder'
CREATE TABLE [dbo].[ErpPurReturnOrder] (
    [PurReturnOrderId] int IDENTITY(1,1) NOT NULL,
    [PurReturnOrderNo] nvarchar(64)  NULL,
    [ReturnDate] datetime  NULL,
    [PurUserId] int  NOT NULL,
    [SupplyId] int  NOT NULL,
    [Contact] nvarchar(64)  NULL,
    [TelePhone] nvarchar(64)  NULL,
    [StoreId] int  NOT NULL,
    [StatusCode] smallint  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL,
    [ApproveTime] datetime  NULL,
    [Approver] nvarchar(64)  NULL,
    [TotalNum] int  NOT NULL,
    [TotalAmount] decimal(18,2)  NOT NULL,
    [Remarks] nvarchar(max)  NULL,
    [Discount] decimal(18,2)  NOT NULL,
    [DiscountAmount] decimal(18,2)  NOT NULL,
    [RelationId] nvarchar(32)  NULL
);
GO

-- Creating table 'ErpPurReturnOrderDetail'
CREATE TABLE [dbo].[ErpPurReturnOrderDetail] (
    [PurReturnOrderDetailId] int IDENTITY(1,1) NOT NULL,
    [PurReturnOrderId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [Sku] nvarchar(64)  NULL,
    [Price] decimal(18,2)  NOT NULL,
    [Amount] decimal(18,0)  NOT NULL,
    [Num] int  NOT NULL,
    [Memo] nvarchar(max)  NULL,
    [BatchNo] nvarchar(64)  NULL,
    [ProductSpecId] int  NOT NULL
);
GO

-- Creating table 'ErpLogisticMode'
CREATE TABLE [dbo].[ErpLogisticMode] (
    [LogisticModeId] int IDENTITY(1,1) NOT NULL,
    [LogisticId] int  NOT NULL,
    [LogisticModeCode] nvarchar(64)  NULL,
    [LogisticMode] nvarchar(64)  NULL,
    [LogisticModeEN] nvarchar(64)  NULL,
    [IsActive] bit  NOT NULL,
    [Remarks] nvarchar(max)  NULL,
    [Express] nvarchar(64)  NULL,
    [EBay] nvarchar(64)  NULL,
    [Wish] nvarchar(64)  NULL,
    [Amazon] nvarchar(64)  NULL,
    [CustomerAgreement] nvarchar(64)  NULL,
    [PrintType] nvarchar(32)  NULL,
    [HasTemplete] char(1)  NULL,
    [ModeTextSize] varchar(32)  NULL,
    [StoreId] int  NOT NULL,
    [TrackingURL] nvarchar(max)  NULL,
    [TrackingNumPoolId] int  NULL,
    [AddressTemCode] nvarchar(64)  NULL,
    [DeclarationTemCode] nvarchar(64)  NULL,
    [LogisticModeColumn1] nvarchar(256)  NULL,
    [LogisticModeColumn2] nvarchar(256)  NULL,
    [LogisticModeColumn3] nvarchar(256)  NULL,
    [LogisticModeColumn4] nvarchar(256)  NULL,
    [LogisticModeColumn5] nvarchar(256)  NULL,
    [LogisticModeColumn6] nvarchar(256)  NULL,
    [LogisticModeColumn7] nvarchar(256)  NULL,
    [LogisticModeColumn8] nvarchar(256)  NULL,
    [LogisticModeColumn9] nvarchar(256)  NULL,
    [LogisticModeColumn10] nvarchar(256)  NULL,
    [LogisticModeColumn11] nvarchar(500)  NULL,
    [LogisticModeColumn12] nvarchar(500)  NULL,
    [LogisticModeColumn13] nvarchar(500)  NULL,
    [LogisticModeColumn14] nvarchar(500)  NULL,
    [LogisticModeColumn15] nvarchar(500)  NULL,
    [AmazonOther] nvarchar(256)  NULL,
    [EbayOther] nvarchar(256)  NULL,
    [WishOther] nvarchar(256)  NULL,
    [SystemIsActive] bit  NOT NULL DEFAULT 1,
    [TookWay] nvarchar(256)  NULL,
    [BackWay] nvarchar(256)  NULL,
    [SpecialAttributes] nvarchar(256)  NULL,
    [ReturnAddress] nvarchar(256)  NULL
);
GO
-- Creating table 'ErpMessage'
CREATE TABLE [dbo].[ErpMessage] (
    [MessageId] bigint IDENTITY(1,1) NOT NULL,
    [GroupId] int  NOT NULL,
    [MessageType] nvarchar(16)  NULL,
    [TypeId] int  NOT NULL,
    [TypeRealtionId] nvarchar(32)  NOT NULL,
    [RelationId] nvarchar(32)  NULL,
    [RelationType] nvarchar(16)  NULL,
    [OwnerRelationId] nvarchar(64)  NULL,
    [UserHashCode] bigint  NULL,
    [SenderName] nvarchar(64)  NULL,
    [CustomerId] int  NOT NULL,
    [GroupKey] nvarchar(32)  NULL,
    [Content] nvarchar(max)  NOT NULL,
    [HaveFile] bit  NOT NULL,
    [FileName] nvarchar(256)  NULL,
    [MediumFileName] nvarchar(256)  NULL,
    [SmallFileName] nvarchar(256)  NULL,
    [CreateTime] datetime  NOT NULL,
    [MsgColumn1] nvarchar(256)  NULL,
    [MsgColumn2] nvarchar(256)  NULL,
    [MsgColumn3] nvarchar(256)  NULL,
    [MsgColumn4] nvarchar(256)  NULL,
    [MsgColumn5] nvarchar(256)  NULL,
    [MsgColumn6] nvarchar(256)  NULL,
    [MsgColumn7] nvarchar(256)  NULL,
    [MsgColumn8] nvarchar(256)  NULL,
    [MsgColumn9] nvarchar(256)  NULL,
    [MsgColumn10] nvarchar(256)  NULL,
    [SenderId] nvarchar(32)  NULL,
    [ReceiverName] nvarchar(64)  NULL,
    [ReceiverId] nvarchar(32)  NULL,
    [IsRead] bit  NOT NULL,
    [OrderId] int  NOT NULL,
    [OrderRelationId] nvarchar(32)  NULL,
    [ProductId] int  NOT NULL,
    [ProductRelationId] nvarchar(32)  NULL
);
GO

-- Creating table 'ErpProductSupplier'
CREATE TABLE [dbo].[ErpProductSupplier] (
    [ProductSupplierId] int IDENTITY(1,1) NOT NULL,
    [ProductId] int  NOT NULL,
    [SupplierId] int  NOT NULL,
    [IsDefault] bit  NOT NULL,
    [ListOrder] int  NOT NULL,
    [Moq] int  NOT NULL,
    [DeliveryTime] int  NULL,
    [UpdateTime] datetime  NULL
);
GO

-- Creating table 'ErpLogisticParam'
CREATE TABLE [dbo].[ErpLogisticParam] (
    [ParamCode] nvarchar(64)  NOT NULL,
    [ParamName] nvarchar(32)  NOT NULL,
    [TableName] nvarchar(32)  NULL,
    [ColumnName] nvarchar(32)  NULL,
    [ParamType] nvarchar(64)  NULL
);
GO
-- Creating table 'ErpLogisticPlan'
CREATE TABLE [dbo].[ErpLogisticPlan] (
    [LogisticPlanId] int IDENTITY(1,1) NOT NULL,
    [LogisticPlanName] nvarchar(64)  NOT NULL,
    [LogisticModeId] int  NOT NULL,
    [OrderNum] int  NOT NULL,
    [IsActive] smallint  NOT NULL,
    [PriceCurrency] nvarchar(32)  NULL,
    [RuleJson] nvarchar(max)  NULL,
    [StoreId] int  NULL
);
GO
-- Creating table 'ErpMessageTemplate'
CREATE TABLE [dbo].[ErpMessageTemplate] (
    [TemplateId] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(64)  NOT NULL,
    [Content] nvarchar(max)  NOT NULL,
    [IsActive] bit  NOT NULL,
    [CreateTime] datetime  NOT NULL,
    [Creator] nvarchar(64)  NULL
);
GO
-- Creating table 'ErpLogisticPrintTem'
CREATE TABLE [dbo].[ErpLogisticPrintTem] (
    [TemId] int IDENTITY(1,1) NOT NULL,
    [TemCode] nvarchar(64)  NULL,
    [Title] nvarchar(64)  NOT NULL,
    [IsCustom] bit  NOT NULL,
    [TemPath] nvarchar(256)  NOT NULL,
    [TemType] smallint  NOT NULL,
    [LogisticCode] varchar(64)  NULL,
    [PrintInterface] nvarchar(64)  NULL,
    [Remark] nvarchar(256)  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NOT NULL,
    [Operator] nvarchar(64)  NULL,
    [OperateTime] datetime  NULL
);
GO
CREATE TABLE [dbo].[ErpApiUserRole] (
    [RoleId] int  NOT NULL,
    [ApiUserId] int  NOT NULL
);
GO

-- Creating table 'ErpTrackingNumPool'
CREATE TABLE [dbo].[ErpTrackingNumPool] (
    [TrackingNumPoolId] int IDENTITY(1,1) NOT NULL,
    [TrackingNumPoolName] nvarchar(64)  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NOT NULL,
    [Remarks] nvarchar(max)  NULL
);
GO

-- Creating table 'ErpTrackingNum'
CREATE TABLE [dbo].[ErpTrackingNum] (
    [TrackingNumId] int IDENTITY(1,1) NOT NULL,
    [TrackingNum] nvarchar(32) NOT NULL,
    [TrackingNumPoolId] int NOT NULL,
    [CreateTime] datetime NULL,
    [UseTime] datetime NULL
);
GO

-- Creating table 'ErpOrderChange'
CREATE TABLE [dbo].[ErpOrderChange] (
    [ChangeId] bigint IDENTITY(1,1) NOT NULL,
    [UserId] nvarchar(128)  NOT NULL,
    [RelationType] nvarchar(32)  NULL,
    [RelationId] nvarchar(64)  NULL,
    [IsSync] bit  NOT NULL,
    [ChangeTime] datetime  NOT NULL,
    [OldStatus] nvarchar(128)  NULL,
    [NewStatus] nvarchar(128)  NULL
);
GO




-- Creating table 'ErpShelfPosition'
CREATE TABLE [dbo].[ErpShelfPosition] (
    [ShelfPositionId] int IDENTITY(1,1) NOT NULL,
    [StoreId] int  NOT NULL,
    [ShelfPosition] nvarchar(32)  NOT NULL,
    [IsActive] bit  NOT NULL,
    [ShelfPositionType] bit  NOT NULL,
    [ShelfPositionColumn1] nvarchar(64)  NULL,
    [ShelfPositionColumn2] nvarchar(64)  NULL,
    [ShelfPositionColumn3] nvarchar(64)  NULL,
    [ShelfPositionColumn4] nvarchar(64)  NULL,
    [ShelfPositionColumn5] nvarchar(64)  NULL,
    [ShelfPositionColumn6] nvarchar(64)  NULL,
    [ShelfPositionColumn7] nvarchar(64)  NULL,
    [ShelfPositionColumn8] nvarchar(64)  NULL,
    [ShelfPositionColumn9] nvarchar(64)  NULL,
    [ShelfPositionColumn10] nvarchar(64)  NULL
);
GO
-- Creating table 'ErpOnlineCatalog'
CREATE TABLE [dbo].[ErpOnlineCatalog] (
    [CatalogId] int IDENTITY(1,1) NOT NULL,
    [CatalogName] nvarchar(128)  NOT NULL,
    [RelationType] nvarchar(32)  NOT NULL,
    [RelationId] nvarchar(32)  NOT NULL,
    [ParentCatalogId] nvarchar(32)  NULL,
    [HasChild] bit  NOT NULL,
    [LevelNum] int  NOT NULL,
    [OrderNo] int  NOT NULL,
    [Remarks] nvarchar(max)  NULL
);
GO

-- Creating table 'ErpCatalogAttribute'
CREATE TABLE [dbo].[ErpCatalogAttribute] (
    [CatatalogAttrId] int IDENTITY(1,1) NOT NULL,
    [RelationType] nvarchar(32)  NOT NULL,
    [CatalogRelationId] nvarchar(32)  NOT NULL,
    [AttrNameId] nvarchar(32)  NOT NULL,
    [AttrName] nvarchar(64)  NULL,
    [IsSKU] bit  NOT NULL,
    [Required] bit  NOT NULL,
    [InputType] nvarchar(32)  NULL,
    [ShowTypeValue] nvarchar(32)  NULL,
    [ColumnName] nvarchar(32)  NULL
);
GO

-- Creating table 'ErpAttributeValue'
CREATE TABLE [dbo].[ErpAttributeValue] (
    [AttrValueId] bigint IDENTITY(1,1) NOT NULL,
	[CatalogAttrId] int  NOT NULL,
    [RelationType] nvarchar(32)  NOT NULL,
    [AttrNameId] nvarchar(32)  NOT NULL,
    [ValueId] nvarchar(32)  NOT NULL,
    [ValueName] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpOnlineProduct'
CREATE TABLE [dbo].[ErpOnlineProduct] (
    [OnlineProductId] int IDENTITY(1,1) NOT NULL,
    [ProductName] nvarchar(512)  NOT NULL,
    [ParentSKU] nvarchar(64)  NULL,
    [CatalogId] nvarchar(32)  NOT NULL,
    [RelationType] nvarchar(32)  NOT NULL,
    [RelationId] nvarchar(32)  NOT NULL,
    [UserId] nvarchar(64)  NULL,
    [ProductId] int  NOT NULL,
    [ProductSpecId] bigint  NOT NULL,
    [KeyWord1] nvarchar(256)  NULL,
    [KeyWord2] nvarchar(256)  NULL,
    [KeyWord3] nvarchar(256)  NULL,
    [KeyWord4] nvarchar(256)  NULL,
    [KeyWord5] nvarchar(256)  NULL,
    [StatusCode] nvarchar(32)  NULL,
    [Content] nvarchar(max)  NULL,
    [ImageUrl] nvarchar(max)  NULL,
    [PackageType] bit  NOT NULL,
    [PackageNum] int  NOT NULL,
    [FreightTemplate] nvarchar(64)  NULL,
    [PromiseTemplate] nvarchar(64)  NULL,
    [ReduceStrategy] nvarchar(64)  NULL,
    [ProductUnit] nvarchar(32)  NULL,
    [ProductPrice] decimal(18,2)  NOT NULL,
    [PriceCurrency] nvarchar(32)  NULL,
    [StockNum] int  NOT NULL,
    [GroupId] nvarchar(32)  NULL,
    [PackageLength] int  NOT NULL,
    [PackageWidth] int  NOT NULL,
    [PackageHeight] int  NOT NULL,
    [GrossWeight] decimal(18,3)  NOT NULL,
    [IsPackSell] bit  NOT NULL,
    [BaseUnit] int  NOT NULL,
    [AddUnit] int  NOT NULL,
    [AddWeight] decimal(18,3)  NOT NULL,
    [DeliveryTime] int  NOT NULL,
    [ProductValidNum] int  NOT NULL,
    [OfflineDate] datetime  NULL,
    [BulkOrder] int  NOT NULL,
    [BulkDiscount] int  NOT NULL,
    [SizechartId] nvarchar(32)  NULL,
    [ShippingCost] decimal(18,2)  NULL,
    [MainImage] nvarchar(max)  NULL,
    [ShippingTime] nvarchar(64)  NULL,
    [ProductViewUrl] nvarchar(512)  NULL
);
GO

-- Creating table 'ErpOnlineProductSpec'
CREATE TABLE [dbo].[ErpOnlineProductSpec] (
    [OlProductSpecId] bigint IDENTITY(1,1) NOT NULL,
    [OnlineProductId] int  NOT NULL,
	[RelationId] nvarchar(64)  NULL,
    [ProductId] int  NOT NULL,
    [ProductSpecId] bigint  NOT NULL,
    [SKU] nvarchar(64)  NULL,
    [Spec1] nvarchar(64)  NULL,
    [Spec2] nvarchar(64)  NULL,
    [Spec3] nvarchar(64)  NULL,
    [Spec4] nvarchar(64)  NULL,
    [Spec5] nvarchar(64)  NULL,
	[SpecValue1] nvarchar(64)  NULL,
    [SpecValue2] nvarchar(64)  NULL,
    [SpecValue3] nvarchar(64)  NULL,
    [SpecValue4] nvarchar(64)  NULL,
    [SpecValue5] nvarchar(64)  NULL,
    [SalePrice] decimal(18,2)  NULL,
    [StockNum] int  NOT NULL,
	[ShippingTime] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpOnlineProductAttr'
CREATE TABLE [dbo].[ErpOnlineProductAttr] (
    [OnlineProductId] int  NOT NULL,
    [ProductColumn1] nvarchar(64)  NULL,
    [ProductColumn2] nvarchar(64)  NULL,
    [ProductColumn3] nvarchar(64)  NULL,
    [ProductColumn4] nvarchar(64)  NULL,
    [ProductColumn5] nvarchar(64)  NULL,
    [ProductColumn6] nvarchar(64)  NULL,
    [ProductColumn7] nvarchar(64)  NULL,
    [ProductColumn8] nvarchar(64)  NULL,
    [ProductColumn9] nvarchar(64)  NULL,
    [ProductColumn10] nvarchar(64)  NULL,
    [ProductColumn11] nvarchar(64)  NULL,
    [ProductColumn12] nvarchar(64)  NULL,
    [ProductColumn13] nvarchar(64)  NULL,
    [ProductColumn14] nvarchar(64)  NULL,
    [ProductColumn15] nvarchar(64)  NULL,
    [ProductColumn16] nvarchar(64)  NULL,
    [ProductColumn17] nvarchar(64)  NULL,
    [ProductColumn18] nvarchar(64)  NULL,
    [ProductColumn19] nvarchar(64)  NULL,
    [ProductColumn20] nvarchar(64)  NULL,
    [ProductColumn21] nvarchar(64)  NULL,
    [ProductColumn22] nvarchar(64)  NULL,
    [ProductColumn23] nvarchar(64)  NULL,
    [ProductColumn24] nvarchar(64)  NULL,
    [ProductColumn25] nvarchar(64)  NULL,
    [ProductColumn26] nvarchar(64)  NULL,
    [ProductColumn27] nvarchar(64)  NULL,
    [ProductColumn28] nvarchar(64)  NULL,
    [ProductColumn29] nvarchar(64)  NULL,
    [ProductColumn30] nvarchar(64)  NULL,
    [ProductColumn31] nvarchar(64)  NULL,
    [ProductColumn32] nvarchar(64)  NULL,
    [ProductColumn33] nvarchar(64)  NULL,
    [ProductColumn34] nvarchar(64)  NULL,
    [ProductColumn35] nvarchar(64)  NULL,
    [ProductColumn36] nvarchar(64)  NULL,
    [ProductColumn37] nvarchar(64)  NULL,
    [ProductColumn38] nvarchar(64)  NULL,
    [ProductColumn39] nvarchar(64)  NULL,
    [ProductColumn40] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpSKURelation'
CREATE TABLE [dbo].[ErpSKURelation] (
    [SKURelationId] int IDENTITY(1,1) NOT NULL,
    [LocalSKU] nvarchar(64)  NULL,
    [SalerSKU] nvarchar(64)  NULL
);
GO

-- Creating table 'ErpProductSupplierOffer'
CREATE TABLE [dbo].[ErpProductSupplierOffer] (
    [SupplierOfferId] int IDENTITY(1,1) NOT NULL,
    [ProductId] int  NOT NULL,
    [SKU] nvarchar(64)  NOT NULL,
    [ProductSpecId] int  NOT NULL,
    [SupplierId] int  NOT NULL,
    [SupplierOffer] decimal(18,2)  NOT NULL,
    [PurLink] nvarchar(256)  NULL,
    [Creator] nvarchar(64)  NULL,
    [OfferDate] datetime  NOT NULL
);
GO
-- Creating table 'ErpSupProduct'
CREATE TABLE [dbo].[ErpSupProduct] (
    [SupProductId] int IDENTITY(1,1) NOT NULL,
    [ParentProductId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [ProductSpecId] int  NULL,
    [ProductSku] nvarchar(64)  NULL,
	[ProductCount] int  NOT NULL
);
GO
-- Creating table 'ErpLogisticModeParam'
CREATE TABLE [dbo].[ErpLogisticModeParam] (
    [ParamId] int IDENTITY(1,1) NOT NULL,
    [LogisticId] int  NULL,
    [LogisticModeCode] nvarchar(64)  NULL,
    [CountryCode] nvarchar(64)  NULL,
    [CountryName] nvarchar(200)  NULL,
	[ParamType] nvarchar(64)  NULL,
    [ParamValue1] nvarchar(200)  NULL,
    [ParamValue2] nvarchar(200)  NULL,
    [ParamValue3] nvarchar(200)  NULL,
);
GO
-- Creating table 'ErpOrderLogisticCache'
CREATE TABLE [dbo].[ErpOrderLogisticCache] (
    [LogisticCacheId] int IDENTITY(1,1) NOT NULL,
    [RelationId] nvarchar(32)  NULL,
    [RelationType] nvarchar(32)  NULL,
    [GrossWeight] decimal(18,2)  NOT NULL,
    [Weight] decimal(18,2)  NOT NULL,
    [PackageLength] decimal(18,2)  NOT NULL,
    [PackageWidth] decimal(18,2)  NOT NULL,
    [PackageHeight] decimal(18,2)  NOT NULL,
    [DeclareWeight] decimal(18,2)  NOT NULL,
    [DeclaredPrice] decimal(18,2)  NOT NULL,
    [DeclareCNName] nvarchar(64)  NULL,
    [DeclareENName] nvarchar(64)  NULL,
    [HsCode] nvarchar(32)  NULL
);
GO
-- Creating table 'ErpArrivalRecord'
CREATE TABLE [dbo].[ErpArrivalRecord] (
    [ArrivalRecordId] int IDENTITY(1,1) NOT NULL,
    [PurOrderId] int  NOT NULL,
    [Creator] nvarchar(max)  NULL,
    [ArrivalTime] datetime  NULL,
    [ArrivalNum] int  NOT NULL,
    [Remarks] nvarchar(max)  NULL,
    [InStoreId] int  NOT NULL
);
GO

-- Creating table 'ErpArrivalRecordDetail'
CREATE TABLE [dbo].[ErpArrivalRecordDetail] (
    [ArrivalRecordDetailId] int IDENTITY(1,1) NOT NULL,
    [ArrivalRecordId] int  NOT NULL,
    [PurOrderId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [ProductSpecId] int  NOT NULL,
    [SKU] nvarchar(max)  NULL,
    [Num] int  NOT NULL,
    [Price] decimal(18,0)  NOT NULL,
    [PurOrderDetailId] int  NOT NULL
);
GO
-- Creating table 'ErpAllocation'
CREATE TABLE [dbo].[ErpAllocation] (
    [AllocationId] int IDENTITY(1,1) NOT NULL,
    [StoreId] int  NOT NULL,
    [ShelfPositionId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [ProductSpecId] int  NOT NULL,
    [SKU] nvarchar(64)  NULL,
    [AllocationNum] int  NOT NULL,
    [StockId] int  NOT NULL,
    [OrderId] int  NOT NULL,
    [OrderDetailId] int  NOT NULL
);
GO

-- Creating table 'ErpPurPlan'
CREATE TABLE [dbo].[ErpPurPlan] (
    [PurPlanId] int IDENTITY(1,1) NOT NULL,
    [PurPlanNo] nvarchar(32)  NOT NULL,
    [PurPlanTitle] nvarchar(255)  NOT NULL,
    [SotreId] int  NOT NULL,
    [TotalNum] int  NOT NULL,
    [TotalAmount] decimal(18,2)  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL,
    [SubmitTime] datetime  NOT NULL,
    [StatusCode] int  NOT NULL
);
GO
-- Creating table 'ErpPurPlanDetail'
CREATE TABLE [dbo].[ErpPurPlanDetail] (
    [PurPlanDetailId] int IDENTITY(1,1) NOT NULL,
    [PurPlanId] int  NOT NULL,
    [ProductId] int  NOT NULL,
    [ProductSpecId] int  NOT NULL,
    [SKU] nvarchar(255)  NULL,
    [PurNum] int  NOT NULL,
    [PurPrice] decimal(18,2)  NOT NULL,
    [SupplierId] int  NOT NULL,
    [PurChaserId] int  NOT NULL
);
GO

-- Creating table 'ErpMessageGroup'
CREATE TABLE [dbo].[ErpMessageGroup] (
    [GroupId] int IDENTITY(1,1) NOT NULL,
    [OwnerUserId] nvarchar(64)  NULL,
    [UserHashCode] bigint  NULL,
    [RelationType] nvarchar(16)  NULL,
    [MessageType] int  NULL,
    [GroupKey] nvarchar(32)  NULL,
    [UnreadCount] smallint  NOT NULL,
    [LastMessageId] bigint  NOT NULL,
    [LastRelationId] nvarchar(32)  NULL,
    [LastMessageCoutent] nvarchar(max)  NULL,
    [LastMessageIsOwn] bit  NOT NULL,
    [LastMessageTime] datetime  NOT NULL,
    [ChildUserName] nvarchar(64)  NULL,
    [ChildUserId] nvarchar(64)  NULL,
    [OtherUserName] nvarchar(64)  NULL,
    [OtherUserId] nvarchar(64)  NULL,
    [DealStat] bit  NOT NULL,
    [Rank] nvarchar(32)  NULL
);
GO
-- Creating table 'ErpWaitEvaluated'
CREATE TABLE [dbo].[ErpWaitEvaluated] (
    [WaitEvaluatedId] int IDENTITY(1,1) NOT NULL,
    [RelationId] nvarchar(64)  NULL,
    [RelationType] nvarchar(32)  NULL,
    [UserHashCode] bigint  NULL,
    [Content] nvarchar(max)  NULL,
    [EvaluationTime] datetime  NULL,
    [IsEvaluation] bit  NOT NULL,
	[Score]  int  null
);
GO

-- Creating table 'ErpPackageTrackItem'
CREATE TABLE [dbo].[ErpPackageTrackItem] (
    [TrackItemId] bigint IDENTITY(1,1) NOT NULL,
    [PackageTrackId] int  NOT NULL,
    [TrackTime] datetime  NOT NULL,
    [Address1] nvarchar(256)  NULL,
    [Address2] nvarchar(256)  NULL,
    [EventString] nvarchar(256)  NULL,
    [IsFrom] bit  NOT NULL
);
GO

CREATE TABLE [dbo].[ErpPackageTrack] (
    [PackageTrackId] int IDENTITY(1,1) NOT NULL,
    [DeliveryId] int  NOT NULL,
    [OrderId] int  NOT NULL,
    [TrackingNo] nvarchar(64)  NULL,
    [PackageType] int  NOT NULL,
    [PackageStauts] int  NOT NULL,
    [FromCountry] nvarchar(64)  NULL,
    [FromCountryName] nvarchar(256)  NULL,
    [ToCountry] nvarchar(64)  NULL,
    [ToCountryName] nvarchar(256)  NULL,
    [FromStatus] int  NOT NULL,
    [ToStatus] int  NOT NULL,
    [SearchTime] datetime  NOT NULL,
    [CacheTime] datetime  NULL,
    [LastEventTime] datetime  NULL,
    [LastEvent] nvarchar(max)  NULL,
    [Remarks] nvarchar(max)  NULL
);
GO
-- Creating table 'ErpPurProposal'
CREATE TABLE [dbo].[ErpPurProposal] (
    [ProposalId] int IDENTITY(1,1) NOT NULL,
    [ProductId] int  NULL,
    [ProductSpecId] int  NULL,
    [SupplierId] int  NULL,
    [StoreId] int  NULL,
    [ShelfPositionId] int  NULL,
    [ProposalNum] int  NULL,
    [ProposalTime] datetime  NULL,
	[Sku] nvarchar(128)  NULL
);
GO
CREATE TABLE [dbo].[ErpSaleSiteMessage] (
    [SaleSiteMessageId] int IDENTITY(1,1) NOT NULL,
    [OwnerUserId] nvarchar(64)  NULL,
    [UserHashCode] bigint  NULL,
    [RelationType] nvarchar(64)  NULL,
    [SiteMessageId] nvarchar(64)  NOT NULL,
    [MessageType] nvarchar(64)  NULL,
    [QuestionType] nvarchar(64)  NULL,
    [IsRead] bit  NULL,
    [IsReplied] bit  NULL,
    [IsResponseEnabled] bit  NULL,
    [UserResponseDate] datetime  NULL,
    [ReceiveDate] bit  NULL,
    [Sender] nvarchar(64)  NULL,
    [Subject] nvarchar(800)  NULL,
    [IsHighPriority] bit  NULL,
    [MessageText] nvarchar(max)  NULL,
    [MessageContent] nvarchar(max)  NULL,
    [ItemId] nvarchar(64)  NULL,
    [ItemTitle] nvarchar(600)  NULL,
    [ItemEndTime] datetime  NULL
);
GO
-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [ArrivalRecordId] in table 'ErpArrivalRecord'
ALTER TABLE [dbo].[ErpArrivalRecord]
ADD CONSTRAINT [PK_ErpArrivalRecord]
    PRIMARY KEY CLUSTERED ([ArrivalRecordId] ASC);
GO

-- Creating primary key on [ArrivalRecordDetailId] in table 'ErpArrivalRecordDetail'
ALTER TABLE [dbo].[ErpArrivalRecordDetail]
ADD CONSTRAINT [PK_ErpArrivalRecordDetail]
    PRIMARY KEY CLUSTERED ([ArrivalRecordDetailId] ASC);
GO

-- Creating primary key on [ProductId] in table 'ErpProduct'
ALTER TABLE [dbo].[ErpProduct]
ADD CONSTRAINT [PK_ErpProduct]
    PRIMARY KEY CLUSTERED ([ProductId] ASC);
GO

-- Creating primary key on [InStoreId] in table 'ErpInStore'
ALTER TABLE [dbo].[ErpInStore]
ADD CONSTRAINT [PK_ErpInStore]
    PRIMARY KEY CLUSTERED ([InStoreId] ASC);
GO

-- Creating primary key on [OutStoreId] in table 'ErpOutStore'
ALTER TABLE [dbo].[ErpOutStore]
ADD CONSTRAINT [PK_ErpOutStore]
    PRIMARY KEY CLUSTERED ([OutStoreId] ASC);
GO

-- Creating primary key on [InStoreDetailId] in table 'ErpInStoreDetail'
ALTER TABLE [dbo].[ErpInStoreDetail]
ADD CONSTRAINT [PK_ErpInStoreDetail]
    PRIMARY KEY CLUSTERED ([InStoreDetailId] ASC);
GO

-- Creating primary key on [OutStoreDetailId] in table 'ErpOutStoreDetail'
ALTER TABLE [dbo].[ErpOutStoreDetail]
ADD CONSTRAINT [PK_ErpOutStoreDetail]
    PRIMARY KEY CLUSTERED ([OutStoreDetailId] ASC);
GO

-- Creating primary key on [StockId], [ProductId], [StoreId] in table 'ErpStock'
ALTER TABLE [dbo].[ErpStock]
ADD CONSTRAINT [PK_ErpStock]
    PRIMARY KEY CLUSTERED ([StockId] ASC);
GO

-- Creating primary key on [CheckId] in table 'ErpCheck'
ALTER TABLE [dbo].[ErpCheck]
ADD CONSTRAINT [PK_ErpCheck]
    PRIMARY KEY CLUSTERED ([CheckId] ASC);
GO

-- Creating primary key on [CheckAddId] in table 'ErpCheckAdd'
ALTER TABLE [dbo].[ErpCheckAdd]
ADD CONSTRAINT [PK_ErpCheckAdd]
    PRIMARY KEY CLUSTERED ([CheckAddId] ASC);
GO

-- Creating primary key on [CheckAddDetailId] in table 'ErpCheckAddDetail'
ALTER TABLE [dbo].[ErpCheckAddDetail]
ADD CONSTRAINT [PK_ErpCheckAddDetail]
    PRIMARY KEY CLUSTERED ([CheckAddDetailId] ASC);
GO

-- Creating primary key on [CheckDetailId] in table 'ErpCheckDetail'
ALTER TABLE [dbo].[ErpCheckDetail]
ADD CONSTRAINT [PK_ErpCheckDetail]
    PRIMARY KEY CLUSTERED ([CheckDetailId] ASC);
GO

-- Creating primary key on [CheckSubId] in table 'ErpCheckSub'
ALTER TABLE [dbo].[ErpCheckSub]
ADD CONSTRAINT [PK_ErpCheckSub]
    PRIMARY KEY CLUSTERED ([CheckSubId] ASC);
GO

-- Creating primary key on [CheckSubDetailId] in table 'ErpCheckSubDetail'
ALTER TABLE [dbo].[ErpCheckSubDetail]
ADD CONSTRAINT [PK_ErpCheckSubDetail]
    PRIMARY KEY CLUSTERED ([CheckSubDetailId] ASC);
GO

-- Creating primary key on [StoreId] in table 'ErpStore'
ALTER TABLE [dbo].[ErpStore]
ADD CONSTRAINT [PK_ErpStore]
    PRIMARY KEY CLUSTERED ([StoreId] ASC);
GO

-- Creating primary key on [CustomerId] in table 'ErpCustomer'
ALTER TABLE [dbo].[ErpCustomer]
ADD CONSTRAINT [PK_ErpCustomer]
    PRIMARY KEY CLUSTERED ([CustomerId] ASC);
GO

-- Creating primary key on [SupplierId] in table 'ErpSupplier'
ALTER TABLE [dbo].[ErpSupplier]
ADD CONSTRAINT [PK_ErpSupplier]
    PRIMARY KEY CLUSTERED ([SupplierId] ASC);
GO

-- Creating primary key on [TransferId] in table 'ErpTransfer'
ALTER TABLE [dbo].[ErpTransfer]
ADD CONSTRAINT [PK_ErpTransfer]
    PRIMARY KEY CLUSTERED ([TransferId] ASC);
GO

-- Creating primary key on [TransferDetailId] in table 'ErpTransferDetail'
ALTER TABLE [dbo].[ErpTransferDetail]
ADD CONSTRAINT [PK_ErpTransferDetail]
    PRIMARY KEY CLUSTERED ([TransferDetailId] ASC);
GO

-- Creating primary key on [ProductId], [SKU] in table 'ErpProductSpec'
ALTER TABLE [dbo].[ErpProductSpec]
ADD CONSTRAINT [PK_ErpProductSpec]
    PRIMARY KEY CLUSTERED ([ProductSpecId] ASC);
GO

-- Creating primary key on [SpecTemId] in table 'ErpProductSpecTem'
ALTER TABLE [dbo].[ErpProductSpecTem]
ADD CONSTRAINT [PK_ErpProductSpecTem]
    PRIMARY KEY CLUSTERED ([SpecTemId] ASC);
GO

-- Creating primary key on [ApiUserId] in table 'ErpApiUser'
ALTER TABLE [dbo].[ErpApiUser]
ADD CONSTRAINT [PK_ErpApiUser]
    PRIMARY KEY CLUSTERED ([ApiUserId] ASC);
GO

-- Creating primary key on [OrderId] in table 'ErpOrder'
ALTER TABLE [dbo].[ErpOrder]
ADD CONSTRAINT [PK_ErpOrder]
    PRIMARY KEY CLUSTERED ([OrderId] ASC);
GO

-- Creating primary key on [OrderDetailId] in table 'ErpOrderDetail'
ALTER TABLE [dbo].[ErpOrderDetail]
ADD CONSTRAINT [PK_ErpOrderDetail]
    PRIMARY KEY CLUSTERED ([OrderDetailId] ASC);
GO

-- Creating primary key on [BankId] in table 'ErpBank'
ALTER TABLE [dbo].[ErpBank]
ADD CONSTRAINT [PK_ErpBank]
    PRIMARY KEY CLUSTERED ([BankId] ASC);
GO

-- Creating primary key on [InvoiceId] in table 'ErpInvoice'
ALTER TABLE [dbo].[ErpInvoice]
ADD CONSTRAINT [PK_ErpInvoice]
    PRIMARY KEY CLUSTERED ([InvoiceId] ASC);
GO

-- Creating primary key on [AddressId] in table 'ErpAddress'
ALTER TABLE [dbo].[ErpAddress]
ADD CONSTRAINT [PK_ErpAddress]
    PRIMARY KEY CLUSTERED ([AddressId] ASC);
GO

-- Creating primary key on [PaymentRecordId] in table 'ErpPaymentRecord'
ALTER TABLE [dbo].[ErpPaymentRecord]
ADD CONSTRAINT [PK_ErpPaymentRecord]
    PRIMARY KEY CLUSTERED ([PaymentRecordId] ASC);
GO

-- Creating primary key on [DeliveryId] in table 'ErpDelivery'
ALTER TABLE [dbo].[ErpDelivery]
ADD CONSTRAINT [PK_ErpDelivery]
    PRIMARY KEY CLUSTERED ([DeliveryId] ASC);
GO

-- Creating primary key on [LogisticId] in table 'ErpLogistic'
ALTER TABLE [dbo].[ErpLogistic]
ADD CONSTRAINT [PK_ErpLogistic]
    PRIMARY KEY CLUSTERED ([LogisticId] ASC);
GO

-- Creating primary key on [ReturnOrderId] in table 'ErpReturnOrder'
ALTER TABLE [dbo].[ErpReturnOrder]
ADD CONSTRAINT [PK_ErpReturnOrder]
    PRIMARY KEY CLUSTERED ([ReturnOrderId] ASC);
GO

-- Creating primary key on [ReturnOrderDetailId] in table 'ErpReturnOrderDetail'
ALTER TABLE [dbo].[ErpReturnOrderDetail]
ADD CONSTRAINT [PK_ErpReturnOrderDetail]
    PRIMARY KEY CLUSTERED ([ReturnOrderDetailId] ASC);
GO

-- Creating primary key on [RefundId], [ReturnOrderId] in table 'ErpRefund'
ALTER TABLE [dbo].[ErpRefund]
ADD CONSTRAINT [PK_ErpRefund]
    PRIMARY KEY CLUSTERED ([RefundId], [ReturnOrderId] ASC);
GO

-- Creating primary key on [ProductLogisticId] in table 'ErpProductLogistic'
ALTER TABLE [dbo].[ErpProductLogistic]
ADD CONSTRAINT [PK_ErpProductLogistic]
    PRIMARY KEY CLUSTERED ([ProductLogisticId] ASC);
GO

-- Creating primary key on [PurOrderId] in table 'ErpPurOrder'
ALTER TABLE [dbo].[ErpPurOrder]
ADD CONSTRAINT [PK_ErpPurOrder]
    PRIMARY KEY CLUSTERED ([PurOrderId] ASC);
GO

-- Creating primary key on [PurOrderDetailId] in table 'ErpPurOrderDetail'
ALTER TABLE [dbo].[ErpPurOrderDetail]
ADD CONSTRAINT [PK_ErpPurOrderDetail]
    PRIMARY KEY CLUSTERED ([PurOrderDetailId] ASC);
GO

-- Creating primary key on [PurReturnOrderId] in table 'ErpPurReturnOrder'
ALTER TABLE [dbo].[ErpPurReturnOrder]
ADD CONSTRAINT [PK_ErpPurReturnOrder]
    PRIMARY KEY CLUSTERED ([PurReturnOrderId] ASC);
GO

-- Creating primary key on [PurReturnOrderDetailId] in table 'ErpPurReturnOrderDetail'
ALTER TABLE [dbo].[ErpPurReturnOrderDetail]
ADD CONSTRAINT [PK_ErpPurReturnOrderDetail]
    PRIMARY KEY CLUSTERED ([PurReturnOrderDetailId] ASC);
GO

-- Creating primary key on [LogisticModeId] in table 'ErpLogisticMode'
ALTER TABLE [dbo].[ErpLogisticMode]
ADD CONSTRAINT [PK_ErpLogisticMode]
    PRIMARY KEY CLUSTERED ([LogisticModeId] ASC);
GO

-- Creating primary key on [ProductSupplierId] in table 'ErpProductSupplier'
ALTER TABLE [dbo].[ErpProductSupplier]
ADD CONSTRAINT [PK_ErpProductSupplier]
    PRIMARY KEY CLUSTERED ([ProductSupplierId] ASC);
GO

-- Creating primary key on [MessageId] in table 'ErpMessage'
ALTER TABLE [dbo].[ErpMessage]
ADD CONSTRAINT [PK_ErpMessage]
    PRIMARY KEY CLUSTERED ([MessageId] ASC);
GO

-- Creating primary key on [ParamCode] in table 'ErpLogisticParam'
ALTER TABLE [dbo].[ErpLogisticParam]
ADD CONSTRAINT [PK_ErpLogisticParam]
    PRIMARY KEY CLUSTERED ([ParamCode] ASC);
GO

-- Creating primary key on [LogisticPlanId] in table 'ErpLogisticPlan'
ALTER TABLE [dbo].[ErpLogisticPlan]
ADD CONSTRAINT [PK_ErpLogisticPlan]
    PRIMARY KEY CLUSTERED ([LogisticPlanId] ASC);
GO
-- Creating primary key on [TemplateId] in table 'ErpMessageTemplate'
ALTER TABLE [dbo].[ErpMessageTemplate]
ADD CONSTRAINT [PK_ErpMessageTemplate]
    PRIMARY KEY CLUSTERED ([TemplateId] ASC);
GO
-- Creating primary key on [TemId] in table 'ErpLogisticPrintTem'
ALTER TABLE [dbo].[ErpLogisticPrintTem]
ADD CONSTRAINT [PK_ErpLogisticPrintTem]
    PRIMARY KEY CLUSTERED ([TemId] ASC);
GO
ALTER TABLE [dbo].[ErpApiUserRole]
ADD CONSTRAINT [PK_ErpApiUserRole]
    PRIMARY KEY CLUSTERED ([ApiUserId], [RoleId] ASC);
GO

-- Creating primary key on [TrackingNumPoolId] in table 'ErpTrackingNumPool'
ALTER TABLE [dbo].[ErpTrackingNumPool]
ADD CONSTRAINT [PK_TrackingNumPool]
    PRIMARY KEY CLUSTERED ([TrackingNumPoolId] ASC);
GO

-- Creating primary key on [TrackingNumId] in table 'ErpTrackingNum'
ALTER TABLE [dbo].[ErpTrackingNum]
ADD CONSTRAINT [PK_ErpTrackingNum]
    PRIMARY KEY CLUSTERED ([TrackingNumId] ASC);
GO

ALTER TABLE [dbo].[ErpOrderChange]
ADD CONSTRAINT [PK_ErpOrderChange]
    PRIMARY KEY CLUSTERED ([ChangeId] ASC);
GO
-- Creating primary key on [ShelfPositionId] in table 'ErpShelfPosition'
ALTER TABLE [dbo].[ErpShelfPosition]
ADD CONSTRAINT [PK_ErpShelfPosition]
    PRIMARY KEY CLUSTERED ([ShelfPositionId] ASC);
GO
-- Creating primary key on [CatalogId] in table 'ErpOnlineCatalog'
ALTER TABLE [dbo].[ErpOnlineCatalog]
ADD CONSTRAINT [PK_ErpOnlineCatalog]
    PRIMARY KEY CLUSTERED ([CatalogId] ASC);
GO

-- Creating primary key on [CatatalogAttrId] in table 'ErpCatalogAttribute'
ALTER TABLE [dbo].[ErpCatalogAttribute]
ADD CONSTRAINT [PK_ErpCatalogAttribute]
    PRIMARY KEY CLUSTERED ([CatatalogAttrId] ASC);
GO

-- Creating primary key on [AttrValueId] in table 'ErpAttributeValue'
ALTER TABLE [dbo].[ErpAttributeValue]
ADD CONSTRAINT [PK_ErpAttributeValue]
    PRIMARY KEY CLUSTERED ([AttrValueId] ASC);
GO

-- Creating primary key on [OnlineProductId] in table 'ErpOnlineProduct'
ALTER TABLE [dbo].[ErpOnlineProduct]
ADD CONSTRAINT [PK_ErpOnlineProduct]
    PRIMARY KEY CLUSTERED ([OnlineProductId] ASC);
GO

-- Creating primary key on [OlProductSpecId] in table 'ErpOnlineProductSpec'
ALTER TABLE [dbo].[ErpOnlineProductSpec]
ADD CONSTRAINT [PK_ErpOnlineProductSpec]
    PRIMARY KEY CLUSTERED ([OlProductSpecId] ASC);
GO

-- Creating primary key on [OnlineProductId] in table 'ErpOnlineProductAttr'
ALTER TABLE [dbo].[ErpOnlineProductAttr]
ADD CONSTRAINT [PK_ErpOnlineProductAttr]
    PRIMARY KEY CLUSTERED ([OnlineProductId] ASC);
GO

-- Creating primary key on [SKURelationId] in table 'ErpSKURelation'
ALTER TABLE [dbo].[ErpSKURelation]
ADD CONSTRAINT [PK_ErpSKURelation]
    PRIMARY KEY CLUSTERED ([SKURelationId] ASC);
GO

-- Creating primary key on [ParamId] in table 'ErpLogisticModeParam'
ALTER TABLE [dbo].[ErpLogisticModeParam]
ADD CONSTRAINT [PK_ErpLogisticModeParam]
    PRIMARY KEY CLUSTERED ([ParamId] ASC);
GO

-- Creating primary key on [SupProductId] in table 'ErpSupProduct'
ALTER TABLE [dbo].[ErpSupProduct]
ADD CONSTRAINT [PK_ErpSupProduct]
    PRIMARY KEY CLUSTERED ([SupProductId] ASC);
GO

-- Creating primary key on [SupplierOfferId] in table 'ErpProductSupplierOffer'
ALTER TABLE [dbo].[ErpProductSupplierOffer]
ADD CONSTRAINT [PK_ErpProductSupplierOffer]
    PRIMARY KEY CLUSTERED ([SupplierOfferId] ASC);
GO

-- Creating primary key on [LogisticCacheId] in table 'ErpOrderLogisticCache'
ALTER TABLE [dbo].[ErpOrderLogisticCache]
ADD CONSTRAINT [PK_ErpOrderLogisticCache]
    PRIMARY KEY CLUSTERED ([LogisticCacheId] ASC);
GO

-- Creating primary key on [PurPlanId] in table 'ErpPurPlan'
ALTER TABLE [dbo].[ErpPurPlan]
ADD CONSTRAINT [PK_ErpPurPlan]
    PRIMARY KEY CLUSTERED ([PurPlanId] ASC);
GO

-- Creating primary key on [PurPlanDetailId] in table 'ErpPurPlanDetail'
ALTER TABLE [dbo].[ErpPurPlanDetail]
ADD CONSTRAINT [PK_ErpPurPlanDetail]
    PRIMARY KEY CLUSTERED ([PurPlanDetailId] ASC);
GO

-- Creating primary key on [GroupId] in table 'ErpMessageGroup'
ALTER TABLE [dbo].[ErpMessageGroup]
ADD CONSTRAINT [PK_ErpMessageGroup]
    PRIMARY KEY CLUSTERED ([GroupId] ASC);
GO
ALTER TABLE [dbo].[ErpWaitEvaluated]
ADD CONSTRAINT [PK_ErpWaitEvaluated]
    PRIMARY KEY CLUSTERED ([WaitEvaluatedId] ASC);
GO
-- Creating primary key on [TrackItemId] in table 'ErpPackageTrackItem'
ALTER TABLE [dbo].[ErpPackageTrackItem]
ADD CONSTRAINT [PK_ErpPackageTrackItem]
    PRIMARY KEY CLUSTERED ([TrackItemId] ASC);
GO

-- Creating primary key on [PackageTrackId] in table 'ErpPackageTrack'
ALTER TABLE [dbo].[ErpPackageTrack]
ADD CONSTRAINT [PK_ErpPackageTrack]
    PRIMARY KEY CLUSTERED ([PackageTrackId] ASC);
GO
-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [CustId] in table 'ErpOrder'
ALTER TABLE [dbo].[ErpOrder] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReCustomerOrder]
    FOREIGN KEY ([CustId])
    REFERENCES [dbo].[ErpCustomer]
        ([CustomerId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpOrder] NOCHECK CONSTRAINT [FK_ErpReCustomerOrder];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReCustomerOrder'
CREATE INDEX [IX_FK_ErpReCustomerOrder]
ON [dbo].[ErpOrder]
    ([CustId]);
GO

-- Creating foreign key on [OrderId] in table 'ErpOrderDetail'
ALTER TABLE [dbo].[ErpOrderDetail] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReOrderDetail]
    FOREIGN KEY ([OrderId])
    REFERENCES [dbo].[ErpOrder]
        ([OrderId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpOrderDetail] NOCHECK CONSTRAINT [FK_ErpReOrderDetail]
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReOrderDetail'
CREATE INDEX [IX_FK_ErpReOrderDetail]
ON [dbo].[ErpOrderDetail]
    ([OrderId]);
GO

-- Creating foreign key on [OrderId] in table 'ErpPaymentRecord'
ALTER TABLE [dbo].[ErpPaymentRecord] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReOrderPaymentRecord]
    FOREIGN KEY ([OrderId])
    REFERENCES [dbo].[ErpOrder]
        ([OrderId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpPaymentRecord] NOCHECK CONSTRAINT [FK_ErpReOrderPaymentRecord]
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReOrderPaymentRecord'
CREATE INDEX [IX_FK_ErpReOrderPaymentRecord]
ON [dbo].[ErpPaymentRecord]
    ([OrderId]);
GO

-- Creating foreign key on [AddressId] in table 'ErpOrder'
ALTER TABLE [dbo].[ErpOrder] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReAddressOrder]
    FOREIGN KEY ([AddressId])
    REFERENCES [dbo].[ErpAddress]
        ([AddressId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpOrder] NOCHECK CONSTRAINT [FK_ErpReAddressOrder]
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReAddressOrder'
CREATE INDEX [IX_FK_ErpReAddressOrder]
ON [dbo].[ErpOrder]
    ([AddressId]);
GO

-- Creating foreign key on [OrderId] in table 'ErpDelivery'
ALTER TABLE [dbo].[ErpDelivery] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReOrderDelivery]
    FOREIGN KEY ([OrderId])
    REFERENCES [dbo].[ErpOrder]
        ([OrderId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating primary key on [AllocationId] in table 'ErpAllocation'
ALTER TABLE [dbo].[ErpAllocation]
ADD CONSTRAINT [PK_ErpAllocation]
    PRIMARY KEY CLUSTERED ([AllocationId] ASC);
GO

ALTER TABLE [dbo].[ErpDelivery] NOCHECK CONSTRAINT [FK_ErpReOrderDelivery]
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReOrderDelivery'
CREATE INDEX [IX_FK_ErpReOrderDelivery]
ON [dbo].[ErpDelivery]
    ([OrderId]);
GO

--Begin: Rick 2015-06-15 添加几个数据索引---
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ErpMessage]') AND name = N'index_message_relation')
	CREATE NONCLUSTERED INDEX [index_message_relation] ON [dbo].[ErpMessage] 
	(
		[OrderRelationId] ASC,
		[RelationType] ASC,
		[MessageType] ASC
	) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HgComment]') AND name = N'index_comment_relation')
	CREATE NONCLUSTERED INDEX [index_comment_relation] ON [dbo].[HgComment] 
	(
		[RelationId] ASC,
		[CommentType] ASC
	)
	INCLUDE ( [CreateTime]) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ErpOrder]') AND name = N'index_order_relation')
CREATE NONCLUSTERED INDEX [index_order_relation] ON [dbo].[ErpOrder] 
(
	[RelationId] ASC,
	[RelationType] ASC
) ON [PRIMARY]
GO
--End: Rick 2015-06-15 添加几个数据索引---

ALTER TABLE [dbo].[ErpAddress] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReCustomerAddress]
    FOREIGN KEY ([RelationId])
    REFERENCES [dbo].[ErpCustomer]
        ([CustomerId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpAddress] NOCHECK CONSTRAINT [FK_ErpReCustomerAddress];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReCustomerAddress'
CREATE INDEX [IX_FK_ErpReCustomerAddress]
ON [dbo].[ErpAddress]
    ([RelationId]);
GO
-- Creating foreign key on [OnlineProductId] in table 'ErpOnlineProductAttr'
ALTER TABLE [dbo].[ErpOnlineProductAttr] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReOnlineProductAttr]
    FOREIGN KEY ([OnlineProductId])
    REFERENCES [dbo].[ErpOnlineProduct]
        ([OnlineProductId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpOnlineProductAttr] NOCHECK CONSTRAINT [FK_ErpReOnlineProductAttr];
GO

-- Creating foreign key on [OnlineProductId] in table 'ErpOnlineProductSpec'
ALTER TABLE [dbo].[ErpOnlineProductSpec] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReOnlineProductSpec]
    FOREIGN KEY ([OnlineProductId])
    REFERENCES [dbo].[ErpOnlineProduct]
        ([OnlineProductId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpOnlineProductSpec] NOCHECK CONSTRAINT [FK_ErpReOnlineProductSpec];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReOnlineProductSpec'
CREATE INDEX [IX_FK_ErpReOnlineProductSpec]
ON [dbo].[ErpOnlineProductSpec]
    ([OnlineProductId]);
GO

CREATE NONCLUSTERED INDEX [index_catalog_relation] ON [dbo].[ErpCatalogAttribute] 
(
	[RelationType] ASC,
	[CatalogRelationId] ASC
)
INCLUDE ( [AttrNameId],
[IsSKU],
[Required]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
CREATE NONCLUSTERED INDEX [index_attribute_relation] ON [dbo].[ErpAttributeValue] 
(
	[RelationType] ASC,
	[AttrNameId] ASC
)
INCLUDE ( [AttrValueId],
[ValueId],
[ValueName]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
-- Creating foreign key on [CatalogAttrId] in table 'ErpAttributeValue'
ALTER TABLE [dbo].[ErpAttributeValue] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReCatalogAttributeValue]
    FOREIGN KEY ([CatalogAttrId])
    REFERENCES [dbo].[ErpCatalogAttribute]
        ([CatatalogAttrId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpAttributeValue] NOCHECK CONSTRAINT [FK_ErpReCatalogAttributeValue];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReCatalogAttributeValue'
CREATE INDEX [IX_FK_ErpReCatalogAttributeValue]
ON [dbo].[ErpAttributeValue]
    ([CatalogAttrId]);
GO

-- Creating foreign key on [ProductId] in table 'ErpProductLogistic'
ALTER TABLE [dbo].[ErpProductLogistic] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReProductLogistic]
    FOREIGN KEY ([ProductId])
    REFERENCES [dbo].[ErpProduct]
        ([ProductId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpProductLogistic] NOCHECK CONSTRAINT [FK_ErpReProductLogistic];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReProductLogistic'
CREATE INDEX [IX_FK_ErpReProductLogistic]
ON [dbo].[ErpProductLogistic]
    ([ProductId]);
GO

-- Creating foreign key on [ProductId] in table 'ErpProductSpec'
ALTER TABLE [dbo].[ErpProductSpec] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReProductSpec]
    FOREIGN KEY ([ProductId])
    REFERENCES [dbo].[ErpProduct]
        ([ProductId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpProductSpec] NOCHECK CONSTRAINT [FK_ErpReProductSpec];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReProductSpec'
CREATE INDEX [IX_FK_ErpReProductSpec]
ON [dbo].[ErpProductSpec]
    ([ProductId]);
GO

-- Creating foreign key on [ProductId] in table 'ErpProductSupplier'
ALTER TABLE [dbo].[ErpProductSupplier] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReProductSupplier]
    FOREIGN KEY ([ProductId])
    REFERENCES [dbo].[ErpProduct]
        ([ProductId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpProductSupplier] NOCHECK CONSTRAINT [FK_ErpReProductSupplier];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReProductSupplier'
CREATE INDEX [IX_FK_ErpReProductSupplier]
ON [dbo].[ErpProductSupplier]
    ([ProductId]);
GO

-- Creating foreign key on [SupplierId] in table 'ErpProductSupplier'
ALTER TABLE [dbo].[ErpProductSupplier] WITH NOCHECK
ADD CONSTRAINT [FK_ErpRESupplierProduct]
    FOREIGN KEY ([SupplierId])
    REFERENCES [dbo].[ErpSupplier]
        ([SupplierId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpProductSupplier] NOCHECK CONSTRAINT [FK_ErpRESupplierProduct];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpRESupplierProduct'
CREATE INDEX [IX_FK_ErpRESupplierProduct]
ON [dbo].[ErpProductSupplier]
    ([SupplierId]);
GO

-- Creating foreign key on [SpecTemId] in table 'ErpProduct'
ALTER TABLE [dbo].[ErpProduct] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReProductSpecTem]
    FOREIGN KEY ([SpecTemId])
    REFERENCES [dbo].[ErpProductSpecTem]
        ([SpecTemId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpProduct] NOCHECK CONSTRAINT [FK_ErpReProductSpecTem];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReProductSpecTem'
CREATE INDEX [IX_FK_ErpReProductSpecTem]
ON [dbo].[ErpProduct]
    ([SpecTemId]);
GO

-- Creating foreign key on [ProductId] in table 'ErpProductSupplierOffer'
ALTER TABLE [dbo].[ErpProductSupplierOffer] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReProductSupplierOffer]
    FOREIGN KEY ([ProductId])
    REFERENCES [dbo].[ErpProduct]
        ([ProductId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpProductSupplierOffer] NOCHECK CONSTRAINT [FK_ErpReProductSupplierOffer];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReProductSupplierOffer'
CREATE INDEX [IX_FK_ErpReProductSupplierOffer]
ON [dbo].[ErpProductSupplierOffer]
    ([ProductId]);
GO

-- Creating foreign key on [SupplierId] in table 'ErpProductSupplierOffer'
ALTER TABLE [dbo].[ErpProductSupplierOffer] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReSupplierProductOffer]
    FOREIGN KEY ([SupplierId])
    REFERENCES [dbo].[ErpSupplier]
        ([SupplierId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpProductSupplierOffer] NOCHECK CONSTRAINT [FK_ErpReSupplierProductOffer];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReSupplierProductOffer'
CREATE INDEX [IX_FK_ErpReSupplierProductOffer]
ON [dbo].[ErpProductSupplierOffer]
    ([SupplierId]);
GO

/****** Object:  Index [index_relation_id]    Script Date: 07/31/2015 13:29:17 ******/
CREATE NONCLUSTERED INDEX [index_relation_id] ON [ErpOrderLogisticCache] 
(
	[RelationId] ASC,
	[RelationType] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

-- Creating foreign key on [GroupId] in table 'ErpMessage'
ALTER TABLE [dbo].[ErpMessage] WITH NOCHECK
ADD CONSTRAINT [FK_ErpReMessageGroup]
    FOREIGN KEY ([GroupId])
    REFERENCES [dbo].[ErpMessageGroup]
        ([GroupId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpMessage] NOCHECK CONSTRAINT [FK_ErpReMessageGroup];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpReMessageGroup'
CREATE INDEX [IX_FK_ErpReMessageGroup]
ON [dbo].[ErpMessage]
    ([GroupId]);
GO

-- Creating foreign key on [PackageTrackId] in table 'ErpPackageTrackItem'
ALTER TABLE [dbo].[ErpPackageTrackItem] WITH NOCHECK
ADD CONSTRAINT [FK_ErpRePackageTrackItem]
    FOREIGN KEY ([PackageTrackId])
    REFERENCES [dbo].[ErpPackageTrack]
        ([PackageTrackId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[ErpPackageTrackItem] NOCHECK CONSTRAINT [FK_ErpRePackageTrackItem];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ErpRePackageTrackItem'
CREATE INDEX [IX_FK_ErpRePackageTrackItem]
ON [dbo].[ErpPackageTrackItem]
    ([PackageTrackId]);
GO

CREATE NONCLUSTERED INDEX [index_tracking_no] ON [dbo].[ErpPackageTrack] 
(
	[TrackingNo] ASC,
	[OrderId] ASC
)
INCLUDE ( [PackageTrackId],
[DeliveryId]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

-- Creating primary key on [ProposalId] in table 'ErpPurProposal'
ALTER TABLE [dbo].[ErpPurProposal]
ADD CONSTRAINT [PK_ErpPurProposal]
    PRIMARY KEY CLUSTERED ([ProposalId] ASC);
GO
ALTER TABLE [dbo].[ErpSaleSiteMessage]
ADD CONSTRAINT [PK_ErpSaleSiteMessage]
    PRIMARY KEY CLUSTERED ([SaleSiteMessageId] ASC);
GO
-- --------------------------------------------------
-- Script has ended
-- --------------------------------------------------
