﻿
--线上商品与本地产品关联的存储过程
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[procOnlineProductRelation]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[procOnlineProductRelation]
GO

CREATE PROCEDURE [dbo].[procOnlineProductRelation] ( @onlineProductId int, @isMatch bit output )
AS
BEGIN
 declare @sql nvarchar(max)
 declare @hasError bit
 declare @parentSKU nvarchar(64)
 declare @spcCount int
 declare @localSKU nvarchar(64)
 declare @productId int
 declare @productSpecId bigint
 declare @onlineProductSpecId bigint
 declare @specSKU nvarchar(64)
 set @hasError=0
 set @sql=''
 
 --检查指定的线上商品是否存在
 if not exists(select * from ErpOnlineProduct where OnlineProductId=@onlineProductId)
 begin
	set @hasError=1
	goto ProcEnd
 end
 
 select @spcCount = count(*) from ErpOnlineProductSpec where OnlineProductId=@onlineProductId
 if(@spcCount=0) --如果商品没有子规格
 begin
	select @parentSKU = ParentSKU from ErpOnlineProduct where OnlineProductId=@onlineProductId
	if(len(@parentSKU)=0)
	begin
		set @hasError=1
		goto ProcEnd
	end
	
	select @localSKU = LocalSKU from ErpSKURelation where SalerSKU=@parentSKU
	--当未找到SKU映射关系时，直接按本身的SKU查找
	if(len(@localSKU)=0)
	begin
		set @localSKU = @parentSKU
	end
	
	--查找本地产品并映射
	select @productId=Isnull(ProductId,0) from ErpProduct where ProductStyle=@localSKU
	if(@productId>0)
	begin
		set @sql=N'update ErpOnlineProduct set ProductId='+CAST(@productId as nvarchar(64))+',ProductSpecId=0 where OnlineProductId='+CAST(@onlineProductId as nvarchar(64))
	end
	else
	begin
		select @productId=Isnull(ProductId,0),@productSpecId=Isnull(ProductSpecId,0) from ErpProductSpec where SKU=@localSKU
		if(@productId>0)
		begin
			set @sql=N'update ErpOnlineProduct set ProductId='+CAST(@productId as nvarchar(64))+', ProductSpecId='+CAST(@productSpecId as nvarchar(64))+' where OnlineProductId='+CAST(@onlineProductId as nvarchar(64))
		end
	end
 end
 else
 begin

	declare @index int
	set @index=0
	declare #SpecCursor cursor for select OlProductSpecId,SKU from ErpOnlineProductSpec where OnlineProductId=@onlineProductId
	open #SpecCursor
	
	fetch next from #SpecCursor into @onlineProductSpecId,@specSKU
	while(@@FETCH_STATUS=0)
	begin
		set @productId = 0
		set @productSpecId = 0
		set @localSKU = ''
		
		--如果SKU为空，则直接转到结束
		if(LEN(@specSKU)=0)
		begin
			set @hasError=1
			goto ProcEnd
		end
		
		select @localSKU = LocalSKU from ErpSKURelation where SalerSKU=@specSKU
		--当未找到SKU映射关系时，直接按本身的SKU查找
		if(LEN(@localSKU)=0)
		begin
			set @localSKU=@specSKU
		end
		
		--查找本地产品并映射
		select @productId=Isnull(ProductId,0) from ErpProduct where ProductStyle=@localSKU
		if(@productId>0)
		begin
			set @sql+='update ErpOnlineProductSpec set ProductId='+CAST(@productId as nvarchar(64))+',ProductSpecId=0 where OlProductSpecId='+CAST(@onlineProductSpecId as nvarchar(64))+';'
			if(@index=0)
				set @sql+='update ErpOnlineProduct set ProductId='+CAST(@productId as nvarchar(64))+',ProductSpecId=0 where OnlineProductId='+CAST(@onlineProductId as nvarchar(64))+';'
		end
		else
		begin
			select @productId=Isnull(ProductId,0),@productSpecId=Isnull(ProductSpecId,0) from ErpProductSpec where SKU=@localSKU
			if(@productId>0)
			begin
				set @sql+='update ErpOnlineProductSpec set ProductId='+CAST(@productId as nvarchar(64))+',ProductSpecId='+CAST(@productSpecId as nvarchar(64))+' where OlProductSpecId='+CAST(@onlineProductSpecId as nvarchar(64))+';'
				if(@index=0)
					set @sql+='update ErpOnlineProduct set ProductId='+CAST(@productId as nvarchar(64))+',ProductSpecId=0 where OnlineProductId='+CAST(@onlineProductId as nvarchar(64))+';'
			end
			else
			begin
				set @hasError=1
			end
		end
		
		set @index = @index+1
		fetch next from #SpecCursor into @onlineProductSpecId,@specSKU
	end
	
	close #SpecCursor
	deallocate #SpecCursor
 end
 
 --执行脚本
 ProcEnd:
 if(@hasError=0)
 begin
	if(LEN(@sql)>0)
		exec(@sql)
	set @isMatch=1
 end
 else
 begin
	set @isMatch=0
 end
END
GO

--首页获取用户任务数量的存储过程
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[proGetUserTaskCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[proGetUserTaskCount]
GO

CREATE PROCEDURE [dbo].[proGetUserTaskCount]
	@userId int
AS
BEGIN
	declare @isAdmin bit
	declare @OrderApprove int --待处理
	declare @OrderAccording int --待配货
	declare @OrderPrint int --待发货
	declare @OrderNotPrint int --待打单

	declare @OrderOutOfStock int --缺货订单
	declare @OrderPur int --采购在途
	declare @OrderInStore int --待入库

	declare @OrderMessage int --订单留言
	declare @SiteMessage int --站内信
	
	select @isAdmin = IsAdmin from HgUser where UserId = @userId
	if(@isAdmin=1)
	begin
		SELECT 
			@OrderApprove = SUM(case when StatusCode=1 then 1 else 0 end), --待处理
			@OrderAccording = SUM(case when StatusCode=2 then 1 else 0 end), --待配货
			@OrderPrint = SUM(case when StatusCode=3 then 1 else 0 end), --待发货
			@OrderNotPrint = SUM(case when StatusCode=3 and IsPrint=0 then 1 else 0 end) --待打单
		 FROM ErpOrder
		 WHERE OrderMark in ('CombinPackage','Normal','SplitPackage') AND  ErpOrder.IsAbandoned=0
	 end
	 else
	 begin
		SELECT 
			@OrderApprove = SUM(case when StatusCode=1 then 1 else 0 end), --待处理
			@OrderAccording = SUM(case when StatusCode=2 then 1 else 0 end), --待配货
			@OrderPrint = SUM(case when StatusCode=3 then 1 else 0 end), --待发货
			@OrderNotPrint = SUM(case when StatusCode=3 and IsPrint=0 then 1 else 0 end) --待打单
		 FROM ErpOrder
		 inner join ErpApiUser on ErpOrder.UserHashCode = ErpOrder.UserHashCode
		 inner join ErpApiUserRole on ErpApiUser.ApiUserId = ErpApiUserRole.ApiUserId
		 WHERE ErpOrder.IsAbandoned=0 AND OrderMark IN ('CombinPackage','Normal','SplitPackage') AND ErpApiUserRole.RoleId=@userId
	 end
	 
	--缺货订单
	select @OrderOutOfStock = COUNT(*) from ErpOrder where AllocationStatus in (1,2)

	--采购在途
	select @OrderPur = COUNT(*) from ErpPurOrder
	where PurOrderId in (
		select PurOrderId from ErpPurOrderDetail
		 inner join ErpProduct on ErpPurOrderDetail.ProductId=ErpProduct.ProductId 
		)
	 AND (ErpPurOrder.StatusCode = -1 or ErpPurOrder.StatusCode = 0)

	--待入库
	SELECT @OrderInStore = COUNT(*) FROM ErpInStore WHERE StatusCode = -1

	select 
		@OrderMessage = SUM(case when MessageType='order' then 1 else 0 end), --订单留言
		@SiteMessage = SUM(case when MessageType='order' then 0 else 1 end) --站内信
	 from ErpMessage
	 where IsRead=0
	
	if(@OrderApprove is null) 
		set @OrderApprove = 0
	if(@OrderAccording is null) 
		set @OrderAccording = 0
	if(@OrderPrint is null) 
		set @OrderPrint = 0
	if(@OrderNotPrint is null) 
		set @OrderNotPrint = 0
		
	select @OrderApprove as OrderApprove,@OrderAccording as OrderAccording,@OrderPrint as OrderPrint,@OrderNotPrint as OrderNotPrint,@OrderOutOfStock as OrderOutOfStock,@OrderPur as OrderPur,@OrderInStore as OrderInStore,@OrderMessage as OrderMessage,@SiteMessage as SiteMessage
END
GO

--订单管理获取订单各种状态数量的存储过程
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[proGetOrderStatusCount]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[proGetOrderStatusCount]
GO

CREATE PROCEDURE [dbo].[proGetOrderStatusCount]
	@userId int
AS
BEGIN
	declare @isAdmin bit
	declare @AllOrderNum int --所有订单
	declare @OrderApprove int --待处理
	declare @OrderAccording int --待配货
	declare @OrderPrint int --待发货
	declare @OrderReceipt int --已发货
	declare @OrderVirtual int --虚拟已发货
	declare @OrderCompleted int --已完成
	declare @OrderAbandoned int --已作废
	declare @OrderDraft int --其它
	--declare @OrderIssue int --纠纷及退款，注意：纠纷及退款有专门的接口，需要特别处理，所以不在此处查询

	select @isAdmin = IsAdmin from HgUser where UserId = @userId
	if(@isAdmin=1)
	begin
		SELECT 
			@AllOrderNum = COUNT(*), --所有订单
			@OrderApprove = SUM(case when StatusCode=1 and IsAbandoned=0 then 1 else 0 end), --待处理
			@OrderAccording = SUM(case when StatusCode=2 and IsAbandoned=0 then 1 else 0 end), --待配货
			@OrderPrint = SUM(case when StatusCode=3 and IsAbandoned=0 then 1 else 0 end), --待发货
			@OrderReceipt = SUM(case when StatusCode=4 and IsAbandoned=0 then 1 else 0 end), --已发货
			@OrderVirtual = SUM(case when StatusCode=6 and IsAbandoned=0 then 1 else 0 end), --虚拟已发货
			@OrderCompleted = SUM(case when StatusCode=5 and IsAbandoned=0 then 1 else 0 end), --已完成
			@OrderDraft = SUM(case when StatusCode=0 and IsAbandoned=0 then 1 else 0 end), --其它
			@OrderAbandoned = SUM(case when IsAbandoned=1 then 1 else 0 end) --已作废
			--@OrderIssue = SUM(case when OrderColumn2 in('IN_ISSUE','END_ISSUE','IN_CANCEL','IN_ISSUE','IN_FROZEN') then 1 else 0 end) --纠纷及退款
		 FROM ErpOrder
		 WHERE OrderMark in ('CombinPackage','Normal','SplitPackage')
	 end
	 else
	 begin
		SELECT 
			@AllOrderNum = COUNT(*), --所有订单
			@OrderApprove = SUM(case when StatusCode=1 and IsAbandoned=0 then 1 else 0 end), --待处理
			@OrderAccording = SUM(case when StatusCode=2 and IsAbandoned=0 then 1 else 0 end), --待配货
			@OrderPrint = SUM(case when StatusCode=3 and IsAbandoned=0 then 1 else 0 end), --待发货
			@OrderReceipt = SUM(case when StatusCode=4 and IsAbandoned=0 then 1 else 0 end), --已发货
			@OrderVirtual = SUM(case when StatusCode=6 and IsAbandoned=0 then 1 else 0 end), --虚拟已发货
			@OrderCompleted = SUM(case when StatusCode=5 and IsAbandoned=0 then 1 else 0 end), --已完成
			@OrderDraft = SUM(case when StatusCode=0 and IsAbandoned=0 then 1 else 0 end), --其它
			@OrderAbandoned = SUM(case when IsAbandoned=1 then 1 else 0 end) --已作废
			--@OrderIssue = SUM(case when OrderColumn2 in('IN_ISSUE','END_ISSUE','IN_CANCEL','IN_ISSUE','IN_FROZEN') then 1 else 0 end) --纠纷及退款
		 FROM ErpOrder
		 inner join ErpApiUser on ErpOrder.UserHashCode = ErpOrder.UserHashCode
		 inner join ErpApiUserRole on ErpApiUser.ApiUserId = ErpApiUserRole.ApiUserId
		 WHERE OrderMark IN ('CombinPackage','Normal','SplitPackage') AND ErpApiUserRole.RoleId=@userId
	 end
	
	if(@AllOrderNum is null) 
		set @AllOrderNum = 0
	if(@OrderApprove is null) 
		set @OrderApprove = 0
	if(@OrderAccording is null) 
		set @OrderAccording = 0
	if(@OrderPrint is null) 
		set @OrderPrint = 0
	if(@OrderReceipt is null) 
		set @OrderReceipt = 0
	if(@OrderVirtual is null) 
		set @OrderVirtual = 0
	if(@OrderCompleted is null) 
		set @OrderCompleted = 0
	if(@OrderDraft is null) 
		set @OrderDraft = 0
	if(@OrderAbandoned is null) 
		set @OrderAbandoned = 0
		
	select @AllOrderNum as AllOrderNum,@OrderApprove as OrderApprove,@OrderAccording as OrderAccording,@OrderPrint as OrderPrint,@OrderReceipt as OrderReceipt,@OrderVirtual as OrderVirtual,@OrderCompleted as OrderCompleted,@OrderDraft as OrderDraft,@OrderAbandoned as OrderAbandoned
END
GO
SET IDENTITY_INSERT [dbo].[HgCatalog] ON
INSERT [dbo].[HgCatalog] ([CatalogId], [CatalogName], [TypeCode], [ParentCatalogId], [CatalogIdPath], [HasChild], [LevelNum], [OrderNo], [Remarks], [CreateTime], [Creator]) VALUES (10, N'供应商分类', N'supplier', 0, N'10/', 0, 0, 1, NULL, NULL, NULL)
INSERT [dbo].[HgCatalog] ([CatalogId], [CatalogName], [TypeCode], [ParentCatalogId], [CatalogIdPath], [HasChild], [LevelNum], [OrderNo], [Remarks], [CreateTime], [Creator]) VALUES (12, N'产品分类', N'product', 0, N'12/', 0, 0, 1, NULL, NULL, NULL)
INSERT [dbo].[HgCatalog] ([CatalogId], [CatalogName], [TypeCode], [ParentCatalogId], [CatalogIdPath], [HasChild], [LevelNum], [OrderNo], [Remarks], [CreateTime], [Creator]) VALUES (14, N'客户分类', N'customer', 0, N'14/', 0, 0, 1, NULL, NULL, NULL)
SET IDENTITY_INSERT [dbo].[HgCatalog] OFF
GO
--========产品管理
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_product', N'产品管理', 5, 1, NULL, NULL, NULL, NULL, 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_product_module', N'本地产品', 1, 2, NULL, 'erp_product', NULL, NULL, 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_product_manage', N'产品管理', 1, 3, NULL, 'erp_product_module', 'Product/Index', 'glyphicon glyphicon-gift', 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'catalog_product', N'产品目录', 2, 3, NULL, 'erp_product_module', 'Catalog/Product/Index', 'glyphicon glyphicon-list', 1)
--线上商品管理
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_online_product', N'线上商品', 2, 2, NULL, 'erp_product', NULL, NULL, 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_online_product_manage', N'线上商品管理', 1, 3, NULL, 'erp_online_product', 'OnlineProduct/Index', 'glyphicon glyphicon-gift', 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_match_product', N'匹配产品', 2, 3, NULL, 'erp_online_product', 'OnlineProduct/ViewMatch', 'glyphicon glyphicon-gift', 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_sku_mapping', N'SKU映射', 15, 3, NULL, 'erp_online_product', 'SKUMapping/Index', 'glyphicon glyphicon-gift', 1)
--========采购管理
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_pur', N'采购管理', 20, 1, NULL, NULL, NULL, NULL, 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_pur_manage', N'采购管理', 1, 2, NULL, N'erp_pur', NULL, NULL, 1)  
--采购计划
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_pur_plan', N'采购计划', 10, 3, NULL, N'erp_pur_manage', N'PurOrder/PurPlan', NULL, 1)
--采购订单  
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_pur_order', N'采购订单', 15, 3, NULL, N'erp_pur_manage', N'PurOrder/Index', N'glyphicon glyphicon-pushpin', 1)
--采购退货单
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_pur_return', N'采购退货单', 20, 3, NULL, N'erp_pur_manage', N'PurOrder/PurReturn', N'glyphicon glyphicon-link', 1)
--缺货订单
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_outofstock_order', N'缺货订单', 25, 3, NULL, N'erp_pur_manage', N'PurOrder/OutOfStockOrder', NULL, 1)
--缺货产品
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_outofstock_product', N'缺货产品', 30, 3, NULL, N'erp_pur_manage', N'PurOrder/OutOfStockProduct', NULL, 1)
--供应商管理
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_supplier', N'供应商管理', 2, 2, NULL, N'erp_pur', NULL, NULL, 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_supplier_manage', N'供应商管理', 1, 3, NULL, N'erp_supplier', N'Supplier/Index', N'glyphicon glyphicon-bed', 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'catalog_supplier', N'供应商目录', 2, 3, NULL, 'erp_supplier', 'Catalog/Supplier/Index', 'glyphicon glyphicon-list', 1)
--供应商报价
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_supplier_product', N'供货信息', 3, 3, NULL, 'erp_supplier', 'Supplier/ProductAndSuppliers', 'glyphicon glyphicon-compressed', 1)
--========销售管理
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_sale', N'订单管理', 10, 1, NULL, NULL, NULL, NULL, 1)
--订单管理
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_order', N'订单管理', 1, 2, NULL, N'erp_sale', NULL, NULL, 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_ordersync', N'同步订单', 1, 3, NULL, N'erp_order', N'Order/OrderSync', N'glyphicon glyphicon-refresh', 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_orderapprove', N'待处理', 5, 3, NULL, N'erp_order', N'Order/OrderApprove', N'glyphicon glyphicon-saved', 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_orderaccording', N'待配货', 10, 3, NULL, N'erp_order', N'Order/OrderAccording', N'glyphicon glyphicon-barcode', 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_orderprint', N'待发货', 15, 3, NULL, N'erp_order', N'Order/OrderPrint', N'glyphicon glyphicon-send', 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_ordervirtual', N'虚拟发货', 20, 3, NULL, N'erp_order', N'Order/OrderVirtual', N'glyphicon glyphicon-info-sign',1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_orderreceipt', N'已发货', 25, 3, NULL, N'erp_order', N'Order/OrderReceipt', N'glyphicon glyphicon-flag', 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_order_manage', N'订单搜索', 30, 3, NULL, N'erp_order', N'Order/Index', N'glyphicon glyphicon-search', 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_returnorder_manage', N'退单管理', 40, 3, NULL, N'erp_order', N'ReturnOrder/Index', N'glyphicon glyphicon-link', 1)
--物流跟踪
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_package_track', N'物流追踪', 50, 2, NULL, N'erp_sale', NULL, NULL, 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_package_track_search', N'批量查询', 50, 3, NULL, N'erp_package_track', N'PackageTrack/SyncTrack', NULL, 1)
--客户管理
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_customer', N'客户管理', 20, 2, NULL, N'erp_cs', NULL, NULL, 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_customer_manage', N'客户管理', 1, 3, NULL, N'erp_customer', N'Customer/Index', N'glyphicon glyphicon-earphone', 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'catalog_customer', N'客户目录', 2, 3, NULL, 'erp_customer', 'Catalog/Customer/Index', 'glyphicon glyphicon-list', 1)
--=======库存管理
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_manage', N'仓库管理', 25, 1, NULL, NULL, NULL, NULL, 1)
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_stock', N'库存管理', 1, 2, NULL, N'erp_manage', NULL, NULL, 1)
--入库管理
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_instore', N'入库管理', 1, 3, NULL, N'erp_stock', N'InStore/Index', N'glyphicon glyphicon-copy', 1)
--出库管理
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_outstore', N'出库管理', 2, 3, NULL, N'erp_stock', N'OutStore/Index', N'glyphicon glyphicon-paste', 1)
--库存盘点
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_checkinginventory', N'库存盘点', 3, 3, NULL, N'erp_stock', N'StockHandle/CheckingInventory', N'glyphicon glyphicon-usd', 1)
--库存调拨
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_transfer', N'库存调拨', 4, 3, NULL, N'erp_stock', N'StockHandle/TransferIndex', N'glyphicon glyphicon-retweet', 1)
--仓库管理
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_store_manage', N'仓库设置', 5, 3, NULL, 'erp_stock', 'Store/Index', 'glyphicon glyphicon-oil', 1)
--库存报表
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_report', N'库存报表', 2, 2, NULL, N'erp_manage', NULL, NULL, 1)
--库存查询
INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_stock_query', N'库存查询', 1, 3, NULL, N'erp_report', N'StockHandle/IndexStockQuery', N'glyphicon glyphicon-search', 1)
GO
--========产品管理
--产品管理
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_product', N'产品管理', NULL, NULL, NULL, 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_product_module', N'本地产品', NULL, NULL, N'erp_product', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_product_manage', N'产品管理', NULL, NULL, N'erp_product_module', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_product_edit', N'编辑产品信息', N'Product', N'Edit', N'erp_product_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_product_delete', N'删除产品信息', N'Product', N'Delete', N'erp_product_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_product_index', N'浏览产品列表', N'Product', N'Index', N'erp_product_manage', 2, NULL)
--线上商品管理
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_online_product', N'线上商品', NULL, NULL, N'erp_product', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_online_product_manage', N'线上商品管理', NULL, NULL, N'erp_online_product', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_online_product_index', N'浏览线上商品', N'OnlineProduct', N'Index', N'erp_online_product_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_online_product_reflash', N'刷新线上商品', N'OnlineProduct', N'ReflashProducts', N'erp_online_product_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_match_product', N'匹配产品', NULL, NULL, N'erp_online_product', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_match_product_index', N'浏览匹配产品', N'OnlineProduct', N'ViewMatch', N'erp_match_product', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_match_product_match', N'关联本地产品', N'OnlineProduct', N'MatchProduct', N'erp_match_product', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_match_product_local', N'转换为本地产品', N'OnlineProduct', N'TransfToLocal', N'erp_match_product', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_sku_mapping', N'SKU映射', NULL, NULL, N'erp_online_product', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_sku_mapping_index', N'查看SKU映射', N'SKUMapping', N'Index', N'erp_sku_mapping', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_sku_mapping_edit', N'编辑SKU映射', N'SKUMapping', N'Edit', N'erp_sku_mapping', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_sku_mapping_delete', N'删除SKU映射', N'SKUMapping', N'Delete', N'erp_sku_mapping', 2, NULL)
--产品目录
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'catalog_product', N'产品目录', NULL, NULL, N'erp_product_module', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_productcatalog_edit', N'编辑角色目录', N'ProductCatalog', N'Edit', N'catalog_product', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_productcatalog_delete', N'删除角色目录', N'ProductCatalog', N'Delete', N'catalog_product', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_productcatalog_index', N'浏览角色目录', N'ProductCatalog', N'Index', N'catalog_product', 2, NULL)
--========采购管理
--采购管理
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_pur', N'采购管理', NULL, NULL, NULL, 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_pur_manage', N'采购管理', NULL, NULL, N'erp_pur', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_pur_order', N'采购订单', NULL, NULL, N'erp_pur_manage', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purorder_index', N'订单列表浏览', N'PurOrder', N'Index', N'erp_pur_order', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purorder_confirm', N'订单审核', N'PurOrder', N'Confirm', N'erp_pur_order', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purorder_delete', N'删除订单信息', N'PurOrder', N'Delete', N'erp_pur_order', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purorder_edit', N'编辑订单信息', N'PurOrder', N'Edit', N'erp_pur_order', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_pur_return', N'采购退货单', NULL, NULL, N'erp_pur_manage', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purreturn_index', N'退货列表浏览', N'PurOrder', N'PurReturn', N'erp_pur_return', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purreturn_confirm', N'退货单审核', N'PurOrder', N'PurReturnConfirm', N'erp_pur_return', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purreturn_delete', N'删除退货单信息', N'PurOrder', N'PurReturnDelete', N'erp_pur_return', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purreturn_edit', N'编辑退货单信息', N'PurOrder', N'PurReturnEdit', N'erp_pur_return', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_pur_plan', N'采购计划', NULL, NULL, N'erp_pur_manage', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purplan_index', N'采购计划浏览', N'PurOrder', N'PurPlan', N'erp_pur_plan', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purplan_edit', N'编辑采购计划', N'PurOrder', N'PurPlanEdit', N'erp_pur_plan', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purplan_delete', N'删除采购计划', N'PurOrder', N'PurPlanDelete', N'erp_pur_plan', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_purplan_confirm', N'采购计划审核', N'PurOrder', N'PurPlanConfirm', N'erp_pur_plan', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_outofstock_order', N'缺货订单', NULL, NULL, N'erp_pur_manage', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_outofstockorder_index', N'缺货订单浏览', N'PurOrder', N'OutOfStockOrder', N'erp_outofstock_order', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_outofstock_product', N'缺货产品', NULL, NULL, N'erp_pur_manage', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_outofstockproduct_index', N'缺货产品浏览', N'PurOrder', N'OutOfStockProduct', N'erp_outofstock_product', 2, NULL)
--供应商管理
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_supplier', N'供应商管理', NULL, NULL, N'erp_pur', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_supplier_manage', N'供应商管理', NULL, NULL, N'erp_supplier', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_supplier_delete', N'删除供应商信息', N'Supplier', N'Delete', N'erp_supplier_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_supplier_edit', N'编辑供应商信息', N'Supplier', N'Edit', N'erp_supplier_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_supplier_index', N'浏览供应商信息', N'Supplier', N'Index', N'erp_supplier_manage', 2, NULL)
--产品供应商
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_supplier_product', N'供货信息', NULL, NULL, N'erp_supplier', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_supplierproduct_delete', N'删除供应商报价', N'Supplier', N'SupplierProductDelete', N'erp_supplier_product', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_supplierproduct_edit', N'编辑供应商报价', N'Supplier', N'SupplierProductEdit', N'erp_supplier_product', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_supplierproduct_index', N'浏览供应商报价', N'Supplier', N'SupplierProduct', N'erp_supplier_product', 2, NULL)
--供应商目录
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'catalog_supplier', N'供应商目录', NULL, NULL, N'erp_supplier', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_suppliercatalog_edit', N'编辑供应商目录', N'SupplierCatalog', N'Edit', N'catalog_supplier', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_suppliercatalog_delete', N'删除供应商目录', N'SupplierCatalog', N'Delete', N'catalog_supplier', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_suppliercatalog_index', N'浏览供应商目录', N'SupplierCatalog', N'Index', N'catalog_supplier', 2, NULL)
--========销售管理  
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_sale', N'订单管理', NULL, NULL, NULL, 1, NULL)
--订单管理
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order', N'订单管理', NULL, NULL, N'erp_sale', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_according', N'订单列表浏览', N'Order', N'OrderAccording', N'erp_orderaccording', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_actualdeliver', N'发货', N'Order', N'ActualDeliver', N'erp_orderprint', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_approve', N'审核订单', N'Order', N'ApproveOrder', N'erp_orderapprove', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_delete', N'订单作废', N'Order', N'Delete', N'erp_order_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_details', N'订单详情', N'Order', N'OrderDetails', N'erp_order_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_edit', N'订单编辑', N'Order', N'Edit', N'erp_order_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_index', N'订单列表浏览', N'Order', N'Index', N'erp_order_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_insertmsg', N'回复留言信息', N'Order', N'InsertMessage', N'erp_order_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_manage', N'订单搜索', NULL, NULL, N'erp_order', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_message', N'查看留言信息', N'Order', N'MessageList', N'erp_order_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_printlabel', N'打印标签', N'Order', N'PrintLabel', N'erp_orderprint', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_printpicking', N'打印拣货单', N'Order', N'PrintPicking', N'erp_orderprint', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_sync', N'同步订单', N'Order', N'LoadOrder', N'erp_ordersync', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_virtualdeliver', N'虚拟发货', N'Order', N'VirtualDeliver', N'erp_orderprint', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_orderaccording', N'待配货', NULL, NULL, N'erp_order', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_orderaccording_index', N'配货', N'Order', N'AccordingOrder', N'erp_orderaccording', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_orderapprove', N'待处理', NULL, NULL, N'erp_order', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_orderapprove_index', N'订单列表浏览', N'Order', N'OrderApprove', N'erp_orderapprove', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_orderprint', N'待发货', NULL, NULL, N'erp_order', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_orderprint_index', N'订单列表浏览', N'Order', N'OrderPrint', N'erp_orderprint', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_ordersync', N'同步订单', NULL, NULL, N'erp_order', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_ordersync_index', N'同步订单浏览', N'Order', N'OrderSync', N'erp_ordersync', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_orderreceipt', N'已发货', NULL, NULL, N'erp_order', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_orderreceipt_index', N'订单列表浏览', N'Order', N'OrderReceipt', N'erp_orderreceipt', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_returnorder_manage', N'退单管理', NULL, NULL, N'erp_order', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_returnorder_delete', N'删除订单', N'ReturnOrder', N'Delete', N'erp_returnorder_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_returnorder_edit', N'退单编辑', N'ReturnOrder', N'Edit', N'erp_returnorder_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_returnorder_index', N'退单列表浏览', N'ReturnOrder', N'Index', N'erp_returnorder_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_returnorder_details', N'退单详情', N'ReturnOrder', N'ReturnOrderDetails', N'erp_returnorder_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_returnorder_outstore', N'退单入库', N'ReturnOrder', N'ReturnOrderInStore', N'erp_returnorder_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_sitemessage', N'站内信及留言', NULL, NULL, N'erp_cs_aliexpress', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_sitemessage_index', N'站内信列表浏览', N'OrderMessage', N'Index', N'erp_order_sitemessage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_sitemessage_insert', N'发表站内信', N'OrderMessage', N'InsertMessage', N'erp_order_sitemessage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_message_index', N'订单留言列表浏览', N'OrderMessage', N'OrderMes', N'erp_order_sitemessage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_ordervirtual', N'虚拟发货', NULL, NULL, N'erp_order', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_ordervirtual_index', N'虚拟订单列表浏览', N'Order', N'OrderVirtual', N'erp_ordervirtual', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_issue', N'退款及纠纷', NULL, NULL, N'erp_cs_aliexpress', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_order_issue_index', N'查看退款及纠纷订单', N'Order', N'OrderIssue', N'erp_order_issue', 2, NULL)
--物流跟踪
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_package_track', N'物流追踪', NULL, NULL, N'erp_sale', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_package_track_search', N'批量查询', NULL, NULL, N'erp_package_track', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_package_track_sync', N'批量同步物流信息', N'PackageTrack', N'SyncTrack', N'erp_package_track_search', 2, NULL)
--客户管理
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_customer', N'客户管理', NULL, NULL, N'erp_sale', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_customer_manage', N'客户管理', NULL, NULL, N'erp_customer', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_customer_delete', N'删除客户信息', N'Customer', N'Delete', N'erp_customer_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_customer_edit', N'编辑客户信息', N'Customer', N'Edit', N'erp_customer_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_customer_index', N'浏览客户信息', N'Customer', N'Index', N'erp_customer_manage', 2, NULL)
--客户目录
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'catalog_customer', N'客户目录', NULL, NULL, N'erp_customer', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_customercatalog_edit', N'编辑客户目录', N'CustomerCatalog', N'Edit', N'catalog_customer', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_customercatalog_delete', N'删除客户目录', N'CustomerCatalog', N'Delete', N'catalog_customer', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_customercatalog_index', N'浏览客户目录', N'CustomerCatalog', N'Index', N'catalog_customer', 2, NULL)
GO
--========仓库管理
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_manage', N'仓库管理', NULL, NULL, NULL, 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_stock', N'库存管理', NULL, NULL, N'erp_manage', 1, NULL)
--入库管理
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_instore', N'入库管理', NULL, NULL, N'erp_stock', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_instore_confirm', N'审核入库', N'InStore', N'Confirm', N'erp_instore', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_instore_delete', N'删除入库信息', N'InStore', N'Delete', N'erp_instore', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_instore_edit', N'编辑入库信息', N'InStore', N'Edit', N'erp_instore', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_instore_index', N'浏览入库列表', N'InStore', N'Index', N'erp_instore', 2, NULL)
--出库管理
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_outstore', N'出库管理', NULL, NULL, N'erp_stock', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_outstore_confirm', N'审核出库', N'OutStore', N'Confirm', N'erp_outstore', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_outstore_delete', N'删除出库信息', N'OutStore', N'Delete', N'erp_outstore', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_outstore_edit', N'编辑出库信息', N'OutStore', N'Edit', N'erp_outstore', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_outstore_index', N'浏览出库列表', N'OutStore', N'Index', N'erp_outstore', 2, NULL)
--库存盘点
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_checkinginventory', N'库存盘点', NULL, NULL, N'erp_stock', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_checkinginventory_index', N'浏览库存盘点', N'StockHandle', N'CheckingInventory', N'erp_checkinginventory', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_checkinghistory_index', N'盘点历史', N'StockHandle', N'CheckingInventoryHistory', N'erp_checkinginventory', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_checkadd_edit', N'盘盈', N'StockHandle', N'ChckAddEdit', N'erp_CheckingAdd', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_checksub_edit', N'盘亏', N'StockHandle', N'CheckSubEdit', N'erp_CheckingSub', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_checkingadd_index', N'浏览库存盘盈', N'StockHandle', N'CheckingAdd', N'erp_CheckingAdd', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_checkingsub_index', N'浏览库存盘亏', N'StockHandle', N'CheckingSub', N'erp_CheckingSub', 2, NULL)
--库存调拨
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_transfer', N'库存调拨', NULL, NULL, N'erp_stock', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_transfer_confirm', N'审核调拨', N'StockHandle', N'TransferConfirm', N'erp_transfer', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_transfer_delete', N'删除调拨信息', N'StockHandle', N'TransferDelete', N'erp_transfer', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_transfer_edit', N'编辑调拨信息', N'StockHandle', N'TransferEdit', N'erp_transfer', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_transfer_index', N'浏览调拨列表', N'StockHandle', N'TransferIndex', N'erp_transfer', 2, NULL)
--仓库管理
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_store_manage', N'仓库设置', NULL, NULL, N'erp_stock', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_store_edit', N'编辑仓库', N'Store', N'Edit', N'erp_store_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_store_delete', N'删除仓库', N'Store', N'Delete', N'erp_store_manage', 2, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_store_index', N'仓库设置', N'Store', N'Index', N'erp_store_manage', 2, NULL)
--库存报表
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_report', N'库存报表', NULL, NULL, N'erp_manage', 1, NULL)
--库存查询
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_stock_query', N'库存查询', NULL, NULL, N'erp_report', 1, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_stock_query_index', N'库存查询', N'StockHandle', N'IndexStockQuery', N'erp_stock_query', 2, NULL)
GO
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpCheck', N'CheckNo', N'盘点历史表', N'盘点单号', N'CH', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpCheckAdd', N'CheckAddNo', N'盘盈表', N'盘盈单号', N'CA', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpCheckSub', N'CheckSubNo', N'盘亏表', N'盘亏单号', N'CS', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpCustomer', N'CustomerNo', N'客户表', N'客户编号', N'CU', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpInStore', N'InStoreNo', N'入库表', N'入库编号', N'IS', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpOrder', N'OrderNo', N'订单表', N'订单单号', N'O', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpOutStore', N'OutStoreNo', N'出库表', N'出库编号', N'OS', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpProduct', N'ProductCode', N'产品表', N'产品编号', N'P', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpPurOrder', N'PurOrderNo', N'订单采购表', N'采购单号', N'PO', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpPurReturnOrder', N'PurReturnOrderNo', N'采购退货表', N'采购退货单号', N'PR', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpReturnOrder', N'ReturnOrderNo', N'退单表', N'退单号', N'BO', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpSupplier', N'SupplierNo', N'供应商表', N'供应商编号', N'SU', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpTransfer', N'TransferNo', N'库存调拨表', N'调拨单号', N'DB', N'-', N'yyyyMMdd', 1, 4)
INSERT [dbo].[HgColumnCode] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [Prefixion], [PrefixionConnect], [DateFormat], [Identify], [IdentityBit]) VALUES (N'ErpStore', N'StoreNo', N'仓库表', N'仓库编号', N'SO', N'-', N'yyyyMMdd', 1, 4)
GO
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpApiUser', N'UserFrom', N'amazon', N'账号设置表', N'用户来源', N'亚马逊', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpApiUser', N'UserFrom', N'ebay', N'账号设置表', N'用户来源', N'Ebay', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Honor', N'honor_1', N'客户表', N'信誉度', N'很好', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Honor', N'honor_2', N'客户表', N'信誉度', N'一般', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Honor', N'honor_3', N'客户表', N'信誉度', N'不好', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Importance', N'imp_1', N'客户表', N'重要程度', N'非常重要', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Importance', N'imp_2', N'客户表', N'重要程度', N'重要', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Importance', N'imp_3', N'客户表', N'重要程度', N'一般', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Importance', N'imp_4', N'客户表', N'重要程度', N'较弱', NULL, 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_1', N'客户表', N'行业', N'信息传输、计算机服务和软件业务', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_1_1', N'客户表', N'行业', N'软件业', N'industry_1', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_1_2', N'客户表', N'行业', N'计算机服务业', N'industry_1', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_1_3', N'客户表', N'行业', N'电信和其他信息传输服务业', N'industry_1', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_10', N'客户表', N'行业', N'水利、环境和公共设施管理业', NULL, 1, 10)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_10_1', N'客户表', N'行业', N'公共设施管理业', N'industry_10', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_10_2', N'客户表', N'行业', N'环境管理业', N'industry_10', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_10_3', N'客户表', N'行业', N'水利管理业', N'industry_10', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_11', N'客户表', N'行业', N'农、林、牧、渔业', NULL, 1, 11)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_11_1', N'客户表', N'行业', N'农业', N'industry_11', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_11_2', N'客户表', N'行业', N'林业', N'industry_11', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_11_3', N'客户表', N'行业', N'畜牧业', N'industry_11', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_11_4', N'客户表', N'行业', N'渔业', N'industry_11', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_11_5', N'客户表', N'行业', N'农、林、牧、渔服务业', N'industry_11', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_12', N'客户表', N'行业', N'制造业', NULL, 1, 12)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_1', N'客户表', N'行业', N'农副食品加工业', N'industry_12', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_10', N'客户表', N'行业', N'造纸及纸制品业', N'industry_12', 1, 10)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_11', N'客户表', N'行业', N'印刷业和记录媒介的复制', N'industry_12', 1, 11)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_12', N'客户表', N'行业', N'文教体育用品制造业', N'industry_12', 1, 12)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_13', N'客户表', N'行业', N'石油加工、炼焦及核燃料加工业', N'industry_12', 1, 13)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_14', N'客户表', N'行业', N'化学原料及化学制品制造业', N'industry_12', 1, 14)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_15', N'客户表', N'行业', N'医药制造业', N'industry_12', 1, 15)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_16', N'客户表', N'行业', N'化学纤维制造业', N'industry_12', 1, 16)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_17', N'客户表', N'行业', N'橡胶制品业', N'industry_12', 1, 17)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_18', N'客户表', N'行业', N'塑料制品业', N'industry_12', 1, 18)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_19', N'客户表', N'行业', N'非金属矿物制品业', N'industry_12', 1, 19)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_2', N'客户表', N'行业', N'食品制造业', N'industry_12', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_20', N'客户表', N'行业', N'黑色金属冶炼及压延加工业', N'industry_12', 1, 20)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_21', N'客户表', N'行业', N'有色金属冶炼及压延加工业', N'industry_12', 1, 21)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_22', N'客户表', N'行业', N'金属制品业', N'industry_12', 1, 22)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_23', N'客户表', N'行业', N'通用设备制造业', N'industry_12', 1, 23)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_24', N'客户表', N'行业', N'专用设备制造业', N'industry_12', 1, 24)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_25', N'客户表', N'行业', N'交通运输设备制造业', N'industry_12', 1, 25)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_26', N'客户表', N'行业', N'电气机械及器材制造业', N'industry_12', 1, 26)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_27', N'客户表', N'行业', N'通信设备、计算机及其他电子设备制造业', N'industry_12', 1, 27)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_28', N'客户表', N'行业', N'仪器仪表及文化、办公用机械制造业', N'industry_12', 1, 28)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_29', N'客户表', N'行业', N'工艺品及其他制造业', N'industry_12', 1, 29)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_3', N'客户表', N'行业', N'饮料制造业', N'industry_12', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_30', N'客户表', N'行业', N'废弃资源和废旧材料回收加工业', N'industry_12', 1, 30)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_4', N'客户表', N'行业', N'烟草制品业', N'industry_12', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_5', N'客户表', N'行业', N'纺织业', N'industry_12', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_6', N'客户表', N'行业', N'纺织服装、鞋、帽制造业', N'industry_12', 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_7', N'客户表', N'行业', N'皮革、毛皮、羽毛(绒)及其制品业', N'industry_12', 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_8', N'客户表', N'行业', N'木材加工及木、竹、藤、棕、草制品业', N'industry_12', 1, 8)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_12_9', N'客户表', N'行业', N'家具制造业', N'industry_12', 1, 9)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_13', N'客户表', N'行业', N'机械/电气行业', NULL, 1, 13)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_13_1', N'客户表', N'行业', N'机械/电气行业', N'industry_13', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_14', N'客户表', N'行业', N'电力、燃气及水的生产和供应业', NULL, 1, 14)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_14_1', N'客户表', N'行业', N'电力、燃气及水的生产和供应业', N'industry_14', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_15', N'客户表', N'行业', N'卫生、社会保障和社会福利业', NULL, 1, 15)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_15_1', N'客户表', N'行业', N'卫生', N'industry_15', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_15_2', N'客户表', N'行业', N'社会保障业', N'industry_15', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_15_3', N'客户表', N'行业', N'社会福利业', N'industry_15', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_16', N'客户表', N'行业', N'教育', NULL, 1, 16)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_16_1', N'客户表', N'行业', N'教育', N'industry_16', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_17', N'客户表', N'行业', N'房地产业', NULL, 1, 17)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_17_1', N'客户表', N'行业', N'房地产业', N'industry_17', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_18', N'客户表', N'行业', N'租赁和商务服务业', NULL, 1, 18)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_18_1', N'客户表', N'行业', N'租赁', N'industry_18', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_18_2', N'客户表', N'行业', N'商务服务业', N'industry_18', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_19', N'客户表', N'行业', N'公共管理和社会组织', NULL, 1, 19)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_19_1', N'客户表', N'行业', N'中国共产党机关', N'industry_19', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_19_2', N'客户表', N'行业', N'国家机构', N'industry_19', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_19_3', N'客户表', N'行业', N'人民政协和民主党派', N'industry_19', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_19_4', N'客户表', N'行业', N'群众团体、社会团体和宗教组织', N'industry_19', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_19_5', N'客户表', N'行业', N'基层群众自治组织', N'industry_19', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_2', N'客户表', N'行业', N'金融业', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_2_1', N'客户表', N'行业', N'银行业', N'industry_2', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_2_2', N'客户表', N'行业', N'证券业', N'industry_2', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_2_3', N'客户表', N'行业', N'保险业', N'industry_2', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_2_4', N'客户表', N'行业', N'其他金融活动', N'industry_2', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_20', N'客户表', N'行业', N'居民服务和其他服务业', NULL, 1, 20)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_20_1', N'客户表', N'行业', N'居民服务', N'industry_20', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_20_2', N'客户表', N'行业', N'其他服务业', N'industry_20', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_21', N'客户表', N'行业', N'国际组织', NULL, 1, 21)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_21_1', N'客户表', N'行业', N'国际组织', N'industry_21', 1, 21)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_3', N'客户表', N'行业', N'批发和零售业', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_3_1', N'客户表', N'行业', N'批发业', N'industry_3', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_3_2', N'客户表', N'行业', N'零售业', N'industry_3', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_4', N'客户表', N'行业', N'文化、体育和娱乐业', NULL, 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_4_1', N'客户表', N'行业', N'文化、新闻出版业', N'industry_4', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_4_2', N'客户表', N'行业', N'文化、文化艺术业', N'industry_4', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_4_3', N'客户表', N'行业', N'文化、广播、电视、电影和音像业', N'industry_4', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_4_4', N'客户表', N'行业', N'体育', N'industry_4', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_4_5', N'客户表', N'行业', N'娱乐业', N'industry_4', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_5', N'客户表', N'行业', N'建筑业', NULL, 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_5_1', N'客户表', N'行业', N'房屋和土木工程建筑业', N'industry_5', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_5_2', N'客户表', N'行业', N'建筑安装业', N'industry_5', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_5_3', N'客户表', N'行业', N'建筑装饰业', N'industry_5', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_5_4', N'客户表', N'行业', N'其他建筑业', N'industry_5', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_6', N'客户表', N'行业', N'科学研究、技术服务和地质勘查业', NULL, 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_6_1', N'客户表', N'行业', N'科技交流和推广服务业', N'industry_6', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_6_2', N'客户表', N'行业', N'专业技术服务业', N'industry_6', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_6_3', N'客户表', N'行业', N'地质勘查业', N'industry_6', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_6_4', N'客户表', N'行业', N'研究与实验发展', N'industry_6', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_7', N'客户表', N'行业', N'住宿和餐饮业', NULL, 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_7_1', N'客户表', N'行业', N'餐饮业', N'industry_7', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_7_2', N'客户表', N'行业', N'住宿业', N'industry_7', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_8', N'客户表', N'行业', N'交通运输、仓储和邮政业', NULL, 1, 8)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_8_1', N'客户表', N'行业', N'邮政业', N'industry_8', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_8_2', N'客户表', N'行业', N'航空运输业', N'industry_8', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_8_3', N'客户表', N'行业', N'铁路运输业', N'industry_8', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_8_4', N'客户表', N'行业', N'道路运输业', N'industry_8', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_8_5', N'客户表', N'行业', N'城市公共交通业', N'industry_8', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_8_6', N'客户表', N'行业', N'水上运输业', N'industry_8', 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_8_7', N'客户表', N'行业', N'管道运输业', N'industry_8', 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_8_8', N'客户表', N'行业', N'装卸搬运和其他运输服务业', N'industry_8', 1, 8)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_8_9', N'客户表', N'行业', N'仓储业', N'industry_8', 1, 9)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'IndustryIParent', N'industry_9', N'客户表', N'行业', N'采矿业', NULL, 1, 9)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_9_1', N'客户表', N'行业', N'石油和天然气开采业', N'industry_9', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_9_2', N'客户表', N'行业', N'煤炭开采和洗选业', N'industry_9', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_9_3', N'客户表', N'行业', N'石油和天然气开采业', N'industry_9', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_9_4', N'客户表', N'行业', N'黑色金属矿采选业', N'industry_9', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_9_5', N'客户表', N'行业', N'有色金属矿采选业', N'industry_9', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_9_6', N'客户表', N'行业', N'非金属矿采选业', N'industry_9', 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'Industry', N'industry_9_7', N'客户表', N'行业', N'其他采矿业', N'industry_9', 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerSource', N'source_1', N'客户表', N'客户来源', N'自己关系', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerSource', N'source_2', N'客户表', N'客户来源', N'网络宣传', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerSource', N'source_3', N'客户表', N'客户来源', N'业务开发', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerSource', N'source_4', N'客户表', N'客户来源', N'朋友介绍', NULL, 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerSource', N'source_5', N'客户表', N'客户来源', N'公司网站', NULL, 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerSource', N'source_6', N'客户表', N'客户来源', N'客户介绍', NULL, 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerType', N'type_1', N'客户表', N'客户类型', N'一般客户', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerType', N'type_10', N'客户表', N'客户类型', N'政府单位', NULL, 1, 10)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerType', N'type_11', N'客户表', N'客户类型', N'个人客户', NULL, 1, 11)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerType', N'type_2', N'客户表', N'客户类型', N'大客户', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerType', N'type_3', N'客户表', N'客户类型', N'重点客户', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerType', N'type_4', N'客户表', N'客户类型', N'VIP客户', NULL, 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerType', N'type_5', N'客户表', N'客户类型', N'一般意向', NULL, 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerType', N'type_6', N'客户表', N'客户类型', N'重点意向', NULL, 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerType', N'type_7', N'客户表', N'客户类型', N'独家区域代理', NULL, 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerType', N'type_8', N'客户表', N'客户类型', N'地区核心代理', NULL, 1, 8)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerType', N'type_9', N'客户表', N'客户类型', N'增值服务代理商', NULL, 1, 9)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpInStore', N'InStoreType', N'allocation_in_store', N'入库表', N'入库类型', N'调拨入库', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpInStore', N'InStoreType', N'check_add_in_store', N'入库表', N'入库类型', N'盘盈入库', NULL, 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpInStore', N'InStoreType', N'other_in_store', N'入库表', N'入库类型', N'其他入库', NULL, 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpInStore', N'InStoreType', N'pur_in_store', N'入库表', N'入库类型', N'采购入库', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpInStore', N'InStoreType', N'sale_return_in_store', N'入库表', N'入库类型', N'销售退货入库', NULL, 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpOutStore', N'OutStoreType', N'allocation_out_store', N'出库表', N'出库类型', N'调拨出库', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpOutStore', N'OutStoreType', N'check_sub_in_store', N'出库表', N'出库类型', N'盘亏出库', NULL, 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpOutStore', N'OutStoreType', N'other_out_store', N'出库表', N'出库类型', N'其他出库', NULL, 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpOutStore', N'OutStoreType', N'pur_out_store', N'出库表', N'出库类型', N'采购退货出库', NULL, 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpOutStore', N'OutStoreType', N'sale_out_store', N'出库表', N'出库类型', N'销售出库', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpOutStore', N'OutStoreType', N'scrap_out_store', N'出库表', N'出库类型', N'报废出库', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpProduct', N'ProductType', N'normal', N'产品表', N'产品类型', N'普通产品', NULL, 0, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpProduct', N'ProductType', N'change', N'产品表', N'产品类型', N'变参产品', NULL, 0, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpProduct', N'ProductType', N'combined ', N'产品表', N'产品类型', N'组合产品', NULL, 0, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpProduct', N'ProductUnit', N'打', N'产品表', N'标准单位', N'打', NULL, 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpProduct', N'ProductUnit', N'个', N'产品表', N'标准单位', N'个', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpProduct', N'ProductUnit', N'瓶', N'产品表', N'标准单位', N'瓶', NULL, 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpProduct', N'ProductUnit', N'台', N'产品表', N'标准单位', N'台', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpProduct', N'ProductUnit', N'套', N'产品表', N'标准单位', N'套', NULL, 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpProduct', N'ProductUnit', N'张', N'产品表', N'标准单位', N'张', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpProduct', N'ProductUnit', N'支', N'产品表', N'标准单位', N'支', NULL, 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Honor', N'honor_1', N'供应商表', N'信誉度', N'很好', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Honor', N'honor_2', N'供应商表', N'信誉度', N'一般', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Honor', N'honor_3', N'供应商表', N'信誉度', N'不好', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Importance', N'imp_1', N'供应商表', N'重要程度', N'非常重要', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Importance', N'imp_2', N'供应商表', N'重要程度', N'重要', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Importance', N'imp_3', N'供应商表', N'重要程度', N'一般', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Importance', N'imp_4', N'供应商表', N'重要程度', N'较弱', NULL, 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_1', N'供应商表', N'行业', N'信息传输、计算机服务和软件业务', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_1_1', N'供应商表', N'行业', N'软件业', N'industry_1', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_1_2', N'供应商表', N'行业', N'计算机服务业', N'industry_1', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_1_3', N'供应商表', N'行业', N'电信和其他信息传输服务业', N'industry_1', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_10', N'供应商表', N'行业', N'水利、环境和公共设施管理业', NULL, 1, 10)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_10_1', N'供应商表', N'行业', N'公共设施管理业', N'industry_10', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_10_2', N'供应商表', N'行业', N'环境管理业', N'industry_10', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_10_3', N'供应商表', N'行业', N'水利管理业', N'industry_10', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_11', N'供应商表', N'行业', N'农、林、牧、渔业', NULL, 1, 11)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_11_1', N'供应商表', N'行业', N'农业', N'industry_11', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_11_2', N'供应商表', N'行业', N'林业', N'industry_11', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_11_3', N'供应商表', N'行业', N'畜牧业', N'industry_11', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_11_4', N'供应商表', N'行业', N'渔业', N'industry_11', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_11_5', N'供应商表', N'行业', N'农、林、牧、渔服务业', N'industry_11', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_12', N'供应商表', N'行业', N'制造业', NULL, 1, 12)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_1', N'供应商表', N'行业', N'农副食品加工业', N'industry_12', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_10', N'供应商表', N'行业', N'造纸及纸制品业', N'industry_12', 1, 10)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_11', N'供应商表', N'行业', N'印刷业和记录媒介的复制', N'industry_12', 1, 11)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_12', N'供应商表', N'行业', N'文教体育用品制造业', N'industry_12', 1, 12)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_13', N'供应商表', N'行业', N'石油加工、炼焦及核燃料加工业', N'industry_12', 1, 13)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_14', N'供应商表', N'行业', N'化学原料及化学制品制造业', N'industry_12', 1, 14)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_15', N'供应商表', N'行业', N'医药制造业', N'industry_12', 1, 15)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_16', N'供应商表', N'行业', N'化学纤维制造业', N'industry_12', 1, 16)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_17', N'供应商表', N'行业', N'橡胶制品业', N'industry_12', 1, 17)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_18', N'供应商表', N'行业', N'塑料制品业', N'industry_12', 1, 18)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_19', N'供应商表', N'行业', N'非金属矿物制品业', N'industry_12', 1, 19)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_2', N'供应商表', N'行业', N'食品制造业', N'industry_12', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_20', N'供应商表', N'行业', N'黑色金属冶炼及压延加工业', N'industry_12', 1, 20)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_21', N'供应商表', N'行业', N'有色金属冶炼及压延加工业', N'industry_12', 1, 21)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_22', N'供应商表', N'行业', N'金属制品业', N'industry_12', 1, 22)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_23', N'供应商表', N'行业', N'通用设备制造业', N'industry_12', 1, 23)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_24', N'供应商表', N'行业', N'专用设备制造业', N'industry_12', 1, 24)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_25', N'供应商表', N'行业', N'交通运输设备制造业', N'industry_12', 1, 25)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_26', N'供应商表', N'行业', N'电气机械及器材制造业', N'industry_12', 1, 26)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_27', N'供应商表', N'行业', N'通信设备、计算机及其他电子设备制造业', N'industry_12', 1, 27)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_28', N'供应商表', N'行业', N'仪器仪表及文化、办公用机械制造业', N'industry_12', 1, 28)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_29', N'供应商表', N'行业', N'工艺品及其他制造业', N'industry_12', 1, 29)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_3', N'供应商表', N'行业', N'饮料制造业', N'industry_12', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_30', N'供应商表', N'行业', N'废弃资源和废旧材料回收加工业', N'industry_12', 1, 30)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_4', N'供应商表', N'行业', N'烟草制品业', N'industry_12', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_5', N'供应商表', N'行业', N'纺织业', N'industry_12', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_6', N'供应商表', N'行业', N'纺织服装、鞋、帽制造业', N'industry_12', 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_7', N'供应商表', N'行业', N'皮革、毛皮、羽毛(绒)及其制品业', N'industry_12', 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_8', N'供应商表', N'行业', N'木材加工及木、竹、藤、棕、草制品业', N'industry_12', 1, 8)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_12_9', N'供应商表', N'行业', N'家具制造业', N'industry_12', 1, 9)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_13', N'供应商表', N'行业', N'机械/电气行业', NULL, 1, 13)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_13_1', N'供应商表', N'行业', N'机械/电气行业', N'industry_13', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_14', N'供应商表', N'行业', N'电力、燃气及水的生产和供应业', NULL, 1, 14)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_14_1', N'供应商表', N'行业', N'电力、燃气及水的生产和供应业', N'industry_14', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_15', N'供应商表', N'行业', N'卫生、社会保障和社会福利业', NULL, 1, 15)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_15_1', N'供应商表', N'行业', N'卫生', N'industry_15', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_15_2', N'供应商表', N'行业', N'社会保障业', N'industry_15', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_15_3', N'供应商表', N'行业', N'社会福利业', N'industry_15', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_16', N'供应商表', N'行业', N'教育', NULL, 1, 16)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_16_1', N'供应商表', N'行业', N'教育', N'industry_16', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_17', N'供应商表', N'行业', N'房地产业', NULL, 1, 17)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_17_1', N'供应商表', N'行业', N'房地产业', N'industry_17', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_18', N'供应商表', N'行业', N'租赁和商务服务业', NULL, 1, 18)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_18_1', N'供应商表', N'行业', N'租赁', N'industry_18', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_18_2', N'供应商表', N'行业', N'商务服务业', N'industry_18', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_19', N'供应商表', N'行业', N'公共管理和社会组织', NULL, 1, 19)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_19_1', N'供应商表', N'行业', N'中国共产党机关', N'industry_19', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_19_2', N'供应商表', N'行业', N'国家机构', N'industry_19', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_19_3', N'供应商表', N'行业', N'人民政协和民主党派', N'industry_19', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_19_4', N'供应商表', N'行业', N'群众团体、社会团体和宗教组织', N'industry_19', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_19_5', N'供应商表', N'行业', N'基层群众自治组织', N'industry_19', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_2', N'供应商表', N'行业', N'金融业', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_2_1', N'供应商表', N'行业', N'银行业', N'industry_2', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_2_2', N'供应商表', N'行业', N'证券业', N'industry_2', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_2_3', N'供应商表', N'行业', N'保险业', N'industry_2', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_2_4', N'供应商表', N'行业', N'其他金融活动', N'industry_2', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_20', N'供应商表', N'行业', N'居民服务和其他服务业', NULL, 1, 20)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_20_1', N'供应商表', N'行业', N'居民服务', N'industry_20', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_20_2', N'供应商表', N'行业', N'其他服务业', N'industry_20', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_21', N'供应商表', N'行业', N'国际组织', NULL, 1, 21)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_21_1', N'供应商表', N'行业', N'国际组织', N'industry_21', 1, 21)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_3', N'供应商表', N'行业', N'批发和零售业', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_3_1', N'供应商表', N'行业', N'批发业', N'industry_3', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_3_2', N'供应商表', N'行业', N'零售业', N'industry_3', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_4', N'供应商表', N'行业', N'文化、体育和娱乐业', NULL, 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_4_1', N'供应商表', N'行业', N'文化、新闻出版业', N'industry_4', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_4_2', N'供应商表', N'行业', N'文化、文化艺术业', N'industry_4', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_4_3', N'供应商表', N'行业', N'文化、广播、电视、电影和音像业', N'industry_4', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_4_4', N'供应商表', N'行业', N'体育', N'industry_4', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_4_5', N'供应商表', N'行业', N'娱乐业', N'industry_4', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_5', N'供应商表', N'行业', N'建筑业', NULL, 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_5_1', N'供应商表', N'行业', N'房屋和土木工程建筑业', N'industry_5', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_5_2', N'供应商表', N'行业', N'建筑安装业', N'industry_5', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_5_3', N'供应商表', N'行业', N'建筑装饰业', N'industry_5', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_5_4', N'供应商表', N'行业', N'其他建筑业', N'industry_5', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_6', N'供应商表', N'行业', N'科学研究、技术服务和地质勘查业', NULL, 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_6_1', N'供应商表', N'行业', N'科技交流和推广服务业', N'industry_6', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_6_2', N'供应商表', N'行业', N'专业技术服务业', N'industry_6', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_6_3', N'供应商表', N'行业', N'地质勘查业', N'industry_6', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_6_4', N'供应商表', N'行业', N'研究与实验发展', N'industry_6', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_7', N'供应商表', N'行业', N'住宿和餐饮业', NULL, 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_7_1', N'供应商表', N'行业', N'餐饮业', N'industry_7', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_7_2', N'供应商表', N'行业', N'住宿业', N'industry_7', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_8', N'供应商表', N'行业', N'交通运输、仓储和邮政业', NULL, 1, 8)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_8_1', N'供应商表', N'行业', N'邮政业', N'industry_8', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_8_2', N'供应商表', N'行业', N'航空运输业', N'industry_8', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_8_3', N'供应商表', N'行业', N'铁路运输业', N'industry_8', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_8_4', N'供应商表', N'行业', N'道路运输业', N'industry_8', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_8_5', N'供应商表', N'行业', N'城市公共交通业', N'industry_8', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_8_6', N'供应商表', N'行业', N'水上运输业', N'industry_8', 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_8_7', N'供应商表', N'行业', N'管道运输业', N'industry_8', 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_8_8', N'供应商表', N'行业', N'装卸搬运和其他运输服务业', N'industry_8', 1, 8)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_8_9', N'供应商表', N'行业', N'仓储业', N'industry_8', 1, 9)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'IndustryIParent', N'industry_9', N'供应商表', N'行业', N'采矿业', NULL, 1, 9)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_9_1', N'供应商表', N'行业', N'石油和天然气开采业', N'industry_9', 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_9_2', N'供应商表', N'行业', N'煤炭开采和洗选业', N'industry_9', 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_9_3', N'供应商表', N'行业', N'石油和天然气开采业', N'industry_9', 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_9_4', N'供应商表', N'行业', N'黑色金属矿采选业', N'industry_9', 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_9_5', N'供应商表', N'行业', N'有色金属矿采选业', N'industry_9', 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_9_6', N'供应商表', N'行业', N'非金属矿采选业', N'industry_9', 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'Industry', N'industry_9_7', N'供应商表', N'行业', N'其他采矿业', N'industry_9', 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierSource', N'source_1', N'供应商表', N'供应商来源', N'自己关系', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierSource', N'source_2', N'供应商表', N'供应商来源', N'网络宣传', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierSource', N'source_3', N'供应商表', N'供应商来源', N'业务开发', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierSource', N'source_4', N'供应商表', N'供应商来源', N'朋友介绍', NULL, 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierSource', N'source_5', N'供应商表', N'供应商来源', N'公司网站', NULL, 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierSource', N'source_6', N'供应商表', N'供应商来源', N'客户介绍', NULL, 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierType', N'type_1', N'供应商表', N'供应商类型', N'一般客户', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierType', N'type_10', N'供应商表', N'供应商类型', N'政府单位', NULL, 1, 10)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierType', N'type_11', N'供应商表', N'供应商类型', N'个人客户', NULL, 1, 11)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierType', N'type_2', N'供应商表', N'供应商类型', N'大客户', NULL, 1, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierType', N'type_3', N'供应商表', N'供应商类型', N'重点客户', NULL, 1, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierType', N'type_4', N'供应商表', N'供应商类型', N'VIP客户', NULL, 1, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierType', N'type_5', N'供应商表', N'供应商类型', N'一般意向', NULL, 1, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierType', N'type_6', N'供应商表', N'供应商类型', N'重点意向', NULL, 1, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierType', N'type_7', N'供应商表', N'供应商类型', N'独家区域代理', NULL, 1, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierType', N'type_8', N'供应商表', N'供应商类型', N'地区核心代理', NULL, 1, 8)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpSupplier', N'SupplierType', N'type_9', N'供应商表', N'供应商类型', N'增值服务代理商', NULL, 1, 9)
--OrderStatus
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'OrderStatus ', N'PLACE_ORDER_SUCCESS', N'速卖通订单', N'订单状态', N'等待买家付款', NULL, 0, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'OrderStatus ', N'IN_CANCEL', N'速卖通订单', N'订单状态', N'买家申请取消', NULL, 0, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'OrderStatus ', N'RISK_CONTROL', N'速卖通订单', N'订单状态', N'资金未到帐', NULL, 0, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'OrderStatus ', N'WAIT_SELLER_SEND_GOODS', N'速卖通订单', N'订单状态', N'等待卖家发货', NULL, 0, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'OrderStatus ', N'SELLER_PART_SEND_GOODS', N'速卖通订单', N'订单状态', N'部分发货', NULL, 0, 5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'OrderStatus ', N'WAIT_BUYER_ACCEPT_GOODS', N'速卖通订单', N'订单状态', N'等待买家收货', NULL, 0, 6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'OrderStatus ', N'FUND_PROCESSING', N'速卖通订单', N'订单状态', N'买家确认收货等待退放款处理', NULL, 0, 7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'OrderStatus ', N'FINISH', N'速卖通订单', N'订单状态', N'已结束的订单', NULL, 0, 8)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'OrderStatus ', N'IN_ISSUE', N'速卖通订单', N'订单状态', N'含纠纷的订单', NULL, 0, 9)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'OrderStatus ', N'IN_FROZEN', N'速卖通订单', N'订单状态', N'冻结中的订单', NULL, 0, 10)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'OrderStatus ', N'WAIT_SELLER_EXAMINE_MONEY', N'速卖通订单', N'订单状态', N'等待卖家确认金额', NULL, 0, 11)
--logisticsStatus
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'LogisticsStatus ', N'WAIT_SELLER_SEND_GOODS', N'速卖通订单', N'物流状态', N'等待卖家发货', NULL, 0, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'LogisticsStatus ', N'SELLER_SEND_PART_GOODS', N'速卖通订单', N'物流状态', N'卖家部分发货', NULL, 0, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'LogisticsStatus ', N'SELLER_SEND_GOODS', N'速卖通订单', N'物流状态', N'卖家已发货', NULL, 0, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'LogisticsStatus ', N'BUYER_ACCEPT_GOODS', N'速卖通订单', N'物流状态', N'买家已确认收货', NULL, 0, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'LogisticsStatus ', N'NO_LOGISTICS', N'速卖通订单', N'物流状态', N'没有物流流转信息', NULL, 0, 5)
--issueStatus
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'LssueStatus ', N'NO_ISSUE', N'速卖通订单', N'纠纷状态', N'无纠纷', NULL, 0, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'LssueStatus ', N'IN_ISSUE', N'速卖通订单', N'纠纷状态', N'纠纷中', NULL, 0, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'LssueStatus ', N'END_ISSUE', N'速卖通订单', N'纠纷状态', N'纠纷结束', NULL, 0, 3)
--frozenStatus
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'FrozenStatus ', N'NO_FROZEN', N'速卖通订单', N'冻结状态', N'无冻结', NULL, 0, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'FrozenStatus ', N'IN_FROZEN', N'速卖通订单', N'冻结状态', N'冻结中', NULL, 0, 2)
--fundStatus
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'FundStatus ', N'NOT_PAY', N'速卖通订单', N'资金状态', N'未付款', NULL, 0, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'FundStatus ', N'PAY_SUCCESS', N'速卖通订单', N'资金状态', N'付款成功', NULL, 0, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AliexpressAPI', N'FundStatus ', N'WAIT_SELLER_CHECK', N'速卖通订单', N'资金状态', N'卖家验款', NULL, 0, 3)
GO
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn1', N'客户表', N'CustomerColumn1', 2, 0, 1, N'', 1)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn10', N'客户表', N'CustomerColumn10', 3, 0, 1, N'', 10)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn11', N'客户表', N'CustomerColumn11', 3, 0, 1, N'', 11)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn12', N'客户表', N'CustomerColumn12', 0, 0, 1, N'', 12)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn13', N'客户表', N'CustomerColumn13', 3, 0, 1, N'', 13)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn14', N'客户表', N'CustomerColumn14', 0, 0, 1, N'', 14)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn15', N'客户表', N'CustomerColumn15', 0, 0, 1, N'', 15)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn16', N'客户表', N'CustomerColumn16', 0, 0, 1, N'', 16)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn17', N'客户表', N'CustomerColumn17', 0, 0, 1, N'', 17)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn18', N'客户表', N'CustomerColumn18', 0, 0, 1, N'', 18)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn19', N'客户表', N'CustomerColumn19', 0, 0, 1, N'', 19)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn2', N'客户表', N'CustomerColumn2', 2, 0, 1, N'', 2)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn20', N'客户表', N'CustomerColumn20', 0, 0, 1, N'', 20)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn3', N'客户表', N'CustomerColumn3', 0, 0, 1, N'', 3)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn4', N'客户表', N'CustomerColumn4', 1, 0, 1, N'', 4)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn5', N'客户表', N'CustomerColumn5', 1, 0, 1, N'', 5)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn6', N'客户表', N'CustomerColumn6', 4, 0, 1, N'', 6)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn7', N'客户表', N'CustomerColumn7', 0, 0, 1, N'', 7)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn8', N'客户表', N'CustomerColumn8', 0, 0, 1, N'', 8)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpCustomer', N'CustomerColumn9', N'客户表', N'CustomerColumn9', 0, 0, 1, N'', 9)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn1', N'产品表', N'ProductColumn1', 3, 0, 1, N'', 1)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn10', N'产品表', N'ProductColumn10', 0, 0, 1, N'', 10)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn11', N'产品表', N'ProductColumn11', 0, 0, 1, N'', 11)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn12', N'产品表', N'ProductColumn12', 0, 0, 1, N'', 12)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn13', N'产品表', N'ProductColumn13', 0, 0, 1, N'', 13)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn14', N'产品表', N'ProductColumn14', 0, 0, 1, N'', 14)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn15', N'产品表', N'ProductColumn15', 0, 0, 1, N'', 15)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn16', N'产品表', N'ProductColumn16', 0, 0, 1, N'', 16)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn17', N'产品表', N'ProductColumn17', 0, 0, 1, N'', 17)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn18', N'产品表', N'ProductColumn18', 0, 0, 1, N'', 18)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn19', N'产品表', N'ProductColumn19', 0, 0, 1, N'', 19)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn2', N'产品表', N'ProductColumn2', 0, 0, 1, N'', 2)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn20', N'产品表', N'ProductColumn20', 0, 0, 1, N'', 20)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn3', N'产品表', N'ProductColumn3', 0, 0, 1, N'', 3)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn4', N'产品表', N'ProductColumn4', 0, 0, 1, N'', 4)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn5', N'产品表', N'ProductColumn5', 0, 0, 1, N'', 5)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn6', N'产品表', N'ProductColumn6', 0, 0, 1, N'', 6)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn7', N'产品表', N'ProductColumn7', 0, 0, 1, N'', 7)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn8', N'产品表', N'ProductColumn8', 0, 0, 1, N'', 8)
INSERT [dbo].[HgColumnSetting] ([TableName], [ColumnName], [TableTitle], [ColumnTitle], [DataType], [IsActive], [AllowEmpty], [DataFomart], [OrderNo]) VALUES (N'ErpProduct', N'ProductColumn9', N'产品表', N'ProductColumn9', 0, 0, 1, N'', 9)
GO
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AliexpressApi', N'IsUseOwnKey', N'使用自有帐号', N'false', 3, N'', 1, 0, N'如果您有自己的开发者帐号可以使用自有的帐号，使用自有开发者帐号时请完成以下配置项')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AliexpressApi', N'ApiHost', N'接口调用地址', N'gw.api.alibaba.com', 1, N'', 1, 1, N'')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AliexpressApi', N'AppKey', N'AppKey', N'', 1, N'', 1, 3, N'')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AliexpressApi', N'AppSignature', N'App密钥', N'', 1, N'', 1, 4, N'')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AliexpressApi', N'IsBizAccount', N'商业授权帐号', N'true', 3, N'', 1, 2, N'是否取得速卖通商业授权, 如果是自用授权则不需要配置AppKey和App密钥')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AliexpressApi', N'RedirectUrl', N'接收URL地址', N'ApiUser/ReceiveToken', 1, N'', 1, 5, N'接收认证授权信息的URL地址')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AmazonApi', N'IsUseOwnKey', N'使用自有帐号', N'false', 3, N'', 1, 0, N'如果您有自己的开发者帐号可以使用自有的帐号，使用自有开发者帐号时请完成以下配置项')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EbayApi', N'IsUseOwnKey', N'使用自有帐号', N'false', 3, N'', 1, 0, N'如果您有自己的开发者帐号可以使用自有的帐号，使用自有开发者帐号时请完成以下配置项')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EbayApi', N'ApiAddress', N'调用接口地址', N'https://api.ebay.com/wsapi', 1, N'', 1, 5, N'For production site use: https://api.ebay.com/wsapi <br />For Sandbox site use: https://api.sandbox.ebay.com/wsapi')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EbayApi', N'AppID', N'应用ID', N'', 1, N'', 1, 2, N'')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EbayApi', N'CertID', N'证书ID', N'', 1, N' ', 1, 3, N' ')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EbayApi', N'DEVID', N'开发者ID', N'', 1, N'', 1, 1, N'')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EbayApi', N'RuName', N'RuName', N'', 1, N'', 1, 4, N'')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'WishApi', N'IsUseOwnKey', N'使用自有帐号', N'false', 3, N'', 1, 0, N'如果您有自己的开发者帐号可以使用自有的帐号，使用自有开发者帐号时请完成以下配置项')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'WishApi', N'ApiAddress', N'调用接口地址', N'https://merchant.wish.com/api/v1/', 1, N'', 1, 1, N'')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'ErpStockModule', N'OutStoreRule', N'出库规则', N'1', 5, N'先进先出|1|后进先出|2', 1, 4, N'')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'ErpOrderModule', N'IsEnabledSKU', N'启用SKU管理', N'true', 3, N'', 1, 1, N'是否启用SKU管理，当您需要对本地产品进行管理时请启用此选项，并且设置本地和电商平台中的SKU值，同步下来的订单将通过SKU查找与之相匹配的商品。')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'ErpOrderModule', N'DefaultTrackingNumber', N'默认跟踪号', N'', 1, N'', 1, 5, N'亚马逊回传跟踪号时，如果没有跟踪号就回传该值，如：no tracking number')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'ErpOrderModule', N'IsEnabledAutoApprove', N'自动审核订单', N'false', 3, N'', 1, 2, N'启用之后，在同步订单时会自动审核订单。')
GO

/*Begin 电商物流方式 */
--AliExpress
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'EMS', N'物流方式表', N'AliExpress', N'EMS', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'ACOMMERCE', N'物流方式表', N'AliExpress', N'aCommerce', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'ARAMEX', N'物流方式表', N'AliExpress', N'Aramex', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'AUSPOST', N'物流方式表', N'AliExpress', N'AUSPOST', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'CHP', N'物流方式表', N'AliExpress', N'Swiss Post', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'CORREOS', N'物流方式表', N'AliExpress', N'Correos', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'CPAM', N'物流方式表', N'AliExpress', N'China Post Registered Air Mail', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'CPAM_HRB', N'物流方式表', N'AliExpress', N'Russian Air', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'CPAP', N'物流方式表', N'AliExpress', N'China Post Air Parcel', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'CTR_LAND_PICKUP', N'物流方式表', N'AliExpress', N'CTR-LAND PICKUP', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'DEUTSCHE_POST', N'物流方式表', N'AliExpress', N'Deutsche Post', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'DHL', N'物流方式表', N'AliExpress', N'DHL', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'DHL_DE', N'物流方式表', N'AliExpress', N'DHL_DE', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'DHL_ES', N'物流方式表', N'AliExpress', N'DHL_ES', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'DHL_FR', N'物流方式表', N'AliExpress', N'DHL_FR', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'DHL_IT', N'物流方式表', N'AliExpress', N'DHL_IT', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'DHL_UK', N'物流方式表', N'AliExpress', N'DHL_UK', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'ECONOMIC139', N'物流方式表', N'AliExpress', N'139 ECONOMIC Package', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'FEDEX', N'物流方式表', N'AliExpress', N'Fedex IP', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'FEDEX_IE', N'物流方式表', N'AliExpress', N'Fedex IE', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'EMS_SH_ZX_US', N'物流方式表', N'AliExpress', N'DHL Global Mail', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'EMS_ZX_ZX_US', N'物流方式表', N'AliExpress', N'ePacket', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'ENVIALIA', N'物流方式表', N'AliExpress', N'Envialia', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'HKPAM', N'物流方式表', N'AliExpress', N'HongKong Post Air Mail', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'HKPAP', N'物流方式表', N'AliExpress', N'HongKong Post Air Parcel', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'ITELLA', N'物流方式表', N'AliExpress', N'Posti Finland', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'ITELLA_PY', N'物流方式表', N'AliExpress', N'Posti Finland Economy', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'JNE', N'物流方式表', N'AliExpress', N'JNE', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'POSTEITALIANE', N'物流方式表', N'AliExpress', N'Posteitaliane', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'ROYAL_MAIL', N'物流方式表', N'AliExpress', N'Royal Mail', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'RUSSIAN_POST', N'物流方式表', N'AliExpress', N'Russian Post', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'SEP', N'物流方式表', N'AliExpress', N'Sweden Post', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'SF', N'物流方式表', N'AliExpress', N'SF Express', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'SGP', N'物流方式表', N'AliExpress', N'Singapore Post', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'SPSR_CN', N'物流方式表', N'AliExpress', N'Russia Express-SPSR', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'SPSR_RU', N'物流方式表', N'AliExpress', N'SPSR_RU', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'SINOTRANS_PY', N'物流方式表', N'AliExpress', N'Sinoair-Correos  Economy Service', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'TNT', N'物流方式表', N'AliExpress', N'TNT', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'TOLL', N'物流方式表', N'AliExpress', N'TOLL', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'UPS', N'物流方式表', N'AliExpress', N'UPS Express Saver', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'UPS_US', N'物流方式表', N'AliExpress', N'UPS', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'UPSE', N'物流方式表', N'AliExpress', N'UPS Expedited', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'USPS', N'物流方式表', N'AliExpress', N'USPS', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'YANWEN_AM', N'物流方式表', N'AliExpress', N'Special Line-YW', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'YANWEN_JYT', N'物流方式表', N'AliExpress', N'China Post Ordinary Small Packet Plus', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'ZTORU', N'物流方式表', N'AliExpress', N'ZTO Express to Russia', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'Other', N'物流方式表', N'AliExpress', N'Seller''s Shipping Method', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'OTHER_AU', N'物流方式表', N'AliExpress', N'Seller''s Shipping  Method - AU', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'OTHER_DE', N'物流方式表', N'AliExpress', N'Seller''s Shipping  Method - DE', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'OTHER_ES', N'物流方式表', N'AliExpress', N'Seller''s Shipping  Method - ES', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'OTHER_FR', N'物流方式表', N'AliExpress', N'Seller''s Shipping  Method - FR', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'OTHER_IT', N'物流方式表', N'AliExpress', N'Seller''s Shipping  Method - IT', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'OTHER_RU', N'物流方式表', N'AliExpress', N'Seller''s Shipping  Method - RU', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'OTHER_UK', N'物流方式表', N'AliExpress', N'Seller''s Shipping  Method - UK', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'OTHER_US', N'物流方式表', N'AliExpress', N'Seller''s Shipping  Method - US', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'LAPOSTE', N'物流方式表', N'AliExpress', N'LAPOSTE', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'AliExpress', N'SINOTRANS_AM', N'物流方式表', N'AliExpress', N'CORREOS PAQ 72', NULL, 1, 1)
--EBAY
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'4PX',N'物流方式表',N'Ebay',N'4PX',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'A1 Courier Services',N'物流方式表',N'Ebay',N'A1 Courier Services',null,1,2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'ABF',N'物流方式表',N'Ebay',N'ABF',null,1,3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'ALLIED EXPRESS',N'物流方式表',N'Ebay',N'ALLIED EXPRESS',null,1,4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'AMWST',N'物流方式表',N'Ebay',N'AMWST',null,1,5)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'An Post',N'物流方式表',N'Ebay',N'An Post',null,1,6)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Aramex',N'物流方式表',N'Ebay',N'Aramex',null,1,7)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'ARVATO',N'物流方式表',N'Ebay',N'ARVATO',null,1,8)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'ASM',N'物流方式表',N'Ebay',N'ASM',null,1,9)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Australia Post',N'物流方式表',N'Ebay',N'Australia Post',null,1,10)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Australian Air Express',N'物流方式表',N'Ebay',N'Australian Air Express',null,1,11)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'AVRT',N'物流方式表',N'Ebay',N'AVRT',null,1,12)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'B Post',N'物流方式表',N'Ebay',N'B Post',null,1,13)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Bartolini',N'物流方式表',N'Ebay',N'Bartolini',null,1,14)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'BELGIAN POST',N'物流方式表',N'Ebay',N'BELGIAN POST',null,1,15)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'BKNS',N'物流方式表',N'Ebay',N'BKNS',null,1,16)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Blue Package',N'物流方式表',N'Ebay',N'Blue Package',null,1,17)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Brokers World Wide',N'物流方式表',N'Ebay',N'Brokers World Wide',null,1,18)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'CENF',N'物流方式表',N'Ebay',N'CENF',null,1,19)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'CEVA',N'物流方式表',N'Ebay',N'CEVA',null,1,20)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'China Post',N'物流方式表',N'Ebay',N'China Post',null,1,21)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Chronopost',N'物流方式表',N'Ebay',N'Chronopost',null,1,22)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'CHUKOU1',N'物流方式表',N'Ebay',N'CHUKOU1',null,1,23)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'CHUKOU1_EXPRESS',N'物流方式表',N'Ebay',N'CHUKOU1_EXPRESS',null,1,24)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Chunghwa Post',N'物流方式表',N'Ebay',N'Chunghwa Post',null,1,25)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'CitiPost',N'物流方式表',N'Ebay',N'CitiPost',null,1,26)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'City Link',N'物流方式表',N'Ebay',N'City Link',null,1,27)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'CNWY',N'物流方式表',N'Ebay',N'CNWY',null,1,28)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Coliposte Domestic',N'物流方式表',N'Ebay',N'Coliposte Domestic',null,1,29)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Coliposte International',N'物流方式表',N'Ebay',N'Coliposte International',null,1,30)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'ColiposteDomestic',N'物流方式表',N'Ebay',N'ColiposteDomestic',null,1,31)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'ColiposteInternational',N'物流方式表',N'Ebay',N'ColiposteInternational',null,1,32)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Colissimo',N'物流方式表',N'Ebay',N'Colissimo',null,1,33)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'CollectPlus',N'物流方式表',N'Ebay',N'CollectPlus',null,1,34)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Correos',N'物流方式表',N'Ebay',N'Correos',null,1,35)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'CPC',N'物流方式表',N'Ebay',N'CPC',null,1,36)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'DB Schenker',N'物流方式表',N'Ebay',N'DB Schenker',null,1,37)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Deutsche Post',N'物流方式表',N'Ebay',N'Deutsche Post',null,1,38)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'DeutschePost',N'物流方式表',N'Ebay',N'DeutschePost',null,1,39)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'DHL',N'物流方式表',N'Ebay',N'DHL',null,1,40)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'DHL Global Mail',N'物流方式表',N'Ebay',N'DHL Global Mail',null,1,41)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'DHL Global Mail Americas',N'物流方式表',N'Ebay',N'DHL Global Mail Americas',null,1,42)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'DHLG',N'物流方式表',N'Ebay',N'DHLG',null,1,43)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Die Schweizerische Post',N'物流方式表',N'Ebay',N'Die Schweizerische Post',null,1,44)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'DPD',N'物流方式表',N'Ebay',N'DPD',null,1,45)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Ducros',N'物流方式表',N'Ebay',N'Ducros',null,1,46)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'E GO',N'物流方式表',N'Ebay',N'E GO',null,1,47)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'EMS',N'物流方式表',N'Ebay',N'EMS',null,1,48)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'ePacket',N'物流方式表',N'Ebay',N'ePacket',null,1,49)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Exapaq',N'物流方式表',N'Ebay',N'Exapaq',null,1,50)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Fastway',N'物流方式表',N'Ebay',N'Fastway',null,1,51)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'FASTWAY COURIERS',N'物流方式表',N'Ebay',N'FASTWAY COURIERS',null,1,52)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'FedEx',N'物流方式表',N'Ebay',N'FedEx',null,1,53)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'FedEx Smart Post',N'物流方式表',N'Ebay',N'FedEx Smart Post',null,1,54)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'FLYT',N'物流方式表',N'Ebay',N'FLYT',null,1,55)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'FLYT Express',N'物流方式表',N'Ebay',N'FLYT Express',null,1,56)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'FlytExpress US Direct line',N'物流方式表',N'Ebay',N'FlytExpress US Direct line',null,1,57)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'FTFT',N'物流方式表',N'Ebay',N'FTFT',null,1,58)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'FulfilExpress-AccStation',N'物流方式表',N'Ebay',N'FulfilExpress-AccStation',null,1,59)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'FulfilExpress-eForCity',N'物流方式表',N'Ebay',N'FulfilExpress-eForCity',null,1,60)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'FulfilExpress-EverydaySource',N'物流方式表',N'Ebay',N'FulfilExpress-EverydaySource',null,1,61)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'FulfilExpress-iTrimming',N'物流方式表',N'Ebay',N'FulfilExpress-iTrimming',null,1,62)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'GlobalShipping_MultiCarrier',N'物流方式表',N'Ebay',N'GlobalShipping_MultiCarrier',null,1,63)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'GLS',N'物流方式表',N'Ebay',N'GLS',null,1,64)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'GSO',N'物流方式表',N'Ebay',N'GSO',null,1,65)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'HDUSA',N'物流方式表',N'Ebay',N'HDUSA',null,1,66)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Hermes',N'物流方式表',N'Ebay',N'Hermes',null,1,67)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Home Delivery Network',N'物流方式表',N'Ebay',N'Home Delivery Network',null,1,68)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Hong Kong Post',N'物流方式表',N'Ebay',N'Hong Kong Post',null,1,69)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'HUNTER_EXPRESS',N'物流方式表',N'Ebay',N'HUNTER_EXPRESS',null,1,70)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'i-parcel',N'物流方式表',N'Ebay',N'i-parcel',null,1,71)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'iLoxx',N'物流方式表',N'Ebay',N'iLoxx',null,1,72)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'In Post',N'物流方式表',N'Ebay',N'In Post',null,1,73)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'India Post',N'物流方式表',N'Ebay',N'India Post',null,1,74)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Indonesia Post',N'物流方式表',N'Ebay',N'Indonesia Post',null,1,75)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'InPost',N'物流方式表',N'Ebay',N'InPost',null,1,76)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'InterPost',N'物流方式表',N'Ebay',N'InterPost',null,1,77)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'IoInvio',N'物流方式表',N'Ebay',N'IoInvio',null,1,78)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Japan Post',N'物流方式表',N'Ebay',N'Japan Post',null,1,79)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'KIALA',N'物流方式表',N'Ebay',N'KIALA',null,1,80)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Korea Post',N'物流方式表',N'Ebay',N'Korea Post',null,1,81)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'LA POSTE',N'物流方式表',N'Ebay',N'LA POSTE',null,1,82)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'LDSO',N'物流方式表',N'Ebay',N'LDSO',null,1,83)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'LTL',N'物流方式表',N'Ebay',N'LTL',null,1,84)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'MALAYSIA POST',N'物流方式表',N'Ebay',N'MALAYSIA POST',null,1,85)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Manna Freight',N'物流方式表',N'Ebay',N'Manna Freight',null,1,86)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Mondial Relay',N'物流方式表',N'Ebay',N'Mondial Relay',null,1,87)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'MRW',N'物流方式表',N'Ebay',N'MRW',null,1,88)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'MSI',N'物流方式表',N'Ebay',N'MSI',null,1,89)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Nacex',N'物流方式表',N'Ebay',N'Nacex',null,1,90)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'NEMF',N'物流方式表',N'Ebay',N'NEMF',null,1,91)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'ODFL',N'物流方式表',N'Ebay',N'ODFL',null,1,92)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'OFFD',N'物流方式表',N'Ebay',N'OFFD',null,1,93)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'ONTRACK',N'物流方式表',N'Ebay',N'ONTRACK',null,1,94)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Other',N'物流方式表',N'Ebay',N'Other',null,1,95)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'OVNT',N'物流方式表',N'Ebay',N'OVNT',null,1,96)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Parcel Pool',N'物流方式表',N'Ebay',N'Parcel Pool',null,1,97)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Parcelforce',N'物流方式表',N'Ebay',N'Parcelforce',null,1,98)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Philpost',N'物流方式表',N'Ebay',N'Philpost',null,1,99)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Pilot',N'物流方式表',N'Ebay',N'Pilot',null,1,100)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'PITD',N'物流方式表',N'Ebay',N'PITD',null,1,101)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Pitt Ohio Trucking',N'物流方式表',N'Ebay',N'Pitt Ohio Trucking',null,1,102)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Poczta Polska',N'物流方式表',N'Ebay',N'Poczta Polska',null,1,103)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Pocztex',N'物流方式表',N'Ebay',N'Pocztex',null,1,104)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'POST ITALIANO',N'物流方式表',N'Ebay',N'POST ITALIANO',null,1,105)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Post NL',N'物流方式表',N'Ebay',N'Post NL',null,1,106)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Poste Italiane',N'物流方式表',N'Ebay',N'Poste Italiane',null,1,107)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Prestige',N'物流方式表',N'Ebay',N'Prestige',null,1,108)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Quantium',N'物流方式表',N'Ebay',N'Quantium',null,1,109)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'RETL',N'物流方式表',N'Ebay',N'RETL',null,1,110)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Royal Mail',N'物流方式表',N'Ebay',N'Royal Mail',null,1,111)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'RRUN',N'物流方式表',N'Ebay',N'RRUN',null,1,112)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Russian Post',N'物流方式表',N'Ebay',N'Russian Post',null,1,113)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'SAIA',N'物流方式表',N'Ebay',N'SAIA',null,1,114)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'SDA',N'物流方式表',N'Ebay',N'SDA',null,1,115)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Seur',N'物流方式表',N'Ebay',N'Seur',null,1,116)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'SFC',N'物流方式表',N'Ebay',N'SFC',null,1,117)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'SFC Express',N'物流方式表',N'Ebay',N'SFC Express',null,1,118)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'SFC_EXPRESS',N'物流方式表',N'Ebay',N'SFC_EXPRESS',null,1,119)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'SINGAPORE POST',N'物流方式表',N'Ebay',N'SINGAPORE POST',null,1,120)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Siódemka',N'物流方式表',N'Ebay',N'Siódemka',null,1,121)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'SMART SEND',N'物流方式表',N'Ebay',N'SMART SEND',null,1,122)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Suntek Express LTD',N'物流方式表',N'Ebay',N'Suntek Express LTD',null,1,123)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Sweden Post',N'物流方式表',N'Ebay',N'Sweden Post',null,1,124)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Swiss Post',N'物流方式表',N'Ebay',N'Swiss Post',null,1,125)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'TELE',N'物流方式表',N'Ebay',N'TELE',null,1,126)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'TEMANDO',N'物流方式表',N'Ebay',N'TEMANDO',null,1,127)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'THAILAND POST',N'物流方式表',N'Ebay',N'THAILAND POST',null,1,128)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'TNT',N'物流方式表',N'Ebay',N'TNT',null,1,129)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'TNT EXPRESS',N'物流方式表',N'Ebay',N'TNT EXPRESS',null,1,130)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'TPG',N'物流方式表',N'Ebay',N'TPG',null,1,131)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'TWW',N'物流方式表',N'Ebay',N'TWW',null,1,132)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'UPS',N'物流方式表',N'Ebay',N'UPS',null,1,133)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'UPS Mail Innovations',N'物流方式表',N'Ebay',N'UPS Mail Innovations',null,1,134)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'UPSC',N'物流方式表',N'Ebay',N'UPSC',null,1,135)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'USFG',N'物流方式表',N'Ebay',N'USFG',null,1,136)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'USPS',N'物流方式表',N'Ebay',N'USPS',null,1,137)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'Vietnam Post',N'物流方式表',N'Ebay',N'Vietnam Post',null,1,138)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'VITR',N'物流方式表',N'Ebay',N'VITR',null,1,139)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'WATKINS',N'物流方式表',N'Ebay',N'WATKINS',null,1,140)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'WISE',N'物流方式表',N'Ebay',N'WISE',null,1,141)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'WPX',N'物流方式表',N'Ebay',N'WPX',null,1,142)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'YANWEN',N'物流方式表',N'Ebay',N'YANWEN',null,1,143)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'YRC',N'物流方式表',N'Ebay',N'YRC',null,1,144)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'ePacketChina',N'物流方式表',N'Ebay',N'ePacketChina',null,1,145)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'OtherInternational',N'物流方式表',N'Ebay',N'OtherInternational',null,1,146)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'StandardDeliveryfromOutsideUKwithRoyalMail',N'物流方式表',N'Ebay',N'StandardDeliveryfromOutsideUKwithRoyalMail',null,1,147)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'StandardInternational',N'物流方式表',N'Ebay',N'StandardInternational',null,1,148)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'UK_SellersStandardInternationalRate',N'物流方式表',N'Ebay',N'UK_SellersStandardInternationalRate',null,1,149)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Ebay',N'EconomyShippingFromOutsideUS',N'物流方式表',N'Ebay',N'EconomyShippingFromOutsideUS',null,1,150)
--amazon
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'4PX',N'物流方式表',N'Amazon',N'4PX',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'A1 Courier Services',N'物流方式表',N'Amazon',N'A1 Courier Services',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'ABF',N'物流方式表',N'Amazon',N'ABF',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'ALLIED EXPRESS',N'物流方式表',N'Amazon',N'ALLIED EXPRESS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'AMWST',N'物流方式表',N'Amazon',N'AMWST',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'An Post',N'物流方式表',N'Amazon',N'An Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Aramex',N'物流方式表',N'Amazon',N'Aramex',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'ARVATO',N'物流方式表',N'Amazon',N'ARVATO',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'ASM',N'物流方式表',N'Amazon',N'ASM',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Australia Post',N'物流方式表',N'Amazon',N'Australia Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Australian Air Express',N'物流方式表',N'Amazon',N'Australian Air Express',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'AVRT',N'物流方式表',N'Amazon',N'AVRT',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'B Post',N'物流方式表',N'Amazon',N'B Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Bartolini',N'物流方式表',N'Amazon',N'Bartolini',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'BELGIAN POST',N'物流方式表',N'Amazon',N'BELGIAN POST',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'BKNS',N'物流方式表',N'Amazon',N'BKNS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Blue Package',N'物流方式表',N'Amazon',N'Blue Package',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Brokers World Wide',N'物流方式表',N'Amazon',N'Brokers World Wide',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Canada Post',N'物流方式表',N'Amazon',N'Canada Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'CENF',N'物流方式表',N'Amazon',N'CENF',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'CEVA',N'物流方式表',N'Amazon',N'CEVA',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'China Post',N'物流方式表',N'Amazon',N'China Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Chronopost',N'物流方式表',N'Amazon',N'Chronopost',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'CHUKOU1',N'物流方式表',N'Amazon',N'CHUKOU1',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'CHUKOU1_EXPRESS',N'物流方式表',N'Amazon',N'CHUKOU1_EXPRESS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Chunghwa Post',N'物流方式表',N'Amazon',N'Chunghwa Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'CitiPost',N'物流方式表',N'Amazon',N'CitiPost',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'City Link',N'物流方式表',N'Amazon',N'City Link',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'CNWY',N'物流方式表',N'Amazon',N'CNWY',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Coliposte Domestic',N'物流方式表',N'Amazon',N'Coliposte Domestic',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Coliposte International',N'物流方式表',N'Amazon',N'Coliposte International',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Colissimo',N'物流方式表',N'Amazon',N'Colissimo',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'CollectPlus',N'物流方式表',N'Amazon',N'CollectPlus',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Correos',N'物流方式表',N'Amazon',N'Correos',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'CPC',N'物流方式表',N'Amazon',N'CPC',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'DB Schenker',N'物流方式表',N'Amazon',N'DB Schenker',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Deutsche Post',N'物流方式表',N'Amazon',N'Deutsche Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'DHL',N'物流方式表',N'Amazon',N'DHL',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'DHL Global Mail',N'物流方式表',N'Amazon',N'DHL Global Mail',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'DHL Global Mail Americas',N'物流方式表',N'Amazon',N'DHL Global Mail Americas',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'DHLG',N'物流方式表',N'Amazon',N'DHLG',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Die Schweizerische Post',N'物流方式表',N'Amazon',N'Die Schweizerische Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'DPD',N'物流方式表',N'Amazon',N'DPD',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Ducros',N'物流方式表',N'Amazon',N'Ducros',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'E GO',N'物流方式表',N'Amazon',N'E GO',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'EMS',N'物流方式表',N'Amazon',N'EMS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'ePacket',N'物流方式表',N'Amazon',N'ePacket',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Exapaq',N'物流方式表',N'Amazon',N'Exapaq',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Fastway',N'物流方式表',N'Amazon',N'Fastway',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FASTWAY COURIERS',N'物流方式表',N'Amazon',N'FASTWAY COURIERS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FedEx',N'物流方式表',N'Amazon',N'FedEx',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FedEx Smart Post',N'物流方式表',N'Amazon',N'FedEx Smart Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FedEx Smartpost',N'物流方式表',N'Amazon',N'FedEx Smartpost',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FLYT',N'物流方式表',N'Amazon',N'FLYT',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FLYT Express',N'物流方式表',N'Amazon',N'FLYT Express',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FlytExpress US Direct line',N'物流方式表',N'Amazon',N'FlytExpress US Direct line',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FTFT',N'物流方式表',N'Amazon',N'FTFT',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FulfilExpress-AccStation',N'物流方式表',N'Amazon',N'FulfilExpress-AccStation',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FulfilExpress-eForCity',N'物流方式表',N'Amazon',N'FulfilExpress-eForCity',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FulfilExpress-EverydaySource',N'物流方式表',N'Amazon',N'FulfilExpress-EverydaySource',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'FulfilExpress-iTrimming',N'物流方式表',N'Amazon',N'FulfilExpress-iTrimming',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'GLS',N'物流方式表',N'Amazon',N'GLS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'GSO',N'物流方式表',N'Amazon',N'GSO',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'HDUSA',N'物流方式表',N'Amazon',N'HDUSA',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Home Delivery Network',N'物流方式表',N'Amazon',N'Home Delivery Network',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Hong Kong Post',N'物流方式表',N'Amazon',N'Hong Kong Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'HUNTER_EXPRESS',N'物流方式表',N'Amazon',N'HUNTER_EXPRESS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'i-parcel',N'物流方式表',N'Amazon',N'i-parcel',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'iLoxx',N'物流方式表',N'Amazon',N'iLoxx',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'In Post',N'物流方式表',N'Amazon',N'In Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'India Post',N'物流方式表',N'Amazon',N'India Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Indonesia Post',N'物流方式表',N'Amazon',N'Indonesia Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'InPost',N'物流方式表',N'Amazon',N'InPost',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'InterPost',N'物流方式表',N'Amazon',N'InterPost',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'IoInvio',N'物流方式表',N'Amazon',N'IoInvio',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Japan Post',N'物流方式表',N'Amazon',N'Japan Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'KIALA',N'物流方式表',N'Amazon',N'KIALA',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Korea Post',N'物流方式表',N'Amazon',N'Korea Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'LA POSTE',N'物流方式表',N'Amazon',N'LA POSTE',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Lasership',N'物流方式表',N'Amazon',N'Lasership',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'LDSO',N'物流方式表',N'Amazon',N'LDSO',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'LTL',N'物流方式表',N'Amazon',N'LTL',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'MALAYSIA POST',N'物流方式表',N'Amazon',N'MALAYSIA POST',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Manna Freight',N'物流方式表',N'Amazon',N'Manna Freight',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Mondial Relay',N'物流方式表',N'Amazon',N'Mondial Relay',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'MRW',N'物流方式表',N'Amazon',N'MRW',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'MSI',N'物流方式表',N'Amazon',N'MSI',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'NACEX',N'物流方式表',N'Amazon',N'NACEX',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'NEMF',N'物流方式表',N'Amazon',N'NEMF',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Newgistics',N'物流方式表',N'Amazon',N'Newgistics',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'ODFL',N'物流方式表',N'Amazon',N'ODFL',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'OFFD',N'物流方式表',N'Amazon',N'OFFD',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'OnTrac',N'物流方式表',N'Amazon',N'OnTrac',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'ONTRACK',N'物流方式表',N'Amazon',N'ONTRACK',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Other',N'物流方式表',N'Amazon',N'Other',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'OVNT',N'物流方式表',N'Amazon',N'OVNT',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Parcel Pool',N'物流方式表',N'Amazon',N'Parcel Pool',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Parcelforce',N'物流方式表',N'Amazon',N'Parcelforce',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Philpost',N'物流方式表',N'Amazon',N'Philpost',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Pilot',N'物流方式表',N'Amazon',N'Pilot',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'PITD',N'物流方式表',N'Amazon',N'PITD',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Pitt Ohio Trucking',N'物流方式表',N'Amazon',N'Pitt Ohio Trucking',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Poczta Polska',N'物流方式表',N'Amazon',N'Poczta Polska',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Pocztex',N'物流方式表',N'Amazon',N'Pocztex',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'POST ITALIANO',N'物流方式表',N'Amazon',N'POST ITALIANO',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Post NL',N'物流方式表',N'Amazon',N'Post NL',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Poste Italiane',N'物流方式表',N'Amazon',N'Poste Italiane',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Prestige',N'物流方式表',N'Amazon',N'Prestige',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Quantium',N'物流方式表',N'Amazon',N'Quantium',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'RETL',N'物流方式表',N'Amazon',N'RETL',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Royal Mail',N'物流方式表',N'Amazon',N'Royal Mail',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'RRUN',N'物流方式表',N'Amazon',N'RRUN',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Russian Post',N'物流方式表',N'Amazon',N'Russian Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'SAIA',N'物流方式表',N'Amazon',N'SAIA',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'SDA',N'物流方式表',N'Amazon',N'SDA',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Seur',N'物流方式表',N'Amazon',N'Seur',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'SFC',N'物流方式表',N'Amazon',N'SFC',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'SFC Express',N'物流方式表',N'Amazon',N'SFC Express',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'SFC_EXPRESS',N'物流方式表',N'Amazon',N'SFC_EXPRESS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'SINGAPORE POST',N'物流方式表',N'Amazon',N'SINGAPORE POST',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Siódemka',N'物流方式表',N'Amazon',N'Siódemka',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'SMART SEND',N'物流方式表',N'Amazon',N'SMART SEND',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Suntek Express LTD',N'物流方式表',N'Amazon',N'Suntek Express LTD',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Sweden Post',N'物流方式表',N'Amazon',N'Sweden Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Swiss Post',N'物流方式表',N'Amazon',N'Swiss Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'TELE',N'物流方式表',N'Amazon',N'TELE',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'TEMANDO',N'物流方式表',N'Amazon',N'TEMANDO',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'THAILAND POST',N'物流方式表',N'Amazon',N'THAILAND POST',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'TNT',N'物流方式表',N'Amazon',N'TNT',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'TNT EXPRESS',N'物流方式表',N'Amazon',N'TNT EXPRESS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'TPG',N'物流方式表',N'Amazon',N'TPG',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'TWW',N'物流方式表',N'Amazon',N'TWW',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'UPS',N'物流方式表',N'Amazon',N'UPS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'UPS Mail Innovations',N'物流方式表',N'Amazon',N'UPS Mail Innovations',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'UPSC',N'物流方式表',N'Amazon',N'UPSC',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'UPSMI',N'物流方式表',N'Amazon',N'UPSMI',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'USFG',N'物流方式表',N'Amazon',N'USFG',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'USPS',N'物流方式表',N'Amazon',N'USPS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'Vietnam Post',N'物流方式表',N'Amazon',N'Vietnam Post',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'VITR',N'物流方式表',N'Amazon',N'VITR',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'WATKINS',N'物流方式表',N'Amazon',N'WATKINS',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'WISE',N'物流方式表',N'Amazon',N'WISE',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'WPX',N'物流方式表',N'Amazon',N'WPX',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'YANWEN',N'物流方式表',N'Amazon',N'YANWEN',null,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Amazon',N'YRC',N'物流方式表',N'Amazon',N'YRC',null,1,1)
--wish
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SFExpress', N'物流方式表', N'Wish', N'SFExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'EltaCourier', N'物流方式表', N'Wish', N'EltaCourier', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'EmiratesPost', N'物流方式表', N'Wish', N'EmiratesPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'EMPSExpress', N'物流方式表', N'Wish', N'EMPSExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'YODEL', N'物流方式表', N'Wish', N'YODEL', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'YodelInternational', N'物流方式表', N'Wish', N'YodelInternational', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'YRC', N'物流方式表', N'Wish', N'YRC', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'YundaExpress', N'物流方式表', N'Wish', N'YundaExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'USPS', N'物流方式表', N'Wish', N'USPS', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'VietnamPost', N'物流方式表', N'Wish', N'VietnamPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'VietnamPostEMS', N'物流方式表', N'Wish', N'VietnamPostEMS', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ViettelPost', N'物流方式表', N'Wish', N'ViettelPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Wahana', N'物流方式表', N'Wish', N'Wahana', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'WeDoLogisitics', N'物流方式表', N'Wish', N'WeDoLogisitics', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'XDPExpress', N'物流方式表', N'Wish', N'XDPExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Xend', N'物流方式表', N'Wish', N'Xend', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'XpressBees', N'物流方式表', N'Wish', N'XpressBees', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Yanwen', N'物流方式表', N'Wish', N'Yanwen', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'UPSFreight', N'物流方式表', N'Wish', N'UPSFreight', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'UPSMailInnovations', N'物流方式表', N'Wish', N'UPSMailInnovations', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'UPS', N'物流方式表', N'Wish', N'UPS', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TollGlobalExpress', N'物流方式表', N'Wish', N'TollGlobalExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TollIPEC', N'物流方式表', N'Wish', N'TollIPEC', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TollPriority', N'物流方式表', N'Wish', N'TollPriority', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TrakPak', N'物流方式表', N'Wish', N'TrakPak', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TurkishPost', N'物流方式表', N'Wish', N'TurkishPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'UKMail', N'物流方式表', N'Wish', N'UKMail', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'UkrPoshta', N'物流方式表', N'Wish', N'UkrPoshta', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TNT', N'物流方式表', N'Wish', N'TNT', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TNTAustralia', N'物流方式表', N'Wish', N'TNTAustralia', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TNTClickItaly', N'物流方式表', N'Wish', N'TNTClickItaly', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TNTFrance', N'物流方式表', N'Wish', N'TNTFrance', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TNTItaly', N'物流方式表', N'Wish', N'TNTItaly', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TNTPostItaly', N'物流方式表', N'Wish', N'TNTPostItaly', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TNTUK', N'物流方式表', N'Wish', N'TNTUK', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'StarTrackAustralia', N'物流方式表', N'Wish', N'StarTrackAustralia', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'StarTrackExpress', N'物流方式表', N'Wish', N'StarTrackExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'STOExpress', N'物流方式表', N'Wish', N'STOExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SwedenPosten', N'物流方式表', N'Wish', N'SwedenPosten', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SwissPost', N'物流方式表', N'Wish', N'SwissPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TaiwanPost', N'物流方式表', N'Wish', N'TaiwanPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TAQBINHongKong', N'物流方式表', N'Wish', N'TAQBINHongKong', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TAQBINJapan', N'物流方式表', N'Wish', N'TAQBINJapan', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TAQBINMalaysia', N'物流方式表', N'Wish', N'TAQBINMalaysia', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TAQBINSingapore', N'物流方式表', N'Wish', N'TAQBINSingapore', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'TGX', N'物流方式表', N'Wish', N'TGX', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ThailandThaiPost', N'物流方式表', N'Wish', N'ThailandThaiPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Tiki', N'物流方式表', N'Wish', N'Tiki', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SingaporePost', N'物流方式表', N'Wish', N'SingaporePost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SingaporeSpeedpost', N'物流方式表', N'Wish', N'SingaporeSpeedpost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Siodemka', N'物流方式表', N'Wish', N'Siodemka', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SkynetMalaysia', N'物流方式表', N'Wish', N'SkynetMalaysia', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SkynetWorldwideExpress', N'物流方式表', N'Wish', N'SkynetWorldwideExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SkynetWorldwideExpressUK', N'物流方式表', N'Wish', N'SkynetWorldwideExpressUK', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SouthAfricanPostOffice', N'物流方式表', N'Wish', N'SouthAfricanPostOffice', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SpanishSeur', N'物流方式表', N'Wish', N'SpanishSeur', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SpecialisedFreight', N'物流方式表', N'Wish', N'SpecialisedFreight', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'RussianPost', N'物流方式表', N'Wish', N'RussianPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Safexpress', N'物流方式表', N'Wish', N'Safexpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Sagawa', N'物流方式表', N'Wish', N'Sagawa', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'SaudiPost', N'物流方式表', N'Wish', N'SaudiPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Selektvracht', N'物流方式表', N'Wish', N'Selektvracht', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'RoyalMail', N'物流方式表', N'Wish', N'RoyalMail', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'RPXIndonesia', N'物流方式表', N'Wish', N'RPXIndonesia', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'RPXOnline', N'物流方式表', N'Wish', N'RPXOnline', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PosteItaliane', N'物流方式表', N'Wish', N'PosteItaliane', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PosteItalianePaccocelere', N'物流方式表', N'Wish', N'PosteItalianePaccocelere', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PostenNorge', N'物流方式表', N'Wish', N'PostenNorge', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PostNL', N'物流方式表', N'Wish', N'PostNL', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PostNLInternational', N'物流方式表', N'Wish', N'PostNLInternational', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PostNLInternational3S', N'物流方式表', N'Wish', N'PostNLInternational3S', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PostNordLogistics', N'物流方式表', N'Wish', N'PostNordLogistics', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PostService', N'物流方式表', N'Wish', N'PostService', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ProfessionalCouriers', N'物流方式表', N'Wish', N'ProfessionalCouriers', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PTTPosta', N'物流方式表', N'Wish', N'PTTPosta', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Purolator', N'物流方式表', N'Wish', N'Purolator', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PX4', N'物流方式表', N'Wish', N'PX4', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Qxpress', N'物流方式表', N'Wish', N'Qxpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'RAF', N'物流方式表', N'Wish', N'RAF', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'RedExpress', N'物流方式表', N'Wish', N'RedExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'RedExpressWaybill', N'物流方式表', N'Wish', N'RedExpressWaybill', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'RedurSpain', N'物流方式表', N'Wish', N'RedurSpain', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'RLCarriers', N'物流方式表', N'Wish', N'RLCarriers', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'RomaniaPost', N'物流方式表', N'Wish', N'RomaniaPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'OnTrac', N'物流方式表', N'Wish', N'OnTrac', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'OPEK', N'物流方式表', N'Wish', N'OPEK', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Panther', N'物流方式表', N'Wish', N'Panther', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ParcelForce', N'物流方式表', N'Wish', N'ParcelForce', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PocztaPolska', N'物流方式表', N'Wish', N'PocztaPolska', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PortugalCTT', N'物流方式表', N'Wish', N'PortugalCTT', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PortugalSeur', N'物流方式表', N'Wish', N'PortugalSeur', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'PosIndonesiaDomestic', N'物流方式表', N'Wish', N'PosIndonesiaDomestic', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'NewZealandPost', N'物流方式表', N'Wish', N'NewZealandPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'NiPost', N'物流方式表', N'Wish', N'NiPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'NovaPoshta', N'物流方式表', N'Wish', N'NovaPoshta', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'OCAArgentina', N'物流方式表', N'Wish', N'OCAArgentina', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'NACEXSpain', N'物流方式表', N'Wish', N'NACEXSpain', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'LaserShip', N'物流方式表', N'Wish', N'LaserShip', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'LBCExpress', N'物流方式表', N'Wish', N'LBCExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'LithuaniaPost', N'物流方式表', N'Wish', N'LithuaniaPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'MalaysiaPost', N'物流方式表', N'Wish', N'MalaysiaPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'MalaysiaPostPosDaftar', N'物流方式表', N'Wish', N'MalaysiaPostPosDaftar', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'MexicoAeroFlash', N'物流方式表', N'Wish', N'MexicoAeroFlash', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'MexicoMultipack', N'物流方式表', N'Wish', N'MexicoMultipack', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'MexicoRedpack', N'物流方式表', N'Wish', N'MexicoRedpack', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'MexicoSendaExpress', N'物流方式表', N'Wish', N'MexicoSendaExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'MRW', N'物流方式表', N'Wish', N'MRW', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Mypostonline', N'物流方式表', N'Wish', N'Mypostonline', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'JNE', N'物流方式表', N'Wish', N'JNE', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'KerryLogistics', N'物流方式表', N'Wish', N'KerryLogistics', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'KoreaPost', N'物流方式表', N'Wish', N'KoreaPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'KuehneNagel', N'物流方式表', N'Wish', N'KuehneNagel', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'LaPosteColissimo', N'物流方式表', N'Wish', N'LaPosteColissimo', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ItellaPosti', N'物流方式表', N'Wish', N'ItellaPosti', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'JamExpress', N'物流方式表', N'Wish', N'JamExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'JapanPost', N'物流方式表', N'Wish', N'JapanPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'JCEX', N'物流方式表', N'Wish', N'JCEX', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'IndiaPost', N'物流方式表', N'Wish', N'IndiaPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'IndiaPostInternational', N'物流方式表', N'Wish', N'IndiaPostInternational', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'IndonesiaPost', N'物流方式表', N'Wish', N'IndonesiaPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'InterlinkExpress', N'物流方式表', N'Wish', N'InterlinkExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'InternationalSeur', N'物流方式表', N'Wish', N'InternationalSeur', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'IParcel', N'物流方式表', N'Wish', N'IParcel', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'IsraelPost', N'物流方式表', N'Wish', N'IsraelPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'IsraelPostDomestic', N'物流方式表', N'Wish', N'IsraelPostDomestic', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ItalySDA', N'物流方式表', N'Wish', N'ItalySDA', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'HongKongPost', N'物流方式表', N'Wish', N'HongKongPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'HrvatskaPosta', N'物流方式表', N'Wish', N'HrvatskaPosta', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Hermes', N'物流方式表', N'Wish', N'Hermes', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'HermesGermany', N'物流方式表', N'Wish', N'HermesGermany', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'GLS', N'物流方式表', N'Wish', N'GLS', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'GLSItaly', N'物流方式表', N'Wish', N'GLSItaly', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'GLSNetherlands', N'物流方式表', N'Wish', N'GLSNetherlands', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'GoJaVAS', N'物流方式表', N'Wish', N'GoJaVAS', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Greyhound', N'物流方式表', N'Wish', N'Greyhound', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'FlytExpress', N'物流方式表', N'Wish', N'FlytExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'GatiKWE', N'物流方式表', N'Wish', N'GatiKWE', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'GDEX', N'物流方式表', N'Wish', N'GDEX', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'GenikiTaxydromiki', N'物流方式表', N'Wish', N'GenikiTaxydromiki', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'GeodisCalbersonFrance', N'物流方式表', N'Wish', N'GeodisCalbersonFrance', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'GHN', N'物流方式表', N'Wish', N'GHN', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'FedExUK', N'物流方式表', N'Wish', N'FedExUK', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'FirstFlightCouriers', N'物流方式表', N'Wish', N'FirstFlightCouriers', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'FirstLogistics', N'物流方式表', N'Wish', N'FirstLogistics', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'FlashCourier', N'物流方式表', N'Wish', N'FlashCourier', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'FedEx', N'物流方式表', N'Wish', N'FedEx', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'EquickChina', N'物流方式表', N'Wish', N'EquickChina', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Estafeta', N'物流方式表', N'Wish', N'Estafeta', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Estes', N'物流方式表', N'Wish', N'Estes', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Evergreen', N'物流方式表', N'Wish', N'Evergreen', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'FastwayAustralia', N'物流方式表', N'Wish', N'FastwayAustralia', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'FastwayIreland', N'物流方式表', N'Wish', N'FastwayIreland', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'FastwaySouthAfrica', N'物流方式表', N'Wish', N'FastwaySouthAfrica', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'EMS', N'物流方式表', N'Wish', N'EMS', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Envialia', N'物流方式表', N'Wish', N'Envialia', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'EPacket', N'物流方式表', N'Wish', N'EPacket', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ACSCourier', N'物流方式表', N'Wish', N'ACSCourier', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'AIR21', N'物流方式表', N'Wish', N'AIR21', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'AnPost', N'物流方式表', N'Wish', N'AnPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'APCLogistics', N'物流方式表', N'Wish', N'APCLogistics', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ECFirstClass', N'物流方式表', N'Wish', N'ECFirstClass', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'EcomExpress', N'物流方式表', N'Wish', N'EcomExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DHL2MannHandling', N'物流方式表', N'Wish', N'DHL2MannHandling', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DHLBenelux', N'物流方式表', N'Wish', N'DHLBenelux', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DHLGermany', N'物流方式表', N'Wish', N'DHLGermany', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DHLGlobalMail', N'物流方式表', N'Wish', N'DHLGlobalMail', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DHLGlobalMailAsia', N'物流方式表', N'Wish', N'DHLGlobalMailAsia', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DHLNetherlands', N'物流方式表', N'Wish', N'DHLNetherlands', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DHLParcelNL', N'物流方式表', N'Wish', N'DHLParcelNL', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DHLPoland', N'物流方式表', N'Wish', N'DHLPoland', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DirectLink', N'物流方式表', N'Wish', N'DirectLink', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Dotzot', N'物流方式表', N'Wish', N'Dotzot', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DPD', N'物流方式表', N'Wish', N'DPD', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DPDGermany', N'物流方式表', N'Wish', N'DPDGermany', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DPDIreland', N'物流方式表', N'Wish', N'DPDIreland', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DPDPoland', N'物流方式表', N'Wish', N'DPDPoland', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DPDUK', N'物流方式表', N'Wish', N'DPDUK', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DPESouthAfrica', N'物流方式表', N'Wish', N'DPESouthAfrica', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DPEXChina', N'物流方式表', N'Wish', N'DPEXChina', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DTDCIndia', N'物流方式表', N'Wish', N'DTDCIndia', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DX', N'物流方式表', N'Wish', N'DX', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DynamicLogistics', N'物流方式表', N'Wish', N'DynamicLogistics', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DHL', N'物流方式表', N'Wish', N'DHL', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DeutschePost', N'物流方式表', N'Wish', N'DeutschePost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CyprusPost', N'物流方式表', N'Wish', N'CyprusPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DanmarkPost', N'物流方式表', N'Wish', N'DanmarkPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DBSchenkerSweden', N'物流方式表', N'Wish', N'DBSchenkerSweden', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Delhivery', N'物流方式表', N'Wish', N'Delhivery', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'DeltecCourier', N'物流方式表', N'Wish', N'DeltecCourier', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CorreosChile', N'物流方式表', N'Wish', N'CorreosChile', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CorreosDeEspana', N'物流方式表', N'Wish', N'CorreosDeEspana', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CorreosDeMexico', N'物流方式表', N'Wish', N'CorreosDeMexico', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CourierIT', N'物流方式表', N'Wish', N'CourierIT', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CourierPlus', N'物流方式表', N'Wish', N'CourierPlus', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CourierPost', N'物流方式表', N'Wish', N'CourierPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CouriersPlease', N'物流方式表', N'Wish', N'CouriersPlease', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ColisPrive', N'物流方式表', N'Wish', N'ColisPrive', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Colissimo', N'物流方式表', N'Wish', N'Colissimo', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CollectPlus', N'物流方式表', N'Wish', N'CollectPlus', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CorreoArgentino', N'物流方式表', N'Wish', N'CorreoArgentino', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ChronopostFrance', N'物流方式表', N'Wish', N'ChronopostFrance', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ChronopostPortugal', N'物流方式表', N'Wish', N'ChronopostPortugal', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Chukou1', N'物流方式表', N'Wish', N'Chukou1', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CityLink', N'物流方式表', N'Wish', N'CityLink', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CityLinkExpress', N'物流方式表', N'Wish', N'CityLinkExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CityLinkInternational', N'物流方式表', N'Wish', N'CityLinkInternational', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CJGLS', N'物流方式表', N'Wish', N'CJGLS', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CanadaPost', N'物流方式表', N'Wish', N'CanadaPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CeskaPosta', N'物流方式表', N'Wish', N'CeskaPosta', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ChinaAirPost', N'物流方式表', N'Wish', N'ChinaAirPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'AustraliaPost', N'物流方式表', N'Wish', N'AustraliaPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'AustrianPost', N'物流方式表', N'Wish', N'AustrianPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'AustrianPostRegistered', N'物流方式表', N'Wish', N'AustrianPostRegistered', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Belpost', N'物流方式表', N'Wish', N'Belpost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'BestExpress', N'物流方式表', N'Wish', N'BestExpress', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Bluedart', N'物流方式表', N'Wish', N'Bluedart', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'BOXC', N'物流方式表', N'Wish', N'BOXC', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'BPost', N'物流方式表', N'Wish', N'BPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'BPostInternational', N'物流方式表', N'Wish', N'BPostInternational', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'BrazilCorreios', N'物流方式表', N'Wish', N'BrazilCorreios', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'BRTBartolini', N'物流方式表', N'Wish', N'BRTBartolini', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'BulgarianPosts', N'物流方式表', N'Wish', N'BulgarianPosts', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'CambodiaPost', N'物流方式表', N'Wish', N'CambodiaPost', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'_2GO', N'物流方式表', N'Wish', N'_2GO', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'_4SquareGroup', N'物流方式表', N'Wish', N'_4SquareGroup', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ABF', N'物流方式表', N'Wish', N'ABF', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'Aramex', N'物流方式表', N'Wish', N'Aramex', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ArrowXL', N'物流方式表', N'Wish', N'ArrowXL', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'AsendiaUSA', N'物流方式表', N'Wish', N'AsendiaUSA', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'ASM', N'物流方式表', N'Wish', N'ASM', NULL, 1, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode', N'Wish', N'AuPostChina', N'物流方式表', N'Wish', N'AuPostChina', NULL, 1, 1)
GO
/*End*/
--物流模板参数初始化
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[客户协议号]', N'ErpLogisticMode', N'CustomerAgreement', N'CustomerAgreement', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[包裹报关中文名]', N'ErpDelivery', N'DeclareCNName', N'DeliveryDeclareCNName', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[包裹申报价值]', N'ErpDelivery', N'DeclaredPrice', N'DeliveryDeclaredPrice', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[包裹申报总价值]', N'ErpDelivery', N'DeclaredTotalPrice', N'DeliveryDeclaredTotalPrice', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[包裹报关英文名]', N'ErpDelivery', N'DeclareENName', N'DeliveryDeclareENName', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[包裹分类]', N'ErpDelivery', N'DeclareParcelType', N'DeliveryDeclareParcelType', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[包裹申报总重量]', N'ErpDelivery', N'DeclareTotalWeight', N'DeliveryDeclareTotalWeight', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[包裹申报重量]', N'ErpDelivery', N'DeclareWeight', N'DeliveryDeclareWeight', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[物流代码]', N'ErpLogistic', N'LogisticCode', N'DeliveryLogisticCode', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[包裹数量]', N'ErpDelivery', N'Num', N'DeliveryNum', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[物流跟踪号]', N'ErpDelivery', N'LogisticTransitNo', N'LogisticTransitNo', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[物流跟踪号条码]', N'ErpDelivery', N'LogisticTransitNo', N'LogisticTransitNoPic', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[订单号]', N'ErpOrder', N'OrderNo', N'OrderNo', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[打印日期]', N'System', N'DataTime.Now', N'PrintDate', N'Package')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[产品报关中文名]', N'ErpProductLogistic', N'DeclareCNName', N'ProductDeclareCNName', N'Product')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[产品申报价值]', N'ErpProductLogistic', N'DeclaredPrice', N'ProductDeclaredPrice', N'Product')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[产品报关英文名]', N'ErpProductLogistic', N'DeclareENName', N'ProductDeclareENName', N'Product')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[产品申报重量]', N'ErpProductLogistic', N'DeclareWeight', N'ProductDeclareWeight', N'Product')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[产品序号]', N'System', N'IDENTITY', N'ProductNo', N'Product')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[产品数量]', N'ErpOrderDetail', N'Num', N'ProductNum', N'Product')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[产品SKU]', N'ErpOrderDetail', N'Sku', N'ProductSku', N'Product')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[产品SKU*数量]', N'ErpOrderDetail', N'SKu*Num', N'ProductSkuNum', N'Product')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[收件人地址]', N'ErpAddress', N'Address', N'RecipientAddress', N'Recipient')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[收件人城市]', N'ErpAddress', N'City', N'RecipientCity', N'Recipient')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[收件人公司]', N'ErpAddress', N'Company', N'RecipientCompany', N'Recipient')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[收件人]', N'ErpAddress', N'Contact', N'RecipientContack', N'Recipient')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[收件人国家(地区)代码]', N'ErpAddress', N'Country', N'RecipientCountry', N'Recipient')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[收件人国家（地区）中文名]', N'HgCountry', N'Name', N'RecipientCountryChineseName', N'Recipient')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[收件人国家（地区）英文名]', N'HgCountry', N'CountryEnglishName', N'RecipientCountryEnglishName', N'Recipient')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[收件人电话]', N'ErpAddress', N'MobilePhone', N'RecipientMobilePhone', N'Recipient')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[收件人省份]', N'ErpAddress', N'Province', N'RecipientProvince', N'Recipient')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[收件人邮编]', N'ErpAddress', N'ZipCode', N'RecipientZipCode', N'Recipient')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[寄件人地址]', N'ErpAddress', N'Address', N'SendAddress', N'Send')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[寄件人城市]', N'ErpAddress', N'City', N'SendCity', N'Send')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[寄件人公司]', N'ErpAddress', N'Company', N'SendCompany', N'Send')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[寄件人]', N'ErpAddress', N'Contact', N'SendContact', N'Send')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[寄件人国家(地区)]', N'ErpAddress', N'Country', N'SendCountry', N'Send')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[寄件人电话]', N'ErpAddress', N'MobilePhone', N'SendMobilePhone', N'Send')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[寄件人省份]', N'ErpAddress', N'Province', N'SendProvince', N'Send')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[寄件人邮编]', N'ErpAddress', N'ZipCode', N'SendZipCode', N'Send')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[A|B]', N'ErpLogisticModeParam', N'ParamValue2', N'YANWEN_AorB', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[国家数字代码(#X)]', N'ErpLogisticModeParam', N'ParamValue1', N'YANWEN_CountryCode', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[分组号]', N'ErpLogisticModeParam', N'ParamValue1', N'YANWEN_Group', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[挂]', N'ErpLogisticModeParam', N'ParamValue1', N'YANWEN_GUA', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[燕文客户ID]', N'', NULL, N'YANWEN_ID', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[参考号]', N'ErpOrder', N'LogisticNo', N'YANWEN_LogisticNo', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[参考号条码]', N'ErpOrder', N'LogisticNo', N'YANWEN_LogisticNoPic', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[自编号(OrderNo)]', N'ErpOrder', N'OrderNo', N'YANWEN_OrderNo', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[自编号条码]', N'ErpOrder', N'OrderNo', N'YANWEN_OrderNoPic', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[分区]', N'ErpLogisticModeParam', NULL, N'YANWEN_Partition', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[平]', N'ErpLogisticModeParam', N'ParamValue1', N'YANWEN_PING', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[路线]', N'ErpLogisticModeParam', N'ParamValue1', N'YANWEN_Route', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[序]', N'ErpLogisticModeParam', N'ParamValue1', N'YANWEN_XU', N'YANWENPackage')
INSERT [dbo].[ErpLogisticParam] ([ParamName], [TableName], [ColumnName], [ParamCode], [ParamType]) VALUES (N'[收件人地址2]', N'ErpAddress', N'Address2', N'RecipientAddress2', N'Recipient')
GO

/*start chenrong 20150520*/
/*添加默认报关信息菜单*/
INSERT [dbo].[HgMenu] (MenuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive) values('erp_logistic_custominfo_setting','默认报关信息',4,3,'','erp_logistic','Common/SysSetting/ErpCustomInfo','glyphicon glyphicon-oil',1); 

/*添加默认报关信息*/
INSERT [dbo].[HgSysSetting] (SettingGroup, SettingKey, SettingTitle, SettingValue, SettingType, SettingOption, AllowEdit, OrderNo, Remarks) values('ErpCustomInfo','DeclareCNName','报关中文名','礼品',1,'',1,1,'*请填写报关中文名');
INSERT [dbo].[HgSysSetting] (SettingGroup, SettingKey, SettingTitle, SettingValue, SettingType, SettingOption, AllowEdit, OrderNo, Remarks) values('ErpCustomInfo','DeclaredPrice','产品申报价值($)','5|0',6,'手动输入|0|价格百分比|1',1,4,'*请填写申报价值');
INSERT [dbo].[HgSysSetting] (SettingGroup, SettingKey, SettingTitle, SettingValue, SettingType, SettingOption, AllowEdit, OrderNo, Remarks) values('ErpCustomInfo','DeclareENName','报关英文名','sample goods',1,'',1,2,'*请填写报关英文名');
INSERT [dbo].[HgSysSetting] (SettingGroup, SettingKey, SettingTitle, SettingValue, SettingType, SettingOption, AllowEdit, OrderNo, Remarks) values('ErpCustomInfo','DeclareWeight','申报重量(kg)','0.2',2,'',1,3,'*请填写申报重量');
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'ErpOrderModule', N'DeclaredPrice', N'产品申报价值($)', N'10|1', 6, N'手动输入|0|价格百分比|1', 1, 11, N'在同步订单时系统将自动把产品申报价值按输入值计算')
/*添加页面权限*/
INSERT [dbo].[HgPermission] (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks) values('erp_logistic_custominfo_setting','默认报关信息','','','erp_logistic',1,'');
INSERT [dbo].[HgPermission] (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks) values('erp_logistic_custominfo_edit','编辑报关信息','Common','ErpCustomInfoSysSetting','erp_logistic_custominfo_setting',2,'');
/*end */
		
/*start 添加跟踪号号码池 chenrong 2015/05/22*/
INSERT [dbo].[HgMenu] (MenuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive) values('erp_TrackingNumPool','跟踪号号码池',5,3,'','erp_logistic','TrackingNumPool/Index','glyphicon glyphicon-cog',1);
INSERT [dbo].[HgPermission] (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks)values('erp_TrackingNumPool','跟踪号号码池','','','erp_logistic',1,'');
INSERT [dbo].[HgPermission] (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks)values('erp_trackingNumPool_index','跟踪号号码池','TrackingNumPool','Index','erp_TrackingNumPool',2,'');
INSERT [dbo].[HgPermission] (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks)values('erp_trackingNumPool_edit','编辑跟踪号号码池','TrackingNumPool','Edit','erp_TrackingNumPool',2,'');
INSERT [dbo].[HgPermission] (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks)values('erp_trackingNumPool_import','导入跟踪号','TrackingNumPool','Import','erp_TrackingNumPool',2,'');
/*end*/

/*关于物流商接口参数调整 tutu 2015-6-8 sta0rt */
SET IDENTITY_INSERT [dbo].[ErpLogistic] ON
INSERT [dbo].[ErpLogistic] ([LogisticId], [LogisticName], [StatusCode], [LogisticColumn1], [LogisticColumn2], [LogisticColumn3], [LogisticColumn4], [LogisticColumn5], [LogisticColumn6], [LogisticColumn7], [LogisticColumn8], [LogisticColumn9], [LogisticColumn10], [LogisticColumn11], [LogisticColumn12], [LogisticColumn13], [LogisticColumn14], [LogisticColumn15], [LogisticColumn16], [LogisticColumn17], [LogisticColumn18], [LogisticColumn19], [LogisticColumn20], [LogisticCode],[SortNumber]) VALUES (1, N'4PX', 0, N'http://api.4px.com:8058/OrderOnline/ws/OrderOnlineService.dll?wsdl', N'http://api.4px.com:8059/OrderOnlineTool/ws/OrderOnlineToolService.dll?wsdl','http://aeapi.4px.com/label/printOrder', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'FileData/LogisticLogo/4px.png', N'http://www.4px.com/', NULL, N' 一家致力于为跨境电商提供全球物流和全球仓储领先服务的专业物流方案提供商。', NULL, NULL, NULL, NULL, N'4PX',0)
INSERT [dbo].[ErpLogistic] ([LogisticId], [LogisticName], [StatusCode], [LogisticColumn1], [LogisticColumn2], [LogisticColumn3], [LogisticColumn4], [LogisticColumn5], [LogisticColumn6], [LogisticColumn7], [LogisticColumn8], [LogisticColumn9], [LogisticColumn10], [LogisticColumn11], [LogisticColumn12], [LogisticColumn13], [LogisticColumn14], [LogisticColumn15], [LogisticColumn16], [LogisticColumn17], [LogisticColumn18], [LogisticColumn19], [LogisticColumn20], [LogisticCode],[SortNumber]) VALUES (3, N'三态', 0, N'http://api.sendfromchina.com/ishipsvc/web-service',NULL, NULL,NULL, NULL,NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'FileData/LogisticLogo/SFC.png', N'http://www.sfcservice.com/', NULL, N'前海三态通过网站SFCService.com提供各知名国际快递公司与各国邮政的服务和价格，是客户的“国际速递比价网”和“国际速递超市”。', NULL, NULL, NULL, NULL, N'SFC',0)
INSERT [dbo].[ErpLogistic] ([LogisticId], [LogisticName], [StatusCode], [LogisticColumn1], [LogisticColumn2], [LogisticColumn3], [LogisticColumn4], [LogisticColumn5], [LogisticColumn6], [LogisticColumn7], [LogisticColumn8], [LogisticColumn9], [LogisticColumn10], [LogisticColumn11], [LogisticColumn12], [LogisticColumn13], [LogisticColumn14], [LogisticColumn15], [LogisticColumn16], [LogisticColumn17], [LogisticColumn18], [LogisticColumn19], [LogisticColumn20], [LogisticCode],[SortNumber]) VALUES (4, N'出口易', 0, N'http://yewu.chukou1.cn/client/ws/v2.1/ck1.asmx', N'http://api.chukou1.cn/v3/system/tracking/get-tracking',NULL, NULL,NULL, 'http://api.chukou1.cn/v3/direct-express/package/print-label', NULL, NULL, NULL, NULL, NULL, NULL, N'FileData/LogisticLogo/chukou1.jpg', N'http://www.chukou1.com/', NULL, N'出口易依托多年丰富的电子商务卖家经验和技术的创新能力，专注于为客户提供小包、专线、快递、海外仓储、订单管理、货源分销及其售前售后服务的全程物流服务。', NULL, NULL, NULL, NULL, N'ChuKou1',0)
INSERT [dbo].[ErpLogistic] ([LogisticId], [LogisticName], [StatusCode], [LogisticColumn1], [LogisticColumn2], [LogisticColumn3], [LogisticColumn4], [LogisticColumn5], [LogisticColumn6], [LogisticColumn7], [LogisticColumn8], [LogisticColumn9], [LogisticColumn10], [LogisticColumn11], [LogisticColumn12], [LogisticColumn13], [LogisticColumn14], [LogisticColumn15], [LogisticColumn16], [LogisticColumn17], [LogisticColumn18], [LogisticColumn19], [LogisticColumn20], [LogisticCode],[SortNumber]) VALUES (5, N'互联易', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'FileData/LogisticLogo/ICE.png', N'http://www.szice.net/', NULL, N' 深圳市互联易电子商务服务有限公司是一家国际快递物流、电商仓储、ERP系统开发、海外代购、进口业务、海外仓等为一体的集团公司。', NULL, NULL, NULL, NULL, N'ICE',0)
INSERT [dbo].[ErpLogistic] ([LogisticId], [LogisticName], [StatusCode], [LogisticColumn1], [LogisticColumn2], [LogisticColumn3], [LogisticColumn4], [LogisticColumn5], [LogisticColumn6], [LogisticColumn7], [LogisticColumn8], [LogisticColumn9], [LogisticColumn10], [LogisticColumn11], [LogisticColumn12], [LogisticColumn13], [LogisticColumn14], [LogisticColumn15], [LogisticColumn16], [LogisticColumn17], [LogisticColumn18], [LogisticColumn19], [LogisticColumn20], [LogisticCode],[SortNumber]) VALUES (6, N'顺友', 0, N'http://api.sunyou.hk/order/create_order.htm', N'http://www.sunyou.hk/api/find_order.htm', N'http://www.sunyou.hk/api/shiptype_list.htm',NULL,'Tf8zhvm47DuxW583i9jEOw==', 'http://www.sunyou.hk/api/obtaintoken.htm', 'http://www.sunyou.hk/api/download_label.htm', NULL, NULL, NULL, NULL, NULL, N'FileData/LogisticLogo/SUNYOU.gif', N'http://www.sunyou.hk/', NULL, N'业务范围包括顺邮宝专线、各国邮政小包、全球速递以及全球仓储及订单处理服务，讲诚信、重服务是顺友不变的态度。', NULL, NULL, NULL, NULL, N'SunYou',0)
INSERT [dbo].[ErpLogistic] ([LogisticId], [LogisticName], [StatusCode], [LogisticColumn1], [LogisticColumn2], [LogisticColumn3], [LogisticColumn4], [LogisticColumn5], [LogisticColumn6], [LogisticColumn7], [LogisticColumn8], [LogisticColumn9], [LogisticColumn10], [LogisticColumn11], [LogisticColumn12], [LogisticColumn13], [LogisticColumn14], [LogisticColumn15], [LogisticColumn16], [LogisticColumn17], [LogisticColumn18], [LogisticColumn19], [LogisticColumn20], [LogisticCode],[SortNumber]) VALUES (7, N'燕文', 0, N'http://online.yw56.com.cn/service', N'NULL', N'NULL', NULL,NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'FileData/LogisticLogo/yanwen.png', N'http://www.yw56.com.cn/index.aspx', N'4008-900-156 ', N'燕文物流是eBay中国，敦煌网，阿里巴巴,PAYPAL等知名平台的推荐国际物流服务商，也是众多网上卖家共同的选择。', NULL, NULL, NULL, NULL, N'YANWEN',140)
INSERT [dbo].[ErpLogistic] ([LogisticId], [LogisticName], [StatusCode], [LogisticColumn1], [LogisticColumn2], [LogisticColumn3], [LogisticColumn4], [LogisticColumn5], [LogisticColumn6], [LogisticColumn7], [LogisticColumn8], [LogisticColumn9], [LogisticColumn10], [LogisticColumn11], [LogisticColumn12], [LogisticColumn13], [LogisticColumn14], [LogisticColumn15], [LogisticColumn16], [LogisticColumn17], [LogisticColumn18], [LogisticColumn19], [LogisticColumn20], [LogisticCode],[SortNumber]) VALUES (8, N'自定义物流商',0, N'', N' ', N'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'FileData/LogisticLogo/Customize.png', 'http://www.sumool.com/', '0755-23599551', '自定义物流商，用户可以自定义物流方式，使用自定义地址标签，填写或使用跟踪号码池的跟踪号。', NULL, NULL, NULL, NULL, N'Customize',120)
--EBAY物流未开发完暂时不开放INSERT [dbo].[ErpLogistic] ([LogisticId], [LogisticName], [StatusCode], [LogisticColumn1], [LogisticColumn2], [LogisticColumn3], [LogisticColumn4], [LogisticColumn5], [LogisticColumn6], [LogisticColumn7], [LogisticColumn8], [LogisticColumn9], [LogisticColumn10], [LogisticColumn11], [LogisticColumn12], [LogisticColumn13], [LogisticColumn14], [LogisticColumn15], [LogisticColumn16], [LogisticColumn17], [LogisticColumn18], [LogisticColumn19], [LogisticColumn20], [LogisticCode],[SortNumber]) VALUES (9, N'Ebay亚太物流', 0, N'https://api.apacshipping.ebay.com.hk/aspapi/v4/ApacShippingService', NULL, NULL,NULL, NULL, NULL,NULL,NULL, NULL, NULL, NULL, NULL, N'FileData/LogisticLogo/ebay.png', N'https://apacshipping.ebay.com.hk/aspweb/login', NULL, N'Ebay亚太物流', NULL, NULL, NULL, NULL, N'EbayAPAC',0)
INSERT [dbo].[ErpLogistic] ([LogisticId], [LogisticName], [StatusCode], [LogisticColumn1], [LogisticColumn2], [LogisticColumn3], [LogisticColumn4], [LogisticColumn5], [LogisticColumn6], [LogisticColumn7], [LogisticColumn8], [LogisticColumn9], [LogisticColumn10], [LogisticColumn11], [LogisticColumn12], [LogisticColumn13], [LogisticColumn14], [LogisticColumn15], [LogisticColumn16], [LogisticColumn17], [LogisticColumn18], [LogisticColumn19], [LogisticColumn20], [LogisticCode],[SortNumber]) VALUES (10, N'速卖通线上', 0, N'http://gw.api.alibaba.com', NULL, NULL, NULL,NULL,NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'FileData/LogisticLogo/AliExpress.png', N'http://seller.aliexpress.com/so/freight.php', NULL, N'速卖通线上', NULL, NULL, NULL, NULL, N'AliExpress',100)
INSERT [dbo].[ErpLogistic] ([LogisticId], [LogisticName], [StatusCode], [LogisticColumn1], [LogisticColumn2], [LogisticColumn3], [LogisticColumn4], [LogisticColumn5], [LogisticColumn6], [LogisticColumn7], [LogisticColumn8], [LogisticColumn9], [LogisticColumn10], [LogisticColumn11], [LogisticColumn12], [LogisticColumn13], [LogisticColumn14], [LogisticColumn15], [LogisticColumn16], [LogisticColumn17], [LogisticColumn18], [LogisticColumn19], [LogisticColumn20], [LogisticCode],[SortNumber]) VALUES (11, N'顺邮', 0, N'http://www.sunyou56.com/api/shipping.asmx',NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, N'FileData/LogisticLogo/sunyou56.jpg', N'http://www.sunyou56.com/', NULL, N'德国邮政、马来西亚邮政、香港邮政、中国邮政、瑞士邮政一级代理，绝对庄家。专业服务于国内从事eBay、亚马逊及速卖通等网络平台销售的国际外贸卖家。', NULL, NULL, NULL, NULL, N'SunYou56',0)
SET IDENTITY_INSERT [dbo].[ErpLogistic] OFF
/*关于物流商接口参数调整 tutu 2015-6-8 end */

/*物流方式 2015-6-9 tutu*/

--Start 4px
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'C1','中国EMS国际','CHINA EMS',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'C2','香港邮政EMS','HK EMS',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'A1','DHL出口','HK DHL',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'A2','4PX标准专线 ','4PX  Express',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'C4','香港空邮包裹 ','HK AIR POST',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'B1','新加坡小包挂号  ','Singapo SPack IMAIR',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'B2','新加坡小包平邮','Singapore PY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'A6','4PX联邮通挂号','LYT GH',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'A7','4PX联邮通平邮','LYT PY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'D2','香港TNT特惠','TNT HK',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'A4','4PX专线ARMX','4PX ARMX',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'E2','联邮通空邮包裹服务','LYT GSS',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'H3','4PX香港件','4PXABKR',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'H4','香港TNT出口','TNT',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'S1','中国EMS外围','CNEMSWW',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'E9','北京小包挂号','BJXBGH',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'E8','北京小包平邮','BJXBPY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'E4','香港联邦IP','HKFEDIP',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'F3','华南小包平邮','HNXBPY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'F4','华南小包挂号','HNXBGH',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'R2','订单宝海运','OCEAN－FRE',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'F2','订单宝空运','DDBAIR',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'R1','订单宝普货空运 ','AIR－FRE',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'R3','海外仓储中转','OST',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'K6','4PX进口','IMP',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'H5','亚马逊FBA头程配送','YMXFBA',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'E6','香港联邦特惠IP','HKFEDTHIP',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'E7','香港联邦特惠IE','HKFEDTHIE',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'I4','上海DHL','SHCFDHL',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'I8','北京DHL小货','BJDHL-A',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'I9','北京DHL大货','BJDHL-B',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'A5','DHL华东超值大货','DHL EastChina Heavy',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'A8','敦豪华东优惠','DHLExport China East',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'AH','YT澳邮小包平邮','YTMAUPY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'A3','敦豪包裹特惠','DHL Economy Service',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'C3','新加坡EMS','SG EMS',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'E5','香港联邦IE','HKFEDIE',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'AL','中邮小包挂号(宁波)','NBXBGH',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'AM','4PX英国跟踪服务','4PX  Tracking',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'L2','境外取件','JWQJ',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'AN','香港进口派送','HKIMP',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'B7','广州小包挂号','GZXBGH',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'B8','广州小包平邮','GZXBPY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'K4','中港散货','4PXZG',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'S2','中国小包挂号(华东外围)','CNPTGHHD',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'E3','杭州小包挂号','HZXBGH',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'J2','济南小包平邮','PTQDPY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'B3','香港小包挂号','HKGH',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'B4','香港小包平邮','HKPY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'BA','俄罗斯联邮通挂号','RU POST-LINK RMAIL',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'AZ','俄罗斯联邮通平邮','RU POST-LINK OMAIL',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'AY','巴西E通','Brazil Rmail Plus',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'BB','欧洲小包特惠','OZXBTH',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'BC','美E通','US EPAC',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'D5','香港UPS','UPS Export HK',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'AO','4PX专线特选','4PXTX',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'H9','中邮小包平邮(温州)','WZXBPY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'AI','4PX专线优选','4PXYX',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'BF','印尼E通','ID E-PAC',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'B9','中邮小包挂号(上海)','ShangHai GH',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'AX','敦豪小包挂号','GMP+',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'AW','敦豪小包平邮','GMP',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'BJ','青岛邮政小包挂号','QDPTGH',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'I3','中邮小包挂号(福建)','FJXBGH',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'C9','杭州小包平邮','HZXBPY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'BN','中邮小包平邮(福建)','FJXBPY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode], [DeclarationTemCode]) VALUES  (1,'BO','天津邮政小包平邮','PTTJPY',0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL,'4PX_AT1','4PX_DT1')
--End 4px

/*End*/
--三态
/*Start 三态*/
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'AUEXP', N'三态中澳专线', N'Australia Express Line', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'CNAM', N'中国邮政小包(平邮)', N'Air Mail by China Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'CNDHL', N'中国DHL', N'DHL in China', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'CNFEDEX', N'中国FedEx优先型', N'Fedex International Priority Service in China', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'CNRAM', N'中国邮政小包(挂号)', N'Registered Air Mail by China Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'CNSFEDEX', N'中国FedEx经济型', N'Fedex International Economy Service in China', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'CNUPS', N'中国UPS', N'UPS in China', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'DEAM2', N'德国邮政小包（平邮)', N'Air Mail by Deutsch Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'DERAM2', N'德国邮政小包（挂号）', N'Registered Air Mail by Deutsch Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'EMSSE', N'国内EMS标准快递', N'EMSSE', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'EUEXP1', N'三态中欧专线一级服务', N'Europe Express Line 1', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'EUEXP2', N'三态中欧专线二级服务', N'Europe Express Line 2', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'HKBAM', N'香港邮政小包(平邮)', N'Bulk Air Mail by Hongkong Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'HKBRAM', N'香港邮政小包(挂号)', N'Registered Bulk Air Mail by Hongkong Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'HKDHL', N'香港DHL', N'DHL in HongKong', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'HKDHL1', N'香港DHL1', N'DHL1 in HongKong', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'HKUPS', N'香港UPS', N'UPS in Hongkong', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SFCQM1', N'快邮小包一级平邮', N'Air Mail by UK Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SFCQM1R', N'快邮小包一级挂号', N'Registered Air Mail by UK Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SFCQM2', N'快邮小包二级平邮', N'Air Mail by Belgium Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SFCQM2R', N'快邮小包二级挂号', N'Registered Air Mail by Belgium Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SFCQM3', N'快邮三级小包（平邮）', N'SFCQM3', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SFCQM3R', N'快邮三级小包（挂号）', N'SFCQM3R', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SFCQMUS', N'快邮美国小包', N'Air Mail by US Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SGAM', N'新加坡邮政小包(平邮)', N'Air Mail by Singapore Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SGEMS', N'新加坡EMS', N'Express Mail Service by Singapore Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SGRAM', N'新加坡邮政小包(挂号)', N'Registered Air Mail by Singapore Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SWBAM', N'瑞士邮政小包（平邮）', N'Bulk Air Mail by Swiss Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SWBRAM', N'瑞士邮政小包（挂号）', N'Registered Bulk Air Mail by Swiss Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'SZEMS', N'中国EMS', N'Express Mail Service by Shenzhen Branch Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'UKFREIGHT', N'英国仓储', N'UK WAREHOUSE', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'WWAM', N'中国邮政外围小包(平邮)', N'WWAM', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'WWRAM', N'中国邮政外围小包(挂号)', N'WWRAM', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'AIR', N'德国仓储空运', N'Air Shipping for DE Warehouse Fulfillment', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'FREXP', N'法国专线', N'FR Express Line', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'HKEMS', N'香港EMS', N'Express Mail Service by Hong Kong Post', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'OCEAN', N'海外仓储海运', N'OCEAN', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'RUEXP', N'俄罗斯专线', N'RU Express Line', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (3, N'USEXP', N'美加专线', N'US and CA Express Line', 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SFC_AT1','SFC_DT1') 
/*End 三态*/
GO
/*Start 出口易*/
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CND', N'大陆DHL', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'HKD', N'香港DHL', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'EMI', N'省内EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'EMP', N'省外EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'EMS', N'国际EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'HKE', N'香港EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'UPS', N'香港UPS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CNE', N'国内快递', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CNI', N'中邮小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CRI', N'中邮小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CRN', N'省外中邮挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'EUB', N'美国E邮宝', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'HBM', N'香港小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'HTM', N'香港小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'SGO', N'新加坡小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'SGP', N'新加坡小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CRU', N'俄罗斯快线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CRS', N'俄罗斯专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CAP', N'中邮大包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CAN', N'中澳专线平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CAT', N'中澳专线挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CEN', N'中英专线平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CET', N'中英专线挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CEF', N'英国快线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CFE', N'中法专线平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CIE', N'中意专线平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CJP', N'中日专线挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CUN', N'欧陆通平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CUT', N'欧陆通挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'CUE', N'中美专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'MEP', N'中东专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'SAP', N'东南亚专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(4, N'UEE', N'美国经济专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ChuKou1_AT1','ChuKou1_DT1') 
/*End 出口易*/
GO
--Start互联易
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKPOSTPYGH', N'香港平邮挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNUPS', N'CNUPS蓝单', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKDHL', N'香港DHL代理价', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKY-DHL-A', N'香港DHL-A价', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-DHL-H', N'香港DHL-H', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RDXBGHH', N'DHL小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CN-DHL', N'大陆DHL小货价', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-DHL-TH', N'大陆DHL小货促销价', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RDXBGHI', N'DHL小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-UPS-F', N'香港UPS欧美-F价', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKUPS', N'香港UPS代理价', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'FBAKY', N'FBA（空运）', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'FBAKYMG', N'FBA（空运）美国', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-FEDEX-IE', N'香港联邦IE代理价', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-FEDEX-IP', N'香港联邦IP代理价', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-FEDEX-F', N'香港联邦-F价', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKARAMEX', N'香港ARAMEX', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'SZEMS', N'深圳EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'GDEMS', N'广东EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'GJETK', N'E特快', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'EYBA', N'线下E邮宝(美国)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'EYB', N'e邮宝', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'EYBGZ', N'e邮宝(广州)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'AU-EYB-B', N'线下E邮宝(澳洲)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'AU-EYB', N'澳洲E邮宝', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'EYB-GB-B', N'线下E邮宝(英国)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKPOSTPB', N'英国E邮宝', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-EYB', N'香港E邮宝', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CA-EYB-B', N'线下e邮宝(加拿大)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CA-EYB', N'加拿大E邮宝', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'EYB-FR-B', N'线下e邮宝(法国)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CN-DHL-MY', N'法国E邮宝', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'EYB-RU', N'线上e邮宝(俄罗斯)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'EYB-RU-B', N'线下e邮宝(俄罗斯)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'MY-EMS', N'马来西亚邮政EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'SGEMS', N'新加坡EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKEMS', N'香港EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'DX-HK-DB', N'DX香港大包裹', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKDB', N'香港邮政大包裹', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-PPSM', N'香港邮政大包裹平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKPOSTPM', N'香港本地包裹服务', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTAIR-GZ', N'中国邮政航空大包(广州)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTAIR', N'中国邮政航空大包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTSUR-GZ', N'中国邮政水陆路大包(广州)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTSUR', N'中国邮政水陆路大包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTSAL-GZ', N'中国邮政空运水陆大包(广州)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTSAL', N'中国邮政空运水陆大包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'SZCNPOSTGH', N'SZ邮政小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'SZCNPOSTPY', N'SZ邮政小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTGH-SZ', N'中国邮政航空小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTPY-SZ', N'中国邮政平邮小包特价', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTPY-GD', N'中国邮政平邮小包特价(广东)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTGH-NJ', N'中国邮政航空小包挂号(广东)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HNCNPOSTGH', N'中国邮政航空小包挂号(华南)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HNCNPOSTPY-HN', N'中国邮政平邮小包特价(华南)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTGH-FJ', N'中国邮政航空小包挂号(福建)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTPY-FJ', N'中国邮政平邮小包特价(福建)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CN-UPS-HD', N'中国邮政平邮小包特价(ZJ)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTGH-GZ', N'中国邮政航空小包挂号(GZ)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RSGHPS', N'省外中邮小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-UPS-LDTH', N'省外中邮小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'US-ZX', N'美国专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKPOSTPGM', N'澳洲专线(挂号)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'AUEMS', N'澳洲专线(平邮)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HLYZX', N'互联易专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTRU', N'俄罗斯专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'SHKE-EYB', N'SHKE邮宝', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKPOSTTH', N'香港小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'FBATCHY', N'FBA头程（海运）', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'MYA', N'马来西亚小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'MY', N'马来西亚小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'MY-HY', N'马邮(海邮)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RDXBGHG', N'瑞典小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RDXBGHC', N'瑞典小包平邮(电池)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RDXBGHB', N'瑞典小包挂号(电池)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RDXBGHA', N'瑞典小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RDXBGHF', N'荷兰小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HLXB', N'荷兰小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTRUXB', N'俄罗斯小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTRUXB-XJ', N'俄罗斯小包(新疆)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RDXB', N'俄罗斯专线小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RUZXXB', N'RU专线小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'DLEMS', N'DLEMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-E', N'香港进口E特快', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-EI-EI', N'香港快件进口(经济快递)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-EI-SZ', N'香港快件进口(深圳)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-EI-GUGOYW', N'香港快件进口(省内)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-EI-SE', N'香港快件进口(标快)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-TNT-F', N'香港TNT-F价', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'TNT', N'深圳TNT', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'SF', N'顺风', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'ZGKD', N'中港快件', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CKGG', N'出口过港', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'WCCKJ', N'国外仓储快件', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'C-AIR1', N'空运航线一', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'GNYS', N'国内运输', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HWTJ', N'海外退件', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-SF', N'香港顺丰', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKPOSTPY', N'香港空邮小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKPOSTG1', N'香港一级挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RSPOSTPY', N'瑞士小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RSPOSTGH', N'瑞士小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'JPPOSTPY', N'新小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'XJPPOSTGH', N'新小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'RYB', N'瑞邮宝平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'ZT', N'自提', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HKPOSTPG', N'香港大量投寄空邮平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'HK-TJY', N'香港投寄易', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'DPD-RPX', N'欧洲专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(5, N'CNPOSTPY-GZ', N'中国邮政平邮小包特价(GZ)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'ICE_AT1','ICE_DT1') 
--End互联易
--Start顺友
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'HKBRAM', N'香港小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'CNAM', N'中邮小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'HKBAM', N'香港小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'CNRAM', N'中邮小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'SWBAM', N'瑞士小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'SWBRAM', N'瑞士小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'RUAM', N'中俄专线平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'RURAM', N'中俄专线挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'GBAM1P', N'中英专线平邮一级包裹', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'GBRAM1P', N'中英专线挂号一级包裹', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'GBAM2P', N'中英专线平邮二级包裹', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'GBRAM2P', N'中英专线挂号二级包裹', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'GBAM1L', N'中英专线平邮一级信封', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'GBRAM1L', N'中英专线挂号一级信封', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'GBAM2L', N'中英专线平邮二级信封', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'GBRAM2L', N'中英专线挂号二级信封', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'SERAM', N'瑞典小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'BJRAM', N'北京小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'DGMAM', N'德国小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'DGMRAM', N'德国小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'DEAM', N'中德专线平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'DERAM', N'中德专线挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'USRAM', N'中美专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'SYBAM', N'顺邮宝平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(6, N'SYBRAM', N'顺邮宝挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou_AT1','SunYou_DT1') 
--End 顺友
GO
/*Start燕文 2015-6-10*/
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'3', N'北京EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'5', N'大陆DHL', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'6', N'香港UPS速快', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'7', N'大陆TNT', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'12', N'中邮大包(航空)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'14', N'新加坡邮政平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'24', N'香港邮政平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'25', N'燕文欧洲专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'30', N'燕文美国专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'31', N'英国YODEL专线(标准)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'32', N'英国YODEL专线(不含电小包)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'34', N'燕文中东专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'36', N'燕文澳洲专线', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'45', N'香港DHL', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'101', N'比利时邮政平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'102', N'比利时邮政挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'103', N'德国邮政挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'104', N'德国邮政平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'105', N'中邮北京平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'106', N'新加坡邮政挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'107', N'香港邮政挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'112', N'中邮绥芬河标快', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'113', N'中邮绥芬河大包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'118', N'上海EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'120', N'中邮大包(海运)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'121', N'中邮大包(SAL)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'122', N'苏州EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'131', N'英国邮政一等挂号小包(轻薄)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'132', N'英国邮政一等平邮小包(轻薄)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'133', N'英国邮政二等挂号小包(轻薄)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'134', N'英国邮政二等平邮小包(轻薄)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'135', N'英国邮政一等挂号小包(标准)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'136', N'英国邮政一等平邮小包(标准)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'137', N'英国邮政二等挂号小包(标准)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'138', N'英国邮政二等平邮小包(标准)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'139', N'香港FedEx经济', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'140', N'燕邮宝挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'141', N'燕邮宝平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'143', N'中邮北京挂号小包(俄罗斯水陆路)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'144', N'荷兰邮政挂号小包(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'145', N'大陆FedEx经济', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'146', N'瑞士邮政挂号小包(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'147', N'瑞士邮政一等平邮小包(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'148', N'瑞士邮政二等平邮小包(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'149', N'瑞士邮政挂号小包(不含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'150', N'瑞士邮政一等平邮小包(不含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'151', N'瑞士邮政二等平邮小包(不含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'152', N'瑞典邮政挂号小包(不含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'153', N'瑞典邮政平邮小包(不含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'154', N'中邮北京挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'155', N'中邮上海E邮宝(线下)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'156', N'中邮上海E特快', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'158', N'燕特快', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'159', N'英国YODEL专线(含电小包)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'227', N'马来西亚邮政挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'228', N'马来西亚邮政平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'163', N'中邮苏州E邮宝(线下)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'164', N'中邮青岛挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'165', N'中邮南京挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'166', N'中邮上海挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'167', N'中邮广州挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'168', N'中邮广州平邮小包(专用)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'169', N'中邮深圳挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'170', N'中邮天津挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'171', N'昆山EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'172', N'中邮扬州E邮宝(线下)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'173', N'广州EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'174', N'荷兰邮政挂号小包(不含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'175', N'立陶宛邮政挂号小包(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'176', N'立陶宛邮政平邮小包(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'177', N'立陶宛邮政挂号小包(不含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'178', N'立陶宛邮政平邮小包(不含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'179', N'瑞典邮政挂号小包(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'180', N'瑞典邮政平邮小包(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'181', N'荷兰邮政平邮小包(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'182', N'荷兰邮政平邮小包(不含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'183', N'中邮新疆挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'184', N'中邮郑州挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'185', N'匈牙利邮政挂号小包(不含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'186', N'匈牙利邮政平邮小包(不含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'187', N'济南EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'188', N'中邮浙江挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'189', N'中邮上海平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'190', N'中邮深圳平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'191', N'中邮南京平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'192', N'中邮郑州平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'193', N'中邮浙江平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'195', N'中邮黑河挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'196', N'上海EMS(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'197', N'中邮北京E邮宝(线下)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'198', N'中邮济南E邮宝(线下)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'199', N'中邮天津平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'200', N'中邮江苏挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'201', N'中邮天津挂号小包(深圳专用)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'202', N'中邮杭州挂号小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'203', N'匈牙利邮政挂号小包(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'204', N'匈牙利邮政平邮小包(含电)', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'205', N'中邮杭州平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'206', N'中邮江苏平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'207', N'西班牙邮政平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'208', N'燕电通平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'209', N'中邮新疆平邮小包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES  
(7, N'210', N'燕电通挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'YANWEN_AT1','YANWEN_DT1') 
GO
/*End燕文 2015-6-10*/--Start亚太物流
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL]) VALUES  
(9, N'CNPOST', N'CNPOST', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL) 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL]) VALUES  
(9, N'FEDEX', N'FEDEX', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'N', NULL, 0, NULL, NULL) 

--End亚太物流
GO
/*End 物流方式 tutu 2015-6-9*/



/*初始化物流模板 2015-6-8 end */

--start HgColumnOption加备注类型数据 2015-06-18
INSERT INTO HgColumnOption(TableName, ColumnName, OptionValue, TableTitle, ColumnTitle, OptionTitle, ParentValue, AllowEdit, OrderNo) 
values('ErpOrderDetail', 'OrderCommentType', 'Picking', '订单明细表', '备注类型', '拣货备注', '', 0, 1)

INSERT INTO HgColumnOption(TableName, ColumnName, OptionValue, TableTitle, ColumnTitle, OptionTitle, ParentValue, AllowEdit, OrderNo) 
values('ErpOrderDetail', 'OrderCommentType', 'Custom', '订单明细表', '备注类型', '客服备注', '', 0, 2)
go
--end
--Begin: Rick 2015-06-23 添加服务项管理功能--
IF NOT EXISTS(SELECT * FROM HgTaskType WHERE TypeCode='SyncOrder')
	INSERT [dbo].[HgTaskType] ([TypeCode], [TypeName], [Component], [TaskOption1], [TaskOption2], [TaskOption3], [TaskOption4], [TaskOption5], [Remarks]) VALUES (N'SyncOrder', N'同步订单', N'hg.service.plugin.order', NULL, NULL, NULL, NULL, NULL, NULL)
IF NOT EXISTS(SELECT * FROM HgTaskType WHERE TypeCode='SyncSiteMessage')
	INSERT [dbo].[HgTaskType] ([TypeCode], [TypeName], [Component], [TaskOption1], [TaskOption2], [TaskOption3], [TaskOption4], [TaskOption5], [Remarks]) VALUES (N'SyncSiteMessage', N'同步站内信', N'hg.service.plugin.sitemessage', NULL, NULL, NULL, NULL, NULL, N'仅支持速卖通')
GO

IF NOT EXISTS(SELECT * FROM HgColumnOption WHERE TableName='TaskSyncOrder' and ColumnName='TaskOption1' and  OptionValue='NewOrder' )
	INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'TaskSyncOrder', N'TaskOption1', N'NewOrder', N'订单同步任务选项', N'同步订单范围', N'仅同步新增的订单', NULL, 0, 1)
IF NOT EXISTS(SELECT * FROM HgColumnOption WHERE TableName='TaskSyncOrder' and ColumnName='TaskOption1' and  OptionValue='MofityOrder' )
	INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'TaskSyncOrder', N'TaskOption1', N'MofityOrder', N'订单同步任务选项', N'同步订单范围', N'同步所有变更的订单', NULL, 0, 2)
GO
--End: Rick 2015-06-23 添加服务项管理功能--

--amazon接口初始化
--amazon
IF NOT EXISTS(SELECT * FROM HgMenu WHERE MenuCode='erp_amazon_api_setting')
	INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'erp_amazon_api_setting', N'Amazon接口设置', 2, 3, NULL, N'hg_businessplatform_setting', N'Common/SysSetting/AmazonApi', N'glyphicon glyphicon-cog', 1)
GO
IF NOT EXISTS(SELECT * FROM HgPermission WHERE PermissionCode='erp_amazon_api_setting')
	INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_amazon_api_setting', N'Amazon接口设置',null, null, N'hg_businessplatform_setting', 1, NULL)
GO
IF NOT EXISTS(SELECT * FROM HgPermission WHERE PermissionCode='erp_amazon_api_setting_edit')
	INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'erp_amazon_api_setting_edit', N'编辑Amazon接口设置', N'Common', N'AmazonApiSysSetting', N'erp_amazon_api_setting', 2, NULL)
GO

if not exists(select * from HgSysSetting where SettingGroup='AmazonApi' and SettingKey='DeveloperAccessKey')
	INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AmazonApi', N'DeveloperAccessKey', N'开发者访问秘钥编码', N'AKIAJBBWO4PDVYNU6KTQ', 1, N'', 1, 2, N'注册开发者账号时返回的开发者访问秘钥编码')
GO
if not exists(select * from HgSysSetting where SettingGroup='AmazonApi' and SettingKey='DEVID')
	INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AmazonApi', N'DEVID', N'开发者账户编码', N'8854-5030-6882', 1, N'', 1, 3, N'注册亚马逊开发者时返回的编码')
GO

if not exists(select * from HgSysSetting where SettingGroup='AmazonApi' and SettingKey='DeveloperKey')
	INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AmazonApi', N'DeveloperKey', N'开发者秘钥', N'hlc4iH208Bb1cii9/R+1uLn5vtzphE0xss09ZSba', 1, N'', 1, 4, N'注册开发者账号时返回的开发者秘钥')
GO

--Begin: Jockey 2015-06-24 添加亚马逊订单状态--
 if not exists(select * from HgColumnOption where TableName='AmazonAPI' and ColumnName='OrderStatus' and OptionValue='Canceled ')
	INSERT [dbo].HgColumnOption ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AmazonAPI', N'OrderStatus', N'Canceled', N'亚马逊订单', N'订单状态', N'订单已取消', null, 0,7)
GO
  if not exists(select * from HgColumnOption where TableName='AmazonAPI' and ColumnName='OrderStatus' and OptionValue='InvoiceUnconfirmed ')
	INSERT [dbo].HgColumnOption ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AmazonAPI', N'OrderStatus', N'InvoiceUnconfirmed', N'亚马逊订单', N'订单状态', N'已发货但未寄出发票', null, 0,6)
GO
  if not exists(select * from HgColumnOption where TableName='AmazonAPI' and ColumnName='OrderStatus' and OptionValue='PendingAvailability')
	INSERT [dbo].HgColumnOption ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AmazonAPI', N'OrderStatus', N'PendingAvailability', N'亚马逊订单', N'订单状态', N'预定订单', null, 0,1)
GO
  if not exists(select * from HgColumnOption where TableName='AmazonAPI' and ColumnName='OrderStatus' and OptionValue='Pending')
	INSERT [dbo].HgColumnOption ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AmazonAPI', N'OrderStatus', N'Pending', N'亚马逊订单', N'订单状态', N'未付款', null, 0,2)
GO
  if not exists(select * from HgColumnOption where TableName='AmazonAPI' and ColumnName='OrderStatus' and OptionValue='Shipped')
	INSERT [dbo].HgColumnOption ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AmazonAPI', N'OrderStatus', N'Shipped', N'亚马逊订单', N'订单状态', N'已全部发货', null, 0,5)
GO
  if not exists(select * from HgColumnOption where TableName='AmazonAPI' and ColumnName='OrderStatus' and OptionValue='Unfulfillable')
	INSERT [dbo].HgColumnOption ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AmazonAPI', N'OrderStatus', N'Unfulfillable', N'亚马逊订单', N'订单状态', N'订单无法配送', null, 0,8)
GO
  if not exists(select * from HgColumnOption where TableName='AmazonAPI' and ColumnName='OrderStatus' and OptionValue='Unshipped,PartiallyShipped')
	INSERT [dbo].HgColumnOption ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'AmazonAPI', N'OrderStatus', N'Unshipped,PartiallyShipped', N'亚马逊订单', N'订单状态', N'已付款或已部分发货', null, 0,3)
GO
--End: Jockey 2015-06-24 添加亚马逊订单状态--


--Begin:Lopping 添加wish物流选项 2015-06-26
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'EMS (China)',N'物流方式表',N'Wish',N'EMS (China)',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'4PX',N'物流方式表',N'Wish',N'4PX',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'PayPalPackage',N'物流方式表',N'Wish',N'PayPalPackage',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'Post56',N'物流方式表',N'Wish',N'Post56',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'SREKorea',N'物流方式表',N'Wish',N'SREKorea',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'ChinaPost-WishPost',N'物流方式表',N'Wish',N'ChinaPost-WishPost',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'DHLSpainDomestic',N'物流方式表',N'Wish',N'DHLSpainDomestic',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'TransMission',N'物流方式表',N'Wish',N'TransMission',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'MagyarPosta',N'物流方式表',N'Wish',N'MagyarPosta',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'Exapaq',N'物流方式表',N'Wish',N'Exapaq',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'PostaPlus',N'物流方式表',N'Wish',N'PostaPlus',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'TeliwaySICExpress',N'物流方式表',N'Wish',N'TeliwaySICExpress',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'Packlink',N'物流方式表',N'Wish',N'Packlink',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'CNEExpress',N'物流方式表',N'Wish',N'CNEExpress',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'MyHermesUK',N'物流方式表',N'Wish',N'MyHermesUK',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'CanparCourier',N'物流方式表',N'Wish',N'CanparCourier',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'RAM',N'物流方式表',N'Wish',N'RAM',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'DHLExpress',N'物流方式表',N'Wish',N'DHLExpress',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'PanduLogistics',N'物流方式表',N'Wish',N'PanduLogistics',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'SpeedexCourier',N'物流方式表',N'Wish',N'SpeedexCourier',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'SpeedCourier',N'物流方式表',N'Wish',N'SpeedCourier',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'AsendiaGermany',N'物流方式表',N'Wish',N'AsendiaGermany',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'DMMNetwork',N'物流方式表',N'Wish',N'DMMNetwork',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'SGTCorriereEspresso',N'物流方式表',N'Wish',N'SGTCorriereEspresso',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'NationwideExpress',N'物流方式表',N'Wish',N'NationwideExpress',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'GlobegisticsInc',N'物流方式表',N'Wish',N'GlobegisticsInc',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'DACHSER',N'物流方式表',N'Wish',N'DACHSER',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'Ecargo',N'物流方式表',N'Wish',N'Ecargo',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'DawnWing',N'物流方式表',N'Wish',N'DawnWing',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'CorreosExpress',N'物流方式表',N'Wish',N'CorreosExpress',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'FERCAM',N'物流方式表',N'Wish',N'FERCAM',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'JayonExpress',N'物流方式表',N'Wish',N'JayonExpress',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'DSV',N'物流方式表',N'Wish',N'DSV',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'SFInternational',N'物流方式表',N'Wish',N'SFInternational',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'ABXExpress',N'物流方式表',N'Wish',N'ABXExpress',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'KangarooWorldwideExpress',N'物流方式表',N'Wish',N'KangarooWorldwideExpress',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'ZJSExpress',N'物流方式表',N'Wish',N'ZJSExpress',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'Spreadel',N'物流方式表',N'Wish',N'Spreadel',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'AsendiaUK',N'物流方式表',N'Wish',N'AsendiaUK',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'APCOvernight',N'物流方式表',N'Wish',N'APCOvernight',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'BertTransport',N'物流方式表',N'Wish',N'BertTransport',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'DelivreeKing',N'物流方式表',N'Wish',N'DelivreeKing',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'CBLLogistics',N'物流方式表',N'Wish',N'CBLLogistics',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'Newgistics',N'物流方式表',N'Wish',N'Newgistics',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'EasyMail',N'物流方式表',N'Wish',N'EasyMail',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'LogisticWorldwideExpress',N'物流方式表',N'Wish',N'LogisticWorldwideExpress',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'FastrakServices',N'物流方式表',N'Wish',N'FastrakServices',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'Delcart',N'物流方式表',N'Wish',N'Delcart',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'FastwayNewZealand',N'物流方式表',N'Wish',N'FastwayNewZealand',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'NanjingWoyuan',N'物流方式表',N'Wish',N'NanjingWoyuan',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'UBILogisticsAustralia',N'物流方式表',N'Wish',N'UBILogisticsAustralia',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'YunExpress',N'物流方式表',N'Wish',N'YunExpress',NULL,1,1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'ErpLogisticMode',N'Wish',N'OTHER',N'物流方式表',N'Wish',N'OTHER',NULL,1,1)
--End:Lopping 添加wish物流选项 2015-06-26



--start sunyou56 2015-6-29
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'德国专线平邮', N'德国专线平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'俄罗斯大包', N'俄罗斯大包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'佛山中国邮政小包挂号', N'佛山中国邮政小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'佛山中国邮政小包平邮', N'佛山中国邮政小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'广州DHL', N'广州DHL', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'广州EMS', N'广州EMS', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'广州中国邮政小包挂号', N'广州中国邮政小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'广州中国邮政小包平邮', N'广州中国邮政小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'马来西亚邮政小包挂号', N'马来西亚邮政小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'马来西亚邮政小包平邮', N'马来西亚邮政小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'瑞士小包挂号', N'瑞士小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'瑞士小包平邮', N'瑞士小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'香港DHL', N'香港DHL', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'香港Fedex', N'香港Fedex', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'香港德邮小包挂号', N'香港德邮小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'东欧陆运小包挂号', N'东欧陆运小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'香港海运小包挂号', N'香港海运小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'香港德邮小包平邮', N'香港德邮小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'香港海运小包平邮', N'香港海运小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'香港小包挂号', N'香港小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'香港小包平邮', N'香港小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'新加坡德邮小包挂号', N'新加坡德邮小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'新加坡德邮小包平邮', N'新加坡德邮小包平邮', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'中港运输', N'中港运输', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'中国邮政大包', N'中国邮政大包', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
INSERT [dbo].[ErpLogisticMode] ([LogisticId], [LogisticModeCode], [LogisticMode], [LogisticModeEN], [IsActive], [Remarks], [Express], [EBay], [Wish], [Amazon], [LogisticModeColumn1], [LogisticModeColumn2], [LogisticModeColumn3], [LogisticModeColumn4], [LogisticModeColumn5], [LogisticModeColumn6], [LogisticModeColumn7], [LogisticModeColumn8], [LogisticModeColumn9], [LogisticModeColumn10], [CustomerAgreement], [PrintType], [HasTemplete], [ModeTextSize], [StoreId], [TrackingNumPoolId], [TrackingURL],[AddressTemCode],[DeclarationTemCode]) VALUES    (11, N'俄罗斯航空小包挂号', N'俄罗斯航空小包挂号', NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,'Y', NULL, 0, NULL, NULL,'SunYou56_AT1','SunYou56_DT1') 
--end sunyou56
--面单
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'德国专线平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_001/AT_001.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'东欧陆运小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_002/AT_002.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'俄罗斯大包', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_003/AT_003.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'佛山中国邮政小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_004/AT_004.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'佛山中国邮政小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_005/AT_005.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'广州DHL', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_006/AT_006.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'广州EMS', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_007/AT_007.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'广州中国邮政小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_008/AT_008.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'广州中国邮政小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_009/AT_009.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'马来西亚邮政小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_010/AT_010.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'马来西亚邮政小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_011/AT_011.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')


--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'瑞士小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_012/AT_012.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'瑞士小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_013/AT_013.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港DHL', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_014/AT_014.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港Fedex', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_015/AT_015.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港德邮小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_016/AT_016.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港德邮小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_017/AT_017.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港海运小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_018/AT_018.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港海运小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_019/AT_019.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_020/AT_020.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_021/AT_021.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'新加坡德邮小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_022/AT_022.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'新加坡德邮小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_023/AT_023.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'中港运输', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_024/AT_024.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'中国邮政大包', 0, N'默认模板', N'/FileData/LogisticTemplate/addresslabel/SunYou56/AT_025/AT_025.jpg', 0, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

----报关
----dt001
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'德国专线平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_001/DT_001.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
----dt002
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'佛山中国邮政小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_002/DT_002.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'俄罗斯大包', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_002/DT_002.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'东欧陆运小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_002/DT_002.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'中国邮政大包', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_002/DT_002.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'广州中国邮政小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_002/DT_002.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
----DT_003
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'广州中国邮政小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_003/DT_003.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
----DT_004
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'马来西亚邮政小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_004/DT_004.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'马来西亚邮政小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_004/DT_004.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
----DT_005
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'瑞士小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_005/DT_005.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'瑞士小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_005/DT_005.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港海运小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_005/DT_005.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_005/DT_005.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港海运小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_005/DT_005.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'广州EMS', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_005/DT_005.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
----DT_006
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港德邮小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_006/DT_006.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'香港德邮小包平邮', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_006/DT_006.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')
--INSERT [dbo].[ErpLogisticPrintTem] ([Title], [IsCustom], [Remark], [TemPath], [TemType], [Creator], [CreateTime], [Operator], [OperateTime],[LogisticCode]) VALUES ( N'新加坡德邮小包挂号', 0, N'默认模板', N'/FileData/LogisticTemplate/declarationlable/SunYou56/DT_006/DT_006.jpg', 1, N'管理员', GETDATE(), NULL, NULL,'SunYou56')

--End 顺邮物流模板信息 tutu 2015-7-6

--start 初始化一个默认仓库--bunny 2015-07-11
SET IDENTITY_INSERT [dbo].[ErpStore] ON
INSERT INTO [dbo].[ErpStore]([StoreId],[StoreNo],[StoreName],[StoreType],[IsActive],[ManageState])VALUES(1,N'S0001',N'默认仓库',N'自有仓',1,0)
INSERT INTO [dbo].[ErpShelfPosition]([StoreId],[ShelfPosition],[IsActive],[ShelfPositionType])VALUES(1,N'1',1,1)
--INSERT INTO [dbo].[ErpShelfPosition]([StoreId],[ShelfPosition],[IsActive],[ShelfPositionType])VALUES(1,N'2',1,0)
SET IDENTITY_INSERT [dbo].[ErpStore] OFF
--end 初始化一个默认仓库

--Begin：初始化ErpLogisticModeParam表，存放特殊物流商打印面单所需参数 Lopping 2015-07-15
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'US', N'美国', N'挂', N'挂11', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'GB', N'英国', N'挂', N'挂12', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'RU', N'俄罗斯', N'挂', N'挂13', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'BR', N'巴西', N'挂', N'挂14', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'AU', N'澳大利亚', N'挂', N'挂15', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'FR', N'法国', N'挂', N'挂16', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'CA', N'加拿大', N'挂', N'挂17', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'ES', N'西班牙', N'挂', N'挂18', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'DE', N'德国', N'挂', N'挂19', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'IL', N'以色列', N'挂', N'挂20', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'SE', N'瑞典', N'挂', N'挂21', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'NO', N'挪威', N'挂', N'挂22', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'AR', N'阿根廷', N'挂', N'挂23', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'UA', N'乌克兰', N'挂', N'挂24', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', NULL, N'其他', N'挂', N'挂1', N'B', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'US', N'美国', N'平', N'平7', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'GB', N'英国', N'平', N'平8', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'RU', N'俄罗斯', N'平', N'平9', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'BR', N'巴西', N'平', N'平10', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'AU', N'澳大利亚', N'平', N'平11', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'FR', N'法国', N'平', N'平12', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'CA', N'加拿大', N'平', N'平13', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'ES', N'西班牙', N'平', N'平14', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'DE', N'德国', N'平', N'平15', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'IL', N'以色列', N'平', N'平16', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'SE', N'瑞典', N'平', N'平17', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'NO', N'挪威', N'平', N'平18', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'AR', N'阿根廷', N'平', N'平19', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'UA', N'乌克兰', N'平', N'平20', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'NL', N'荷兰', N'平', N'平21', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'HU', N'匈牙利', N'平', N'平21', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'HR', N'克罗地亚', N'平', N'平21', N'A', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', NULL, N'其他', N'平', N'平1', N'B', NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'RU', N'俄罗斯', N'序', N'序1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'US', N'美国', N'序', N'序2', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'BR', N'巴西', N'序', N'序3', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'GB', N'英国', N'序', N'序4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'SE', N'瑞典', N'序', N'序5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'AU', N'澳大利亚', N'序', N'序6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'AR', N'阿根廷', N'序', N'序7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'UA', N'乌克兰', N'序', N'序8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'JP', N'日本', N'序', N'序9', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'IL', N'以色列', N'序', N'序10', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'CA', N'加拿大', N'序', N'序11', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'NO', N'挪威', N'序', N'序12', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'ES', N'西班牙', N'序', N'序13', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'FR', N'法国', N'序', N'序14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'DE', N'德国', N'序', N'序15', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'TR', N'土耳其', N'序', N'序16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'IT', N'意大利', N'序', N'序17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'FI', N'芬兰', N'序', N'序18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'BE', N'比利时', N'序', N'序19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'CL', N'智利', N'序', N'序20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'HR', N'克罗地亚', N'序', N'序21', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'CZ', N'捷克', N'序', N'序22', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'GR', N'希腊', N'序', N'序23', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'CT', N'台湾', N'序', N'序24', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'HU', N'匈牙利', N'序', N'序25', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'PT', N'葡萄牙', N'序', N'序26', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'IE', N'爱尔兰', N'序', N'序27', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'DK', N'丹麦', N'序', N'序28', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'NL', N'荷兰', N'序', N'序29', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'BY', N'白俄罗斯', N'序', N'序30', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'MX', N'墨西哥', N'序', N'序31', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'LV', N'拉脱维亚', N'序', N'序32', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'PL', N'波兰', N'序', N'序33', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'SK', N'斯洛伐克', N'序', N'序34', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'LT', N'立陶宛', N'序', N'序35', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'SG', N'新加坡', N'序', N'序36', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'AT', N'奥地利', N'序', N'序37', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'MT', N'马耳他', N'序', N'序38', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'EE', N'爱沙尼亚', N'序', N'序39', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', N'BG', N'保加利亚', N'序', N'序40', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'154', NULL, N'其他', N'序', N'序41', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'RU', N'俄罗斯', N'序', N'序1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'US', N'美国', N'序', N'序2', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'BR', N'巴西', N'序', N'序3', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'GB', N'英国', N'序', N'序4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'SE', N'瑞典', N'序', N'序5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'AU', N'澳大利亚', N'序', N'序6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'AR', N'阿根廷', N'序', N'序7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'UA', N'乌克兰', N'序', N'序8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'JP', N'日本', N'序', N'序9', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'IL', N'以色列', N'序', N'序10', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'CA', N'加拿大', N'序', N'序11', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'NO', N'挪威', N'序', N'序12', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'ES', N'西班牙', N'序', N'序13', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'FR', N'法国', N'序', N'序14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'DE', N'德国', N'序', N'序15', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'TR', N'土耳其', N'序', N'序16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'IT', N'意大利', N'序', N'序17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'FI', N'芬兰', N'序', N'序18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'BE', N'比利时', N'序', N'序19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'CL', N'智利', N'序', N'序20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'HR', N'克罗地亚', N'序', N'序21', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'CZ', N'捷克', N'序', N'序22', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'GR', N'希腊', N'序', N'序23', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'CT', N'台湾', N'序', N'序24', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'HU', N'匈牙利', N'序', N'序25', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'PT', N'葡萄牙', N'序', N'序26', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'IE', N'爱尔兰', N'序', N'序27', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'DK', N'丹麦', N'序', N'序28', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'NL', N'荷兰', N'序', N'序29', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'BY', N'白俄罗斯', N'序', N'序30', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'MX', N'墨西哥', N'序', N'序31', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'LV', N'拉脱维亚', N'序', N'序32', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'PL', N'波兰', N'序', N'序33', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'SK', N'斯洛伐克', N'序', N'序34', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'LT', N'立陶宛', N'序', N'序35', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'SG', N'新加坡', N'序', N'序36', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'AT', N'奥地利', N'序', N'序37', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'MT', N'马耳他', N'序', N'序38', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'EE', N'爱沙尼亚', N'序', N'序39', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', N'BG', N'保加利亚', N'序', N'序40', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'105', NULL, N'其他', N'序', N'序41', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'GB', N'英国', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'US', N'美国', N'分组号', N'2', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'FR', N'法国', N'分组号', N'3', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'CA', N'加拿大', N'分组号', N'4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'RU', N'俄罗斯', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'BR', N'巴西', N'分组号', N'6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'AU', N'澳大利亚', N'分组号', N'7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'SG', N'新加坡', N'分组号', N'8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'AR', N'阿根廷', N'分组号', N'9', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'HK', N'香港', N'分组号', N'10', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'JP', N'日本', N'分组号', N'11', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', N'KR', N'韩国', N'分组号', N'12', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'206', NULL, N'其他', N'分组号', N'13', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'164', N'RU', N'俄罗斯', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'164', N'US', N'美国', N'分组号', N'2', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'164', N'BR', N'巴西', N'分组号', N'3', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'164', N'GB', N'英国', N'分组号', N'4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'164', N'AU', N'澳大利亚', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'164', N'CA', N'加拿大', N'分组号', N'6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'164', N'BY', N'白俄罗斯', N'分组号', N'7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'164', N'FR', N'法国', N'分组号', N'8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'164', N'IL', N'以色列', N'分组号', N'9', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'164', N'ES', N'西班牙', N'分组号', N'10', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'164', NULL, N'其他', N'分组号', N'11', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'GB', N'英国', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'US', N'美国', N'分组号', N'2', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'DE', N'德国', N'分组号', N'3', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'FR', N'法国', N'分组号', N'4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'CA', N'加拿大', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'ES', N'西班牙', N'分组号', N'6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'IL', N'以色列', N'分组号', N'7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'IT', N'意大利', N'分组号', N'8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'RU', N'俄罗斯', N'分组号', N'9', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'NL', N'荷兰', N'分组号', N'10', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'BR', N'巴西', N'分组号', N'11', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'AU', N'澳大利亚', N'分组号', N'12', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'BY', N'白俄罗斯', N'分组号', N'13', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', N'UA', N'乌克兰', N'分组号', N'14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'165', NULL, N'其他', N'分组号', N'15', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'DE', N'德国', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'IT', N'意大利', N'分组号', N'2', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'FR', N'法国', N'分组号', N'3', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GB', N'英国', N'分组号', N'4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'US', N'美国', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AU', N'澳大利亚', N'分组号', N'6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BR', N'巴西', N'分组号', N'7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CL', N'智利', N'分组号', N'8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NL', N'荷兰', N'分组号', N'9', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'IL', N'以色列', N'分组号', N'10', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'ES', N'西班牙', N'分组号', N'11', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'UA', N'乌克兰', N'分组号', N'12', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BY', N'白俄罗斯', N'分组号', N'13', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CA', N'加拿大', N'分组号', N'14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'JP', N'日本', N'分组号', N'15', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SG', N'新加坡', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'IN', N'印度', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'KR', N'韩国', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TH', N'泰国', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MY', N'马来西亚', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'ID', N'印尼', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AT', N'奥地利', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BG', N'保加利亚', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SK', N'斯洛伐克', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CH', N'瑞士', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CZ', N'捷克', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GR', N'希腊', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'FI', N'芬兰', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BE', N'比利时', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'IE', N'爱尔兰', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PL', N'波兰', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PT', N'葡萄牙', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'DK', N'丹麦', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'LU', N'卢森堡', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'EE', N'爱沙尼亚', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'LT', N'立陶宛', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'RO', N'罗马尼亚', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SI', N'斯洛文尼亚', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MT', N'马耳他', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'LV', N'拉脱维亚', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BA', N'波黑', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'VN', N'越南', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PH', N'菲律宾', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PK', N'巴基斯坦', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'KZ', N'哈萨克斯坦', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CY', N'塞浦路斯', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'KP', N'朝鲜', N'分组号', N'18', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MN', N'蒙古', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TJ', N'塔吉克斯坦', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TM', N'土库曼斯坦', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'UZ', N'乌兹别克斯坦', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'KG', N'吉尔吉斯斯坦', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'LK', N'斯里兰卡', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PS', N'巴勒斯坦', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SY', N'叙利亚', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AZ', N'阿塞拜疆', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AM', N'亚美尼亚', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'OM', N'阿曼', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SA', N'沙特阿拉伯', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'QA', N'卡塔尔', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TR', N'土耳其', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NZ', N'新西兰', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'LA', N'老挝', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BD', N'孟加拉国', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'KH', N'柬埔寨', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MM', N'缅甸', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NP', N'尼泊尔', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BN', N'文莱', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BT', N'不丹', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MV', N'马尔代夫', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TP', N'东帝汶', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AE', N'阿联酋', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'JO', N'约旦', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BH', N'巴林', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AF', N'阿富汗', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'IR', N'伊朗', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'KW', N'科威特', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'YE', N'也门', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'IQ', N'伊拉克', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'LB', N'黎巴嫩', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TS', N'塞尔维亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AL', N'阿尔巴尼亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'IS', N'冰岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AD', N'安道尔', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'FO', N'法罗群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GI', N'直布罗陀', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'LI', N'列支敦士登', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MC', N'摩纳哥', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'ME', N'黑山', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MK', N'马其顿', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SM', N'圣马力诺', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'VA', N'梵蒂冈', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MD', N'摩尔多瓦', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GE', N'格鲁吉亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'斐济群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AS', N'美属萨摩亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'科科斯群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CK', N'库克群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'卡奔达', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CS', N'圣诞岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NC', N'新喀里多尼亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'FM', N'密克罗尼西亚联邦', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'南乔治亚岛和南桑威奇群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'赫德岛和麦克唐纳群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'英属印度洋领地', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'KI', N'基里巴斯', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'KN', N'圣基茨和尼维斯', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MH', N'马绍尔群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'US', N'北马里亚纳群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NF', N'诺福克岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NR', N'瑙鲁', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NU', N'纽埃', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PF', N'法属波利尼西亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PG', N'巴布亚新几内亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PN', N'皮特凯恩群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SB', N'所罗门群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'斯瓦尔巴群岛和扬马延岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'特里斯达库尼亚群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TF', N'法属南部领地', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TK', N'托克劳', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TO', N'汤加', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TV', N'图瓦卢', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'美属太平洋各群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'VU', N'瓦努阿图', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'WS', N'西萨摩亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GB', N'阿森松岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'加那利群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PT', N'亚速尔群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PT', N'马德拉群岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'约翰斯敦岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GU', N'关岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'帕劳', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'瓦利斯和富图纳', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'EG', N'埃及', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SD', N'苏丹', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MA', N'摩洛哥', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'DJ', N'吉布提', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'ET', N'埃塞俄比亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'KE', N'肯尼亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TN', N'突尼斯', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BI', N'布隆迪', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'UG', N'乌干达', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'RW', N'卢旺达', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TD', N'乍得', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NG', N'尼日利亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BF', N'布基纳法索', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BJ', N'贝宁', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CM', N'喀麦隆', N'分组号', N'19', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'DZ', N'阿尔及利亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GA', N'加蓬', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GN', N'几内亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MG', N'马达加斯加', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MR', N'毛里塔尼亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'ZW', N'津巴布韦', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AO', N'安哥拉', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CF', N'中非', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CV', N'佛得角', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'EH', N'西撒哈拉', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'ER', N'厄立特里亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GM', N'冈比亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GQ', N'赤道几内亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GW', N'几内亚比绍', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'KM', N'科摩罗', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'LR', N'利比里亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'LS', N'莱索托', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MW', N'马拉维', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MZ', N'莫桑比克', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NA', N'纳米比亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NE', N'尼日尔', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'留尼汪岛', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SC', N'塞舌尔', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'Sh', N'圣赫勒拿', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'St', N'圣多美和普林西比', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SZ', N'斯威士兰', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'YT', N'马约特', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MA', N'伊夫尼', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'ZM', N'赞比亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'LY', N'利比亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MU', N'毛里求斯', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'ML', N'马里', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SO', N'索马里', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GH', N'加纳', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BW', N'博茨瓦纳', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CD', N'刚果_金', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CG', N'刚果_布', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TZ', N'坦桑尼亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TG', N'多哥', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CI', N'科特迪瓦', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SL', N'塞拉利昂', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SN', N'塞内加尔', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'ZA', N'南非', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'VE', N'委内瑞拉', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CU', N'古巴', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'EC', N'厄瓜多尔', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PA', N'巴拿马', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SR', N'苏里南', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'Co', N'哥伦比亚', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AR', N'阿根廷', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MX', N'墨西哥', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PE', N'秘鲁', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AG', N'安提瓜和巴布达', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AI', N'安圭拉', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'荷属安的列斯群岛', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'AW', N'阿鲁巴', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BB', N'巴巴多斯', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BM', N'百慕大', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BO', N'玻利维亚', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BS', N'巴哈马', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'BZ', N'伯利兹', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CR', N'哥斯达黎加', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'DO', N'多米尼加', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'马尔维纳斯群岛(福克兰)', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GD', N'格林纳达', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GF', N'法属圭亚那', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GP', N'瓜德罗普', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GT', N'危地马拉', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'GY', N'圭亚那', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'HN', N'洪都拉斯', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'HT', N'海地', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'JM', N'牙买加', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'KY', N'开曼群岛', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'LC', N'圣卢西亚', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'MQ', N'马提尼克', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'蒙塞拉特岛', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NI', N'尼加拉瓜', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PM', N'圣皮埃尔和密克隆', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PR', N'波多黎各', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'PY', N'巴拉圭', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SV', N'萨尔瓦多', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TC', N'特克斯和凯科斯群岛', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'TT', N'特立尼达和多巴哥', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'UY', N'乌拉圭', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'VC', N'圣文森特和格林纳丁斯', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'VG', N'英属维尔京群岛', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'VI', N'美属维尔京群岛', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'CL', N'复活岛', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', NULL, N'格陵兰岛', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'RU', N'俄罗斯', N'分组号', N'21', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'SE', N'瑞典', N'分组号', N'22', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'NO', N'挪威', N'分组号', N'22', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'HR', N'克罗地亚', N'分组号', N'22', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'191', N'HU', N'匈牙利', N'分组号', N'22', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AW', N'阿鲁巴', N'分组号', N'0', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'姑鲁嫂', N'分组号', N'0', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'库腊索岛(荷属)', N'分组号', N'0', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NL', N'荷兰', N'分组号', N'0', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'荷属安的列斯群岛', N'分组号', N'0', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'荷兰加勒比区', N'分组号', N'0', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'库拉索', N'分组号', N'0', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'FR', N'法属圣马丁', N'分组号', N'0', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'荷属圣马丁', N'分组号', N'0', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AL', N'阿尔巴尼亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'DZ', N'阿尔及利亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AZ', N'阿塞拜疆', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'EG', N'埃及', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'ET', N'埃塞俄比亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BH', N'巴林', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PA', N'巴拿马', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BJ', N'贝宁', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'IS', N'冰岛', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BO', N'玻利维亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BW', N'博茨瓦纳', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BF', N'布基纳法索', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BI', N'布隆迪', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GQ', N'赤道几内亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TG', N'多哥', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'DO', N'多米尼加', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'DM', N'多米尼克', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'EC', N'厄瓜多尔', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'FO', N'法罗群岛', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'福克兰群岛', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GM', N'冈比亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CG', N'刚果_布', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CD', N'刚果_金', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'Co', N'哥伦比亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CR', N'哥斯达黎加', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'格陵兰岛', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GE', N'格鲁吉亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CU', N'古巴', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GY', N'圭亚那', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'HT', N'海地', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'ME', N'黑山', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'DJ', N'吉布提', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GN', N'几内亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GW', N'几内亚比绍', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GH', N'加纳', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GA', N'加蓬', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'KH', N'柬埔寨', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'ZW', N'津巴布韦', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CM', N'喀麦隆', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'QA', N'卡塔尔', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CI', N'科特迪瓦', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'KW', N'科威特', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'KE', N'肯尼亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'LA', N'老挝', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'LB', N'黎巴嫩', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'LR', N'利比里亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'LY', N'利比亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'LT', N'立陶宛', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'LU', N'卢森堡', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'RW', N'卢旺达', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'RO', N'罗马尼亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'马布亚新几内亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'南乔治岛', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MG', N'马达加斯加', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MT', N'马耳他', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'ML', N'马里', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MR', N'毛里塔尼亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MN', N'蒙古', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BD', N'孟加拉国', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PE', N'秘鲁', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MD', N'摩尔多瓦', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MA', N'摩洛哥', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NP', N'尼泊尔', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NE', N'尼日尔', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NG', N'尼日利亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TS', N'塞尔维亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SL', N'塞拉利昂', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SN', N'塞内加尔', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CY', N'塞浦路斯', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'St', N'圣多美和普林西比', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SI', N'斯洛文尼亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SD', N'苏丹', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SR', N'苏里南', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SO', N'索马里', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TZ', N'坦桑尼亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TT', N'特立尼达和多巴哥', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TN', N'突尼斯', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'VE', N'委内瑞拉', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'UG', N'乌干达', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'UY', N'乌拉圭', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'EH', N'西撒哈拉', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'IN', N'锡金', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'象牙海岸', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'伊大尼', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PT', N'亚速尔群岛', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SY', N'叙利亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'JM', N'牙买加', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AM', N'亚美尼亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'YE', N'也门', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'IQ', N'伊拉克', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'IR', N'伊朗', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'IN', N'印度', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'ZM', N'赞比亚', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TD', N'乍得', N'分组号', N'1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'RU', N'俄罗斯', N'分组号', N'2', N'6', N'2')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'RU', N'俄罗斯', N'分组号', N'11', N'', N'11')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BR', N'巴西', N'分组号', N'3', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'加那利群岛', N'分组号', N'4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GB', N'苏格兰', N'分组号', N'4', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GB', N'英国', N'分组号', N'4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AD', N'安道尔', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'ER', N'厄立特里亚', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'FR', N'法国', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GF', N'法属圭亚那', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CV', N'佛得角', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GP', N'瓜德罗普', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'KM', N'科摩罗', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MQ', N'马提尼克', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'YT', N'马约特', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MC', N'摩纳哥', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CF', N'中非', N'分组号', N'5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PY', N'巴拉圭', N'分组号', N'6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BA', N'波黑', N'分组号', N'6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'DE', N'德国', N'分组号', N'6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SM', N'圣马力诺', N'分组号', N'7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'IT', N'意大利', N'分组号', N'7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'LI', N'列支敦士登', N'分组号', N'8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MK', N'马其顿', N'分组号', N'8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CH', N'瑞士', N'分组号', N'8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'JP', N'日本', N'分组号', N'10', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NZ', N'新西兰', N'分组号', N'12', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AU', N'澳大利亚', N'分组号', N'13', N'3,4,5,6,7,8', N'13')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AU', N'澳大利亚', N'分组号', N'14', N'', N'14')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'塔希堤', N'分组号', N'14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TP', N'东帝汶', N'分组号', N'14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'瓦利斯和富图纳', N'分组号', N'14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'KI', N'基里巴斯', N'分组号', N'14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NF', N'诺福克岛', N'分组号', N'14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'科科斯群岛', N'分组号', N'14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CS', N'圣诞岛', N'分组号', N'14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CA', N'加拿大', N'分组号', N'15', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PM', N'圣皮埃尔和密克隆', N'分组号', N'15', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GU', N'关岛', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'加罗林 ', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'马里亚纳群岛', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'绍尔群岛', N'分组号', N'16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'US', N'美国', N'分组号', N'16', N'4,5,6,7,8,9', N'16')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'US', N'美国', N'分组号', N'17', N'', N'17')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PR', N'波多黎各', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AS', N'东萨摩亚', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'VI', N'美属维尔京群岛', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'帕劳', N'分组号', N'17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NO', N'挪威', N'分组号', N'18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'IL', N'以色列', N'分组号', N'19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SE', N'瑞典', N'分组号', N'20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AR', N'阿根廷', N'分组号', N'21', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'ES', N'西班牙', N'分组号', N'22', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PL', N'波兰', N'分组号', N'23', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'VA', N'梵蒂冈', N'分组号', N'23', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MV', N'马尔代夫', N'分组号', N'24', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BN', N'文莱', N'分组号', N'24', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SG', N'新加坡', N'分组号', N'24', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BY', N'白俄罗斯', N'分组号', N'25', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'UA', N'乌克兰', N'分组号', N'26', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'LV', N'拉脱维亚', N'分组号', N'27', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'EE', N'爱沙尼亚', N'分组号', N'28', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BG', N'保加利亚', N'分组号', N'29', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'HR', N'克罗地亚', N'分组号', N'30', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AT', N'奥地利', N'分组号', N'31', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'IE', N'爱尔兰', N'分组号', N'32', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CL', N'智利', N'分组号', N'33', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'DK', N'丹麦', N'分组号', N'34', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SK', N'斯洛伐克', N'分组号', N'35', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CZ', N'捷克', N'分组号', N'36', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GR', N'希腊', N'分组号', N'37', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'FI', N'芬兰', N'分组号', N'38', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'HU', N'匈牙利', N'分组号', N'39', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PT', N'葡萄牙', N'分组号', N'40', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BE', N'比利时', N'分组号', N'41', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TR', N'土耳其', N'分组号', N'42', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'HN', N'洪都拉斯', N'分组号', N'43', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MX', N'墨西哥', N'分组号', N'43', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NI', N'尼加拉瓜', N'分组号', N'43', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SV', N'萨尔瓦多', N'分组号', N'43', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GT', N'危地马拉', N'分组号', N'43', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SA', N'沙特阿拉伯', N'分组号', N'44', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'留尼汪岛', N'分组号', N'45', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MW', N'马拉维', N'分组号', N'45', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'ZA', N'南非', N'分组号', N'45', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SC', N'塞舌尔', N'分组号', N'45', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MU', N'毛里求斯', N'分组号', N'46', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'KR', N'韩国', N'分组号', N'47', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BT', N'不丹', N'分组号', N'48', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TH', N'泰国', N'分组号', N'48', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PH', N'菲律宾', N'分组号', N'49', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'ID', N'印尼', N'分组号', N'50', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'VN', N'越南', N'分组号', N'51', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'斐济群岛', N'分组号', N'52', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MY', N'马来西亚', N'分组号', N'53', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'KZ', N'哈萨克斯坦', N'分组号', N'54', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'KG', N'吉尔吉斯斯坦', N'分组号', N'54', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TJ', N'塔吉克斯坦', N'分组号', N'54', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TM', N'土库曼斯坦', N'分组号', N'54', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'UZ', N'乌兹别克斯坦', N'分组号', N'54', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AE', N'阿联酋', N'分组号', N'55', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'OM', N'阿曼', N'分组号', N'55', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'LK', N'斯里兰卡', N'分组号', N'56', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AF', N'阿富汗', N'分组号', N'57', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PK', N'巴基斯坦', N'分组号', N'57', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'JO', N'约旦', N'分组号', N'58', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'KP', N'朝鲜', N'分组号', N'59', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AO', N'安哥拉', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AI', N'安圭拉', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'AG', N'安提瓜和巴布达', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BB', N'巴巴多斯', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BS', N'巴哈马', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BM', N'百慕大', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'BZ', N'伯利兹', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GD', N'格林纳达', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'KY', N'开曼群岛', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TC', N'特克斯和凯科斯群岛', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'LS', N'莱索托', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'蒙塞拉特岛', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'Sh', N'圣赫勒拿', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'KN', N'圣基茨和尼维斯', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'SZ', N'斯威士兰', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'VC', N'圣文森特和格林纳丁斯', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GB', N'阿森松岛', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'卡奔达', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'圣克里斯托', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'特克斯群岛', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'特里斯岛', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'LC', N'圣卢西亚', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'VG', N'英属维尔京群岛', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GI', N'直布罗陀', N'分组号', N'60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'MM', N'缅甸', N'分组号', N'61', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PS', N'巴勒斯坦', N'分组号', N'62', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NA', N'纳米比亚', N'分组号', N'62', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PF', N'巴斯群岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'背风群岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'博内尔', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'大特克斯岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'US', N'甘比尔', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'格林纳丁斯岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'GB', N'海峡群岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'金杰岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'金门岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'科西嘉岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'腊帕岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'隆尔瓦多', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'洛德豪岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PT', N'马德拉群岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'马克萨斯', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'马者拉', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'皮特开恩群', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'萨巴', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'圣巴泰勒米', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'圣克罗伊斯', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'圣尤斯特歇斯', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'向风群岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'土阿莫土', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'土布艾', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'托托拉岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'英属西印度群岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'约翰斯敦岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'中途岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TK', N'托克劳', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'FM', N'密克罗尼西亚联邦', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NU', N'纽埃', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'圣托马斯', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'塔希提', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', NULL, N'威克岛', N'分组号', N'63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PG', N'巴布亚新几内亚', N'分组号', N'64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'PF', N'法属波利尼西亚', N'分组号', N'64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'CK', N'库克群岛', N'分组号', N'64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TO', N'汤加', N'分组号', N'64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'TV', N'图瓦卢', N'分组号', N'64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'VU', N'瓦努阿图', N'分组号', N'64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'WS', N'西萨摩亚', N'分组号', N'64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NC', N'新喀里多尼亚', N'分组号', N'64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'167', N'NR', N'瑙鲁', N'分组号', N'64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'140', N'RU', N'俄罗斯', N'分区', N'100000', N'199999', N'1')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'140', N'RU', N'俄罗斯', N'分区', N'200000', N'299999', N'2')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'140', N'RU', N'俄罗斯', N'分区', N'300000', N'399999', N'3')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'140', N'RU', N'俄罗斯', N'分区', N'400000', N'499999', N'4')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'140', N'RU', N'俄罗斯', N'分区', N'600000', N'629999', N'4')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'140', N'RU', N'俄罗斯', N'分区', N'640000', N'641999', N'4')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'140', N'RU', N'俄罗斯', N'分区', N'500000', N'599999', N'5')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'140', N'RU', N'俄罗斯', N'分区', N'630000', N'639999', N'6')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'140', N'RU', N'俄罗斯', N'分区', N'642000', N'699999', N'6')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'141', N'RU', N'俄罗斯', N'分区', N'100000', N'199999', N'1')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'141', N'RU', N'俄罗斯', N'分区', N'200000', N'299999', N'2')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'141', N'RU', N'俄罗斯', N'分区', N'300000', N'399999', N'3')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'141', N'RU', N'俄罗斯', N'分区', N'400000', N'499999', N'4')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'141', N'RU', N'俄罗斯', N'分区', N'600000', N'629999', N'4')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'141', N'RU', N'俄罗斯', N'分区', N'640000', N'641999', N'4')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'141', N'RU', N'俄罗斯', N'分区', N'500000', N'599999', N'5')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'141', N'RU', N'俄罗斯', N'分区', N'630000', N'639999', N'6')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'141', N'RU', N'俄罗斯', N'分区', N'642000', N'699999', N'6')
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BR', N'巴西', N'国家数字代码', N'#1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'RU', N'俄罗斯', N'国家数字代码', N'#2', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'FR', N'法国', N'国家数字代码', N'#3', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'ES', N'西班牙', N'国家数字代码', N'#4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'UA', N'乌克兰', N'国家数字代码', N'#5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'DE', N'德国', N'国家数字代码', N'#6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'IL', N'以色列', N'国家数字代码', N'#7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GB', N'英国', N'国家数字代码', N'#8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SE', N'瑞典', N'国家数字代码', N'#9', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CA', N'加拿大', N'国家数字代码', N'#10', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'NL', N'荷兰', N'国家数字代码', N'#11', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'NZ', N'新西兰', N'国家数字代码', N'#12', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'US', N'美国', N'国家数字代码', N'#13', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AU', N'澳大利亚', N'国家数字代码', N'#14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'NO', N'挪威', N'国家数字代码', N'#15', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GR', N'希腊', N'国家数字代码', N'#16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BY', N'白俄罗斯', N'国家数字代码', N'#17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'TR', N'土耳其', N'国家数字代码', N'#18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'HU', N'匈牙利', N'国家数字代码', N'#19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CH', N'瑞士', N'国家数字代码', N'#20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CZ', N'捷克', N'国家数字代码', N'#21', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'IE', N'爱尔兰', N'国家数字代码', N'#22', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'EE', N'爱沙尼亚', N'国家数字代码', N'#23', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'DK', N'丹麦', N'国家数字代码', N'#24', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'HR', N'克罗地亚', N'国家数字代码', N'#25', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CL', N'智利', N'国家数字代码', N'#26', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MT', N'马耳他', N'国家数字代码', N'#27', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SK', N'斯洛伐克', N'国家数字代码', N'#28', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PT', N'葡萄牙', N'国家数字代码', N'#29', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'FI', N'芬兰', N'国家数字代码', N'#30', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BG', N'保加利亚', N'国家数字代码', N'#31', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'LV', N'拉脱维亚', N'国家数字代码', N'#32', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'LT', N'立陶宛', N'国家数字代码', N'#33', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PL', N'波兰', N'国家数字代码', N'#34', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MX', N'墨西哥', N'国家数字代码', N'#35', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'IT', N'意大利', N'国家数字代码', N'#36', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'KR', N'韩国', N'国家数字代码', N'#37', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'RO', N'罗马尼亚', N'国家数字代码', N'#38', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'KZ', N'哈萨克斯坦', N'国家数字代码', N'#39', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CY', N'塞浦路斯', N'国家数字代码', N'#40', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'TH', N'泰国', N'国家数字代码', N'#41', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BE', N'比利时', N'国家数字代码', N'#42', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'ID', N'印度尼西亚', N'国家数字代码', N'#43', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SA', N'沙特阿拉伯', N'国家数字代码', N'#44', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SI', N'斯洛文尼亚', N'国家数字代码', N'#45', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AT', N'奥地利', N'国家数字代码', N'#46', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'IN', N'印度', N'国家数字代码', N'#47', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SG', N'新加坡', N'国家数字代码', N'#48', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PE', N'秘鲁', N'国家数字代码', N'#49', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MD', N'摩尔多瓦', N'国家数字代码', N'#50', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MY', N'马来西亚', N'国家数字代码', N'#51', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AR', N'阿根廷', N'国家数字代码', N'#52', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'JP', N'日本', N'国家数字代码', N'#53', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'TS', N'塞尔维亚', N'国家数字代码', N'#54', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AZ', N'阿塞拜疆', N'国家数字代码', N'#55', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'Co', N'哥伦比亚', N'国家数字代码', N'#56', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'ZA', N'南非', N'国家数字代码', N'#57', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'LK', N'斯里兰卡', N'国家数字代码', N'#58', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'IS', N'冰岛', N'国家数字代码', N'#59', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MK', N'马其顿', N'国家数字代码', N'#60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'NG', N'尼日利亚', N'国家数字代码', N'#61', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'UY', N'乌拉圭', N'国家数字代码', N'#62', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'LB', N'黎巴嫩', N'国家数字代码', N'#63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PH', N'菲律宾', N'国家数字代码', N'#64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BN', N'文莱', N'国家数字代码', N'#65', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AL', N'阿尔巴尼亚', N'国家数字代码', N'#66', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'EC', N'厄瓜多尔', N'国家数字代码', N'#67', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AE', N'阿联酋', N'国家数字代码', N'#68', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AM', N'亚美尼亚', N'国家数字代码', N'#69', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'UZ', N'乌兹别克斯坦', N'国家数字代码', N'#70', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'LU', N'卢森堡', N'国家数字代码', N'#71', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MU', N'毛里求斯', N'国家数字代码', N'#72', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BA', N'波黑', N'国家数字代码', N'#73', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'KW', N'科威特', N'国家数字代码', N'#74', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'ME', N'黑山', N'国家数字代码', N'#75', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'VE', N'委内瑞拉', N'国家数字代码', N'#76', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'OM', N'阿曼', N'国家数字代码', N'#77', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SV', N'萨尔瓦多', N'国家数字代码', N'#78', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MV', N'马尔代夫', N'国家数字代码', N'#79', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GE', N'格鲁吉亚', N'国家数字代码', N'#80', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PK', N'巴基斯坦', N'国家数字代码', N'#81', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'VN', N'越南', N'国家数字代码', N'#82', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'QA', N'卡塔尔', N'国家数字代码', N'#83', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CR', N'哥斯达黎加', N'国家数字代码', N'#84', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PS', N'巴勒斯坦', N'国家数字代码', N'#85', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GH', N'加纳', N'国家数字代码', N'#86', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CT', N'台湾', N'国家数字代码', N'#87', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'ZM', N'赞比亚', N'国家数字代码', N'#88', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'IR', N'伊朗', N'国家数字代码', N'#89', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'DZ', N'阿尔及利亚', N'国家数字代码', N'#90', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PR', N'波多黎各', N'国家数字代码', N'#91', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'EG', N'埃及', N'国家数字代码', N'#92', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'TM', N'土库曼斯坦', N'国家数字代码', N'#93', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BO', N'玻利维亚', N'国家数字代码', N'#94', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PF', N'法属波利尼西亚', N'国家数字代码', N'#95', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'HK', N'香港', N'国家数字代码', N'#96', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BH', N'巴林', N'国家数字代码', N'#97', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'KE', N'肯尼亚', N'国家数字代码', N'#98', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'LC', N'圣卢西亚', N'国家数字代码', N'#99', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'NC', N'新喀里多尼亚', N'国家数字代码', N'#100', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'KH', N'柬埔寨', N'国家数字代码', N'#101', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'留尼汪岛', N'国家数字代码', N'#102', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'YE', N'也门', N'国家数字代码', N'#103', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GP', N'瓜德罗普', N'国家数字代码', N'#104', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'FJ', N'斐济', N'国家数字代码', N'#105', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'IQ', N'伊拉克', N'国家数字代码', N'#106', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MA', N'摩洛哥', N'国家数字代码', N'#107', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PG', N'巴布亚新几内亚', N'国家数字代码', N'#108', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PY', N'巴拉圭', N'国家数字代码', N'#109', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'KG', N'吉尔吉斯斯坦', N'国家数字代码', N'#110', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CM', N'喀麦隆', N'国家数字代码', N'#111', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'JO', N'约旦', N'国家数字代码', N'#112', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SC', N'塞舌尔', N'国家数字代码', N'#113', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'LA', N'老挝', N'国家数字代码', N'#114', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BZ', N'伯利兹', N'国家数字代码', N'#115', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'KP', N'朝鲜', N'国家数字代码', N'#116', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'ZW', N'津巴布韦', N'国家数字代码', N'#117', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CK', N'库克群岛', N'国家数字代码', N'#118', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'TJ', N'塔吉克斯坦', N'国家数字代码', N'#119', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PA', N'巴拿马', N'国家数字代码', N'#120', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GF', N'法属圭亚那', N'国家数字代码', N'#121', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'TT', N'特立尼达和多巴哥', N'国家数字代码', N'#122', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MQ', N'马提尼克', N'国家数字代码', N'#123', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GM', N'冈比亚', N'国家数字代码', N'#124', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'TN', N'突尼斯', N'国家数字代码', N'#125', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BN', N'文莱达鲁萨兰', N'国家数字代码', N'#126', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'TZ', N'坦桑尼亚', N'国家数字代码', N'#127', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BW', N'博茨瓦纳', N'国家数字代码', N'#128', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'FO', N'法罗群岛', N'国家数字代码', N'#129', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CU', N'古巴', N'国家数字代码', N'#130', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'NA', N'纳米比亚', N'国家数字代码', N'#131', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'NE', N'尼日尔', N'国家数字代码', N'#132', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AF', N'阿富汗', N'国家数字代码', N'#133', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MO', N'澳门', N'国家数字代码', N'#134', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'KY', N'开曼群岛', N'国家数字代码', N'#135', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MZ', N'莫桑比克', N'国家数字代码', N'#136', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'HT', N'海地', N'国家数字代码', N'#137', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GT', N'危地马拉', N'国家数字代码', N'#138', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BB', N'巴巴多斯', N'国家数字代码', N'#139', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AW', N'阿鲁巴', N'国家数字代码', N'#140', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GU', N'关岛', N'国家数字代码', N'#141', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GY', N'圭亚那', N'国家数字代码', N'#142', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AD', N'安道尔', N'国家数字代码', N'#143', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'HN', N'洪都拉斯', N'国家数字代码', N'#144', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AO', N'安哥拉', N'国家数字代码', N'#145', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GA', N'加蓬', N'国家数字代码', N'#146', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'DJ', N'吉布提', N'国家数字代码', N'#147', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GN', N'几内亚', N'国家数字代码', N'#148', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CI', N'科特迪瓦', N'国家数字代码', N'#149', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AG', N'安提瓜', N'国家数字代码', N'#150', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'LR', N'利比里亚', N'国家数字代码', N'#151', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'LY', N'利比亚', N'国家数字代码', N'#152', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'留尼旺岛', N'国家数字代码', N'#153', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'RW', N'卢旺达', N'国家数字代码', N'#154', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MW', N'马拉维', N'国家数字代码', N'#155', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'ML', N'马里', N'国家数字代码', N'#156', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'马约群岛', N'国家数字代码', N'#157', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'美国西部', N'国家数字代码', N'#158', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MN', N'蒙古', N'国家数字代码', N'#159', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BD', N'孟加拉', N'国家数字代码', N'#160', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MM', N'缅甸', N'国家数字代码', N'#161', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MC', N'摩纳哥', N'国家数字代码', N'#162', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'NP', N'尼泊尔', N'国家数字代码', N'#163', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'NI', N'尼加拉瓜', N'国家数字代码', N'#164', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SL', N'塞拉利昂', N'国家数字代码', N'#165', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SN', N'塞内加尔', N'国家数字代码', N'#166', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'WS', N'萨摩亚', N'国家数字代码', N'#167', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BM', N'百慕大', N'国家数字代码', N'#168', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'圣基茨', N'国家数字代码', N'#169', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SM', N'圣马力诺', N'国家数字代码', N'#170', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SD', N'苏丹', N'国家数字代码', N'#171', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SR', N'苏里南', N'国家数字代码', N'#172', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'TO', N'汤加', N'国家数字代码', N'#173', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'VU', N'瓦努阿图', N'国家数字代码', N'#174', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'UG', N'乌干达', N'国家数字代码', N'#175', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SY', N'叙利亚', N'国家数字代码', N'#176', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'JM', N'牙买加', N'国家数字代码', N'#177', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GI', N'直布罗陀', N'国家数字代码', N'#178', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BJ', N'贝宁', N'国家数字代码', N'#179', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BS', N'巴哈马', N'国家数字代码', N'#180', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SZ', N'斯威士兰', N'国家数字代码', N'#181', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'塔希堤', N'国家数字代码', N'#182', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BT', N'不丹', N'国家数字代码', N'#183', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BI', N'布隆迪', N'国家数字代码', N'#184', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'TG', N'多哥', N'国家数字代码', N'#185', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'多米尼加岛', N'国家数字代码', N'#186', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CG', N'刚果', N'国家数字代码', N'#187', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'荷属安的列斯群岛', N'国家数字代码', N'#188', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'LI', N'列支敦士登', N'国家数字代码', N'#189', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MG', N'马达加斯加', N'国家数字代码', N'#190', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MR', N'毛里塔尼亚', N'国家数字代码', N'#191', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'MH', N'马绍尔群岛', N'国家数字代码', N'#192', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AS', N'美属萨摩亚', N'国家数字代码', N'#193', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'FM', N'密克罗尼西亚', N'国家数字代码', N'#194', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PM', N'圣皮埃尔和密克隆', N'国家数字代码', N'#195', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PF', N'波利尼西亚', N'国家数字代码', N'#196', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'ET', N'埃塞俄比亚', N'国家数字代码', N'#197', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'CD', N'刚果民主共和国', N'国家数字代码', N'#198', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'KI', N'基里巴斯', N'国家数字代码', N'#199', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'SO', N'索马里', N'国家数字代码', N'#200', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'大溪地', N'国家数字代码', N'#201', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GD', N'格林纳达', N'国家数字代码', N'#202', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'AI', N'安圭拉', N'国家数字代码', N'#203', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'荷属安提尔群岛', N'国家数字代码', N'#204', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GW', N'几内亚比绍', N'国家数字代码', N'#205', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'BM', N'百慕大群岛', N'国家数字代码', N'#206', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'泽西岛', N'国家数字代码', N'#207', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'格恩西岛', N'国家数字代码', N'#208', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'科西嘉岛', N'国家数字代码', N'#209', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PT', N'马德拉群岛', N'国家数字代码', N'#210', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'PT', N'亚速尔群岛', N'国家数字代码', N'#211', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'ES', N'巴利阿里群岛', N'国家数字代码', N'#212', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'撒丁岛', N'国家数字代码', N'#213', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'西西里岛', N'国家数字代码', N'#214', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'圣马丁', N'国家数字代码', N'#215', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'加纳利群岛', N'国家数字代码', N'#216', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'VA', N'梵蒂冈', N'国家数字代码', N'#217', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'圣基斯和尼维尔', N'国家数字代码', N'#218', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'GQ', N'赤道几内亚', N'国家数字代码', N'#219', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'NR', N'瑙鲁共和国', N'国家数字代码', N'#220', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'塞班岛', N'国家数字代码', N'#221', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', NULL, N'塔希提', N'国家数字代码', N'#222', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'144', N'DO', N'多米尼加共和国', N'国家数字代码', N'#223', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BR', N'巴西', N'国家数字代码', N'#1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'RU', N'俄罗斯', N'国家数字代码', N'#2', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'FR', N'法国', N'国家数字代码', N'#3', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'ES', N'西班牙', N'国家数字代码', N'#4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'UA', N'乌克兰', N'国家数字代码', N'#5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'DE', N'德国', N'国家数字代码', N'#6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'IL', N'以色列', N'国家数字代码', N'#7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GB', N'英国', N'国家数字代码', N'#8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SE', N'瑞典', N'国家数字代码', N'#9', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CA', N'加拿大', N'国家数字代码', N'#10', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'NL', N'荷兰', N'国家数字代码', N'#11', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'NZ', N'新西兰', N'国家数字代码', N'#12', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'US', N'美国', N'国家数字代码', N'#13', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AU', N'澳大利亚', N'国家数字代码', N'#14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'NO', N'挪威', N'国家数字代码', N'#15', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GR', N'希腊', N'国家数字代码', N'#16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BY', N'白俄罗斯', N'国家数字代码', N'#17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'TR', N'土耳其', N'国家数字代码', N'#18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'HU', N'匈牙利', N'国家数字代码', N'#19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CH', N'瑞士', N'国家数字代码', N'#20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CZ', N'捷克', N'国家数字代码', N'#21', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'IE', N'爱尔兰', N'国家数字代码', N'#22', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'EE', N'爱沙尼亚', N'国家数字代码', N'#23', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'DK', N'丹麦', N'国家数字代码', N'#24', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'HR', N'克罗地亚', N'国家数字代码', N'#25', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CL', N'智利', N'国家数字代码', N'#26', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MT', N'马耳他', N'国家数字代码', N'#27', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SK', N'斯洛伐克', N'国家数字代码', N'#28', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PT', N'葡萄牙', N'国家数字代码', N'#29', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'FI', N'芬兰', N'国家数字代码', N'#30', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BG', N'保加利亚', N'国家数字代码', N'#31', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'LV', N'拉脱维亚', N'国家数字代码', N'#32', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'LT', N'立陶宛', N'国家数字代码', N'#33', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PL', N'波兰', N'国家数字代码', N'#34', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MX', N'墨西哥', N'国家数字代码', N'#35', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'IT', N'意大利', N'国家数字代码', N'#36', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'KR', N'韩国', N'国家数字代码', N'#37', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'RO', N'罗马尼亚', N'国家数字代码', N'#38', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'KZ', N'哈萨克斯坦', N'国家数字代码', N'#39', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CY', N'塞浦路斯', N'国家数字代码', N'#40', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'TH', N'泰国', N'国家数字代码', N'#41', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BE', N'比利时', N'国家数字代码', N'#42', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'ID', N'印度尼西亚', N'国家数字代码', N'#43', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SA', N'沙特阿拉伯', N'国家数字代码', N'#44', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SI', N'斯洛文尼亚', N'国家数字代码', N'#45', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AT', N'奥地利', N'国家数字代码', N'#46', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'IN', N'印度', N'国家数字代码', N'#47', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SG', N'新加坡', N'国家数字代码', N'#48', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PE', N'秘鲁', N'国家数字代码', N'#49', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MD', N'摩尔多瓦', N'国家数字代码', N'#50', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MY', N'马来西亚', N'国家数字代码', N'#51', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AR', N'阿根廷', N'国家数字代码', N'#52', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'JP', N'日本', N'国家数字代码', N'#53', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'TS', N'塞尔维亚', N'国家数字代码', N'#54', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AZ', N'阿塞拜疆', N'国家数字代码', N'#55', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'Co', N'哥伦比亚', N'国家数字代码', N'#56', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'ZA', N'南非', N'国家数字代码', N'#57', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'LK', N'斯里兰卡', N'国家数字代码', N'#58', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'IS', N'冰岛', N'国家数字代码', N'#59', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MK', N'马其顿', N'国家数字代码', N'#60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'NG', N'尼日利亚', N'国家数字代码', N'#61', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'UY', N'乌拉圭', N'国家数字代码', N'#62', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'LB', N'黎巴嫩', N'国家数字代码', N'#63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PH', N'菲律宾', N'国家数字代码', N'#64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BN', N'文莱', N'国家数字代码', N'#65', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AL', N'阿尔巴尼亚', N'国家数字代码', N'#66', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'EC', N'厄瓜多尔', N'国家数字代码', N'#67', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AE', N'阿联酋', N'国家数字代码', N'#68', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AM', N'亚美尼亚', N'国家数字代码', N'#69', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'UZ', N'乌兹别克斯坦', N'国家数字代码', N'#70', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'LU', N'卢森堡', N'国家数字代码', N'#71', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MU', N'毛里求斯', N'国家数字代码', N'#72', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BA', N'波黑', N'国家数字代码', N'#73', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'KW', N'科威特', N'国家数字代码', N'#74', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'ME', N'黑山', N'国家数字代码', N'#75', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'VE', N'委内瑞拉', N'国家数字代码', N'#76', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'OM', N'阿曼', N'国家数字代码', N'#77', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SV', N'萨尔瓦多', N'国家数字代码', N'#78', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MV', N'马尔代夫', N'国家数字代码', N'#79', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GE', N'格鲁吉亚', N'国家数字代码', N'#80', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PK', N'巴基斯坦', N'国家数字代码', N'#81', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'VN', N'越南', N'国家数字代码', N'#82', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'QA', N'卡塔尔', N'国家数字代码', N'#83', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CR', N'哥斯达黎加', N'国家数字代码', N'#84', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PS', N'巴勒斯坦', N'国家数字代码', N'#85', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GH', N'加纳', N'国家数字代码', N'#86', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CT', N'台湾', N'国家数字代码', N'#87', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'ZM', N'赞比亚', N'国家数字代码', N'#88', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'IR', N'伊朗', N'国家数字代码', N'#89', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'DZ', N'阿尔及利亚', N'国家数字代码', N'#90', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PR', N'波多黎各', N'国家数字代码', N'#91', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'EG', N'埃及', N'国家数字代码', N'#92', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'TM', N'土库曼斯坦', N'国家数字代码', N'#93', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BO', N'玻利维亚', N'国家数字代码', N'#94', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PF', N'法属波利尼西亚', N'国家数字代码', N'#95', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'HK', N'香港', N'国家数字代码', N'#96', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BH', N'巴林', N'国家数字代码', N'#97', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'KE', N'肯尼亚', N'国家数字代码', N'#98', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'LC', N'圣卢西亚', N'国家数字代码', N'#99', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'NC', N'新喀里多尼亚', N'国家数字代码', N'#100', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'KH', N'柬埔寨', N'国家数字代码', N'#101', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'留尼汪岛', N'国家数字代码', N'#102', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'YE', N'也门', N'国家数字代码', N'#103', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GP', N'瓜德罗普', N'国家数字代码', N'#104', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'FJ', N'斐济', N'国家数字代码', N'#105', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'IQ', N'伊拉克', N'国家数字代码', N'#106', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MA', N'摩洛哥', N'国家数字代码', N'#107', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PG', N'巴布亚新几内亚', N'国家数字代码', N'#108', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PY', N'巴拉圭', N'国家数字代码', N'#109', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'KG', N'吉尔吉斯斯坦', N'国家数字代码', N'#110', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CM', N'喀麦隆', N'国家数字代码', N'#111', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'JO', N'约旦', N'国家数字代码', N'#112', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SC', N'塞舌尔', N'国家数字代码', N'#113', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'LA', N'老挝', N'国家数字代码', N'#114', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BZ', N'伯利兹', N'国家数字代码', N'#115', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'KP', N'朝鲜', N'国家数字代码', N'#116', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'ZW', N'津巴布韦', N'国家数字代码', N'#117', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CK', N'库克群岛', N'国家数字代码', N'#118', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'TJ', N'塔吉克斯坦', N'国家数字代码', N'#119', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PA', N'巴拿马', N'国家数字代码', N'#120', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GF', N'法属圭亚那', N'国家数字代码', N'#121', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'TT', N'特立尼达和多巴哥', N'国家数字代码', N'#122', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MQ', N'马提尼克', N'国家数字代码', N'#123', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GM', N'冈比亚', N'国家数字代码', N'#124', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'TN', N'突尼斯', N'国家数字代码', N'#125', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BN', N'文莱达鲁萨兰', N'国家数字代码', N'#126', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'TZ', N'坦桑尼亚', N'国家数字代码', N'#127', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BW', N'博茨瓦纳', N'国家数字代码', N'#128', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'FO', N'法罗群岛', N'国家数字代码', N'#129', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CU', N'古巴', N'国家数字代码', N'#130', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'NA', N'纳米比亚', N'国家数字代码', N'#131', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'NE', N'尼日尔', N'国家数字代码', N'#132', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AF', N'阿富汗', N'国家数字代码', N'#133', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MO', N'澳门', N'国家数字代码', N'#134', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'KY', N'开曼群岛', N'国家数字代码', N'#135', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MZ', N'莫桑比克', N'国家数字代码', N'#136', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'HT', N'海地', N'国家数字代码', N'#137', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GT', N'危地马拉', N'国家数字代码', N'#138', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BB', N'巴巴多斯', N'国家数字代码', N'#139', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AW', N'阿鲁巴', N'国家数字代码', N'#140', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GU', N'关岛', N'国家数字代码', N'#141', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GY', N'圭亚那', N'国家数字代码', N'#142', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AD', N'安道尔', N'国家数字代码', N'#143', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'HN', N'洪都拉斯', N'国家数字代码', N'#144', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AO', N'安哥拉', N'国家数字代码', N'#145', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GA', N'加蓬', N'国家数字代码', N'#146', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'DJ', N'吉布提', N'国家数字代码', N'#147', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GN', N'几内亚', N'国家数字代码', N'#148', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CI', N'科特迪瓦', N'国家数字代码', N'#149', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AG', N'安提瓜', N'国家数字代码', N'#150', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'LR', N'利比里亚', N'国家数字代码', N'#151', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'LY', N'利比亚', N'国家数字代码', N'#152', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'留尼旺岛', N'国家数字代码', N'#153', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'RW', N'卢旺达', N'国家数字代码', N'#154', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MW', N'马拉维', N'国家数字代码', N'#155', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'ML', N'马里', N'国家数字代码', N'#156', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'马约群岛', N'国家数字代码', N'#157', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'美国西部', N'国家数字代码', N'#158', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MN', N'蒙古', N'国家数字代码', N'#159', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BD', N'孟加拉', N'国家数字代码', N'#160', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MM', N'缅甸', N'国家数字代码', N'#161', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MC', N'摩纳哥', N'国家数字代码', N'#162', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'NP', N'尼泊尔', N'国家数字代码', N'#163', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'NI', N'尼加拉瓜', N'国家数字代码', N'#164', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SL', N'塞拉利昂', N'国家数字代码', N'#165', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SN', N'塞内加尔', N'国家数字代码', N'#166', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'WS', N'萨摩亚', N'国家数字代码', N'#167', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BM', N'百慕大', N'国家数字代码', N'#168', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'圣基茨', N'国家数字代码', N'#169', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SM', N'圣马力诺', N'国家数字代码', N'#170', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SD', N'苏丹', N'国家数字代码', N'#171', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SR', N'苏里南', N'国家数字代码', N'#172', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'TO', N'汤加', N'国家数字代码', N'#173', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'VU', N'瓦努阿图', N'国家数字代码', N'#174', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'UG', N'乌干达', N'国家数字代码', N'#175', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SY', N'叙利亚', N'国家数字代码', N'#176', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'JM', N'牙买加', N'国家数字代码', N'#177', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GI', N'直布罗陀', N'国家数字代码', N'#178', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BJ', N'贝宁', N'国家数字代码', N'#179', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BS', N'巴哈马', N'国家数字代码', N'#180', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SZ', N'斯威士兰', N'国家数字代码', N'#181', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'塔希堤', N'国家数字代码', N'#182', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BT', N'不丹', N'国家数字代码', N'#183', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BI', N'布隆迪', N'国家数字代码', N'#184', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'TG', N'多哥', N'国家数字代码', N'#185', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'多米尼加岛', N'国家数字代码', N'#186', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CG', N'刚果', N'国家数字代码', N'#187', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'荷属安的列斯群岛', N'国家数字代码', N'#188', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'LI', N'列支敦士登', N'国家数字代码', N'#189', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MG', N'马达加斯加', N'国家数字代码', N'#190', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MR', N'毛里塔尼亚', N'国家数字代码', N'#191', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'MH', N'马绍尔群岛', N'国家数字代码', N'#192', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AS', N'美属萨摩亚', N'国家数字代码', N'#193', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'FM', N'密克罗尼西亚', N'国家数字代码', N'#194', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PM', N'圣皮埃尔和密克隆', N'国家数字代码', N'#195', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PF', N'波利尼西亚', N'国家数字代码', N'#196', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'ET', N'埃塞俄比亚', N'国家数字代码', N'#197', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'CD', N'刚果民主共和国', N'国家数字代码', N'#198', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'KI', N'基里巴斯', N'国家数字代码', N'#199', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'SO', N'索马里', N'国家数字代码', N'#200', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'大溪地', N'国家数字代码', N'#201', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GD', N'格林纳达', N'国家数字代码', N'#202', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'AI', N'安圭拉', N'国家数字代码', N'#203', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'荷属安提尔群岛', N'国家数字代码', N'#204', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GW', N'几内亚比绍', N'国家数字代码', N'#205', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'BM', N'百慕大群岛', N'国家数字代码', N'#206', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'泽西岛', N'国家数字代码', N'#207', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'格恩西岛', N'国家数字代码', N'#208', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'科西嘉岛', N'国家数字代码', N'#209', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PT', N'马德拉群岛', N'国家数字代码', N'#210', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'PT', N'亚速尔群岛', N'国家数字代码', N'#211', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'ES', N'巴利阿里群岛', N'国家数字代码', N'#212', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'撒丁岛', N'国家数字代码', N'#213', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'西西里岛', N'国家数字代码', N'#214', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'圣马丁', N'国家数字代码', N'#215', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'加纳利群岛', N'国家数字代码', N'#216', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'VA', N'梵蒂冈', N'国家数字代码', N'#217', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'圣基斯和尼维尔', N'国家数字代码', N'#218', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'GQ', N'赤道几内亚', N'国家数字代码', N'#219', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'NR', N'瑙鲁共和国', N'国家数字代码', N'#220', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'塞班岛', N'国家数字代码', N'#221', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', NULL, N'塔希提', N'国家数字代码', N'#222', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'174', N'DO', N'多米尼加共和国', N'国家数字代码', N'#223', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BR', N'巴西', N'国家数字代码', N'#1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'RU', N'俄罗斯', N'国家数字代码', N'#2', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'FR', N'法国', N'国家数字代码', N'#3', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'ES', N'西班牙', N'国家数字代码', N'#4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'UA', N'乌克兰', N'国家数字代码', N'#5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'DE', N'德国', N'国家数字代码', N'#6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'IL', N'以色列', N'国家数字代码', N'#7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GB', N'英国', N'国家数字代码', N'#8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SE', N'瑞典', N'国家数字代码', N'#9', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CA', N'加拿大', N'国家数字代码', N'#10', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'NL', N'荷兰', N'国家数字代码', N'#11', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'NZ', N'新西兰', N'国家数字代码', N'#12', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'US', N'美国', N'国家数字代码', N'#13', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AU', N'澳大利亚', N'国家数字代码', N'#14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'NO', N'挪威', N'国家数字代码', N'#15', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GR', N'希腊', N'国家数字代码', N'#16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BY', N'白俄罗斯', N'国家数字代码', N'#17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'TR', N'土耳其', N'国家数字代码', N'#18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'HU', N'匈牙利', N'国家数字代码', N'#19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CH', N'瑞士', N'国家数字代码', N'#20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CZ', N'捷克', N'国家数字代码', N'#21', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'IE', N'爱尔兰', N'国家数字代码', N'#22', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'EE', N'爱沙尼亚', N'国家数字代码', N'#23', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'DK', N'丹麦', N'国家数字代码', N'#24', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'HR', N'克罗地亚', N'国家数字代码', N'#25', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CL', N'智利', N'国家数字代码', N'#26', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MT', N'马耳他', N'国家数字代码', N'#27', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SK', N'斯洛伐克', N'国家数字代码', N'#28', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PT', N'葡萄牙', N'国家数字代码', N'#29', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'FI', N'芬兰', N'国家数字代码', N'#30', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BG', N'保加利亚', N'国家数字代码', N'#31', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'LV', N'拉脱维亚', N'国家数字代码', N'#32', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'LT', N'立陶宛', N'国家数字代码', N'#33', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PL', N'波兰', N'国家数字代码', N'#34', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MX', N'墨西哥', N'国家数字代码', N'#35', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'IT', N'意大利', N'国家数字代码', N'#36', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'KR', N'韩国', N'国家数字代码', N'#37', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'RO', N'罗马尼亚', N'国家数字代码', N'#38', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'KZ', N'哈萨克斯坦', N'国家数字代码', N'#39', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CY', N'塞浦路斯', N'国家数字代码', N'#40', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'TH', N'泰国', N'国家数字代码', N'#41', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BE', N'比利时', N'国家数字代码', N'#42', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'ID', N'印度尼西亚', N'国家数字代码', N'#43', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SA', N'沙特阿拉伯', N'国家数字代码', N'#44', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SI', N'斯洛文尼亚', N'国家数字代码', N'#45', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AT', N'奥地利', N'国家数字代码', N'#46', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'IN', N'印度', N'国家数字代码', N'#47', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SG', N'新加坡', N'国家数字代码', N'#48', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PE', N'秘鲁', N'国家数字代码', N'#49', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MD', N'摩尔多瓦', N'国家数字代码', N'#50', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MY', N'马来西亚', N'国家数字代码', N'#51', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AR', N'阿根廷', N'国家数字代码', N'#52', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'JP', N'日本', N'国家数字代码', N'#53', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'TS', N'塞尔维亚', N'国家数字代码', N'#54', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AZ', N'阿塞拜疆', N'国家数字代码', N'#55', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'Co', N'哥伦比亚', N'国家数字代码', N'#56', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'ZA', N'南非', N'国家数字代码', N'#57', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'LK', N'斯里兰卡', N'国家数字代码', N'#58', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'IS', N'冰岛', N'国家数字代码', N'#59', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MK', N'马其顿', N'国家数字代码', N'#60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'NG', N'尼日利亚', N'国家数字代码', N'#61', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'UY', N'乌拉圭', N'国家数字代码', N'#62', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'LB', N'黎巴嫩', N'国家数字代码', N'#63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PH', N'菲律宾', N'国家数字代码', N'#64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BN', N'文莱', N'国家数字代码', N'#65', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AL', N'阿尔巴尼亚', N'国家数字代码', N'#66', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'EC', N'厄瓜多尔', N'国家数字代码', N'#67', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AE', N'阿联酋', N'国家数字代码', N'#68', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AM', N'亚美尼亚', N'国家数字代码', N'#69', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'UZ', N'乌兹别克斯坦', N'国家数字代码', N'#70', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'LU', N'卢森堡', N'国家数字代码', N'#71', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MU', N'毛里求斯', N'国家数字代码', N'#72', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BA', N'波黑', N'国家数字代码', N'#73', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'KW', N'科威特', N'国家数字代码', N'#74', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'ME', N'黑山', N'国家数字代码', N'#75', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'VE', N'委内瑞拉', N'国家数字代码', N'#76', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'OM', N'阿曼', N'国家数字代码', N'#77', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SV', N'萨尔瓦多', N'国家数字代码', N'#78', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MV', N'马尔代夫', N'国家数字代码', N'#79', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GE', N'格鲁吉亚', N'国家数字代码', N'#80', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PK', N'巴基斯坦', N'国家数字代码', N'#81', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'VN', N'越南', N'国家数字代码', N'#82', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'QA', N'卡塔尔', N'国家数字代码', N'#83', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CR', N'哥斯达黎加', N'国家数字代码', N'#84', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PS', N'巴勒斯坦', N'国家数字代码', N'#85', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GH', N'加纳', N'国家数字代码', N'#86', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CT', N'台湾', N'国家数字代码', N'#87', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'ZM', N'赞比亚', N'国家数字代码', N'#88', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'IR', N'伊朗', N'国家数字代码', N'#89', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'DZ', N'阿尔及利亚', N'国家数字代码', N'#90', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PR', N'波多黎各', N'国家数字代码', N'#91', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'EG', N'埃及', N'国家数字代码', N'#92', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'TM', N'土库曼斯坦', N'国家数字代码', N'#93', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BO', N'玻利维亚', N'国家数字代码', N'#94', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PF', N'法属波利尼西亚', N'国家数字代码', N'#95', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'HK', N'香港', N'国家数字代码', N'#96', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BH', N'巴林', N'国家数字代码', N'#97', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'KE', N'肯尼亚', N'国家数字代码', N'#98', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'LC', N'圣卢西亚', N'国家数字代码', N'#99', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'NC', N'新喀里多尼亚', N'国家数字代码', N'#100', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'KH', N'柬埔寨', N'国家数字代码', N'#101', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'留尼汪岛', N'国家数字代码', N'#102', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'YE', N'也门', N'国家数字代码', N'#103', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GP', N'瓜德罗普', N'国家数字代码', N'#104', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'FJ', N'斐济', N'国家数字代码', N'#105', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'IQ', N'伊拉克', N'国家数字代码', N'#106', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MA', N'摩洛哥', N'国家数字代码', N'#107', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PG', N'巴布亚新几内亚', N'国家数字代码', N'#108', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PY', N'巴拉圭', N'国家数字代码', N'#109', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'KG', N'吉尔吉斯斯坦', N'国家数字代码', N'#110', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CM', N'喀麦隆', N'国家数字代码', N'#111', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'JO', N'约旦', N'国家数字代码', N'#112', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SC', N'塞舌尔', N'国家数字代码', N'#113', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'LA', N'老挝', N'国家数字代码', N'#114', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BZ', N'伯利兹', N'国家数字代码', N'#115', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'KP', N'朝鲜', N'国家数字代码', N'#116', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'ZW', N'津巴布韦', N'国家数字代码', N'#117', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CK', N'库克群岛', N'国家数字代码', N'#118', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'TJ', N'塔吉克斯坦', N'国家数字代码', N'#119', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PA', N'巴拿马', N'国家数字代码', N'#120', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GF', N'法属圭亚那', N'国家数字代码', N'#121', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'TT', N'特立尼达和多巴哥', N'国家数字代码', N'#122', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MQ', N'马提尼克', N'国家数字代码', N'#123', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GM', N'冈比亚', N'国家数字代码', N'#124', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'TN', N'突尼斯', N'国家数字代码', N'#125', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BN', N'文莱达鲁萨兰', N'国家数字代码', N'#126', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'TZ', N'坦桑尼亚', N'国家数字代码', N'#127', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BW', N'博茨瓦纳', N'国家数字代码', N'#128', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'FO', N'法罗群岛', N'国家数字代码', N'#129', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CU', N'古巴', N'国家数字代码', N'#130', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'NA', N'纳米比亚', N'国家数字代码', N'#131', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'NE', N'尼日尔', N'国家数字代码', N'#132', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AF', N'阿富汗', N'国家数字代码', N'#133', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MO', N'澳门', N'国家数字代码', N'#134', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'KY', N'开曼群岛', N'国家数字代码', N'#135', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MZ', N'莫桑比克', N'国家数字代码', N'#136', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'HT', N'海地', N'国家数字代码', N'#137', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GT', N'危地马拉', N'国家数字代码', N'#138', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BB', N'巴巴多斯', N'国家数字代码', N'#139', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AW', N'阿鲁巴', N'国家数字代码', N'#140', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GU', N'关岛', N'国家数字代码', N'#141', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GY', N'圭亚那', N'国家数字代码', N'#142', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AD', N'安道尔', N'国家数字代码', N'#143', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'HN', N'洪都拉斯', N'国家数字代码', N'#144', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AO', N'安哥拉', N'国家数字代码', N'#145', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GA', N'加蓬', N'国家数字代码', N'#146', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'DJ', N'吉布提', N'国家数字代码', N'#147', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GN', N'几内亚', N'国家数字代码', N'#148', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CI', N'科特迪瓦', N'国家数字代码', N'#149', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AG', N'安提瓜', N'国家数字代码', N'#150', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'LR', N'利比里亚', N'国家数字代码', N'#151', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'LY', N'利比亚', N'国家数字代码', N'#152', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'留尼旺岛', N'国家数字代码', N'#153', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'RW', N'卢旺达', N'国家数字代码', N'#154', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MW', N'马拉维', N'国家数字代码', N'#155', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'ML', N'马里', N'国家数字代码', N'#156', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'马约群岛', N'国家数字代码', N'#157', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'美国西部', N'国家数字代码', N'#158', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MN', N'蒙古', N'国家数字代码', N'#159', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BD', N'孟加拉', N'国家数字代码', N'#160', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MM', N'缅甸', N'国家数字代码', N'#161', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MC', N'摩纳哥', N'国家数字代码', N'#162', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'NP', N'尼泊尔', N'国家数字代码', N'#163', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'NI', N'尼加拉瓜', N'国家数字代码', N'#164', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SL', N'塞拉利昂', N'国家数字代码', N'#165', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SN', N'塞内加尔', N'国家数字代码', N'#166', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'WS', N'萨摩亚', N'国家数字代码', N'#167', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BM', N'百慕大', N'国家数字代码', N'#168', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'圣基茨', N'国家数字代码', N'#169', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SM', N'圣马力诺', N'国家数字代码', N'#170', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SD', N'苏丹', N'国家数字代码', N'#171', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SR', N'苏里南', N'国家数字代码', N'#172', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'TO', N'汤加', N'国家数字代码', N'#173', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'VU', N'瓦努阿图', N'国家数字代码', N'#174', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'UG', N'乌干达', N'国家数字代码', N'#175', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SY', N'叙利亚', N'国家数字代码', N'#176', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'JM', N'牙买加', N'国家数字代码', N'#177', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GI', N'直布罗陀', N'国家数字代码', N'#178', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BJ', N'贝宁', N'国家数字代码', N'#179', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BS', N'巴哈马', N'国家数字代码', N'#180', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SZ', N'斯威士兰', N'国家数字代码', N'#181', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'塔希堤', N'国家数字代码', N'#182', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BT', N'不丹', N'国家数字代码', N'#183', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BI', N'布隆迪', N'国家数字代码', N'#184', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'TG', N'多哥', N'国家数字代码', N'#185', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'多米尼加岛', N'国家数字代码', N'#186', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CG', N'刚果', N'国家数字代码', N'#187', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'荷属安的列斯群岛', N'国家数字代码', N'#188', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'LI', N'列支敦士登', N'国家数字代码', N'#189', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MG', N'马达加斯加', N'国家数字代码', N'#190', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MR', N'毛里塔尼亚', N'国家数字代码', N'#191', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'MH', N'马绍尔群岛', N'国家数字代码', N'#192', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AS', N'美属萨摩亚', N'国家数字代码', N'#193', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'FM', N'密克罗尼西亚', N'国家数字代码', N'#194', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PM', N'圣皮埃尔和密克隆', N'国家数字代码', N'#195', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PF', N'波利尼西亚', N'国家数字代码', N'#196', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'ET', N'埃塞俄比亚', N'国家数字代码', N'#197', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'CD', N'刚果民主共和国', N'国家数字代码', N'#198', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'KI', N'基里巴斯', N'国家数字代码', N'#199', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'SO', N'索马里', N'国家数字代码', N'#200', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'大溪地', N'国家数字代码', N'#201', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GD', N'格林纳达', N'国家数字代码', N'#202', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'AI', N'安圭拉', N'国家数字代码', N'#203', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'荷属安提尔群岛', N'国家数字代码', N'#204', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GW', N'几内亚比绍', N'国家数字代码', N'#205', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'BM', N'百慕大群岛', N'国家数字代码', N'#206', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'泽西岛', N'国家数字代码', N'#207', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'格恩西岛', N'国家数字代码', N'#208', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'科西嘉岛', N'国家数字代码', N'#209', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PT', N'马德拉群岛', N'国家数字代码', N'#210', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'PT', N'亚速尔群岛', N'国家数字代码', N'#211', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'ES', N'巴利阿里群岛', N'国家数字代码', N'#212', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'撒丁岛', N'国家数字代码', N'#213', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'西西里岛', N'国家数字代码', N'#214', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'圣马丁', N'国家数字代码', N'#215', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'加纳利群岛', N'国家数字代码', N'#216', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'VA', N'梵蒂冈', N'国家数字代码', N'#217', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'圣基斯和尼维尔', N'国家数字代码', N'#218', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'GQ', N'赤道几内亚', N'国家数字代码', N'#219', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'NR', N'瑙鲁共和国', N'国家数字代码', N'#220', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'塞班岛', N'国家数字代码', N'#221', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', NULL, N'塔希提', N'国家数字代码', N'#222', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'181', N'DO', N'多米尼加共和国', N'国家数字代码', N'#223', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BR', N'巴西', N'国家数字代码', N'#1', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'RU', N'俄罗斯', N'国家数字代码', N'#2', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'FR', N'法国', N'国家数字代码', N'#3', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'ES', N'西班牙', N'国家数字代码', N'#4', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'UA', N'乌克兰', N'国家数字代码', N'#5', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'DE', N'德国', N'国家数字代码', N'#6', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'IL', N'以色列', N'国家数字代码', N'#7', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GB', N'英国', N'国家数字代码', N'#8', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'SE', N'瑞典', N'国家数字代码', N'#9', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'CA', N'加拿大', N'国家数字代码', N'#10', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'NL', N'荷兰', N'国家数字代码', N'#11', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'NZ', N'新西兰', N'国家数字代码', N'#12', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'US', N'美国', N'国家数字代码', N'#13', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AU', N'澳大利亚', N'国家数字代码', N'#14', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'NO', N'挪威', N'国家数字代码', N'#15', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GR', N'希腊', N'国家数字代码', N'#16', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BY', N'白俄罗斯', N'国家数字代码', N'#17', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'TR', N'土耳其', N'国家数字代码', N'#18', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'HU', N'匈牙利', N'国家数字代码', N'#19', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'CH', N'瑞士', N'国家数字代码', N'#20', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'CZ', N'捷克', N'国家数字代码', N'#21', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'IE', N'爱尔兰', N'国家数字代码', N'#22', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'EE', N'爱沙尼亚', N'国家数字代码', N'#23', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'DK', N'丹麦', N'国家数字代码', N'#24', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'HR', N'克罗地亚', N'国家数字代码', N'#25', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'CL', N'智利', N'国家数字代码', N'#26', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MT', N'马耳他', N'国家数字代码', N'#27', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'SK', N'斯洛伐克', N'国家数字代码', N'#28', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'PT', N'葡萄牙', N'国家数字代码', N'#29', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'FI', N'芬兰', N'国家数字代码', N'#30', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BG', N'保加利亚', N'国家数字代码', N'#31', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'LV', N'拉脱维亚', N'国家数字代码', N'#32', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'LT', N'立陶宛', N'国家数字代码', N'#33', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'PL', N'波兰', N'国家数字代码', N'#34', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MX', N'墨西哥', N'国家数字代码', N'#35', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'IT', N'意大利', N'国家数字代码', N'#36', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'KR', N'韩国', N'国家数字代码', N'#37', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'RO', N'罗马尼亚', N'国家数字代码', N'#38', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'KZ', N'哈萨克斯坦', N'国家数字代码', N'#39', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'CY', N'塞浦路斯', N'国家数字代码', N'#40', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'TH', N'泰国', N'国家数字代码', N'#41', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BE', N'比利时', N'国家数字代码', N'#42', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'ID', N'印度尼西亚', N'国家数字代码', N'#43', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'SA', N'沙特阿拉伯', N'国家数字代码', N'#44', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'SI', N'斯洛文尼亚', N'国家数字代码', N'#45', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AT', N'奥地利', N'国家数字代码', N'#46', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'IN', N'印度', N'国家数字代码', N'#47', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'SG', N'新加坡', N'国家数字代码', N'#48', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'PE', N'秘鲁', N'国家数字代码', N'#49', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MD', N'摩尔多瓦', N'国家数字代码', N'#50', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MY', N'马来西亚', N'国家数字代码', N'#51', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AR', N'阿根廷', N'国家数字代码', N'#52', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'JP', N'日本', N'国家数字代码', N'#53', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'TS', N'塞尔维亚', N'国家数字代码', N'#54', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AZ', N'阿塞拜疆', N'国家数字代码', N'#55', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'Co', N'哥伦比亚', N'国家数字代码', N'#56', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'ZA', N'南非', N'国家数字代码', N'#57', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'LK', N'斯里兰卡', N'国家数字代码', N'#58', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'IS', N'冰岛', N'国家数字代码', N'#59', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MK', N'马其顿', N'国家数字代码', N'#60', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'NG', N'尼日利亚', N'国家数字代码', N'#61', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'UY', N'乌拉圭', N'国家数字代码', N'#62', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'LB', N'黎巴嫩', N'国家数字代码', N'#63', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'PH', N'菲律宾', N'国家数字代码', N'#64', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BN', N'文莱', N'国家数字代码', N'#65', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AL', N'阿尔巴尼亚', N'国家数字代码', N'#66', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'EC', N'厄瓜多尔', N'国家数字代码', N'#67', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AE', N'阿联酋', N'国家数字代码', N'#68', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AM', N'亚美尼亚', N'国家数字代码', N'#69', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'UZ', N'乌兹别克斯坦', N'国家数字代码', N'#70', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'LU', N'卢森堡', N'国家数字代码', N'#71', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MU', N'毛里求斯', N'国家数字代码', N'#72', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BA', N'波黑', N'国家数字代码', N'#73', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'KW', N'科威特', N'国家数字代码', N'#74', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'ME', N'黑山', N'国家数字代码', N'#75', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'VE', N'委内瑞拉', N'国家数字代码', N'#76', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'OM', N'阿曼', N'国家数字代码', N'#77', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'SV', N'萨尔瓦多', N'国家数字代码', N'#78', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MV', N'马尔代夫', N'国家数字代码', N'#79', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GE', N'格鲁吉亚', N'国家数字代码', N'#80', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'PK', N'巴基斯坦', N'国家数字代码', N'#81', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'VN', N'越南', N'国家数字代码', N'#82', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'QA', N'卡塔尔', N'国家数字代码', N'#83', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'CR', N'哥斯达黎加', N'国家数字代码', N'#84', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'PS', N'巴勒斯坦', N'国家数字代码', N'#85', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GH', N'加纳', N'国家数字代码', N'#86', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'CT', N'台湾', N'国家数字代码', N'#87', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'ZM', N'赞比亚', N'国家数字代码', N'#88', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'IR', N'伊朗', N'国家数字代码', N'#89', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'DZ', N'阿尔及利亚', N'国家数字代码', N'#90', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'PR', N'波多黎各', N'国家数字代码', N'#91', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'EG', N'埃及', N'国家数字代码', N'#92', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'TM', N'土库曼斯坦', N'国家数字代码', N'#93', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BO', N'玻利维亚', N'国家数字代码', N'#94', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'PF', N'法属波利尼西亚', N'国家数字代码', N'#95', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'HK', N'香港', N'国家数字代码', N'#96', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BH', N'巴林', N'国家数字代码', N'#97', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'KE', N'肯尼亚', N'国家数字代码', N'#98', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'LC', N'圣卢西亚', N'国家数字代码', N'#99', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'NC', N'新喀里多尼亚', N'国家数字代码', N'#100', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'KH', N'柬埔寨', N'国家数字代码', N'#101', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', NULL, N'留尼汪岛', N'国家数字代码', N'#102', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'YE', N'也门', N'国家数字代码', N'#103', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GP', N'瓜德罗普', N'国家数字代码', N'#104', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'FJ', N'斐济', N'国家数字代码', N'#105', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'IQ', N'伊拉克', N'国家数字代码', N'#106', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MA', N'摩洛哥', N'国家数字代码', N'#107', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'PG', N'巴布亚新几内亚', N'国家数字代码', N'#108', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'PY', N'巴拉圭', N'国家数字代码', N'#109', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'KG', N'吉尔吉斯斯坦', N'国家数字代码', N'#110', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'CM', N'喀麦隆', N'国家数字代码', N'#111', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'JO', N'约旦', N'国家数字代码', N'#112', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'SC', N'塞舌尔', N'国家数字代码', N'#113', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'LA', N'老挝', N'国家数字代码', N'#114', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BZ', N'伯利兹', N'国家数字代码', N'#115', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'KP', N'朝鲜', N'国家数字代码', N'#116', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'ZW', N'津巴布韦', N'国家数字代码', N'#117', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'CK', N'库克群岛', N'国家数字代码', N'#118', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'TJ', N'塔吉克斯坦', N'国家数字代码', N'#119', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'PA', N'巴拿马', N'国家数字代码', N'#120', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GF', N'法属圭亚那', N'国家数字代码', N'#121', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'TT', N'特立尼达和多巴哥', N'国家数字代码', N'#122', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MQ', N'马提尼克', N'国家数字代码', N'#123', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GM', N'冈比亚', N'国家数字代码', N'#124', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'TN', N'突尼斯', N'国家数字代码', N'#125', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BN', N'文莱达鲁萨兰', N'国家数字代码', N'#126', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'TZ', N'坦桑尼亚', N'国家数字代码', N'#127', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BW', N'博茨瓦纳', N'国家数字代码', N'#128', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'FO', N'法罗群岛', N'国家数字代码', N'#129', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'CU', N'古巴', N'国家数字代码', N'#130', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'NA', N'纳米比亚', N'国家数字代码', N'#131', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'NE', N'尼日尔', N'国家数字代码', N'#132', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AF', N'阿富汗', N'国家数字代码', N'#133', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MO', N'澳门', N'国家数字代码', N'#134', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'KY', N'开曼群岛', N'国家数字代码', N'#135', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MZ', N'莫桑比克', N'国家数字代码', N'#136', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'HT', N'海地', N'国家数字代码', N'#137', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GT', N'危地马拉', N'国家数字代码', N'#138', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'BB', N'巴巴多斯', N'国家数字代码', N'#139', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AW', N'阿鲁巴', N'国家数字代码', N'#140', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GU', N'关岛', N'国家数字代码', N'#141', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GY', N'圭亚那', N'国家数字代码', N'#142', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AD', N'安道尔', N'国家数字代码', N'#143', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'HN', N'洪都拉斯', N'国家数字代码', N'#144', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AO', N'安哥拉', N'国家数字代码', N'#145', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GA', N'加蓬', N'国家数字代码', N'#146', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'DJ', N'吉布提', N'国家数字代码', N'#147', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'GN', N'几内亚', N'国家数字代码', N'#148', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'CI', N'科特迪瓦', N'国家数字代码', N'#149', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'AG', N'安提瓜', N'国家数字代码', N'#150', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'LR', N'利比里亚', N'国家数字代码', N'#151', NULL, NULL)
GO
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'LY', N'利比亚', N'国家数字代码', N'#152', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', NULL, N'留尼旺岛', N'国家数字代码', N'#153', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'RW', N'卢旺达', N'国家数字代码', N'#154', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'MW', N'马拉维', N'国家数字代码', N'#155', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', N'ML', N'马里', N'国家数字代码', N'#156', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticModeCode], [CountryCode], [CountryName], [ParamType], [ParamValue1], [ParamValue2], [ParamValue3]) VALUES (7, N'182', NULL, N'马约群岛', N'国家数字代码', N'#157', NULL, NULL)
INSERT [dbo].[ErpLogisticModeParam] ([LogisticId], [LogisticM