﻿
IF OBJECT_ID(N'[dbo].[FK_HgReRolePermission]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[HgRolePermission] DROP CONSTRAINT [FK_HgReRolePermission];
GO
IF OBJECT_ID(N'[dbo].[FK_HgReTaskType]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[HgTask] DROP CONSTRAINT [FK_HgReTaskType];
GO
IF OBJECT_ID(N'[dbo].[FK_HgUserPreference]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[HgUserPreference] DROP CONSTRAINT [FK_HgUserPreference];
GO

IF OBJECT_ID(N'[dbo].[HgUser]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgUser];
GO
IF OBJECT_ID(N'[dbo].[HgDept]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgDept];
GO
IF OBJECT_ID(N'[dbo].[HgPermission]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgPermission];
GO
IF OBJECT_ID(N'[dbo].[HgRolePermission]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgRolePermission];
GO
IF OBJECT_ID(N'[dbo].[HgRole]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgRole];
GO
IF OBJECT_ID(N'[dbo].[HgUserRole]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgUserRole];
GO
IF OBJECT_ID(N'[dbo].[HgOperateLog]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgOperateLog];
GO
IF OBJECT_ID(N'[dbo].[HgLogin]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgLogin];
GO
IF OBJECT_ID(N'[dbo].[HgMenu]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgMenu];
GO
IF OBJECT_ID(N'[dbo].[HgCatalog]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgCatalog];
GO
IF OBJECT_ID(N'[dbo].[HgCatalogType]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgCatalogType];
GO
IF OBJECT_ID(N'[dbo].[HgColumnSetting]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgColumnSetting];
GO
IF OBJECT_ID(N'[dbo].[HgColumnOption]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgColumnOption];
GO
IF OBJECT_ID(N'[dbo].[HgColumnCode]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgColumnCode];
GO
IF OBJECT_ID(N'[dbo].[HgSysSetting]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgSysSetting];
GO
IF OBJECT_ID(N'[dbo].[HgArea]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgArea];
GO
IF OBJECT_ID(N'[dbo].[HgCountry]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgCountry];
GO
IF OBJECT_ID(N'[dbo].[HgViewSource]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgViewSource];
GO
IF OBJECT_ID(N'[dbo].[HgCurrency]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgCurrency];
GO
IF OBJECT_ID(N'[dbo].[HgNotifyType]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgNotifyType];
GO
IF OBJECT_ID(N'[dbo].[HgNotifyMail]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgNotifyMail];
GO
IF OBJECT_ID(N'[dbo].[HgComment]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgComment];
GO
IF OBJECT_ID(N'[dbo].[HgTask]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgTask];
GO
IF OBJECT_ID(N'[dbo].[HgTaskType]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgTaskType];
GO
IF OBJECT_ID(N'[dbo].[HgUserPreference]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgUserPreference];
GO
IF OBJECT_ID(N'[dbo].[HgMark]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgMark];
GO
IF OBJECT_ID(N'[dbo].[HgMarkRelation]', 'U') IS NOT NULL
    DROP TABLE [dbo].[HgMarkRelation];
GO
-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'HgUser'
CREATE TABLE [dbo].[HgUser] (
    [UserId] int IDENTITY(1,1) NOT NULL,
    [DeptId] int  NOT NULL,
    [RealName] nvarchar(64)  NULL,
    [LoginName] nvarchar(64)  NULL,
    [Password] nvarchar(64)  NULL,
    [IsAdmin] bit  NOT NULL,
    [UserState] smallint  NOT NULL,
    [UserCode] nvarchar(64)  NULL,
    [Email] nvarchar(64)  NULL,
    [Mobile] nvarchar(32)  NULL,
    [Telphone] nvarchar(32)  NULL,
    [LastLoginTime] datetime  NULL,
    [CreateId] int  NOT NULL,
    [Remarks] nvarchar(max)  NULL,
    [CreateTime] datetime  NULL,
    [Creator] nvarchar(64)  NULL
);
GO

-- Creating table 'HgDept'
CREATE TABLE [dbo].[HgDept] (
    [DeptId] int IDENTITY(1,1) NOT NULL,
    [DeptName] nvarchar(64)  NULL,
    [ParentDeptId] int  NULL,
    [DeptIdPath] nvarchar(128)  NULL,
    [HasChild] bit  NOT NULL,
    [LevelNum] int  NOT NULL,
    [OrderNo] int  NOT NULL,
    [Remarks] nvarchar(max)  NULL,
    [CreateTime] datetime  NULL,
    [Creator] nvarchar(64)  NULL
);
GO

-- Creating table 'HgPermission'
CREATE TABLE [dbo].[HgPermission] (
    [PermissionCode] nvarchar(32)  NOT NULL,
    [PermissionName] nvarchar(64)  NULL,
    [ControllerName] nvarchar(64)  NULL,
    [ActionName] nvarchar(64)  NULL,
    [ParentPermissionCode] nvarchar(32)  NULL,
    [PermissionType] smallint  NULL,
    [Remarks] nvarchar(max)  NULL,
    [IsTryout] bit  NULL
);
GO

-- Creating table 'HgRolePermission'
CREATE TABLE [dbo].[HgRolePermission] (
    [RoleId] int  NOT NULL,
    [PermissionCode] nvarchar(32)  NOT NULL
);
GO

-- Creating table 'HgRole'
CREATE TABLE [dbo].[HgRole] (
    [RoleId] int IDENTITY(1,1) NOT NULL,
    [RoleName] nvarchar(64)  NULL,
    [CatalogId] int  NOT NULL,
    [Remarks] nvarchar(max)  NULL,
    [CreateTime] datetime  NULL,
    [Creator] nvarchar(64)  NULL
);
GO

-- Creating table 'HgUserRole'
CREATE TABLE [dbo].[HgUserRole] (
    [UserId] int  NOT NULL,
    [RoleId] int  NOT NULL
);
GO

-- Creating table 'HgOperateLog'
CREATE TABLE [dbo].[HgOperateLog] (
    [LogId] int IDENTITY(1,1) NOT NULL,
    [UserId] int  NOT NULL,
    [PermissionCode] nvarchar(32)  NULL,
    [ContentTable] nvarchar(64)  NULL,
    [PrimaryKeyValue] nvarchar(256)  NULL,
    [OperateTitle] nvarchar(256)  NULL,
    [Context] nvarchar(max)  NULL,
    [IPAddress] nvarchar(32)  NOT NULL,
    [URL] nvarchar(128)  NULL,
    [Creator] nvarchar(64)  NOT NULL,
    [CreateTime] datetime  NULL
);
GO

-- Creating table 'HgLogin'
CREATE TABLE [dbo].[HgLogin] (
    [LoginId] int IDENTITY(1,1) NOT NULL,
    [UserId] int  NOT NULL,
    [LoginTime] datetime  NOT NULL,
    [IPAddress] nvarchar(32)  NULL,
    [PreviousLoginTime] datetime  NULL,
    [PreviousIPAddress] nvarchar(32)  NULL
);
GO

-- Creating table 'HgMenu'
CREATE TABLE [dbo].[HgMenu] (
    [MenuCode] nvarchar(32)  NOT NULL,
    [MenuName] nvarchar(64)  NULL,
    [OrderNo] int  NOT NULL,
    [LevelNo] int  NOT NULL,
    [MenuType] nvarchar(16)  NULL,
    [ParentMenuCode] nvarchar(32)  NULL,
    [MenuLink] nvarchar(128)  NULL,
    [MenuStyle] nvarchar(32)  NULL,
    [IsActive] bit  NOT NULL,
    [IsTryout] bit  NULL
);
GO

-- Creating table 'HgCatalog'
CREATE TABLE [dbo].[HgCatalog] (
    [CatalogId] int IDENTITY(1,1) NOT NULL,
    [CatalogName] nvarchar(64)  NULL,
    [TypeCode] nvarchar(32)  NOT NULL,
    [ParentCatalogId] int  NOT NULL,
    [CatalogIdPath] nvarchar(128)  NULL,
    [HasChild] bit  NOT NULL,
    [LevelNum] int  NOT NULL,
    [OrderNo] int  NOT NULL,
    [Remarks] nvarchar(max)  NULL,
    [CreateTime] datetime  NULL,
    [Creator] nvarchar(64)  NULL
);
GO

-- Creating table 'HgCatalogType'
CREATE TABLE [dbo].[HgCatalogType] (
    [TypeCode] nvarchar(32)  NOT NULL,
    [TypeName] nvarchar(64)  NULL,
    [RootId] int  NOT NULL,
    [ContentTable] nvarchar(32)  NULL,
    [OrderNo] int  NOT NULL,
    [Remarks] nvarchar(max)  NULL
);
GO

-- Creating table 'HgColumnSetting'
CREATE TABLE [dbo].[HgColumnSetting] (
    [TableName] nvarchar(32)  NOT NULL,
    [ColumnName] nvarchar(32)  NOT NULL,
    [TableTitle] nvarchar(64)  NOT NULL,
    [ColumnTitle] nvarchar(64)  NULL,
    [DataType] smallint  NOT NULL,
    [IsActive] bit  NOT NULL,
    [AllowEmpty] bit  NOT NULL,
    [DataFomart] nvarchar(128)  NULL,
    [OrderNo] int  NOT NULL
);
GO

-- Creating table 'HgColumnOption'
CREATE TABLE [dbo].[HgColumnOption] (
    [TableName] nvarchar(32)  NOT NULL,
    [ColumnName] nvarchar(32)  NOT NULL,
    [OptionValue] nvarchar(64)  NOT NULL,
    [TableTitle] nvarchar(64)  NOT NULL,
    [ColumnTitle] nvarchar(64)  NOT NULL,
    [OptionTitle] nvarchar(64)  NULL,
    [ParentValue] nvarchar(64)  NULL,
    [AllowEdit] bit  NOT NULL,
    [OrderNo] int  NOT NULL
);
GO

-- Creating table 'HgColumnCode'
CREATE TABLE [dbo].[HgColumnCode] (
    [TableName] nvarchar(64)  NOT NULL,
    [ColumnName] nvarchar(64)  NOT NULL,
    [TableTitle] nvarchar(64)  NOT NULL,
    [ColumnTitle] nvarchar(64)  NOT NULL,
    [Prefixion] nvarchar(32)  NULL,
    [PrefixionConnect] nvarchar(16)  NULL,
    [DateFormat] nvarchar(32)  NOT NULL,
    [Identify] int  NOT NULL,
    [IdentityBit] int  NOT NULL
);
GO

-- Creating table 'HgSysSetting'
CREATE TABLE [dbo].[HgSysSetting] (
    [SettingGroup] nvarchar(32)  NOT NULL,
    [SettingKey] nvarchar(32)  NOT NULL,
    [SettingTitle] nvarchar(64)  NULL,
    [SettingValue] nvarchar(256)  NULL,
    [SettingType] smallint  NULL,
    [SettingOption] nvarchar(64)  NULL,
    [AllowEdit] bit  NOT NULL,
    [OrderNo] int  NOT NULL,
    [Remarks] nvarchar(256)  NULL
);
GO

-- Creating table 'HgArea'
CREATE TABLE [dbo].[HgArea] (
    [ID] nvarchar(25)  NOT NULL,
    [Name] nvarchar(50)  NULL,
    [ParentID] nvarchar(50)  NULL,
    [ZipCode] nvarchar(50)  NULL,
    [Level] int  NULL,
    [Code] nvarchar(15)  NULL,
    [ParentName] nvarchar(50)  NULL,
    [NameEN] nvarchar(100)  NULL,
    [ParentNameEN] nvarchar(100)  NULL
);
GO
-- Creating table 'HgCountry'
CREATE TABLE [dbo].[HgCountry] (
    [CountryId] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(100)  NULL,
    [FullName] nvarchar(100)  NULL,
    [DoubleCharacterCode] nvarchar(10)  NULL,
    [ThreeCharacterCode] nvarchar(10)  NULL,
    [ThreeNumberCode] nvarchar(10)  NULL,
    [Domain] nvarchar(10)  NULL,
    [PhoneCode] nvarchar(10)  NULL,
    [EnglishName] nvarchar(100)  NULL,
    [EnglishFullName] nvarchar(200)  NULL,
	[Abbreviation] nvarchar(10)  NULL,
	[NationalSortingCode] nvarchar(64)  NULL
);
GO

-- Creating table 'HgViewSource'
CREATE TABLE [dbo].[HgViewSource] (
    [ViewName] nvarchar(20)  NOT NULL,
    [FieldName] nvarchar(64)  NOT NULL,
    [DataType] nvarchar(20)  NOT NULL,
    [Conditions] nvarchar(20)  NULL,
    [ChinaName] nvarchar(20)  NOT NULL,
    [IsEmpty] bit  NOT NULL,
    [IsMust] bit  NOT NULL,
    [Remarks] nvarchar(200)  NULL,
    [PageKey] nvarchar(36)  NOT NULL,
    [OrderNo] int  NULL
);
GO

-- Creating table 'HgCurrency'
CREATE TABLE [dbo].[HgCurrency] (
    [CurrencyName] nvarchar(32)  NOT NULL,
    [CurrencyNameCN] nvarchar(64)  NULL,
    [MiddleRate] decimal(18,5)  NOT NULL,
    [SystemRate] decimal(18,5)  NOT NULL,
    [PubTime] datetime  NULL,
    [IsMain] nvarchar(1)  NOT NULL,
    [Symbol] nvarchar(32)  NULL
);
GO
CREATE TABLE [dbo].[HgNotifyType] (
    [TypeCode] nvarchar(32)  NOT NULL,
    [TypeName] nvarchar(64)  NOT NULL,
    [IsMail] bit  NOT NULL,
    [MailTitleTemplate] nvarchar(256)  NULL,
    [MailContentTemplate] nvarchar(max)  NULL
);
GO
CREATE TABLE [dbo].[HgNotifyMail] (
    [NotifyId] bigint IDENTITY(1,1) NOT NULL,
    [MallAddress] nvarchar(64)  NOT NULL,
    [DisplayName] nvarchar(64)  NOT NULL,
    [Title] nvarchar(256)  NOT NULL,
    [Content] nvarchar(max)  NOT NULL,
    [IsSend] bit  NOT NULL,
    [IsSuccess] bit  NOT NULL,
    [TrySendTimer] int  NOT NULL,
    [SendTime] datetime  NULL,
    [NotifyType] nvarchar(32)  NOT NULL,
    [RelativeId] int  NULL,
    [Outtime] datetime  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateId] int  NULL,
    [CreateTime] datetime  NOT NULL,
    [Message] nvarchar(max)  NULL
);
GO

CREATE TABLE [dbo].[HgComment] (
    [CommentId] bigint IDENTITY(1,1) NOT NULL,
    [UserId] int  NOT NULL,
    [TypeCode] varchar(50)  NULL,
    [CommentType] nvarchar(32)  NOT NULL,
    [RelationId] int  NOT NULL,
    [Context] nvarchar(max)  NULL,
    [IPAddress] nvarchar(64)  NOT NULL,
    [Creator] nvarchar(64)  NOT NULL,
    [CreateTime] datetime  NOT NULL
);
GO
-- Creating table 'HgTask'
CREATE TABLE [dbo].[HgTask] (
    [TaskId] int IDENTITY(1,1) NOT NULL,
    [TypeCode] nvarchar(32)  NOT NULL,
    [TaskName] nvarchar(64)  NOT NULL,
    [IsActive] bit  NOT NULL,
    [TaskPeriod] smallint  NOT NULL,
    [PeriodUnit] smallint  NOT NULL,
    [PeriodValue] nvarchar(64)  NULL,
    [LastRunTime] datetime  NULL,
    [NextRunTime] datetime  NULL,
    [TaskOption1] nvarchar(64)  NULL,
    [TaskOption2] nvarchar(64)  NULL,
    [TaskOption3] nvarchar(64)  NULL,
    [TaskOption4] nvarchar(64)  NULL,
    [TaskOption5] nvarchar(64)  NULL,
    [CreateTime] datetime  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [Remorks] nvarchar(max)  NULL
);
GO
-- Creating table 'HgTaskType'
CREATE TABLE [dbo].[HgTaskType] (
    [TypeCode] nvarchar(32)  NOT NULL,
    [TypeName] nvarchar(max)  NOT NULL,
    [Component] nvarchar(128)  NULL,
    [TaskOption1] nvarchar(64)  NULL,
    [TaskOption2] nvarchar(64)  NULL,
    [TaskOption3] nvarchar(64)  NULL,
    [TaskOption4] nvarchar(64)  NULL,
    [TaskOption5] nvarchar(64)  NULL,
    [Remarks] nvarchar(max)  NULL
);
GO


-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [UserId] in table 'HgUser'
ALTER TABLE [dbo].[HgUser]
ADD CONSTRAINT [PK_HgUser]
    PRIMARY KEY CLUSTERED ([UserId] ASC);
GO

-- Creating primary key on [DeptId] in table 'HgDept'
ALTER TABLE [dbo].[HgDept]
ADD CONSTRAINT [PK_HgDept]
    PRIMARY KEY CLUSTERED ([DeptId] ASC);
GO

-- Creating primary key on [PermissionCode] in table 'HgPermission'
ALTER TABLE [dbo].[HgPermission]
ADD CONSTRAINT [PK_HgPermission]
    PRIMARY KEY CLUSTERED ([PermissionCode] ASC);
GO

-- Creating primary key on [RoleId], [PermissionCode] in table 'HgRolePermission'
ALTER TABLE [dbo].[HgRolePermission]
ADD CONSTRAINT [PK_HgRolePermission]
    PRIMARY KEY CLUSTERED ([RoleId], [PermissionCode] ASC);
GO

-- Creating primary key on [RoleId] in table 'HgRole'
ALTER TABLE [dbo].[HgRole]
ADD CONSTRAINT [PK_HgRole]
    PRIMARY KEY CLUSTERED ([RoleId] ASC);
GO

-- Creating primary key on [RoleId], [UserId] in table 'HgUserRole'
ALTER TABLE [dbo].[HgUserRole]
ADD CONSTRAINT [PK_HgUserRole]
    PRIMARY KEY CLUSTERED ([RoleId], [UserId] ASC);
GO

-- Creating primary key on [LogId] in table 'HgOperateLog'
ALTER TABLE [dbo].[HgOperateLog]
ADD CONSTRAINT [PK_HgOperateLog]
    PRIMARY KEY CLUSTERED ([LogId] ASC);
GO

-- Creating primary key on [LoginId] in table 'HgLogin'
ALTER TABLE [dbo].[HgLogin]
ADD CONSTRAINT [PK_HgLogin]
    PRIMARY KEY CLUSTERED ([LoginId] ASC);
GO

-- Creating primary key on [MenuCode] in table 'HgMenu'
ALTER TABLE [dbo].[HgMenu]
ADD CONSTRAINT [PK_HgMenu]
    PRIMARY KEY CLUSTERED ([MenuCode] ASC);
GO

-- Creating primary key on [CatalogId] in table 'HgCatalog'
ALTER TABLE [dbo].[HgCatalog]
ADD CONSTRAINT [PK_HgCatalog]
    PRIMARY KEY CLUSTERED ([CatalogId] ASC);
GO

-- Creating primary key on [TypeCode] in table 'HgCatalogType'
ALTER TABLE [dbo].[HgCatalogType]
ADD CONSTRAINT [PK_HgCatalogType]
    PRIMARY KEY CLUSTERED ([TypeCode] ASC);
GO

-- Creating primary key on [TableName], [ColumnName] in table 'HgColumnSetting'
ALTER TABLE [dbo].[HgColumnSetting]
ADD CONSTRAINT [PK_HgColumnSetting]
    PRIMARY KEY CLUSTERED ([TableName], [ColumnName] ASC);
GO

-- Creating primary key on [TableName], [OptionValue], [ColumnName] in table 'HgColumnOption'
ALTER TABLE [dbo].[HgColumnOption]
ADD CONSTRAINT [PK_HgColumnOption]
    PRIMARY KEY CLUSTERED ([TableName], [OptionValue], [ColumnName] ASC);
GO

-- Creating primary key on [TableName], [ColumnName] in table 'HgColumnCode'
ALTER TABLE [dbo].[HgColumnCode]
ADD CONSTRAINT [PK_HgColumnCode]
    PRIMARY KEY CLUSTERED ([TableName], [ColumnName] ASC);
GO

-- Creating primary key on [SettingGroup], [SettingKey] in table 'HgSysSetting'
ALTER TABLE [dbo].[HgSysSetting]
ADD CONSTRAINT [PK_HgSysSetting]
    PRIMARY KEY CLUSTERED ([SettingGroup], [SettingKey] ASC);
GO

-- Creating primary key on [ID] in table 'HgArea'
ALTER TABLE [dbo].[HgArea]
ADD CONSTRAINT [PK_HgArea]
    PRIMARY KEY CLUSTERED ([ID] ASC);
GO

-- Creating primary key on [CountryId] in table 'HgCountry'
ALTER TABLE [dbo].[HgCountry]
ADD CONSTRAINT [PK_HgCountry]
    PRIMARY KEY CLUSTERED ([CountryId] ASC);
GO

-- Creating primary key on [ViewName], [FieldName], [PageKey] in table 'HgViewSource'
ALTER TABLE [dbo].[HgViewSource]
ADD CONSTRAINT [PK_HgViewSource]
    PRIMARY KEY CLUSTERED ([ViewName], [FieldName], [PageKey] ASC);
GO

-- Creating primary key on [CurrencyName] in table 'HgCurrency'
ALTER TABLE [dbo].[HgCurrency]
ADD CONSTRAINT [PK_HgCurrency]
    PRIMARY KEY CLUSTERED ([CurrencyName] ASC);
GO

ALTER TABLE [dbo].[HgNotifyType]
ADD CONSTRAINT [PK_HgNotifyType]
    PRIMARY KEY CLUSTERED ([TypeCode] ASC);
GO
ALTER TABLE [dbo].[HgNotifyMail]
ADD CONSTRAINT [PK_HgNotifyMail]
    PRIMARY KEY CLUSTERED ([NotifyId] ASC);
GO
-- Creating primary key on [CommentId] in table 'HgComment'
ALTER TABLE [dbo].[HgComment]
ADD CONSTRAINT [PK_HgComment]
    PRIMARY KEY CLUSTERED ([CommentId] ASC);
GO
-- Creating primary key on [TaskId] in table 'HgTask'
ALTER TABLE [dbo].[HgTask]
ADD CONSTRAINT [PK_HgTask]
    PRIMARY KEY CLUSTERED ([TaskId] ASC);
GO

-- Creating primary key on [TypeCode] in table 'HgTaskType'
ALTER TABLE [dbo].[HgTaskType]
ADD CONSTRAINT [PK_HgTaskType]
    PRIMARY KEY CLUSTERED ([TypeCode] ASC);
GO


-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [RoleId] in table 'HgRolePermission'
ALTER TABLE [dbo].[HgRolePermission] WITH NOCHECK
ADD CONSTRAINT [FK_HgReRolePermission]
    FOREIGN KEY ([RoleId])
    REFERENCES [dbo].[HgRole]
        ([RoleId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[HgRolePermission] NOCHECK CONSTRAINT [FK_HgReRolePermission];
GO

-- Creating foreign key on [TypeCode] in table 'HgTask'
ALTER TABLE [dbo].[HgTask] WITH NOCHECK
ADD CONSTRAINT [FK_HgReTaskType]
    FOREIGN KEY ([TypeCode])
    REFERENCES [dbo].[HgTaskType]
        ([TypeCode])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

ALTER TABLE [dbo].[HgTask] NOCHECK CONSTRAINT [FK_HgReTaskType];
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_HgReTaskType'
CREATE INDEX [IX_FK_HgReTaskType]
ON [dbo].[HgTask]
    ([TypeCode]);
GO

-- Creating table 'HgPhotoBank'
CREATE TABLE [dbo].[HgPhotoBank] (
    [PhotoBankId] bigint IDENTITY(1,1) NOT NULL,
    [DisplayName] nvarchar(256)  NULL,
    [CatalogId] bigint  NOT NULL,
    [FileSize] decimal(18,2)  NOT NULL,
    [Width] int  NOT NULL,
    [Height] int  NOT NULL,
    [PhotoSource] nvarchar(256)  NULL,
    [Url] nvarchar(512)  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL
);
GO
-- Creating table 'HgPhotoBankUse'
CREATE TABLE [dbo].[HgPhotoBankUse] (
    [PhotoBankUseId] bigint IDENTITY(1,1) NOT NULL,
    [PhotoBankId] bigint  NOT NULL,
    [UseTable] nvarchar(64)  NULL,
    [UseColumn] nvarchar(64)  NULL,
    [UseId] bigint  NOT NULL,
    [IsMain] bit  NOT NULL,
    [ListOrder] int  NOT NULL
);
GO

-- Creating table 'HgUserPreference'
CREATE TABLE [dbo].[HgUserPreference] (
    [PreferenceId] int IDENTITY(1,1) NOT NULL,
    [UserId] int  NOT NULL,
    [PreferenceItem] nvarchar(256)  NOT NULL,
    [PreferenceValue] nvarchar(256)  NULL,
    [UpdateTime] datetime  NULL,
    [Remarks] nvarchar(512)  NULL
);
GO
-- Creating primary key on [PreferenceId] in table 'HgUserPreference'
ALTER TABLE [dbo].[HgUserPreference]
ADD CONSTRAINT [PK_HgUserPreference]
    PRIMARY KEY CLUSTERED ([PreferenceId] ASC);
GO


-- Creating table 'HgMark'
CREATE TABLE [dbo].[HgMark] (
    [MarkId] int IDENTITY(1,1) NOT NULL,
    [MarkGroup] nvarchar(64)  NULL,
    [MarkKey] nvarchar(64)  NULL,
    [MarkTitle] nvarchar(max)  NULL,
    [MarkColor] nvarchar(max)  NULL,
    [IsSystem] bit  NULL,
    [OrderNo] int  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL
);
GO

-- Creating table 'HgMarkRelation'
CREATE TABLE [dbo].[HgMarkRelation] (
    [MarkRelationId] int IDENTITY(1,1) NOT NULL,
    [RelationId] int  NULL,
    [MarkId] int  NULL,
    [MarkGroup] nvarchar(64)  NULL
);
GO
-- Creating primary key on [MarkId] in table 'HgMark'
ALTER TABLE [dbo].[HgMark]
ADD CONSTRAINT [PK_HgMark]
    PRIMARY KEY CLUSTERED ([MarkId] ASC);
GO
-- Creating primary key on [MarkRelationId] in table 'HgMarkRelation'
ALTER TABLE [dbo].[HgMarkRelation]
ADD CONSTRAINT [PK_HgMarkRelation]
    PRIMARY KEY CLUSTERED ([MarkRelationId] ASC);
GO