﻿
/* 创建通用的分页存储过程 */
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[procSelectDataByPager]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[procSelectDataByPager]
GO

Create Proc [dbo].[procSelectDataByPager]
(
  @Sql varchar(max) ,
  @Order varchar(4000) ,
  @CurrentPage int ,
  @PageSize int,
  @TotalCount int output
)
As
/* 只用于SQL2005及以下版本 */
Declare @Exec_sql nvarchar(max)
                
Set @Exec_sql='Set @TotalCount=(Select Count(1) From ('+@Sql+') As a)'
Exec sp_executesql @Exec_sql,N'@TotalCount int output',@TotalCount output
 
Set @Order=isnull(' Order by '+nullif(@Order,''),' Order By getdate()')
 
if @CurrentPage=1 /*经常会调用第1页，这里做特殊处理，少一层子查询*/
    Set @Exec_sql='
    ;With CTE_Exec As
    (
        '+@Sql+'
    )
    Select Top(@pagesize) *,row_number() Over('+@Order+') As r From CTE_Exec Order By r
    ' 
Else
    Set @Exec_sql='
    ;With CTE_Exec As
    (
        Select *,row_number() Over('+@Order+') As r From ('+@Sql+') As a 
    )
    Select * From CTE_Exec Where r Between (@CurrentPage-1)*@pagesize+1 And @CurrentPage*@pagesize Order By r
    '
 
 Exec sp_executesql @Exec_sql,N'@CurrentPage int,@PageSize int',@CurrentPage,@PageSize
GO
SET IDENTITY_INSERT [dbo].[HgDept] ON
INSERT [dbo].[HgDept] ([DeptId], [DeptName], [ParentDeptId], [DeptIdPath], [HasChild], [LevelNum], [OrderNo], [Remarks], [CreateTime], [Creator]) VALUES (1, N'组织架构', 0, N'1/', 0, 0, 1, NULL, CAST(0x0000A43F014663C4 AS DateTime), N'管理员')
SET IDENTITY_INSERT [dbo].[HgDept] OFF
SET IDENTITY_INSERT [dbo].[HgUser] ON
INSERT [dbo].[HgUser] ([UserId], [DeptId], [RealName], [LoginName], [Password], [IsAdmin], [UserState], [UserCode], [Email], [Mobile], [Telphone], [LastLoginTime], [CreateId], [Remarks], [CreateTime], [Creator]) VALUES (1, 1, N'管理员', N'admin', N'NfIWtmarnSEh5VvI', 1, 1, N'U0001', NULL, NULL, NULL, NULL, 1, NULL, CAST(0x0000A43F014663C4 AS DateTime), N'管理员')
SET IDENTITY_INSERT [dbo].[HgUser] OFF
GO
INSERT [dbo].[HgCatalogType] ([TypeCode], [TypeName], [RootId], [ContentTable], [OrderNo], [Remarks]) VALUES (N'role', N'角色分类', 1, N'HgRole', 10, N'角色分类')
SET IDENTITY_INSERT [dbo].[HgCatalog] ON
INSERT [dbo].[HgCatalog] ([CatalogId], [CatalogName], [TypeCode], [ParentCatalogId], [CatalogIdPath], [HasChild], [LevelNum], [OrderNo], [Remarks], [CreateTime], [Creator]) VALUES (1, N'角色目录', N'role', 0, N'/1/', 0, 0, 1, NULL, NULL, NULL)
SET IDENTITY_INSERT [dbo].[HgCatalog] OFF
GO
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'HgColumnCode', N'DataFormat', N'dd/MM/yyyy', N'编码规则表', N'日期格式', N'dd/MM/yyyy', NULL, 0, 4)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'HgColumnCode', N'DataFormat', N'ddMMyyyy', N'编码规则表', N'日期格式', N'ddMMyyyy', NULL, 0, 2)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'HgColumnCode', N'DataFormat', N'yyyyMMdd', N'编码规则表', N'日期格式', N'yyyyMMdd', NULL, 0, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'HgColumnCode', N'DataFormat', N'yyyy-MM-dd', N'编码规则表', N'日期格式', N'yyyy-MM-dd', NULL, 0, 3)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'HgPermission', N'PermissionType', N'1', N'权限表', N'权限类型', N'菜单', NULL, 0, 1)
INSERT [dbo].[HgColumnOption] ([TableName], [ColumnName], [OptionValue], [TableTitle], [ColumnTitle], [OptionTitle], [ParentValue], [AllowEdit], [OrderNo]) VALUES (N'HgPermission', N'PermissionType', N'2', N'权限表', N'权限类型', N'操作', NULL, 0, 2)
GO
--========系统配置
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_cmsfiles','文件目录',2,3,NULL,'cms_files','Catalog/CmsFiles/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_cmsnews','新闻目录',2,3,NULL,'cms_news','Catalog/CmsNews/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_cmsnotes','便条目录',2,3,NULL,'cms_notes','Catalog/CmsNotes/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_customer','客户目录',2,3,NULL,'erp_customer','Catalog/Customer/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_enterprise','企业目录管理',2,3,NULL,'mng_manage_manage','Catalog/Enterprise/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_ExamPaper','试卷目录',4,3,NULL,'rs_Exam','Catalog/ExamPaper/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_ExamQuestion','题库目录',3,3,NULL,'rs_Exam','Catalog/ExamQuestion/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_Lectuer','讲师目录',1,3,NULL,'rs_Lesson','Catalog/Lectuer/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_Lesson','课程目录',2,3,NULL,'rs_Lesson','Catalog/Lesson/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_photobank','图片银行目录',3,3,NULL,'erp_product_module','Catalog/PhotoBank/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_ProActiviy','活动目录',3,3,NULL,'pro_ActivityPlan','Catalog/ProActiviy/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_product','产品目录',2,3,NULL,'erp_product_module','Catalog/Product/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_role','角色目录管理',2,3,NULL,'hg_role','Catalog/Role/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('catalog_supplier','供应商目录',2,3,NULL,'erp_supplier','Catalog/Supplier/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_files','文件管理',2,2,NULL,'cms_manage','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_files_manage','文件发布',1,3,NULL,'cms_files','Files/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_forum_reply','问答管理',2,3,NULL,'cms_message','Forum/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_manage','内容管理',45,1,NULL,'','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_message','信息管理',4,2,NULL,'cms_manage','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_message_send','发送信息',1,3,NULL,'cms_message','Message/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_news','新闻管理',1,2,NULL,'cms_manage','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_news_manage','新闻发布',1,3,NULL,'cms_news','News/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_notes','便条管理',3,2,NULL,'cms_manage','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_notes_manage','便条管理',1,3,NULL,'cms_notes','Notes/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_software','软件服务',2,2,NULL,'cms_manage','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_software_manage','软件服务',1,3,NULL,'cms_software','SoftWare/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_wechat','微信平台',6,2,NULL,'mng_manage','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_wechat_Index','微信公众平台信息',1,3,NULL,'cms_wechat','WeChat/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('cms_wechat_Set','微信平台接口设置',2,3,NULL,'cms_wechat','WeChat/Setting',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('erp_wish_api_setting','Wish接口设置',2,3,NULL,'hg_businessplatform_setting','Common/SysSetting/WishApi',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_Column_BaseSet','系统基本设置',2,3,NULL,'hg_framework_setting','Column/BaseSet',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_column_code','编码规则设置',3,3,NULL,'hg_framework_setting','Column/Code',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_column_option','候选项设置',2,3,NULL,'hg_framework_setting','Column/Option',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_column_setting','扩展字段设置',1,3,NULL,'hg_framework_setting','Column/Setting',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_dept_manage','部门管理',3,3,NULL,'hg_role','Dept/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_email_setting','邮件设置',8,3,NULL,'hg_framework_setting','Common/SysSetting/EmailSetting',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_framework','系统配置',35,1,NULL,'','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_framework_setting','系统配置',1,2,NULL,'hg_framework','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_label_setting','标签管理',16,3,NULL,'hg_framework_setting','Label/LabelSetting',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_log_manage','操作日志',5,3,NULL,'hg_role','SysLog/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_mail_manage','邮件日志',6,3,NULL,'hg_role','Notify/MailManage',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_mark_setting','标记管理',15,3,NULL,'hg_framework_setting','Mark/MarkSetting',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_notify_setting','通知设置',9,3,NULL,'hg_framework_setting','Notify/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_photobank','图片银行',4,3,NULL,'erp_product_module','PhotoBank/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_role','用户权限管理',4,2,NULL,'hg_framework','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_role_manage','权限管理',1,3,NULL,'hg_role','Role/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hg_user_manage','用户管理',4,3,NULL,'hg_role','Account/UserIndex',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hr_note','笔记管理',2,2,NULL,'cms_manage','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('hr_note_manage','笔记管理',1,3,NULL,'hr_note','Note/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('mng_account_apply','帐户申请管理',4,3,NULL,'mng_manage_manage','AccountApply/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('mng_edition_manage','版本管理',5,3,NULL,'mng_manage_manage','Edition/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('mng_enterprise_manage','企业管理',1,3,NULL,'mng_manage_manage','Enterprise/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('mng_manage','企业管理',40,1,NULL,'','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('mng_manage_manage','企业管理',1,2,NULL,'mng_manage','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('mng_overdue_enterprise','将过期企业',3,3,NULL,'mng_manage_manage','Enterprise/Outdate',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('pro_ActivityPlan','活动安排',1,2,NULL,'pro_LearningActivity','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('pro_ActivityPlanManage','活动安排管理',1,3,NULL,'pro_ActivityPlan','ProTrainManage/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('pro_ActivityTypeManage','活动类型管理',2,3,NULL,'pro_ActivityPlan','ProTrainTypeManage/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('pro_LearningActivity','学习活动',1,1,NULL,'','ProTrainManage/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('Pro_TestGrade','考试成绩管理',2,3,NULL,'Pro_TestLookThrough','ProTestGrade/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('Pro_TestJudge','考试阅卷管理',3,3,NULL,'Pro_TestLookThrough','ProTestJudge/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('Pro_TestLookThrough','活动监控',1,2,NULL,'pro_LearningActivity','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('Pro_TrainGrade','学习过程监控',1,3,NULL,'Pro_TestLookThrough','ProTrainGrade/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('res_comment','评论管理',3,3,NULL,'cms_message','Comment/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_AccountTestGrade','考试成绩查询',1,3,NULL,'rs_ProExamChart','AccountTestGrade/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_AccountTrainGrade','学习记录查询',1,3,NULL,'rs_ProChart','AccountTrainGrade/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_AccountTrainSchedule','学习进度查询',1,3,NULL,'rs_ProChart','AccountTrainSchedule/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_AccountUserGrade','考生成绩查询',1,3,NULL,'rs_ProExamChart','AccountUserGrade/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_Exam','考评资源',1,2,NULL,'rs_ExamManage','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_ExamManage','资源管理',2,1,NULL,'','QuestionManage/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_ExamPaper','试卷管理',5,3,NULL,'rs_Exam','PaperManage/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_LectuerManage','讲师管理',1,3,NULL,'rs_Lesson','LectuerManage/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_Lesson','课程资源',1,2,NULL,'rs_ExamManage','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_LessonManage','课程管理',3,3,NULL,'rs_Lesson','LessonManage/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_OrginChart','组织机构统计',1,2,NULL,'rs_Report','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_OrginChartInfo','组织架构对比统计',1,3,NULL,'rs_ProExamChart','OrginChartInfo/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_OrginNums','按部门统计',2,3,NULL,'rs_OrginChart','OrginNums/Dep',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_OrginTree','组织架构图',1,3,NULL,'rs_OrginChart','OrginNums/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_ProChart','学习活动统计',1,2,NULL,'rs_Report','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_ProExamChart','考试统计',2,2,NULL,'rs_Report','',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_ProTrainChartInfo','部门考试统计',1,3,NULL,'rs_ProExamChart','ProTrainChartInfo/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_Question','题库管理',3,3,NULL,'rs_Exam','QuestionManage/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_QuestionChart','试题使用统计',1,3,NULL,'rs_ProExamChart','QuestionChart/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_QuestionType','题型管理',1,3,NULL,'rs_Exam','QuestionManage/QuestionType',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_Report','统计报表',3,1,NULL,'','AccountTestGrade/Index',NULL,1,0)
INSERT [dbo].HgMenu (menuCode, MenuName, OrderNo, LevelNo, MenuType, ParentMenuCode, MenuLink, MenuStyle, IsActive,IsTryout) values('rs_RoleNums','按角色统计',3,3,NULL,'rs_OrginChart','OrginNums/Role',NULL,1,0)
--========基本信息
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_cmsfiles', N'下载分类目录', '', '', N'cms_files', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_cmsnews', N'新闻分类目录', '', '', N'cms_news', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_cmsnotes', N'便条分类目录', '', '', N'cms_notes', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_customer', N'客户目录', '', '', N'erp_customer', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_enterprise', N'企业目录管理', '', '', N'mng_manage_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_ExamPaper', N'目录管理', '', '', N'rs_Exam', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_ExamQuestion', N'目录管理', '', '', N'rs_Exam', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_Lectuer', N'目录管理', '', '', N'rs_Lesson', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_Lesson', N'目录管理', '', '', N'rs_Lesson', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_photobank', N'图片银行目录', '', '', N'erp_product_module', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_ProActiviy', N'活动目录管理', '', '', N'pro_ActivityPlan', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_product', N'产品目录', '', '', N'erp_product_module', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_role', N'角色目录管理', '', '', N'hg_role', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'catalog_supplier', N'供应商目录', '', '', N'erp_supplier', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_files', N'文件管理', '', '', N'cms_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_files_catalog_delete', N'删除文件目录', 'CmsFilesCatalog', 'Delete', N'catalog_cmsfiles', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_files_catalog_edit', N'编辑文件目录', 'CmsFilesCatalog', 'Edit', N'catalog_cmsfiles', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_files_catalog_index', N'查询文件目录列表', 'CmsFilesCatalog', 'Index', N'catalog_cmsfiles', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_files_delete', N'删除文件', 'Files', 'Delete', N'cms_files_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_files_edit', N'编辑文件', 'Files', 'Edit', N'cms_files_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_files_index', N'编辑文件', 'Files', 'Index', N'cms_files_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_files_manage', N'文件发布', '', '', N'cms_files', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_files_up_delete', N'删除上传文件', 'Files', 'DeleteFiles', N'cms_files_edit', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_files_up_list', N'获取上传文件列表', 'Files', 'GetFilesList', N'cms_files_edit', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_forum_reply', N'问答管理', '', '', N'cms_message', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_forum_reply_index', N'问答管理', 'Forum', 'Index', N'cms_forum_reply', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_forum_reply_lookforum', N'问答管理', 'Forum', 'LookForum', N'cms_forum_reply', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_manage', N'内容管理', '', '', N'', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_message', N'信息管理', '', '', N'cms_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_message_send', N'发送信息', '', '', N'cms_message', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_message_send_index', N'发送信息', 'Message', 'Index', N'cms_message_send', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_news', N'新闻管理', '', '', N'cms_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_news_catalog_delete', N'删除新闻目录', 'CmsNewsCatalog', 'Delete', N'catalog_cmsnews', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_news_catalog_edit', N'编辑新闻目录', 'CmsNewsCatalog', 'Edit', N'catalog_cmsnews', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_news_catalog_index', N'查询新闻目录列表', 'CmsNewsCatalog', 'Index', N'catalog_cmsnews', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_news_delete', N'删除新闻', 'News', 'Delete', N'cms_news_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_news_edit', N'编辑新闻', 'News', 'Edit', N'cms_news_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_news_index', N'查询新闻列表', 'News', 'Index', N'cms_news_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_news_manage', N'新闻发布', '', '', N'cms_news', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_notes', N'便条管理', '', '', N'cms_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_notes_catalog_delete', N'删除便条目录', 'CmsNotesCatalog', 'Delete', N'catalog_cmsnotes', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_notes_catalog_edit', N'编辑便条目录', 'CmsNotesCatalog', 'Edit', N'catalog_cmsnotes', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_notes_catalog_index', N'查询便条目录列表', 'CmsNotesCatalog', 'Index', N'catalog_cmsnotes', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_notes_delete', N'删除便条', 'Notes', 'Delete', N'cms_notes_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_notes_edit', N'编辑便条', 'Notes', 'Edit', N'cms_notes_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_notes_index', N'编辑便条', 'Notes', 'Index', N'cms_notes_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_notes_manage', N'便条管理', '', '', N'cms_notes', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_software', N'软件服务', '', '', N'cms_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_software_delete', N'删除软件', 'SoftWare', 'Delete', N'cms_software_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_software_index', N'查询目录列表', 'SoftWare', 'Index', N'cms_software_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_software_manage', N'软件服务', '', '', N'cms_software', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_weChat', N'微信平台', '', '', N'mng_manage_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_weChat_Index', N'微信公众号信息', 'WeChat', 'Index', N'cms_weChat', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'cms_weChat_Setting', N'微信接口设置', 'WeChat', 'Setting', N'cms_weChat', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'erp_financial_setting', N'财务模块设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'erp_financial_setting_edit', N'编辑财务模块设置', 'Common', 'ErpFinancialModuleSysSetting', N'erp_financial_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'erp_order_setting', N'订单模块设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'erp_order_setting_edit', N'编辑订单模块设置', 'Common', 'ErpOrderModuleSysSetting', N'erp_order_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'erp_product_setting', N'产品模块设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'erp_stock_setting', N'库存模块设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_account_delete', N'删除用户信息', 'Account', 'Delete', N'hg_user_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_account_edit', N'编辑用户信息', 'Account', 'Edit', N'hg_user_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_account_index', N'浏览用户列表', 'Account', 'UserIndex', N'hg_user_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_BaseSet_index', N'基本模块设置', 'Column', 'BaseSet', N'hg_Column_BaseSet', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_Column_BaseSet', N'基本模块设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_column_code', N'编码规则设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_column_edit_code', N'编辑编码规则', 'Column', 'Code', N'hg_column_code', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_column_edit_option', N'编辑候选项', 'Column', 'Option', N'hg_column_option', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_column_edit_setting', N'编辑扩展字段', 'Column', 'Setting', N'hg_column_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_column_option', N'候选项设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_column_setting', N'扩展字段设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_currency_manage', N'汇率管理', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_dept_delete', N'删除部门', 'Dept', 'Delete', N'hg_dept_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_dept_edit', N'编辑部门', 'Dept', 'Edit', N'hg_dept_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_dept_index', N'浏览部门', 'Dept', 'Index', N'hg_dept_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_dept_manage', N'部门管理', '', '', N'hg_role', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_email_setting', N'邮件设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_email_setting_edit', N'编辑邮件设置', 'Common', 'EmailSettingSysSetting', N'hg_email_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_framework', N'系统配置', '', '', N'', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_framework_setting', N'系统配置', '', '', N'hg_framework', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_label_setting', N'标签设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_label_setting_edit', N'编辑标签', 'Label', 'Edit', N'hg_label_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_label_setting_index', N'编辑标签', 'Label', 'LabelSetting', N'hg_label_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_log_index', N'浏览操作日志', 'SysLog', 'Index', N'hg_log_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_log_manage', N'操作日志', '', '', N'hg_role', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_mail_index', N'浏览邮件日志', 'Notify', 'MailManage', N'hg_mail_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_mail_manage', N'邮件日志', '', '', N'hg_role', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_mail_resend', N'重新发送邮件', 'Notify', 'ReSendMailData', N'hg_mail_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_mark_setting', N'标记设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_mark_setting_edit', N'编辑标记', 'Mark', 'Edit', N'hg_mark_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_mark_setting_index', N'浏览标记', 'Mark', 'MarkSetting', N'hg_mark_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_notify_setting', N'通知设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_notify_setting_edit', N'编辑通知设置', 'Notify', 'Edit', N'hg_notify_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_notify_setting_index', N'浏览通知设置', 'Notify', 'Index', N'hg_notify_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_role', N'用户权限管理', '', '', N'hg_framework', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_role_catalog_delete', N'删除角色目录', 'RoleCatalog', 'Delete', N'catalog_role', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_role_catalog_edit', N'编辑角色目录', 'RoleCatalog', 'Edit', N'catalog_role', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_role_catalog_index', N'浏览角色目录', 'RoleCatalog', 'Index', N'catalog_role', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_role_delete', N'删除角色', 'Role', 'Delete', N'hg_role_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_role_edit', N'编辑角色', 'Role', 'Edit', N'hg_role_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_role_index', N'浏览角色列表', 'Role', 'Index', N'hg_role_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_role_manage', N'权限管理', '', '', N'hg_role', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_Task_setting', N'任务设置', '', '', N'hg_framework_setting', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_Task_setting_delete', N'编辑任务设置', 'Task', 'Delete', N'hg_Task_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_Task_setting_edit', N'编辑任务设置', 'Task', 'Edit', N'hg_Task_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_Task_setting_index', N'浏览任务设置', 'Task', 'Index', N'hg_Task_setting', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hg_user_manage', N'用户管理', '', '', N'hg_role', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hr_note', N'笔记管理', '', '', N'cms_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hr_note_delete', N'删除笔记', 'note', 'Delete', N'hr_note_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hr_note_index', N'查询目录列表', 'note', 'Index', N'hr_note_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'hr_note_manage', N'笔记管理', '', '', N'hr_note', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_account_apply', N'帐户申请管理', '', '', N'mng_manage_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_account_apply_delete', N'删除帐户申请', 'AccountApply', 'Delete', N'mng_account_apply', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_account_apply_examine', N'核查帐户申请', 'AccountApply', 'Examine', N'mng_account_apply', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_account_apply_index', N'浏览帐户申请', 'AccountApply', 'Index', N'mng_account_apply', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_edition_manage', N'版本管理', '', '', N'mng_manage_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_edition_manage_delete', N'删除版本信息', 'Edition', 'Delete', N'mng_edition_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_edition_manage_edit', N'编辑版本信息', 'Edition', 'Edit', N'mng_edition_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_edition_manage_index', N'浏览版本管理', 'Edition', 'Index', N'mng_edition_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterpirse_catalog_Index', N'浏览企业目录', 'EnterpriseCatalog', 'Index', N'catalog_enterprise', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_batchedit', N'批量编辑企业', 'Enterprise', 'BatchEditEnterprise', N'mng_enterprise_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_catalog_delete', N'删除企业目录', 'EnterpriseCatalog', 'Delete', N'catalog_enterprise', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_catalog_edit', N'编辑企业目录', 'EnterpriseCatalog', 'Edit', N'catalog_enterprise', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_createdata', N'生成企业数据库', 'Enterprise', 'CreateData', N'mng_enterprise_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_delete', N'删除企业', 'Enterprise', 'Delete', N'mng_enterprise_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_edit', N'编辑企业', 'Enterprise', 'Edit', N'mng_enterprise_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_index', N'浏览企业', 'Enterprise', 'Index', N'mng_enterprise_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_manage', N'企业管理', '', '', N'mng_manage_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_outdate', N'浏览将过期企业', 'Enterprise', 'Outdate', N'mng_overdue_enterprise', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_rental', N'浏览企业缴费记录', 'Enterprise', 'Rental', N'mng_enterprise_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_rentalconfirm', N'确认企业缴费', 'Enterprise', 'RentalConfirm', N'mng_enterprise_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_rentaldelete', N'删除缴费记录', 'Enterprise', 'RentalDelete', N'mng_enterprise_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_sendemail', N'发送企业推广邮件', 'Enterprise', 'SendEmail', N'mng_enterprise_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_enterprise_setapp', N'设置企业应用', 'Enterprise', 'SetEnterpriseApp', N'mng_enterprise_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_entreprise_rentaledit', N'编辑企业缴费', 'Enterprise', 'RentalEdit', N'mng_enterprise_manage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_manage', N'企业管理', '', '', N'', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_manage_manage', N'企业管理', '', '', N'mng_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'mng_overdue_enterprise', N'将过期企业', '', '', N'mng_manage_manage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityPlan', N'活动安排', '', '', N'pro_LearningActivity', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityPlanManage', N'活动安排管理', '', '', N'pro_ActivityPlan', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityPlanManage_batchdel', N'批量删除', 'ProTrainManage', 'DeleteTrainByIds', N'pro_ActivityPlanManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityPlanManage_delete', N'删除活动安排管理', 'ProTrainManage', 'Del', N'pro_ActivityPlanManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityPlanManage_delmark', N'删除标记', 'ProTrainManage', 'DeleteMark', N'pro_ActivityPlanManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityPlanManage_Edit', N'编辑活动安排管理', 'ProTrainManage', 'Edit', N'pro_ActivityPlanManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityPlanManage_index', N'浏览活动安排管理', 'ProTrainManage', 'Index', N'pro_ActivityPlanManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityPlanManage_mark', N'设置标记', 'ProTrainManage', 'MarkTrain', N'pro_ActivityPlanManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityPlanManage_refresh', N'刷新标记', 'ProTrainManage', 'MarkRefresh', N'pro_ActivityPlanManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityTypeManage', N'活动类型管理', '', '', N'pro_ActivityPlan', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityTypeManage_delete', N'删除活动类型管理', 'ProTrainTypeManage', 'Del', N'pro_ActivityTypeManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityTypeManage_Edit', N'编辑活动类型管理', 'ProTrainTypeManage', 'Edit', N'pro_ActivityTypeManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ActivityTypeManage_index', N'浏览活动类型管理', 'ProTrainTypeManage', 'Index', N'pro_ActivityTypeManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_LearningActivity', N'学习活动', '', '', N'', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ProActiviyCatalog_delete', N'删除活动目录管理', 'ProActiviyCatalog', 'Delete', N'catalog_ProActiviy', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ProActiviyCatalog_Edit', N'编辑活动目录管理', 'ProActiviyCatalog', 'Edit', N'catalog_ProActiviy', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'pro_ProActiviyCatalog_index', N'浏览活动目录管理', 'ProActiviyCatalog', 'Index', N'catalog_ProActiviy', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'Pro_TestGrade', N'考试成绩管理', '', '', N'Pro_TestLookThrough', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'Pro_TestJudge', N'考试阅卷管理', '', '', N'Pro_TestLookThrough', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'Pro_TestLookThrough', N'活动监控', '', '', N'pro_LearningActivity', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'Pro_TrainGrade', N'学习过程监控管理', '', '', N'Pro_TestLookThrough', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestGrade_creategrade', N'考试答案生成', 'ProTestGrade', 'CreateGrade', N'Pro_TestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestGrade_delcreategrade', N'考试删除答案', 'ProTestGrade', 'DelCreateGrade', N'Pro_TestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestGrade_delete', N'考试成绩删除', 'ProTestGrade', 'Delete', N'Pro_TestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestGrade_delgrade', N'删除成绩', 'ProTestGrade', 'DelGrade', N'Pro_TestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestGrade_edit', N'考试成绩编辑', 'ProTestGrade', 'Edit', N'Pro_TestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestGrade_editgradeinfo', N'编辑成绩', 'ProTestGrade', 'EditGradeInfo', N'Pro_TestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestGrade_index', N'考试成绩浏览', 'ProTestGrade', 'index', N'Pro_TestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestGrade_loadexamdata', N'加载试卷', 'ProTestGrade', 'LoadExamData', N'Pro_TestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestGrade_proexamlistuser', N'人员列表', 'ProTestGrade', 'ProExamListUser', N'Pro_TestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestGrade_viewxxamdata', N'加载试卷', 'ProTestGrade', 'ViewExamData', N'Pro_TestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestJudge_autoscore', N' 自动评分', 'ProTestJudge', 'AutoPostJudgeScore', N'Pro_TestJudge', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestJudge_delete', N'考试阅卷删除', 'ProTestJudge', 'Delete', N'Pro_TestJudge', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestJudge_edit', N'考试阅卷编辑', 'ProTestJudge', 'Edit', N'Pro_TestJudge', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestJudge_examuser', N' 人员列表信息', 'ProTestJudge', 'ProExamUser', N'Pro_TestJudge', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestJudge_index', N'考试阅卷列表浏览', 'ProTestJudge', 'index', N'Pro_TestJudge', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestJudge_loadexamdata', N' 加载试卷信息', 'ProTestJudge', 'LoadExamData', N'Pro_TestJudge', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTestJudge_updateexamdata', N' 修改试卷信息', 'ProTestJudge', 'UpdateExamData', N'Pro_TestJudge', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTrainGrade_hasstudyuser', N'学习', 'ProTrainGrade', 'HasStudyUser', N'Pro_TrainGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTrainGrade_index', N'学习过程监控列表浏览', 'ProTrainGrade', 'index', N'Pro_TrainGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTrainGrade_nothasstudyuser', N'学习', 'ProTrainGrade', 'NotHasStudyUser', N'Pro_TrainGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'ProTrainGrade_process', N'学习进度', 'ProTrainGrade', 'Process', N'Pro_TrainGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'res_comment', N'评论管理', '', '', N'cms_message', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'res_comment_commentreply', N'评论回复', 'Comment', 'CommentReply', N'res_comment', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'res_comment_delete', N'删除评论', 'Comment', 'Delete', N'res_comment', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'res_comment_deletereply', N'删除评论回复', 'Comment', 'DeleteReply', N'res_comment', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'res_comment_index', N'评论管理', 'Comment', 'Index', N'res_comment', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'res_comment_lookcomment', N'评论回复', 'Comment', 'LookComment', N'res_comment', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTestGrade', N'考试成绩管理', '', '', N'rs_ProChart', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTestGrade_creategrade', N'考试答案生成', 'AccountTestGrade', 'CreateGrade', N'rs_AccountTestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTestGrade_deletegrade', N'考试删除答案', 'AccountTestGrade', 'DelCreateGrade', N'rs_AccountTestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTestGrade_delgrade', N'删除成绩', 'AccountTestGrade', 'DelGrade', N'rs_AccountTestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTestGrade_editinfo', N'编辑成绩', 'AccountTestGrade', 'EditGradeInfo', N'rs_AccountTestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTestGrade_examlist', N'人员列表', 'AccountTestGrade', 'ProExamListUser', N'rs_AccountTestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTestGrade_index', N'考试成绩查询', 'AccountTestGrade', 'Index', N'rs_AccountTestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTestGrade_loadexamdata', N'加载试卷', 'AccountTestGrade', 'LoadExamData', N'rs_AccountTestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTestGrade_viewxxamdata', N'加载试卷', 'AccountTestGrade', 'ViewExamData', N'rs_AccountTestGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTrainGrade', N'学习记录管理', '', '', N'rs_ProChart', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTrainGrade_index', N'学习记录查询', 'AccountTrainGrade', 'Index', N'rs_AccountTrainGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTrainGrade_trainlist', N'考试人员列表', 'AccountTrainGrade', 'ProTrainListUser', N'rs_AccountTrainGrade', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTrainSchedule', N'学习进度管理', '', '', N'rs_ProChart', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountTrainSchedule_index', N'学习记录查询', 'AccountTrainSchedule', 'Index', N'rs_AccountTrainSchedule', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountUserGrade', N'考生成绩查询', '', '', N'rs_ProExamChart', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_AccountUserGrade_index', N'考生成绩查询', 'AccountUserGrade', 'index', N'rs_AccountUserGrade', '3', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_CatalogLectuer_delete', N'删除讲师目录', 'LectuerCatalog', 'Delete', N'catalog_Lectuer', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_CatalogLectuer_edit', N'编辑讲师目录', 'LectuerCatalog', 'Edit', N'catalog_Lectuer', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_CatalogLectuer_index', N'浏览讲师目录', 'LectuerCatalog', 'Index', N'catalog_Lectuer', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_CatalogLesson_delete', N'删除课程目录', 'LessonCatalog', 'Delete', N'catalog_Lesson', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_CatalogLesson_edit', N'编辑课程目录', 'LessonCatalog', 'Edit', N'catalog_Lesson', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_CatalogLesson_index', N'浏览课程目录', 'LessonCatalog', 'Index', N'catalog_Lesson', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Exam', N'考评资源', '', '', N'rs_ExamManage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamManage', N'资源管理', '', '', N'', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPaper', N'试卷管理', '', '', N'rs_Exam', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPaper_batchdelete', N'批量删除', 'PaperManage', 'DeletePaperByPaperIds', N'rs_ExamPaper', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPaper_delete', N'试卷删除', 'PaperManage', 'Del', N'rs_ExamPaper', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPaper_deletedata', N'批量删除', 'PaperManage', 'DeleteBatchPaper', N'rs_ExamPaper', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPaper_edit', N'试卷编辑', 'PaperManage', 'Edit', N'rs_ExamPaper', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPaper_editdata', N'批量修改题库', 'PaperManage', 'BatchEditPaper', N'rs_ExamPaper', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPaper_editpaper', N'批量修改题库', 'PaperManage', 'BatchEditPaper', N'rs_ExamPaper', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPaper_index', N'试卷管理', 'PaperManage', 'Index', N'rs_ExamPaper', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPaper_View', N'试卷预览', 'PaperManage', 'PaperView', N'rs_ExamPaper', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPapercatalog_delete', N'删除试卷目录', 'ExamPaperCatalog', 'Delete', N'catalog_ExamPaper', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPapercatalog_edit', N'编辑试卷目录', 'ExamPaperCatalog', 'Edit', N'catalog_ExamPaper', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamPapercatalog_index', N'浏览试卷目录', 'ExamPaperCatalog', 'index', N'catalog_ExamPaper', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamQuestioncatalog_delete', N'目录删除', 'ExamQuestionCatalog', 'Delete', N'catalog_ExamQuestion', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamQuestioncatalog_edit', N'目录编辑', 'ExamQuestionCatalog', 'Edit', N'catalog_ExamQuestion', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ExamQuestioncatalog_index', N'目录浏览', 'ExamQuestionCatalog', 'index', N'catalog_ExamQuestion', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LectuerManage', N'讲师管理', '', '', N'rs_Lesson', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LectuerManage_delete', N'讲师删除', 'LectuerManage', 'Del', N'rs_LectuerManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LectuerManage_edit', N'讲师编辑', 'LectuerManage', 'Edit', N'rs_LectuerManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LectuerManage_index', N'讲师浏览', 'LectuerManage', 'Index', N'rs_LectuerManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Lesson', N'课程资源', '', '', N'rs_ExamManage', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LessonManage', N'课程管理', '', '', N'rs_Lesson', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LessonManage_batchdelete', N'课程批量删除', 'LessonManage', 'DeleteBatchLesson', N'rs_LessonManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LessonManage_delete', N'课程删除', 'LessonManage', 'Del', N'rs_LessonManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LessonManage_deletemark', N'删除标记', 'LessonManage', 'DeleteProductMark', N'rs_LessonManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LessonManage_edit', N'课程编辑', 'LessonManage', 'Edit', N'rs_LessonManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LessonManage_index', N'课程浏览', 'LessonManage', 'Index', N'rs_LessonManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LessonManage_mark', N'设置标记', 'LessonManage', 'MarkLesson', N'rs_LessonManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_LessonManage_markrefresh', N'刷新标记', 'LessonManage', 'MarkRefresh', N'rs_LessonManage', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_OrginChart', N'组织机构统计', '', '', N'rs_Report', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_OrginChartInfo', N'按部门统计', '', '', N'rs_ProExamChart', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_OrginChartInfo_index', N'按部门统计', 'OrginChartInfo', 'Index', N'rs_OrginChartInfo', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_OrginNums', N'按组织架构', '', '', N'rs_OrginChart', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_OrginNums_index', N'按部门统计', 'OrginNums', 'Dep', N'rs_OrginNums', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_OrginTree', N'组织架构图', '', '', N'rs_OrginChart', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_OrginTree_index', N'组织架构图', 'OrginNums', 'index', N'rs_OrginTree', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ProChart', N'学习活动统计', '', '', N'rs_Report', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ProExamChart', N'考试成绩统计', '', '', N'rs_Report', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ProTrainChartInfo', N'按活动统计达标率', '', '', N'rs_ProExamChart', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_ProTrainChartInfo_index', N'按活动统计达标率', 'ProTrainChartInfo', 'Index', N'rs_ProTrainChartInfo', '3', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question', N'题库管理', '', '', N'rs_Exam', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_batchdelete', N'批量删除', 'QuestionManage', 'BatchDelete', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_batchedit', N'批量修改', 'QuestionManage', 'BatchEditQuestion', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_connactive', N'关联活动', 'QuestionManage', 'ConnectionActive', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_delete', N'题库删除', 'QuestionManage', 'Del', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_deletemark', N'删除标记', 'QuestionManage', 'DeleteMark', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_edit', N'题库编辑', 'QuestionManage', 'Edit', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_export', N'批量导出', 'QuestionManage', 'Export', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_exportExcl', N'批量导出题库', 'QuestionManage', 'ExportExcel', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_importwordmodule', N'下载模板', 'QuestionManage', 'ImportWordModule', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_index', N'题库列表', 'QuestionManage', 'Index', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_mark', N'设置标记', 'QuestionManage', 'MarkQuestion', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_markrefresh', N'刷新标记', 'QuestionManage', 'MarkRefresh', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Question_viewassociation', N'查看关联', 'QuestionManage', 'ViewAssociation', N'rs_Question', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_QuestionChart', N'按题统计正确率', '', '', N'rs_ProExamChart', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_QuestionChart_index', N'按题统计正确率', 'QuestionChart', 'Index', N'rs_QuestionChart', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_QuestionType', N'题型管理', '', '', N'rs_Exam', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_QuestionType_delete', N'题型删除', 'QuestionManage', 'QuestionTypeDel', N'rs_QuestionType', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_QuestionType_edit', N'题型编辑', 'QuestionManage', 'QuestionTypeEdit', N'rs_QuestionType', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_QuestionType_index', N'题型管理', 'QuestionManage', 'QuestionType', N'rs_QuestionType', '2', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_Report', N'统计报表', '', '', N'', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_RoleNums', N'按角色统计', '', '', N'rs_OrginChart', '1', NULL, NULL)
INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks], [IsTryout]) VALUES (N'rs_RoleNums_index', N'按角色统计', 'OrginNums', 'Role', N'rs_RoleNums', '2', NULL, NULL)

GO
--邮件配置项
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'EmailSender', N'电子邮件', N'', 1, N'', 1, 1, N'此配置用于发送电子邮件的发件人')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'DisplayName', N'显示名称', N'', 1, N'', 1, 2, N'发送邮件时显示发件人的名称')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'ServerName', N'邮件服务器', N'', 1, N'', 1, 3, N'用于发送电子邮件的服务器')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'ServerPort', N'端口号', N'', 2, N'', 1, 4, N'邮件服务器的端口号，如果不填写则使用默认端口')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'AccountName', N'邮件帐号', N'', 1, N'', 1, 5, N'发送电子邮件的帐号')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'AccountPwd', N'帐号密码', N'', 1, N'', 1, 6, N'对应帐号的密码')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'IsEnableSSL', N'安全邮件', N'false', 3, N'', 1, 7, N'邮件服务器是否支持安全连接协议')
GO
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AppSetting', N'VersionCode', N'版本号', N'', 1, N'', 0, 1000, N'')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_1', N'北京市', N'NULL', NULL, N'NULL', 1, N'110000', N'BeiJingShi', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_10', N'江苏省', N'NULL', NULL, N'NULL', 1, N'320000', N'JiangSu', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_11', N'浙江省', N'NULL', NULL, N'NULL', 1, N'330000', N'ZheJiang', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_12', N'安徽省', N'NULL', NULL, N'NULL', 1, N'340000', N'AnHui', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_13', N'福建省', N'NULL', NULL, N'NULL', 1, N'350000', N'FuJian', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_14', N'江西省', N'NULL', NULL, N'NULL', 1, N'360000', N'JiangXi', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_15', N'山东省', N'NULL', NULL, N'NULL', 1, N'370000', N'ShanDong', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_16', N'河南省', N'NULL', NULL, N'NULL', 1, N'410000', N'HeNan', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_17', N'湖北省', N'NULL', NULL, N'NULL', 1, N'420000', N'HuBei', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_18', N'湖南省', N'NULL', NULL, N'NULL', 1, N'430000', N'HuNan', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_19', N'广东省', N'NULL', NULL, N'NULL', 1, N'440000', N'GuangDong', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_2', N'天津市', N'NULL', NULL, N'NULL', 1, N'120000', N'TianJinShi', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_20', N'广西壮族自治区', N'NULL', NULL, N'NULL', 1, N'450000', N'GuangXiZhuangZuZiZhiQu', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_21', N'海南省', N'NULL', NULL, N'NULL', 1, N'460000', N'HaiNan', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_22', N'重庆市', N'NULL', NULL, N'NULL', 1, N'500000', N'ZhongQingShi', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_23', N'四川省', N'NULL', NULL, N'NULL', 1, N'510000', N'SiChuan', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_24', N'贵州省', N'NULL', NULL, N'NULL', 1, N'520000', N'GuiZhou', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_25', N'云南省', N'NULL', NULL, N'NULL', 1, N'530000', N'YunNan', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_26', N'西藏自治区', N'NULL', NULL, N'NULL', 1, N'540000', N'XiCangZiZhiQu', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_27', N'陕西省', N'NULL', NULL, N'NULL', 1, N'610000', N'ShanXi', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_28', N'甘肃省', N'NULL', NULL, N'NULL', 1, N'620000', N'GanSu', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_29', N'青海省', N'NULL', NULL, N'NULL', 1, N'630000', N'QingHai', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_3', N'河北省', N'NULL', NULL, N'NULL', 1, N'130000', N'HeBei', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_30', N'宁夏回族自治区', N'NULL', NULL, N'NULL', 1, N'640000', N'NingXiaHuiZuZiZhiQu', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_31', N'新疆维吾尔自治区', N'NULL', NULL, N'NULL', 1, N'650000', N'XinJiangWeiWuErZiZhiQu', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_32', N'香港特别行政区', N'NULL', NULL, N'NULL', 1, N'810000', N'XiangGangTeBieXingZhengQu', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_33', N'澳门特别行政区', N'NULL', NULL, N'NULL', 1, N'820000', N'AoMenTeBieXingZhengQu', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_34', N'台湾省', N'NULL', NULL, N'NULL', 1, N'710000', N'TaiWan', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_4', N'山西省', N'NULL', NULL, N'NULL', 1, N'140000', N'ShanXi', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_5', N'内蒙古自治区', N'NULL', NULL, N'NULL', 1, N'150000', N'NaMengGuZiZhiQu', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_6', N'辽宁省', N'NULL', NULL, N'NULL', 1, N'210000', N'LiaoNing', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_7', N'吉林省', N'NULL', NULL, N'NULL', 1, N'220000', N'JiLin', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_8', N'黑龙江省', N'NULL', NULL, N'NULL', 1, N'230000', N'HeiLongJiang', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'1_9', N'上海市', N'NULL', NULL, N'NULL', 1, N'310000', N'ShangHaiShi', N'')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_1', N'北京市', N'1_1', N'北京市', N'100000', 2, N'110000', N'BeiJingShi', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_10', N'承德市', N'1_3', N'河北省', N'067000', 2, N'130800', N'ChengDeShi', N'HeBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_100', N'蚌埠市', N'1_12', N'安徽省', N'233000', 2, N'340300', N'BangBuShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_101', N'淮南市', N'1_12', N'安徽省', N'232000', 2, N'340400', N'HuaiNanShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_102', N'马鞍山市', N'1_12', N'安徽省', N'243000', 2, N'340500', N'MaAnShanShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_103', N'淮北市', N'1_12', N'安徽省', N'235000', 2, N'340600', N'HuaiBeiShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_104', N'铜陵市', N'1_12', N'安徽省', N'244000', 2, N'340700', N'TongLingShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_105', N'安庆市', N'1_12', N'安徽省', N'246000', 2, N'340800', N'AnQingShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_106', N'黄山市', N'1_12', N'安徽省', N'242700', 2, N'341000', N'HuangShanShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_107', N'滁州市', N'1_12', N'安徽省', N'239000', 2, N'341100', N'ChuZhouShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_108', N'阜阳市', N'1_12', N'安徽省', N'236100', 2, N'341200', N'FuYangShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_109', N'宿州市', N'1_12', N'安徽省', N'234100', 2, N'341300', N'SuZhouShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_11', N'沧州市', N'1_3', N'河北省', N'061000', 2, N'130900', N'CangZhouShi', N'HeBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_110', N'巢湖市', N'1_12', N'安徽省', N'238000', 2, N'341400', N'ChaoHuShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_111', N'六安市', N'1_12', N'安徽省', N'237000', 2, N'341500', N'LiuAnShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_112', N'亳州市', N'1_12', N'安徽省', N'236800', 2, N'341600', N'BoZhouShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_113', N'池州市', N'1_12', N'安徽省', N'247100', 2, N'341700', N'ChiZhouShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_114', N'宣城市', N'1_12', N'安徽省', N'366000', 2, N'341800', N'XuanChengShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_115', N'福州市', N'1_13', N'福建省', N'350000', 2, N'350100', N'FuZhouShi', N'FuJian')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_116', N'厦门市', N'1_13', N'福建省', N'361000', 2, N'350200', N'XiaMenShi', N'FuJian')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_117', N'莆田市', N'1_13', N'福建省', N'351100', 2, N'350300', N'PuTianShi', N'FuJian')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_118', N'三明市', N'1_13', N'福建省', N'365000', 2, N'350400', N'SanMingShi', N'FuJian')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_119', N'泉州市', N'1_13', N'福建省', N'362000', 2, N'350500', N'QuanZhouShi', N'FuJian')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_12', N'廊坊市', N'1_3', N'河北省', N'065000', 2, N'131000', N'LangFangShi', N'HeBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_120', N'漳州市', N'1_13', N'福建省', N'363000', 2, N'350600', N'ZhangZhouShi', N'FuJian')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_121', N'南平市', N'1_13', N'福建省', N'353000', 2, N'350700', N'NanPingShi', N'FuJian')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_122', N'龙岩市', N'1_13', N'福建省', N'364000', 2, N'350800', N'LongYanShi', N'FuJian')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_123', N'宁德市', N'1_13', N'福建省', N'352100', 2, N'350900', N'NingDeShi', N'FuJian')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_124', N'南昌市', N'1_14', N'江西省', N'330000', 2, N'360100', N'NanChangShi', N'JiangXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_125', N'景德镇市', N'1_14', N'江西省', N'333000', 2, N'360200', N'JingDeZhenShi', N'JiangXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_126', N'萍乡市', N'1_14', N'江西省', N'337000', 2, N'360300', N'PingXiangShi', N'JiangXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_127', N'九江市', N'1_14', N'江西省', N'332000', 2, N'360400', N'JiuJiangShi', N'JiangXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_128', N'新余市', N'1_14', N'江西省', N'338000', 2, N'360500', N'XinYuShi', N'JiangXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_129', N'鹰潭市', N'1_14', N'江西省', N'335000', 2, N'360600', N'YingTanShi', N'JiangXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_13', N'衡水市', N'1_3', N'河北省', N'053000', 2, N'131100', N'HengShuiShi', N'HeBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_130', N'赣州市', N'1_14', N'江西省', N'341000', 2, N'360700', N'GanZhouShi', N'JiangXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_131', N'吉安市', N'1_14', N'江西省', N'343000', 2, N'360800', N'JiAnShi', N'JiangXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_132', N'宜春市', N'1_14', N'江西省', N'336000', 2, N'360900', N'YiChunShi', N'JiangXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_133', N'抚州市', N'1_14', N'江西省', N'332900', 2, N'361000', N'FuZhouShi', N'JiangXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_134', N'上饶市', N'1_14', N'江西省', N'334000', 2, N'361100', N'ShangRaoShi', N'JiangXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_135', N'济南市', N'1_15', N'山东省', N'250000', 2, N'370100', N'JiNanShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_136', N'青岛市', N'1_15', N'山东省', N'266000', 2, N'370200', N'QingDaoShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_137', N'淄博市', N'1_15', N'山东省', N'255000', 2, N'370300', N'ZiBoShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_138', N'枣庄市', N'1_15', N'山东省', N'277100', 2, N'370400', N'ZaoZhuangShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_139', N'东营市', N'1_15', N'山东省', N'257000', 2, N'370500', N'DongYingShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_14', N'太原市', N'1_4', N'山西省', N'030000', 2, N'140100', N'TaiYuanShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_140', N'烟台市', N'1_15', N'山东省', N'264000', 2, N'370600', N'YanTaiShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_141', N'潍坊市', N'1_15', N'山东省', N'261000', 2, N'370700', N'WeiFangShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_142', N'济宁市', N'1_15', N'山东省', N'272100', 2, N'370800', N'JiNingShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_143', N'泰安市', N'1_15', N'山东省', N'271000', 2, N'370900', N'TaiAnShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_144', N'威海市', N'1_15', N'山东省', N'265700', 2, N'371000', N'WeiHaiShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_145', N'日照市', N'1_15', N'山东省', N'276800', 2, N'371100', N'RiZhaoShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_146', N'莱芜市', N'1_15', N'山东省', N'271100', 2, N'371200', N'LaiWuShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_147', N'临沂市', N'1_15', N'山东省', N'276000', 2, N'371300', N'LinYiShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_148', N'德州市', N'1_15', N'山东省', N'253000', 2, N'371400', N'DeZhouShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_149', N'聊城市', N'1_15', N'山东省', N'252000', 2, N'371500', N'LiaoChengShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_15', N'大同市', N'1_4', N'山西省', N'037000', 2, N'140200', N'DaTongShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_150', N'滨州市', N'1_15', N'山东省', N'256600', 2, N'371600', N'BinZhouShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_151', N'菏泽市', N'1_15', N'山东省', N'255000', 2, N'371700', N'HeZeShi', N'ShanDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_152', N'郑州市', N'1_16', N'河南省', N'450000', 2, N'410100', N'ZhengZhouShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_153', N'开封市', N'1_16', N'河南省', N'475000', 2, N'410200', N'KaiFengShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_154', N'洛阳市', N'1_16', N'河南省', N'471000', 2, N'410300', N'LuoYangShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_155', N'平顶山市', N'1_16', N'河南省', N'467000', 2, N'410400', N'PingDingShanShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_156', N'安阳市', N'1_16', N'河南省', N'454900', 2, N'410500', N'AnYangShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_157', N'鹤壁市', N'1_16', N'河南省', N'456600', 2, N'410600', N'HeBiShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_158', N'新乡市', N'1_16', N'河南省', N'453000', 2, N'410700', N'XinXiangShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_159', N'焦作市', N'1_16', N'河南省', N'454100', 2, N'410800', N'JiaoZuoShi', N'HeNan')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_16', N'阳泉市', N'1_4', N'山西省', N'045000', 2, N'140300', N'YangQuanShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_160', N'濮阳市', N'1_16', N'河南省', N'457000', 2, N'410900', N'PuYangShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_161', N'许昌市', N'1_16', N'河南省', N'461000', 2, N'411000', N'XuChangShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_162', N'漯河市', N'1_16', N'河南省', N'462000', 2, N'411100', N'LuoHeShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_163', N'三门峡市', N'1_16', N'河南省', N'472000', 2, N'411200', N'SanMenXiaShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_164', N'南阳市', N'1_16', N'河南省', N'473000', 2, N'411300', N'NanYangShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_165', N'商丘市', N'1_16', N'河南省', N'476000', 2, N'411400', N'ShangQiuShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_166', N'信阳市', N'1_16', N'河南省', N'464000', 2, N'411500', N'XinYangShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_167', N'周口市', N'1_16', N'河南省', N'466000', 2, N'411600', N'ZhouKouShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_168', N'驻马店市', N'1_16', N'河南省', N'463000', 2, N'411700', N'ZhuMaDianShi', N'HeNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_169', N'武汉市', N'1_17', N'湖北省', N'430000', 2, N'420100', N'WuHanShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_17', N'长治市', N'1_4', N'山西省', N'046000', 2, N'140400', N'ChangZhiShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_170', N'黄石市', N'1_17', N'湖北省', N'435000', 2, N'420200', N'HuangShiShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_171', N'十堰市', N'1_17', N'湖北省', N'442000', 2, N'420300', N'ShiYanShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_172', N'宜昌市', N'1_17', N'湖北省', N'443000', 2, N'420500', N'YiChangShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_173', N'襄樊市', N'1_17', N'湖北省', N'441000', 2, N'420600', N'XiangFanShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_174', N'鄂州市', N'1_17', N'湖北省', N'436000', 2, N'420700', N'EZhouShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_175', N'荆门市', N'1_17', N'湖北省', N'448000', 2, N'420800', N'JingMenShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_176', N'孝感市', N'1_17', N'湖北省', N'432100', 2, N'420900', N'XiaoGanShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_177', N'荆州市', N'1_17', N'湖北省', N'434000', 2, N'421000', N'JingZhouShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_178', N'黄冈市', N'1_17', N'湖北省', N'438000', 2, N'421100', N'HuangGangShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_179', N'咸宁市', N'1_17', N'湖北省', N'437000', 2, N'421200', N'XianNingShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_18', N'晋城市', N'1_4', N'山西省', N'048000', 2, N'140500', N'JinChengShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_180', N'随州市', N'1_17', N'湖北省', N'441300', 2, N'421300', N'SuiZhouShi', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_181', N'恩施土家族苗族自治州', N'1_17', N'湖北省', N'445000', 2, N'422800', N'EnShiTuJiaZuMiaoZuZiZhiZhou', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_182', N'神农架', N'1_17', N'湖北省', N'442400', 2, N'429021', N'ShenNongJia', N'HuBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_183', N'长沙市', N'1_18', N'湖南省', N'410000', 2, N'430100', N'ChangShaShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_184', N'株洲市', N'1_18', N'湖南省', N'412000', 2, N'430200', N'ZhuZhouShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_185', N'湘潭市', N'1_18', N'湖南省', N'411100', 2, N'430300', N'XiangTanShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_186', N'衡阳市', N'1_18', N'湖南省', N'421000', 2, N'430400', N'HengYangShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_187', N'邵阳市', N'1_18', N'湖南省', N'422000', 2, N'430500', N'ShaoYangShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_188', N'岳阳市', N'1_18', N'湖南省', N'414000', 2, N'430600', N'YueYangShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_189', N'常德市', N'1_18', N'湖南省', N'415000', 2, N'430700', N'ChangDeShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_19', N'朔州市', N'1_4', N'山西省', N'036000', 2, N'140600', N'ShuoZhouShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_190', N'张家界市', N'1_18', N'湖南省', N'427000', 2, N'430800', N'ZhangJiaJieShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_191', N'益阳市', N'1_18', N'湖南省', N'413000', 2, N'430900', N'YiYangShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_192', N'郴州市', N'1_18', N'湖南省', N'423000', 2, N'431000', N'ChenZhouShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_193', N'永州市', N'1_18', N'湖南省', N'425000', 2, N'431100', N'YongZhouShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_194', N'怀化市', N'1_18', N'湖南省', N'418000', 2, N'431200', N'HuaiHuaShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_195', N'娄底市', N'1_18', N'湖南省', N'417000', 2, N'431300', N'LouDiShi', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_196', N'湘西土家族苗族自治州', N'1_18', N'湖南省', N'416000', 2, N'433100', N'XiangXiTuJiaZuMiaoZuZiZhiZhou', N'HuNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_197', N'广州市', N'1_19', N'广东省', N'510000', 2, N'440100', N'GuangZhouShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_198', N'韶关市', N'1_19', N'广东省', N'521000', 2, N'440200', N'ShaoGuanShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_199', N'深圳市', N'1_19', N'广东省', N'518000', 2, N'440300', N'ShenZhenShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_2', N'天津市', N'1_2', N'天津市', N'100000', 2, N'120000', N'TianJinShi', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_20', N'晋中市', N'1_4', N'山西省', N'030600', 2, N'140700', N'JinZhongShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_200', N'珠海市', N'1_19', N'广东省', N'519000', 2, N'440400', N'ZhuHaiShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_201', N'汕头市', N'1_19', N'广东省', N'515000', 2, N'440500', N'ShanTouShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_202', N'佛山市', N'1_19', N'广东省', N'528000', 2, N'440600', N'FoShanShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_203', N'江门市', N'1_19', N'广东省', N'529000', 2, N'440700', N'JiangMenShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_204', N'湛江市', N'1_19', N'广东省', N'524000', 2, N'440800', N'ZhanJiangShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_205', N'茂名市', N'1_19', N'广东省', N'525000', 2, N'440900', N'MaoMingShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_206', N'肇庆市', N'1_19', N'广东省', N'526000', 2, N'441200', N'ZhaoQingShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_207', N'惠州市', N'1_19', N'广东省', N'516000', 2, N'441300', N'HuiZhouShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_208', N'梅州市', N'1_19', N'广东省', N'514000', 2, N'441400', N'MeiZhouShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_209', N'汕尾市', N'1_19', N'广东省', N'516600', 2, N'441500', N'ShanWeiShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_21', N'运城市', N'1_4', N'山西省', N'044000', 2, N'140800', N'YunChengShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_210', N'河源市', N'1_19', N'广东省', N'517000', 2, N'441600', N'HeYuanShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_211', N'阳江市', N'1_19', N'广东省', N'529500', 2, N'441700', N'YangJiangShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_212', N'清远市', N'1_19', N'广东省', N'511500', 2, N'441800', N'QingYuanShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_213', N'东莞市', N'1_19', N'广东省', N'511700', 2, N'441900', N'DongWanShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_214', N'中山市', N'1_19', N'广东省', N'528400', 2, N'442000', N'ZhongShanShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_215', N'潮州市', N'1_19', N'广东省', N'515600', 2, N'445100', N'ChaoZhouShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_216', N'揭阳市', N'1_19', N'广东省', N'522000', 2, N'445200', N'JieYangShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_217', N'云浮市', N'1_19', N'广东省', N'527300', 2, N'445300', N'YunFuShi', N'GuangDong')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_218', N'南宁市', N'1_20', N'广西壮族自治区', N'530000', 2, N'450100', N'NanNingShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_219', N'柳州市', N'1_20', N'广西壮族自治区', N'545000', 2, N'450200', N'LiuZhouShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_22', N'忻州市', N'1_4', N'山西省', N'034000', 2, N'140900', N'XinZhouShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_220', N'桂林市', N'1_20', N'广西壮族自治区', N'541000', 2, N'450300', N'GuiLinShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_221', N'梧州市', N'1_20', N'广西壮族自治区', N'543000', 2, N'450400', N'WuZhouShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_222', N'北海市', N'1_20', N'广西壮族自治区', N'536000', 2, N'450500', N'BeiHaiShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_223', N'防城港市', N'1_20', N'广西壮族自治区', N'538000', 2, N'450600', N'FangChengGangShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_224', N'钦州市', N'1_20', N'广西壮族自治区', N'535000', 2, N'450700', N'QinZhouShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_225', N'贵港市', N'1_20', N'广西壮族自治区', N'537100', 2, N'450800', N'GuiGangShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_226', N'玉林市', N'1_20', N'广西壮族自治区', N'537000', 2, N'450900', N'YuLinShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_227', N'百色市', N'1_20', N'广西壮族自治区', N'533000', 2, N'451000', N'BaiSeShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_228', N'贺州市', N'1_20', N'广西壮族自治区', N'542800', 2, N'451100', N'HeZhouShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_229', N'河池市', N'1_20', N'广西壮族自治区', N'547000', 2, N'451200', N'HeChiShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_23', N'临汾市', N'1_4', N'山西省', N'041000', 2, N'141000', N'LinFenShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_230', N'来宾市', N'1_20', N'广西壮族自治区', N'546100', 2, N'451300', N'LaiBinShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_231', N'崇左市', N'1_20', N'广西壮族自治区', N'532200', 2, N'451400', N'ChongZuoShi', N'GuangXiZhuangZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_232', N'海口市', N'1_21', N'海南省', N'570000', 2, N'460100', N'HaiKouShi', N'HaiNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_233', N'三亚市', N'1_21', N'海南省', N'572000', 2, N'460200', N'SanYaShi', N'HaiNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_234', N'重庆市', N'1_22', N'重庆市', N'400000', 2, N'500000', N'ZhongQingShi', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_235', N'成都市', N'1_23', N'四川省', N'610000', 2, N'510100', N'ChengDouShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_236', N'自贡市', N'1_23', N'四川省', N'643000', 2, N'510300', N'ZiGongShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_237', N'攀枝花市', N'1_23', N'四川省', N'617000', 2, N'510400', N'PanZhiHuaShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_238', N'泸州市', N'1_23', N'四川省', N'646100', 2, N'510500', N'LuZhouShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_239', N'德阳市', N'1_23', N'四川省', N'618000', 2, N'510600', N'DeYangShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_24', N'吕梁市', N'1_4', N'山西省', N'030500', 2, N'141100', N'LvLiangShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_240', N'绵阳市', N'1_23', N'四川省', N'621000', 2, N'510700', N'MianYangShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_241', N'广元市', N'1_23', N'四川省', N'628000', 2, N'510800', N'GuangYuanShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_242', N'遂宁市', N'1_23', N'四川省', N'629000', 2, N'510900', N'SuiNingShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_243', N'内江市', N'1_23', N'四川省', N'641000', 2, N'511000', N'NaJiangShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_244', N'乐山市', N'1_23', N'四川省', N'614000', 2, N'511100', N'LeShanShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_245', N'南充市', N'1_23', N'四川省', N'637000', 2, N'511300', N'NanChongShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_246', N'眉山市', N'1_23', N'四川省', N'612100', 2, N'511400', N'MeiShanShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_247', N'宜宾市', N'1_23', N'四川省', N'644000', 2, N'511500', N'YiBinShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_248', N'广安市', N'1_23', N'四川省', N'638000', 2, N'511600', N'GuangAnShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_249', N'达州市', N'1_23', N'四川省', N'635000', 2, N'511700', N'DaZhouShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_25', N'呼和浩特市', N'1_5', N'内蒙古自治区', N'010000', 2, N'150100', N'HuHeHaoTeShi', N'NaMengGuZiZhiQu')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_250', N'雅安市', N'1_23', N'四川省', N'625000', 2, N'511800', N'YaAnShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_251', N'巴中市', N'1_23', N'四川省', N'635500', 2, N'511900', N'BaZhongShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_252', N'资阳市', N'1_23', N'四川省', N'641300', 2, N'512000', N'ZiYangShi', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_253', N'阿坝藏族羌族自治州', N'1_23', N'四川省', N'624600', 2, N'513200', N'ABaCangZuQiangZuZiZhiZhou', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_254', N'甘孜藏族自治州', N'1_23', N'四川省', N'626000', 2, N'513300', N'GanZiCangZuZiZhiZhou', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_255', N'凉山彝族自治州', N'1_23', N'四川省', N'615000', 2, N'513400', N'LiangShanYiZuZiZhiZhou', N'SiChuan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_256', N'贵阳市', N'1_24', N'贵州省', N'55000', 2, N'520100', N'GuiYangShi', N'GuiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_257', N'六盘水市', N'1_24', N'贵州省', N'553000', 2, N'520200', N'LiuPanShuiShi', N'GuiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_258', N'遵义市', N'1_24', N'贵州省', N'563000', 2, N'520300', N'ZunYiShi', N'GuiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_259', N'安顺市', N'1_24', N'贵州省', N'561000', 2, N'520400', N'AnShunShi', N'GuiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_26', N'包头市', N'1_5', N'内蒙古自治区', N'014000', 2, N'150200', N'BaoTouShi', N'NaMengGuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_260', N'铜仁地区', N'1_24', N'贵州省', N'554300', 2, N'522200', N'TongRenDiQu', N'GuiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_261', N'黔西南布依族苗族自治州', N'1_24', N'贵州省', N'551500', 2, N'522300', N'QianXiNanBuYiZuMiaoZuZiZhiZhou', N'GuiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_262', N'毕节地区', N'1_24', N'贵州省', N'551700', 2, N'522400', N'BiJieDiQu', N'GuiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_263', N'黔东南苗族侗族自治州', N'1_24', N'贵州省', N'551500', 2, N'522600', N'QianDongNanMiaoZuDongZuZiZhiZhou', N'GuiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_264', N'黔南布依族苗族自治州', N'1_24', N'贵州省', N'550100', 2, N'522700', N'QianNanBuYiZuMiaoZuZiZhiZhou', N'GuiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_265', N'昆明市', N'1_25', N'云南省', N'650000', 2, N'530100', N'KunMingShi', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_266', N'曲靖市', N'1_25', N'云南省', N'655000', 2, N'530300', N'QuJingShi', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_267', N'玉溪市', N'1_25', N'云南省', N'653100', 2, N'530400', N'YuXiShi', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_268', N'保山市', N'1_25', N'云南省', N'678000', 2, N'530500', N'BaoShanShi', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_269', N'昭通市', N'1_25', N'云南省', N'657000', 2, N'530600', N'ZhaoTongShi', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_27', N'乌海市', N'1_5', N'内蒙古自治区', N'016000', 2, N'150300', N'WuHaiShi', N'NaMengGuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_270', N'丽江市', N'1_25', N'云南省', N'674100', 2, N'530700', N'LiJiangShi', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_271', N'思茅市', N'1_25', N'云南省', N'665000', 2, N'530800', N'SiMaoShi', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_272', N'临沧市', N'1_25', N'云南省', N'677000', 2, N'530900', N'LinCangShi', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_273', N'楚雄彝族自治州', N'1_25', N'云南省', N'675000', 2, N'532300', N'ChuXiongYiZuZiZhiZhou', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_274', N'红河哈尼族彝族自治州', N'1_25', N'云南省', N'654400', 2, N'532500', N'HongHeHaNiZuYiZuZiZhiZhou', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_275', N'文山壮族苗族自治州', N'1_25', N'云南省', N'663000', 2, N'532600', N'WenShanZhuangZuMiaoZuZiZhiZhou', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_276', N'西双版纳傣族自治州', N'1_25', N'云南省', N'666200', 2, N'532800', N'XiShuangBanNaDaiZuZiZhiZhou', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_277', N'大理白族自治州', N'1_25', N'云南省', N'671000', 2, N'532900', N'DaLiBaiZuZiZhiZhou', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_278', N'德宏傣族景颇族自治州', N'1_25', N'云南省', N'678400', 2, N'533100', N'DeHongDaiZuJingPoZuZiZhiZhou', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_279', N'怒江傈僳族自治州', N'1_25', N'云南省', N'671400', 2, N'533300', N'NuJiangLiSuZuZiZhiZhou', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_28', N'赤峰市', N'1_5', N'内蒙古自治区', N'024000', 2, N'150400', N'ChiFengShi', N'NaMengGuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_280', N'迪庆藏族自治州', N'1_25', N'云南省', N'674400', 2, N'533400', N'DiQingCangZuZiZhiZhou', N'YunNan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_281', N'拉萨市', N'1_26', N'西藏自治区', N'850000', 2, N'540100', N'LaSaShi', N'XiCangZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_282', N'昌都地区', N'1_26', N'西藏自治区', N'854000', 2, N'542100', N'ChangDouDiQu', N'XiCangZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_283', N'山南地区', N'1_26', N'西藏自治区', N'856000', 2, N'542200', N'ShanNanDiQu', N'XiCangZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_284', N'日喀则地区', N'1_26', N'西藏自治区', N'857000', 2, N'542300', N'RiKaZeDiQu', N'XiCangZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_285', N'那曲地区', N'1_26', N'西藏自治区', N'852000', 2, N'542400', N'NaQuDiQu', N'XiCangZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_286', N'阿里地区', N'1_26', N'西藏自治区', N'859100', 2, N'542500', N'ALiDiQu', N'XiCangZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_287', N'林芝地区', N'1_26', N'西藏自治区', N'860100', 2, N'542600', N'LinZhiDiQu', N'XiCangZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_288', N'西安市', N'1_27', N'陕西省', N'710000', 2, N'610100', N'XiAnShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_289', N'铜川市', N'1_27', N'陕西省', N'727000', 2, N'610200', N'TongChuanShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_29', N'通辽市', N'1_5', N'内蒙古自治区', N'028000', 2, N'150500', N'TongLiaoShi', N'NaMengGuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_290', N'宝鸡市', N'1_27', N'陕西省', N'721000', 2, N'610300', N'BaoJiShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_291', N'咸阳市', N'1_27', N'陕西省', N'712000', 2, N'610400', N'XianYangShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_292', N'渭南市', N'1_27', N'陕西省', N'714000', 2, N'610500', N'WeiNanShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_293', N'延安市', N'1_27', N'陕西省', N'716000', 2, N'610600', N'YanAnShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_294', N'汉中市', N'1_27', N'陕西省', N'723000', 2, N'610700', N'HanZhongShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_295', N'榆林市', N'1_27', N'陕西省', N'719000', 2, N'610800', N'YuLinShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_296', N'安康市', N'1_27', N'陕西省', N'725000', 2, N'610900', N'AnKangShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_297', N'商洛市', N'1_27', N'陕西省', N'711500', 2, N'611000', N'ShangLuoShi', N'ShanXi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_298', N'兰州市', N'1_28', N'甘肃省', N'730000', 2, N'620100', N'LanZhouShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_299', N'嘉峪关市', N'1_28', N'甘肃省', N'735100', 2, N'620200', N'JiaYuGuanShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_3', N'石家庄市', N'1_3', N'河北省', N'050000', 2, N'130100', N'ShiJiaZhuangShi', N'HeBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_30', N'鄂尔多斯市', N'1_5', N'内蒙古自治区', N'010300', 2, N'150600', N'EErDuoSiShi', N'NaMengGuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_300', N'金昌市', N'1_28', N'甘肃省', N'737100', 2, N'620300', N'JinChangShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_301', N'白银市', N'1_28', N'甘肃省', N'730900', 2, N'620400', N'BaiYinShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_302', N'天水市', N'1_28', N'甘肃省', N'741000', 2, N'620500', N'TianShuiShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_303', N'武威市', N'1_28', N'甘肃省', N'733000', 2, N'620600', N'WuWeiShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_304', N'张掖市', N'1_28', N'甘肃省', N'734000', 2, N'620700', N'ZhangYeShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_305', N'平凉市', N'1_28', N'甘肃省', N'744000', 2, N'620800', N'PingLiangShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_306', N'酒泉市', N'1_28', N'甘肃省', N'735000', 2, N'620900', N'JiuQuanShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_307', N'庆阳市', N'1_28', N'甘肃省', N'744500', 2, N'621000', N'QingYangShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_308', N'定西市', N'1_28', N'甘肃省', N'743000', 2, N'621100', N'DingXiShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_309', N'陇南市', N'1_28', N'甘肃省', N'742100', 2, N'621200', N'LongNanShi', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_31', N'呼伦贝尔市', N'1_5', N'内蒙古自治区', N'021000', 2, N'150700', N'HuLunBeiErShi', N'NaMengGuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_310', N'临夏回族自治州', N'1_28', N'甘肃省', N'731100', 2, N'622900', N'LinXiaHuiZuZiZhiZhou', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_311', N'甘南藏族自治州', N'1_28', N'甘肃省', N'747000', 2, N'623000', N'GanNanCangZuZiZhiZhou', N'GanSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_312', N'西宁市', N'1_29', N'青海省', N'810000', 2, N'630100', N'XiNingShi', N'QingHai')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_313', N'海东地区', N'1_29', N'青海省', N'810600', 2, N'632100', N'HaiDongDiQu', N'QingHai')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_314', N'海北藏族自治州', N'1_29', N'青海省', N'810300', 2, N'632200', N'HaiBeiCangZuZiZhiZhou', N'QingHai')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_315', N'黄南藏族自治州', N'1_29', N'青海省', N'811300', 2, N'632300', N'HuangNanCangZuZiZhiZhou', N'QingHai')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_316', N'海南藏族自治州', N'1_29', N'青海省', N'813000', 2, N'632500', N'HaiNanCangZuZiZhiZhou', N'QingHai')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_317', N'果洛藏族自治州', N'1_29', N'青海省', N'814000', 2, N'632600', N'GuoLuoCangZuZiZhiZhou', N'QingHai')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_318', N'玉树藏族自治州', N'1_29', N'青海省', N'815000', 2, N'632700', N'YuShuCangZuZiZhiZhou', N'QingHai')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_319', N'海西蒙古族藏族自治州', N'1_29', N'青海省', N'817000', 2, N'632800', N'HaiXiMengGuZuCangZuZiZhiZhou', N'QingHai')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_32', N'巴彦淖尔市', N'1_5', N'内蒙古自治区', N'014400', 2, N'150800', N'BaYanNaoErShi', N'NaMengGuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_320', N'银川市', N'1_30', N'宁夏回族自治区', N'750000', 2, N'640100', N'YinChuanShi', N'NingXiaHuiZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_321', N'石嘴山市', N'1_30', N'宁夏回族自治区', N'753000', 2, N'640200', N'ShiZuiShanShi', N'NingXiaHuiZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_322', N'吴忠市', N'1_30', N'宁夏回族自治区', N'751100', 2, N'640300', N'WuZhongShi', N'NingXiaHuiZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_323', N'固原市', N'1_30', N'宁夏回族自治区', N'756000', 2, N'640400', N'GuYuanShi', N'NingXiaHuiZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_324', N'中卫市', N'1_30', N'宁夏回族自治区', N'751700', 2, N'640500', N'ZhongWeiShi', N'NingXiaHuiZuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_325', N'乌鲁木齐市', N'1_31', N'新疆维吾尔自治区', N'830000', 2, N'650100', N'WuLuMuQiShi', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_326', N'克拉玛依市', N'1_31', N'新疆维吾尔自治区', N'834000', 2, N'650200', N'KeLaMaYiShi', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_327', N'吐鲁番地区', N'1_31', N'新疆维吾尔自治区', N'838000', 2, N'652100', N'TuLuFanDiQu', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_328', N'哈密地区', N'1_31', N'新疆维吾尔自治区', N'839000', 2, N'652200', N'HaMiDiQu', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_329', N'昌吉回族自治州', N'1_31', N'新疆维吾尔自治区', N'831100', 2, N'652300', N'ChangJiHuiZuZiZhiZhou', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_33', N'乌兰察布市', N'1_5', N'内蒙古自治区', N'011800', 2, N'150900', N'WuLanChaBuShi', N'NaMengGuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_330', N'博尔塔拉蒙古自治州', N'1_31', N'新疆维吾尔自治区', N'833400', 2, N'652700', N'BoErTaLaMengGuZiZhiZhou', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_331', N'巴音郭楞蒙古自治州', N'1_31', N'新疆维吾尔自治区', N'841000', 2, N'652800', N'BaYinGuoLengMengGuZiZhiZhou', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_332', N'阿克苏地区', N'1_31', N'新疆维吾尔自治区', N'843000', 2, N'652900', N'AKeSuDiQu', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_333', N'克孜勒苏柯尔克孜自治州', N'1_31', N'新疆维吾尔自治区', N'835600', 2, N'653000', N'KeZiLeSuKeErKeZiZiZhiZhou', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_334', N'喀什地区', N'1_31', N'新疆维吾尔自治区', N'844000', 2, N'653100', N'KaShiDiQu', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_335', N'和田地区', N'1_31', N'新疆维吾尔自治区', N'848000', 2, N'653200', N'HeTianDiQu', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_336', N'伊犁哈萨克自治州', N'1_31', N'新疆维吾尔自治区', N'833200', 2, N'654000', N'YiLiHaSaKeZiZhiZhou', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_337', N'塔城地区', N'1_31', N'新疆维吾尔自治区', N'834700', 2, N'654200', N'TaChengDiQu', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_338', N'阿勒泰地区', N'1_31', N'新疆维吾尔自治区', N'836500', 2, N'654300', N'ALeTaiDiQu', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_339', N'石河子市', N'1_31', N'新疆维吾尔自治区', N'832000', 2, N'659001', N'ShiHeZiShi', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_34', N'兴安盟', N'1_5', N'内蒙古自治区', N'137500', 2, N'152200', N'XingAnMeng', N'NaMengGuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_340', N'阿拉尔市', N'1_31', N'新疆维吾尔自治区', N'843300', 2, N'659002', N'ALaErShi', N'XinJiangWeiWuErZiZhiQu')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_341', N'图木舒克市', N'1_31', N'新疆维吾尔自治区', N'843900', 2, N'659003', N'TuMuShuKeShi', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_342', N'五家渠市', N'1_31', N'新疆维吾尔自治区', N'831300', 2, N'659004', N'WuJiaQuShi', N'XinJiangWeiWuErZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_343', N'香港特别行政区', N'1_32', N'香港特别行政区', N'000000', 2, N'810000', N'XiangGangTeBieXingZhengQu', N'XiangGangTeBieXingZhengQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_344', N'澳门特别行政区', N'1_33', N'澳门特别行政区', N'000000', 2, N'820000', N'AoMenTeBieXingZhengQu', N'AoMenTeBieXingZhengQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_345', N'台北市', N'1_34', N'台湾省', N'000000', 2, N'710000', N'TaiBeiShi', N'TaiWan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_346', N'高雄市', N'1_34', N'台湾省', N'000000', 2, N'710000', N'GaoXiongShi', N'TaiWan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_347', N'基隆市', N'1_34', N'台湾省', N'000000', 2, N'710000', N'JiLongShi', N'TaiWan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_348', N'台中市', N'1_34', N'台湾省', N'000000', 2, N'710000', N'TaiZhongShi', N'TaiWan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_349', N'台南市', N'1_34', N'台湾省', N'000000', 2, N'710000', N'TaiNanShi', N'TaiWan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_35', N'锡林郭勒盟', N'1_5', N'内蒙古自治区', N'011100', 2, N'152500', N'XiLinGuoLeMeng', N'NaMengGuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_350', N'新竹市', N'1_34', N'台湾省', N'000000', 2, N'710000', N'XinZhuShi', N'TaiWan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_351', N'嘉义市', N'1_34', N'台湾省', N'000000', 2, N'710000', N'JiaYiShi', N'TaiWan')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_36', N'阿拉善盟', N'1_5', N'内蒙古自治区', N'016000', 2, N'152900', N'ALaShanMeng', N'NaMengGuZiZhiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_37', N'沈阳市', N'1_6', N'辽宁省', N'110000', 2, N'210100', N'ShenYangShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_38', N'大连市', N'1_6', N'辽宁省', N'116000', 2, N'210200', N'DaLianShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_39', N'鞍山市', N'1_6', N'辽宁省', N'114000', 2, N'210300', N'AnShanShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_4', N'唐山市', N'1_3', N'河北省', N'063000', 2, N'130200', N'TangShanShi', N'HeBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_40', N'抚顺市', N'1_6', N'辽宁省', N'113000', 2, N'210400', N'FuShunShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_41', N'本溪市', N'1_6', N'辽宁省', N'117000', 2, N'210500', N'BenXiShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_42', N'丹东市', N'1_6', N'辽宁省', N'118000', 2, N'210600', N'DanDongShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_43', N'锦州市', N'1_6', N'辽宁省', N'121000', 2, N'210700', N'JinZhouShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_44', N'营口市', N'1_6', N'辽宁省', N'115000', 2, N'210800', N'YingKouShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_45', N'阜新市', N'1_6', N'辽宁省', N'123000', 2, N'210900', N'FuXinShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_46', N'辽阳市', N'1_6', N'辽宁省', N'111000', 2, N'211000', N'LiaoYangShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_47', N'盘锦市', N'1_6', N'辽宁省', N'124000', 2, N'211100', N'PanJinShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_48', N'铁岭市', N'1_6', N'辽宁省', N'112000', 2, N'211200', N'TieLingShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_49', N'朝阳市', N'1_6', N'辽宁省', N'122000', 2, N'211300', N'ChaoYangShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_5', N'秦皇岛市', N'1_3', N'河北省', N'066000', 2, N'130300', N'QinHuangDaoShi', N'HeBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_50', N'葫芦岛市', N'1_6', N'辽宁省', N'125000', 2, N'211400', N'HuLuDaoShi', N'LiaoNing')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_51', N'长春市', N'1_7', N'吉林省', N'130000', 2, N'220100', N'ChangChunShi', N'JiLin')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_52', N'吉林市', N'1_7', N'吉林省', N'132000', 2, N'220200', N'JiLinShi', N'JiLin')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_53', N'四平市', N'1_7', N'吉林省', N'136000', 2, N'220300', N'SiPingShi', N'JiLin')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_54', N'辽源市', N'1_7', N'吉林省', N'136200', 2, N'220400', N'LiaoYuanShi', N'JiLin')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_55', N'通化市', N'1_7', N'吉林省', N'134000', 2, N'220500', N'TongHuaShi', N'JiLin')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_56', N'白山市', N'1_7', N'吉林省', N'134300', 2, N'220600', N'BaiShanShi', N'JiLin')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_57', N'松原市', N'1_7', N'吉林省', N'131100', 2, N'220700', N'SongYuanShi', N'JiLin')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_58', N'白城市', N'1_7', N'吉林省', N'137000', 2, N'220800', N'BaiChengShi', N'JiLin')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_59', N'延边朝鲜族自治州', N'1_7', N'吉林省', N'133000', 2, N'222400', N'YanBianChaoXianZuZiZhiZhou', N'JiLin')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_6', N'邯郸市', N'1_3', N'河北省', N'056000', 2, N'130400', N'HanDanShi', N'HeBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_60', N'哈尔滨市', N'1_8', N'黑龙江省', N'150000', 2, N'230100', N'HaErBinShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_61', N'齐齐哈尔市', N'1_8', N'黑龙江省', N'161000', 2, N'230200', N'QiQiHaErShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_62', N'鸡西市', N'1_8', N'黑龙江省', N'158100', 2, N'230300', N'JiXiShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_63', N'鹤岗市', N'1_8', N'黑龙江省', N'154100', 2, N'230400', N'HeGangShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_64', N'双鸭山市', N'1_8', N'黑龙江省', N'155100', 2, N'230500', N'ShuangYaShanShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_65', N'大庆市', N'1_8', N'黑龙江省', N'163000', 2, N'230600', N'DaQingShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_66', N'伊春市', N'1_8', N'黑龙江省', N'152300', 2, N'230700', N'YiChunShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_67', N'佳木斯市', N'1_8', N'黑龙江省', N'154000', 2, N'230800', N'JiaMuSiShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_68', N'七台河市', N'1_8', N'黑龙江省', N'154600', 2, N'230900', N'QiTaiHeShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_69', N'牡丹江市', N'1_8', N'黑龙江省', N'157000', 2, N'231000', N'MuDanJiangShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_7', N'邢台市', N'1_3', N'河北省', N'054000', 2, N'130500', N'XingTaiShi', N'HeBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_70', N'黑河市', N'1_8', N'黑龙江省', N'164300', 2, N'231100', N'HeiHeShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_71', N'绥化市', N'1_8', N'黑龙江省', N'152000', 2, N'231200', N'SuiHuaShi', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_72', N'大兴安岭地区', N'1_8', N'黑龙江省', N'165000', 2, N'232700', N'DaXingAnLingDiQu', N'HeiLongJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_73', N'上海市', N'1_9', N'上海市', N'200000', 2, N'310000', N'ShangHaiShi', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_74', N'南京市', N'1_10', N'江苏省', N'210000', 2, N'320100', N'NanJingShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_75', N'无锡市', N'1_10', N'江苏省', N'214000', 2, N'320200', N'WuXiShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_76', N'徐州市', N'1_10', N'江苏省', N'221000', 2, N'320300', N'XuZhouShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_77', N'常州市', N'1_10', N'江苏省', N'213000', 2, N'320400', N'ChangZhouShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_78', N'苏州市', N'1_10', N'江苏省', N'215000', 2, N'320500', N'SuZhouShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_79', N'南通市', N'1_10', N'江苏省', N'226000', 2, N'320600', N'NanTongShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_8', N'保定市', N'1_3', N'河北省', N'071000', 2, N'130600', N'BaoDingShi', N'HeBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_80', N'连云港市', N'1_10', N'江苏省', N'222000', 2, N'320700', N'LianYunGangShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_81', N'淮安市', N'1_10', N'江苏省', N'223200', 2, N'320800', N'HuaiAnShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_82', N'盐城市', N'1_10', N'江苏省', N'224000', 2, N'320900', N'YanChengShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_83', N'扬州市', N'1_10', N'江苏省', N'225000', 2, N'321000', N'YangZhouShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_84', N'镇江市', N'1_10', N'江苏省', N'212000', 2, N'321100', N'ZhenJiangShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_85', N'泰州市', N'1_10', N'江苏省', N'225300', 2, N'321200', N'TaiZhouShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_86', N'宿迁市', N'1_10', N'江苏省', N'223800', 2, N'321300', N'SuQianShi', N'JiangSu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_87', N'杭州市', N'1_11', N'浙江省', N'310000', 2, N'330100', N'HangZhouShi', N'ZheJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_88', N'宁波市', N'1_11', N'浙江省', N'315000', 2, N'330200', N'NingBoShi', N'ZheJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_89', N'温州市', N'1_11', N'浙江省', N'325000', 2, N'330300', N'WenZhouShi', N'ZheJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_9', N'张家口市', N'1_3', N'河北省', N'075000', 2, N'130700', N'ZhangJiaKouShi', N'HeBei')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_90', N'嘉兴市', N'1_11', N'浙江省', N'314000', 2, N'330400', N'JiaXingShi', N'ZheJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_91', N'湖州市', N'1_11', N'浙江省', N'313000', 2, N'330500', N'HuZhouShi', N'ZheJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_92', N'绍兴市', N'1_11', N'浙江省', N'312000', 2, N'330600', N'ShaoXingShi', N'ZheJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_93', N'金华市', N'1_11', N'浙江省', N'321000', 2, N'330700', N'JinHuaShi', N'ZheJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_94', N'衢州市', N'1_11', N'浙江省', N'324000', 2, N'330800', N'QuZhouShi', N'ZheJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_95', N'舟山市', N'1_11', N'浙江省', N'316000', 2, N'330900', N'ZhouShanShi', N'ZheJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_96', N'台州市', N'1_11', N'浙江省', N'318000', 2, N'331000', N'TaiZhouShi', N'ZheJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_97', N'丽水市', N'1_11', N'浙江省', N'323000', 2, N'331100', N'LiShuiShi', N'ZheJiang')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_98', N'合肥市', N'1_12', N'安徽省', N'230000', 2, N'340100', N'HeFeiShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'2_99', N'芜湖市', N'1_12', N'安徽省', N'241000', 2, N'340200', N'WuHuShi', N'AnHui')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1', N'东城区', N'2_1', N'北京市', N'NULL', 3, N'110101', N'DongChengQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_10', N'房山区', N'2_1', N'北京市', N'NULL', 3, N'110111', N'FangShanQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_100', N'桥东区', N'2_7', N'邢台市', N'NULL', 3, N'130502', N'QiaoDongQu', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1000', N'颍东区', N'2_108', N'阜阳市', N'NULL', 3, N'341203', N'YingDongQu', N'FuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1001', N'颍泉区', N'2_108', N'阜阳市', N'NULL', 3, N'341204', N'YingQuanQu', N'FuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1002', N'临泉县', N'2_108', N'阜阳市', N'NULL', 3, N'341221', N'LinQuanXian', N'FuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1003', N'太和县', N'2_108', N'阜阳市', N'NULL', 3, N'341222', N'TaiHeXian', N'FuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1004', N'阜南县', N'2_108', N'阜阳市', N'NULL', 3, N'341225', N'FuNanXian', N'FuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1005', N'颍上县', N'2_108', N'阜阳市', N'NULL', 3, N'341226', N'YingShangXian', N'FuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1006', N'界首市', N'2_108', N'阜阳市', N'NULL', 3, N'341282', N'JieShouShi', N'FuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1007', N'埇桥区', N'2_109', N'宿州市', N'NULL', 3, N'341302', N'YongQiaoQu', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1008', N'砀山县', N'2_109', N'宿州市', N'NULL', 3, N'341321', N'DangShanXian', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1009', N'萧县', N'2_109', N'宿州市', N'NULL', 3, N'341322', N'XiaoXian', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_101', N'桥西区', N'2_7', N'邢台市', N'NULL', 3, N'130503', N'QiaoXiQu', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1010', N'灵璧县', N'2_109', N'宿州市', N'NULL', 3, N'341323', N'LingBiXian', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1011', N'泗县', N'2_109', N'宿州市', N'NULL', 3, N'341324', N'SiXian', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1012', N'居巢区', N'2_110', N'巢湖市', N'NULL', 3, N'341402', N'JuChaoQu', N'ChaoHuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1013', N'庐江县', N'2_110', N'巢湖市', N'NULL', 3, N'341421', N'LuJiangXian', N'ChaoHuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1014', N'无为县', N'2_110', N'巢湖市', N'NULL', 3, N'341422', N'WuWeiXian', N'ChaoHuShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1015', N'含山县', N'2_110', N'巢湖市', N'NULL', 3, N'341423', N'HanShanXian', N'ChaoHuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1016', N'和县', N'2_110', N'巢湖市', N'NULL', 3, N'341424', N'HeXian', N'ChaoHuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1017', N'金安区', N'2_111', N'六安市', N'NULL', 3, N'341502', N'JinAnQu', N'LiuAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1018', N'裕安区', N'2_111', N'六安市', N'NULL', 3, N'341503', N'YuAnQu', N'LiuAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1019', N'寿县', N'2_111', N'六安市', N'NULL', 3, N'341521', N'ShouXian', N'LiuAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_102', N'邢台县', N'2_7', N'邢台市', N'NULL', 3, N'130521', N'XingTaiXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1020', N'霍邱县', N'2_111', N'六安市', N'NULL', 3, N'341522', N'HuoQiuXian', N'LiuAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1021', N'舒城县', N'2_111', N'六安市', N'NULL', 3, N'341523', N'ShuChengXian', N'LiuAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1022', N'金寨县', N'2_111', N'六安市', N'NULL', 3, N'341524', N'JinZhaiXian', N'LiuAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1023', N'霍山县', N'2_111', N'六安市', N'NULL', 3, N'341525', N'HuoShanXian', N'LiuAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1024', N'谯城区', N'2_112', N'亳州市', N'NULL', 3, N'341602', N'QiaoChengQu', N'BoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1025', N'涡阳县', N'2_112', N'亳州市', N'NULL', 3, N'341621', N'WoYangXian', N'BoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1026', N'蒙城县', N'2_112', N'亳州市', N'NULL', 3, N'341622', N'MengChengXian', N'BoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1027', N'利辛县', N'2_112', N'亳州市', N'NULL', 3, N'341623', N'LiXinXian', N'BoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1028', N'贵池区', N'2_113', N'池州市', N'NULL', 3, N'341702', N'GuiChiQu', N'ChiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1029', N'东至县', N'2_113', N'池州市', N'NULL', 3, N'341721', N'DongZhiXian', N'ChiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_103', N'临城县', N'2_7', N'邢台市', N'NULL', 3, N'130522', N'LinChengXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1030', N'石台县', N'2_113', N'池州市', N'NULL', 3, N'341722', N'ShiTaiXian', N'ChiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1031', N'青阳县', N'2_113', N'池州市', N'NULL', 3, N'341723', N'QingYangXian', N'ChiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1032', N'宣州区', N'2_114', N'宣城市', N'NULL', 3, N'341802', N'XuanZhouQu', N'XuanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1033', N'郎溪县', N'2_114', N'宣城市', N'NULL', 3, N'341821', N'LangXiXian', N'XuanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1034', N'广德县', N'2_114', N'宣城市', N'NULL', 3, N'341822', N'GuangDeXian', N'XuanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1035', N'泾县', N'2_114', N'宣城市', N'NULL', 3, N'341823', N'JingXian', N'XuanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1036', N'绩溪县', N'2_114', N'宣城市', N'NULL', 3, N'341824', N'JiXiXian', N'XuanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1037', N'旌德县', N'2_114', N'宣城市', N'NULL', 3, N'341825', N'JingDeXian', N'XuanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1038', N'宁国市', N'2_114', N'宣城市', N'NULL', 3, N'341881', N'NingGuoShi', N'XuanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1039', N'鼓楼区', N'2_115', N'福州市', N'NULL', 3, N'350102', N'GuLouQu', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_104', N'内丘县', N'2_7', N'邢台市', N'NULL', 3, N'130523', N'NaQiuXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1040', N'台江区', N'2_115', N'福州市', N'NULL', 3, N'350103', N'TaiJiangQu', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1041', N'仓山区', N'2_115', N'福州市', N'NULL', 3, N'350104', N'CangShanQu', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1042', N'马尾区', N'2_115', N'福州市', N'NULL', 3, N'350105', N'MaWeiQu', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1043', N'晋安区', N'2_115', N'福州市', N'NULL', 3, N'350111', N'JinAnQu', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1044', N'闽侯县', N'2_115', N'福州市', N'NULL', 3, N'350121', N'MinHouXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1045', N'连江县', N'2_115', N'福州市', N'NULL', 3, N'350122', N'LianJiangXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1046', N'罗源县', N'2_115', N'福州市', N'NULL', 3, N'350123', N'LuoYuanXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1047', N'闽清县', N'2_115', N'福州市', N'NULL', 3, N'350124', N'MinQingXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1048', N'永泰县', N'2_115', N'福州市', N'NULL', 3, N'350125', N'YongTaiXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1049', N'平潭县', N'2_115', N'福州市', N'NULL', 3, N'350128', N'PingTanXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_105', N'柏乡县', N'2_7', N'邢台市', N'NULL', 3, N'130524', N'BaiXiangXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1050', N'福清市', N'2_115', N'福州市', N'NULL', 3, N'350181', N'FuQingShi', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1051', N'长乐市', N'2_115', N'福州市', N'NULL', 3, N'350182', N'ChangLeShi', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1052', N'思明区', N'2_116', N'厦门市', N'NULL', 3, N'350203', N'SiMingQu', N'XiaMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1053', N'海沧区', N'2_116', N'厦门市', N'NULL', 3, N'350205', N'HaiCangQu', N'XiaMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1054', N'湖里区', N'2_116', N'厦门市', N'NULL', 3, N'350206', N'HuLiQu', N'XiaMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1055', N'集美区', N'2_116', N'厦门市', N'NULL', 3, N'350211', N'JiMeiQu', N'XiaMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1056', N'同安区', N'2_116', N'厦门市', N'NULL', 3, N'350212', N'TongAnQu', N'XiaMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1057', N'翔安区', N'2_116', N'厦门市', N'NULL', 3, N'350213', N'XiangAnQu', N'XiaMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1058', N'城厢区', N'2_117', N'莆田市', N'NULL', 3, N'350302', N'ChengXiangQu', N'PuTianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1059', N'涵江区', N'2_117', N'莆田市', N'NULL', 3, N'350303', N'HanJiangQu', N'PuTianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_106', N'隆尧县', N'2_7', N'邢台市', N'NULL', 3, N'130525', N'LongYaoXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1060', N'荔城区', N'2_117', N'莆田市', N'NULL', 3, N'350304', N'LiChengQu', N'PuTianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1061', N'秀屿区', N'2_117', N'莆田市', N'NULL', 3, N'350305', N'XiuYuQu', N'PuTianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1062', N'仙游县', N'2_117', N'莆田市', N'NULL', 3, N'350322', N'XianYouXian', N'PuTianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1063', N'梅列区', N'2_118', N'三明市', N'NULL', 3, N'350402', N'MeiLieQu', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1064', N'三元区', N'2_118', N'三明市', N'NULL', 3, N'350403', N'SanYuanQu', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1065', N'明溪县', N'2_118', N'三明市', N'NULL', 3, N'350421', N'MingXiXian', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1066', N'清流县', N'2_118', N'三明市', N'NULL', 3, N'350423', N'QingLiuXian', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1067', N'宁化县', N'2_118', N'三明市', N'NULL', 3, N'350424', N'NingHuaXian', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1068', N'大田县', N'2_118', N'三明市', N'NULL', 3, N'350425', N'DaTianXian', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1069', N'尤溪县', N'2_118', N'三明市', N'NULL', 3, N'350426', N'YouXiXian', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_107', N'任县', N'2_7', N'邢台市', N'NULL', 3, N'130526', N'RenXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1070', N'沙县', N'2_118', N'三明市', N'NULL', 3, N'350427', N'ShaXian', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1071', N'将乐县', N'2_118', N'三明市', N'NULL', 3, N'350428', N'JiangLeXian', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1072', N'泰宁县', N'2_118', N'三明市', N'NULL', 3, N'350429', N'TaiNingXian', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1073', N'建宁县', N'2_118', N'三明市', N'NULL', 3, N'350430', N'JianNingXian', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1074', N'永安市', N'2_118', N'三明市', N'NULL', 3, N'350481', N'YongAnShi', N'SanMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1075', N'鲤城区', N'2_119', N'泉州市', N'NULL', 3, N'350502', N'LiChengQu', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1076', N'丰泽区', N'2_119', N'泉州市', N'NULL', 3, N'350503', N'FengZeQu', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1077', N'洛江区', N'2_119', N'泉州市', N'NULL', 3, N'350504', N'LuoJiangQu', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1078', N'泉港区', N'2_119', N'泉州市', N'NULL', 3, N'350505', N'QuanGangQu', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1079', N'惠安县', N'2_119', N'泉州市', N'NULL', 3, N'350521', N'HuiAnXian', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_108', N'南和县', N'2_7', N'邢台市', N'NULL', 3, N'130527', N'NanHeXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1080', N'安溪县', N'2_119', N'泉州市', N'NULL', 3, N'350524', N'AnXiXian', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1081', N'永春县', N'2_119', N'泉州市', N'NULL', 3, N'350525', N'YongChunXian', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1082', N'德化县', N'2_119', N'泉州市', N'NULL', 3, N'350526', N'DeHuaXian', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1083', N'金门县', N'2_119', N'泉州市', N'NULL', 3, N'350527', N'JinMenXian', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1084', N'石狮市', N'2_119', N'泉州市', N'NULL', 3, N'350581', N'ShiShiShi', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1085', N'晋江市', N'2_119', N'泉州市', N'NULL', 3, N'350582', N'JinJiangShi', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1086', N'南安市', N'2_119', N'泉州市', N'NULL', 3, N'350583', N'NanAnShi', N'QuanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1087', N'芗城区', N'2_120', N'漳州市', N'NULL', 3, N'350602', N'XiangChengQu', N'ZhangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1088', N'龙文区', N'2_120', N'漳州市', N'NULL', 3, N'350603', N'LongWenQu', N'ZhangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1089', N'云霄县', N'2_120', N'漳州市', N'NULL', 3, N'350622', N'YunXiaoXian', N'ZhangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_109', N'宁晋县', N'2_7', N'邢台市', N'NULL', 3, N'130528', N'NingJinXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1090', N'漳浦县', N'2_120', N'漳州市', N'NULL', 3, N'350623', N'ZhangPuXian', N'ZhangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1091', N'诏安县', N'2_120', N'漳州市', N'NULL', 3, N'350624', N'ZhaoAnXian', N'ZhangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1092', N'长泰县', N'2_120', N'漳州市', N'NULL', 3, N'350625', N'ChangTaiXian', N'ZhangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1093', N'东山县', N'2_120', N'漳州市', N'NULL', 3, N'350626', N'DongShanXian', N'ZhangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1094', N'南靖县', N'2_120', N'漳州市', N'NULL', 3, N'350627', N'NanJingXian', N'ZhangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1095', N'平和县', N'2_120', N'漳州市', N'NULL', 3, N'350628', N'PingHeXian', N'ZhangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1096', N'华安县', N'2_120', N'漳州市', N'NULL', 3, N'350629', N'HuaAnXian', N'ZhangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1097', N'龙海市', N'2_120', N'漳州市', N'NULL', 3, N'350681', N'LongHaiShi', N'ZhangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1098', N'延平区', N'2_121', N'南平市', N'NULL', 3, N'350702', N'YanPingQu', N'NanPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1099', N'顺昌县', N'2_121', N'南平市', N'NULL', 3, N'350721', N'ShunChangXian', N'NanPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_11', N'通州区', N'2_1', N'北京市', N'NULL', 3, N'110112', N'TongZhouQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_110', N'巨鹿县', N'2_7', N'邢台市', N'NULL', 3, N'130529', N'JuLuXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1100', N'浦城县', N'2_121', N'南平市', N'NULL', 3, N'350722', N'PuChengXian', N'NanPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1101', N'光泽县', N'2_121', N'南平市', N'NULL', 3, N'350723', N'GuangZeXian', N'NanPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1102', N'松溪县', N'2_121', N'南平市', N'NULL', 3, N'350724', N'SongXiXian', N'NanPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1103', N'政和县', N'2_121', N'南平市', N'NULL', 3, N'350725', N'ZhengHeXian', N'NanPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1104', N'邵武市', N'2_121', N'南平市', N'NULL', 3, N'350781', N'ShaoWuShi', N'NanPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1105', N'武夷山市', N'2_121', N'南平市', N'NULL', 3, N'350782', N'WuYiShanShi', N'NanPingShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1106', N'建瓯市', N'2_121', N'南平市', N'NULL', 3, N'350783', N'JianOuShi', N'NanPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1107', N'建阳市', N'2_121', N'南平市', N'NULL', 3, N'350784', N'JianYangShi', N'NanPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1108', N'新罗区', N'2_122', N'龙岩市', N'NULL', 3, N'350802', N'XinLuoQu', N'LongYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1109', N'长汀县', N'2_122', N'龙岩市', N'NULL', 3, N'350821', N'ChangTingXian', N'LongYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_111', N'新河县', N'2_7', N'邢台市', N'NULL', 3, N'130530', N'XinHeXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1110', N'永定县', N'2_122', N'龙岩市', N'NULL', 3, N'350822', N'YongDingXian', N'LongYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1111', N'上杭县', N'2_122', N'龙岩市', N'NULL', 3, N'350823', N'ShangHangXian', N'LongYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1112', N'武平县', N'2_122', N'龙岩市', N'NULL', 3, N'350824', N'WuPingXian', N'LongYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1113', N'连城县', N'2_122', N'龙岩市', N'NULL', 3, N'350825', N'LianChengXian', N'LongYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1114', N'漳平市', N'2_122', N'龙岩市', N'NULL', 3, N'350881', N'ZhangPingShi', N'LongYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1115', N'蕉城区', N'2_123', N'宁德市', N'NULL', 3, N'350902', N'JiaoChengQu', N'NingDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1116', N'霞浦县', N'2_123', N'宁德市', N'NULL', 3, N'350921', N'XiaPuXian', N'NingDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1117', N'古田县', N'2_123', N'宁德市', N'NULL', 3, N'350922', N'GuTianXian', N'NingDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1118', N'屏南县', N'2_123', N'宁德市', N'NULL', 3, N'350923', N'PingNanXian', N'NingDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1119', N'寿宁县', N'2_123', N'宁德市', N'NULL', 3, N'350924', N'ShouNingXian', N'NingDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_112', N'广宗县', N'2_7', N'邢台市', N'NULL', 3, N'130531', N'GuangZongXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1120', N'周宁县', N'2_123', N'宁德市', N'NULL', 3, N'350925', N'ZhouNingXian', N'NingDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1121', N'柘荣县', N'2_123', N'宁德市', N'NULL', 3, N'350926', N'ZheRongXian', N'NingDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1122', N'福安市', N'2_123', N'宁德市', N'NULL', 3, N'350981', N'FuAnShi', N'NingDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1123', N'福鼎市', N'2_123', N'宁德市', N'NULL', 3, N'350982', N'FuDingShi', N'NingDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1124', N'东湖区', N'2_124', N'南昌市', N'NULL', 3, N'360102', N'DongHuQu', N'NanChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1125', N'西湖区', N'2_124', N'南昌市', N'NULL', 3, N'360103', N'XiHuQu', N'NanChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1126', N'青云谱区', N'2_124', N'南昌市', N'NULL', 3, N'360104', N'QingYunPuQu', N'NanChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1127', N'湾里区', N'2_124', N'南昌市', N'NULL', 3, N'360105', N'WanLiQu', N'NanChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1128', N'青山湖区', N'2_124', N'南昌市', N'NULL', 3, N'360111', N'QingShanHuQu', N'NanChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1129', N'南昌县', N'2_124', N'南昌市', N'NULL', 3, N'360121', N'NanChangXian', N'NanChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_113', N'平乡县', N'2_7', N'邢台市', N'NULL', 3, N'130532', N'PingXiangXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1130', N'新建县', N'2_124', N'南昌市', N'NULL', 3, N'360122', N'XinJianXian', N'NanChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1131', N'安义县', N'2_124', N'南昌市', N'NULL', 3, N'360123', N'AnYiXian', N'NanChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1132', N'进贤县', N'2_124', N'南昌市', N'NULL', 3, N'360124', N'JinXianXian', N'NanChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1133', N'昌江区', N'2_125', N'景德镇市', N'NULL', 3, N'360202', N'ChangJiangQu', N'JingDeZhenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1134', N'珠山区', N'2_125', N'景德镇市', N'NULL', 3, N'360203', N'ZhuShanQu', N'JingDeZhenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1135', N'浮梁县', N'2_125', N'景德镇市', N'NULL', 3, N'360222', N'FuLiangXian', N'JingDeZhenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1136', N'乐平市', N'2_125', N'景德镇市', N'NULL', 3, N'360281', N'LePingShi', N'JingDeZhenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1137', N'安源区', N'2_126', N'萍乡市', N'NULL', 3, N'360302', N'AnYuanQu', N'PingXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1138', N'湘东区', N'2_126', N'萍乡市', N'NULL', 3, N'360313', N'XiangDongQu', N'PingXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1139', N'莲花县', N'2_126', N'萍乡市', N'NULL', 3, N'360321', N'LianHuaXian', N'PingXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_114', N'威县', N'2_7', N'邢台市', N'NULL', 3, N'130533', N'WeiXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1140', N'上栗县', N'2_126', N'萍乡市', N'NULL', 3, N'360322', N'ShangLiXian', N'PingXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1141', N'芦溪县', N'2_126', N'萍乡市', N'NULL', 3, N'360323', N'LuXiXian', N'PingXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1142', N'庐山区', N'2_127', N'九江市', N'NULL', 3, N'360402', N'LuShanQu', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1143', N'浔阳区', N'2_127', N'九江市', N'NULL', 3, N'360403', N'XunYangQu', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1144', N'九江县', N'2_127', N'九江市', N'NULL', 3, N'360421', N'JiuJiangXian', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1145', N'武宁县', N'2_127', N'九江市', N'NULL', 3, N'360423', N'WuNingXian', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1146', N'修水县', N'2_127', N'九江市', N'NULL', 3, N'360424', N'XiuShuiXian', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1147', N'永修县', N'2_127', N'九江市', N'NULL', 3, N'360425', N'YongXiuXian', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1148', N'德安县', N'2_127', N'九江市', N'NULL', 3, N'360426', N'DeAnXian', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1149', N'星子县', N'2_127', N'九江市', N'NULL', 3, N'360427', N'XingZiXian', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_115', N'清河县', N'2_7', N'邢台市', N'NULL', 3, N'130534', N'QingHeXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1150', N'都昌县', N'2_127', N'九江市', N'NULL', 3, N'360428', N'DouChangXian', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1151', N'湖口县', N'2_127', N'九江市', N'NULL', 3, N'360429', N'HuKouXian', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1152', N'彭泽县', N'2_127', N'九江市', N'NULL', 3, N'360430', N'PengZeXian', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1153', N'瑞昌市', N'2_127', N'九江市', N'NULL', 3, N'360481', N'RuiChangShi', N'JiuJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1154', N'渝水区', N'2_128', N'新余市', N'NULL', 3, N'360502', N'YuShuiQu', N'XinYuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1155', N'分宜县', N'2_128', N'新余市', N'NULL', 3, N'360521', N'FenYiXian', N'XinYuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1156', N'月湖区', N'2_129', N'鹰潭市', N'NULL', 3, N'360602', N'YueHuQu', N'YingTanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1157', N'余江县', N'2_129', N'鹰潭市', N'NULL', 3, N'360622', N'YuJiangXian', N'YingTanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1158', N'贵溪市', N'2_129', N'鹰潭市', N'NULL', 3, N'360681', N'GuiXiShi', N'YingTanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1159', N'章贡区', N'2_130', N'赣州市', N'NULL', 3, N'360702', N'ZhangGongQu', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_116', N'临西县', N'2_7', N'邢台市', N'NULL', 3, N'130535', N'LinXiXian', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1160', N'赣县', N'2_130', N'赣州市', N'NULL', 3, N'360721', N'GanXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1161', N'信丰县', N'2_130', N'赣州市', N'NULL', 3, N'360722', N'XinFengXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1162', N'大余县', N'2_130', N'赣州市', N'NULL', 3, N'360723', N'DaYuXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1163', N'上犹县', N'2_130', N'赣州市', N'NULL', 3, N'360724', N'ShangYouXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1164', N'崇义县', N'2_130', N'赣州市', N'NULL', 3, N'360725', N'ChongYiXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1165', N'安远县', N'2_130', N'赣州市', N'NULL', 3, N'360726', N'AnYuanXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1166', N'龙南县', N'2_130', N'赣州市', N'NULL', 3, N'360727', N'LongNanXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1167', N'定南县', N'2_130', N'赣州市', N'NULL', 3, N'360728', N'DingNanXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1168', N'全南县', N'2_130', N'赣州市', N'NULL', 3, N'360729', N'QuanNanXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1169', N'宁都县', N'2_130', N'赣州市', N'NULL', 3, N'360730', N'NingDouXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_117', N'南宫市', N'2_7', N'邢台市', N'NULL', 3, N'130581', N'NanGongShi', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1170', N'于都县', N'2_130', N'赣州市', N'NULL', 3, N'360731', N'YuDouXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1171', N'兴国县', N'2_130', N'赣州市', N'NULL', 3, N'360732', N'XingGuoXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1172', N'会昌县', N'2_130', N'赣州市', N'NULL', 3, N'360733', N'HuiChangXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1173', N'寻乌县', N'2_130', N'赣州市', N'NULL', 3, N'360734', N'XunWuXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1174', N'石城县', N'2_130', N'赣州市', N'NULL', 3, N'360735', N'ShiChengXian', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1175', N'瑞金市', N'2_130', N'赣州市', N'NULL', 3, N'360781', N'RuiJinShi', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1176', N'南康市', N'2_130', N'赣州市', N'NULL', 3, N'360782', N'NanKangShi', N'GanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1177', N'吉州区', N'2_131', N'吉安市', N'NULL', 3, N'360802', N'JiZhouQu', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1178', N'青原区', N'2_131', N'吉安市', N'NULL', 3, N'360803', N'QingYuanQu', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1179', N'吉安县', N'2_131', N'吉安市', N'NULL', 3, N'360821', N'JiAnXian', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_118', N'沙河市', N'2_7', N'邢台市', N'NULL', 3, N'130582', N'ShaHeShi', N'XingTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1180', N'吉水县', N'2_131', N'吉安市', N'NULL', 3, N'360822', N'JiShuiXian', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1181', N'峡江县', N'2_131', N'吉安市', N'NULL', 3, N'360823', N'XiaJiangXian', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1182', N'新干县', N'2_131', N'吉安市', N'NULL', 3, N'360824', N'XinGanXian', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1183', N'永丰县', N'2_131', N'吉安市', N'NULL', 3, N'360825', N'YongFengXian', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1184', N'泰和县', N'2_131', N'吉安市', N'NULL', 3, N'360826', N'TaiHeXian', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1185', N'遂川县', N'2_131', N'吉安市', N'NULL', 3, N'360827', N'SuiChuanXian', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1186', N'万安县', N'2_131', N'吉安市', N'NULL', 3, N'360828', N'WanAnXian', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1187', N'安福县', N'2_131', N'吉安市', N'NULL', 3, N'360829', N'AnFuXian', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1188', N'永新县', N'2_131', N'吉安市', N'NULL', 3, N'360830', N'YongXinXian', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1189', N'井冈山市', N'2_131', N'吉安市', N'NULL', 3, N'360881', N'JingGangShanShi', N'JiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_119', N'新市区', N'2_8', N'保定市', N'NULL', 3, N'130602', N'XinShiQu', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1190', N'袁州区', N'2_132', N'宜春市', N'NULL', 3, N'360902', N'YuanZhouQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1191', N'奉新县', N'2_132', N'宜春市', N'NULL', 3, N'360921', N'FengXinXian', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1192', N'万载县', N'2_132', N'宜春市', N'NULL', 3, N'360922', N'WanZaiXian', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1193', N'上高县', N'2_132', N'宜春市', N'NULL', 3, N'360923', N'ShangGaoXian', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1194', N'宜丰县', N'2_132', N'宜春市', N'NULL', 3, N'360924', N'YiFengXian', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1195', N'靖安县', N'2_132', N'宜春市', N'NULL', 3, N'360925', N'JingAnXian', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1196', N'铜鼓县', N'2_132', N'宜春市', N'NULL', 3, N'360926', N'TongGuXian', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1197', N'丰城市', N'2_132', N'宜春市', N'NULL', 3, N'360981', N'FengChengShi', N'YiChunShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1198', N'樟树市', N'2_132', N'宜春市', N'NULL', 3, N'360982', N'ZhangShuShi', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1199', N'高安市', N'2_132', N'宜春市', N'NULL', 3, N'360983', N'GaoAnShi', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_12', N'顺义区', N'2_1', N'北京市', N'NULL', 3, N'110113', N'ShunYiQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_120', N'北市区', N'2_8', N'保定市', N'NULL', 3, N'130603', N'BeiShiQu', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1200', N'临川区', N'2_133', N'抚州市', N'NULL', 3, N'361002', N'LinChuanQu', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1201', N'南城县', N'2_133', N'抚州市', N'NULL', 3, N'361021', N'NanChengXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1202', N'黎川县', N'2_133', N'抚州市', N'NULL', 3, N'361022', N'LiChuanXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1203', N'南丰县', N'2_133', N'抚州市', N'NULL', 3, N'361023', N'NanFengXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1204', N'崇仁县', N'2_133', N'抚州市', N'NULL', 3, N'361024', N'ChongRenXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1205', N'乐安县', N'2_133', N'抚州市', N'NULL', 3, N'361025', N'LeAnXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1206', N'宜黄县', N'2_133', N'抚州市', N'NULL', 3, N'361026', N'YiHuangXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1207', N'金溪县', N'2_133', N'抚州市', N'NULL', 3, N'361027', N'JinXiXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1208', N'资溪县', N'2_133', N'抚州市', N'NULL', 3, N'361028', N'ZiXiXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1209', N'东乡县', N'2_133', N'抚州市', N'NULL', 3, N'361029', N'DongXiangXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_121', N'南市区', N'2_8', N'保定市', N'NULL', 3, N'130604', N'NanShiQu', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1210', N'广昌县', N'2_133', N'抚州市', N'NULL', 3, N'361030', N'GuangChangXian', N'FuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1211', N'信州区', N'2_134', N'上饶市', N'NULL', 3, N'361102', N'XinZhouQu', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1212', N'上饶县', N'2_134', N'上饶市', N'NULL', 3, N'361121', N'ShangRaoXian', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1213', N'广丰县', N'2_134', N'上饶市', N'NULL', 3, N'361122', N'GuangFengXian', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1214', N'玉山县', N'2_134', N'上饶市', N'NULL', 3, N'361123', N'YuShanXian', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1215', N'铅山县', N'2_134', N'上饶市', N'NULL', 3, N'361124', N'QianShanXian', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1216', N'横峰县', N'2_134', N'上饶市', N'NULL', 3, N'361125', N'HengFengXian', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1217', N'弋阳县', N'2_134', N'上饶市', N'NULL', 3, N'361126', N'YiYangXian', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1218', N'余干县', N'2_134', N'上饶市', N'NULL', 3, N'361127', N'YuGanXian', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1219', N'鄱阳县', N'2_134', N'上饶市', N'NULL', 3, N'361128', N'PoYangXian', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_122', N'满城县', N'2_8', N'保定市', N'NULL', 3, N'130621', N'ManChengXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1220', N'万年县', N'2_134', N'上饶市', N'NULL', 3, N'361129', N'WanNianXian', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1221', N'婺源县', N'2_134', N'上饶市', N'NULL', 3, N'361130', N'WuYuanXian', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1222', N'德兴市', N'2_134', N'上饶市', N'NULL', 3, N'361181', N'DeXingShi', N'ShangRaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1223', N'历下区', N'2_135', N'济南市', N'NULL', 3, N'370102', N'LiXiaQu', N'JiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1224', N'市中区', N'2_135', N'济南市', N'NULL', 3, N'370103', N'ShiZhongQu', N'JiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1225', N'槐荫区', N'2_135', N'济南市', N'NULL', 3, N'370104', N'HuaiYinQu', N'JiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1226', N'天桥区', N'2_135', N'济南市', N'NULL', 3, N'370105', N'TianQiaoQu', N'JiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1227', N'历城区', N'2_135', N'济南市', N'NULL', 3, N'370112', N'LiChengQu', N'JiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1228', N'长清区', N'2_135', N'济南市', N'NULL', 3, N'370113', N'ChangQingQu', N'JiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1229', N'平阴县', N'2_135', N'济南市', N'NULL', 3, N'370124', N'PingYinXian', N'JiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_123', N'清苑县', N'2_8', N'保定市', N'NULL', 3, N'130622', N'QingYuanXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1230', N'济阳县', N'2_135', N'济南市', N'NULL', 3, N'370125', N'JiYangXian', N'JiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1231', N'商河县', N'2_135', N'济南市', N'NULL', 3, N'370126', N'ShangHeXian', N'JiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1232', N'章丘市', N'2_135', N'济南市', N'NULL', 3, N'370181', N'ZhangQiuShi', N'JiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1233', N'市南区', N'2_136', N'青岛市', N'NULL', 3, N'370202', N'ShiNanQu', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1234', N'市北区', N'2_136', N'青岛市', N'NULL', 3, N'370203', N'ShiBeiQu', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1235', N'四方区', N'2_136', N'青岛市', N'NULL', 3, N'370205', N'SiFangQu', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1236', N'黄岛区', N'2_136', N'青岛市', N'NULL', 3, N'370211', N'HuangDaoQu', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1237', N'崂山区', N'2_136', N'青岛市', N'NULL', 3, N'370212', N'LaoShanQu', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1238', N'李沧区', N'2_136', N'青岛市', N'NULL', 3, N'370213', N'LiCangQu', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1239', N'城阳区', N'2_136', N'青岛市', N'NULL', 3, N'370214', N'ChengYangQu', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_124', N'涞水县', N'2_8', N'保定市', N'NULL', 3, N'130623', N'LaiShuiXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1240', N'胶州市', N'2_136', N'青岛市', N'NULL', 3, N'370281', N'JiaoZhouShi', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1241', N'即墨市', N'2_136', N'青岛市', N'NULL', 3, N'370282', N'JiMoShi', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1242', N'平度市', N'2_136', N'青岛市', N'NULL', 3, N'370283', N'PingDuShi', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1243', N'胶南市', N'2_136', N'青岛市', N'NULL', 3, N'370284', N'JiaoNanShi', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1244', N'莱西市', N'2_136', N'青岛市', N'NULL', 3, N'370285', N'LaiXiShi', N'QingDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1245', N'淄川区', N'2_137', N'淄博市', N'NULL', 3, N'370302', N'ZiChuanQu', N'ZiBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1246', N'张店区', N'2_137', N'淄博市', N'NULL', 3, N'370303', N'ZhangDianQu', N'ZiBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1247', N'博山区', N'2_137', N'淄博市', N'NULL', 3, N'370304', N'BoShanQu', N'ZiBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1248', N'临淄区', N'2_137', N'淄博市', N'NULL', 3, N'370305', N'LinZiQu', N'ZiBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1249', N'周村区', N'2_137', N'淄博市', N'NULL', 3, N'370306', N'ZhouCunQu', N'ZiBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_125', N'阜平县', N'2_8', N'保定市', N'NULL', 3, N'130624', N'FuPingXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1250', N'桓台县', N'2_137', N'淄博市', N'NULL', 3, N'370321', N'HuanTaiXian', N'ZiBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1251', N'高青县', N'2_137', N'淄博市', N'NULL', 3, N'370322', N'GaoQingXian', N'ZiBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1252', N'沂源县', N'2_137', N'淄博市', N'NULL', 3, N'370323', N'YiYuanXian', N'ZiBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1253', N'市中区', N'2_138', N'枣庄市', N'NULL', 3, N'370402', N'ShiZhongQu', N'ZaoZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1254', N'薛城区', N'2_138', N'枣庄市', N'NULL', 3, N'370403', N'XueChengQu', N'ZaoZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1255', N'峄城区', N'2_138', N'枣庄市', N'NULL', 3, N'370404', N'YiChengQu', N'ZaoZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1256', N'台儿庄区', N'2_138', N'枣庄市', N'NULL', 3, N'370405', N'TaiErZhuangQu', N'ZaoZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1257', N'山亭区', N'2_138', N'枣庄市', N'NULL', 3, N'370406', N'ShanTingQu', N'ZaoZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1258', N'滕州市', N'2_138', N'枣庄市', N'NULL', 3, N'370481', N'TengZhouShi', N'ZaoZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1259', N'东营区', N'2_139', N'东营市', N'NULL', 3, N'370502', N'DongYingQu', N'DongYingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_126', N'徐水县', N'2_8', N'保定市', N'NULL', 3, N'130625', N'XuShuiXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1260', N'河口区', N'2_139', N'东营市', N'NULL', 3, N'370503', N'HeKouQu', N'DongYingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1261', N'垦利县', N'2_139', N'东营市', N'NULL', 3, N'370521', N'KenLiXian', N'DongYingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1262', N'利津县', N'2_139', N'东营市', N'NULL', 3, N'370522', N'LiJinXian', N'DongYingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1263', N'广饶县', N'2_139', N'东营市', N'NULL', 3, N'370523', N'GuangRaoXian', N'DongYingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1264', N'芝罘区', N'2_140', N'烟台市', N'NULL', 3, N'370602', N'ZhiFuQu', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1265', N'福山区', N'2_140', N'烟台市', N'NULL', 3, N'370611', N'FuShanQu', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1266', N'牟平区', N'2_140', N'烟台市', N'NULL', 3, N'370612', N'MouPingQu', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1267', N'莱山区', N'2_140', N'烟台市', N'NULL', 3, N'370613', N'LaiShanQu', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1268', N'长岛县', N'2_140', N'烟台市', N'NULL', 3, N'370634', N'ChangDaoXian', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1269', N'龙口市', N'2_140', N'烟台市', N'NULL', 3, N'370681', N'LongKouShi', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_127', N'定兴县', N'2_8', N'保定市', N'NULL', 3, N'130626', N'DingXingXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1270', N'莱阳市', N'2_140', N'烟台市', N'NULL', 3, N'370682', N'LaiYangShi', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1271', N'莱州市', N'2_140', N'烟台市', N'NULL', 3, N'370683', N'LaiZhouShi', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1272', N'蓬莱市', N'2_140', N'烟台市', N'NULL', 3, N'370684', N'PengLaiShi', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1273', N'招远市', N'2_140', N'烟台市', N'NULL', 3, N'370685', N'ZhaoYuanShi', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1274', N'栖霞市', N'2_140', N'烟台市', N'NULL', 3, N'370686', N'QiXiaShi', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1275', N'海阳市', N'2_140', N'烟台市', N'NULL', 3, N'370687', N'HaiYangShi', N'YanTaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1276', N'潍城区', N'2_141', N'潍坊市', N'NULL', 3, N'370702', N'WeiChengQu', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1277', N'寒亭区', N'2_141', N'潍坊市', N'NULL', 3, N'370703', N'HanTingQu', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1278', N'坊子区', N'2_141', N'潍坊市', N'NULL', 3, N'370704', N'FangZiQu', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1279', N'奎文区', N'2_141', N'潍坊市', N'NULL', 3, N'370705', N'KuiWenQu', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_128', N'唐县', N'2_8', N'保定市', N'NULL', 3, N'130627', N'TangXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1280', N'临朐县', N'2_141', N'潍坊市', N'NULL', 3, N'370724', N'LinQuXian', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1281', N'昌乐县', N'2_141', N'潍坊市', N'NULL', 3, N'370725', N'ChangLeXian', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1282', N'青州市', N'2_141', N'潍坊市', N'NULL', 3, N'370781', N'QingZhouShi', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1283', N'诸城市', N'2_141', N'潍坊市', N'NULL', 3, N'370782', N'ZhuChengShi', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1284', N'寿光市', N'2_141', N'潍坊市', N'NULL', 3, N'370783', N'ShouGuangShi', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1285', N'安丘市', N'2_141', N'潍坊市', N'NULL', 3, N'370784', N'AnQiuShi', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1286', N'高密市', N'2_141', N'潍坊市', N'NULL', 3, N'370785', N'GaoMiShi', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1287', N'昌邑市', N'2_141', N'潍坊市', N'NULL', 3, N'370786', N'ChangYiShi', N'WeiFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1288', N'市中区', N'2_142', N'济宁市', N'NULL', 3, N'370802', N'ShiZhongQu', N'JiNingShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1289', N'任城区', N'2_142', N'济宁市', N'NULL', 3, N'370811', N'RenChengQu', N'JiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_129', N'高阳县', N'2_8', N'保定市', N'NULL', 3, N'130628', N'GaoYangXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1290', N'微山县', N'2_142', N'济宁市', N'NULL', 3, N'370826', N'WeiShanXian', N'JiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1291', N'鱼台县', N'2_142', N'济宁市', N'NULL', 3, N'370827', N'YuTaiXian', N'JiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1292', N'金乡县', N'2_142', N'济宁市', N'NULL', 3, N'370828', N'JinXiangXian', N'JiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1293', N'嘉祥县', N'2_142', N'济宁市', N'NULL', 3, N'370829', N'JiaXiangXian', N'JiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1294', N'汶上县', N'2_142', N'济宁市', N'NULL', 3, N'370830', N'WenShangXian', N'JiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1295', N'泗水县', N'2_142', N'济宁市', N'NULL', 3, N'370831', N'SiShuiXian', N'JiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1296', N'梁山县', N'2_142', N'济宁市', N'NULL', 3, N'370832', N'LiangShanXian', N'JiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1297', N'曲阜市', N'2_142', N'济宁市', N'NULL', 3, N'370881', N'QuFuShi', N'JiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1298', N'兖州市', N'2_142', N'济宁市', N'NULL', 3, N'370882', N'YanZhouShi', N'JiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1299', N'邹城市', N'2_142', N'济宁市', N'NULL', 3, N'370883', N'ZouChengShi', N'JiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_13', N'昌平区', N'2_1', N'北京市', N'NULL', 3, N'110114', N'ChangPingQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_130', N'容城县', N'2_8', N'保定市', N'NULL', 3, N'130629', N'RongChengXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1300', N'泰山区', N'2_143', N'泰安市', N'NULL', 3, N'370902', N'TaiShanQu', N'TaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1301', N'岱岳区', N'2_143', N'泰安市', N'NULL', 3, N'370903', N'DaiYueQu', N'TaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1302', N'宁阳县', N'2_143', N'泰安市', N'NULL', 3, N'370921', N'NingYangXian', N'TaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1303', N'东平县', N'2_143', N'泰安市', N'NULL', 3, N'370923', N'DongPingXian', N'TaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1304', N'新泰市', N'2_143', N'泰安市', N'NULL', 3, N'370982', N'XinTaiShi', N'TaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1305', N'肥城市', N'2_143', N'泰安市', N'NULL', 3, N'370983', N'FeiChengShi', N'TaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1306', N'环翠区', N'2_144', N'威海市', N'NULL', 3, N'371002', N'HuanCuiQu', N'WeiHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1307', N'文登市', N'2_144', N'威海市', N'NULL', 3, N'371081', N'WenDengShi', N'WeiHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1308', N'荣成市', N'2_144', N'威海市', N'NULL', 3, N'371082', N'RongChengShi', N'WeiHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1309', N'乳山市', N'2_144', N'威海市', N'NULL', 3, N'371083', N'RuShanShi', N'WeiHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_131', N'涞源县', N'2_8', N'保定市', N'NULL', 3, N'130630', N'LaiYuanXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1310', N'东港区', N'2_145', N'日照市', N'NULL', 3, N'371102', N'DongGangQu', N'RiZhaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1311', N'岚山区', N'2_145', N'日照市', N'NULL', 3, N'371103', N'LanShanQu', N'RiZhaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1312', N'五莲县', N'2_145', N'日照市', N'NULL', 3, N'371121', N'WuLianXian', N'RiZhaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1313', N'莒县', N'2_145', N'日照市', N'NULL', 3, N'371122', N'JuXian', N'RiZhaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1314', N'莱城区', N'2_146', N'莱芜市', N'NULL', 3, N'371202', N'LaiChengQu', N'LaiWuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1315', N'钢城区', N'2_146', N'莱芜市', N'NULL', 3, N'371203', N'GangChengQu', N'LaiWuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1316', N'兰山区', N'2_147', N'临沂市', N'NULL', 3, N'371302', N'LanShanQu', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1317', N'罗庄区', N'2_147', N'临沂市', N'NULL', 3, N'371311', N'LuoZhuangQu', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1318', N'河东区', N'2_147', N'临沂市', N'NULL', 3, N'371312', N'HeDongQu', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1319', N'沂南县', N'2_147', N'临沂市', N'NULL', 3, N'371321', N'YiNanXian', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_132', N'望都县', N'2_8', N'保定市', N'NULL', 3, N'130631', N'WangDouXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1320', N'郯城县', N'2_147', N'临沂市', N'NULL', 3, N'371322', N'TanChengXian', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1321', N'沂水县', N'2_147', N'临沂市', N'NULL', 3, N'371323', N'YiShuiXian', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1322', N'苍山县', N'2_147', N'临沂市', N'NULL', 3, N'371324', N'CangShanXian', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1323', N'费县', N'2_147', N'临沂市', N'NULL', 3, N'371325', N'FeiXian', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1324', N'平邑县', N'2_147', N'临沂市', N'NULL', 3, N'371326', N'PingYiXian', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1325', N'莒南县', N'2_147', N'临沂市', N'NULL', 3, N'371327', N'JuNanXian', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1326', N'蒙阴县', N'2_147', N'临沂市', N'NULL', 3, N'371328', N'MengYinXian', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1327', N'临沭县', N'2_147', N'临沂市', N'NULL', 3, N'371329', N'LinShuXian', N'LinYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1328', N'德城区', N'2_148', N'德州市', N'NULL', 3, N'371402', N'DeChengQu', N'DeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1329', N'陵县', N'2_148', N'德州市', N'NULL', 3, N'371421', N'LingXian', N'DeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_133', N'安新县', N'2_8', N'保定市', N'NULL', 3, N'130632', N'AnXinXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1330', N'宁津县', N'2_148', N'德州市', N'NULL', 3, N'371422', N'NingJinXian', N'DeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1331', N'庆云县', N'2_148', N'德州市', N'NULL', 3, N'371423', N'QingYunXian', N'DeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1332', N'临邑县', N'2_148', N'德州市', N'NULL', 3, N'371424', N'LinYiXian', N'DeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1333', N'齐河县', N'2_148', N'德州市', N'NULL', 3, N'371425', N'QiHeXian', N'DeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1334', N'平原县', N'2_148', N'德州市', N'NULL', 3, N'371426', N'PingYuanXian', N'DeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1335', N'夏津县', N'2_148', N'德州市', N'NULL', 3, N'371427', N'XiaJinXian', N'DeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1336', N'武城县', N'2_148', N'德州市', N'NULL', 3, N'371428', N'WuChengXian', N'DeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1337', N'乐陵市', N'2_148', N'德州市', N'NULL', 3, N'371481', N'LeLingShi', N'DeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1338', N'禹城市', N'2_148', N'德州市', N'NULL', 3, N'371482', N'YuChengShi', N'DeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1339', N'东昌府区', N'2_149', N'聊城市', N'NULL', 3, N'371502', N'DongChangFuQu', N'LiaoChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_134', N'易县', N'2_8', N'保定市', N'NULL', 3, N'130633', N'YiXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1340', N'阳谷县', N'2_149', N'聊城市', N'NULL', 3, N'371521', N'YangGuXian', N'LiaoChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1341', N'莘县', N'2_149', N'聊城市', N'NULL', 3, N'371522', N'XinXian', N'LiaoChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1342', N'茌平县', N'2_149', N'聊城市', N'NULL', 3, N'371523', N'ChiPingXian', N'LiaoChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1343', N'东阿县', N'2_149', N'聊城市', N'NULL', 3, N'371524', N'DongAXian', N'LiaoChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1344', N'冠县', N'2_149', N'聊城市', N'NULL', 3, N'371525', N'GuanXian', N'LiaoChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1345', N'高唐县', N'2_149', N'聊城市', N'NULL', 3, N'371526', N'GaoTangXian', N'LiaoChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1346', N'临清市', N'2_149', N'聊城市', N'NULL', 3, N'371581', N'LinQingShi', N'LiaoChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1347', N'滨城区', N'2_150', N'滨州市', N'NULL', 3, N'371602', N'BinChengQu', N'BinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1348', N'惠民县', N'2_150', N'滨州市', N'NULL', 3, N'371621', N'HuiMinXian', N'BinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1349', N'阳信县', N'2_150', N'滨州市', N'NULL', 3, N'371622', N'YangXinXian', N'BinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_135', N'曲阳县', N'2_8', N'保定市', N'NULL', 3, N'130634', N'QuYangXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1350', N'无棣县', N'2_150', N'滨州市', N'NULL', 3, N'371623', N'WuDiXian', N'BinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1351', N'沾化县', N'2_150', N'滨州市', N'NULL', 3, N'371624', N'ZhanHuaXian', N'BinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1352', N'博兴县', N'2_150', N'滨州市', N'NULL', 3, N'371625', N'BoXingXian', N'BinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1353', N'邹平县', N'2_150', N'滨州市', N'NULL', 3, N'371626', N'ZouPingXian', N'BinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1354', N'牡丹区', N'2_151', N'菏泽市', N'NULL', 3, N'371702', N'MuDanQu', N'HeZeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1355', N'曹县', N'2_151', N'菏泽市', N'NULL', 3, N'371721', N'CaoXian', N'HeZeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1356', N'单县', N'2_151', N'菏泽市', N'NULL', 3, N'371722', N'DanXian', N'HeZeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1357', N'成武县', N'2_151', N'菏泽市', N'NULL', 3, N'371723', N'ChengWuXian', N'HeZeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1358', N'巨野县', N'2_151', N'菏泽市', N'NULL', 3, N'371724', N'JuYeXian', N'HeZeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1359', N'郓城县', N'2_151', N'菏泽市', N'NULL', 3, N'371725', N'YunChengXian', N'HeZeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_136', N'蠡县', N'2_8', N'保定市', N'NULL', 3, N'130635', N'LiXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1360', N'鄄城县', N'2_151', N'菏泽市', N'NULL', 3, N'371726', N'JuanChengXian', N'HeZeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1361', N'定陶县', N'2_151', N'菏泽市', N'NULL', 3, N'371727', N'DingTaoXian', N'HeZeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1362', N'东明县', N'2_151', N'菏泽市', N'NULL', 3, N'371728', N'DongMingXian', N'HeZeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1363', N'中原区', N'2_152', N'郑州市', N'NULL', 3, N'410102', N'ZhongYuanQu', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1364', N'二七区', N'2_152', N'郑州市', N'NULL', 3, N'410103', N'ErQiQu', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1365', N'管城回族区', N'2_152', N'郑州市', N'NULL', 3, N'410104', N'GuanChengHuiZuQu', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1366', N'金水区', N'2_152', N'郑州市', N'NULL', 3, N'410105', N'JinShuiQu', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1367', N'上街区', N'2_152', N'郑州市', N'NULL', 3, N'410106', N'ShangJieQu', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1368', N'惠济区', N'2_152', N'郑州市', N'NULL', 3, N'410108', N'HuiJiQu', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1369', N'中牟县', N'2_152', N'郑州市', N'NULL', 3, N'410122', N'ZhongMouXian', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_137', N'顺平县', N'2_8', N'保定市', N'NULL', 3, N'130636', N'ShunPingXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1370', N'巩义市', N'2_152', N'郑州市', N'NULL', 3, N'410181', N'GongYiShi', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1371', N'荥阳市', N'2_152', N'郑州市', N'NULL', 3, N'410182', N'YingYangShi', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1372', N'新密市', N'2_152', N'郑州市', N'NULL', 3, N'410183', N'XinMiShi', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1373', N'新郑市', N'2_152', N'郑州市', N'NULL', 3, N'410184', N'XinZhengShi', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1374', N'登封市', N'2_152', N'郑州市', N'NULL', 3, N'410185', N'DengFengShi', N'ZhengZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1375', N'龙亭区', N'2_153', N'开封市', N'NULL', 3, N'410202', N'LongTingQu', N'KaiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1376', N'顺河回族区', N'2_153', N'开封市', N'NULL', 3, N'410203', N'ShunHeHuiZuQu', N'KaiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1377', N'鼓楼区', N'2_153', N'开封市', N'NULL', 3, N'410204', N'GuLouQu', N'KaiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1378', N'金明区', N'2_153', N'开封市', N'NULL', 3, N'410211', N'JinMingQu', N'KaiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1379', N'禹王台区', N'2_153', N'开封市', N'NULL', 3, N'410205', N'YuWangTaiQu', N'KaiFengShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_138', N'博野县', N'2_8', N'保定市', N'NULL', 3, N'130637', N'BoYeXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1380', N'杞县', N'2_153', N'开封市', N'NULL', 3, N'410221', N'QiXian', N'KaiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1381', N'通许县', N'2_153', N'开封市', N'NULL', 3, N'410222', N'TongXuXian', N'KaiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1382', N'尉氏县', N'2_153', N'开封市', N'NULL', 3, N'410223', N'WeiShiXian', N'KaiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1383', N'开封县', N'2_153', N'开封市', N'NULL', 3, N'410224', N'KaiFengXian', N'KaiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1384', N'兰考县', N'2_153', N'开封市', N'NULL', 3, N'410225', N'LanKaoXian', N'KaiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1385', N'老城区', N'2_154', N'洛阳市', N'NULL', 3, N'410302', N'LaoChengQu', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1386', N'西工区', N'2_154', N'洛阳市', N'NULL', 3, N'410303', N'XiGongQu', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1387', N'廛河回族区', N'2_154', N'洛阳市', N'NULL', 3, N'410304', N'ChanHeHuiZuQu', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1388', N'涧西区', N'2_154', N'洛阳市', N'NULL', 3, N'410305', N'JianXiQu', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1389', N'吉利区', N'2_154', N'洛阳市', N'NULL', 3, N'410306', N'JiLiQu', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_139', N'雄县', N'2_8', N'保定市', N'NULL', 3, N'130638', N'XiongXian', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1390', N'洛龙区', N'2_154', N'洛阳市', N'NULL', 3, N'410307', N'LuoLongQu', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1391', N'孟津县', N'2_154', N'洛阳市', N'NULL', 3, N'410322', N'MengJinXian', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1392', N'新安县', N'2_154', N'洛阳市', N'NULL', 3, N'410323', N'XinAnXian', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1393', N'栾川县', N'2_154', N'洛阳市', N'NULL', 3, N'410324', N'LuanChuanXian', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1394', N'嵩县', N'2_154', N'洛阳市', N'NULL', 3, N'410325', N'SongXian', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1395', N'汝阳县', N'2_154', N'洛阳市', N'NULL', 3, N'410326', N'RuYangXian', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1396', N'宜阳县', N'2_154', N'洛阳市', N'NULL', 3, N'410327', N'YiYangXian', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1397', N'洛宁县', N'2_154', N'洛阳市', N'NULL', 3, N'410328', N'LuoNingXian', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1398', N'伊川县', N'2_154', N'洛阳市', N'NULL', 3, N'410329', N'YiChuanXian', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1399', N'偃师市', N'2_154', N'洛阳市', N'NULL', 3, N'410381', N'YanShiShi', N'LuoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_14', N'大兴区', N'2_1', N'北京市', N'NULL', 3, N'110115', N'DaXingQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_140', N'涿州市', N'2_8', N'保定市', N'NULL', 3, N'130681', N'ZhuoZhouShi', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1400', N'新华区', N'2_155', N'平顶山市', N'NULL', 3, N'410402', N'XinHuaQu', N'PingDingShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1401', N'卫东区', N'2_155', N'平顶山市', N'NULL', 3, N'410403', N'WeiDongQu', N'PingDingShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1402', N'石龙区', N'2_155', N'平顶山市', N'NULL', 3, N'410404', N'ShiLongQu', N'PingDingShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1403', N'湛河区', N'2_155', N'平顶山市', N'NULL', 3, N'410411', N'ZhanHeQu', N'PingDingShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1404', N'宝丰县', N'2_155', N'平顶山市', N'NULL', 3, N'410421', N'BaoFengXian', N'PingDingShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1405', N'叶县', N'2_155', N'平顶山市', N'NULL', 3, N'410422', N'YeXian', N'PingDingShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1406', N'鲁山县', N'2_155', N'平顶山市', N'NULL', 3, N'410423', N'LuShanXian', N'PingDingShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1407', N'郏县', N'2_155', N'平顶山市', N'NULL', 3, N'410425', N'JiaXian', N'PingDingShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1408', N'舞钢市', N'2_155', N'平顶山市', N'NULL', 3, N'410481', N'WuGangShi', N'PingDingShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1409', N'汝州市', N'2_155', N'平顶山市', N'NULL', 3, N'410482', N'RuZhouShi', N'PingDingShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_141', N'定州市', N'2_8', N'保定市', N'NULL', 3, N'130682', N'DingZhouShi', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1410', N'文峰区', N'2_156', N'安阳市', N'NULL', 3, N'410502', N'WenFengQu', N'AnYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1411', N'北关区', N'2_156', N'安阳市', N'NULL', 3, N'410503', N'BeiGuanQu', N'AnYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1412', N'殷都区', N'2_156', N'安阳市', N'NULL', 3, N'410505', N'YinDouQu', N'AnYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1413', N'龙安区', N'2_156', N'安阳市', N'NULL', 3, N'410506', N'LongAnQu', N'AnYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1414', N'安阳县', N'2_156', N'安阳市', N'NULL', 3, N'410522', N'AnYangXian', N'AnYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1415', N'汤阴县', N'2_156', N'安阳市', N'NULL', 3, N'410523', N'TangYinXian', N'AnYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1416', N'滑县', N'2_156', N'安阳市', N'NULL', 3, N'410526', N'HuaXian', N'AnYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1417', N'内黄县', N'2_156', N'安阳市', N'NULL', 3, N'410527', N'NaHuangXian', N'AnYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1418', N'林州市', N'2_156', N'安阳市', N'NULL', 3, N'410581', N'LinZhouShi', N'AnYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1419', N'鹤山区', N'2_157', N'鹤壁市', N'NULL', 3, N'410602', N'HeShanQu', N'HeBiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_142', N'安国市', N'2_8', N'保定市', N'NULL', 3, N'130683', N'AnGuoShi', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1420', N'山城区', N'2_157', N'鹤壁市', N'NULL', 3, N'410603', N'ShanChengQu', N'HeBiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1421', N'淇滨区', N'2_157', N'鹤壁市', N'NULL', 3, N'410611', N'QiBinQu', N'HeBiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1422', N'浚县', N'2_157', N'鹤壁市', N'NULL', 3, N'410621', N'JunXian', N'HeBiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1423', N'淇县', N'2_157', N'鹤壁市', N'NULL', 3, N'410622', N'QiXian', N'HeBiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1424', N'红旗区', N'2_158', N'新乡市', N'NULL', 3, N'410702', N'HongQiQu', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1425', N'卫滨区', N'2_158', N'新乡市', N'NULL', 3, N'410703', N'WeiBinQu', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1426', N'凤泉区', N'2_158', N'新乡市', N'NULL', 3, N'410704', N'FengQuanQu', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1427', N'牧野区', N'2_158', N'新乡市', N'NULL', 3, N'410711', N'MuYeQu', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1428', N'新乡县', N'2_158', N'新乡市', N'NULL', 3, N'410721', N'XinXiangXian', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1429', N'获嘉县', N'2_158', N'新乡市', N'NULL', 3, N'410724', N'HuoJiaXian', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_143', N'高碑店市', N'2_8', N'保定市', N'NULL', 3, N'130684', N'GaoBeiDianShi', N'BaoDingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1430', N'原阳县', N'2_158', N'新乡市', N'NULL', 3, N'410725', N'YuanYangXian', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1431', N'延津县', N'2_158', N'新乡市', N'NULL', 3, N'410726', N'YanJinXian', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1432', N'封丘县', N'2_158', N'新乡市', N'NULL', 3, N'410727', N'FengQiuXian', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1433', N'长垣县', N'2_158', N'新乡市', N'NULL', 3, N'410728', N'ChangYuanXian', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1434', N'卫辉市', N'2_158', N'新乡市', N'NULL', 3, N'410781', N'WeiHuiShi', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1435', N'辉县市', N'2_158', N'新乡市', N'NULL', 3, N'410782', N'HuiXianShi', N'XinXiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1436', N'解放区', N'2_159', N'焦作市', N'NULL', 3, N'410802', N'JieFangQu', N'JiaoZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1437', N'中站区', N'2_159', N'焦作市', N'NULL', 3, N'410803', N'ZhongZhanQu', N'JiaoZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1438', N'马村区', N'2_159', N'焦作市', N'NULL', 3, N'410804', N'MaCunQu', N'JiaoZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1439', N'山阳区', N'2_159', N'焦作市', N'NULL', 3, N'410811', N'ShanYangQu', N'JiaoZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_144', N'桥东区', N'2_9', N'张家口市', N'NULL', 3, N'130702', N'QiaoDongQu', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1440', N'修武县', N'2_159', N'焦作市', N'NULL', 3, N'410821', N'XiuWuXian', N'JiaoZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1441', N'博爱县', N'2_159', N'焦作市', N'NULL', 3, N'410822', N'BoAiXian', N'JiaoZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1442', N'武陟县', N'2_159', N'焦作市', N'NULL', 3, N'410823', N'WuZhiXian', N'JiaoZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1443', N'温县', N'2_159', N'焦作市', N'NULL', 3, N'410825', N'WenXian', N'JiaoZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1444', N'济源市', N'2_159', N'焦作市', N'NULL', 3, N'410881', N'JiYuanShi', N'JiaoZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1445', N'沁阳市', N'2_159', N'焦作市', N'NULL', 3, N'410882', N'QinYangShi', N'JiaoZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1446', N'孟州市', N'2_159', N'焦作市', N'NULL', 3, N'410883', N'MengZhouShi', N'JiaoZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1447', N'华龙区', N'2_160', N'濮阳市', N'NULL', 3, N'410902', N'HuaLongQu', N'PuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1448', N'清丰县', N'2_160', N'濮阳市', N'NULL', 3, N'410922', N'QingFengXian', N'PuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1449', N'南乐县', N'2_160', N'濮阳市', N'NULL', 3, N'410923', N'NanLeXian', N'PuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_145', N'桥西区', N'2_9', N'张家口市', N'NULL', 3, N'130703', N'QiaoXiQu', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1450', N'范县', N'2_160', N'濮阳市', N'NULL', 3, N'410926', N'FanXian', N'PuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1451', N'台前县', N'2_160', N'濮阳市', N'NULL', 3, N'410927', N'TaiQianXian', N'PuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1452', N'濮阳县', N'2_160', N'濮阳市', N'NULL', 3, N'410928', N'PuYangXian', N'PuYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1453', N'魏都区', N'2_161', N'许昌市', N'NULL', 3, N'411002', N'WeiDouQu', N'XuChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1454', N'许昌县', N'2_161', N'许昌市', N'NULL', 3, N'411023', N'XuChangXian', N'XuChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1455', N'鄢陵县', N'2_161', N'许昌市', N'NULL', 3, N'411024', N'YanLingXian', N'XuChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1456', N'襄城县', N'2_161', N'许昌市', N'NULL', 3, N'411025', N'XiangChengXian', N'XuChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1457', N'禹州市', N'2_161', N'许昌市', N'NULL', 3, N'411081', N'YuZhouShi', N'XuChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1458', N'长葛市', N'2_161', N'许昌市', N'NULL', 3, N'411082', N'ChangGeShi', N'XuChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1459', N'源汇区', N'2_162', N'漯河市', N'NULL', 3, N'411102', N'YuanHuiQu', N'LuoHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_146', N'宣化区', N'2_9', N'张家口市', N'NULL', 3, N'130705', N'XuanHuaQu', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1460', N'郾城区', N'2_162', N'漯河市', N'NULL', 3, N'411103', N'YanChengQu', N'LuoHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1461', N'召陵区', N'2_162', N'漯河市', N'NULL', 3, N'411104', N'ZhaoLingQu', N'LuoHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1462', N'舞阳县', N'2_162', N'漯河市', N'NULL', 3, N'411121', N'WuYangXian', N'LuoHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1463', N'临颍县', N'2_162', N'漯河市', N'NULL', 3, N'411122', N'LinYingXian', N'LuoHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1465', N'湖滨区', N'2_163', N'三门峡市', N'NULL', 3, N'411202', N'HuBinQu', N'SanMenXiaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1466', N'渑池县', N'2_163', N'三门峡市', N'NULL', 3, N'411221', N'ShengChiXian', N'SanMenXiaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1467', N'陕县', N'2_163', N'三门峡市', N'NULL', 3, N'411222', N'ShanXian', N'SanMenXiaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1468', N'卢氏县', N'2_163', N'三门峡市', N'NULL', 3, N'411224', N'LuShiXian', N'SanMenXiaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1469', N'义马市', N'2_163', N'三门峡市', N'NULL', 3, N'411281', N'YiMaShi', N'SanMenXiaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_147', N'下花园区', N'2_9', N'张家口市', N'NULL', 3, N'130706', N'XiaHuaYuanQu', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1470', N'灵宝市', N'2_163', N'三门峡市', N'NULL', 3, N'411282', N'LingBaoShi', N'SanMenXiaShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1471', N'宛城区', N'2_164', N'南阳市', N'NULL', 3, N'411302', N'WanChengQu', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1472', N'卧龙区', N'2_164', N'南阳市', N'NULL', 3, N'411303', N'WoLongQu', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1473', N'南召县', N'2_164', N'南阳市', N'NULL', 3, N'411321', N'NanZhaoXian', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1474', N'方城县', N'2_164', N'南阳市', N'NULL', 3, N'411322', N'FangChengXian', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1475', N'西峡县', N'2_164', N'南阳市', N'NULL', 3, N'411323', N'XiXiaXian', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1476', N'镇平县', N'2_164', N'南阳市', N'NULL', 3, N'411324', N'ZhenPingXian', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1477', N'内乡县', N'2_164', N'南阳市', N'NULL', 3, N'411325', N'NaXiangXian', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1478', N'淅川县', N'2_164', N'南阳市', N'NULL', 3, N'411326', N'XiChuanXian', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1479', N'社旗县', N'2_164', N'南阳市', N'NULL', 3, N'411327', N'SheQiXian', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_148', N'宣化县', N'2_9', N'张家口市', N'NULL', 3, N'130721', N'XuanHuaXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1480', N'唐河县', N'2_164', N'南阳市', N'NULL', 3, N'411328', N'TangHeXian', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1481', N'新野县', N'2_164', N'南阳市', N'NULL', 3, N'411329', N'XinYeXian', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1482', N'桐柏县', N'2_164', N'南阳市', N'NULL', 3, N'411330', N'TongBaiXian', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1483', N'邓州市', N'2_164', N'南阳市', N'NULL', 3, N'411381', N'DengZhouShi', N'NanYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1484', N'梁园区', N'2_165', N'商丘市', N'NULL', 3, N'411402', N'LiangYuanQu', N'ShangQiuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1485', N'睢阳区', N'2_165', N'商丘市', N'NULL', 3, N'411403', N'SuiYangQu', N'ShangQiuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1486', N'民权县', N'2_165', N'商丘市', N'NULL', 3, N'411421', N'MinQuanXian', N'ShangQiuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1487', N'睢县', N'2_165', N'商丘市', N'NULL', 3, N'411422', N'SuiXian', N'ShangQiuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1488', N'宁陵县', N'2_165', N'商丘市', N'NULL', 3, N'411423', N'NingLingXian', N'ShangQiuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1489', N'柘城县', N'2_165', N'商丘市', N'NULL', 3, N'411424', N'ZheChengXian', N'ShangQiuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_149', N'张北县', N'2_9', N'张家口市', N'NULL', 3, N'130722', N'ZhangBeiXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1490', N'虞城县', N'2_165', N'商丘市', N'NULL', 3, N'411425', N'YuChengXian', N'ShangQiuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1491', N'夏邑县', N'2_165', N'商丘市', N'NULL', 3, N'411426', N'XiaYiXian', N'ShangQiuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1492', N'永城市', N'2_165', N'商丘市', N'NULL', 3, N'411481', N'YongChengShi', N'ShangQiuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1493', N'浉河区', N'2_166', N'信阳市', N'NULL', 3, N'411502', N'ShiHeQu', N'XinYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1494', N'平桥区', N'2_166', N'信阳市', N'NULL', 3, N'411503', N'PingQiaoQu', N'XinYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1495', N'罗山县', N'2_166', N'信阳市', N'NULL', 3, N'411521', N'LuoShanXian', N'XinYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1496', N'光山县', N'2_166', N'信阳市', N'NULL', 3, N'411522', N'GuangShanXian', N'XinYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1497', N'新县', N'2_166', N'信阳市', N'NULL', 3, N'411523', N'XinXian', N'XinYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1498', N'商城县', N'2_166', N'信阳市', N'NULL', 3, N'411524', N'ShangChengXian', N'XinYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1499', N'固始县', N'2_166', N'信阳市', N'NULL', 3, N'411525', N'GuShiXian', N'XinYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_15', N'怀柔区', N'2_1', N'北京市', N'NULL', 3, N'110116', N'HuaiRouQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_150', N'康保县', N'2_9', N'张家口市', N'NULL', 3, N'130723', N'KangBaoXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1500', N'潢川县', N'2_166', N'信阳市', N'NULL', 3, N'411526', N'HuangChuanXian', N'XinYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1501', N'淮滨县', N'2_166', N'信阳市', N'NULL', 3, N'411527', N'HuaiBinXian', N'XinYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1502', N'息县', N'2_166', N'信阳市', N'NULL', 3, N'411528', N'XiXian', N'XinYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1503', N'川汇区', N'2_167', N'周口市', N'NULL', 3, N'411602', N'ChuanHuiQu', N'ZhouKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1504', N'扶沟县', N'2_167', N'周口市', N'NULL', 3, N'411621', N'FuGouXian', N'ZhouKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1505', N'西华县', N'2_167', N'周口市', N'NULL', 3, N'411622', N'XiHuaXian', N'ZhouKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1506', N'商水县', N'2_167', N'周口市', N'NULL', 3, N'411623', N'ShangShuiXian', N'ZhouKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1507', N'沈丘县', N'2_167', N'周口市', N'NULL', 3, N'411624', N'ShenQiuXian', N'ZhouKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1508', N'郸城县', N'2_167', N'周口市', N'NULL', 3, N'411625', N'DanChengXian', N'ZhouKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1509', N'淮阳县', N'2_167', N'周口市', N'NULL', 3, N'411626', N'HuaiYangXian', N'ZhouKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_151', N'沽源县', N'2_9', N'张家口市', N'NULL', 3, N'130724', N'GuYuanXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1510', N'太康县', N'2_167', N'周口市', N'NULL', 3, N'411627', N'TaiKangXian', N'ZhouKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1511', N'鹿邑县', N'2_167', N'周口市', N'NULL', 3, N'411628', N'LuYiXian', N'ZhouKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1512', N'项城市', N'2_167', N'周口市', N'NULL', 3, N'411681', N'XiangChengShi', N'ZhouKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1513', N'驿城区', N'2_168', N'驻马店市', N'NULL', 3, N'411702', N'YiChengQu', N'ZhuMaDianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1514', N'西平县', N'2_168', N'驻马店市', N'NULL', 3, N'411721', N'XiPingXian', N'ZhuMaDianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1515', N'上蔡县', N'2_168', N'驻马店市', N'NULL', 3, N'411722', N'ShangCaiXian', N'ZhuMaDianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1516', N'平舆县', N'2_168', N'驻马店市', N'NULL', 3, N'411723', N'PingYuXian', N'ZhuMaDianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1517', N'正阳县', N'2_168', N'驻马店市', N'NULL', 3, N'411724', N'ZhengYangXian', N'ZhuMaDianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1518', N'确山县', N'2_168', N'驻马店市', N'NULL', 3, N'411725', N'QueShanXian', N'ZhuMaDianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1519', N'泌阳县', N'2_168', N'驻马店市', N'NULL', 3, N'411726', N'MiYangXian', N'ZhuMaDianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_152', N'尚义县', N'2_9', N'张家口市', N'NULL', 3, N'130725', N'ShangYiXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1520', N'汝南县', N'2_168', N'驻马店市', N'NULL', 3, N'411727', N'RuNanXian', N'ZhuMaDianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1521', N'遂平县', N'2_168', N'驻马店市', N'NULL', 3, N'411728', N'SuiPingXian', N'ZhuMaDianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1522', N'新蔡县', N'2_168', N'驻马店市', N'NULL', 3, N'411729', N'XinCaiXian', N'ZhuMaDianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1523', N'江岸区', N'2_169', N'武汉市', N'NULL', 3, N'420102', N'JiangAnQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1524', N'江汉区', N'2_169', N'武汉市', N'NULL', 3, N'420103', N'JiangHanQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1525', N'硚口区', N'2_169', N'武汉市', N'NULL', 3, N'420104', N'QiaoKouQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1526', N'汉阳区', N'2_169', N'武汉市', N'NULL', 3, N'420105', N'HanYangQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1527', N'武昌区', N'2_169', N'武汉市', N'NULL', 3, N'420106', N'WuChangQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1528', N'青山区', N'2_169', N'武汉市', N'NULL', 3, N'420107', N'QingShanQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1529', N'洪山区', N'2_169', N'武汉市', N'NULL', 3, N'420111', N'HongShanQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_153', N'蔚县', N'2_9', N'张家口市', N'NULL', 3, N'130726', N'WeiXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1530', N'东西湖区', N'2_169', N'武汉市', N'NULL', 3, N'420112', N'DongXiHuQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1531', N'汉南区', N'2_169', N'武汉市', N'NULL', 3, N'420113', N'HanNanQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1532', N'蔡甸区', N'2_169', N'武汉市', N'NULL', 3, N'420114', N'CaiDianQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1533', N'江夏区', N'2_169', N'武汉市', N'NULL', 3, N'420115', N'JiangXiaQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1534', N'黄陂区', N'2_169', N'武汉市', N'NULL', 3, N'420116', N'HuangBeiQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1535', N'新洲区', N'2_169', N'武汉市', N'NULL', 3, N'420117', N'XinZhouQu', N'WuHanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1536', N'黄石港区', N'2_170', N'黄石市', N'NULL', 3, N'420202', N'HuangShiGangQu', N'HuangShiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1537', N'西塞山区', N'2_170', N'黄石市', N'NULL', 3, N'420203', N'XiSaiShanQu', N'HuangShiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1538', N'下陆区', N'2_170', N'黄石市', N'NULL', 3, N'420204', N'XiaLuQu', N'HuangShiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1539', N'铁山区', N'2_170', N'黄石市', N'NULL', 3, N'420205', N'TieShanQu', N'HuangShiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_154', N'阳原县', N'2_9', N'张家口市', N'NULL', 3, N'130727', N'YangYuanXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1540', N'阳新县', N'2_170', N'黄石市', N'NULL', 3, N'420222', N'YangXinXian', N'HuangShiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1541', N'大冶市', N'2_170', N'黄石市', N'NULL', 3, N'420281', N'DaYeShi', N'HuangShiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1542', N'茅箭区', N'2_171', N'十堰市', N'NULL', 3, N'420302', N'MaoJianQu', N'ShiYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1543', N'张湾区', N'2_171', N'十堰市', N'NULL', 3, N'420303', N'ZhangWanQu', N'ShiYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1544', N'郧县', N'2_171', N'十堰市', N'NULL', 3, N'420321', N'YunXian', N'ShiYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1545', N'郧西县', N'2_171', N'十堰市', N'NULL', 3, N'420322', N'YunXiXian', N'ShiYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1546', N'竹山县', N'2_171', N'十堰市', N'NULL', 3, N'420323', N'ZhuShanXian', N'ShiYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1547', N'竹溪县', N'2_171', N'十堰市', N'NULL', 3, N'420324', N'ZhuXiXian', N'ShiYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1548', N'房县', N'2_171', N'十堰市', N'NULL', 3, N'420325', N'FangXian', N'ShiYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1549', N'丹江口市', N'2_171', N'十堰市', N'NULL', 3, N'420381', N'DanJiangKouShi', N'ShiYanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_155', N'怀安县', N'2_9', N'张家口市', N'NULL', 3, N'130728', N'HuaiAnXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1550', N'西陵区', N'2_172', N'宜昌市', N'NULL', 3, N'420502', N'XiLingQu', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1551', N'伍家岗区', N'2_172', N'宜昌市', N'NULL', 3, N'420503', N'WuJiaGangQu', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1552', N'点军区', N'2_172', N'宜昌市', N'NULL', 3, N'420504', N'DianJunQu', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1553', N'猇亭区', N'2_172', N'宜昌市', N'NULL', 3, N'420505', N'XiaoTingQu', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1554', N'夷陵区', N'2_172', N'宜昌市', N'NULL', 3, N'420506', N'YiLingQu', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1555', N'远安县', N'2_172', N'宜昌市', N'NULL', 3, N'420525', N'YuanAnXian', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1556', N'兴山县', N'2_172', N'宜昌市', N'NULL', 3, N'420526', N'XingShanXian', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1557', N'秭归县', N'2_172', N'宜昌市', N'NULL', 3, N'420527', N'ZiGuiXian', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1558', N'长阳土家族自治县', N'2_172', N'宜昌市', N'NULL', 3, N'420528', N'ChangYangTuJiaZuZiZhiXian', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1559', N'五峰土家族自治县', N'2_172', N'宜昌市', N'NULL', 3, N'420529', N'WuFengTuJiaZuZiZhiXian', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_156', N'万全县', N'2_9', N'张家口市', N'NULL', 3, N'130729', N'WanQuanXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1560', N'宜都市', N'2_172', N'宜昌市', N'NULL', 3, N'420581', N'YiDouShi', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1561', N'当阳市', N'2_172', N'宜昌市', N'NULL', 3, N'420582', N'DangYangShi', N'YiChangShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1562', N'枝江市', N'2_172', N'宜昌市', N'NULL', 3, N'420583', N'ZhiJiangShi', N'YiChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1563', N'襄城区', N'2_173', N'襄樊市', N'NULL', 3, N'420602', N'XiangChengQu', N'XiangFanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1564', N'樊城区', N'2_173', N'襄樊市', N'NULL', 3, N'420606', N'FanChengQu', N'XiangFanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1565', N'襄阳区', N'2_173', N'襄樊市', N'NULL', 3, N'420607', N'XiangYangQu', N'XiangFanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1566', N'南漳县', N'2_173', N'襄樊市', N'NULL', 3, N'420624', N'NanZhangXian', N'XiangFanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1567', N'谷城县', N'2_173', N'襄樊市', N'NULL', 3, N'420625', N'GuChengXian', N'XiangFanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1568', N'保康县', N'2_173', N'襄樊市', N'NULL', 3, N'420626', N'BaoKangXian', N'XiangFanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1569', N'老河口市', N'2_173', N'襄樊市', N'NULL', 3, N'420682', N'LaoHeKouShi', N'XiangFanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_157', N'怀来县', N'2_9', N'张家口市', N'NULL', 3, N'130730', N'HuaiLaiXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1570', N'枣阳市', N'2_173', N'襄樊市', N'NULL', 3, N'420683', N'ZaoYangShi', N'XiangFanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1571', N'宜城市', N'2_173', N'襄樊市', N'NULL', 3, N'420684', N'YiChengShi', N'XiangFanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1572', N'梁子湖区', N'2_174', N'鄂州市', N'NULL', 3, N'420702', N'LiangZiHuQu', N'EZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1573', N'华容区', N'2_174', N'鄂州市', N'NULL', 3, N'420703', N'HuaRongQu', N'EZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1574', N'鄂城区', N'2_174', N'鄂州市', N'NULL', 3, N'420704', N'EChengQu', N'EZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1575', N'东宝区', N'2_175', N'荆门市', N'NULL', 3, N'420802', N'DongBaoQu', N'JingMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1576', N'掇刀区', N'2_175', N'荆门市', N'NULL', 3, N'420804', N'DuoDaoQu', N'JingMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1577', N'京山县', N'2_175', N'荆门市', N'NULL', 3, N'420821', N'JingShanXian', N'JingMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1578', N'沙洋县', N'2_175', N'荆门市', N'NULL', 3, N'420822', N'ShaYangXian', N'JingMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1579', N'钟祥市', N'2_175', N'荆门市', N'NULL', 3, N'420881', N'ZhongXiangShi', N'JingMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_158', N'涿鹿县', N'2_9', N'张家口市', N'NULL', 3, N'130731', N'ZhuoLuXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1580', N'孝南区', N'2_176', N'孝感市', N'NULL', 3, N'420902', N'XiaoNanQu', N'XiaoGanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1581', N'孝昌县', N'2_176', N'孝感市', N'NULL', 3, N'420921', N'XiaoChangXian', N'XiaoGanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1582', N'大悟县', N'2_176', N'孝感市', N'NULL', 3, N'420922', N'DaWuXian', N'XiaoGanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1583', N'云梦县', N'2_176', N'孝感市', N'NULL', 3, N'420923', N'YunMengXian', N'XiaoGanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1584', N'应城市', N'2_176', N'孝感市', N'NULL', 3, N'420981', N'YingChengShi', N'XiaoGanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1585', N'安陆市', N'2_176', N'孝感市', N'NULL', 3, N'420982', N'AnLuShi', N'XiaoGanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1586', N'汉川市', N'2_176', N'孝感市', N'NULL', 3, N'420984', N'HanChuanShi', N'XiaoGanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1587', N'沙市区', N'2_177', N'荆州市', N'NULL', 3, N'421002', N'ShaShiQu', N'JingZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1588', N'荆州区', N'2_177', N'荆州市', N'NULL', 3, N'421003', N'JingZhouQu', N'JingZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1589', N'公安县', N'2_177', N'荆州市', N'NULL', 3, N'421022', N'GongAnXian', N'JingZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_159', N'赤城县', N'2_9', N'张家口市', N'NULL', 3, N'130732', N'ChiChengXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1590', N'监利县', N'2_177', N'荆州市', N'NULL', 3, N'421023', N'JianLiXian', N'JingZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1591', N'江陵县', N'2_177', N'荆州市', N'NULL', 3, N'421024', N'JiangLingXian', N'JingZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1592', N'石首市', N'2_177', N'荆州市', N'NULL', 3, N'421081', N'ShiShouShi', N'JingZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1593', N'洪湖市', N'2_177', N'荆州市', N'NULL', 3, N'421083', N'HongHuShi', N'JingZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1594', N'松滋市', N'2_177', N'荆州市', N'NULL', 3, N'421087', N'SongZiShi', N'JingZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1595', N'黄州区', N'2_178', N'黄冈市', N'NULL', 3, N'421102', N'HuangZhouQu', N'HuangGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1596', N'团风县', N'2_178', N'黄冈市', N'NULL', 3, N'421121', N'TuanFengXian', N'HuangGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1597', N'红安县', N'2_178', N'黄冈市', N'NULL', 3, N'421122', N'HongAnXian', N'HuangGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1598', N'罗田县', N'2_178', N'黄冈市', N'NULL', 3, N'421123', N'LuoTianXian', N'HuangGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1599', N'英山县', N'2_178', N'黄冈市', N'NULL', 3, N'421124', N'YingShanXian', N'HuangGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_16', N'平谷区', N'2_1', N'北京市', N'NULL', 3, N'110117', N'PingGuQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_160', N'崇礼县', N'2_9', N'张家口市', N'NULL', 3, N'130733', N'ChongLiXian', N'ZhangJiaKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1600', N'浠水县', N'2_178', N'黄冈市', N'NULL', 3, N'421125', N'XiShuiXian', N'HuangGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1601', N'蕲春县', N'2_178', N'黄冈市', N'NULL', 3, N'421126', N'QiChunXian', N'HuangGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1602', N'黄梅县', N'2_178', N'黄冈市', N'NULL', 3, N'421127', N'HuangMeiXian', N'HuangGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1603', N'麻城市', N'2_178', N'黄冈市', N'NULL', 3, N'421181', N'MaChengShi', N'HuangGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1604', N'武穴市', N'2_178', N'黄冈市', N'NULL', 3, N'421182', N'WuXueShi', N'HuangGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1605', N'咸安区', N'2_179', N'咸宁市', N'NULL', 3, N'421202', N'XianAnQu', N'XianNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1606', N'嘉鱼县', N'2_179', N'咸宁市', N'NULL', 3, N'421221', N'JiaYuXian', N'XianNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1607', N'通城县', N'2_179', N'咸宁市', N'NULL', 3, N'421222', N'TongChengXian', N'XianNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1608', N'崇阳县', N'2_179', N'咸宁市', N'NULL', 3, N'421223', N'ChongYangXian', N'XianNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1609', N'通山县', N'2_179', N'咸宁市', N'NULL', 3, N'421224', N'TongShanXian', N'XianNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_161', N'双桥区', N'2_10', N'承德市', N'NULL', 3, N'130802', N'ShuangQiaoQu', N'ChengDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1610', N'赤壁市', N'2_179', N'咸宁市', N'NULL', 3, N'421281', N'ChiBiShi', N'XianNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1611', N'曾都区', N'2_180', N'随州市', N'NULL', 3, N'421302', N'ZengDouQu', N'SuiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1612', N'广水市', N'2_180', N'随州市', N'NULL', 3, N'421381', N'GuangShuiShi', N'SuiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1613', N'恩施市', N'2_181', N'恩施土家族苗族自治州', N'NULL', 3, N'422801', N'EnShiShi', N'EnShiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1614', N'利川市', N'2_181', N'恩施土家族苗族自治州', N'NULL', 3, N'422802', N'LiChuanShi', N'EnShiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1615', N'建始县', N'2_181', N'恩施土家族苗族自治州', N'NULL', 3, N'422822', N'JianShiXian', N'EnShiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1616', N'巴东县', N'2_181', N'恩施土家族苗族自治州', N'NULL', 3, N'422823', N'BaDongXian', N'EnShiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1617', N'宣恩县', N'2_181', N'恩施土家族苗族自治州', N'NULL', 3, N'422825', N'XuanEnXian', N'EnShiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1618', N'咸丰县', N'2_181', N'恩施土家族苗族自治州', N'NULL', 3, N'422826', N'XianFengXian', N'EnShiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1619', N'来凤县', N'2_181', N'恩施土家族苗族自治州', N'NULL', 3, N'422827', N'LaiFengXian', N'EnShiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_162', N'双滦区', N'2_10', N'承德市', N'NULL', 3, N'130803', N'ShuangLuanQu', N'ChengDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1620', N'鹤峰县', N'2_181', N'恩施土家族苗族自治州', N'NULL', 3, N'422828', N'HeFengXian', N'EnShiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1621', N'仙桃市', N'2_182', N'神农架', N'NULL', 3, N'429004', N'XianTaoShi', N'ShenNongJia')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1622', N'潜江市', N'2_182', N'神农架', N'NULL', 3, N'429005', N'QianJiangShi', N'ShenNongJia')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1623', N'天门市', N'2_182', N'神农架', N'NULL', 3, N'429006', N'TianMenShi', N'ShenNongJia')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1624', N'神农架林区', N'2_182', N'神农架', N'NULL', 3, N'429021', N'ShenNongJiaLinQu', N'ShenNongJia')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1625', N'芙蓉区', N'2_183', N'长沙市', N'NULL', 3, N'430102', N'FuRongQu', N'ChangShaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1626', N'天心区', N'2_183', N'长沙市', N'NULL', 3, N'430103', N'TianXinQu', N'ChangShaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1627', N'岳麓区', N'2_183', N'长沙市', N'NULL', 3, N'430104', N'YueLuQu', N'ChangShaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1628', N'开福区', N'2_183', N'长沙市', N'NULL', 3, N'430105', N'KaiFuQu', N'ChangShaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1629', N'雨花区', N'2_183', N'长沙市', N'NULL', 3, N'430111', N'YuHuaQu', N'ChangShaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_163', N'鹰手营子矿区', N'2_10', N'承德市', N'NULL', 3, N'130804', N'YingShouYingZiKuangQu', N'ChengDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1630', N'长沙县', N'2_183', N'长沙市', N'NULL', 3, N'430121', N'ChangShaXian', N'ChangShaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1631', N'望城县', N'2_183', N'长沙市', N'NULL', 3, N'430122', N'WangChengXian', N'ChangShaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1632', N'宁乡县', N'2_183', N'长沙市', N'NULL', 3, N'430124', N'NingXiangXian', N'ChangShaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1633', N'浏阳市', N'2_183', N'长沙市', N'NULL', 3, N'430181', N'LiuYangShi', N'ChangShaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1634', N'荷塘区', N'2_184', N'株洲市', N'NULL', 3, N'430202', N'HeTangQu', N'ZhuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1635', N'芦淞区', N'2_184', N'株洲市', N'NULL', 3, N'430203', N'LuSongQu', N'ZhuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1636', N'石峰区', N'2_184', N'株洲市', N'NULL', 3, N'430204', N'ShiFengQu', N'ZhuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1637', N'天元区', N'2_184', N'株洲市', N'NULL', 3, N'430211', N'TianYuanQu', N'ZhuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1638', N'株洲县', N'2_184', N'株洲市', N'NULL', 3, N'430221', N'ZhuZhouXian', N'ZhuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1639', N'攸县', N'2_184', N'株洲市', N'NULL', 3, N'430223', N'YouXian', N'ZhuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_164', N'承德县', N'2_10', N'承德市', N'NULL', 3, N'130821', N'ChengDeXian', N'ChengDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1640', N'茶陵县', N'2_184', N'株洲市', N'NULL', 3, N'430224', N'ChaLingXian', N'ZhuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1641', N'炎陵县', N'2_184', N'株洲市', N'NULL', 3, N'430225', N'YanLingXian', N'ZhuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1642', N'醴陵市', N'2_184', N'株洲市', N'NULL', 3, N'430281', N'LiLingShi', N'ZhuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1643', N'雨湖区', N'2_185', N'湘潭市', N'NULL', 3, N'430302', N'YuHuQu', N'XiangTanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1644', N'岳塘区', N'2_185', N'湘潭市', N'NULL', 3, N'430304', N'YueTangQu', N'XiangTanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1645', N'湘潭县', N'2_185', N'湘潭市', N'NULL', 3, N'430321', N'XiangTanXian', N'XiangTanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1646', N'湘乡市', N'2_185', N'湘潭市', N'NULL', 3, N'430381', N'XiangXiangShi', N'XiangTanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1647', N'韶山市', N'2_185', N'湘潭市', N'NULL', 3, N'430382', N'ShaoShanShi', N'XiangTanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1648', N'珠晖区', N'2_186', N'衡阳市', N'NULL', 3, N'430405', N'ZhuHuiQu', N'HengYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1649', N'雁峰区', N'2_186', N'衡阳市', N'NULL', 3, N'430406', N'YanFengQu', N'HengYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_165', N'兴隆县', N'2_10', N'承德市', N'NULL', 3, N'130822', N'XingLongXian', N'ChengDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1650', N'石鼓区', N'2_186', N'衡阳市', N'NULL', 3, N'430407', N'ShiGuQu', N'HengYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1651', N'蒸湘区', N'2_186', N'衡阳市', N'NULL', 3, N'430408', N'ZhengXiangQu', N'HengYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1652', N'南岳区', N'2_186', N'衡阳市', N'NULL', 3, N'430412', N'NanYueQu', N'HengYangShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1653', N'衡阳县', N'2_186', N'衡阳市', N'NULL', 3, N'430421', N'HengYangXian', N'HengYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1654', N'衡南县', N'2_186', N'衡阳市', N'NULL', 3, N'430422', N'HengNanXian', N'HengYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1655', N'衡山县', N'2_186', N'衡阳市', N'NULL', 3, N'430423', N'HengShanXian', N'HengYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1656', N'衡东县', N'2_186', N'衡阳市', N'NULL', 3, N'430424', N'HengDongXian', N'HengYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1657', N'祁东县', N'2_186', N'衡阳市', N'NULL', 3, N'430426', N'QiDongXian', N'HengYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1658', N'耒阳市', N'2_186', N'衡阳市', N'NULL', 3, N'430481', N'LeiYangShi', N'HengYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1659', N'常宁市', N'2_186', N'衡阳市', N'NULL', 3, N'430482', N'ChangNingShi', N'HengYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_166', N'平泉县', N'2_10', N'承德市', N'NULL', 3, N'130823', N'PingQuanXian', N'ChengDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1660', N'双清区', N'2_187', N'邵阳市', N'NULL', 3, N'430502', N'ShuangQingQu', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1661', N'大祥区', N'2_187', N'邵阳市', N'NULL', 3, N'430503', N'DaXiangQu', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1662', N'北塔区', N'2_187', N'邵阳市', N'NULL', 3, N'430511', N'BeiTaQu', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1663', N'邵东县', N'2_187', N'邵阳市', N'NULL', 3, N'430521', N'ShaoDongXian', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1664', N'新邵县', N'2_187', N'邵阳市', N'NULL', 3, N'430522', N'XinShaoXian', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1665', N'邵阳县', N'2_187', N'邵阳市', N'NULL', 3, N'430523', N'ShaoYangXian', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1666', N'隆回县', N'2_187', N'邵阳市', N'NULL', 3, N'430524', N'LongHuiXian', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1667', N'洞口县', N'2_187', N'邵阳市', N'NULL', 3, N'430525', N'DongKouXian', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1668', N'绥宁县', N'2_187', N'邵阳市', N'NULL', 3, N'430527', N'SuiNingXian', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1669', N'新宁县', N'2_187', N'邵阳市', N'NULL', 3, N'430528', N'XinNingXian', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_167', N'滦平县', N'2_10', N'承德市', N'NULL', 3, N'130824', N'LuanPingXian', N'ChengDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1670', N'城步苗族自治县', N'2_187', N'邵阳市', N'NULL', 3, N'430529', N'ChengBuMiaoZuZiZhiXian', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1671', N'武冈市', N'2_187', N'邵阳市', N'NULL', 3, N'430581', N'WuGangShi', N'ShaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1672', N'岳阳楼区', N'2_188', N'岳阳市', N'NULL', 3, N'430602', N'YueYangLouQu', N'YueYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1673', N'云溪区', N'2_188', N'岳阳市', N'NULL', 3, N'430603', N'YunXiQu', N'YueYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1674', N'君山区', N'2_188', N'岳阳市', N'NULL', 3, N'430611', N'JunShanQu', N'YueYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1675', N'岳阳县', N'2_188', N'岳阳市', N'NULL', 3, N'430621', N'YueYangXian', N'YueYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1676', N'华容县', N'2_188', N'岳阳市', N'NULL', 3, N'430623', N'HuaRongXian', N'YueYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1677', N'湘阴县', N'2_188', N'岳阳市', N'NULL', 3, N'430624', N'XiangYinXian', N'YueYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1678', N'平江县', N'2_188', N'岳阳市', N'NULL', 3, N'430626', N'PingJiangXian', N'YueYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1679', N'汨罗市', N'2_188', N'岳阳市', N'NULL', 3, N'430681', N'MiLuoShi', N'YueYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_168', N'隆化县', N'2_10', N'承德市', N'NULL', 3, N'130825', N'LongHuaXian', N'ChengDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1680', N'临湘市', N'2_188', N'岳阳市', N'NULL', 3, N'430682', N'LinXiangShi', N'YueYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1681', N'武陵区', N'2_189', N'常德市', N'NULL', 3, N'430702', N'WuLingQu', N'ChangDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1682', N'鼎城区', N'2_189', N'常德市', N'NULL', 3, N'430703', N'DingChengQu', N'ChangDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1683', N'安乡县', N'2_189', N'常德市', N'NULL', 3, N'430721', N'AnXiangXian', N'ChangDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1684', N'汉寿县', N'2_189', N'常德市', N'NULL', 3, N'430722', N'HanShouXian', N'ChangDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1685', N'澧县', N'2_189', N'常德市', N'NULL', 3, N'430723', N'LiXian', N'ChangDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1686', N'临澧县', N'2_189', N'常德市', N'NULL', 3, N'430724', N'LinLiXian', N'ChangDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1687', N'桃源县', N'2_189', N'常德市', N'NULL', 3, N'430725', N'TaoYuanXian', N'ChangDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1688', N'石门县', N'2_189', N'常德市', N'NULL', 3, N'430726', N'ShiMenXian', N'ChangDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1689', N'津市市', N'2_189', N'常德市', N'NULL', 3, N'430781', N'JinShiShi', N'ChangDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_169', N'丰宁满族自治县', N'2_10', N'承德市', N'NULL', 3, N'130826', N'FengNingManZuZiZhiXian', N'ChengDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1690', N'永定区', N'2_190', N'张家界市', N'NULL', 3, N'430802', N'YongDingQu', N'ZhangJiaJieShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1691', N'武陵源区', N'2_190', N'张家界市', N'NULL', 3, N'430811', N'WuLingYuanQu', N'ZhangJiaJieShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1692', N'慈利县', N'2_190', N'张家界市', N'NULL', 3, N'430821', N'CiLiXian', N'ZhangJiaJieShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1693', N'桑植县', N'2_190', N'张家界市', N'NULL', 3, N'430822', N'SangZhiXian', N'ZhangJiaJieShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1694', N'资阳区', N'2_191', N'益阳市', N'NULL', 3, N'430902', N'ZiYangQu', N'YiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1695', N'赫山区', N'2_191', N'益阳市', N'NULL', 3, N'430903', N'HeShanQu', N'YiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1696', N'南县', N'2_191', N'益阳市', N'NULL', 3, N'430921', N'NanXian', N'YiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1697', N'桃江县', N'2_191', N'益阳市', N'NULL', 3, N'430922', N'TaoJiangXian', N'YiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1698', N'安化县', N'2_191', N'益阳市', N'NULL', 3, N'430923', N'AnHuaXian', N'YiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1699', N'沅江市', N'2_191', N'益阳市', N'NULL', 3, N'430981', N'YuanJiangShi', N'YiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_17', N'密云县', N'2_1', N'北京市', N'NULL', 3, N'110228', N'MiYunXian', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_170', N'宽城满族自治县', N'2_10', N'承德市', N'NULL', 3, N'130827', N'KuanChengManZuZiZhiXian', N'ChengDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1700', N'北湖区', N'2_192', N'郴州市', N'NULL', 3, N'431002', N'BeiHuQu', N'ChenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1701', N'苏仙区', N'2_192', N'郴州市', N'NULL', 3, N'431003', N'SuXianQu', N'ChenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1702', N'桂阳县', N'2_192', N'郴州市', N'NULL', 3, N'431021', N'GuiYangXian', N'ChenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1703', N'宜章县', N'2_192', N'郴州市', N'NULL', 3, N'431022', N'YiZhangXian', N'ChenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1704', N'永兴县', N'2_192', N'郴州市', N'NULL', 3, N'431023', N'YongXingXian', N'ChenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1705', N'嘉禾县', N'2_192', N'郴州市', N'NULL', 3, N'431024', N'JiaHeXian', N'ChenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1706', N'临武县', N'2_192', N'郴州市', N'NULL', 3, N'431025', N'LinWuXian', N'ChenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1707', N'汝城县', N'2_192', N'郴州市', N'NULL', 3, N'431026', N'RuChengXian', N'ChenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1708', N'桂东县', N'2_192', N'郴州市', N'NULL', 3, N'431027', N'GuiDongXian', N'ChenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1709', N'安仁县', N'2_192', N'郴州市', N'NULL', 3, N'431028', N'AnRenXian', N'ChenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_171', N'围场满族蒙古族自治县', N'2_10', N'承德市', N'NULL', 3, N'130828', N'WeiChangManZuMengGuZuZiZhiXian', N'ChengDeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1710', N'资兴市', N'2_192', N'郴州市', N'NULL', 3, N'431081', N'ZiXingShi', N'ChenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1711', N'零陵区', N'2_193', N'永州市', N'NULL', 3, N'431102', N'LingLingQu', N'YongZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1712', N'冷水滩区', N'2_193', N'永州市', N'NULL', 3, N'431103', N'LengShuiTanQu', N'YongZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1713', N'祁阳县', N'2_193', N'永州市', N'NULL', 3, N'431121', N'QiYangXian', N'YongZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1714', N'东安县', N'2_193', N'永州市', N'NULL', 3, N'431122', N'DongAnXian', N'YongZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1715', N'双牌县', N'2_193', N'永州市', N'NULL', 3, N'431123', N'ShuangPaiXian', N'YongZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1716', N'道县', N'2_193', N'永州市', N'NULL', 3, N'431124', N'DaoXian', N'YongZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1717', N'江永县', N'2_193', N'永州市', N'NULL', 3, N'431125', N'JiangYongXian', N'YongZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1718', N'宁远县', N'2_193', N'永州市', N'NULL', 3, N'431126', N'NingYuanXian', N'YongZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1719', N'蓝山县', N'2_193', N'永州市', N'NULL', 3, N'431127', N'LanShanXian', N'YongZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_172', N'新华区', N'2_11', N'沧州市', N'NULL', 3, N'130902', N'XinHuaQu', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1720', N'新田县', N'2_193', N'永州市', N'NULL', 3, N'431128', N'XinTianXian', N'YongZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1721', N'江华瑶族自治县', N'2_193', N'永州市', N'NULL', 3, N'431129', N'JiangHuaYaoZuZiZhiXian', N'YongZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1722', N'鹤城区', N'2_194', N'怀化市', N'NULL', 3, N'431202', N'HeChengQu', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1723', N'中方县', N'2_194', N'怀化市', N'NULL', 3, N'431221', N'ZhongFangXian', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1724', N'沅陵县', N'2_194', N'怀化市', N'NULL', 3, N'431222', N'YuanLingXian', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1725', N'辰溪县', N'2_194', N'怀化市', N'NULL', 3, N'431223', N'ChenXiXian', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1726', N'溆浦县', N'2_194', N'怀化市', N'NULL', 3, N'431224', N'XuPuXian', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1727', N'会同县', N'2_194', N'怀化市', N'NULL', 3, N'431225', N'HuiTongXian', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1728', N'麻阳苗族自治县', N'2_194', N'怀化市', N'NULL', 3, N'431226', N'MaYangMiaoZuZiZhiXian', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1729', N'新晃侗族自治县', N'2_194', N'怀化市', N'NULL', 3, N'431227', N'XinHuangDongZuZiZhiXian', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_173', N'运河区', N'2_11', N'沧州市', N'NULL', 3, N'130903', N'YunHeQu', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1730', N'芷江侗族自治县', N'2_194', N'怀化市', N'NULL', 3, N'431228', N'ZhiJiangDongZuZiZhiXian', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1731', N'靖州苗族侗族自治县', N'2_194', N'怀化市', N'NULL', 3, N'431229', N'JingZhouMiaoZuDongZuZiZhiXian', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1732', N'通道侗族自治县', N'2_194', N'怀化市', N'NULL', 3, N'431230', N'TongDaoDongZuZiZhiXian', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1733', N'洪江市', N'2_194', N'怀化市', N'NULL', 3, N'431281', N'HongJiangShi', N'HuaiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1734', N'娄星区', N'2_195', N'娄底市', N'NULL', 3, N'431302', N'LouXingQu', N'LouDiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1735', N'双峰县', N'2_195', N'娄底市', N'NULL', 3, N'431321', N'ShuangFengXian', N'LouDiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1736', N'新化县', N'2_195', N'娄底市', N'NULL', 3, N'431322', N'XinHuaXian', N'LouDiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1737', N'冷水江市', N'2_195', N'娄底市', N'NULL', 3, N'431381', N'LengShuiJiangShi', N'LouDiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1738', N'涟源市', N'2_195', N'娄底市', N'NULL', 3, N'431382', N'LianYuanShi', N'LouDiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1739', N'吉首市', N'2_196', N'湘西土家族苗族自治州', N'NULL', 3, N'433101', N'JiShouShi', N'XiangXiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_174', N'沧县', N'2_11', N'沧州市', N'NULL', 3, N'130921', N'CangXian', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1740', N'泸溪县', N'2_196', N'湘西土家族苗族自治州', N'NULL', 3, N'433122', N'LuXiXian', N'XiangXiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1741', N'凤凰县', N'2_196', N'湘西土家族苗族自治州', N'NULL', 3, N'433123', N'FengHuangXian', N'XiangXiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1742', N'花垣县', N'2_196', N'湘西土家族苗族自治州', N'NULL', 3, N'433124', N'HuaYuanXian', N'XiangXiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1743', N'保靖县', N'2_196', N'湘西土家族苗族自治州', N'NULL', 3, N'433125', N'BaoJingXian', N'XiangXiTuJiaZuMiaoZuZiZhiZhou')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1744', N'古丈县', N'2_196', N'湘西土家族苗族自治州', N'NULL', 3, N'433126', N'GuZhangXian', N'XiangXiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1745', N'永顺县', N'2_196', N'湘西土家族苗族自治州', N'NULL', 3, N'433127', N'YongShunXian', N'XiangXiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1746', N'龙山县', N'2_196', N'湘西土家族苗族自治州', N'NULL', 3, N'433130', N'LongShanXian', N'XiangXiTuJiaZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1747', N'从化市', N'2_197', N'广州市', N'NULL', 3, N'440184', N'CongHuaShi', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1748', N'南沙区', N'2_197', N'广州市', N'NULL', 3, N'440115', N'NanShaQu', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1749', N'萝岗区', N'2_197', N'广州市', N'NULL', 3, N'440116', N'LuoGangQu', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_175', N'青县', N'2_11', N'沧州市', N'NULL', 3, N'130922', N'QingXian', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1750', N'荔湾区', N'2_197', N'广州市', N'NULL', 3, N'440103', N'LiWanQu', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1751', N'越秀区', N'2_197', N'广州市', N'NULL', 3, N'440104', N'YueXiuQu', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1752', N'海珠区', N'2_197', N'广州市', N'NULL', 3, N'440105', N'HaiZhuQu', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1753', N'增城市', N'2_197', N'广州市', N'NULL', 3, N'440183', N'ZengChengShi', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1754', N'天河区', N'2_197', N'广州市', N'NULL', 3, N'440106', N'TianHeQu', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1755', N'白云区', N'2_197', N'广州市', N'NULL', 3, N'440111', N'BaiYunQu', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1756', N'黄埔区', N'2_197', N'广州市', N'NULL', 3, N'440112', N'HuangPuQu', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1757', N'番禺区', N'2_197', N'广州市', N'NULL', 3, N'440113', N'FanYuQu', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1758', N'花都区', N'2_197', N'广州市', N'NULL', 3, N'440114', N'HuaDouQu', N'GuangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1759', N'武江区', N'2_198', N'韶关市', N'NULL', 3, N'440203', N'WuJiangQu', N'ShaoGuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_176', N'东光县', N'2_11', N'沧州市', N'NULL', 3, N'130923', N'DongGuangXian', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1760', N'浈江区', N'2_198', N'韶关市', N'NULL', 3, N'440204', N'ZhenJiangQu', N'ShaoGuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1761', N'曲江区', N'2_198', N'韶关市', N'NULL', 3, N'440205', N'QuJiangQu', N'ShaoGuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1762', N'始兴县', N'2_198', N'韶关市', N'NULL', 3, N'440222', N'ShiXingXian', N'ShaoGuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1763', N'仁化县', N'2_198', N'韶关市', N'NULL', 3, N'440224', N'RenHuaXian', N'ShaoGuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1764', N'翁源县', N'2_198', N'韶关市', N'NULL', 3, N'440229', N'WengYuanXian', N'ShaoGuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1765', N'乳源瑶族自治县', N'2_198', N'韶关市', N'NULL', 3, N'440232', N'RuYuanYaoZuZiZhiXian', N'ShaoGuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1766', N'新丰县', N'2_198', N'韶关市', N'NULL', 3, N'440233', N'XinFengXian', N'ShaoGuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1767', N'乐昌市', N'2_198', N'韶关市', N'NULL', 3, N'440281', N'LeChangShi', N'ShaoGuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1768', N'南雄市', N'2_198', N'韶关市', N'NULL', 3, N'440282', N'NanXiongShi', N'ShaoGuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1769', N'罗湖区', N'2_199', N'深圳市', N'NULL', 3, N'440303', N'LuoHuQu', N'ShenZhenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_177', N'海兴县', N'2_11', N'沧州市', N'NULL', 3, N'130924', N'HaiXingXian', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1770', N'福田区', N'2_199', N'深圳市', N'NULL', 3, N'440304', N'FuTianQu', N'ShenZhenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1771', N'南山区', N'2_199', N'深圳市', N'NULL', 3, N'440305', N'NanShanQu', N'ShenZhenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1772', N'宝安区', N'2_199', N'深圳市', N'NULL', 3, N'440306', N'BaoAnQu', N'ShenZhenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1773', N'龙岗区', N'2_199', N'深圳市', N'NULL', 3, N'440307', N'LongGangQu', N'ShenZhenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1774', N'盐田区', N'2_199', N'深圳市', N'NULL', 3, N'440308', N'YanTianQu', N'ShenZhenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1775', N'香洲区', N'2_200', N'珠海市', N'NULL', 3, N'440402', N'XiangZhouQu', N'ZhuHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1776', N'斗门区', N'2_200', N'珠海市', N'NULL', 3, N'440403', N'DouMenQu', N'ZhuHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1777', N'金湾区', N'2_200', N'珠海市', N'NULL', 3, N'440404', N'JinWanQu', N'ZhuHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1778', N'龙湖区', N'2_201', N'汕头市', N'NULL', 3, N'440507', N'LongHuQu', N'ShanTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1779', N'金平区', N'2_201', N'汕头市', N'NULL', 3, N'440511', N'JinPingQu', N'ShanTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_178', N'盐山县', N'2_11', N'沧州市', N'NULL', 3, N'130925', N'YanShanXian', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1780', N'濠江区', N'2_201', N'汕头市', N'NULL', 3, N'440512', N'HaoJiangQu', N'ShanTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1781', N'潮阳区', N'2_201', N'汕头市', N'NULL', 3, N'440513', N'ChaoYangQu', N'ShanTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1782', N'潮南区', N'2_201', N'汕头市', N'NULL', 3, N'440514', N'ChaoNanQu', N'ShanTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1783', N'澄海区', N'2_201', N'汕头市', N'NULL', 3, N'440515', N'ChengHaiQu', N'ShanTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1784', N'南澳县', N'2_201', N'汕头市', N'NULL', 3, N'440523', N'NanAoXian', N'ShanTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1785', N'禅城区', N'2_202', N'佛山市', N'NULL', 3, N'440604', N'ChanChengQu', N'FoShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1786', N'南海区', N'2_202', N'佛山市', N'NULL', 3, N'440605', N'NanHaiQu', N'FoShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1787', N'顺德区', N'2_202', N'佛山市', N'NULL', 3, N'440606', N'ShunDeQu', N'FoShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1788', N'三水区', N'2_202', N'佛山市', N'NULL', 3, N'440607', N'SanShuiQu', N'FoShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1789', N'高明区', N'2_202', N'佛山市', N'NULL', 3, N'440608', N'GaoMingQu', N'FoShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_179', N'肃宁县', N'2_11', N'沧州市', N'NULL', 3, N'130926', N'SuNingXian', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1790', N'蓬江区', N'2_203', N'江门市', N'NULL', 3, N'440703', N'PengJiangQu', N'JiangMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1791', N'江海区', N'2_203', N'江门市', N'NULL', 3, N'440704', N'JiangHaiQu', N'JiangMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1792', N'新会区', N'2_203', N'江门市', N'NULL', 3, N'440705', N'XinHuiQu', N'JiangMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1793', N'台山市', N'2_203', N'江门市', N'NULL', 3, N'440781', N'TaiShanShi', N'JiangMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1794', N'开平市', N'2_203', N'江门市', N'NULL', 3, N'440783', N'KaiPingShi', N'JiangMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1795', N'鹤山市', N'2_203', N'江门市', N'NULL', 3, N'440784', N'HeShanShi', N'JiangMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1796', N'恩平市', N'2_203', N'江门市', N'NULL', 3, N'440785', N'EnPingShi', N'JiangMenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1797', N'赤坎区', N'2_204', N'湛江市', N'NULL', 3, N'440802', N'ChiKanQu', N'ZhanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1798', N'霞山区', N'2_204', N'湛江市', N'NULL', 3, N'440803', N'XiaShanQu', N'ZhanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1799', N'坡头区', N'2_204', N'湛江市', N'NULL', 3, N'440804', N'PoTouQu', N'ZhanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_18', N'延庆县', N'2_1', N'北京市', N'NULL', 3, N'110229', N'YanQingXian', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_180', N'南皮县', N'2_11', N'沧州市', N'NULL', 3, N'130927', N'NanPiXian', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1800', N'麻章区', N'2_204', N'湛江市', N'NULL', 3, N'440811', N'MaZhangQu', N'ZhanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1801', N'遂溪县', N'2_204', N'湛江市', N'NULL', 3, N'440823', N'SuiXiXian', N'ZhanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1802', N'徐闻县', N'2_204', N'湛江市', N'NULL', 3, N'440825', N'XuWenXian', N'ZhanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1803', N'廉江市', N'2_204', N'湛江市', N'NULL', 3, N'440881', N'LianJiangShi', N'ZhanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1804', N'雷州市', N'2_204', N'湛江市', N'NULL', 3, N'440882', N'LeiZhouShi', N'ZhanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1805', N'吴川市', N'2_204', N'湛江市', N'NULL', 3, N'440883', N'WuChuanShi', N'ZhanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1806', N'茂南区', N'2_205', N'茂名市', N'NULL', 3, N'440902', N'MaoNanQu', N'MaoMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1807', N'茂港区', N'2_205', N'茂名市', N'NULL', 3, N'440903', N'MaoGangQu', N'MaoMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1808', N'电白县', N'2_205', N'茂名市', N'NULL', 3, N'440923', N'DianBaiXian', N'MaoMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1809', N'高州市', N'2_205', N'茂名市', N'NULL', 3, N'440981', N'GaoZhouShi', N'MaoMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_181', N'吴桥县', N'2_11', N'沧州市', N'NULL', 3, N'130928', N'WuQiaoXian', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1810', N'化州市', N'2_205', N'茂名市', N'NULL', 3, N'440982', N'HuaZhouShi', N'MaoMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1811', N'信宜市', N'2_205', N'茂名市', N'NULL', 3, N'440983', N'XinYiShi', N'MaoMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1812', N'端州区', N'2_206', N'肇庆市', N'NULL', 3, N'441202', N'DuanZhouQu', N'ZhaoQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1813', N'鼎湖区', N'2_206', N'肇庆市', N'NULL', 3, N'441203', N'DingHuQu', N'ZhaoQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1814', N'广宁县', N'2_206', N'肇庆市', N'NULL', 3, N'441223', N'GuangNingXian', N'ZhaoQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1815', N'怀集县', N'2_206', N'肇庆市', N'NULL', 3, N'441224', N'HuaiJiXian', N'ZhaoQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1816', N'封开县', N'2_206', N'肇庆市', N'NULL', 3, N'441225', N'FengKaiXian', N'ZhaoQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1817', N'德庆县', N'2_206', N'肇庆市', N'NULL', 3, N'441226', N'DeQingXian', N'ZhaoQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1818', N'高要市', N'2_206', N'肇庆市', N'NULL', 3, N'441283', N'GaoYaoShi', N'ZhaoQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1819', N'四会市', N'2_206', N'肇庆市', N'NULL', 3, N'441284', N'SiHuiShi', N'ZhaoQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_182', N'献县', N'2_11', N'沧州市', N'NULL', 3, N'130929', N'XianXian', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1820', N'惠城区', N'2_207', N'惠州市', N'NULL', 3, N'441302', N'HuiChengQu', N'HuiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1821', N'惠阳区', N'2_207', N'惠州市', N'NULL', 3, N'441303', N'HuiYangQu', N'HuiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1822', N'博罗县', N'2_207', N'惠州市', N'NULL', 3, N'441322', N'BoLuoXian', N'HuiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1823', N'惠东县', N'2_207', N'惠州市', N'NULL', 3, N'441323', N'HuiDongXian', N'HuiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1824', N'龙门县', N'2_207', N'惠州市', N'NULL', 3, N'441324', N'LongMenXian', N'HuiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1825', N'梅江区', N'2_208', N'梅州市', N'NULL', 3, N'441402', N'MeiJiangQu', N'MeiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1826', N'梅县', N'2_208', N'梅州市', N'NULL', 3, N'441421', N'MeiXian', N'MeiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1827', N'大埔县', N'2_208', N'梅州市', N'NULL', 3, N'441422', N'DaPuXian', N'MeiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1828', N'丰顺县', N'2_208', N'梅州市', N'NULL', 3, N'441423', N'FengShunXian', N'MeiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1829', N'五华县', N'2_208', N'梅州市', N'NULL', 3, N'441424', N'WuHuaXian', N'MeiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_183', N'孟村回族自治县', N'2_11', N'沧州市', N'NULL', 3, N'130930', N'MengCunHuiZuZiZhiXian', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1830', N'平远县', N'2_208', N'梅州市', N'NULL', 3, N'441426', N'PingYuanXian', N'MeiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1831', N'蕉岭县', N'2_208', N'梅州市', N'NULL', 3, N'441427', N'JiaoLingXian', N'MeiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1832', N'兴宁市', N'2_208', N'梅州市', N'NULL', 3, N'441481', N'XingNingShi', N'MeiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1833', N'城区', N'2_209', N'汕尾市', N'NULL', 3, N'441502', N'ChengQu', N'ShanWeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1834', N'海丰县', N'2_209', N'汕尾市', N'NULL', 3, N'441521', N'HaiFengXian', N'ShanWeiShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1835', N'陆河县', N'2_209', N'汕尾市', N'NULL', 3, N'441523', N'LuHeXian', N'ShanWeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1836', N'陆丰市', N'2_209', N'汕尾市', N'NULL', 3, N'441581', N'LuFengShi', N'ShanWeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1837', N'源城区', N'2_210', N'河源市', N'NULL', 3, N'441602', N'YuanChengQu', N'HeYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1838', N'紫金县', N'2_210', N'河源市', N'NULL', 3, N'441621', N'ZiJinXian', N'HeYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1839', N'龙川县', N'2_210', N'河源市', N'NULL', 3, N'441622', N'LongChuanXian', N'HeYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_184', N'泊头市', N'2_11', N'沧州市', N'NULL', 3, N'130981', N'BoTouShi', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1840', N'连平县', N'2_210', N'河源市', N'NULL', 3, N'441623', N'LianPingXian', N'HeYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1841', N'和平县', N'2_210', N'河源市', N'NULL', 3, N'441624', N'HePingXian', N'HeYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1842', N'东源县', N'2_210', N'河源市', N'NULL', 3, N'441625', N'DongYuanXian', N'HeYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1843', N'江城区', N'2_211', N'阳江市', N'NULL', 3, N'441702', N'JiangChengQu', N'YangJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1844', N'阳西县', N'2_211', N'阳江市', N'NULL', 3, N'441721', N'YangXiXian', N'YangJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1845', N'阳东县', N'2_211', N'阳江市', N'NULL', 3, N'441723', N'YangDongXian', N'YangJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1846', N'阳春市', N'2_211', N'阳江市', N'NULL', 3, N'441781', N'YangChunShi', N'YangJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1847', N'清城区', N'2_212', N'清远市', N'NULL', 3, N'441802', N'QingChengQu', N'QingYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1848', N'佛冈县', N'2_212', N'清远市', N'NULL', 3, N'441821', N'FoGangXian', N'QingYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1849', N'阳山县', N'2_212', N'清远市', N'NULL', 3, N'441823', N'YangShanXian', N'QingYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_185', N'任丘市', N'2_11', N'沧州市', N'NULL', 3, N'130982', N'RenQiuShi', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1850', N'连山壮族瑶族自治县', N'2_212', N'清远市', N'NULL', 3, N'441825', N'LianShanZhuangZuYaoZuZiZhiXian', N'QingYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1851', N'连南瑶族自治县', N'2_212', N'清远市', N'NULL', 3, N'441826', N'LianNanYaoZuZiZhiXian', N'QingYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1852', N'清新县', N'2_212', N'清远市', N'NULL', 3, N'441827', N'QingXinXian', N'QingYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1853', N'英德市', N'2_212', N'清远市', N'NULL', 3, N'441881', N'YingDeShi', N'QingYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1854', N'连州市', N'2_212', N'清远市', N'NULL', 3, N'441882', N'LianZhouShi', N'QingYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1855', N'湘桥区', N'2_215', N'潮州市', N'NULL', 3, N'445102', N'XiangQiaoQu', N'ChaoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1856', N'潮安县', N'2_215', N'潮州市', N'NULL', 3, N'445121', N'ChaoAnXian', N'ChaoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1857', N'饶平县', N'2_215', N'潮州市', N'NULL', 3, N'445122', N'RaoPingXian', N'ChaoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1858', N'榕城区', N'2_216', N'揭阳市', N'NULL', 3, N'445202', N'RongChengQu', N'JieYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1859', N'揭东县', N'2_216', N'揭阳市', N'NULL', 3, N'445221', N'JieDongXian', N'JieYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_186', N'黄骅市', N'2_11', N'沧州市', N'NULL', 3, N'130983', N'HuangHuaShi', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1860', N'揭西县', N'2_216', N'揭阳市', N'NULL', 3, N'445222', N'JieXiXian', N'JieYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1861', N'惠来县', N'2_216', N'揭阳市', N'NULL', 3, N'445224', N'HuiLaiXian', N'JieYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1862', N'普宁市', N'2_216', N'揭阳市', N'NULL', 3, N'445281', N'PuNingShi', N'JieYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1863', N'云城区', N'2_217', N'云浮市', N'NULL', 3, N'445302', N'YunChengQu', N'YunFuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1864', N'新兴县', N'2_217', N'云浮市', N'NULL', 3, N'445321', N'XinXingXian', N'YunFuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1865', N'郁南县', N'2_217', N'云浮市', N'NULL', 3, N'445322', N'YuNanXian', N'YunFuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1866', N'云安县', N'2_217', N'云浮市', N'NULL', 3, N'445323', N'YunAnXian', N'YunFuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1867', N'罗定市', N'2_217', N'云浮市', N'NULL', 3, N'445381', N'LuoDingShi', N'YunFuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1868', N'兴宁区', N'2_218', N'南宁市', N'NULL', 3, N'450102', N'XingNingQu', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1869', N'青秀区', N'2_218', N'南宁市', N'NULL', 3, N'450103', N'QingXiuQu', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_187', N'河间市', N'2_11', N'沧州市', N'NULL', 3, N'130984', N'HeJianShi', N'CangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1870', N'江南区', N'2_218', N'南宁市', N'NULL', 3, N'450105', N'JiangNanQu', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1871', N'西乡塘区', N'2_218', N'南宁市', N'NULL', 3, N'450107', N'XiXiangTangQu', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1872', N'良庆区', N'2_218', N'南宁市', N'NULL', 3, N'450108', N'LiangQingQu', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1873', N'邕宁区', N'2_218', N'南宁市', N'NULL', 3, N'450109', N'YongNingQu', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1874', N'武鸣县', N'2_218', N'南宁市', N'NULL', 3, N'450122', N'WuMingXian', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1875', N'隆安县', N'2_218', N'南宁市', N'NULL', 3, N'450123', N'LongAnXian', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1876', N'马山县', N'2_218', N'南宁市', N'NULL', 3, N'450124', N'MaShanXian', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1877', N'上林县', N'2_218', N'南宁市', N'NULL', 3, N'450125', N'ShangLinXian', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1878', N'宾阳县', N'2_218', N'南宁市', N'NULL', 3, N'450126', N'BinYangXian', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1879', N'横县', N'2_218', N'南宁市', N'NULL', 3, N'450127', N'HengXian', N'NanNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_188', N'安次区', N'2_12', N'廊坊市', N'NULL', 3, N'131002', N'AnCiQu', N'LangFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1880', N'城中区', N'2_219', N'柳州市', N'NULL', 3, N'450202', N'ChengZhongQu', N'LiuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1881', N'鱼峰区', N'2_219', N'柳州市', N'NULL', 3, N'450203', N'YuFengQu', N'LiuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1882', N'柳南区', N'2_219', N'柳州市', N'NULL', 3, N'450204', N'LiuNanQu', N'LiuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1883', N'柳北区', N'2_219', N'柳州市', N'NULL', 3, N'450205', N'LiuBeiQu', N'LiuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1884', N'柳江县', N'2_219', N'柳州市', N'NULL', 3, N'450221', N'LiuJiangXian', N'LiuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1885', N'柳城县', N'2_219', N'柳州市', N'NULL', 3, N'450222', N'LiuChengXian', N'LiuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1886', N'鹿寨县', N'2_219', N'柳州市', N'NULL', 3, N'450223', N'LuZhaiXian', N'LiuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1887', N'融安县', N'2_219', N'柳州市', N'NULL', 3, N'450224', N'RongAnXian', N'LiuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1888', N'融水苗族自治县', N'2_219', N'柳州市', N'NULL', 3, N'450225', N'RongShuiMiaoZuZiZhiXian', N'LiuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1889', N'三江侗族自治县', N'2_219', N'柳州市', N'NULL', 3, N'450226', N'SanJiangDongZuZiZhiXian', N'LiuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_189', N'广阳区', N'2_12', N'廊坊市', N'NULL', 3, N'131003', N'GuangYangQu', N'LangFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1890', N'秀峰区', N'2_220', N'桂林市', N'NULL', 3, N'450302', N'XiuFengQu', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1891', N'叠彩区', N'2_220', N'桂林市', N'NULL', 3, N'450303', N'DieCaiQu', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1892', N'象山区', N'2_220', N'桂林市', N'NULL', 3, N'450304', N'XiangShanQu', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1893', N'七星区', N'2_220', N'桂林市', N'NULL', 3, N'450305', N'QiXingQu', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1894', N'雁山区', N'2_220', N'桂林市', N'NULL', 3, N'450311', N'YanShanQu', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1895', N'阳朔县', N'2_220', N'桂林市', N'NULL', 3, N'450321', N'YangShuoXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1896', N'临桂县', N'2_220', N'桂林市', N'NULL', 3, N'450322', N'LinGuiXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1897', N'灵川县', N'2_220', N'桂林市', N'NULL', 3, N'450323', N'LingChuanXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1898', N'全州县', N'2_220', N'桂林市', N'NULL', 3, N'450324', N'QuanZhouXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1899', N'兴安县', N'2_220', N'桂林市', N'NULL', 3, N'450325', N'XingAnXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_19', N'和平区', N'2_2', N'天津市', N'NULL', 3, N'120101', N'HePingQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_190', N'固安县', N'2_12', N'廊坊市', N'NULL', 3, N'131022', N'GuAnXian', N'LangFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1900', N'永福县', N'2_220', N'桂林市', N'NULL', 3, N'450326', N'YongFuXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1901', N'灌阳县', N'2_220', N'桂林市', N'NULL', 3, N'450327', N'GuanYangXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1902', N'龙胜各族自治县', N'2_220', N'桂林市', N'NULL', 3, N'450328', N'LongShengGeZuZiZhiXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1903', N'资源县', N'2_220', N'桂林市', N'NULL', 3, N'450329', N'ZiYuanXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1904', N'平乐县', N'2_220', N'桂林市', N'NULL', 3, N'450330', N'PingLeXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1905', N'荔蒲县', N'2_220', N'桂林市', N'NULL', 3, N'450331', N'LiPuXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1906', N'恭城瑶族自治县', N'2_220', N'桂林市', N'NULL', 3, N'450332', N'GongChengYaoZuZiZhiXian', N'GuiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1907', N'万秀区', N'2_221', N'梧州市', N'NULL', 3, N'450403', N'WanXiuQu', N'WuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1908', N'蝶山区', N'2_221', N'梧州市', N'NULL', 3, N'450404', N'DieShanQu', N'WuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1909', N'长洲区', N'2_221', N'梧州市', N'NULL', 3, N'450405', N'ChangZhouQu', N'WuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_191', N'永清县', N'2_12', N'廊坊市', N'NULL', 3, N'131023', N'YongQingXian', N'LangFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1910', N'苍梧县', N'2_221', N'梧州市', N'NULL', 3, N'450421', N'CangWuXian', N'WuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1911', N'藤县', N'2_221', N'梧州市', N'NULL', 3, N'450422', N'TengXian', N'WuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1912', N'蒙山县', N'2_221', N'梧州市', N'NULL', 3, N'450423', N'MengShanXian', N'WuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1913', N'岑溪市', N'2_221', N'梧州市', N'NULL', 3, N'450481', N'CenXiShi', N'WuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1914', N'海城区', N'2_222', N'北海市', N'NULL', 3, N'450502', N'HaiChengQu', N'BeiHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1915', N'银海区', N'2_222', N'北海市', N'NULL', 3, N'450503', N'YinHaiQu', N'BeiHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1916', N'铁山港区', N'2_222', N'北海市', N'NULL', 3, N'450512', N'TieShanGangQu', N'BeiHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1917', N'合浦县', N'2_222', N'北海市', N'NULL', 3, N'450521', N'HePuXian', N'BeiHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1918', N'港口区', N'2_223', N'防城港市', N'NULL', 3, N'450602', N'GangKouQu', N'FangChengGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1919', N'防城区', N'2_223', N'防城港市', N'NULL', 3, N'450603', N'FangChengQu', N'FangChengGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_192', N'香河县', N'2_12', N'廊坊市', N'NULL', 3, N'131024', N'XiangHeXian', N'LangFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1920', N'上思县', N'2_223', N'防城港市', N'NULL', 3, N'450621', N'ShangSiXian', N'FangChengGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1921', N'东兴市', N'2_223', N'防城港市', N'NULL', 3, N'450681', N'DongXingShi', N'FangChengGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1922', N'钦南区', N'2_224', N'钦州市', N'NULL', 3, N'450702', N'QinNanQu', N'QinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1923', N'钦北区', N'2_224', N'钦州市', N'NULL', 3, N'450703', N'QinBeiQu', N'QinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1924', N'灵山县', N'2_224', N'钦州市', N'NULL', 3, N'450721', N'LingShanXian', N'QinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1925', N'浦北县', N'2_224', N'钦州市', N'NULL', 3, N'450722', N'PuBeiXian', N'QinZhouShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1926', N'港北区', N'2_225', N'贵港市', N'NULL', 3, N'450802', N'GangBeiQu', N'GuiGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1927', N'港南区', N'2_225', N'贵港市', N'NULL', 3, N'450803', N'GangNanQu', N'GuiGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1928', N'覃塘区', N'2_225', N'贵港市', N'NULL', 3, N'450804', N'TanTangQu', N'GuiGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1929', N'平南县', N'2_225', N'贵港市', N'NULL', 3, N'450821', N'PingNanXian', N'GuiGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_193', N'大城县', N'2_12', N'廊坊市', N'NULL', 3, N'131025', N'DaChengXian', N'LangFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1930', N'桂平市', N'2_225', N'贵港市', N'NULL', 3, N'450881', N'GuiPingShi', N'GuiGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1931', N'玉州区', N'2_226', N'玉林市', N'NULL', 3, N'450902', N'YuZhouQu', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1932', N'容县', N'2_226', N'玉林市', N'NULL', 3, N'450921', N'RongXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1933', N'陆川县', N'2_226', N'玉林市', N'NULL', 3, N'450922', N'LuChuanXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1934', N'博白县', N'2_226', N'玉林市', N'NULL', 3, N'450923', N'BoBaiXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1935', N'兴业县', N'2_226', N'玉林市', N'NULL', 3, N'450924', N'XingYeXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1936', N'北流市', N'2_226', N'玉林市', N'NULL', 3, N'450981', N'BeiLiuShi', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1937', N'右江区', N'2_227', N'百色市', N'NULL', 3, N'451002', N'YouJiangQu', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1938', N'田阳县', N'2_227', N'百色市', N'NULL', 3, N'451021', N'TianYangXian', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1939', N'田东县', N'2_227', N'百色市', N'NULL', 3, N'451022', N'TianDongXian', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_194', N'文安县', N'2_12', N'廊坊市', N'NULL', 3, N'131026', N'WenAnXian', N'LangFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1940', N'平果县', N'2_227', N'百色市', N'NULL', 3, N'451023', N'PingGuoXian', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1941', N'德保县', N'2_227', N'百色市', N'NULL', 3, N'451024', N'DeBaoXian', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1942', N'靖西县', N'2_227', N'百色市', N'NULL', 3, N'451025', N'JingXiXian', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1943', N'那坡县', N'2_227', N'百色市', N'NULL', 3, N'451026', N'NaPoXian', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1944', N'凌云县', N'2_227', N'百色市', N'NULL', 3, N'451027', N'LingYunXian', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1945', N'乐业县', N'2_227', N'百色市', N'NULL', 3, N'451028', N'LeYeXian', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1946', N'田林县', N'2_227', N'百色市', N'NULL', 3, N'451029', N'TianLinXian', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1947', N'西林县', N'2_227', N'百色市', N'NULL', 3, N'451030', N'XiLinXian', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1948', N'隆林各族自治县', N'2_227', N'百色市', N'NULL', 3, N'451031', N'LongLinGeZuZiZhiXian', N'BaiSeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1949', N'八步区', N'2_228', N'贺州市', N'NULL', 3, N'451102', N'BaBuQu', N'HeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_195', N'大厂回族自治县', N'2_12', N'廊坊市', N'NULL', 3, N'131028', N'DaChangHuiZuZiZhiXian', N'LangFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1950', N'昭平县', N'2_228', N'贺州市', N'NULL', 3, N'451121', N'ZhaoPingXian', N'HeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1951', N'钟山县', N'2_228', N'贺州市', N'NULL', 3, N'451122', N'ZhongShanXian', N'HeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1952', N'富川瑶族自治县', N'2_228', N'贺州市', N'NULL', 3, N'451123', N'FuChuanYaoZuZiZhiXian', N'HeZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1953', N'金城江区', N'2_229', N'河池市', N'NULL', 3, N'451202', N'JinChengJiangQu', N'HeChiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1954', N'南丹县', N'2_229', N'河池市', N'NULL', 3, N'451221', N'NanDanXian', N'HeChiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1955', N'天峨县', N'2_229', N'河池市', N'NULL', 3, N'451222', N'TianEXian', N'HeChiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1956', N'凤山县', N'2_229', N'河池市', N'NULL', 3, N'451223', N'FengShanXian', N'HeChiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1957', N'东兰县', N'2_229', N'河池市', N'NULL', 3, N'451224', N'DongLanXian', N'HeChiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1958', N'罗城仫佬族自治县', N'2_229', N'河池市', N'NULL', 3, N'451225', N'LuoChengMuLaoZuZiZhiXian', N'HeChiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1959', N'环江毛南族自治县', N'2_229', N'河池市', N'NULL', 3, N'451226', N'HuanJiangMaoNanZuZiZhiXian', N'HeChiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_196', N'霸州市', N'2_12', N'廊坊市', N'NULL', 3, N'131081', N'BaZhouShi', N'LangFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1960', N'巴马瑶族自治县', N'2_229', N'河池市', N'NULL', 3, N'451227', N'BaMaYaoZuZiZhiXian', N'HeChiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1961', N'都安瑶族自治县', N'2_229', N'河池市', N'NULL', 3, N'451228', N'DouAnYaoZuZiZhiXian', N'HeChiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1962', N'大化瑶族自治县', N'2_229', N'河池市', N'NULL', 3, N'451229', N'DaHuaYaoZuZiZhiXian', N'HeChiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1963', N'宜州市', N'2_229', N'河池市', N'NULL', 3, N'451281', N'YiZhouShi', N'HeChiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1964', N'兴宾区', N'2_230', N'来宾市', N'NULL', 3, N'451302', N'XingBinQu', N'LaiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1965', N'忻城县', N'2_230', N'来宾市', N'NULL', 3, N'451321', N'XinChengXian', N'LaiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1966', N'象州县', N'2_230', N'来宾市', N'NULL', 3, N'451322', N'XiangZhouXian', N'LaiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1967', N'武宣县', N'2_230', N'来宾市', N'NULL', 3, N'451323', N'WuXuanXian', N'LaiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1968', N'金秀瑶族自治县', N'2_230', N'来宾市', N'NULL', 3, N'451324', N'JinXiuYaoZuZiZhiXian', N'LaiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1969', N'合山市', N'2_230', N'来宾市', N'NULL', 3, N'451381', N'HeShanShi', N'LaiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_197', N'三河市', N'2_12', N'廊坊市', N'NULL', 3, N'131082', N'SanHeShi', N'LangFangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1970', N'江洲区', N'2_231', N'崇左市', N'NULL', 3, N'451402', N'JiangZhouQu', N'ChongZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1971', N'扶绥县', N'2_231', N'崇左市', N'NULL', 3, N'451421', N'FuSuiXian', N'ChongZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1972', N'宁明县', N'2_231', N'崇左市', N'NULL', 3, N'451422', N'NingMingXian', N'ChongZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1973', N'龙州县', N'2_231', N'崇左市', N'NULL', 3, N'451423', N'LongZhouXian', N'ChongZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1974', N'大新县', N'2_231', N'崇左市', N'NULL', 3, N'451424', N'DaXinXian', N'ChongZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1975', N'天等县', N'2_231', N'崇左市', N'NULL', 3, N'451425', N'TianDengXian', N'ChongZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1976', N'凭祥市', N'2_231', N'崇左市', N'NULL', 3, N'451481', N'PingXiangShi', N'ChongZuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1977', N'秀英区', N'2_232', N'海口市', N'NULL', 3, N'460105', N'XiuYingQu', N'HaiKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1978', N'龙华区', N'2_232', N'海口市', N'NULL', 3, N'460106', N'LongHuaQu', N'HaiKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1979', N'琼山区', N'2_232', N'海口市', N'NULL', 3, N'460107', N'QiongShanQu', N'HaiKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_198', N'桃城区', N'2_13', N'衡水市', N'NULL', 3, N'131102', N'TaoChengQu', N'HengShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1980', N'美兰区', N'2_232', N'海口市', N'NULL', 3, N'460108', N'MeiLanQu', N'HaiKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1981', N'五指山市', N'2_233', N'三亚市', N'NULL', 3, N'469001', N'WuZhiShanShi', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1982', N'琼海市', N'2_233', N'三亚市', N'NULL', 3, N'469002', N'QiongHaiShi', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1983', N'儋州市', N'2_233', N'三亚市', N'NULL', 3, N'469003', N'DanZhouShi', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1984', N'文昌市', N'2_233', N'三亚市', N'NULL', 3, N'469005', N'WenChangShi', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1985', N'万宁市', N'2_233', N'三亚市', N'NULL', 3, N'469006', N'WanNingShi', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1986', N'东方市', N'2_233', N'三亚市', N'NULL', 3, N'469007', N'DongFangShi', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1987', N'定安县', N'2_233', N'三亚市', N'NULL', 3, N'469025', N'DingAnXian', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1988', N'屯昌县', N'2_233', N'三亚市', N'NULL', 3, N'469026', N'TunChangXian', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1989', N'澄迈县', N'2_233', N'三亚市', N'NULL', 3, N'469027', N'ChengMaiXian', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_199', N'枣强县', N'2_13', N'衡水市', N'NULL', 3, N'131121', N'ZaoQiangXian', N'HengShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1990', N'临高县', N'2_233', N'三亚市', N'NULL', 3, N'469028', N'LinGaoXian', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1991', N'白沙黎族自治县', N'2_233', N'三亚市', N'NULL', 3, N'469030', N'BaiShaLiZuZiZhiXian', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1992', N'昌江黎族自治县', N'2_233', N'三亚市', N'NULL', 3, N'469031', N'ChangJiangLiZuZiZhiXian', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1993', N'乐东黎族自治县', N'2_233', N'三亚市', N'NULL', 3, N'469033', N'LeDongLiZuZiZhiXian', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1994', N'陵水黎族自治县', N'2_233', N'三亚市', N'NULL', 3, N'469034', N'LingShuiLiZuZiZhiXian', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1995', N'保亭黎族苗族自治县', N'2_233', N'三亚市', N'NULL', 3, N'469035', N'BaoTingLiZuMiaoZuZiZhiXian', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1996', N'琼中黎族苗族自治县', N'2_233', N'三亚市', N'NULL', 3, N'469036', N'QiongZhongLiZuMiaoZuZiZhiXian', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1997', N'西沙群岛', N'2_233', N'三亚市', N'NULL', 3, N'469037', N'XiShaQunDao', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1998', N'南沙群岛', N'2_233', N'三亚市', N'NULL', 3, N'469038', N'NanShaQunDao', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_1999', N'中沙群岛的岛礁及其海域', N'2_233', N'三亚市', N'NULL', 3, N'469039', N'ZhongShaQunDaoDeDaoJiaoJiQiHaiYu', N'SanYaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2', N'西城区', N'2_1', N'北京市', N'NULL', 3, N'110102', N'XiChengQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_20', N'河东区', N'2_2', N'天津市', N'NULL', 3, N'120102', N'HeDongQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_200', N'武邑县', N'2_13', N'衡水市', N'NULL', 3, N'131122', N'WuYiXian', N'HengShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2000', N'万州区', N'2_234', N'重庆市', N'NULL', 3, N'500101', N'WanZhouQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2001', N'涪陵区', N'2_234', N'重庆市', N'NULL', 3, N'500102', N'FuLingQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2002', N'渝中区', N'2_234', N'重庆市', N'NULL', 3, N'500103', N'YuZhongQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2003', N'大渡口区', N'2_234', N'重庆市', N'NULL', 3, N'500104', N'DaDuKouQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2004', N'江北区', N'2_234', N'重庆市', N'NULL', 3, N'500105', N'JiangBeiQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2005', N'沙坪坝区', N'2_234', N'重庆市', N'NULL', 3, N'500106', N'ShaPingBaQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2006', N'九龙坡区', N'2_234', N'重庆市', N'NULL', 3, N'500107', N'JiuLongPoQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2007', N'南岸区', N'2_234', N'重庆市', N'NULL', 3, N'500108', N'NanAnQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2008', N'北碚区', N'2_234', N'重庆市', N'NULL', 3, N'500109', N'BeiBeiQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2009', N'万盛区', N'2_234', N'重庆市', N'NULL', 3, N'500110', N'WanShengQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_201', N'武强县', N'2_13', N'衡水市', N'NULL', 3, N'131123', N'WuQiangXian', N'HengShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2010', N'双桥区', N'2_234', N'重庆市', N'NULL', 3, N'500111', N'ShuangQiaoQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2011', N'渝北区', N'2_234', N'重庆市', N'NULL', 3, N'500112', N'YuBeiQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2012', N'巴南区', N'2_234', N'重庆市', N'NULL', 3, N'500113', N'BaNanQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2013', N'黔江区', N'2_234', N'重庆市', N'NULL', 3, N'500114', N'QianJiangQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2014', N'长寿区', N'2_234', N'重庆市', N'NULL', 3, N'500115', N'ChangShouQu', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2015', N'綦江县', N'2_234', N'重庆市', N'NULL', 3, N'500222', N'QiJiangXian', N'ZhongQingShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2016', N'潼南县', N'2_234', N'重庆市', N'NULL', 3, N'500223', N'TongNanXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2017', N'铜梁县', N'2_234', N'重庆市', N'NULL', 3, N'500224', N'TongLiangXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2018', N'大足县', N'2_234', N'重庆市', N'NULL', 3, N'500225', N'DaZuXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2019', N'荣昌县', N'2_234', N'重庆市', N'NULL', 3, N'500226', N'RongChangXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_202', N'饶阳县', N'2_13', N'衡水市', N'NULL', 3, N'131124', N'RaoYangXian', N'HengShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2020', N'璧山县', N'2_234', N'重庆市', N'NULL', 3, N'500227', N'BiShanXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2021', N'梁平县', N'2_234', N'重庆市', N'NULL', 3, N'500228', N'LiangPingXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2022', N'城口县', N'2_234', N'重庆市', N'NULL', 3, N'500229', N'ChengKouXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2023', N'丰都县', N'2_234', N'重庆市', N'NULL', 3, N'500230', N'FengDouXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2024', N'垫江县', N'2_234', N'重庆市', N'NULL', 3, N'500231', N'DianJiangXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2025', N'武隆县', N'2_234', N'重庆市', N'NULL', 3, N'500232', N'WuLongXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2026', N'忠县', N'2_234', N'重庆市', N'NULL', 3, N'500233', N'ZhongXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2027', N'开县', N'2_234', N'重庆市', N'NULL', 3, N'500234', N'KaiXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2028', N'云阳县', N'2_234', N'重庆市', N'NULL', 3, N'500235', N'YunYangXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2029', N'奉节县', N'2_234', N'重庆市', N'NULL', 3, N'500236', N'FengJieXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_203', N'安平县', N'2_13', N'衡水市', N'NULL', 3, N'131125', N'AnPingXian', N'HengShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2030', N'巫山县', N'2_234', N'重庆市', N'NULL', 3, N'500237', N'WuShanXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2031', N'巫溪县', N'2_234', N'重庆市', N'NULL', 3, N'500238', N'WuXiXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2032', N'石柱土家族自治县', N'2_234', N'重庆市', N'NULL', 3, N'500240', N'ShiZhuTuJiaZuZiZhiXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2033', N'秀山土家族苗族自治县', N'2_234', N'重庆市', N'NULL', 3, N'500241', N'XiuShanTuJiaZuMiaoZuZiZhiXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2034', N'酉阳土家族苗族自治县', N'2_234', N'重庆市', N'NULL', 3, N'500242', N'YouYangTuJiaZuMiaoZuZiZhiXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2035', N'彭水苗族土家族自治县', N'2_234', N'重庆市', N'NULL', 3, N'500243', N'PengShuiMiaoZuTuJiaZuZiZhiXian', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2036', N'江津市', N'2_234', N'重庆市', N'NULL', 3, N'500116', N'JiangJinShi', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2037', N'合川市', N'2_234', N'重庆市', N'NULL', 3, N'500117', N'HeChuanShi', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2038', N'永川市', N'2_234', N'重庆市', N'NULL', 3, N'500118', N'YongChuanShi', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2039', N'南川市', N'2_234', N'重庆市', N'NULL', 3, N'500119', N'NanChuanShi', N'ZhongQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_204', N'故城县', N'2_13', N'衡水市', N'NULL', 3, N'131126', N'GuChengXian', N'HengShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2040', N'锦江区', N'2_235', N'成都市', N'NULL', 3, N'510104', N'JinJiangQu', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2041', N'青羊区', N'2_235', N'成都市', N'NULL', 3, N'510105', N'QingYangQu', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2042', N'金牛区', N'2_235', N'成都市', N'NULL', 3, N'510106', N'JinNiuQu', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2043', N'武侯区', N'2_235', N'成都市', N'NULL', 3, N'510107', N'WuHouQu', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2044', N'成华区', N'2_235', N'成都市', N'NULL', 3, N'510108', N'ChengHuaQu', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2045', N'龙泉驿区', N'2_235', N'成都市', N'NULL', 3, N'510112', N'LongQuanYiQu', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2046', N'青白江区', N'2_235', N'成都市', N'NULL', 3, N'510113', N'QingBaiJiangQu', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2047', N'新都区', N'2_235', N'成都市', N'NULL', 3, N'510114', N'XinDouQu', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2048', N'温江区', N'2_235', N'成都市', N'NULL', 3, N'510115', N'WenJiangQu', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2049', N'金堂县', N'2_235', N'成都市', N'NULL', 3, N'510121', N'JinTangXian', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_205', N'景县', N'2_13', N'衡水市', N'NULL', 3, N'131127', N'JingXian', N'HengShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2050', N'双流县', N'2_235', N'成都市', N'NULL', 3, N'510122', N'ShuangLiuXian', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2051', N'郫县', N'2_235', N'成都市', N'NULL', 3, N'510124', N'PiXian', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2052', N'大邑县', N'2_235', N'成都市', N'NULL', 3, N'510129', N'DaYiXian', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2053', N'蒲江县', N'2_235', N'成都市', N'NULL', 3, N'510131', N'PuJiangXian', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2054', N'新津县', N'2_235', N'成都市', N'NULL', 3, N'510132', N'XinJinXian', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2055', N'都江堰市', N'2_235', N'成都市', N'NULL', 3, N'510181', N'DouJiangYanShi', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2056', N'彭州市', N'2_235', N'成都市', N'NULL', 3, N'510182', N'PengZhouShi', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2057', N'邛崃市', N'2_235', N'成都市', N'NULL', 3, N'510183', N'QiongLaiShi', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2058', N'崇州市', N'2_235', N'成都市', N'NULL', 3, N'510184', N'ChongZhouShi', N'ChengDouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2059', N'自流井区', N'2_236', N'自贡市', N'NULL', 3, N'510302', N'ZiLiuJingQu', N'ZiGongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_206', N'阜城县', N'2_13', N'衡水市', N'NULL', 3, N'131128', N'FuChengXian', N'HengShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2060', N'贡井区', N'2_236', N'自贡市', N'NULL', 3, N'510303', N'GongJingQu', N'ZiGongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2061', N'大安区', N'2_236', N'自贡市', N'NULL', 3, N'510304', N'DaAnQu', N'ZiGongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2062', N'沿滩区', N'2_236', N'自贡市', N'NULL', 3, N'510311', N'YanTanQu', N'ZiGongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2063', N'荣县', N'2_236', N'自贡市', N'NULL', 3, N'510321', N'RongXian', N'ZiGongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2064', N'富顺县', N'2_236', N'自贡市', N'NULL', 3, N'510322', N'FuShunXian', N'ZiGongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2065', N'东区', N'2_237', N'攀枝花市', N'NULL', 3, N'510402', N'DongQu', N'PanZhiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2066', N'西区', N'2_237', N'攀枝花市', N'NULL', 3, N'510403', N'XiQu', N'PanZhiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2067', N'仁和区', N'2_237', N'攀枝花市', N'NULL', 3, N'510411', N'RenHeQu', N'PanZhiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2068', N'米易县', N'2_237', N'攀枝花市', N'NULL', 3, N'510421', N'MiYiXian', N'PanZhiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2069', N'盐边县', N'2_237', N'攀枝花市', N'NULL', 3, N'510422', N'YanBianXian', N'PanZhiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_207', N'冀州市', N'2_13', N'衡水市', N'NULL', 3, N'131181', N'JiZhouShi', N'HengShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2070', N'江阳区', N'2_238', N'泸州市', N'NULL', 3, N'510502', N'JiangYangQu', N'LuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2071', N'纳溪区', N'2_238', N'泸州市', N'NULL', 3, N'510503', N'NaXiQu', N'LuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2072', N'龙马潭区', N'2_238', N'泸州市', N'NULL', 3, N'510504', N'LongMaTanQu', N'LuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2073', N'泸县', N'2_238', N'泸州市', N'NULL', 3, N'510521', N'LuXian', N'LuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2074', N'合江县', N'2_238', N'泸州市', N'NULL', 3, N'510522', N'HeJiangXian', N'LuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2075', N'叙永县', N'2_238', N'泸州市', N'NULL', 3, N'510524', N'XuYongXian', N'LuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2076', N'古蔺县', N'2_238', N'泸州市', N'NULL', 3, N'510525', N'GuLinXian', N'LuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2077', N'旌阳区', N'2_239', N'德阳市', N'NULL', 3, N'510603', N'JingYangQu', N'DeYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2078', N'中江县', N'2_239', N'德阳市', N'NULL', 3, N'510623', N'ZhongJiangXian', N'DeYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2079', N'罗江县', N'2_239', N'德阳市', N'NULL', 3, N'510626', N'LuoJiangXian', N'DeYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_208', N'深州市', N'2_13', N'衡水市', N'NULL', 3, N'131182', N'ShenZhouShi', N'HengShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2080', N'广汉市', N'2_239', N'德阳市', N'NULL', 3, N'510681', N'GuangHanShi', N'DeYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2081', N'什邡市', N'2_239', N'德阳市', N'NULL', 3, N'510682', N'ShiFangShi', N'DeYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2082', N'绵竹市', N'2_239', N'德阳市', N'NULL', 3, N'510683', N'MianZhuShi', N'DeYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2083', N'涪城区', N'2_240', N'绵阳市', N'NULL', 3, N'510703', N'FuChengQu', N'MianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2084', N'游仙区', N'2_240', N'绵阳市', N'NULL', 3, N'510704', N'YouXianQu', N'MianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2085', N'三台县', N'2_240', N'绵阳市', N'NULL', 3, N'510722', N'SanTaiXian', N'MianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2086', N'盐亭县', N'2_240', N'绵阳市', N'NULL', 3, N'510723', N'YanTingXian', N'MianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2087', N'安县', N'2_240', N'绵阳市', N'NULL', 3, N'510724', N'AnXian', N'MianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2088', N'梓潼县', N'2_240', N'绵阳市', N'NULL', 3, N'510725', N'ZiTongXian', N'MianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2089', N'北川羌族自治县', N'2_240', N'绵阳市', N'NULL', 3, N'510726', N'BeiChuanQiangZuZiZhiXian', N'MianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_209', N'小店区', N'2_14', N'太原市', N'NULL', 3, N'140105', N'XiaoDianQu', N'TaiYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2090', N'平武县', N'2_240', N'绵阳市', N'NULL', 3, N'510727', N'PingWuXian', N'MianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2091', N'江油市', N'2_240', N'绵阳市', N'NULL', 3, N'510781', N'JiangYouShi', N'MianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2092', N'市中区', N'2_241', N'广元市', N'NULL', 3, N'510802', N'ShiZhongQu', N'GuangYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2093', N'元坝区', N'2_241', N'广元市', N'NULL', 3, N'510811', N'YuanBaQu', N'GuangYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2094', N'朝天区', N'2_241', N'广元市', N'NULL', 3, N'510812', N'ChaoTianQu', N'GuangYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2095', N'旺苍县', N'2_241', N'广元市', N'NULL', 3, N'510821', N'WangCangXian', N'GuangYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2096', N'青川县', N'2_241', N'广元市', N'NULL', 3, N'510822', N'QingChuanXian', N'GuangYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2097', N'剑阁县', N'2_241', N'广元市', N'NULL', 3, N'510823', N'JianGeXian', N'GuangYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2098', N'苍溪县', N'2_241', N'广元市', N'NULL', 3, N'510824', N'CangXiXian', N'GuangYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2099', N'船山区', N'2_242', N'遂宁市', N'NULL', 3, N'510903', N'ChuanShanQu', N'SuiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_21', N'河西区', N'2_2', N'天津市', N'NULL', 3, N'120103', N'HeXiQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_210', N'迎泽区', N'2_14', N'太原市', N'NULL', 3, N'140106', N'YingZeQu', N'TaiYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2100', N'安居区', N'2_242', N'遂宁市', N'NULL', 3, N'510904', N'AnJuQu', N'SuiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2101', N'蓬溪县', N'2_242', N'遂宁市', N'NULL', 3, N'510921', N'PengXiXian', N'SuiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2102', N'射洪县', N'2_242', N'遂宁市', N'NULL', 3, N'510922', N'SheHongXian', N'SuiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2103', N'大英县', N'2_242', N'遂宁市', N'NULL', 3, N'510923', N'DaYingXian', N'SuiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2104', N'市中区', N'2_243', N'内江市', N'NULL', 3, N'511002', N'ShiZhongQu', N'NaJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2105', N'东兴区', N'2_243', N'内江市', N'NULL', 3, N'511011', N'DongXingQu', N'NaJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2106', N'威远县', N'2_243', N'内江市', N'NULL', 3, N'511024', N'WeiYuanXian', N'NaJiangShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2107', N'资中县', N'2_243', N'内江市', N'NULL', 3, N'511025', N'ZiZhongXian', N'NaJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2108', N'隆昌县', N'2_243', N'内江市', N'NULL', 3, N'511028', N'LongChangXian', N'NaJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2109', N'市中区', N'2_244', N'乐山市', N'NULL', 3, N'511102', N'ShiZhongQu', N'LeShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_211', N'杏花岭区', N'2_14', N'太原市', N'NULL', 3, N'140107', N'XingHuaLingQu', N'TaiYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2110', N'沙湾区', N'2_244', N'乐山市', N'NULL', 3, N'511111', N'ShaWanQu', N'LeShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2111', N'五通桥区', N'2_244', N'乐山市', N'NULL', 3, N'511112', N'WuTongQiaoQu', N'LeShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2112', N'金口河区', N'2_244', N'乐山市', N'NULL', 3, N'511113', N'JinKouHeQu', N'LeShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2113', N'犍为县', N'2_244', N'乐山市', N'NULL', 3, N'511123', N'JianWeiXian', N'LeShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2114', N'井研县', N'2_244', N'乐山市', N'NULL', 3, N'511124', N'JingYanXian', N'LeShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2115', N'夹江县', N'2_244', N'乐山市', N'NULL', 3, N'511126', N'JiaJiangXian', N'LeShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2116', N'沐川县', N'2_244', N'乐山市', N'NULL', 3, N'511129', N'MuChuanXian', N'LeShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2117', N'峨边彝族自治县', N'2_244', N'乐山市', N'NULL', 3, N'511132', N'EBianYiZuZiZhiXian', N'LeShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2118', N'马边彝族自治县', N'2_244', N'乐山市', N'NULL', 3, N'511133', N'MaBianYiZuZiZhiXian', N'LeShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2119', N'峨眉山市', N'2_244', N'乐山市', N'NULL', 3, N'511181', N'EMeiShanShi', N'LeShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_212', N'尖草坪区', N'2_14', N'太原市', N'NULL', 3, N'140108', N'JianCaoPingQu', N'TaiYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2120', N'顺庆区', N'2_245', N'南充市', N'NULL', 3, N'511302', N'ShunQingQu', N'NanChongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2121', N'高坪区', N'2_245', N'南充市', N'NULL', 3, N'511303', N'GaoPingQu', N'NanChongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2122', N'嘉陵区', N'2_245', N'南充市', N'NULL', 3, N'511304', N'JiaLingQu', N'NanChongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2123', N'南部县', N'2_245', N'南充市', N'NULL', 3, N'511321', N'NanBuXian', N'NanChongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2124', N'营山县', N'2_245', N'南充市', N'NULL', 3, N'511322', N'YingShanXian', N'NanChongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2125', N'蓬安县', N'2_245', N'南充市', N'NULL', 3, N'511323', N'PengAnXian', N'NanChongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2126', N'仪陇县', N'2_245', N'南充市', N'NULL', 3, N'511324', N'YiLongXian', N'NanChongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2127', N'西充县', N'2_245', N'南充市', N'NULL', 3, N'511325', N'XiChongXian', N'NanChongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2128', N'阆中市', N'2_245', N'南充市', N'NULL', 3, N'511381', N'LangZhongShi', N'NanChongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2129', N'东坡区', N'2_246', N'眉山市', N'NULL', 3, N'511402', N'DongPoQu', N'MeiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_213', N'万柏林区', N'2_14', N'太原市', N'NULL', 3, N'140109', N'WanBaiLinQu', N'TaiYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2130', N'仁寿县', N'2_246', N'眉山市', N'NULL', 3, N'511421', N'RenShouXian', N'MeiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2131', N'彭山县', N'2_246', N'眉山市', N'NULL', 3, N'511422', N'PengShanXian', N'MeiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2132', N'洪雅县', N'2_246', N'眉山市', N'NULL', 3, N'511423', N'HongYaXian', N'MeiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2133', N'丹棱县', N'2_246', N'眉山市', N'NULL', 3, N'511424', N'DanLengXian', N'MeiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2134', N'青神县', N'2_246', N'眉山市', N'NULL', 3, N'511425', N'QingShenXian', N'MeiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2135', N'翠屏区', N'2_247', N'宜宾市', N'NULL', 3, N'511502', N'CuiPingQu', N'YiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2136', N'宜宾县', N'2_247', N'宜宾市', N'NULL', 3, N'511521', N'YiBinXian', N'YiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2137', N'南溪县', N'2_247', N'宜宾市', N'NULL', 3, N'511522', N'NanXiXian', N'YiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2138', N'江安县', N'2_247', N'宜宾市', N'NULL', 3, N'511523', N'JiangAnXian', N'YiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2139', N'长宁县', N'2_247', N'宜宾市', N'NULL', 3, N'511524', N'ChangNingXian', N'YiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_214', N'晋源区', N'2_14', N'太原市', N'NULL', 3, N'140110', N'JinYuanQu', N'TaiYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2140', N'高县', N'2_247', N'宜宾市', N'NULL', 3, N'511525', N'GaoXian', N'YiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2141', N'珙县', N'2_247', N'宜宾市', N'NULL', 3, N'511526', N'GongXian', N'YiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2142', N'筠连县', N'2_247', N'宜宾市', N'NULL', 3, N'511527', N'JunLianXian', N'YiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2143', N'兴文县', N'2_247', N'宜宾市', N'NULL', 3, N'511528', N'XingWenXian', N'YiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2144', N'屏山县', N'2_247', N'宜宾市', N'NULL', 3, N'511529', N'PingShanXian', N'YiBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2145', N'广安区', N'2_248', N'广安市', N'NULL', 3, N'511602', N'GuangAnQu', N'GuangAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2146', N'岳池县', N'2_248', N'广安市', N'NULL', 3, N'511621', N'YueChiXian', N'GuangAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2147', N'武胜县', N'2_248', N'广安市', N'NULL', 3, N'511622', N'WuShengXian', N'GuangAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2148', N'邻水县', N'2_248', N'广安市', N'NULL', 3, N'511623', N'LinShuiXian', N'GuangAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2149', N'华蓥市', N'2_248', N'广安市', N'NULL', 3, N'511681', N'HuaYingShi', N'GuangAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_215', N'清徐县', N'2_14', N'太原市', N'NULL', 3, N'140121', N'QingXuXian', N'TaiYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2150', N'通川区', N'2_249', N'达州市', N'NULL', 3, N'511702', N'TongChuanQu', N'DaZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2151', N'达县', N'2_249', N'达州市', N'NULL', 3, N'511721', N'DaXian', N'DaZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2152', N'宣汉县', N'2_249', N'达州市', N'NULL', 3, N'511722', N'XuanHanXian', N'DaZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2153', N'开江县', N'2_249', N'达州市', N'NULL', 3, N'511723', N'KaiJiangXian', N'DaZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2154', N'大竹县', N'2_249', N'达州市', N'NULL', 3, N'511724', N'DaZhuXian', N'DaZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2155', N'渠县', N'2_249', N'达州市', N'NULL', 3, N'511725', N'QuXian', N'DaZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2156', N'万源市', N'2_249', N'达州市', N'NULL', 3, N'511781', N'WanYuanShi', N'DaZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2157', N'雨城区', N'2_250', N'雅安市', N'NULL', 3, N'511802', N'YuChengQu', N'YaAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2158', N'名山县', N'2_250', N'雅安市', N'NULL', 3, N'511821', N'MingShanXian', N'YaAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2159', N'荥经县', N'2_250', N'雅安市', N'NULL', 3, N'511822', N'YingJingXian', N'YaAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_216', N'阳曲县', N'2_14', N'太原市', N'NULL', 3, N'140122', N'YangQuXian', N'TaiYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2160', N'汉源县', N'2_250', N'雅安市', N'NULL', 3, N'511823', N'HanYuanXian', N'YaAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2161', N'石棉县', N'2_250', N'雅安市', N'NULL', 3, N'511824', N'ShiMianXian', N'YaAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2162', N'天全县', N'2_250', N'雅安市', N'NULL', 3, N'511825', N'TianQuanXian', N'YaAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2163', N'芦山县', N'2_250', N'雅安市', N'NULL', 3, N'511826', N'LuShanXian', N'YaAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2164', N'宝兴县', N'2_250', N'雅安市', N'NULL', 3, N'511827', N'BaoXingXian', N'YaAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2165', N'巴州区', N'2_251', N'巴中市', N'NULL', 3, N'511902', N'BaZhouQu', N'BaZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2166', N'通江县', N'2_251', N'巴中市', N'NULL', 3, N'511921', N'TongJiangXian', N'BaZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2167', N'南江县', N'2_251', N'巴中市', N'NULL', 3, N'511922', N'NanJiangXian', N'BaZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2168', N'平昌县', N'2_251', N'巴中市', N'NULL', 3, N'511923', N'PingChangXian', N'BaZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2169', N'雁江区', N'2_252', N'资阳市', N'NULL', 3, N'512002', N'YanJiangQu', N'ZiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_217', N'娄烦县', N'2_14', N'太原市', N'NULL', 3, N'140123', N'LouFanXian', N'TaiYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2170', N'安岳县', N'2_252', N'资阳市', N'NULL', 3, N'512021', N'AnYueXian', N'ZiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2171', N'乐至县', N'2_252', N'资阳市', N'NULL', 3, N'512022', N'LeZhiXian', N'ZiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2172', N'简阳市', N'2_252', N'资阳市', N'NULL', 3, N'512081', N'JianYangShi', N'ZiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2173', N'汶川县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513221', N'WenChuanXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2174', N'理县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513222', N'LiXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2175', N'茂县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513223', N'MaoXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2176', N'松潘县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513224', N'SongPanXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2177', N'九寨沟县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513225', N'JiuZhaiGouXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2178', N'金川县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513226', N'JinChuanXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2179', N'小金县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513227', N'XiaoJinXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_218', N'古交市', N'2_14', N'太原市', N'NULL', 3, N'140181', N'GuJiaoShi', N'TaiYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2180', N'黑水县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513228', N'HeiShuiXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2181', N'马尔康县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513229', N'MaErKangXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2182', N'壤塘县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513230', N'RangTangXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2183', N'阿坝县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513231', N'ABaXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2184', N'若尔盖县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513232', N'RuoErGaiXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2185', N'红原县', N'2_253', N'阿坝藏族羌族自治州', N'NULL', 3, N'513233', N'HongYuanXian', N'ABaCangZuQiangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2186', N'康定县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513321', N'KangDingXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2187', N'泸定县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513322', N'LuDingXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2188', N'丹巴县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513323', N'DanBaXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2189', N'九龙县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513324', N'JiuLongXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_219', N'城区', N'2_15', N'大同市', N'NULL', 3, N'140202', N'ChengQu', N'DaTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2190', N'雅江县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513325', N'YaJiangXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2191', N'道孚县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513326', N'DaoFuXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2192', N'炉霍县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513327', N'LuHuoXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2193', N'甘孜县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513328', N'GanZiXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2194', N'新龙县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513329', N'XinLongXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2195', N'德格县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513330', N'DeGeXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2196', N'白玉县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513331', N'BaiYuXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2197', N'石渠县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513332', N'ShiQuXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2198', N'色达县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513333', N'SeDaXian', N'GanZiCangZuZiZhiZhou')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2199', N'理塘县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513334', N'LiTangXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_22', N'南开区', N'2_2', N'天津市', N'NULL', 3, N'120104', N'NanKaiQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_220', N'矿区', N'2_15', N'大同市', N'NULL', 3, N'140203', N'KuangQu', N'DaTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2200', N'巴塘县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513335', N'BaTangXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2201', N'乡城县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513336', N'XiangChengXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2202', N'稻城县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513337', N'DaoChengXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2203', N'得荣县', N'2_254', N'甘孜藏族自治州', N'NULL', 3, N'513338', N'DeRongXian', N'GanZiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2204', N'西昌市', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513401', N'XiChangShi', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2205', N'木里藏族自治县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513422', N'MuLiCangZuZiZhiXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2206', N'盐源县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513423', N'YanYuanXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2207', N'德昌县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513424', N'DeChangXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2208', N'会理县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513425', N'HuiLiXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2209', N'会东县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513426', N'HuiDongXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_221', N'南郊区', N'2_15', N'大同市', N'NULL', 3, N'140211', N'NanJiaoQu', N'DaTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2210', N'宁南县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513427', N'NingNanXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2211', N'普格县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513428', N'PuGeXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2212', N'布拖县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513429', N'BuTuoXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2213', N'金阳县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513430', N'JinYangXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2214', N'昭觉县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513431', N'ZhaoJueXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2215', N'喜德县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513432', N'XiDeXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2216', N'冕宁县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513433', N'MianNingXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2217', N'越西县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513434', N'YueXiXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2218', N'甘洛县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513435', N'GanLuoXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2219', N'美姑县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513436', N'MeiGuXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_222', N'新荣区', N'2_15', N'大同市', N'NULL', 3, N'140212', N'XinRongQu', N'DaTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2220', N'雷波县', N'2_255', N'凉山彝族自治州', N'NULL', 3, N'513437', N'LeiBoXian', N'LiangShanYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2221', N'南明区', N'2_256', N'贵阳市', N'NULL', 3, N'520102', N'NanMingQu', N'GuiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2222', N'云岩区', N'2_256', N'贵阳市', N'NULL', 3, N'520103', N'YunYanQu', N'GuiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2223', N'花溪区', N'2_256', N'贵阳市', N'NULL', 3, N'520111', N'HuaXiQu', N'GuiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2224', N'乌当区', N'2_256', N'贵阳市', N'NULL', 3, N'520112', N'WuDangQu', N'GuiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2225', N'白云区', N'2_256', N'贵阳市', N'NULL', 3, N'520113', N'BaiYunQu', N'GuiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2226', N'小河区', N'2_256', N'贵阳市', N'NULL', 3, N'520114', N'XiaoHeQu', N'GuiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2227', N'开阳县', N'2_256', N'贵阳市', N'NULL', 3, N'520121', N'KaiYangXian', N'GuiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2228', N'息烽县', N'2_256', N'贵阳市', N'NULL', 3, N'520122', N'XiFengXian', N'GuiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2229', N'修文县', N'2_256', N'贵阳市', N'NULL', 3, N'520123', N'XiuWenXian', N'GuiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_223', N'阳高县', N'2_15', N'大同市', N'NULL', 3, N'140221', N'YangGaoXian', N'DaTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2230', N'清镇市', N'2_256', N'贵阳市', N'NULL', 3, N'520181', N'QingZhenShi', N'GuiYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2231', N'钟山区', N'2_257', N'六盘水市', N'NULL', 3, N'520201', N'ZhongShanQu', N'LiuPanShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2232', N'六枝特区', N'2_257', N'六盘水市', N'NULL', 3, N'520203', N'LiuZhiTeQu', N'LiuPanShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2233', N'水城县', N'2_257', N'六盘水市', N'NULL', 3, N'520221', N'ShuiChengXian', N'LiuPanShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2234', N'盘县', N'2_257', N'六盘水市', N'NULL', 3, N'520222', N'PanXian', N'LiuPanShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2235', N'红花岗区', N'2_258', N'遵义市', N'NULL', 3, N'520302', N'HongHuaGangQu', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2236', N'汇川区', N'2_258', N'遵义市', N'NULL', 3, N'520303', N'HuiChuanQu', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2237', N'遵义县', N'2_258', N'遵义市', N'NULL', 3, N'520321', N'ZunYiXian', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2238', N'桐梓县', N'2_258', N'遵义市', N'NULL', 3, N'520322', N'TongZiXian', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2239', N'绥阳县', N'2_258', N'遵义市', N'NULL', 3, N'520323', N'SuiYangXian', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_224', N'天镇县', N'2_15', N'大同市', N'NULL', 3, N'140222', N'TianZhenXian', N'DaTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2240', N'正安县', N'2_258', N'遵义市', N'NULL', 3, N'520324', N'ZhengAnXian', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2241', N'道真仡佬族苗族自治县', N'2_258', N'遵义市', N'NULL', 3, N'520325', N'DaoZhenYiLaoZuMiaoZuZiZhiXian', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2242', N'务川仡佬族苗族自治县', N'2_258', N'遵义市', N'NULL', 3, N'520326', N'WuChuanYiLaoZuMiaoZuZiZhiXian', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2243', N'凤冈县', N'2_258', N'遵义市', N'NULL', 3, N'520327', N'FengGangXian', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2244', N'湄潭县', N'2_258', N'遵义市', N'NULL', 3, N'520328', N'MeiTanXian', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2245', N'余庆县', N'2_258', N'遵义市', N'NULL', 3, N'520329', N'YuQingXian', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2246', N'习水县', N'2_258', N'遵义市', N'NULL', 3, N'520330', N'XiShuiXian', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2247', N'赤水市', N'2_258', N'遵义市', N'NULL', 3, N'520381', N'ChiShuiShi', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2248', N'仁怀市', N'2_258', N'遵义市', N'NULL', 3, N'520382', N'RenHuaiShi', N'ZunYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2249', N'西秀区', N'2_259', N'安顺市', N'NULL', 3, N'520402', N'XiXiuQu', N'AnShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_225', N'广灵县', N'2_15', N'大同市', N'NULL', 3, N'140223', N'GuangLingXian', N'DaTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2250', N'平坝县', N'2_259', N'安顺市', N'NULL', 3, N'520421', N'PingBaXian', N'AnShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2251', N'普定县', N'2_259', N'安顺市', N'NULL', 3, N'520422', N'PuDingXian', N'AnShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2252', N'镇宁布依族苗族自治县', N'2_259', N'安顺市', N'NULL', 3, N'520423', N'ZhenNingBuYiZuMiaoZuZiZhiXian', N'AnShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2253', N'关岭布依族苗族自治县', N'2_259', N'安顺市', N'NULL', 3, N'520424', N'GuanLingBuYiZuMiaoZuZiZhiXian', N'AnShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2254', N'紫云苗族布依族自治县', N'2_259', N'安顺市', N'NULL', 3, N'520425', N'ZiYunMiaoZuBuYiZuZiZhiXian', N'AnShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2255', N'铜仁市', N'2_260', N'铜仁地区', N'NULL', 3, N'522201', N'TongRenShi', N'TongRenDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2256', N'江口县', N'2_260', N'铜仁地区', N'NULL', 3, N'522222', N'JiangKouXian', N'TongRenDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2257', N'玉屏侗族自治县', N'2_260', N'铜仁地区', N'NULL', 3, N'522223', N'YuPingDongZuZiZhiXian', N'TongRenDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2258', N'石阡县', N'2_260', N'铜仁地区', N'NULL', 3, N'522224', N'ShiQianXian', N'TongRenDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2259', N'思南县', N'2_260', N'铜仁地区', N'NULL', 3, N'522225', N'SiNanXian', N'TongRenDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_226', N'灵丘县', N'2_15', N'大同市', N'NULL', 3, N'140224', N'LingQiuXian', N'DaTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2260', N'印江土家族苗族自治县', N'2_260', N'铜仁地区', N'NULL', 3, N'522226', N'YinJiangTuJiaZuMiaoZuZiZhiXian', N'TongRenDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2261', N'德江县', N'2_260', N'铜仁地区', N'NULL', 3, N'522227', N'DeJiangXian', N'TongRenDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2262', N'沿河土家族自治县', N'2_260', N'铜仁地区', N'NULL', 3, N'522228', N'YanHeTuJiaZuZiZhiXian', N'TongRenDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2263', N'松桃苗族自治县', N'2_260', N'铜仁地区', N'NULL', 3, N'522229', N'SongTaoMiaoZuZiZhiXian', N'TongRenDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2264', N'万山特区', N'2_260', N'铜仁地区', N'NULL', 3, N'522230', N'WanShanTeQu', N'TongRenDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2265', N'兴义市', N'2_261', N'黔西南布依族苗族自治州', N'NULL', 3, N'522301', N'XingYiShi', N'QianXiNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2266', N'兴仁县', N'2_261', N'黔西南布依族苗族自治州', N'NULL', 3, N'522322', N'XingRenXian', N'QianXiNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2267', N'普安县', N'2_261', N'黔西南布依族苗族自治州', N'NULL', 3, N'522323', N'PuAnXian', N'QianXiNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2268', N'晴隆县', N'2_261', N'黔西南布依族苗族自治州', N'NULL', 3, N'522324', N'QingLongXian', N'QianXiNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2269', N'贞丰县', N'2_261', N'黔西南布依族苗族自治州', N'NULL', 3, N'522325', N'ZhenFengXian', N'QianXiNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_227', N'浑源县', N'2_15', N'大同市', N'NULL', 3, N'140225', N'HunYuanXian', N'DaTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2270', N'望谟县', N'2_261', N'黔西南布依族苗族自治州', N'NULL', 3, N'522326', N'WangMoXian', N'QianXiNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2271', N'册亨县', N'2_261', N'黔西南布依族苗族自治州', N'NULL', 3, N'522327', N'CeHengXian', N'QianXiNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2272', N'安龙县', N'2_261', N'黔西南布依族苗族自治州', N'NULL', 3, N'522328', N'AnLongXian', N'QianXiNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2273', N'毕节市', N'2_262', N'毕节地区', N'NULL', 3, N'522401', N'BiJieShi', N'BiJieDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2274', N'大方县', N'2_262', N'毕节地区', N'NULL', 3, N'522422', N'DaFangXian', N'BiJieDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2275', N'黔西县', N'2_262', N'毕节地区', N'NULL', 3, N'522423', N'QianXiXian', N'BiJieDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2276', N'金沙县', N'2_262', N'毕节地区', N'NULL', 3, N'522424', N'JinShaXian', N'BiJieDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2277', N'织金县', N'2_262', N'毕节地区', N'NULL', 3, N'522425', N'ZhiJinXian', N'BiJieDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2278', N'纳雍县', N'2_262', N'毕节地区', N'NULL', 3, N'522426', N'NaYongXian', N'BiJieDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2279', N'威宁彝族回族苗族自治县', N'2_262', N'毕节地区', N'NULL', 3, N'522427', N'WeiNingYiZuHuiZuMiaoZuZiZhiXian', N'BiJieDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_228', N'左云县', N'2_15', N'大同市', N'NULL', 3, N'140226', N'ZuoYunXian', N'DaTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2280', N'赫章县', N'2_262', N'毕节地区', N'NULL', 3, N'522428', N'HeZhangXian', N'BiJieDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2281', N'凯里市', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522601', N'KaiLiShi', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2282', N'黄平县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522622', N'HuangPingXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2283', N'施秉县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522623', N'ShiBingXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2284', N'三穗县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522624', N'SanSuiXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2285', N'镇远县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522625', N'ZhenYuanXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2286', N'岑巩县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522626', N'CenGongXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2287', N'天柱县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522627', N'TianZhuXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2288', N'锦屏县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522628', N'JinPingXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2289', N'剑河县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522629', N'JianHeXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_229', N'大同县', N'2_15', N'大同市', N'NULL', 3, N'140227', N'DaTongXian', N'DaTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2290', N'台江县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522630', N'TaiJiangXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2291', N'黎平县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522631', N'LiPingXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2292', N'榕江县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522632', N'RongJiangXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2293', N'从江县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522633', N'CongJiangXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2294', N'雷山县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522634', N'LeiShanXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2295', N'麻江县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522635', N'MaJiangXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2296', N'丹寨县', N'2_263', N'黔东南苗族侗族自治州', N'NULL', 3, N'522636', N'DanZhaiXian', N'QianDongNanMiaoZuDongZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2297', N'都匀市', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522701', N'DouYunShi', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2298', N'福泉市', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522702', N'FuQuanShi', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2299', N'荔波县', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522722', N'LiBoXian', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_23', N'河北区', N'2_2', N'天津市', N'NULL', 3, N'120105', N'HeBeiQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_230', N'城区', N'2_16', N'阳泉市', N'NULL', 3, N'140302', N'ChengQu', N'YangQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2300', N'贵定县', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522723', N'GuiDingXian', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2301', N'瓮安县', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522725', N'WengAnXian', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2302', N'独山县', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522726', N'DuShanXian', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2303', N'平塘县', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522727', N'PingTangXian', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2304', N'罗甸县', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522728', N'LuoDianXian', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2305', N'长顺县', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522729', N'ChangShunXian', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2306', N'龙里县', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522730', N'LongLiXian', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2307', N'惠水县', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522731', N'HuiShuiXian', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2308', N'三都水族自治县', N'2_264', N'黔南布依族苗族自治州', N'NULL', 3, N'522732', N'SanDouShuiZuZiZhiXian', N'QianNanBuYiZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2309', N'五华区', N'2_265', N'昆明市', N'NULL', 3, N'530102', N'WuHuaQu', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_231', N'矿区', N'2_16', N'阳泉市', N'NULL', 3, N'140303', N'KuangQu', N'YangQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2310', N'盘龙区', N'2_265', N'昆明市', N'NULL', 3, N'530103', N'PanLongQu', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2311', N'官渡区', N'2_265', N'昆明市', N'NULL', 3, N'530111', N'GuanDuQu', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2312', N'西山区', N'2_265', N'昆明市', N'NULL', 3, N'530112', N'XiShanQu', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2313', N'东川区', N'2_265', N'昆明市', N'NULL', 3, N'530113', N'DongChuanQu', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2314', N'呈贡县', N'2_265', N'昆明市', N'NULL', 3, N'530121', N'ChengGongXian', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2315', N'晋宁县', N'2_265', N'昆明市', N'NULL', 3, N'530122', N'JinNingXian', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2316', N'富民县', N'2_265', N'昆明市', N'NULL', 3, N'530124', N'FuMinXian', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2317', N'宜良县', N'2_265', N'昆明市', N'NULL', 3, N'530125', N'YiLiangXian', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2318', N'石林彝族自治县', N'2_265', N'昆明市', N'NULL', 3, N'530126', N'ShiLinYiZuZiZhiXian', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2319', N'嵩明县', N'2_265', N'昆明市', N'NULL', 3, N'530127', N'SongMingXian', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_232', N'郊区', N'2_16', N'阳泉市', N'NULL', 3, N'140311', N'JiaoQu', N'YangQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2320', N'禄劝彝族苗族自治县', N'2_265', N'昆明市', N'NULL', 3, N'530128', N'LuQuanYiZuMiaoZuZiZhiXian', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2321', N'寻甸回族彝族自治县', N'2_265', N'昆明市', N'NULL', 3, N'530129', N'XunDianHuiZuYiZuZiZhiXian', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2322', N'安宁市', N'2_265', N'昆明市', N'NULL', 3, N'530181', N'AnNingShi', N'KunMingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2323', N'麒麟区', N'2_266', N'曲靖市', N'NULL', 3, N'530302', N'QiLinQu', N'QuJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2324', N'马龙县', N'2_266', N'曲靖市', N'NULL', 3, N'530321', N'MaLongXian', N'QuJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2325', N'陆良县', N'2_266', N'曲靖市', N'NULL', 3, N'530322', N'LuLiangXian', N'QuJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2326', N'师宗县', N'2_266', N'曲靖市', N'NULL', 3, N'530323', N'ShiZongXian', N'QuJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2327', N'罗平县', N'2_266', N'曲靖市', N'NULL', 3, N'530324', N'LuoPingXian', N'QuJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2328', N'富源县', N'2_266', N'曲靖市', N'NULL', 3, N'530325', N'FuYuanXian', N'QuJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2329', N'会泽县', N'2_266', N'曲靖市', N'NULL', 3, N'530326', N'HuiZeXian', N'QuJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_233', N'平定县', N'2_16', N'阳泉市', N'NULL', 3, N'140321', N'PingDingXian', N'YangQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2330', N'沾益县', N'2_266', N'曲靖市', N'NULL', 3, N'530328', N'ZhanYiXian', N'QuJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2331', N'宣威市', N'2_266', N'曲靖市', N'NULL', 3, N'530381', N'XuanWeiShi', N'QuJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2332', N'红塔区', N'2_267', N'玉溪市', N'NULL', 3, N'530402', N'HongTaQu', N'YuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2333', N'江川县', N'2_267', N'玉溪市', N'NULL', 3, N'530421', N'JiangChuanXian', N'YuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2334', N'澄江县', N'2_267', N'玉溪市', N'NULL', 3, N'530422', N'ChengJiangXian', N'YuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2335', N'通海县', N'2_267', N'玉溪市', N'NULL', 3, N'530423', N'TongHaiXian', N'YuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2336', N'华宁县', N'2_267', N'玉溪市', N'NULL', 3, N'530424', N'HuaNingXian', N'YuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2337', N'易门县', N'2_267', N'玉溪市', N'NULL', 3, N'530425', N'YiMenXian', N'YuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2338', N'峨山彝族自治县', N'2_267', N'玉溪市', N'NULL', 3, N'530426', N'EShanYiZuZiZhiXian', N'YuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2339', N'新平彝族傣族自治县', N'2_267', N'玉溪市', N'NULL', 3, N'530427', N'XinPingYiZuDaiZuZiZhiXian', N'YuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_234', N'盂县', N'2_16', N'阳泉市', N'NULL', 3, N'140322', N'YuXian', N'YangQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2340', N'元江哈尼族彝族傣族自治县', N'2_267', N'玉溪市', N'NULL', 3, N'530428', N'YuanJiangHaNiZuYiZuDaiZuZiZhiXian', N'YuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2341', N'隆阳区', N'2_268', N'保山市', N'NULL', 3, N'530502', N'LongYangQu', N'BaoShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2342', N'施甸县', N'2_268', N'保山市', N'NULL', 3, N'530521', N'ShiDianXian', N'BaoShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2343', N'腾冲县', N'2_268', N'保山市', N'NULL', 3, N'530522', N'TengChongXian', N'BaoShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2344', N'龙陵县', N'2_268', N'保山市', N'NULL', 3, N'530523', N'LongLingXian', N'BaoShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2345', N'昌宁县', N'2_268', N'保山市', N'NULL', 3, N'530524', N'ChangNingXian', N'BaoShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2346', N'昭阳区', N'2_269', N'昭通市', N'NULL', 3, N'530602', N'ZhaoYangQu', N'ZhaoTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2347', N'鲁甸县', N'2_269', N'昭通市', N'NULL', 3, N'530621', N'LuDianXian', N'ZhaoTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2348', N'巧家县', N'2_269', N'昭通市', N'NULL', 3, N'530622', N'QiaoJiaXian', N'ZhaoTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2349', N'盐津县', N'2_269', N'昭通市', N'NULL', 3, N'530623', N'YanJinXian', N'ZhaoTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_235', N'城区', N'2_17', N'长治市', N'NULL', 3, N'140402', N'ChengQu', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2350', N'大关县', N'2_269', N'昭通市', N'NULL', 3, N'530624', N'DaGuanXian', N'ZhaoTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2351', N'永善县', N'2_269', N'昭通市', N'NULL', 3, N'530625', N'YongShanXian', N'ZhaoTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2352', N'绥江县', N'2_269', N'昭通市', N'NULL', 3, N'530626', N'SuiJiangXian', N'ZhaoTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2353', N'镇雄县', N'2_269', N'昭通市', N'NULL', 3, N'530627', N'ZhenXiongXian', N'ZhaoTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2354', N'彝良县', N'2_269', N'昭通市', N'NULL', 3, N'530628', N'YiLiangXian', N'ZhaoTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2355', N'威信县', N'2_269', N'昭通市', N'NULL', 3, N'530629', N'WeiXinXian', N'ZhaoTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2356', N'水富县', N'2_269', N'昭通市', N'NULL', 3, N'530630', N'ShuiFuXian', N'ZhaoTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2357', N'古城区', N'2_270', N'丽江市', N'NULL', 3, N'530702', N'GuChengQu', N'LiJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2358', N'玉龙纳西族自治县', N'2_270', N'丽江市', N'NULL', 3, N'530721', N'YuLongNaXiZuZiZhiXian', N'LiJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2359', N'永胜县', N'2_270', N'丽江市', N'NULL', 3, N'530722', N'YongShengXian', N'LiJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_236', N'郊区', N'2_17', N'长治市', N'NULL', 3, N'140411', N'JiaoQu', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2360', N'华坪县', N'2_270', N'丽江市', N'NULL', 3, N'530723', N'HuaPingXian', N'LiJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2361', N'宁蒗彝族自治县', N'2_270', N'丽江市', N'NULL', 3, N'530724', N'NingLangYiZuZiZhiXian', N'LiJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2362', N'翠云区', N'2_271', N'思茅市', N'NULL', 3, N'530802', N'CuiYunQu', N'SiMaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2363', N'普洱哈尼族彝族自治县', N'2_271', N'思茅市', N'NULL', 3, N'530821', N'PuErHaNiZuYiZuZiZhiXian', N'SiMaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2364', N'墨江哈尼族自治县', N'2_271', N'思茅市', N'NULL', 3, N'530822', N'MoJiangHaNiZuZiZhiXian', N'SiMaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2365', N'景东彝族自治县', N'2_271', N'思茅市', N'NULL', 3, N'530823', N'JingDongYiZuZiZhiXian', N'SiMaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2366', N'景谷傣族彝族自治县', N'2_271', N'思茅市', N'NULL', 3, N'530824', N'JingGuDaiZuYiZuZiZhiXian', N'SiMaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2367', N'镇沅彝族哈尼族拉祜族自治县', N'2_271', N'思茅市', N'NULL', 3, N'530825', N'ZhenYuanYiZuHaNiZuLaHuZuZiZhiXian', N'SiMaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2368', N'江城哈尼族彝族自治县', N'2_271', N'思茅市', N'NULL', 3, N'530826', N'JiangChengHaNiZuYiZuZiZhiXian', N'SiMaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2369', N'孟连傣族拉祜族佤族自治县', N'2_271', N'思茅市', N'NULL', 3, N'530827', N'MengLianDaiZuLaHuZuWaZuZiZhiXian', N'SiMaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_237', N'长治县', N'2_17', N'长治市', N'NULL', 3, N'140421', N'ChangZhiXian', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2370', N'澜沧拉祜族自治县', N'2_271', N'思茅市', N'NULL', 3, N'530828', N'LanCangLaHuZuZiZhiXian', N'SiMaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2371', N'西盟佤族自治县', N'2_271', N'思茅市', N'NULL', 3, N'530829', N'XiMengWaZuZiZhiXian', N'SiMaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2372', N'临翔区', N'2_272', N'临沧市', N'NULL', 3, N'530902', N'LinXiangQu', N'LinCangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2373', N'凤庆县', N'2_272', N'临沧市', N'NULL', 3, N'530921', N'FengQingXian', N'LinCangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2374', N'云县', N'2_272', N'临沧市', N'NULL', 3, N'530922', N'YunXian', N'LinCangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2375', N'永德县', N'2_272', N'临沧市', N'NULL', 3, N'530923', N'YongDeXian', N'LinCangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2376', N'镇康县', N'2_272', N'临沧市', N'NULL', 3, N'530924', N'ZhenKangXian', N'LinCangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2377', N'双江拉祜族佤族布朗族傣族自治县', N'2_272', N'临沧市', N'NULL', 3, N'530925', N'ShuangJiangLaHuZuWaZuBuLangZuDaiZuZiZhiXian', N'LinCangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2378', N'耿马傣族佤族自治县', N'2_272', N'临沧市', N'NULL', 3, N'530926', N'GengMaDaiZuWaZuZiZhiXian', N'LinCangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2379', N'沧源佤族自治县', N'2_272', N'临沧市', N'NULL', 3, N'530927', N'CangYuanWaZuZiZhiXian', N'LinCangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_238', N'襄垣县', N'2_17', N'长治市', N'NULL', 3, N'140423', N'XiangYuanXian', N'ChangZhiShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2380', N'楚雄市', N'2_273', N'楚雄彝族自治州', N'NULL', 3, N'532301', N'ChuXiongShi', N'ChuXiongYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2381', N'双柏县', N'2_273', N'楚雄彝族自治州', N'NULL', 3, N'532322', N'ShuangBaiXian', N'ChuXiongYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2382', N'牟定县', N'2_273', N'楚雄彝族自治州', N'NULL', 3, N'532323', N'MouDingXian', N'ChuXiongYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2383', N'南华县', N'2_273', N'楚雄彝族自治州', N'NULL', 3, N'532324', N'NanHuaXian', N'ChuXiongYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2384', N'姚安县', N'2_273', N'楚雄彝族自治州', N'NULL', 3, N'532325', N'YaoAnXian', N'ChuXiongYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2385', N'大姚县', N'2_273', N'楚雄彝族自治州', N'NULL', 3, N'532326', N'DaYaoXian', N'ChuXiongYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2386', N'永仁县', N'2_273', N'楚雄彝族自治州', N'NULL', 3, N'532327', N'YongRenXian', N'ChuXiongYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2387', N'元谋县', N'2_273', N'楚雄彝族自治州', N'NULL', 3, N'532328', N'YuanMouXian', N'ChuXiongYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2388', N'武定县', N'2_273', N'楚雄彝族自治州', N'NULL', 3, N'532329', N'WuDingXian', N'ChuXiongYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2389', N'禄丰县', N'2_273', N'楚雄彝族自治州', N'NULL', 3, N'532331', N'LuFengXian', N'ChuXiongYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_239', N'屯留县', N'2_17', N'长治市', N'NULL', 3, N'140424', N'TunLiuXian', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2390', N'个旧市', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532501', N'GeJiuShi', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2391', N'开远市', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532502', N'KaiYuanShi', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2392', N'蒙自县', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532522', N'MengZiXian', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2393', N'屏边苗族自治县', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532523', N'PingBianMiaoZuZiZhiXian', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2394', N'建水县', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532524', N'JianShuiXian', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2395', N'石屏县', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532525', N'ShiPingXian', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2396', N'弥勒县', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532526', N'MiLeXian', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2397', N'泸西县', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532527', N'LuXiXian', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2398', N'元阳县', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532528', N'YuanYangXian', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2399', N'红河县', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532529', N'HongHeXian', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_24', N'红桥区', N'2_2', N'天津市', N'NULL', 3, N'120106', N'HongQiaoQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_240', N'平顺县', N'2_17', N'长治市', N'NULL', 3, N'140425', N'PingShunXian', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2400', N'金平苗族瑶族傣族自治县', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532530', N'JinPingMiaoZuYaoZuDaiZuZiZhiXian', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2401', N'绿春县', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532531', N'LvChunXian', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2402', N'河口瑶族自治县', N'2_274', N'红河哈尼族彝族自治州', N'NULL', 3, N'532532', N'HeKouYaoZuZiZhiXian', N'HongHeHaNiZuYiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2403', N'文山县', N'2_275', N'文山壮族苗族自治州', N'NULL', 3, N'532621', N'WenShanXian', N'WenShanZhuangZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2404', N'砚山县', N'2_275', N'文山壮族苗族自治州', N'NULL', 3, N'532622', N'YanShanXian', N'WenShanZhuangZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2405', N'西畴县', N'2_275', N'文山壮族苗族自治州', N'NULL', 3, N'532623', N'XiChouXian', N'WenShanZhuangZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2406', N'麻栗坡县', N'2_275', N'文山壮族苗族自治州', N'NULL', 3, N'532624', N'MaLiPoXian', N'WenShanZhuangZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2407', N'马关县', N'2_275', N'文山壮族苗族自治州', N'NULL', 3, N'532625', N'MaGuanXian', N'WenShanZhuangZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2408', N'丘北县', N'2_275', N'文山壮族苗族自治州', N'NULL', 3, N'532626', N'QiuBeiXian', N'WenShanZhuangZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2409', N'广南县', N'2_275', N'文山壮族苗族自治州', N'NULL', 3, N'532627', N'GuangNanXian', N'WenShanZhuangZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_241', N'黎城县', N'2_17', N'长治市', N'NULL', 3, N'140426', N'LiChengXian', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2410', N'富宁县', N'2_275', N'文山壮族苗族自治州', N'NULL', 3, N'532628', N'FuNingXian', N'WenShanZhuangZuMiaoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2411', N'景洪市', N'2_276', N'西双版纳傣族自治州', N'NULL', 3, N'532801', N'JingHongShi', N'XiShuangBanNaDaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2412', N'勐海县', N'2_276', N'西双版纳傣族自治州', N'NULL', 3, N'532822', N'MengHaiXian', N'XiShuangBanNaDaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2413', N'勐腊县', N'2_276', N'西双版纳傣族自治州', N'NULL', 3, N'532823', N'MengLaXian', N'XiShuangBanNaDaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2414', N'大理市', N'2_277', N'大理白族自治州', N'NULL', 3, N'532901', N'DaLiShi', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2415', N'漾濞彝族自治县', N'2_277', N'大理白族自治州', N'NULL', 3, N'532922', N'YangBiYiZuZiZhiXian', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2416', N'祥云县', N'2_277', N'大理白族自治州', N'NULL', 3, N'532923', N'XiangYunXian', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2417', N'宾川县', N'2_277', N'大理白族自治州', N'NULL', 3, N'532924', N'BinChuanXian', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2418', N'弥渡县', N'2_277', N'大理白族自治州', N'NULL', 3, N'532925', N'MiDuXian', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2419', N'南涧彝族自治县', N'2_277', N'大理白族自治州', N'NULL', 3, N'532926', N'NanJianYiZuZiZhiXian', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_242', N'壶关县', N'2_17', N'长治市', N'NULL', 3, N'140427', N'HuGuanXian', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2420', N'巍山彝族回族自治县', N'2_277', N'大理白族自治州', N'NULL', 3, N'532927', N'WeiShanYiZuHuiZuZiZhiXian', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2421', N'永平县', N'2_277', N'大理白族自治州', N'NULL', 3, N'532928', N'YongPingXian', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2422', N'云龙县', N'2_277', N'大理白族自治州', N'NULL', 3, N'532929', N'YunLongXian', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2423', N'洱源县', N'2_277', N'大理白族自治州', N'NULL', 3, N'532930', N'ErYuanXian', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2424', N'剑川县', N'2_277', N'大理白族自治州', N'NULL', 3, N'532931', N'JianChuanXian', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2425', N'鹤庆县', N'2_277', N'大理白族自治州', N'NULL', 3, N'532932', N'HeQingXian', N'DaLiBaiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2426', N'瑞丽市', N'2_278', N'德宏傣族景颇族自治州', N'NULL', 3, N'533102', N'RuiLiShi', N'DeHongDaiZuJingPoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2427', N'潞西市', N'2_278', N'德宏傣族景颇族自治州', N'NULL', 3, N'533103', N'LuXiShi', N'DeHongDaiZuJingPoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2428', N'梁河县', N'2_278', N'德宏傣族景颇族自治州', N'NULL', 3, N'533122', N'LiangHeXian', N'DeHongDaiZuJingPoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2429', N'盈江县', N'2_278', N'德宏傣族景颇族自治州', N'NULL', 3, N'533123', N'YingJiangXian', N'DeHongDaiZuJingPoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_243', N'长子县', N'2_17', N'长治市', N'NULL', 3, N'140428', N'ChangZiXian', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2430', N'陇川县', N'2_278', N'德宏傣族景颇族自治州', N'NULL', 3, N'533124', N'LongChuanXian', N'DeHongDaiZuJingPoZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2431', N'泸水县', N'2_279', N'怒江傈僳族自治州', N'NULL', 3, N'533321', N'LuShuiXian', N'NuJiangLiSuZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2432', N'福贡县', N'2_279', N'怒江傈僳族自治州', N'NULL', 3, N'533323', N'FuGongXian', N'NuJiangLiSuZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2433', N'贡山独龙族怒族自治县', N'2_279', N'怒江傈僳族自治州', N'NULL', 3, N'533324', N'GongShanDuLongZuNuZuZiZhiXian', N'NuJiangLiSuZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2434', N'兰坪白族普米族自治县', N'2_279', N'怒江傈僳族自治州', N'NULL', 3, N'533325', N'LanPingBaiZuPuMiZuZiZhiXian', N'NuJiangLiSuZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2435', N'香格里拉县', N'2_280', N'迪庆藏族自治州', N'NULL', 3, N'533421', N'XiangGeLiLaXian', N'DiQingCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2436', N'德钦县', N'2_280', N'迪庆藏族自治州', N'NULL', 3, N'533422', N'DeQinXian', N'DiQingCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2437', N'维西傈僳族自治县', N'2_280', N'迪庆藏族自治州', N'NULL', 3, N'533423', N'WeiXiLiSuZuZiZhiXian', N'DiQingCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2438', N'城关区', N'2_281', N'拉萨市', N'NULL', 3, N'540102', N'ChengGuanQu', N'LaSaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2439', N'林周县', N'2_281', N'拉萨市', N'NULL', 3, N'540121', N'LinZhouXian', N'LaSaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_244', N'武乡县', N'2_17', N'长治市', N'NULL', 3, N'140429', N'WuXiangXian', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2440', N'当雄县', N'2_281', N'拉萨市', N'NULL', 3, N'540122', N'DangXiongXian', N'LaSaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2441', N'尼木县', N'2_281', N'拉萨市', N'NULL', 3, N'540123', N'NiMuXian', N'LaSaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2442', N'曲水县', N'2_281', N'拉萨市', N'NULL', 3, N'540124', N'QuShuiXian', N'LaSaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2443', N'堆龙德庆县', N'2_281', N'拉萨市', N'NULL', 3, N'540125', N'DuiLongDeQingXian', N'LaSaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2444', N'达孜县', N'2_281', N'拉萨市', N'NULL', 3, N'540126', N'DaZiXian', N'LaSaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2445', N'墨竹工卡县', N'2_281', N'拉萨市', N'NULL', 3, N'540127', N'MoZhuGongKaXian', N'LaSaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2446', N'昌都县', N'2_282', N'昌都地区', N'NULL', 3, N'542121', N'ChangDouXian', N'ChangDouDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2447', N'江达县', N'2_282', N'昌都地区', N'NULL', 3, N'542122', N'JiangDaXian', N'ChangDouDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2448', N'贡觉县', N'2_282', N'昌都地区', N'NULL', 3, N'542123', N'GongJueXian', N'ChangDouDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2449', N'类乌齐县', N'2_282', N'昌都地区', N'NULL', 3, N'542124', N'LeiWuQiXian', N'ChangDouDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_245', N'沁县', N'2_17', N'长治市', N'NULL', 3, N'140430', N'QinXian', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2450', N'丁青县', N'2_282', N'昌都地区', N'NULL', 3, N'542125', N'DingQingXian', N'ChangDouDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2451', N'察雅县', N'2_282', N'昌都地区', N'NULL', 3, N'542126', N'ChaYaXian', N'ChangDouDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2452', N'八宿县', N'2_282', N'昌都地区', N'NULL', 3, N'542127', N'BaSuXian', N'ChangDouDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2453', N'左贡县', N'2_282', N'昌都地区', N'NULL', 3, N'542128', N'ZuoGongXian', N'ChangDouDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2454', N'芒康县', N'2_282', N'昌都地区', N'NULL', 3, N'542129', N'MangKangXian', N'ChangDouDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2455', N'洛隆县', N'2_282', N'昌都地区', N'NULL', 3, N'542132', N'LuoLongXian', N'ChangDouDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2456', N'边坝县', N'2_282', N'昌都地区', N'NULL', 3, N'542133', N'BianBaXian', N'ChangDouDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2457', N'乃东县', N'2_283', N'山南地区', N'NULL', 3, N'542221', N'NaiDongXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2458', N'扎囊县', N'2_283', N'山南地区', N'NULL', 3, N'542222', N'ZhaNangXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2459', N'贡嘎县', N'2_283', N'山南地区', N'NULL', 3, N'542223', N'GongGaXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_246', N'沁源县', N'2_17', N'长治市', N'NULL', 3, N'140431', N'QinYuanXian', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2460', N'桑日县', N'2_283', N'山南地区', N'NULL', 3, N'542224', N'SangRiXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2461', N'琼结县', N'2_283', N'山南地区', N'NULL', 3, N'542225', N'QiongJieXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2462', N'曲松县', N'2_283', N'山南地区', N'NULL', 3, N'542226', N'QuSongXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2463', N'措美县', N'2_283', N'山南地区', N'NULL', 3, N'542227', N'CuoMeiXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2464', N'洛扎县', N'2_283', N'山南地区', N'NULL', 3, N'542228', N'LuoZhaXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2465', N'加查县', N'2_283', N'山南地区', N'NULL', 3, N'542229', N'JiaChaXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2466', N'隆子县', N'2_283', N'山南地区', N'NULL', 3, N'542231', N'LongZiXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2467', N'错那县', N'2_283', N'山南地区', N'NULL', 3, N'542232', N'CuoNaXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2468', N'浪卡子县', N'2_283', N'山南地区', N'NULL', 3, N'542233', N'LangKaZiXian', N'ShanNanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2469', N'日喀则市', N'2_284', N'日喀则地区', N'NULL', 3, N'542301', N'RiKaZeShi', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_247', N'潞城市', N'2_17', N'长治市', N'NULL', 3, N'140481', N'LuChengShi', N'ChangZhiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2470', N'南木林县', N'2_284', N'日喀则地区', N'NULL', 3, N'542322', N'NanMuLinXian', N'RiKaZeDiQu')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2471', N'江孜县', N'2_284', N'日喀则地区', N'NULL', 3, N'542323', N'JiangZiXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2472', N'定日县', N'2_284', N'日喀则地区', N'NULL', 3, N'542324', N'DingRiXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2473', N'萨迦县', N'2_284', N'日喀则地区', N'NULL', 3, N'542325', N'SaJiaXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2474', N'拉孜县', N'2_284', N'日喀则地区', N'NULL', 3, N'542326', N'LaZiXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2475', N'昂仁县', N'2_284', N'日喀则地区', N'NULL', 3, N'542327', N'AngRenXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2476', N'谢通门县', N'2_284', N'日喀则地区', N'NULL', 3, N'542328', N'XieTongMenXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2477', N'白朗县', N'2_284', N'日喀则地区', N'NULL', 3, N'542329', N'BaiLangXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2478', N'仁布县', N'2_284', N'日喀则地区', N'NULL', 3, N'542330', N'RenBuXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2479', N'康马县', N'2_284', N'日喀则地区', N'NULL', 3, N'542331', N'KangMaXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_248', N'城区', N'2_18', N'晋城市', N'NULL', 3, N'140502', N'ChengQu', N'JinChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2480', N'定结县', N'2_284', N'日喀则地区', N'NULL', 3, N'542332', N'DingJieXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2481', N'仲巴县', N'2_284', N'日喀则地区', N'NULL', 3, N'542333', N'ZhongBaXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2482', N'亚东县', N'2_284', N'日喀则地区', N'NULL', 3, N'542334', N'YaDongXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2483', N'吉隆县', N'2_284', N'日喀则地区', N'NULL', 3, N'542335', N'JiLongXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2484', N'聂拉木县', N'2_284', N'日喀则地区', N'NULL', 3, N'542336', N'NieLaMuXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2485', N'萨嘎县', N'2_284', N'日喀则地区', N'NULL', 3, N'542337', N'SaGaXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2486', N'岗巴县', N'2_284', N'日喀则地区', N'NULL', 3, N'542338', N'GangBaXian', N'RiKaZeDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2487', N'那曲县', N'2_285', N'那曲地区', N'NULL', 3, N'542421', N'NaQuXian', N'NaQuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2488', N'嘉黎县', N'2_285', N'那曲地区', N'NULL', 3, N'542422', N'JiaLiXian', N'NaQuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2489', N'比如县', N'2_285', N'那曲地区', N'NULL', 3, N'542423', N'BiRuXian', N'NaQuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_249', N'沁水县', N'2_18', N'晋城市', N'NULL', 3, N'140521', N'QinShuiXian', N'JinChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2490', N'聂荣县', N'2_285', N'那曲地区', N'NULL', 3, N'542424', N'NieRongXian', N'NaQuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2491', N'安多县', N'2_285', N'那曲地区', N'NULL', 3, N'542425', N'AnDuoXian', N'NaQuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2492', N'申扎县', N'2_285', N'那曲地区', N'NULL', 3, N'542426', N'ShenZhaXian', N'NaQuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2493', N'索县', N'2_285', N'那曲地区', N'NULL', 3, N'542427', N'SuoXian', N'NaQuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2494', N'班戈县', N'2_285', N'那曲地区', N'NULL', 3, N'542428', N'BanGeXian', N'NaQuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2495', N'巴青县', N'2_285', N'那曲地区', N'NULL', 3, N'542429', N'BaQingXian', N'NaQuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2496', N'尼玛县', N'2_285', N'那曲地区', N'NULL', 3, N'542430', N'NiMaXian', N'NaQuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2497', N'普兰县', N'2_286', N'阿里地区', N'NULL', 3, N'542521', N'PuLanXian', N'ALiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2498', N'札达县', N'2_286', N'阿里地区', N'NULL', 3, N'542522', N'ZhaDaXian', N'ALiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2499', N'噶尔县', N'2_286', N'阿里地区', N'NULL', 3, N'542523', N'GaErXian', N'ALiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_25', N'塘沽区', N'2_2', N'天津市', N'NULL', 3, N'120107', N'TangGuQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_250', N'阳城县', N'2_18', N'晋城市', N'NULL', 3, N'140522', N'YangChengXian', N'JinChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2500', N'日土县', N'2_286', N'阿里地区', N'NULL', 3, N'542524', N'RiTuXian', N'ALiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2501', N'革吉县', N'2_286', N'阿里地区', N'NULL', 3, N'542525', N'GeJiXian', N'ALiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2502', N'改则县', N'2_286', N'阿里地区', N'NULL', 3, N'542526', N'GaiZeXian', N'ALiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2503', N'措勤县', N'2_286', N'阿里地区', N'NULL', 3, N'542527', N'CuoQinXian', N'ALiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2504', N'林芝县', N'2_287', N'林芝地区', N'NULL', 3, N'542621', N'LinZhiXian', N'LinZhiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2505', N'工布江达县', N'2_287', N'林芝地区', N'NULL', 3, N'542622', N'GongBuJiangDaXian', N'LinZhiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2506', N'米林县', N'2_287', N'林芝地区', N'NULL', 3, N'542623', N'MiLinXian', N'LinZhiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2507', N'墨脱县', N'2_287', N'林芝地区', N'NULL', 3, N'542624', N'MoTuoXian', N'LinZhiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2508', N'波密县', N'2_287', N'林芝地区', N'NULL', 3, N'542625', N'BoMiXian', N'LinZhiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2509', N'察隅县', N'2_287', N'林芝地区', N'NULL', 3, N'542626', N'ChaYuXian', N'LinZhiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_251', N'陵川县', N'2_18', N'晋城市', N'NULL', 3, N'140524', N'LingChuanXian', N'JinChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2510', N'朗县', N'2_287', N'林芝地区', N'NULL', 3, N'542627', N'LangXian', N'LinZhiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2511', N'新城区', N'2_288', N'西安市', N'NULL', 3, N'610102', N'XinChengQu', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2512', N'碑林区', N'2_288', N'西安市', N'NULL', 3, N'610103', N'BeiLinQu', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2513', N'莲湖区', N'2_288', N'西安市', N'NULL', 3, N'610104', N'LianHuQu', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2514', N'灞桥区', N'2_288', N'西安市', N'NULL', 3, N'610111', N'BaQiaoQu', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2515', N'未央区', N'2_288', N'西安市', N'NULL', 3, N'610112', N'WeiYangQu', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2516', N'雁塔区', N'2_288', N'西安市', N'NULL', 3, N'610113', N'YanTaQu', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2517', N'阎良区', N'2_288', N'西安市', N'NULL', 3, N'610114', N'YanLiangQu', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2518', N'临潼区', N'2_288', N'西安市', N'NULL', 3, N'610115', N'LinTongQu', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2519', N'长安区', N'2_288', N'西安市', N'NULL', 3, N'610116', N'ChangAnQu', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_252', N'泽州县', N'2_18', N'晋城市', N'NULL', 3, N'140525', N'ZeZhouXian', N'JinChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2520', N'蓝田县', N'2_288', N'西安市', N'NULL', 3, N'610122', N'LanTianXian', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2521', N'周至县', N'2_288', N'西安市', N'NULL', 3, N'610124', N'ZhouZhiXian', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2522', N'户县', N'2_288', N'西安市', N'NULL', 3, N'610125', N'HuXian', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2523', N'高陵县', N'2_288', N'西安市', N'NULL', 3, N'610126', N'GaoLingXian', N'XiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2524', N'王益区', N'2_289', N'铜川市', N'NULL', 3, N'610202', N'WangYiQu', N'TongChuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2525', N'印台区', N'2_289', N'铜川市', N'NULL', 3, N'610203', N'YinTaiQu', N'TongChuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2526', N'耀州区', N'2_289', N'铜川市', N'NULL', 3, N'610204', N'YaoZhouQu', N'TongChuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2527', N'宜君县', N'2_289', N'铜川市', N'NULL', 3, N'610222', N'YiJunXian', N'TongChuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2528', N'渭滨区', N'2_290', N'宝鸡市', N'NULL', 3, N'610302', N'WeiBinQu', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2529', N'金台区', N'2_290', N'宝鸡市', N'NULL', 3, N'610303', N'JinTaiQu', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_253', N'高平市', N'2_18', N'晋城市', N'NULL', 3, N'140581', N'GaoPingShi', N'JinChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2530', N'陈仓区', N'2_290', N'宝鸡市', N'NULL', 3, N'610304', N'ChenCangQu', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2531', N'凤翔县', N'2_290', N'宝鸡市', N'NULL', 3, N'610322', N'FengXiangXian', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2532', N'岐山县', N'2_290', N'宝鸡市', N'NULL', 3, N'610323', N'QiShanXian', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2533', N'扶风县', N'2_290', N'宝鸡市', N'NULL', 3, N'610324', N'FuFengXian', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2534', N'眉县', N'2_290', N'宝鸡市', N'NULL', 3, N'610326', N'MeiXian', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2535', N'陇县', N'2_290', N'宝鸡市', N'NULL', 3, N'610327', N'LongXian', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2536', N'千阳县', N'2_290', N'宝鸡市', N'NULL', 3, N'610328', N'QianYangXian', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2537', N'麟游县', N'2_290', N'宝鸡市', N'NULL', 3, N'610329', N'LinYouXian', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2538', N'凤县', N'2_290', N'宝鸡市', N'NULL', 3, N'610330', N'FengXian', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2539', N'太白县', N'2_290', N'宝鸡市', N'NULL', 3, N'610331', N'TaiBaiXian', N'BaoJiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_254', N'朔城区', N'2_19', N'朔州市', N'NULL', 3, N'140602', N'ShuoChengQu', N'ShuoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2540', N'秦都区', N'2_291', N'咸阳市', N'NULL', 3, N'610402', N'QinDouQu', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2541', N'杨凌区', N'2_291', N'咸阳市', N'NULL', 3, N'610403', N'YangLingQu', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2542', N'渭城区', N'2_291', N'咸阳市', N'NULL', 3, N'610404', N'WeiChengQu', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2543', N'三原县', N'2_291', N'咸阳市', N'NULL', 3, N'610422', N'SanYuanXian', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2544', N'泾阳县', N'2_291', N'咸阳市', N'NULL', 3, N'610423', N'JingYangXian', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2545', N'乾县', N'2_291', N'咸阳市', N'NULL', 3, N'610424', N'QianXian', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2546', N'礼泉县', N'2_291', N'咸阳市', N'NULL', 3, N'610425', N'LiQuanXian', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2547', N'永寿县', N'2_291', N'咸阳市', N'NULL', 3, N'610426', N'YongShouXian', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2548', N'彬县', N'2_291', N'咸阳市', N'NULL', 3, N'610427', N'BinXian', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2549', N'长武县', N'2_291', N'咸阳市', N'NULL', 3, N'610428', N'ChangWuXian', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_255', N'平鲁区', N'2_19', N'朔州市', N'NULL', 3, N'140603', N'PingLuQu', N'ShuoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2550', N'旬邑县', N'2_291', N'咸阳市', N'NULL', 3, N'610429', N'XunYiXian', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2551', N'淳化县', N'2_291', N'咸阳市', N'NULL', 3, N'610430', N'ChunHuaXian', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2552', N'武功县', N'2_291', N'咸阳市', N'NULL', 3, N'610431', N'WuGongXian', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2553', N'兴平市', N'2_291', N'咸阳市', N'NULL', 3, N'610481', N'XingPingShi', N'XianYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2554', N'临渭区', N'2_292', N'渭南市', N'NULL', 3, N'610502', N'LinWeiQu', N'WeiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2555', N'华县', N'2_292', N'渭南市', N'NULL', 3, N'610521', N'HuaXian', N'WeiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2556', N'潼关县', N'2_292', N'渭南市', N'NULL', 3, N'610522', N'TongGuanXian', N'WeiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2557', N'大荔县', N'2_292', N'渭南市', N'NULL', 3, N'610523', N'DaLiXian', N'WeiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2558', N'合阳县', N'2_292', N'渭南市', N'NULL', 3, N'610524', N'HeYangXian', N'WeiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2559', N'澄城县', N'2_292', N'渭南市', N'NULL', 3, N'610525', N'ChengChengXian', N'WeiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_256', N'山阴县', N'2_19', N'朔州市', N'NULL', 3, N'140621', N'ShanYinXian', N'ShuoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2560', N'蒲城县', N'2_292', N'渭南市', N'NULL', 3, N'610526', N'PuChengXian', N'WeiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2561', N'白水县', N'2_292', N'渭南市', N'NULL', 3, N'610527', N'BaiShuiXian', N'WeiNanShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2562', N'富平县', N'2_292', N'渭南市', N'NULL', 3, N'610528', N'FuPingXian', N'WeiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2563', N'韩城市', N'2_292', N'渭南市', N'NULL', 3, N'610581', N'HanChengShi', N'WeiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2564', N'华阴市', N'2_292', N'渭南市', N'NULL', 3, N'610582', N'HuaYinShi', N'WeiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2565', N'宝塔区', N'2_293', N'延安市', N'NULL', 3, N'610602', N'BaoTaQu', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2566', N'延长县', N'2_293', N'延安市', N'NULL', 3, N'610621', N'YanChangXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2567', N'延川县', N'2_293', N'延安市', N'NULL', 3, N'610622', N'YanChuanXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2568', N'子长县', N'2_293', N'延安市', N'NULL', 3, N'610623', N'ZiChangXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2569', N'安塞县', N'2_293', N'延安市', N'NULL', 3, N'610624', N'AnSaiXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_257', N'应县', N'2_19', N'朔州市', N'NULL', 3, N'140622', N'YingXian', N'ShuoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2570', N'志丹县', N'2_293', N'延安市', N'NULL', 3, N'610625', N'ZhiDanXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2571', N'吴起县', N'2_293', N'延安市', N'NULL', 3, N'610626', N'WuQiXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2572', N'甘泉县', N'2_293', N'延安市', N'NULL', 3, N'610627', N'GanQuanXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2573', N'富县', N'2_293', N'延安市', N'NULL', 3, N'610628', N'FuXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2574', N'洛川县', N'2_293', N'延安市', N'NULL', 3, N'610629', N'LuoChuanXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2575', N'宜川县', N'2_293', N'延安市', N'NULL', 3, N'610630', N'YiChuanXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2576', N'黄龙县', N'2_293', N'延安市', N'NULL', 3, N'610631', N'HuangLongXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2577', N'黄陵县', N'2_293', N'延安市', N'NULL', 3, N'610632', N'HuangLingXian', N'YanAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2578', N'汉台区', N'2_294', N'汉中市', N'NULL', 3, N'610702', N'HanTaiQu', N'HanZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2579', N'南郑县', N'2_294', N'汉中市', N'NULL', 3, N'610721', N'NanZhengXian', N'HanZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_258', N'右玉县', N'2_19', N'朔州市', N'NULL', 3, N'140623', N'YouYuXian', N'ShuoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2580', N'城固县', N'2_294', N'汉中市', N'NULL', 3, N'610722', N'ChengGuXian', N'HanZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2581', N'洋县', N'2_294', N'汉中市', N'NULL', 3, N'610723', N'YangXian', N'HanZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2582', N'西乡县', N'2_294', N'汉中市', N'NULL', 3, N'610724', N'XiXiangXian', N'HanZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2583', N'勉县', N'2_294', N'汉中市', N'NULL', 3, N'610725', N'MianXian', N'HanZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2584', N'宁强县', N'2_294', N'汉中市', N'NULL', 3, N'610726', N'NingQiangXian', N'HanZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2585', N'略阳县', N'2_294', N'汉中市', N'NULL', 3, N'610727', N'LueYangXian', N'HanZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2586', N'镇巴县', N'2_294', N'汉中市', N'NULL', 3, N'610728', N'ZhenBaXian', N'HanZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2587', N'留坝县', N'2_294', N'汉中市', N'NULL', 3, N'610729', N'LiuBaXian', N'HanZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2588', N'佛坪县', N'2_294', N'汉中市', N'NULL', 3, N'610730', N'FoPingXian', N'HanZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2589', N'榆阳区', N'2_295', N'榆林市', N'NULL', 3, N'610802', N'YuYangQu', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_259', N'怀仁县', N'2_19', N'朔州市', N'NULL', 3, N'140624', N'HuaiRenXian', N'ShuoZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2590', N'神木县', N'2_295', N'榆林市', N'NULL', 3, N'610821', N'ShenMuXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2591', N'府谷县', N'2_295', N'榆林市', N'NULL', 3, N'610822', N'FuGuXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2592', N'横山县', N'2_295', N'榆林市', N'NULL', 3, N'610823', N'HengShanXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2593', N'靖边县', N'2_295', N'榆林市', N'NULL', 3, N'610824', N'JingBianXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2594', N'定边县', N'2_295', N'榆林市', N'NULL', 3, N'610825', N'DingBianXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2595', N'绥德县', N'2_295', N'榆林市', N'NULL', 3, N'610826', N'SuiDeXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2596', N'米脂县', N'2_295', N'榆林市', N'NULL', 3, N'610827', N'MiZhiXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2597', N'佳县', N'2_295', N'榆林市', N'NULL', 3, N'610828', N'JiaXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2598', N'吴堡县', N'2_295', N'榆林市', N'NULL', 3, N'610829', N'WuBaoXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2599', N'清涧县', N'2_295', N'榆林市', N'NULL', 3, N'610830', N'QingJianXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_26', N'汉沽区', N'2_2', N'天津市', N'NULL', 3, N'120108', N'HanGuQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_260', N'榆次区', N'2_20', N'晋中市', N'NULL', 3, N'140702', N'YuCiQu', N'JinZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2600', N'子洲县', N'2_295', N'榆林市', N'NULL', 3, N'610831', N'ZiZhouXian', N'YuLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2601', N'汉滨区', N'2_296', N'安康市', N'NULL', 3, N'610902', N'HanBinQu', N'AnKangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2602', N'汉阴县', N'2_296', N'安康市', N'NULL', 3, N'610921', N'HanYinXian', N'AnKangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2603', N'石泉县', N'2_296', N'安康市', N'NULL', 3, N'610922', N'ShiQuanXian', N'AnKangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2604', N'宁陕县', N'2_296', N'安康市', N'NULL', 3, N'610923', N'NingShanXian', N'AnKangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2605', N'紫阳县', N'2_296', N'安康市', N'NULL', 3, N'610924', N'ZiYangXian', N'AnKangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2606', N'岚皋县', N'2_296', N'安康市', N'NULL', 3, N'610925', N'LanGaoXian', N'AnKangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2607', N'平利县', N'2_296', N'安康市', N'NULL', 3, N'610926', N'PingLiXian', N'AnKangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2608', N'镇坪县', N'2_296', N'安康市', N'NULL', 3, N'610927', N'ZhenPingXian', N'AnKangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2609', N'旬阳县', N'2_296', N'安康市', N'NULL', 3, N'610928', N'XunYangXian', N'AnKangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_261', N'榆社县', N'2_20', N'晋中市', N'NULL', 3, N'140721', N'YuSheXian', N'JinZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2610', N'白河县', N'2_296', N'安康市', N'NULL', 3, N'610929', N'BaiHeXian', N'AnKangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2611', N'商州区', N'2_297', N'商洛市', N'NULL', 3, N'611002', N'ShangZhouQu', N'ShangLuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2612', N'洛南县', N'2_297', N'商洛市', N'NULL', 3, N'611021', N'LuoNanXian', N'ShangLuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2613', N'丹凤县', N'2_297', N'商洛市', N'NULL', 3, N'611022', N'DanFengXian', N'ShangLuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2614', N'商南县', N'2_297', N'商洛市', N'NULL', 3, N'611023', N'ShangNanXian', N'ShangLuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2615', N'山阳县', N'2_297', N'商洛市', N'NULL', 3, N'611024', N'ShanYangXian', N'ShangLuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2616', N'镇安县', N'2_297', N'商洛市', N'NULL', 3, N'611025', N'ZhenAnXian', N'ShangLuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2617', N'柞水县', N'2_297', N'商洛市', N'NULL', 3, N'611026', N'ZuoShuiXian', N'ShangLuoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2618', N'城关区', N'2_298', N'兰州市', N'NULL', 3, N'620102', N'ChengGuanQu', N'LanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2619', N'七里河区', N'2_298', N'兰州市', N'NULL', 3, N'620103', N'QiLiHeQu', N'LanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_262', N'左权县', N'2_20', N'晋中市', N'NULL', 3, N'140722', N'ZuoQuanXian', N'JinZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2620', N'西固区', N'2_298', N'兰州市', N'NULL', 3, N'620104', N'XiGuQu', N'LanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2621', N'安宁区', N'2_298', N'兰州市', N'NULL', 3, N'620105', N'AnNingQu', N'LanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2622', N'红古区', N'2_298', N'兰州市', N'NULL', 3, N'620111', N'HongGuQu', N'LanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2623', N'永登县', N'2_298', N'兰州市', N'NULL', 3, N'620121', N'YongDengXian', N'LanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2624', N'皋兰县', N'2_298', N'兰州市', N'NULL', 3, N'620122', N'GaoLanXian', N'LanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2625', N'榆中县', N'2_298', N'兰州市', N'NULL', 3, N'620123', N'YuZhongXian', N'LanZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2626', N'金川区', N'2_300', N'金昌市', N'NULL', 3, N'620302', N'JinChuanQu', N'JinChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2627', N'永昌县', N'2_300', N'金昌市', N'NULL', 3, N'620321', N'YongChangXian', N'JinChangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2628', N'白银区', N'2_301', N'白银市', N'NULL', 3, N'620402', N'BaiYinQu', N'BaiYinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2629', N'平川区', N'2_301', N'白银市', N'NULL', 3, N'620403', N'PingChuanQu', N'BaiYinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_263', N'和顺县', N'2_20', N'晋中市', N'NULL', 3, N'140723', N'HeShunXian', N'JinZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2630', N'靖远县', N'2_301', N'白银市', N'NULL', 3, N'620421', N'JingYuanXian', N'BaiYinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2631', N'会宁县', N'2_301', N'白银市', N'NULL', 3, N'620422', N'HuiNingXian', N'BaiYinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2632', N'景泰县', N'2_301', N'白银市', N'NULL', 3, N'620423', N'JingTaiXian', N'BaiYinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2633', N'秦城区', N'2_302', N'天水市', N'NULL', 3, N'620502', N'QinChengQu', N'TianShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2634', N'北道区', N'2_302', N'天水市', N'NULL', 3, N'620503', N'BeiDaoQu', N'TianShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2635', N'清水县', N'2_302', N'天水市', N'NULL', 3, N'620521', N'QingShuiXian', N'TianShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2636', N'秦安县', N'2_302', N'天水市', N'NULL', 3, N'620522', N'QinAnXian', N'TianShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2637', N'甘谷县', N'2_302', N'天水市', N'NULL', 3, N'620523', N'GanGuXian', N'TianShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2638', N'武山县', N'2_302', N'天水市', N'NULL', 3, N'620524', N'WuShanXian', N'TianShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2639', N'张家川回族自治县', N'2_302', N'天水市', N'NULL', 3, N'620525', N'ZhangJiaChuanHuiZuZiZhiXian', N'TianShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_264', N'昔阳县', N'2_20', N'晋中市', N'NULL', 3, N'140724', N'XiYangXian', N'JinZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2640', N'凉州区', N'2_303', N'武威市', N'NULL', 3, N'620602', N'LiangZhouQu', N'WuWeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2641', N'民勤县', N'2_303', N'武威市', N'NULL', 3, N'620621', N'MinQinXian', N'WuWeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2642', N'古浪县', N'2_303', N'武威市', N'NULL', 3, N'620622', N'GuLangXian', N'WuWeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2643', N'天祝藏族自治县', N'2_303', N'武威市', N'NULL', 3, N'620623', N'TianZhuCangZuZiZhiXian', N'WuWeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2644', N'甘州区', N'2_304', N'张掖市', N'NULL', 3, N'620702', N'GanZhouQu', N'ZhangYeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2645', N'肃南裕固族自治县', N'2_304', N'张掖市', N'NULL', 3, N'620721', N'SuNanYuGuZuZiZhiXian', N'ZhangYeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2646', N'民乐县', N'2_304', N'张掖市', N'NULL', 3, N'620722', N'MinLeXian', N'ZhangYeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2647', N'临泽县', N'2_304', N'张掖市', N'NULL', 3, N'620723', N'LinZeXian', N'ZhangYeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2648', N'高台县', N'2_304', N'张掖市', N'NULL', 3, N'620724', N'GaoTaiXian', N'ZhangYeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2649', N'山丹县', N'2_304', N'张掖市', N'NULL', 3, N'620725', N'ShanDanXian', N'ZhangYeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_265', N'寿阳县', N'2_20', N'晋中市', N'NULL', 3, N'140725', N'ShouYangXian', N'JinZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2650', N'崆峒区', N'2_305', N'平凉市', N'NULL', 3, N'620802', N'KongDongQu', N'PingLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2651', N'泾川县', N'2_305', N'平凉市', N'NULL', 3, N'620821', N'JingChuanXian', N'PingLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2652', N'灵台县', N'2_305', N'平凉市', N'NULL', 3, N'620822', N'LingTaiXian', N'PingLiangShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2653', N'崇信县', N'2_305', N'平凉市', N'NULL', 3, N'620823', N'ChongXinXian', N'PingLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2654', N'华亭县', N'2_305', N'平凉市', N'NULL', 3, N'620824', N'HuaTingXian', N'PingLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2655', N'庄浪县', N'2_305', N'平凉市', N'NULL', 3, N'620825', N'ZhuangLangXian', N'PingLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2656', N'静宁县', N'2_305', N'平凉市', N'NULL', 3, N'620826', N'JingNingXian', N'PingLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2657', N'肃州区', N'2_306', N'酒泉市', N'NULL', 3, N'620902', N'SuZhouQu', N'JiuQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2658', N'金塔县', N'2_306', N'酒泉市', N'NULL', 3, N'620921', N'JinTaXian', N'JiuQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2659', N'瓜州县', N'2_306', N'酒泉市', N'NULL', 3, N'620922', N'GuaZhouXian', N'JiuQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_266', N'太谷县', N'2_20', N'晋中市', N'NULL', 3, N'140726', N'TaiGuXian', N'JinZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2660', N'肃北蒙古族自治县', N'2_306', N'酒泉市', N'NULL', 3, N'620923', N'SuBeiMengGuZuZiZhiXian', N'JiuQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2661', N'阿克塞哈萨克族自治县', N'2_306', N'酒泉市', N'NULL', 3, N'620924', N'AKeSaiHaSaKeZuZiZhiXian', N'JiuQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2662', N'玉门市', N'2_306', N'酒泉市', N'NULL', 3, N'620981', N'YuMenShi', N'JiuQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2663', N'敦煌市', N'2_306', N'酒泉市', N'NULL', 3, N'620982', N'DunHuangShi', N'JiuQuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2664', N'西峰区', N'2_307', N'庆阳市', N'NULL', 3, N'621002', N'XiFengQu', N'QingYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2665', N'庆城县', N'2_307', N'庆阳市', N'NULL', 3, N'621021', N'QingChengXian', N'QingYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2666', N'环县', N'2_307', N'庆阳市', N'NULL', 3, N'621022', N'HuanXian', N'QingYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2667', N'华池县', N'2_307', N'庆阳市', N'NULL', 3, N'621023', N'HuaChiXian', N'QingYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2668', N'合水县', N'2_307', N'庆阳市', N'NULL', 3, N'621024', N'HeShuiXian', N'QingYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2669', N'正宁县', N'2_307', N'庆阳市', N'NULL', 3, N'621025', N'ZhengNingXian', N'QingYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_267', N'祁县', N'2_20', N'晋中市', N'NULL', 3, N'140727', N'QiXian', N'JinZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2670', N'宁县', N'2_307', N'庆阳市', N'NULL', 3, N'621026', N'NingXian', N'QingYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2671', N'镇原县', N'2_307', N'庆阳市', N'NULL', 3, N'621027', N'ZhenYuanXian', N'QingYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2672', N'安定区', N'2_308', N'定西市', N'NULL', 3, N'621102', N'AnDingQu', N'DingXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2673', N'通渭县', N'2_308', N'定西市', N'NULL', 3, N'621121', N'TongWeiXian', N'DingXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2674', N'陇西县', N'2_308', N'定西市', N'NULL', 3, N'621122', N'LongXiXian', N'DingXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2675', N'渭源县', N'2_308', N'定西市', N'NULL', 3, N'621123', N'WeiYuanXian', N'DingXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2676', N'临洮县', N'2_308', N'定西市', N'NULL', 3, N'621124', N'LinTaoXian', N'DingXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2677', N'漳县', N'2_308', N'定西市', N'NULL', 3, N'621125', N'ZhangXian', N'DingXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2678', N'岷县', N'2_308', N'定西市', N'NULL', 3, N'621126', N'MinXian', N'DingXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2679', N'武都区', N'2_309', N'陇南市', N'NULL', 3, N'621202', N'WuDouQu', N'LongNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_268', N'平遥县', N'2_20', N'晋中市', N'NULL', 3, N'140728', N'PingYaoXian', N'JinZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2680', N'成县', N'2_309', N'陇南市', N'NULL', 3, N'621221', N'ChengXian', N'LongNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2681', N'文县', N'2_309', N'陇南市', N'NULL', 3, N'621222', N'WenXian', N'LongNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2682', N'宕昌县', N'2_309', N'陇南市', N'NULL', 3, N'621223', N'DangChangXian', N'LongNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2683', N'康县', N'2_309', N'陇南市', N'NULL', 3, N'621224', N'KangXian', N'LongNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2684', N'西和县', N'2_309', N'陇南市', N'NULL', 3, N'621225', N'XiHeXian', N'LongNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2685', N'礼县', N'2_309', N'陇南市', N'NULL', 3, N'621226', N'LiXian', N'LongNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2686', N'徽县', N'2_309', N'陇南市', N'NULL', 3, N'621227', N'HuiXian', N'LongNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2687', N'两当县', N'2_309', N'陇南市', N'NULL', 3, N'621228', N'LiangDangXian', N'LongNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2688', N'临夏市', N'2_310', N'临夏回族自治州', N'NULL', 3, N'622901', N'LinXiaShi', N'LinXiaHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2689', N'临夏县', N'2_310', N'临夏回族自治州', N'NULL', 3, N'622921', N'LinXiaXian', N'LinXiaHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_269', N'灵石县', N'2_20', N'晋中市', N'NULL', 3, N'140729', N'LingShiXian', N'JinZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2690', N'康乐县', N'2_310', N'临夏回族自治州', N'NULL', 3, N'622922', N'KangLeXian', N'LinXiaHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2691', N'永靖县', N'2_310', N'临夏回族自治州', N'NULL', 3, N'622923', N'YongJingXian', N'LinXiaHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2692', N'广河县', N'2_310', N'临夏回族自治州', N'NULL', 3, N'622924', N'GuangHeXian', N'LinXiaHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2693', N'和政县', N'2_310', N'临夏回族自治州', N'NULL', 3, N'622925', N'HeZhengXian', N'LinXiaHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2694', N'东乡族自治县', N'2_310', N'临夏回族自治州', N'NULL', 3, N'622926', N'DongXiangZuZiZhiXian', N'LinXiaHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2695', N'积石山保安族东乡族撒拉族自治县', N'2_310', N'临夏回族自治州', N'NULL', 3, N'622927', N'JiShiShanBaoAnZuDongXiangZuSaLaZuZiZhiXian', N'LinXiaHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2696', N'合作市', N'2_311', N'甘南藏族自治州', N'NULL', 3, N'623001', N'HeZuoShi', N'GanNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2697', N'临潭县', N'2_311', N'甘南藏族自治州', N'NULL', 3, N'623021', N'LinTanXian', N'GanNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2698', N'卓尼县', N'2_311', N'甘南藏族自治州', N'NULL', 3, N'623022', N'ZhuoNiXian', N'GanNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2699', N'舟曲县', N'2_311', N'甘南藏族自治州', N'NULL', 3, N'623023', N'ZhouQuXian', N'GanNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_27', N'大港区', N'2_2', N'天津市', N'NULL', 3, N'120109', N'DaGangQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_270', N'介休市', N'2_20', N'晋中市', N'NULL', 3, N'140781', N'JieXiuShi', N'JinZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2700', N'迭部县', N'2_311', N'甘南藏族自治州', N'NULL', 3, N'623024', N'DieBuXian', N'GanNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2701', N'玛曲县', N'2_311', N'甘南藏族自治州', N'NULL', 3, N'623025', N'MaQuXian', N'GanNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2702', N'碌曲县', N'2_311', N'甘南藏族自治州', N'NULL', 3, N'623026', N'LuQuXian', N'GanNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2703', N'夏河县', N'2_311', N'甘南藏族自治州', N'NULL', 3, N'623027', N'XiaHeXian', N'GanNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2704', N'城东区', N'2_312', N'西宁市', N'NULL', 3, N'630102', N'ChengDongQu', N'XiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2705', N'城中区', N'2_312', N'西宁市', N'NULL', 3, N'630103', N'ChengZhongQu', N'XiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2706', N'城西区', N'2_312', N'西宁市', N'NULL', 3, N'630104', N'ChengXiQu', N'XiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2707', N'城北区', N'2_312', N'西宁市', N'NULL', 3, N'630105', N'ChengBeiQu', N'XiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2708', N'大通回族土族自治县', N'2_312', N'西宁市', N'NULL', 3, N'630121', N'DaTongHuiZuTuZuZiZhiXian', N'XiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2709', N'湟中县', N'2_312', N'西宁市', N'NULL', 3, N'630122', N'HuangZhongXian', N'XiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_271', N'盐湖区', N'2_21', N'运城市', N'NULL', 3, N'140802', N'YanHuQu', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2710', N'湟源县', N'2_312', N'西宁市', N'NULL', 3, N'630123', N'HuangYuanXian', N'XiNingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2711', N'平安县', N'2_313', N'海东地区', N'NULL', 3, N'632121', N'PingAnXian', N'HaiDongDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2712', N'民和回族土族自治县', N'2_313', N'海东地区', N'NULL', 3, N'632122', N'MinHeHuiZuTuZuZiZhiXian', N'HaiDongDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2713', N'乐都县', N'2_313', N'海东地区', N'NULL', 3, N'632123', N'LeDouXian', N'HaiDongDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2714', N'互助土族自治县', N'2_313', N'海东地区', N'NULL', 3, N'632126', N'HuZhuTuZuZiZhiXian', N'HaiDongDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2715', N'化隆回族自治县', N'2_313', N'海东地区', N'NULL', 3, N'632127', N'HuaLongHuiZuZiZhiXian', N'HaiDongDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2716', N'循化撒拉族自治县', N'2_313', N'海东地区', N'NULL', 3, N'632128', N'XunHuaSaLaZuZiZhiXian', N'HaiDongDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2717', N'门源回族自治县', N'2_314', N'海北藏族自治州', N'NULL', 3, N'632221', N'MenYuanHuiZuZiZhiXian', N'HaiBeiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2718', N'祁连县', N'2_314', N'海北藏族自治州', N'NULL', 3, N'632222', N'QiLianXian', N'HaiBeiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2719', N'海晏县', N'2_314', N'海北藏族自治州', N'NULL', 3, N'632223', N'HaiYanXian', N'HaiBeiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_272', N'临猗县', N'2_21', N'运城市', N'NULL', 3, N'140821', N'LinYiXian', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2720', N'刚察县', N'2_314', N'海北藏族自治州', N'NULL', 3, N'632224', N'GangChaXian', N'HaiBeiCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2721', N'同仁县', N'2_315', N'黄南藏族自治州', N'NULL', 3, N'632321', N'TongRenXian', N'HuangNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2722', N'尖扎县', N'2_315', N'黄南藏族自治州', N'NULL', 3, N'632322', N'JianZhaXian', N'HuangNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2723', N'泽库县', N'2_315', N'黄南藏族自治州', N'NULL', 3, N'632323', N'ZeKuXian', N'HuangNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2724', N'河南蒙古族自治县', N'2_315', N'黄南藏族自治州', N'NULL', 3, N'632324', N'HeNanMengGuZuZiZhiXian', N'HuangNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2725', N'共和县', N'2_316', N'海南藏族自治州', N'NULL', 3, N'632521', N'GongHeXian', N'HaiNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2726', N'同德县', N'2_316', N'海南藏族自治州', N'NULL', 3, N'632522', N'TongDeXian', N'HaiNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2727', N'贵德县', N'2_316', N'海南藏族自治州', N'NULL', 3, N'632523', N'GuiDeXian', N'HaiNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2728', N'兴海县', N'2_316', N'海南藏族自治州', N'NULL', 3, N'632524', N'XingHaiXian', N'HaiNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2729', N'贵南县', N'2_316', N'海南藏族自治州', N'NULL', 3, N'632525', N'GuiNanXian', N'HaiNanCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_273', N'万荣县', N'2_21', N'运城市', N'NULL', 3, N'140822', N'WanRongXian', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2730', N'玛沁县', N'2_317', N'果洛藏族自治州', N'NULL', 3, N'632621', N'MaQinXian', N'GuoLuoCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2731', N'班玛县', N'2_317', N'果洛藏族自治州', N'NULL', 3, N'632622', N'BanMaXian', N'GuoLuoCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2732', N'甘德县', N'2_317', N'果洛藏族自治州', N'NULL', 3, N'632623', N'GanDeXian', N'GuoLuoCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2733', N'达日县', N'2_317', N'果洛藏族自治州', N'NULL', 3, N'632624', N'DaRiXian', N'GuoLuoCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2734', N'久治县', N'2_317', N'果洛藏族自治州', N'NULL', 3, N'632625', N'JiuZhiXian', N'GuoLuoCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2735', N'玛多县', N'2_317', N'果洛藏族自治州', N'NULL', 3, N'632626', N'MaDuoXian', N'GuoLuoCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2736', N'玉树县', N'2_318', N'玉树藏族自治州', N'NULL', 3, N'632721', N'YuShuXian', N'YuShuCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2737', N'杂多县', N'2_318', N'玉树藏族自治州', N'NULL', 3, N'632722', N'ZaDuoXian', N'YuShuCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2738', N'称多县', N'2_318', N'玉树藏族自治州', N'NULL', 3, N'632723', N'ChenDuoXian', N'YuShuCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2739', N'治多县', N'2_318', N'玉树藏族自治州', N'NULL', 3, N'632724', N'ZhiDuoXian', N'YuShuCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_274', N'闻喜县', N'2_21', N'运城市', N'NULL', 3, N'140823', N'WenXiXian', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2740', N'囊谦县', N'2_318', N'玉树藏族自治州', N'NULL', 3, N'632725', N'NangQianXian', N'YuShuCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2741', N'曲麻莱县', N'2_318', N'玉树藏族自治州', N'NULL', 3, N'632726', N'QuMaLaiXian', N'YuShuCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2742', N'格尔木市', N'2_319', N'海西蒙古族藏族自治州', N'NULL', 3, N'632801', N'GeErMuShi', N'HaiXiMengGuZuCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2743', N'德令哈市', N'2_319', N'海西蒙古族藏族自治州', N'NULL', 3, N'632802', N'DeLingHaShi', N'HaiXiMengGuZuCangZuZiZhiZhou')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2744', N'乌兰县', N'2_319', N'海西蒙古族藏族自治州', N'NULL', 3, N'632821', N'WuLanXian', N'HaiXiMengGuZuCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2745', N'都兰县', N'2_319', N'海西蒙古族藏族自治州', N'NULL', 3, N'632822', N'DouLanXian', N'HaiXiMengGuZuCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2746', N'天峻县', N'2_319', N'海西蒙古族藏族自治州', N'NULL', 3, N'632823', N'TianJunXian', N'HaiXiMengGuZuCangZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2747', N'兴庆区', N'2_320', N'银川市', N'NULL', 3, N'640104', N'XingQingQu', N'YinChuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2748', N'西夏区', N'2_320', N'银川市', N'NULL', 3, N'640105', N'XiXiaQu', N'YinChuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2749', N'金凤区', N'2_320', N'银川市', N'NULL', 3, N'640106', N'JinFengQu', N'YinChuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_275', N'稷山县', N'2_21', N'运城市', N'NULL', 3, N'140824', N'JiShanXian', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2750', N'永宁县', N'2_320', N'银川市', N'NULL', 3, N'640121', N'YongNingXian', N'YinChuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2751', N'贺兰县', N'2_320', N'银川市', N'NULL', 3, N'640122', N'HeLanXian', N'YinChuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2752', N'灵武市', N'2_320', N'银川市', N'NULL', 3, N'640181', N'LingWuShi', N'YinChuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2753', N'大武口区', N'2_321', N'石嘴山市', N'NULL', 3, N'640202', N'DaWuKouQu', N'ShiZuiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2754', N'惠农区', N'2_321', N'石嘴山市', N'NULL', 3, N'640205', N'HuiNongQu', N'ShiZuiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2755', N'平罗县', N'2_321', N'石嘴山市', N'NULL', 3, N'640221', N'PingLuoXian', N'ShiZuiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2756', N'利通区', N'2_322', N'吴忠市', N'NULL', 3, N'640302', N'LiTongQu', N'WuZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2757', N'盐池县', N'2_322', N'吴忠市', N'NULL', 3, N'640323', N'YanChiXian', N'WuZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2758', N'同心县', N'2_322', N'吴忠市', N'NULL', 3, N'640324', N'TongXinXian', N'WuZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2759', N'青铜峡市', N'2_322', N'吴忠市', N'NULL', 3, N'640381', N'QingTongXiaShi', N'WuZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_276', N'新绛县', N'2_21', N'运城市', N'NULL', 3, N'140825', N'XinJiangXian', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2760', N'原州区', N'2_323', N'固原市', N'NULL', 3, N'640402', N'YuanZhouQu', N'GuYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2761', N'西吉县', N'2_323', N'固原市', N'NULL', 3, N'640422', N'XiJiXian', N'GuYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2762', N'隆德县', N'2_323', N'固原市', N'NULL', 3, N'640423', N'LongDeXian', N'GuYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2763', N'泾源县', N'2_323', N'固原市', N'NULL', 3, N'640424', N'JingYuanXian', N'GuYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2764', N'彭阳县', N'2_323', N'固原市', N'NULL', 3, N'640425', N'PengYangXian', N'GuYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2765', N'沙坡头区', N'2_324', N'中卫市', N'NULL', 3, N'640502', N'ShaPoTouQu', N'ZhongWeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2766', N'中宁县', N'2_324', N'中卫市', N'NULL', 3, N'640521', N'ZhongNingXian', N'ZhongWeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2767', N'海原县', N'2_324', N'中卫市', N'NULL', 3, N'640522', N'HaiYuanXian', N'ZhongWeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2768', N'天山区', N'2_325', N'乌鲁木齐市', N'NULL', 3, N'650102', N'TianShanQu', N'WuLuMuQiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2769', N'沙依巴克区', N'2_325', N'乌鲁木齐市', N'NULL', 3, N'650103', N'ShaYiBaKeQu', N'WuLuMuQiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_277', N'绛县', N'2_21', N'运城市', N'NULL', 3, N'140826', N'JiangXian', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2770', N'新市区', N'2_325', N'乌鲁木齐市', N'NULL', 3, N'650104', N'XinShiQu', N'WuLuMuQiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2771', N'水磨沟区', N'2_325', N'乌鲁木齐市', N'NULL', 3, N'650105', N'ShuiMoGouQu', N'WuLuMuQiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2772', N'头屯河区', N'2_325', N'乌鲁木齐市', N'NULL', 3, N'650106', N'TouTunHeQu', N'WuLuMuQiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2773', N'达坂城区', N'2_325', N'乌鲁木齐市', N'NULL', 3, N'650107', N'DaBanChengQu', N'WuLuMuQiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2774', N'东山区', N'2_325', N'乌鲁木齐市', N'NULL', 3, N'650108', N'DongShanQu', N'WuLuMuQiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2775', N'乌鲁木齐县', N'2_325', N'乌鲁木齐市', N'NULL', 3, N'650121', N'WuLuMuQiXian', N'WuLuMuQiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2776', N'独山子区', N'2_326', N'克拉玛依市', N'NULL', 3, N'650202', N'DuShanZiQu', N'KeLaMaYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2777', N'克拉玛依区', N'2_326', N'克拉玛依市', N'NULL', 3, N'650203', N'KeLaMaYiQu', N'KeLaMaYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2778', N'白碱滩区', N'2_326', N'克拉玛依市', N'NULL', 3, N'650204', N'BaiJianTanQu', N'KeLaMaYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2779', N'乌尔禾区', N'2_326', N'克拉玛依市', N'NULL', 3, N'650205', N'WuErHeQu', N'KeLaMaYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_278', N'垣曲县', N'2_21', N'运城市', N'NULL', 3, N'140827', N'YuanQuXian', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2780', N'吐鲁番市', N'2_327', N'吐鲁番地区', N'NULL', 3, N'652101', N'TuLuFanShi', N'TuLuFanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2781', N'鄯善县', N'2_327', N'吐鲁番地区', N'NULL', 3, N'652122', N'ShanShanXian', N'TuLuFanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2782', N'托克逊县', N'2_327', N'吐鲁番地区', N'NULL', 3, N'652123', N'TuoKeXunXian', N'TuLuFanDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2783', N'哈密市', N'2_328', N'哈密地区', N'NULL', 3, N'652201', N'HaMiShi', N'HaMiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2784', N'巴里坤哈萨克自治县', N'2_328', N'哈密地区', N'NULL', 3, N'652222', N'BaLiKunHaSaKeZiZhiXian', N'HaMiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2785', N'伊吾县', N'2_328', N'哈密地区', N'NULL', 3, N'652223', N'YiWuXian', N'HaMiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2786', N'昌吉市', N'2_329', N'昌吉回族自治州', N'NULL', 3, N'652301', N'ChangJiShi', N'ChangJiHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2787', N'阜康市', N'2_329', N'昌吉回族自治州', N'NULL', 3, N'652302', N'FuKangShi', N'ChangJiHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2788', N'米泉市', N'2_329', N'昌吉回族自治州', N'NULL', 3, N'652303', N'MiQuanShi', N'ChangJiHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2789', N'呼图壁县', N'2_329', N'昌吉回族自治州', N'NULL', 3, N'652323', N'HuTuBiXian', N'ChangJiHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_279', N'夏县', N'2_21', N'运城市', N'NULL', 3, N'140828', N'XiaXian', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2790', N'玛纳斯县', N'2_329', N'昌吉回族自治州', N'NULL', 3, N'652324', N'MaNaSiXian', N'ChangJiHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2791', N'奇台县', N'2_329', N'昌吉回族自治州', N'NULL', 3, N'652325', N'QiTaiXian', N'ChangJiHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2792', N'吉木萨尔县', N'2_329', N'昌吉回族自治州', N'NULL', 3, N'652327', N'JiMuSaErXian', N'ChangJiHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2793', N'木垒哈萨克自治县', N'2_329', N'昌吉回族自治州', N'NULL', 3, N'652328', N'MuLeiHaSaKeZiZhiXian', N'ChangJiHuiZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2794', N'博乐市', N'2_330', N'博尔塔拉蒙古自治州', N'NULL', 3, N'652701', N'BoLeShi', N'BoErTaLaMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2795', N'精河县', N'2_330', N'博尔塔拉蒙古自治州', N'NULL', 3, N'652722', N'JingHeXian', N'BoErTaLaMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2796', N'温泉县', N'2_330', N'博尔塔拉蒙古自治州', N'NULL', 3, N'652723', N'WenQuanXian', N'BoErTaLaMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2797', N'库尔勒市', N'2_331', N'巴音郭楞蒙古自治州', N'NULL', 3, N'652801', N'KuErLeShi', N'BaYinGuoLengMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2798', N'轮台县', N'2_331', N'巴音郭楞蒙古自治州', N'NULL', 3, N'652822', N'LunTaiXian', N'BaYinGuoLengMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2799', N'尉犁县', N'2_331', N'巴音郭楞蒙古自治州', N'NULL', 3, N'652823', N'WeiLiXian', N'BaYinGuoLengMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_28', N'东丽区', N'2_2', N'天津市', N'NULL', 3, N'120110', N'DongLiQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_280', N'平陆县', N'2_21', N'运城市', N'NULL', 3, N'140829', N'PingLuXian', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2800', N'若羌县', N'2_331', N'巴音郭楞蒙古自治州', N'NULL', 3, N'652824', N'RuoQiangXian', N'BaYinGuoLengMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2801', N'且末县', N'2_331', N'巴音郭楞蒙古自治州', N'NULL', 3, N'652825', N'QieMoXian', N'BaYinGuoLengMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2802', N'焉耆回族自治县', N'2_331', N'巴音郭楞蒙古自治州', N'NULL', 3, N'652826', N'YanQiHuiZuZiZhiXian', N'BaYinGuoLengMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2803', N'和静县', N'2_331', N'巴音郭楞蒙古自治州', N'NULL', 3, N'652827', N'HeJingXian', N'BaYinGuoLengMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2804', N'和硕县', N'2_331', N'巴音郭楞蒙古自治州', N'NULL', 3, N'652828', N'HeShuoXian', N'BaYinGuoLengMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2805', N'博湖县', N'2_331', N'巴音郭楞蒙古自治州', N'NULL', 3, N'652829', N'BoHuXian', N'BaYinGuoLengMengGuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2806', N'阿克苏市', N'2_332', N'阿克苏地区', N'NULL', 3, N'652901', N'AKeSuShi', N'AKeSuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2807', N'温宿县', N'2_332', N'阿克苏地区', N'NULL', 3, N'652922', N'WenSuXian', N'AKeSuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2808', N'库车县', N'2_332', N'阿克苏地区', N'NULL', 3, N'652923', N'KuCheXian', N'AKeSuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2809', N'沙雅县', N'2_332', N'阿克苏地区', N'NULL', 3, N'652924', N'ShaYaXian', N'AKeSuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_281', N'芮城县', N'2_21', N'运城市', N'NULL', 3, N'140830', N'RuiChengXian', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2810', N'新和县', N'2_332', N'阿克苏地区', N'NULL', 3, N'652925', N'XinHeXian', N'AKeSuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2811', N'拜城县', N'2_332', N'阿克苏地区', N'NULL', 3, N'652926', N'BaiChengXian', N'AKeSuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2812', N'乌什县', N'2_332', N'阿克苏地区', N'NULL', 3, N'652927', N'WuShiXian', N'AKeSuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2813', N'阿瓦提县', N'2_332', N'阿克苏地区', N'NULL', 3, N'652928', N'AWaTiXian', N'AKeSuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2814', N'柯坪县', N'2_332', N'阿克苏地区', N'NULL', 3, N'652929', N'KePingXian', N'AKeSuDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2815', N'阿图什市', N'2_333', N'克孜勒苏柯尔克孜自治州', N'NULL', 3, N'653001', N'ATuShiShi', N'KeZiLeSuKeErKeZiZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2816', N'阿克陶县', N'2_333', N'克孜勒苏柯尔克孜自治州', N'NULL', 3, N'653022', N'AKeTaoXian', N'KeZiLeSuKeErKeZiZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2817', N'阿合奇县', N'2_333', N'克孜勒苏柯尔克孜自治州', N'NULL', 3, N'653023', N'AHeQiXian', N'KeZiLeSuKeErKeZiZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2818', N'乌恰县', N'2_333', N'克孜勒苏柯尔克孜自治州', N'NULL', 3, N'653024', N'WuQiaXian', N'KeZiLeSuKeErKeZiZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2819', N'喀什市', N'2_334', N'喀什地区', N'NULL', 3, N'653101', N'KaShiShi', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_282', N'永济市', N'2_21', N'运城市', N'NULL', 3, N'140881', N'YongJiShi', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2820', N'疏附县', N'2_334', N'喀什地区', N'NULL', 3, N'653121', N'ShuFuXian', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2821', N'疏勒县', N'2_334', N'喀什地区', N'NULL', 3, N'653122', N'ShuLeXian', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2822', N'英吉沙县', N'2_334', N'喀什地区', N'NULL', 3, N'653123', N'YingJiShaXian', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2823', N'泽普县', N'2_334', N'喀什地区', N'NULL', 3, N'653124', N'ZePuXian', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2824', N'莎车县', N'2_334', N'喀什地区', N'NULL', 3, N'653125', N'ShaCheXian', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2825', N'叶城县', N'2_334', N'喀什地区', N'NULL', 3, N'653126', N'YeChengXian', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2826', N'麦盖提县', N'2_334', N'喀什地区', N'NULL', 3, N'653127', N'MaiGaiTiXian', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2827', N'岳普湖县', N'2_334', N'喀什地区', N'NULL', 3, N'653128', N'YuePuHuXian', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2828', N'伽师县', N'2_334', N'喀什地区', N'NULL', 3, N'653129', N'GaShiXian', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2829', N'巴楚县', N'2_334', N'喀什地区', N'NULL', 3, N'653130', N'BaChuXian', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_283', N'河津市', N'2_21', N'运城市', N'NULL', 3, N'140882', N'HeJinShi', N'YunChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2830', N'塔什库尔干塔吉克自治县', N'2_334', N'喀什地区', N'NULL', 3, N'653131', N'TaShiKuErGanTaJiKeZiZhiXian', N'KaShiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2831', N'和田市', N'2_335', N'和田地区', N'NULL', 3, N'653201', N'HeTianShi', N'HeTianDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2832', N'和田县', N'2_335', N'和田地区', N'NULL', 3, N'653221', N'HeTianXian', N'HeTianDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2833', N'墨玉县', N'2_335', N'和田地区', N'NULL', 3, N'653222', N'MoYuXian', N'HeTianDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2834', N'皮山县', N'2_335', N'和田地区', N'NULL', 3, N'653223', N'PiShanXian', N'HeTianDiQu')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2835', N'洛浦县', N'2_335', N'和田地区', N'NULL', 3, N'653224', N'LuoPuXian', N'HeTianDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2836', N'策勒县', N'2_335', N'和田地区', N'NULL', 3, N'653225', N'CeLeXian', N'HeTianDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2837', N'于田县', N'2_335', N'和田地区', N'NULL', 3, N'653226', N'YuTianXian', N'HeTianDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2838', N'民丰县', N'2_335', N'和田地区', N'NULL', 3, N'653227', N'MinFengXian', N'HeTianDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2839', N'伊宁市', N'2_336', N'伊犁哈萨克自治州', N'NULL', 3, N'654002', N'YiNingShi', N'YiLiHaSaKeZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_284', N'忻府区', N'2_22', N'忻州市', N'NULL', 3, N'140902', N'XinFuQu', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2840', N'奎屯市', N'2_336', N'伊犁哈萨克自治州', N'NULL', 3, N'654003', N'KuiTunShi', N'YiLiHaSaKeZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2841', N'伊宁县', N'2_336', N'伊犁哈萨克自治州', N'NULL', 3, N'654021', N'YiNingXian', N'YiLiHaSaKeZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2842', N'察布查尔锡伯自治县', N'2_336', N'伊犁哈萨克自治州', N'NULL', 3, N'654022', N'ChaBuChaErXiBoZiZhiXian', N'YiLiHaSaKeZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2843', N'霍城县', N'2_336', N'伊犁哈萨克自治州', N'NULL', 3, N'654023', N'HuoChengXian', N'YiLiHaSaKeZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2844', N'巩留县', N'2_336', N'伊犁哈萨克自治州', N'NULL', 3, N'654024', N'GongLiuXian', N'YiLiHaSaKeZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2845', N'新源县', N'2_336', N'伊犁哈萨克自治州', N'NULL', 3, N'654025', N'XinYuanXian', N'YiLiHaSaKeZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2846', N'昭苏县', N'2_336', N'伊犁哈萨克自治州', N'NULL', 3, N'654026', N'ZhaoSuXian', N'YiLiHaSaKeZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2847', N'特克斯县', N'2_336', N'伊犁哈萨克自治州', N'NULL', 3, N'654027', N'TeKeSiXian', N'YiLiHaSaKeZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2848', N'尼勒克县', N'2_336', N'伊犁哈萨克自治州', N'NULL', 3, N'654028', N'NiLeKeXian', N'YiLiHaSaKeZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2849', N'塔城市', N'2_337', N'塔城地区', N'NULL', 3, N'654201', N'TaChengShi', N'TaChengDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_285', N'定襄县', N'2_22', N'忻州市', N'NULL', 3, N'140921', N'DingXiangXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2850', N'乌苏市', N'2_337', N'塔城地区', N'NULL', 3, N'654202', N'WuSuShi', N'TaChengDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2851', N'额敏县', N'2_337', N'塔城地区', N'NULL', 3, N'654221', N'EMinXian', N'TaChengDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2852', N'沙湾县', N'2_337', N'塔城地区', N'NULL', 3, N'654223', N'ShaWanXian', N'TaChengDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2853', N'托里县', N'2_337', N'塔城地区', N'NULL', 3, N'654224', N'TuoLiXian', N'TaChengDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2854', N'裕民县', N'2_337', N'塔城地区', N'NULL', 3, N'654225', N'YuMinXian', N'TaChengDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2855', N'和布克赛尔蒙古自治县', N'2_337', N'塔城地区', N'NULL', 3, N'654226', N'HeBuKeSaiErMengGuZiZhiXian', N'TaChengDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2856', N'阿勒泰市', N'2_338', N'阿勒泰地区', N'NULL', 3, N'654301', N'ALeTaiShi', N'ALeTaiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2857', N'布尔津县', N'2_338', N'阿勒泰地区', N'NULL', 3, N'654321', N'BuErJinXian', N'ALeTaiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2858', N'富蕴县', N'2_338', N'阿勒泰地区', N'NULL', 3, N'654322', N'FuYunXian', N'ALeTaiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2859', N'福海县', N'2_338', N'阿勒泰地区', N'NULL', 3, N'654323', N'FuHaiXian', N'ALeTaiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_286', N'五台县', N'2_22', N'忻州市', N'NULL', 3, N'140922', N'WuTaiXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2860', N'哈巴河县', N'2_338', N'阿勒泰地区', N'NULL', 3, N'654324', N'HaBaHeXian', N'ALeTaiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2861', N'青河县', N'2_338', N'阿勒泰地区', N'NULL', 3, N'654325', N'QingHeXian', N'ALeTaiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2862', N'吉木乃县', N'2_338', N'阿勒泰地区', N'NULL', 3, N'654326', N'JiMuNaiXian', N'ALeTaiDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2863', N'东莞市', N'2_213', N'东莞市', N'NULL', 3, N'441900', N'DongWanShi', N'DongWanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2864', N'中山市', N'2_214', N'中山市', N'NULL', 3, N'442001', N'ZhongShanShi', N'ZhongShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2865', N'嘉峪关市', N'2_299', N'嘉峪关市', N'NULL', 3, N'620200', N'JiaYuGuanShi', N'JiaYuGuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2866', N'石河子市', N'2_339', N'石河子市', N'NULL', 3, N'659001', N'ShiHeZiShi', N'ShiHeZiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2867', N'阿拉尔市', N'2_340', N'阿拉尔市', N'NULL', 3, N'659002', N'ALaErShi', N'ALaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2868', N'图木舒克市', N'2_341', N'图木舒克市', N'NULL', 3, N'659003', N'TuMuShuKeShi', N'TuMuShuKeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2869', N'五家渠市', N'2_342', N'五家渠市', N'NULL', 3, N'659004', N'WuJiaQuShi', N'WuJiaQuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_287', N'代县', N'2_22', N'忻州市', N'NULL', 3, N'140923', N'DaiXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2870', N'香港特别行政区', N'2_343', N'香港特别行政区', N'NULL', 3, N'810000', N'XiangGangTeBieXingZhengQu', N'XiangGangTeBieXingZhengQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2871', N'澳门特别行政区', N'2_344', N'澳门特别行政区', N'NULL', 3, N'820000', N'AoMenTeBieXingZhengQu', N'AoMenTeBieXingZhengQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2872', N'中正区', N'2_345', N'台北市', N'000000', 3, N'710000', N'ZhongZhengQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2873', N'大同区', N'2_345', N'台北市', N'000000', 3, N'710000', N'DaTongQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2874', N'中山区', N'2_345', N'台北市', N'000000', 3, N'710000', N'ZhongShanQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2875', N'松山区', N'2_345', N'台北市', N'000000', 3, N'710000', N'SongShanQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2876', N'大安区', N'2_345', N'台北市', N'000000', 3, N'710000', N'DaAnQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2877', N'万华区', N'2_345', N'台北市', N'000000', 3, N'710000', N'WanHuaQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2878', N'信义区', N'2_345', N'台北市', N'000000', 3, N'710000', N'XinYiQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2879', N'士林区', N'2_345', N'台北市', N'000000', 3, N'710000', N'ShiLinQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_288', N'繁峙县', N'2_22', N'忻州市', N'NULL', 3, N'140924', N'FanZhiXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2880', N'北投区', N'2_345', N'台北市', N'000000', 3, N'710000', N'BeiTouQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2881', N'内湖区', N'2_345', N'台北市', N'000000', 3, N'710000', N'NaHuQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2882', N'南港区', N'2_345', N'台北市', N'000000', 3, N'710000', N'NanGangQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2883', N'文山区', N'2_345', N'台北市', N'000000', 3, N'710000', N'WenShanQu', N'TaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2884', N'新兴区', N'2_346', N'高雄市', N'000000', 3, N'710000', N'XinXingQu', N'GaoXiongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2885', N'前金区', N'2_346', N'高雄市', N'000000', 3, N'710000', N'QianJinQu', N'GaoXiongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2886', N'芩雅区', N'2_346', N'高雄市', N'000000', 3, N'710000', N'QinYaQu', N'GaoXiongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2887', N'盐埕区', N'2_346', N'高雄市', N'000000', 3, N'710000', N'YanChengQu', N'GaoXiongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2888', N'鼓山区', N'2_346', N'高雄市', N'000000', 3, N'710000', N'GuShanQu', N'GaoXiongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2889', N'旗津区', N'2_346', N'高雄市', N'000000', 3, N'710000', N'QiJinQu', N'GaoXiongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_289', N'宁武县', N'2_22', N'忻州市', N'NULL', 3, N'140925', N'NingWuXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2890', N'前镇区', N'2_346', N'高雄市', N'000000', 3, N'710000', N'QianZhenQu', N'GaoXiongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2891', N'三民区', N'2_346', N'高雄市', N'000000', 3, N'710000', N'SanMinQu', N'GaoXiongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2892', N'左营区', N'2_346', N'高雄市', N'000000', 3, N'710000', N'ZuoYingQu', N'GaoXiongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2893', N'楠梓区', N'2_346', N'高雄市', N'000000', 3, N'710000', N'NanZiQu', N'GaoXiongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2894', N'小港区', N'2_346', N'高雄市', N'000000', 3, N'710000', N'XiaoGangQu', N'GaoXiongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2895', N'仁爱区', N'2_347', N'基隆市', N'000000', 3, N'710000', N'RenAiQu', N'JiLongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2896', N'信义区', N'2_347', N'基隆市', N'000000', 3, N'710000', N'XinYiQu', N'JiLongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2897', N'中正区', N'2_347', N'基隆市', N'000000', 3, N'710000', N'ZhongZhengQu', N'JiLongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2898', N'中山区', N'2_347', N'基隆市', N'000000', 3, N'710000', N'ZhongShanQu', N'JiLongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2899', N'安乐区', N'2_347', N'基隆市', N'000000', 3, N'710000', N'AnLeQu', N'JiLongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_29', N'西青区', N'2_2', N'天津市', N'NULL', 3, N'120111', N'XiQingQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_290', N'静乐县', N'2_22', N'忻州市', N'NULL', 3, N'140926', N'JingLeXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2900', N'暖暖区', N'2_347', N'基隆市', N'000000', 3, N'710000', N'NuanNuanQu', N'JiLongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2901', N'七堵区', N'2_347', N'基隆市', N'000000', 3, N'710000', N'QiDuQu', N'JiLongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2902', N'中区', N'2_348', N'台中市', N'000000', 3, N'710000', N'ZhongQu', N'TaiZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2903', N'东区', N'2_348', N'台中市', N'000000', 3, N'710000', N'DongQu', N'TaiZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2904', N'南区', N'2_348', N'台中市', N'000000', 3, N'710000', N'NanQu', N'TaiZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2905', N'西区', N'2_348', N'台中市', N'000000', 3, N'710000', N'XiQu', N'TaiZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2906', N'北区', N'2_348', N'台中市', N'000000', 3, N'710000', N'BeiQu', N'TaiZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2907', N'北屯区', N'2_348', N'台中市', N'000000', 3, N'710000', N'BeiTunQu', N'TaiZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2908', N'西屯区', N'2_348', N'台中市', N'000000', 3, N'710000', N'XiTunQu', N'TaiZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2909', N'南屯区', N'2_348', N'台中市', N'000000', 3, N'710000', N'NanTunQu', N'TaiZhongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_291', N'神池县', N'2_22', N'忻州市', N'NULL', 3, N'140927', N'ShenChiXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2910', N'中西区', N'2_349', N'台南市', N'000000', 3, N'710000', N'ZhongXiQu', N'TaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2911', N'东区', N'2_349', N'台南市', N'000000', 3, N'710000', N'DongQu', N'TaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2912', N'南区', N'2_349', N'台南市', N'000000', 3, N'710000', N'NanQu', N'TaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2913', N'北区', N'2_349', N'台南市', N'000000', 3, N'710000', N'BeiQu', N'TaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2914', N'安平区', N'2_349', N'台南市', N'000000', 3, N'710000', N'AnPingQu', N'TaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2915', N'安南区', N'2_349', N'台南市', N'000000', 3, N'710000', N'AnNanQu', N'TaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2916', N'东区', N'2_350', N'新竹市', N'000000', 3, N'710000', N'DongQu', N'XinZhuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2917', N'北区', N'2_350', N'新竹市', N'000000', 3, N'710000', N'BeiQu', N'XinZhuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2918', N'香山区', N'2_350', N'新竹市', N'000000', 3, N'710000', N'XiangShanQu', N'XinZhuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2919', N'东区', N'2_351', N'嘉义市', N'000000', 3, N'710000', N'DongQu', N'JiaYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_292', N'五寨县', N'2_22', N'忻州市', N'NULL', 3, N'140928', N'WuZhaiXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_2920', N'西区', N'2_351', N'嘉义市', N'000000', 3, N'710000', N'XiQu', N'JiaYiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_293', N'岢岚县', N'2_22', N'忻州市', N'NULL', 3, N'140929', N'KeLanXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_294', N'河曲县', N'2_22', N'忻州市', N'NULL', 3, N'140930', N'HeQuXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_295', N'保德县', N'2_22', N'忻州市', N'NULL', 3, N'140931', N'BaoDeXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_296', N'偏关县', N'2_22', N'忻州市', N'NULL', 3, N'140932', N'PianGuanXian', N'XinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_297', N'原平市', N'2_22', N'忻州市', N'NULL', 3, N'140981', N'YuanPingShi', N'XinZhouShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_298', N'尧都区', N'2_23', N'临汾市', N'NULL', 3, N'141002', N'YaoDouQu', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_299', N'曲沃县', N'2_23', N'临汾市', N'NULL', 3, N'141021', N'QuWoXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_3', N'崇文区', N'2_1', N'北京市', N'NULL', 3, N'110103', N'ChongWenQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_30', N'津南区', N'2_2', N'天津市', N'NULL', 3, N'120112', N'JinNanQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_300', N'翼城县', N'2_23', N'临汾市', N'NULL', 3, N'141022', N'YiChengXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_301', N'襄汾县', N'2_23', N'临汾市', N'NULL', 3, N'141023', N'XiangFenXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_302', N'洪洞县', N'2_23', N'临汾市', N'NULL', 3, N'141024', N'HongDongXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_303', N'古县', N'2_23', N'临汾市', N'NULL', 3, N'141025', N'GuXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_304', N'安泽县', N'2_23', N'临汾市', N'NULL', 3, N'141026', N'AnZeXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_305', N'浮山县', N'2_23', N'临汾市', N'NULL', 3, N'141027', N'FuShanXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_306', N'吉县', N'2_23', N'临汾市', N'NULL', 3, N'141028', N'JiXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_307', N'乡宁县', N'2_23', N'临汾市', N'NULL', 3, N'141029', N'XiangNingXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_308', N'大宁县', N'2_23', N'临汾市', N'NULL', 3, N'141030', N'DaNingXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_309', N'隰县', N'2_23', N'临汾市', N'NULL', 3, N'141031', N'XiXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_31', N'北辰区', N'2_2', N'天津市', N'NULL', 3, N'120113', N'BeiChenQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_310', N'永和县', N'2_23', N'临汾市', N'NULL', 3, N'141032', N'YongHeXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_311', N'蒲县', N'2_23', N'临汾市', N'NULL', 3, N'141033', N'PuXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_312', N'汾西县', N'2_23', N'临汾市', N'NULL', 3, N'141034', N'FenXiXian', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_313', N'侯马市', N'2_23', N'临汾市', N'NULL', 3, N'141081', N'HouMaShi', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_314', N'霍州市', N'2_23', N'临汾市', N'NULL', 3, N'141082', N'HuoZhouShi', N'LinFenShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_315', N'离石区', N'2_24', N'吕梁市', N'NULL', 3, N'141102', N'LiShiQu', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_316', N'文水县', N'2_24', N'吕梁市', N'NULL', 3, N'141121', N'WenShuiXian', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_317', N'交城县', N'2_24', N'吕梁市', N'NULL', 3, N'141122', N'JiaoChengXian', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_318', N'兴县', N'2_24', N'吕梁市', N'NULL', 3, N'141123', N'XingXian', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_319', N'临县', N'2_24', N'吕梁市', N'NULL', 3, N'141124', N'LinXian', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_32', N'武清区', N'2_2', N'天津市', N'NULL', 3, N'120114', N'WuQingQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_320', N'柳林县', N'2_24', N'吕梁市', N'NULL', 3, N'141125', N'LiuLinXian', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_321', N'石楼县', N'2_24', N'吕梁市', N'NULL', 3, N'141126', N'ShiLouXian', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_322', N'岚县', N'2_24', N'吕梁市', N'NULL', 3, N'141127', N'LanXian', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_323', N'方山县', N'2_24', N'吕梁市', N'NULL', 3, N'141128', N'FangShanXian', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_324', N'中阳县', N'2_24', N'吕梁市', N'NULL', 3, N'141129', N'ZhongYangXian', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_325', N'交口县', N'2_24', N'吕梁市', N'NULL', 3, N'141130', N'JiaoKouXian', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_326', N'孝义市', N'2_24', N'吕梁市', N'NULL', 3, N'141181', N'XiaoYiShi', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_327', N'汾阳市', N'2_24', N'吕梁市', N'NULL', 3, N'141182', N'FenYangShi', N'LvLiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_328', N'新城区', N'2_25', N'呼和浩特市', N'NULL', 3, N'150102', N'XinChengQu', N'HuHeHaoTeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_329', N'回民区', N'2_25', N'呼和浩特市', N'NULL', 3, N'150103', N'HuiMinQu', N'HuHeHaoTeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_33', N'宝坻区', N'2_2', N'天津市', N'NULL', 3, N'120115', N'BaoDiQu', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_330', N'玉泉区', N'2_25', N'呼和浩特市', N'NULL', 3, N'150104', N'YuQuanQu', N'HuHeHaoTeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_331', N'赛罕区', N'2_25', N'呼和浩特市', N'NULL', 3, N'150105', N'SaiHanQu', N'HuHeHaoTeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_332', N'土默特左旗', N'2_25', N'呼和浩特市', N'NULL', 3, N'150121', N'TuMoTeZuoQi', N'HuHeHaoTeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_333', N'托克托县', N'2_25', N'呼和浩特市', N'NULL', 3, N'150122', N'TuoKeTuoXian', N'HuHeHaoTeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_334', N'和林格尔县', N'2_25', N'呼和浩特市', N'NULL', 3, N'150123', N'HeLinGeErXian', N'HuHeHaoTeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_335', N'清水河县', N'2_25', N'呼和浩特市', N'NULL', 3, N'150124', N'QingShuiHeXian', N'HuHeHaoTeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_336', N'武川县', N'2_25', N'呼和浩特市', N'NULL', 3, N'150125', N'WuChuanXian', N'HuHeHaoTeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_337', N'东河区', N'2_26', N'包头市', N'NULL', 3, N'150202', N'DongHeQu', N'BaoTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_338', N'昆都仑区', N'2_26', N'包头市', N'NULL', 3, N'150203', N'KunDouLunQu', N'BaoTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_339', N'青山区', N'2_26', N'包头市', N'NULL', 3, N'150204', N'QingShanQu', N'BaoTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_34', N'宁河县', N'2_2', N'天津市', N'NULL', 3, N'120221', N'NingHeXian', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_340', N'石拐区', N'2_26', N'包头市', N'NULL', 3, N'150205', N'ShiGuaiQu', N'BaoTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_341', N'白云矿区', N'2_26', N'包头市', N'NULL', 3, N'150206', N'BaiYunKuangQu', N'BaoTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_342', N'九原区', N'2_26', N'包头市', N'NULL', 3, N'150207', N'JiuYuanQu', N'BaoTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_343', N'土默特右旗', N'2_26', N'包头市', N'NULL', 3, N'150221', N'TuMoTeYouQi', N'BaoTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_344', N'固阳县', N'2_26', N'包头市', N'NULL', 3, N'150222', N'GuYangXian', N'BaoTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_345', N'达尔罕茂明安联合旗', N'2_26', N'包头市', N'NULL', 3, N'150223', N'DaErHanMaoMingAnLianHeQi', N'BaoTouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_346', N'海勃湾区', N'2_27', N'乌海市', N'NULL', 3, N'150302', N'HaiBoWanQu', N'WuHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_347', N'海南区', N'2_27', N'乌海市', N'NULL', 3, N'150303', N'HaiNanQu', N'WuHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_348', N'乌达区', N'2_27', N'乌海市', N'NULL', 3, N'150304', N'WuDaQu', N'WuHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_349', N'红山区', N'2_28', N'赤峰市', N'NULL', 3, N'150402', N'HongShanQu', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_35', N'静海县', N'2_2', N'天津市', N'NULL', 3, N'120223', N'JingHaiXian', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_350', N'元宝山区', N'2_28', N'赤峰市', N'NULL', 3, N'150403', N'YuanBaoShanQu', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_351', N'松山区', N'2_28', N'赤峰市', N'NULL', 3, N'150404', N'SongShanQu', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_352', N'阿鲁科尔沁旗', N'2_28', N'赤峰市', N'NULL', 3, N'150421', N'ALuKeErQinQi', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_353', N'巴林左旗', N'2_28', N'赤峰市', N'NULL', 3, N'150422', N'BaLinZuoQi', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_354', N'巴林右旗', N'2_28', N'赤峰市', N'NULL', 3, N'150423', N'BaLinYouQi', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_355', N'林西县', N'2_28', N'赤峰市', N'NULL', 3, N'150424', N'LinXiXian', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_356', N'克什克腾旗', N'2_28', N'赤峰市', N'NULL', 3, N'150425', N'KeShiKeTengQi', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_357', N'翁牛特旗', N'2_28', N'赤峰市', N'NULL', 3, N'150426', N'WengNiuTeQi', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_358', N'喀喇沁旗', N'2_28', N'赤峰市', N'NULL', 3, N'150428', N'KaLaQinQi', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_359', N'宁城县', N'2_28', N'赤峰市', N'NULL', 3, N'150429', N'NingChengXian', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_36', N'蓟县', N'2_2', N'天津市', N'NULL', 3, N'120225', N'JiXian', N'TianJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_360', N'敖汉旗', N'2_28', N'赤峰市', N'NULL', 3, N'150430', N'AoHanQi', N'ChiFengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_361', N'科尔沁区', N'2_29', N'通辽市', N'NULL', 3, N'150502', N'KeErQinQu', N'TongLiaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_362', N'科尔沁左翼中旗', N'2_29', N'通辽市', N'NULL', 3, N'150521', N'KeErQinZuoYiZhongQi', N'TongLiaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_363', N'科尔沁左翼后旗', N'2_29', N'通辽市', N'NULL', 3, N'150522', N'KeErQinZuoYiHouQi', N'TongLiaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_364', N'开鲁县', N'2_29', N'通辽市', N'NULL', 3, N'150523', N'KaiLuXian', N'TongLiaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_365', N'库伦旗', N'2_29', N'通辽市', N'NULL', 3, N'150524', N'KuLunQi', N'TongLiaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_366', N'奈曼旗', N'2_29', N'通辽市', N'NULL', 3, N'150525', N'NaiManQi', N'TongLiaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_367', N'扎鲁特旗', N'2_29', N'通辽市', N'NULL', 3, N'150526', N'ZhaLuTeQi', N'TongLiaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_368', N'霍林郭勒市', N'2_29', N'通辽市', N'NULL', 3, N'150581', N'HuoLinGuoLeShi', N'TongLiaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_369', N'东胜区', N'2_30', N'鄂尔多斯市', N'NULL', 3, N'150602', N'DongShengQu', N'EErDuoSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_37', N'长安区', N'2_3', N'石家庄市', N'NULL', 3, N'130102', N'ChangAnQu', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_370', N'达拉特旗', N'2_30', N'鄂尔多斯市', N'NULL', 3, N'150621', N'DaLaTeQi', N'EErDuoSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_371', N'准格尔旗', N'2_30', N'鄂尔多斯市', N'NULL', 3, N'150622', N'ZhunGeErQi', N'EErDuoSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_372', N'鄂托克前旗', N'2_30', N'鄂尔多斯市', N'NULL', 3, N'150623', N'ETuoKeQianQi', N'EErDuoSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_373', N'鄂托克旗', N'2_30', N'鄂尔多斯市', N'NULL', 3, N'150624', N'ETuoKeQi', N'EErDuoSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_374', N'杭锦旗', N'2_30', N'鄂尔多斯市', N'NULL', 3, N'150625', N'HangJinQi', N'EErDuoSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_375', N'乌审旗', N'2_30', N'鄂尔多斯市', N'NULL', 3, N'150626', N'WuShenQi', N'EErDuoSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_376', N'伊金霍洛旗', N'2_30', N'鄂尔多斯市', N'NULL', 3, N'150627', N'YiJinHuoLuoQi', N'EErDuoSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_377', N'海拉尔区', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150702', N'HaiLaErQu', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_378', N'阿荣旗', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150721', N'ARongQi', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_379', N'莫力达瓦达斡尔族自治旗', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150722', N'MoLiDaWaDaWoErZuZiZhiQi', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_38', N'桥东区', N'2_3', N'石家庄市', N'NULL', 3, N'130103', N'QiaoDongQu', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_380', N'鄂伦春自治旗', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150723', N'ELunChunZiZhiQi', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_381', N'鄂温克族自治旗', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150724', N'EWenKeZuZiZhiQi', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_382', N'陈巴尔虎旗', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150725', N'ChenBaErHuQi', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_383', N'新巴尔虎左旗', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150726', N'XinBaErHuZuoQi', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_384', N'新巴尔虎右旗', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150727', N'XinBaErHuYouQi', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_385', N'满洲里市', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150781', N'ManZhouLiShi', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_386', N'牙克石市', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150782', N'YaKeShiShi', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_387', N'扎兰屯市', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150783', N'ZhaLanTunShi', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_388', N'额尔古纳市', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150784', N'EErGuNaShi', N'HuLunBeiErShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_389', N'根河市', N'2_31', N'呼伦贝尔市', N'NULL', 3, N'150785', N'GenHeShi', N'HuLunBeiErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_39', N'桥西区', N'2_3', N'石家庄市', N'NULL', 3, N'130104', N'QiaoXiQu', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_390', N'临河区', N'2_32', N'巴彦淖尔市', N'NULL', 3, N'150802', N'LinHeQu', N'BaYanNaoErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_391', N'五原县', N'2_32', N'巴彦淖尔市', N'NULL', 3, N'150821', N'WuYuanXian', N'BaYanNaoErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_392', N'磴口县', N'2_32', N'巴彦淖尔市', N'NULL', 3, N'150822', N'DengKouXian', N'BaYanNaoErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_393', N'乌拉特前旗', N'2_32', N'巴彦淖尔市', N'NULL', 3, N'150823', N'WuLaTeQianQi', N'BaYanNaoErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_394', N'乌拉特中旗', N'2_32', N'巴彦淖尔市', N'NULL', 3, N'150824', N'WuLaTeZhongQi', N'BaYanNaoErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_395', N'乌拉特后旗', N'2_32', N'巴彦淖尔市', N'NULL', 3, N'150825', N'WuLaTeHouQi', N'BaYanNaoErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_396', N'杭锦后旗', N'2_32', N'巴彦淖尔市', N'NULL', 3, N'150826', N'HangJinHouQi', N'BaYanNaoErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_397', N'集宁区', N'2_33', N'乌兰察布市', N'NULL', 3, N'150902', N'JiNingQu', N'WuLanChaBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_398', N'卓资县', N'2_33', N'乌兰察布市', N'NULL', 3, N'150921', N'ZhuoZiXian', N'WuLanChaBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_399', N'化德县', N'2_33', N'乌兰察布市', N'NULL', 3, N'150922', N'HuaDeXian', N'WuLanChaBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_4', N'宣武区', N'2_1', N'北京市', N'NULL', 3, N'110104', N'XuanWuQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_40', N'新华区', N'2_3', N'石家庄市', N'NULL', 3, N'130105', N'XinHuaQu', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_400', N'商都县', N'2_33', N'乌兰察布市', N'NULL', 3, N'150923', N'ShangDouXian', N'WuLanChaBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_401', N'兴和县', N'2_33', N'乌兰察布市', N'NULL', 3, N'150924', N'XingHeXian', N'WuLanChaBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_402', N'凉城县', N'2_33', N'乌兰察布市', N'NULL', 3, N'150925', N'LiangChengXian', N'WuLanChaBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_403', N'察哈尔右翼前旗', N'2_33', N'乌兰察布市', N'NULL', 3, N'150926', N'ChaHaErYouYiQianQi', N'WuLanChaBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_404', N'察哈尔右翼中旗', N'2_33', N'乌兰察布市', N'NULL', 3, N'150927', N'ChaHaErYouYiZhongQi', N'WuLanChaBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_405', N'察哈尔右翼后旗', N'2_33', N'乌兰察布市', N'NULL', 3, N'150928', N'ChaHaErYouYiHouQi', N'WuLanChaBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_406', N'四子王旗', N'2_33', N'乌兰察布市', N'NULL', 3, N'150929', N'SiZiWangQi', N'WuLanChaBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_407', N'丰镇市', N'2_33', N'乌兰察布市', N'NULL', 3, N'150981', N'FengZhenShi', N'WuLanChaBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_408', N'乌兰浩特市', N'2_34', N'兴安盟', N'NULL', 3, N'152201', N'WuLanHaoTeShi', N'XingAnMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_409', N'阿尔山市', N'2_34', N'兴安盟', N'NULL', 3, N'152202', N'AErShanShi', N'XingAnMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_41', N'井陉矿区', N'2_3', N'石家庄市', N'NULL', 3, N'130107', N'JingXingKuangQu', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_410', N'科尔沁右翼前旗', N'2_34', N'兴安盟', N'NULL', 3, N'152221', N'KeErQinYouYiQianQi', N'XingAnMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_411', N'科尔沁右翼中旗', N'2_34', N'兴安盟', N'NULL', 3, N'152222', N'KeErQinYouYiZhongQi', N'XingAnMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_412', N'扎赉特旗', N'2_34', N'兴安盟', N'NULL', 3, N'152223', N'ZhaLaiTeQi', N'XingAnMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_413', N'突泉县', N'2_34', N'兴安盟', N'NULL', 3, N'152224', N'TuQuanXian', N'XingAnMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_414', N'二连浩特市', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152501', N'ErLianHaoTeShi', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_415', N'锡林浩特市', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152502', N'XiLinHaoTeShi', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_416', N'阿巴嘎旗', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152522', N'ABaGaQi', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_417', N'苏尼特左旗', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152523', N'SuNiTeZuoQi', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_418', N'苏尼特右旗', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152524', N'SuNiTeYouQi', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_419', N'东乌珠穆沁旗', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152525', N'DongWuZhuMuQinQi', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_42', N'裕华区', N'2_3', N'石家庄市', N'NULL', 3, N'130108', N'YuHuaQu', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_420', N'西乌珠穆沁旗', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152526', N'XiWuZhuMuQinQi', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_421', N'太仆寺旗', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152527', N'TaiPuSiQi', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_422', N'镶黄旗', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152528', N'XiangHuangQi', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_423', N'正镶白旗', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152529', N'ZhengXiangBaiQi', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_424', N'正蓝旗', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152530', N'ZhengLanQi', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_425', N'多伦县', N'2_35', N'锡林郭勒盟', N'NULL', 3, N'152531', N'DuoLunXian', N'XiLinGuoLeMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_426', N'阿拉善左旗', N'2_36', N'阿拉善盟', N'NULL', 3, N'152921', N'ALaShanZuoQi', N'ALaShanMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_427', N'阿拉善右旗', N'2_36', N'阿拉善盟', N'NULL', 3, N'152922', N'ALaShanYouQi', N'ALaShanMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_428', N'额济纳旗', N'2_36', N'阿拉善盟', N'NULL', 3, N'152923', N'EJiNaQi', N'ALaShanMeng')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_429', N'和平区', N'2_37', N'沈阳市', N'NULL', 3, N'210102', N'HePingQu', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_43', N'井陉县', N'2_3', N'石家庄市', N'NULL', 3, N'130121', N'JingXingXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_430', N'沈河区', N'2_37', N'沈阳市', N'NULL', 3, N'210103', N'ShenHeQu', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_431', N'大东区', N'2_37', N'沈阳市', N'NULL', 3, N'210104', N'DaDongQu', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_432', N'皇姑区', N'2_37', N'沈阳市', N'NULL', 3, N'210105', N'HuangGuQu', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_433', N'铁西区', N'2_37', N'沈阳市', N'NULL', 3, N'210106', N'TieXiQu', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_434', N'苏家屯区', N'2_37', N'沈阳市', N'NULL', 3, N'210111', N'SuJiaTunQu', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_435', N'东陵区', N'2_37', N'沈阳市', N'NULL', 3, N'210112', N'DongLingQu', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_436', N'沈北新区', N'2_37', N'沈阳市', N'NULL', 3, N'210113', N'ShenBeiXinQu', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_437', N'于洪区', N'2_37', N'沈阳市', N'NULL', 3, N'210114', N'YuHongQu', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_438', N'辽中县', N'2_37', N'沈阳市', N'NULL', 3, N'210122', N'LiaoZhongXian', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_439', N'康平县', N'2_37', N'沈阳市', N'NULL', 3, N'210123', N'KangPingXian', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_44', N'正定县', N'2_3', N'石家庄市', N'NULL', 3, N'130123', N'ZhengDingXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_440', N'法库县', N'2_37', N'沈阳市', N'NULL', 3, N'210124', N'FaKuXian', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_441', N'新民市', N'2_37', N'沈阳市', N'NULL', 3, N'210181', N'XinMinShi', N'ShenYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_442', N'中山区', N'2_38', N'大连市', N'NULL', 3, N'210202', N'ZhongShanQu', N'DaLianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_443', N'西岗区', N'2_38', N'大连市', N'NULL', 3, N'210203', N'XiGangQu', N'DaLianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_444', N'沙河口区', N'2_38', N'大连市', N'NULL', 3, N'210204', N'ShaHeKouQu', N'DaLianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_445', N'甘井子区', N'2_38', N'大连市', N'NULL', 3, N'210211', N'GanJingZiQu', N'DaLianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_446', N'旅顺口区', N'2_38', N'大连市', N'NULL', 3, N'210212', N'LvShunKouQu', N'DaLianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_447', N'金州区', N'2_38', N'大连市', N'NULL', 3, N'210213', N'JinZhouQu', N'DaLianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_448', N'长海县', N'2_38', N'大连市', N'NULL', 3, N'210224', N'ChangHaiXian', N'DaLianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_449', N'瓦房店市', N'2_38', N'大连市', N'NULL', 3, N'210281', N'WaFangDianShi', N'DaLianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_45', N'栾城县', N'2_3', N'石家庄市', N'NULL', 3, N'130124', N'LuanChengXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_450', N'普兰店市', N'2_38', N'大连市', N'NULL', 3, N'210282', N'PuLanDianShi', N'DaLianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_451', N'庄河市', N'2_38', N'大连市', N'NULL', 3, N'210283', N'ZhuangHeShi', N'DaLianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_452', N'铁东区', N'2_39', N'鞍山市', N'NULL', 3, N'210302', N'TieDongQu', N'AnShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_453', N'铁西区', N'2_39', N'鞍山市', N'NULL', 3, N'210303', N'TieXiQu', N'AnShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_454', N'立山区', N'2_39', N'鞍山市', N'NULL', 3, N'210304', N'LiShanQu', N'AnShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_455', N'千山区', N'2_39', N'鞍山市', N'NULL', 3, N'210311', N'QianShanQu', N'AnShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_456', N'台安县', N'2_39', N'鞍山市', N'NULL', 3, N'210321', N'TaiAnXian', N'AnShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_457', N'岫岩满族自治县', N'2_39', N'鞍山市', N'NULL', 3, N'210323', N'XiuYanManZuZiZhiXian', N'AnShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_458', N'海城市', N'2_39', N'鞍山市', N'NULL', 3, N'210381', N'HaiChengShi', N'AnShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_459', N'新抚区', N'2_40', N'抚顺市', N'NULL', 3, N'210402', N'XinFuQu', N'FuShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_46', N'行唐县', N'2_3', N'石家庄市', N'NULL', 3, N'130125', N'XingTangXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_460', N'东洲区', N'2_40', N'抚顺市', N'NULL', 3, N'210403', N'DongZhouQu', N'FuShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_461', N'望花区', N'2_40', N'抚顺市', N'NULL', 3, N'210404', N'WangHuaQu', N'FuShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_462', N'顺城区', N'2_40', N'抚顺市', N'NULL', 3, N'210411', N'ShunChengQu', N'FuShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_463', N'抚顺县', N'2_40', N'抚顺市', N'NULL', 3, N'210421', N'FuShunXian', N'FuShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_464', N'新宾满族自治县', N'2_40', N'抚顺市', N'NULL', 3, N'210422', N'XinBinManZuZiZhiXian', N'FuShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_465', N'清原满族自治县', N'2_40', N'抚顺市', N'NULL', 3, N'210423', N'QingYuanManZuZiZhiXian', N'FuShunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_466', N'平山区', N'2_41', N'本溪市', N'NULL', 3, N'210502', N'PingShanQu', N'BenXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_467', N'溪湖区', N'2_41', N'本溪市', N'NULL', 3, N'210503', N'XiHuQu', N'BenXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_468', N'明山区', N'2_41', N'本溪市', N'NULL', 3, N'210504', N'MingShanQu', N'BenXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_469', N'南芬区', N'2_41', N'本溪市', N'NULL', 3, N'210505', N'NanFenQu', N'BenXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_47', N'灵寿县', N'2_3', N'石家庄市', N'NULL', 3, N'130126', N'LingShouXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_470', N'本溪满族自治县', N'2_41', N'本溪市', N'NULL', 3, N'210521', N'BenXiManZuZiZhiXian', N'BenXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_471', N'桓仁满族自治县', N'2_41', N'本溪市', N'NULL', 3, N'210522', N'HuanRenManZuZiZhiXian', N'BenXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_472', N'元宝区', N'2_42', N'丹东市', N'NULL', 3, N'210602', N'YuanBaoQu', N'DanDongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_473', N'振兴区', N'2_42', N'丹东市', N'NULL', 3, N'210603', N'ZhenXingQu', N'DanDongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_474', N'振安区', N'2_42', N'丹东市', N'NULL', 3, N'210604', N'ZhenAnQu', N'DanDongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_475', N'宽甸满族自治县', N'2_42', N'丹东市', N'NULL', 3, N'210624', N'KuanDianManZuZiZhiXian', N'DanDongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_476', N'东港市', N'2_42', N'丹东市', N'NULL', 3, N'210681', N'DongGangShi', N'DanDongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_477', N'凤城市', N'2_42', N'丹东市', N'NULL', 3, N'210682', N'FengChengShi', N'DanDongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_478', N'古塔区', N'2_43', N'锦州市', N'NULL', 3, N'210702', N'GuTaQu', N'JinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_479', N'凌河区', N'2_43', N'锦州市', N'NULL', 3, N'210703', N'LingHeQu', N'JinZhouShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_48', N'高邑县', N'2_3', N'石家庄市', N'NULL', 3, N'130127', N'GaoYiXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_480', N'太和区', N'2_43', N'锦州市', N'NULL', 3, N'210711', N'TaiHeQu', N'JinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_481', N'黑山县', N'2_43', N'锦州市', N'NULL', 3, N'210726', N'HeiShanXian', N'JinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_482', N'义县', N'2_43', N'锦州市', N'NULL', 3, N'210727', N'YiXian', N'JinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_483', N'凌海市', N'2_43', N'锦州市', N'NULL', 3, N'210781', N'LingHaiShi', N'JinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_484', N'北镇市', N'2_43', N'锦州市', N'NULL', 3, N'210782', N'BeiZhenShi', N'JinZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_485', N'站前区', N'2_44', N'营口市', N'NULL', 3, N'210802', N'ZhanQianQu', N'YingKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_486', N'西市区', N'2_44', N'营口市', N'NULL', 3, N'210803', N'XiShiQu', N'YingKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_487', N'鲅鱼圈区', N'2_44', N'营口市', N'NULL', 3, N'210804', N'BaYuQuanQu', N'YingKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_488', N'老边区', N'2_44', N'营口市', N'NULL', 3, N'210811', N'LaoBianQu', N'YingKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_489', N'盖州市', N'2_44', N'营口市', N'NULL', 3, N'210881', N'GaiZhouShi', N'YingKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_49', N'深泽县', N'2_3', N'石家庄市', N'NULL', 3, N'130128', N'ShenZeXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_490', N'大石桥市', N'2_44', N'营口市', N'NULL', 3, N'210882', N'DaShiQiaoShi', N'YingKouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_491', N'海州区', N'2_45', N'阜新市', N'NULL', 3, N'210902', N'HaiZhouQu', N'FuXinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_492', N'新邱区', N'2_45', N'阜新市', N'NULL', 3, N'210903', N'XinQiuQu', N'FuXinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_493', N'太平区', N'2_45', N'阜新市', N'NULL', 3, N'210904', N'TaiPingQu', N'FuXinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_494', N'清河门区', N'2_45', N'阜新市', N'NULL', 3, N'210905', N'QingHeMenQu', N'FuXinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_495', N'细河区', N'2_45', N'阜新市', N'NULL', 3, N'210911', N'XiHeQu', N'FuXinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_496', N'阜新蒙古族自治县', N'2_45', N'阜新市', N'NULL', 3, N'210921', N'FuXinMengGuZuZiZhiXian', N'FuXinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_497', N'彰武县', N'2_45', N'阜新市', N'NULL', 3, N'210922', N'ZhangWuXian', N'FuXinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_498', N'白塔区', N'2_46', N'辽阳市', N'NULL', 3, N'211002', N'BaiTaQu', N'LiaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_499', N'文圣区', N'2_46', N'辽阳市', N'NULL', 3, N'211003', N'WenShengQu', N'LiaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_5', N'朝阳区', N'2_1', N'北京市', N'NULL', 3, N'110105', N'ChaoYangQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_50', N'赞皇县', N'2_3', N'石家庄市', N'NULL', 3, N'130129', N'ZanHuangXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_500', N'宏伟区', N'2_46', N'辽阳市', N'NULL', 3, N'211004', N'HongWeiQu', N'LiaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_501', N'弓长岭区', N'2_46', N'辽阳市', N'NULL', 3, N'211005', N'GongChangLingQu', N'LiaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_502', N'太子河区', N'2_46', N'辽阳市', N'NULL', 3, N'211011', N'TaiZiHeQu', N'LiaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_503', N'辽阳县', N'2_46', N'辽阳市', N'NULL', 3, N'211021', N'LiaoYangXian', N'LiaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_504', N'灯塔市', N'2_46', N'辽阳市', N'NULL', 3, N'211081', N'DengTaShi', N'LiaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_505', N'双台子区', N'2_47', N'盘锦市', N'NULL', 3, N'211102', N'ShuangTaiZiQu', N'PanJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_506', N'兴隆台区', N'2_47', N'盘锦市', N'NULL', 3, N'211103', N'XingLongTaiQu', N'PanJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_507', N'大洼县', N'2_47', N'盘锦市', N'NULL', 3, N'211121', N'DaWaXian', N'PanJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_508', N'盘山县', N'2_47', N'盘锦市', N'NULL', 3, N'211122', N'PanShanXian', N'PanJinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_509', N'银州区', N'2_48', N'铁岭市', N'NULL', 3, N'211202', N'YinZhouQu', N'TieLingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_51', N'无极县', N'2_3', N'石家庄市', N'NULL', 3, N'130130', N'WuJiXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_510', N'清河区', N'2_48', N'铁岭市', N'NULL', 3, N'211204', N'QingHeQu', N'TieLingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_511', N'铁岭县', N'2_48', N'铁岭市', N'NULL', 3, N'211221', N'TieLingXian', N'TieLingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_512', N'西丰县', N'2_48', N'铁岭市', N'NULL', 3, N'211223', N'XiFengXian', N'TieLingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_513', N'昌图县', N'2_48', N'铁岭市', N'NULL', 3, N'211224', N'ChangTuXian', N'TieLingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_514', N'调兵山市', N'2_48', N'铁岭市', N'NULL', 3, N'211281', N'DiaoBingShanShi', N'TieLingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_515', N'开原市', N'2_48', N'铁岭市', N'NULL', 3, N'211282', N'KaiYuanShi', N'TieLingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_516', N'双塔区', N'2_49', N'朝阳市', N'NULL', 3, N'211302', N'ShuangTaQu', N'ChaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_517', N'龙城区', N'2_49', N'朝阳市', N'NULL', 3, N'211303', N'LongChengQu', N'ChaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_518', N'朝阳县', N'2_49', N'朝阳市', N'NULL', 3, N'211321', N'ChaoYangXian', N'ChaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_519', N'建平县', N'2_49', N'朝阳市', N'NULL', 3, N'211322', N'JianPingXian', N'ChaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_52', N'平山县', N'2_3', N'石家庄市', N'NULL', 3, N'130131', N'PingShanXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_520', N'喀喇沁左翼蒙古族自治县', N'2_49', N'朝阳市', N'NULL', 3, N'211324', N'KaLaQinZuoYiMengGuZuZiZhiXian', N'ChaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_521', N'北票市', N'2_49', N'朝阳市', N'NULL', 3, N'211381', N'BeiPiaoShi', N'ChaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_522', N'凌源市', N'2_49', N'朝阳市', N'NULL', 3, N'211382', N'LingYuanShi', N'ChaoYangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_523', N'连山区', N'2_50', N'葫芦岛市', N'NULL', 3, N'211402', N'LianShanQu', N'HuLuDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_524', N'龙港区', N'2_50', N'葫芦岛市', N'NULL', 3, N'211403', N'LongGangQu', N'HuLuDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_525', N'南票区', N'2_50', N'葫芦岛市', N'NULL', 3, N'211404', N'NanPiaoQu', N'HuLuDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_526', N'绥中县', N'2_50', N'葫芦岛市', N'NULL', 3, N'211421', N'SuiZhongXian', N'HuLuDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_527', N'建昌县', N'2_50', N'葫芦岛市', N'NULL', 3, N'211422', N'JianChangXian', N'HuLuDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_528', N'兴城市', N'2_50', N'葫芦岛市', N'NULL', 3, N'211481', N'XingChengShi', N'HuLuDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_529', N'南关区', N'2_51', N'长春市', N'NULL', 3, N'220102', N'NanGuanQu', N'ChangChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_53', N'元氏县', N'2_3', N'石家庄市', N'NULL', 3, N'130132', N'YuanShiXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_530', N'宽城区', N'2_51', N'长春市', N'NULL', 3, N'220103', N'KuanChengQu', N'ChangChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_531', N'朝阳区', N'2_51', N'长春市', N'NULL', 3, N'220104', N'ChaoYangQu', N'ChangChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_532', N'二道区', N'2_51', N'长春市', N'NULL', 3, N'220105', N'ErDaoQu', N'ChangChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_533', N'绿园区', N'2_51', N'长春市', N'NULL', 3, N'220106', N'LvYuanQu', N'ChangChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_534', N'双阳区', N'2_51', N'长春市', N'NULL', 3, N'220112', N'ShuangYangQu', N'ChangChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_535', N'农安县', N'2_51', N'长春市', N'NULL', 3, N'220122', N'NongAnXian', N'ChangChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_536', N'九台市', N'2_51', N'长春市', N'NULL', 3, N'220181', N'JiuTaiShi', N'ChangChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_537', N'榆树市', N'2_51', N'长春市', N'NULL', 3, N'220182', N'YuShuShi', N'ChangChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_538', N'德惠市', N'2_51', N'长春市', N'NULL', 3, N'220183', N'DeHuiShi', N'ChangChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_539', N'昌邑区', N'2_52', N'吉林市', N'NULL', 3, N'220202', N'ChangYiQu', N'JiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_54', N'赵县', N'2_3', N'石家庄市', N'NULL', 3, N'130133', N'ZhaoXian', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_540', N'龙潭区', N'2_52', N'吉林市', N'NULL', 3, N'220203', N'LongTanQu', N'JiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_541', N'船营区', N'2_52', N'吉林市', N'NULL', 3, N'220204', N'ChuanYingQu', N'JiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_542', N'丰满区', N'2_52', N'吉林市', N'NULL', 3, N'220211', N'FengManQu', N'JiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_543', N'永吉县', N'2_52', N'吉林市', N'NULL', 3, N'220221', N'YongJiXian', N'JiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_544', N'蛟河市', N'2_52', N'吉林市', N'NULL', 3, N'220281', N'JiaoHeShi', N'JiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_545', N'桦甸市', N'2_52', N'吉林市', N'NULL', 3, N'220282', N'HuaDianShi', N'JiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_546', N'舒兰市', N'2_52', N'吉林市', N'NULL', 3, N'220283', N'ShuLanShi', N'JiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_547', N'磐石市', N'2_52', N'吉林市', N'NULL', 3, N'220284', N'PanShiShi', N'JiLinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_548', N'铁西区', N'2_53', N'四平市', N'NULL', 3, N'220302', N'TieXiQu', N'SiPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_549', N'铁东区', N'2_53', N'四平市', N'NULL', 3, N'220303', N'TieDongQu', N'SiPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_55', N'辛集市', N'2_3', N'石家庄市', N'NULL', 3, N'130181', N'XinJiShi', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_550', N'梨树县', N'2_53', N'四平市', N'NULL', 3, N'220322', N'LiShuXian', N'SiPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_551', N'伊通满族自治县', N'2_53', N'四平市', N'NULL', 3, N'220323', N'YiTongManZuZiZhiXian', N'SiPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_552', N'公主岭市', N'2_53', N'四平市', N'NULL', 3, N'220381', N'GongZhuLingShi', N'SiPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_553', N'双辽市', N'2_53', N'四平市', N'NULL', 3, N'220382', N'ShuangLiaoShi', N'SiPingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_554', N'龙山区', N'2_54', N'辽源市', N'NULL', 3, N'220402', N'LongShanQu', N'LiaoYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_555', N'西安区', N'2_54', N'辽源市', N'NULL', 3, N'220403', N'XiAnQu', N'LiaoYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_556', N'东丰县', N'2_54', N'辽源市', N'NULL', 3, N'220421', N'DongFengXian', N'LiaoYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_557', N'东辽县', N'2_54', N'辽源市', N'NULL', 3, N'220422', N'DongLiaoXian', N'LiaoYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_558', N'东昌区', N'2_55', N'通化市', N'NULL', 3, N'220502', N'DongChangQu', N'TongHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_559', N'二道江区', N'2_55', N'通化市', N'NULL', 3, N'220503', N'ErDaoJiangQu', N'TongHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_56', N'藁城市', N'2_3', N'石家庄市', N'NULL', 3, N'130182', N'GaoChengShi', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_560', N'通化县', N'2_55', N'通化市', N'NULL', 3, N'220521', N'TongHuaXian', N'TongHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_561', N'辉南县', N'2_55', N'通化市', N'NULL', 3, N'220523', N'HuiNanXian', N'TongHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_562', N'柳河县', N'2_55', N'通化市', N'NULL', 3, N'220524', N'LiuHeXian', N'TongHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_563', N'梅河口市', N'2_55', N'通化市', N'NULL', 3, N'220581', N'MeiHeKouShi', N'TongHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_564', N'集安市', N'2_55', N'通化市', N'NULL', 3, N'220582', N'JiAnShi', N'TongHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_565', N'八道江区', N'2_56', N'白山市', N'NULL', 3, N'220602', N'BaDaoJiangQu', N'BaiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_566', N'抚松县', N'2_56', N'白山市', N'NULL', 3, N'220621', N'FuSongXian', N'BaiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_567', N'靖宇县', N'2_56', N'白山市', N'NULL', 3, N'220622', N'JingYuXian', N'BaiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_568', N'长白朝鲜族自治县', N'2_56', N'白山市', N'NULL', 3, N'220623', N'ChangBaiChaoXianZuZiZhiXian', N'BaiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_569', N'江源区', N'2_56', N'白山市', N'NULL', 3, N'220604', N'JiangYuanQu', N'BaiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_57', N'晋州市', N'2_3', N'石家庄市', N'NULL', 3, N'130183', N'JinZhouShi', N'ShiJiaZhuangShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_570', N'临江市', N'2_56', N'白山市', N'NULL', 3, N'220681', N'LinJiangShi', N'BaiShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_571', N'宁江区', N'2_57', N'松原市', N'NULL', 3, N'220702', N'NingJiangQu', N'SongYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_572', N'前郭尔罗斯蒙古族自治县', N'2_57', N'松原市', N'NULL', 3, N'220721', N'QianGuoErLuoSiMengGuZuZiZhiXian', N'SongYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_573', N'长岭县', N'2_57', N'松原市', N'NULL', 3, N'220722', N'ChangLingXian', N'SongYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_574', N'乾安县', N'2_57', N'松原市', N'NULL', 3, N'220723', N'QianAnXian', N'SongYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_575', N'扶余县', N'2_57', N'松原市', N'NULL', 3, N'220724', N'FuYuXian', N'SongYuanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_576', N'洮北区', N'2_58', N'白城市', N'NULL', 3, N'220802', N'TaoBeiQu', N'BaiChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_577', N'镇赉县', N'2_58', N'白城市', N'NULL', 3, N'220821', N'ZhenLaiXian', N'BaiChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_578', N'通榆县', N'2_58', N'白城市', N'NULL', 3, N'220822', N'TongYuXian', N'BaiChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_579', N'洮南市', N'2_58', N'白城市', N'NULL', 3, N'220881', N'TaoNanShi', N'BaiChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_58', N'新乐市', N'2_3', N'石家庄市', N'NULL', 3, N'130184', N'XinLeShi', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_580', N'大安市', N'2_58', N'白城市', N'NULL', 3, N'220882', N'DaAnShi', N'BaiChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_581', N'延吉市', N'2_59', N'延边朝鲜族自治州', N'NULL', 3, N'222401', N'YanJiShi', N'YanBianChaoXianZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_582', N'图们市', N'2_59', N'延边朝鲜族自治州', N'NULL', 3, N'222402', N'TuMenShi', N'YanBianChaoXianZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_583', N'敦化市', N'2_59', N'延边朝鲜族自治州', N'NULL', 3, N'222403', N'DunHuaShi', N'YanBianChaoXianZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_584', N'珲春市', N'2_59', N'延边朝鲜族自治州', N'NULL', 3, N'222404', N'HuiChunShi', N'YanBianChaoXianZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_585', N'龙井市', N'2_59', N'延边朝鲜族自治州', N'NULL', 3, N'222405', N'LongJingShi', N'YanBianChaoXianZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_586', N'和龙市', N'2_59', N'延边朝鲜族自治州', N'NULL', 3, N'222406', N'HeLongShi', N'YanBianChaoXianZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_587', N'汪清县', N'2_59', N'延边朝鲜族自治州', N'NULL', 3, N'222424', N'WangQingXian', N'YanBianChaoXianZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_588', N'安图县', N'2_59', N'延边朝鲜族自治州', N'NULL', 3, N'222426', N'AnTuXian', N'YanBianChaoXianZuZiZhiZhou')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_589', N'道里区', N'2_60', N'哈尔滨市', N'NULL', 3, N'230102', N'DaoLiQu', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_59', N'鹿泉市', N'2_3', N'石家庄市', N'NULL', 3, N'130185', N'LuQuanShi', N'ShiJiaZhuangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_590', N'南岗区', N'2_60', N'哈尔滨市', N'NULL', 3, N'230103', N'NanGangQu', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_591', N'道外区', N'2_60', N'哈尔滨市', N'NULL', 3, N'230104', N'DaoWaiQu', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_592', N'香坊区', N'2_60', N'哈尔滨市', N'NULL', 3, N'230110', N'XiangFangQu', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_594', N'平房区', N'2_60', N'哈尔滨市', N'NULL', 3, N'230108', N'PingFangQu', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_595', N'松北区', N'2_60', N'哈尔滨市', N'NULL', 3, N'230109', N'SongBeiQu', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_596', N'呼兰区', N'2_60', N'哈尔滨市', N'NULL', 3, N'230111', N'HuLanQu', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_597', N'依兰县', N'2_60', N'哈尔滨市', N'NULL', 3, N'230123', N'YiLanXian', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_598', N'方正县', N'2_60', N'哈尔滨市', N'NULL', 3, N'230124', N'FangZhengXian', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_599', N'宾县', N'2_60', N'哈尔滨市', N'NULL', 3, N'230125', N'BinXian', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_6', N'丰台区', N'2_1', N'北京市', N'NULL', 3, N'110106', N'FengTaiQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_60', N'路南区', N'2_4', N'唐山市', N'NULL', 3, N'130202', N'LuNanQu', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_600', N'巴彦县', N'2_60', N'哈尔滨市', N'NULL', 3, N'230126', N'BaYanXian', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_601', N'木兰县', N'2_60', N'哈尔滨市', N'NULL', 3, N'230127', N'MuLanXian', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_602', N'通河县', N'2_60', N'哈尔滨市', N'NULL', 3, N'230128', N'TongHeXian', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_603', N'延寿县', N'2_60', N'哈尔滨市', N'NULL', 3, N'230129', N'YanShouXian', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_604', N'阿城区', N'2_60', N'哈尔滨市', N'NULL', 3, N'230112', N'AChengQu', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_605', N'双城市', N'2_60', N'哈尔滨市', N'NULL', 3, N'230182', N'ShuangChengShi', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_606', N'尚志市', N'2_60', N'哈尔滨市', N'NULL', 3, N'230183', N'ShangZhiShi', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_607', N'五常市', N'2_60', N'哈尔滨市', N'NULL', 3, N'230184', N'WuChangShi', N'HaErBinShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_608', N'龙沙区', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230202', N'LongShaQu', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_609', N'建华区', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230203', N'JianHuaQu', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_61', N'路北区', N'2_4', N'唐山市', N'NULL', 3, N'130203', N'LuBeiQu', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_610', N'铁锋区', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230204', N'TieFengQu', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_611', N'昂昂溪区', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230205', N'AngAngXiQu', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_612', N'富拉尔基区', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230206', N'FuLaErJiQu', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_613', N'碾子山区', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230207', N'NianZiShanQu', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_614', N'梅里斯达斡尔族区', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230208', N'MeiLiSiDaWoErZuQu', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_615', N'龙江县', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230221', N'LongJiangXian', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_616', N'依安县', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230223', N'YiAnXian', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_617', N'泰来县', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230224', N'TaiLaiXian', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_618', N'甘南县', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230225', N'GanNanXian', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_619', N'富裕县', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230227', N'FuYuXian', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_62', N'古冶区', N'2_4', N'唐山市', N'NULL', 3, N'130204', N'GuYeQu', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_620', N'克山县', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230229', N'KeShanXian', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_621', N'克东县', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230230', N'KeDongXian', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_622', N'拜泉县', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230231', N'BaiQuanXian', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_623', N'讷河市', N'2_61', N'齐齐哈尔市', N'NULL', 3, N'230281', N'NeHeShi', N'QiQiHaErShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_624', N'鸡冠区', N'2_62', N'鸡西市', N'NULL', 3, N'230302', N'JiGuanQu', N'JiXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_625', N'恒山区', N'2_62', N'鸡西市', N'NULL', 3, N'230303', N'HengShanQu', N'JiXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_626', N'滴道区', N'2_62', N'鸡西市', N'NULL', 3, N'230304', N'DiDaoQu', N'JiXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_627', N'梨树区', N'2_62', N'鸡西市', N'NULL', 3, N'230305', N'LiShuQu', N'JiXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_628', N'城子河区', N'2_62', N'鸡西市', N'NULL', 3, N'230306', N'ChengZiHeQu', N'JiXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_629', N'麻山区', N'2_62', N'鸡西市', N'NULL', 3, N'230307', N'MaShanQu', N'JiXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_63', N'开平区', N'2_4', N'唐山市', N'NULL', 3, N'130205', N'KaiPingQu', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_630', N'鸡东县', N'2_62', N'鸡西市', N'NULL', 3, N'230321', N'JiDongXian', N'JiXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_631', N'虎林市', N'2_62', N'鸡西市', N'NULL', 3, N'230381', N'HuLinShi', N'JiXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_632', N'密山市', N'2_62', N'鸡西市', N'NULL', 3, N'230382', N'MiShanShi', N'JiXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_633', N'向阳区', N'2_63', N'鹤岗市', N'NULL', 3, N'230402', N'XiangYangQu', N'HeGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_634', N'工农区', N'2_63', N'鹤岗市', N'NULL', 3, N'230403', N'GongNongQu', N'HeGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_635', N'南山区', N'2_63', N'鹤岗市', N'NULL', 3, N'230404', N'NanShanQu', N'HeGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_636', N'兴安区', N'2_63', N'鹤岗市', N'NULL', 3, N'230405', N'XingAnQu', N'HeGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_637', N'东山区', N'2_63', N'鹤岗市', N'NULL', 3, N'230406', N'DongShanQu', N'HeGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_638', N'兴山区', N'2_63', N'鹤岗市', N'NULL', 3, N'230407', N'XingShanQu', N'HeGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_639', N'萝北县', N'2_63', N'鹤岗市', N'NULL', 3, N'230421', N'LuoBeiXian', N'HeGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_64', N'丰南区', N'2_4', N'唐山市', N'NULL', 3, N'130207', N'FengNanQu', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_640', N'绥滨县', N'2_63', N'鹤岗市', N'NULL', 3, N'230422', N'SuiBinXian', N'HeGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_641', N'尖山区', N'2_64', N'双鸭山市', N'NULL', 3, N'230502', N'JianShanQu', N'ShuangYaShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_642', N'岭东区', N'2_64', N'双鸭山市', N'NULL', 3, N'230503', N'LingDongQu', N'ShuangYaShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_643', N'四方台区', N'2_64', N'双鸭山市', N'NULL', 3, N'230505', N'SiFangTaiQu', N'ShuangYaShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_644', N'宝山区', N'2_64', N'双鸭山市', N'NULL', 3, N'230506', N'BaoShanQu', N'ShuangYaShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_645', N'集贤县', N'2_64', N'双鸭山市', N'NULL', 3, N'230521', N'JiXianXian', N'ShuangYaShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_646', N'友谊县', N'2_64', N'双鸭山市', N'NULL', 3, N'230522', N'YouYiXian', N'ShuangYaShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_647', N'宝清县', N'2_64', N'双鸭山市', N'NULL', 3, N'230523', N'BaoQingXian', N'ShuangYaShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_648', N'饶河县', N'2_64', N'双鸭山市', N'NULL', 3, N'230524', N'RaoHeXian', N'ShuangYaShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_649', N'萨尔图区', N'2_65', N'大庆市', N'NULL', 3, N'230602', N'SaErTuQu', N'DaQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_65', N'丰润区', N'2_4', N'唐山市', N'NULL', 3, N'130208', N'FengRunQu', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_650', N'龙凤区', N'2_65', N'大庆市', N'NULL', 3, N'230603', N'LongFengQu', N'DaQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_651', N'让胡路区', N'2_65', N'大庆市', N'NULL', 3, N'230604', N'RangHuLuQu', N'DaQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_652', N'红岗区', N'2_65', N'大庆市', N'NULL', 3, N'230605', N'HongGangQu', N'DaQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_653', N'大同区', N'2_65', N'大庆市', N'NULL', 3, N'230606', N'DaTongQu', N'DaQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_654', N'肇州县', N'2_65', N'大庆市', N'NULL', 3, N'230621', N'ZhaoZhouXian', N'DaQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_655', N'肇源县', N'2_65', N'大庆市', N'NULL', 3, N'230622', N'ZhaoYuanXian', N'DaQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_656', N'林甸县', N'2_65', N'大庆市', N'NULL', 3, N'230623', N'LinDianXian', N'DaQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_657', N'杜尔伯特蒙古族自治县', N'2_65', N'大庆市', N'NULL', 3, N'230624', N'DuErBoTeMengGuZuZiZhiXian', N'DaQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_658', N'伊春区', N'2_66', N'伊春市', N'NULL', 3, N'230702', N'YiChunQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_659', N'南岔区', N'2_66', N'伊春市', N'NULL', 3, N'230703', N'NanChaQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_66', N'滦县', N'2_4', N'唐山市', N'NULL', 3, N'130223', N'LuanXian', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_660', N'友好区', N'2_66', N'伊春市', N'NULL', 3, N'230704', N'YouHaoQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_661', N'西林区', N'2_66', N'伊春市', N'NULL', 3, N'230705', N'XiLinQu', N'YiChunShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_662', N'翠峦区', N'2_66', N'伊春市', N'NULL', 3, N'230706', N'CuiLuanQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_663', N'新青区', N'2_66', N'伊春市', N'NULL', 3, N'230707', N'XinQingQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_664', N'美溪区', N'2_66', N'伊春市', N'NULL', 3, N'230708', N'MeiXiQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_665', N'金山屯区', N'2_66', N'伊春市', N'NULL', 3, N'230709', N'JinShanTunQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_666', N'五营区', N'2_66', N'伊春市', N'NULL', 3, N'230710', N'WuYingQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_667', N'乌马河区', N'2_66', N'伊春市', N'NULL', 3, N'230711', N'WuMaHeQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_668', N'汤旺河区', N'2_66', N'伊春市', N'NULL', 3, N'230712', N'TangWangHeQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_669', N'带岭区', N'2_66', N'伊春市', N'NULL', 3, N'230713', N'DaiLingQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_67', N'滦南县', N'2_4', N'唐山市', N'NULL', 3, N'130224', N'LuanNanXian', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_670', N'乌伊岭区', N'2_66', N'伊春市', N'NULL', 3, N'230714', N'WuYiLingQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_671', N'红星区', N'2_66', N'伊春市', N'NULL', 3, N'230715', N'HongXingQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_672', N'上甘岭区', N'2_66', N'伊春市', N'NULL', 3, N'230716', N'ShangGanLingQu', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_673', N'嘉荫县', N'2_66', N'伊春市', N'NULL', 3, N'230722', N'JiaYinXian', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_674', N'铁力市', N'2_66', N'伊春市', N'NULL', 3, N'230781', N'TieLiShi', N'YiChunShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_676', N'向阳区', N'2_67', N'佳木斯市', N'NULL', 3, N'230803', N'XiangYangQu', N'JiaMuSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_677', N'前进区', N'2_67', N'佳木斯市', N'NULL', 3, N'230804', N'QianJinQu', N'JiaMuSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_678', N'东风区', N'2_67', N'佳木斯市', N'NULL', 3, N'230805', N'DongFengQu', N'JiaMuSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_679', N'郊区', N'2_67', N'佳木斯市', N'NULL', 3, N'230811', N'JiaoQu', N'JiaMuSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_68', N'乐亭县', N'2_4', N'唐山市', N'NULL', 3, N'130225', N'LeTingXian', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_680', N'桦南县', N'2_67', N'佳木斯市', N'NULL', 3, N'230822', N'HuaNanXian', N'JiaMuSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_681', N'桦川县', N'2_67', N'佳木斯市', N'NULL', 3, N'230826', N'HuaChuanXian', N'JiaMuSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_682', N'汤原县', N'2_67', N'佳木斯市', N'NULL', 3, N'230828', N'TangYuanXian', N'JiaMuSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_683', N'抚远县', N'2_67', N'佳木斯市', N'NULL', 3, N'230833', N'FuYuanXian', N'JiaMuSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_684', N'同江市', N'2_67', N'佳木斯市', N'NULL', 3, N'230881', N'TongJiangShi', N'JiaMuSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_685', N'富锦市', N'2_67', N'佳木斯市', N'NULL', 3, N'230882', N'FuJinShi', N'JiaMuSiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_686', N'新兴区', N'2_68', N'七台河市', N'NULL', 3, N'230902', N'XinXingQu', N'QiTaiHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_687', N'桃山区', N'2_68', N'七台河市', N'NULL', 3, N'230903', N'TaoShanQu', N'QiTaiHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_688', N'茄子河区', N'2_68', N'七台河市', N'NULL', 3, N'230904', N'QieZiHeQu', N'QiTaiHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_689', N'勃利县', N'2_68', N'七台河市', N'NULL', 3, N'230921', N'BoLiXian', N'QiTaiHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_69', N'迁西县', N'2_4', N'唐山市', N'NULL', 3, N'130227', N'QianXiXian', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_690', N'东安区', N'2_69', N'牡丹江市', N'NULL', 3, N'231002', N'DongAnQu', N'MuDanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_691', N'阳明区', N'2_69', N'牡丹江市', N'NULL', 3, N'231003', N'YangMingQu', N'MuDanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_692', N'爱民区', N'2_69', N'牡丹江市', N'NULL', 3, N'231004', N'AiMinQu', N'MuDanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_693', N'西安区', N'2_69', N'牡丹江市', N'NULL', 3, N'231005', N'XiAnQu', N'MuDanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_694', N'东宁县', N'2_69', N'牡丹江市', N'NULL', 3, N'231024', N'DongNingXian', N'MuDanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_695', N'林口县', N'2_69', N'牡丹江市', N'NULL', 3, N'231025', N'LinKouXian', N'MuDanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_696', N'绥芬河市', N'2_69', N'牡丹江市', N'NULL', 3, N'231081', N'SuiFenHeShi', N'MuDanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_697', N'海林市', N'2_69', N'牡丹江市', N'NULL', 3, N'231083', N'HaiLinShi', N'MuDanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_698', N'宁安市', N'2_69', N'牡丹江市', N'NULL', 3, N'231084', N'NingAnShi', N'MuDanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_699', N'穆棱市', N'2_69', N'牡丹江市', N'NULL', 3, N'231085', N'MuLengShi', N'MuDanJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_7', N'石景山区', N'2_1', N'北京市', N'NULL', 3, N'110107', N'ShiJingShanQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_70', N'玉田县', N'2_4', N'唐山市', N'NULL', 3, N'130229', N'YuTianXian', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_700', N'爱辉区', N'2_70', N'黑河市', N'NULL', 3, N'231102', N'AiHuiQu', N'HeiHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_701', N'嫩江县', N'2_70', N'黑河市', N'NULL', 3, N'231121', N'NenJiangXian', N'HeiHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_702', N'逊克县', N'2_70', N'黑河市', N'NULL', 3, N'231123', N'XunKeXian', N'HeiHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_703', N'孙吴县', N'2_70', N'黑河市', N'NULL', 3, N'231124', N'SunWuXian', N'HeiHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_704', N'北安市', N'2_70', N'黑河市', N'NULL', 3, N'231181', N'BeiAnShi', N'HeiHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_705', N'五大连池市', N'2_70', N'黑河市', N'NULL', 3, N'231182', N'WuDaLianChiShi', N'HeiHeShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_706', N'北林区', N'2_71', N'绥化市', N'NULL', 3, N'231202', N'BeiLinQu', N'SuiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_707', N'望奎县', N'2_71', N'绥化市', N'NULL', 3, N'231221', N'WangKuiXian', N'SuiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_708', N'兰西县', N'2_71', N'绥化市', N'NULL', 3, N'231222', N'LanXiXian', N'SuiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_709', N'青冈县', N'2_71', N'绥化市', N'NULL', 3, N'231223', N'QingGangXian', N'SuiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_71', N'唐海县', N'2_4', N'唐山市', N'NULL', 3, N'130230', N'TangHaiXian', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_710', N'庆安县', N'2_71', N'绥化市', N'NULL', 3, N'231224', N'QingAnXian', N'SuiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_711', N'明水县', N'2_71', N'绥化市', N'NULL', 3, N'231225', N'MingShuiXian', N'SuiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_712', N'绥棱县', N'2_71', N'绥化市', N'NULL', 3, N'231226', N'SuiLengXian', N'SuiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_713', N'安达市', N'2_71', N'绥化市', N'NULL', 3, N'231281', N'AnDaShi', N'SuiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_714', N'肇东市', N'2_71', N'绥化市', N'NULL', 3, N'231282', N'ZhaoDongShi', N'SuiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_715', N'海伦市', N'2_71', N'绥化市', N'NULL', 3, N'231283', N'HaiLunShi', N'SuiHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_716', N'呼玛县', N'2_72', N'大兴安岭地区', N'NULL', 3, N'232721', N'HuMaXian', N'DaXingAnLingDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_717', N'塔河县', N'2_72', N'大兴安岭地区', N'NULL', 3, N'232722', N'TaHeXian', N'DaXingAnLingDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_718', N'漠河县', N'2_72', N'大兴安岭地区', N'NULL', 3, N'232723', N'MoHeXian', N'DaXingAnLingDiQu')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_719', N'黄浦区', N'2_73', N'上海市', N'NULL', 3, N'310101', N'HuangPuQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_72', N'遵化市', N'2_4', N'唐山市', N'NULL', 3, N'130281', N'ZunHuaShi', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_720', N'卢湾区', N'2_73', N'上海市', N'NULL', 3, N'310103', N'LuWanQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_721', N'徐汇区', N'2_73', N'上海市', N'NULL', 3, N'310104', N'XuHuiQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_722', N'长宁区', N'2_73', N'上海市', N'NULL', 3, N'310105', N'ChangNingQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_723', N'静安区', N'2_73', N'上海市', N'NULL', 3, N'310106', N'JingAnQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_724', N'普陀区', N'2_73', N'上海市', N'NULL', 3, N'310107', N'PuTuoQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_725', N'闸北区', N'2_73', N'上海市', N'NULL', 3, N'310108', N'ZhaBeiQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_726', N'虹口区', N'2_73', N'上海市', N'NULL', 3, N'310109', N'HongKouQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_727', N'杨浦区', N'2_73', N'上海市', N'NULL', 3, N'310110', N'YangPuQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_728', N'闵行区', N'2_73', N'上海市', N'NULL', 3, N'310112', N'MinXingQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_729', N'宝山区', N'2_73', N'上海市', N'NULL', 3, N'310113', N'BaoShanQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_73', N'迁安市', N'2_4', N'唐山市', N'NULL', 3, N'130283', N'QianAnShi', N'TangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_730', N'嘉定区', N'2_73', N'上海市', N'NULL', 3, N'310114', N'JiaDingQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_731', N'浦东新区', N'2_73', N'上海市', N'NULL', 3, N'310115', N'PuDongXinQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_732', N'金山区', N'2_73', N'上海市', N'NULL', 3, N'310116', N'JinShanQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_733', N'松江区', N'2_73', N'上海市', N'NULL', 3, N'310117', N'SongJiangQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_734', N'青浦区', N'2_73', N'上海市', N'NULL', 3, N'310118', N'QingPuQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_735', N'南汇区', N'2_73', N'上海市', N'NULL', 3, N'310119', N'NanHuiQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_736', N'奉贤区', N'2_73', N'上海市', N'NULL', 3, N'310120', N'FengXianQu', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_737', N'崇明县', N'2_73', N'上海市', N'NULL', 3, N'310230', N'ChongMingXian', N'ShangHaiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_738', N'玄武区', N'2_74', N'南京市', N'NULL', 3, N'320102', N'XuanWuQu', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_739', N'白下区', N'2_74', N'南京市', N'NULL', 3, N'320103', N'BaiXiaQu', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_74', N'海港区', N'2_5', N'秦皇岛市', N'NULL', 3, N'130302', N'HaiGangQu', N'QinHuangDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_740', N'秦淮区', N'2_74', N'南京市', N'NULL', 3, N'320104', N'QinHuaiQu', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_741', N'建邺区', N'2_74', N'南京市', N'NULL', 3, N'320105', N'JianYeQu', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_742', N'鼓楼区', N'2_74', N'南京市', N'NULL', 3, N'320106', N'GuLouQu', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_743', N'下关区', N'2_74', N'南京市', N'NULL', 3, N'320107', N'XiaGuanQu', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_744', N'浦口区', N'2_74', N'南京市', N'NULL', 3, N'320111', N'PuKouQu', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_745', N'栖霞区', N'2_74', N'南京市', N'NULL', 3, N'320113', N'QiXiaQu', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_746', N'雨花台区', N'2_74', N'南京市', N'NULL', 3, N'320114', N'YuHuaTaiQu', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_747', N'江宁区', N'2_74', N'南京市', N'NULL', 3, N'320115', N'JiangNingQu', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_748', N'六合区', N'2_74', N'南京市', N'NULL', 3, N'320116', N'LiuHeQu', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_749', N'溧水县', N'2_74', N'南京市', N'NULL', 3, N'320124', N'LiShuiXian', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_75', N'山海关区', N'2_5', N'秦皇岛市', N'NULL', 3, N'130303', N'ShanHaiGuanQu', N'QinHuangDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_750', N'高淳县', N'2_74', N'南京市', N'NULL', 3, N'320125', N'GaoChunXian', N'NanJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_751', N'崇安区', N'2_75', N'无锡市', N'NULL', 3, N'320202', N'ChongAnQu', N'WuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_752', N'南长区', N'2_75', N'无锡市', N'NULL', 3, N'320203', N'NanChangQu', N'WuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_753', N'北塘区', N'2_75', N'无锡市', N'NULL', 3, N'320204', N'BeiTangQu', N'WuXiShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_754', N'锡山区', N'2_75', N'无锡市', N'NULL', 3, N'320205', N'XiShanQu', N'WuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_755', N'惠山区', N'2_75', N'无锡市', N'NULL', 3, N'320206', N'HuiShanQu', N'WuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_756', N'滨湖区', N'2_75', N'无锡市', N'NULL', 3, N'320211', N'BinHuQu', N'WuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_757', N'江阴市', N'2_75', N'无锡市', N'NULL', 3, N'320281', N'JiangYinShi', N'WuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_758', N'宜兴市', N'2_75', N'无锡市', N'NULL', 3, N'320282', N'YiXingShi', N'WuXiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_759', N'鼓楼区', N'2_76', N'徐州市', N'NULL', 3, N'320302', N'GuLouQu', N'XuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_76', N'北戴河区', N'2_5', N'秦皇岛市', N'NULL', 3, N'130304', N'BeiDaiHeQu', N'QinHuangDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_760', N'云龙区', N'2_76', N'徐州市', N'NULL', 3, N'320303', N'YunLongQu', N'XuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_761', N'九里区', N'2_76', N'徐州市', N'NULL', 3, N'320304', N'JiuLiQu', N'XuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_762', N'贾汪区', N'2_76', N'徐州市', N'NULL', 3, N'320305', N'JiaWangQu', N'XuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_763', N'泉山区', N'2_76', N'徐州市', N'NULL', 3, N'320311', N'QuanShanQu', N'XuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_764', N'丰县', N'2_76', N'徐州市', N'NULL', 3, N'320321', N'FengXian', N'XuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_765', N'沛县', N'2_76', N'徐州市', N'NULL', 3, N'320322', N'PeiXian', N'XuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_766', N'铜山县', N'2_76', N'徐州市', N'NULL', 3, N'320323', N'TongShanXian', N'XuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_767', N'睢宁县', N'2_76', N'徐州市', N'NULL', 3, N'320324', N'SuiNingXian', N'XuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_768', N'新沂市', N'2_76', N'徐州市', N'NULL', 3, N'320381', N'XinYiShi', N'XuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_769', N'邳州市', N'2_76', N'徐州市', N'NULL', 3, N'320382', N'PiZhouShi', N'XuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_77', N'青龙满族自治县', N'2_5', N'秦皇岛市', N'NULL', 3, N'130321', N'QingLongManZuZiZhiXian', N'QinHuangDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_770', N'天宁区', N'2_77', N'常州市', N'NULL', 3, N'320402', N'TianNingQu', N'ChangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_771', N'钟楼区', N'2_77', N'常州市', N'NULL', 3, N'320404', N'ZhongLouQu', N'ChangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_772', N'戚墅堰区', N'2_77', N'常州市', N'NULL', 3, N'320405', N'QiShuYanQu', N'ChangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_773', N'新北区', N'2_77', N'常州市', N'NULL', 3, N'320411', N'XinBeiQu', N'ChangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_774', N'武进区', N'2_77', N'常州市', N'NULL', 3, N'320412', N'WuJinQu', N'ChangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_775', N'溧阳市', N'2_77', N'常州市', N'NULL', 3, N'320481', N'LiYangShi', N'ChangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_776', N'金坛市', N'2_77', N'常州市', N'NULL', 3, N'320482', N'JinTanShi', N'ChangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_777', N'沧浪区', N'2_78', N'苏州市', N'NULL', 3, N'320502', N'CangLangQu', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_778', N'平江区', N'2_78', N'苏州市', N'NULL', 3, N'320503', N'PingJiangQu', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_779', N'金阊区', N'2_78', N'苏州市', N'NULL', 3, N'320504', N'JinChangQu', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_78', N'昌黎县', N'2_5', N'秦皇岛市', N'NULL', 3, N'130322', N'ChangLiXian', N'QinHuangDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_780', N'虎丘区', N'2_78', N'苏州市', N'NULL', 3, N'320505', N'HuQiuQu', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_781', N'吴中区', N'2_78', N'苏州市', N'NULL', 3, N'320506', N'WuZhongQu', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_782', N'相城区', N'2_78', N'苏州市', N'NULL', 3, N'320507', N'XiangChengQu', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_783', N'常熟市', N'2_78', N'苏州市', N'NULL', 3, N'320581', N'ChangShuShi', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_784', N'张家港市', N'2_78', N'苏州市', N'NULL', 3, N'320582', N'ZhangJiaGangShi', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_785', N'昆山市', N'2_78', N'苏州市', N'NULL', 3, N'320583', N'KunShanShi', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_786', N'吴江市', N'2_78', N'苏州市', N'NULL', 3, N'320584', N'WuJiangShi', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_787', N'太仓市', N'2_78', N'苏州市', N'NULL', 3, N'320585', N'TaiCangShi', N'SuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_788', N'崇川区', N'2_79', N'南通市', N'NULL', 3, N'320602', N'ChongChuanQu', N'NanTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_789', N'港闸区', N'2_79', N'南通市', N'NULL', 3, N'320611', N'GangZhaQu', N'NanTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_79', N'抚宁县', N'2_5', N'秦皇岛市', N'NULL', 3, N'130323', N'FuNingXian', N'QinHuangDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_790', N'海安县', N'2_79', N'南通市', N'NULL', 3, N'320621', N'HaiAnXian', N'NanTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_791', N'如东县', N'2_79', N'南通市', N'NULL', 3, N'320623', N'RuDongXian', N'NanTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_792', N'启东市', N'2_79', N'南通市', N'NULL', 3, N'320681', N'QiDongShi', N'NanTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_793', N'如皋市', N'2_79', N'南通市', N'NULL', 3, N'320682', N'RuGaoShi', N'NanTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_794', N'通州市', N'2_79', N'南通市', N'NULL', 3, N'320683', N'TongZhouShi', N'NanTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_795', N'海门市', N'2_79', N'南通市', N'NULL', 3, N'320684', N'HaiMenShi', N'NanTongShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_796', N'连云区', N'2_80', N'连云港市', N'NULL', 3, N'320703', N'LianYunQu', N'LianYunGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_797', N'新浦区', N'2_80', N'连云港市', N'NULL', 3, N'320705', N'XinPuQu', N'LianYunGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_798', N'海州区', N'2_80', N'连云港市', N'NULL', 3, N'320706', N'HaiZhouQu', N'LianYunGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_799', N'赣榆县', N'2_80', N'连云港市', N'NULL', 3, N'320721', N'GanYuXian', N'LianYunGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_8', N'海淀区', N'2_1', N'北京市', N'NULL', 3, N'110108', N'HaiDianQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_80', N'卢龙县', N'2_5', N'秦皇岛市', N'NULL', 3, N'130324', N'LuLongXian', N'QinHuangDaoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_800', N'东海县', N'2_80', N'连云港市', N'NULL', 3, N'320722', N'DongHaiXian', N'LianYunGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_801', N'灌云县', N'2_80', N'连云港市', N'NULL', 3, N'320723', N'GuanYunXian', N'LianYunGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_802', N'灌南县', N'2_80', N'连云港市', N'NULL', 3, N'320724', N'GuanNanXian', N'LianYunGangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_803', N'清河区', N'2_81', N'淮安市', N'NULL', 3, N'320802', N'QingHeQu', N'HuaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_804', N'楚州区', N'2_81', N'淮安市', N'NULL', 3, N'320803', N'ChuZhouQu', N'HuaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_805', N'淮阴区', N'2_81', N'淮安市', N'NULL', 3, N'320804', N'HuaiYinQu', N'HuaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_806', N'清浦区', N'2_81', N'淮安市', N'NULL', 3, N'320811', N'QingPuQu', N'HuaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_807', N'涟水县', N'2_81', N'淮安市', N'NULL', 3, N'320826', N'LianShuiXian', N'HuaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_808', N'洪泽县', N'2_81', N'淮安市', N'NULL', 3, N'320829', N'HongZeXian', N'HuaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_809', N'盱眙县', N'2_81', N'淮安市', N'NULL', 3, N'320830', N'XuYiXian', N'HuaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_81', N'邯山区', N'2_6', N'邯郸市', N'NULL', 3, N'130402', N'HanShanQu', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_810', N'金湖县', N'2_81', N'淮安市', N'NULL', 3, N'320831', N'JinHuXian', N'HuaiAnShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_811', N'亭湖区', N'2_82', N'盐城市', N'NULL', 3, N'320902', N'TingHuQu', N'YanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_812', N'盐都区', N'2_82', N'盐城市', N'NULL', 3, N'320903', N'YanDouQu', N'YanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_813', N'响水县', N'2_82', N'盐城市', N'NULL', 3, N'320921', N'XiangShuiXian', N'YanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_814', N'滨海县', N'2_82', N'盐城市', N'NULL', 3, N'320922', N'BinHaiXian', N'YanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_815', N'阜宁县', N'2_82', N'盐城市', N'NULL', 3, N'320923', N'FuNingXian', N'YanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_816', N'射阳县', N'2_82', N'盐城市', N'NULL', 3, N'320924', N'SheYangXian', N'YanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_817', N'建湖县', N'2_82', N'盐城市', N'NULL', 3, N'320925', N'JianHuXian', N'YanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_818', N'东台市', N'2_82', N'盐城市', N'NULL', 3, N'320981', N'DongTaiShi', N'YanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_819', N'大丰市', N'2_82', N'盐城市', N'NULL', 3, N'320982', N'DaFengShi', N'YanChengShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_82', N'丛台区', N'2_6', N'邯郸市', N'NULL', 3, N'130403', N'CongTaiQu', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_820', N'广陵区', N'2_83', N'扬州市', N'NULL', 3, N'321002', N'GuangLingQu', N'YangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_821', N'邗江区', N'2_83', N'扬州市', N'NULL', 3, N'321003', N'HanJiangQu', N'YangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_822', N'维扬区', N'2_83', N'扬州市', N'NULL', 3, N'321011', N'WeiYangQu', N'YangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_823', N'宝应县', N'2_83', N'扬州市', N'NULL', 3, N'321023', N'BaoYingXian', N'YangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_824', N'仪征市', N'2_83', N'扬州市', N'NULL', 3, N'321081', N'YiZhengShi', N'YangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_825', N'高邮市', N'2_83', N'扬州市', N'NULL', 3, N'321084', N'GaoYouShi', N'YangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_826', N'江都市', N'2_83', N'扬州市', N'NULL', 3, N'321088', N'JiangDouShi', N'YangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_827', N'京口区', N'2_84', N'镇江市', N'NULL', 3, N'321102', N'JingKouQu', N'ZhenJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_828', N'润州区', N'2_84', N'镇江市', N'NULL', 3, N'321111', N'RunZhouQu', N'ZhenJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_829', N'丹徒区', N'2_84', N'镇江市', N'NULL', 3, N'321112', N'DanTuQu', N'ZhenJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_83', N'复兴区', N'2_6', N'邯郸市', N'NULL', 3, N'130404', N'FuXingQu', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_830', N'丹阳市', N'2_84', N'镇江市', N'NULL', 3, N'321181', N'DanYangShi', N'ZhenJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_831', N'扬中市', N'2_84', N'镇江市', N'NULL', 3, N'321182', N'YangZhongShi', N'ZhenJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_832', N'句容市', N'2_84', N'镇江市', N'NULL', 3, N'321183', N'JuRongShi', N'ZhenJiangShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_833', N'海陵区', N'2_85', N'泰州市', N'NULL', 3, N'321202', N'HaiLingQu', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_834', N'高港区', N'2_85', N'泰州市', N'NULL', 3, N'321203', N'GaoGangQu', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_835', N'兴化市', N'2_85', N'泰州市', N'NULL', 3, N'321281', N'XingHuaShi', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_836', N'靖江市', N'2_85', N'泰州市', N'NULL', 3, N'321282', N'JingJiangShi', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_837', N'泰兴市', N'2_85', N'泰州市', N'NULL', 3, N'321283', N'TaiXingShi', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_838', N'姜堰市', N'2_85', N'泰州市', N'NULL', 3, N'321284', N'JiangYanShi', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_839', N'宿城区', N'2_86', N'宿迁市', N'NULL', 3, N'321302', N'SuChengQu', N'SuQianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_84', N'峰峰矿区', N'2_6', N'邯郸市', N'NULL', 3, N'130406', N'FengFengKuangQu', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_840', N'宿豫区', N'2_86', N'宿迁市', N'NULL', 3, N'321311', N'SuYuQu', N'SuQianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_841', N'沭阳县', N'2_86', N'宿迁市', N'NULL', 3, N'321322', N'ShuYangXian', N'SuQianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_842', N'泗阳县', N'2_86', N'宿迁市', N'NULL', 3, N'321323', N'SiYangXian', N'SuQianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_843', N'泗洪县', N'2_86', N'宿迁市', N'NULL', 3, N'321324', N'SiHongXian', N'SuQianShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_844', N'上城区', N'2_87', N'杭州市', N'NULL', 3, N'330102', N'ShangChengQu', N'HangZhouShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_845', N'下城区', N'2_87', N'杭州市', N'NULL', 3, N'330103', N'XiaChengQu', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_846', N'江干区', N'2_87', N'杭州市', N'NULL', 3, N'330104', N'JiangGanQu', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_847', N'拱墅区', N'2_87', N'杭州市', N'NULL', 3, N'330105', N'GongShuQu', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_848', N'西湖区', N'2_87', N'杭州市', N'NULL', 3, N'330106', N'XiHuQu', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_849', N'滨江区', N'2_87', N'杭州市', N'NULL', 3, N'330108', N'BinJiangQu', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_85', N'邯郸县', N'2_6', N'邯郸市', N'NULL', 3, N'130421', N'HanDanXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_850', N'萧山区', N'2_87', N'杭州市', N'NULL', 3, N'330109', N'XiaoShanQu', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_851', N'余杭区', N'2_87', N'杭州市', N'NULL', 3, N'330110', N'YuHangQu', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_852', N'桐庐县', N'2_87', N'杭州市', N'NULL', 3, N'330122', N'TongLuXian', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_853', N'淳安县', N'2_87', N'杭州市', N'NULL', 3, N'330127', N'ChunAnXian', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_854', N'建德市', N'2_87', N'杭州市', N'NULL', 3, N'330182', N'JianDeShi', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_855', N'富阳市', N'2_87', N'杭州市', N'NULL', 3, N'330183', N'FuYangShi', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_856', N'临安市', N'2_87', N'杭州市', N'NULL', 3, N'330185', N'LinAnShi', N'HangZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_857', N'海曙区', N'2_88', N'宁波市', N'NULL', 3, N'330203', N'HaiShuQu', N'NingBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_858', N'江东区', N'2_88', N'宁波市', N'NULL', 3, N'330204', N'JiangDongQu', N'NingBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_859', N'江北区', N'2_88', N'宁波市', N'NULL', 3, N'330205', N'JiangBeiQu', N'NingBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_86', N'临漳县', N'2_6', N'邯郸市', N'NULL', 3, N'130423', N'LinZhangXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_860', N'北仑区', N'2_88', N'宁波市', N'NULL', 3, N'330206', N'BeiLunQu', N'NingBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_861', N'镇海区', N'2_88', N'宁波市', N'NULL', 3, N'330211', N'ZhenHaiQu', N'NingBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_862', N'鄞州区', N'2_88', N'宁波市', N'NULL', 3, N'330212', N'YinZhouQu', N'NingBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_863', N'象山县', N'2_88', N'宁波市', N'NULL', 3, N'330225', N'XiangShanXian', N'NingBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_864', N'宁海县', N'2_88', N'宁波市', N'NULL', 3, N'330226', N'NingHaiXian', N'NingBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_865', N'余姚市', N'2_88', N'宁波市', N'NULL', 3, N'330281', N'YuYaoShi', N'NingBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_866', N'慈溪市', N'2_88', N'宁波市', N'NULL', 3, N'330282', N'CiXiShi', N'NingBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_867', N'奉化市', N'2_88', N'宁波市', N'NULL', 3, N'330283', N'FengHuaShi', N'NingBoShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_868', N'鹿城区', N'2_89', N'温州市', N'NULL', 3, N'330302', N'LuChengQu', N'WenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_869', N'龙湾区', N'2_89', N'温州市', N'NULL', 3, N'330303', N'LongWanQu', N'WenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_87', N'成安县', N'2_6', N'邯郸市', N'NULL', 3, N'130424', N'ChengAnXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_870', N'瓯海区', N'2_89', N'温州市', N'NULL', 3, N'330304', N'OuHaiQu', N'WenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_871', N'洞头县', N'2_89', N'温州市', N'NULL', 3, N'330322', N'DongTouXian', N'WenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_872', N'永嘉县', N'2_89', N'温州市', N'NULL', 3, N'330324', N'YongJiaXian', N'WenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_873', N'平阳县', N'2_89', N'温州市', N'NULL', 3, N'330326', N'PingYangXian', N'WenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_874', N'苍南县', N'2_89', N'温州市', N'NULL', 3, N'330327', N'CangNanXian', N'WenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_875', N'文成县', N'2_89', N'温州市', N'NULL', 3, N'330328', N'WenChengXian', N'WenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_876', N'泰顺县', N'2_89', N'温州市', N'NULL', 3, N'330329', N'TaiShunXian', N'WenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_877', N'瑞安市', N'2_89', N'温州市', N'NULL', 3, N'330381', N'RuiAnShi', N'WenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_878', N'乐清市', N'2_89', N'温州市', N'NULL', 3, N'330382', N'LeQingShi', N'WenZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_879', N'秀城区', N'2_90', N'嘉兴市', N'NULL', 3, N'330402', N'XiuChengQu', N'JiaXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_88', N'大名县', N'2_6', N'邯郸市', N'NULL', 3, N'130425', N'DaMingXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_880', N'秀洲区', N'2_90', N'嘉兴市', N'NULL', 3, N'330411', N'XiuZhouQu', N'JiaXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_881', N'嘉善县', N'2_90', N'嘉兴市', N'NULL', 3, N'330421', N'JiaShanXian', N'JiaXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_882', N'海盐县', N'2_90', N'嘉兴市', N'NULL', 3, N'330424', N'HaiYanXian', N'JiaXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_883', N'海宁市', N'2_90', N'嘉兴市', N'NULL', 3, N'330481', N'HaiNingShi', N'JiaXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_884', N'平湖市', N'2_90', N'嘉兴市', N'NULL', 3, N'330482', N'PingHuShi', N'JiaXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_885', N'桐乡市', N'2_90', N'嘉兴市', N'NULL', 3, N'330483', N'TongXiangShi', N'JiaXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_886', N'吴兴区', N'2_91', N'湖州市', N'NULL', 3, N'330502', N'WuXingQu', N'HuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_887', N'南浔区', N'2_91', N'湖州市', N'NULL', 3, N'330503', N'NanXunQu', N'HuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_888', N'德清县', N'2_91', N'湖州市', N'NULL', 3, N'330521', N'DeQingXian', N'HuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_889', N'长兴县', N'2_91', N'湖州市', N'NULL', 3, N'330522', N'ChangXingXian', N'HuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_89', N'涉县', N'2_6', N'邯郸市', N'NULL', 3, N'130426', N'SheXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_890', N'安吉县', N'2_91', N'湖州市', N'NULL', 3, N'330523', N'AnJiXian', N'HuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_891', N'越城区', N'2_92', N'绍兴市', N'NULL', 3, N'330602', N'YueChengQu', N'ShaoXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_892', N'绍兴县', N'2_92', N'绍兴市', N'NULL', 3, N'330621', N'ShaoXingXian', N'ShaoXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_893', N'新昌县', N'2_92', N'绍兴市', N'NULL', 3, N'330624', N'XinChangXian', N'ShaoXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_894', N'诸暨市', N'2_92', N'绍兴市', N'NULL', 3, N'330681', N'ZhuJiShi', N'ShaoXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_895', N'上虞市', N'2_92', N'绍兴市', N'NULL', 3, N'330682', N'ShangYuShi', N'ShaoXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_896', N'嵊州市', N'2_92', N'绍兴市', N'NULL', 3, N'330683', N'ShengZhouShi', N'ShaoXingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_897', N'婺城区', N'2_93', N'金华市', N'NULL', 3, N'330702', N'WuChengQu', N'JinHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_898', N'金东区', N'2_93', N'金华市', N'NULL', 3, N'330703', N'JinDongQu', N'JinHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_899', N'武义县', N'2_93', N'金华市', N'NULL', 3, N'330723', N'WuYiXian', N'JinHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_9', N'门头沟区', N'2_1', N'北京市', N'NULL', 3, N'110109', N'MenTouGouQu', N'BeiJingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_90', N'磁县', N'2_6', N'邯郸市', N'NULL', 3, N'130427', N'CiXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_900', N'浦江县', N'2_93', N'金华市', N'NULL', 3, N'330726', N'PuJiangXian', N'JinHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_901', N'磐安县', N'2_93', N'金华市', N'NULL', 3, N'330727', N'PanAnXian', N'JinHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_902', N'兰溪市', N'2_93', N'金华市', N'NULL', 3, N'330781', N'LanXiShi', N'JinHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_903', N'义乌市', N'2_93', N'金华市', N'NULL', 3, N'330782', N'YiWuShi', N'JinHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_904', N'东阳市', N'2_93', N'金华市', N'NULL', 3, N'330783', N'DongYangShi', N'JinHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_905', N'永康市', N'2_93', N'金华市', N'NULL', 3, N'330784', N'YongKangShi', N'JinHuaShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_906', N'柯城区', N'2_94', N'衢州市', N'NULL', 3, N'330802', N'KeChengQu', N'QuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_907', N'衢江区', N'2_94', N'衢州市', N'NULL', 3, N'330803', N'QuJiangQu', N'QuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_908', N'常山县', N'2_94', N'衢州市', N'NULL', 3, N'330822', N'ChangShanXian', N'QuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_909', N'开化县', N'2_94', N'衢州市', N'NULL', 3, N'330824', N'KaiHuaXian', N'QuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_91', N'肥乡县', N'2_6', N'邯郸市', N'NULL', 3, N'130428', N'FeiXiangXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_910', N'龙游县', N'2_94', N'衢州市', N'NULL', 3, N'330825', N'LongYouXian', N'QuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_911', N'江山市', N'2_94', N'衢州市', N'NULL', 3, N'330881', N'JiangShanShi', N'QuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_912', N'定海区', N'2_95', N'舟山市', N'NULL', 3, N'330902', N'DingHaiQu', N'ZhouShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_913', N'普陀区', N'2_95', N'舟山市', N'NULL', 3, N'330903', N'PuTuoQu', N'ZhouShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_914', N'岱山县', N'2_95', N'舟山市', N'NULL', 3, N'330921', N'DaiShanXian', N'ZhouShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_915', N'嵊泗县', N'2_95', N'舟山市', N'NULL', 3, N'330922', N'ShengSiXian', N'ZhouShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_916', N'椒江区', N'2_96', N'台州市', N'NULL', 3, N'331002', N'JiaoJiangQu', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_917', N'黄岩区', N'2_96', N'台州市', N'NULL', 3, N'331003', N'HuangYanQu', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_918', N'路桥区', N'2_96', N'台州市', N'NULL', 3, N'331004', N'LuQiaoQu', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_919', N'玉环县', N'2_96', N'台州市', N'NULL', 3, N'331021', N'YuHuanXian', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_92', N'永年县', N'2_6', N'邯郸市', N'NULL', 3, N'130429', N'YongNianXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_920', N'三门县', N'2_96', N'台州市', N'NULL', 3, N'331022', N'SanMenXian', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_921', N'天台县', N'2_96', N'台州市', N'NULL', 3, N'331023', N'TianTaiXian', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_922', N'仙居县', N'2_96', N'台州市', N'NULL', 3, N'331024', N'XianJuXian', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_923', N'温岭市', N'2_96', N'台州市', N'NULL', 3, N'331081', N'WenLingShi', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_924', N'临海市', N'2_96', N'台州市', N'NULL', 3, N'331082', N'LinHaiShi', N'TaiZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_925', N'莲都区', N'2_97', N'丽水市', N'NULL', 3, N'331102', N'LianDouQu', N'LiShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_926', N'青田县', N'2_97', N'丽水市', N'NULL', 3, N'331121', N'QingTianXian', N'LiShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_927', N'缙云县', N'2_97', N'丽水市', N'NULL', 3, N'331122', N'JinYunXian', N'LiShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_928', N'遂昌县', N'2_97', N'丽水市', N'NULL', 3, N'331123', N'SuiChangXian', N'LiShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_929', N'松阳县', N'2_97', N'丽水市', N'NULL', 3, N'331124', N'SongYangXian', N'LiShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_93', N'邱县', N'2_6', N'邯郸市', N'NULL', 3, N'130430', N'QiuXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_930', N'云和县', N'2_97', N'丽水市', N'NULL', 3, N'331125', N'YunHeXian', N'LiShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_931', N'庆元县', N'2_97', N'丽水市', N'NULL', 3, N'331126', N'QingYuanXian', N'LiShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_932', N'景宁畲族自治县', N'2_97', N'丽水市', N'NULL', 3, N'331127', N'JingNingSheZuZiZhiXian', N'LiShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_933', N'龙泉市', N'2_97', N'丽水市', N'NULL', 3, N'331181', N'LongQuanShi', N'LiShuiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_934', N'瑶海区', N'2_98', N'合肥市', N'NULL', 3, N'340102', N'YaoHaiQu', N'HeFeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_935', N'庐阳区', N'2_98', N'合肥市', N'NULL', 3, N'340103', N'LuYangQu', N'HeFeiShi')
GO
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_936', N'蜀山区', N'2_98', N'合肥市', N'NULL', 3, N'340104', N'ShuShanQu', N'HeFeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_937', N'包河区', N'2_98', N'合肥市', N'NULL', 3, N'340111', N'BaoHeQu', N'HeFeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_938', N'长丰县', N'2_98', N'合肥市', N'NULL', 3, N'340121', N'ChangFengXian', N'HeFeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_939', N'肥东县', N'2_98', N'合肥市', N'NULL', 3, N'340122', N'FeiDongXian', N'HeFeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_94', N'鸡泽县', N'2_6', N'邯郸市', N'NULL', 3, N'130431', N'JiZeXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_940', N'肥西县', N'2_98', N'合肥市', N'NULL', 3, N'340123', N'FeiXiXian', N'HeFeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_941', N'镜湖区', N'2_99', N'芜湖市', N'NULL', 3, N'340202', N'JingHuQu', N'WuHuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_942', N'弋江区', N'2_99', N'芜湖市', N'NULL', 3, N'340203', N'YiJiangQu', N'WuHuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_943', N'鸠江区', N'2_99', N'芜湖市', N'NULL', 3, N'340207', N'JiuJiangQu', N'WuHuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_944', N'三山区', N'2_99', N'芜湖市', N'NULL', 3, N'340208', N'SanShanQu', N'WuHuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_945', N'芜湖县', N'2_99', N'芜湖市', N'NULL', 3, N'340221', N'WuHuXian', N'WuHuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_946', N'繁昌县', N'2_99', N'芜湖市', N'NULL', 3, N'340222', N'FanChangXian', N'WuHuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_947', N'南陵县', N'2_99', N'芜湖市', N'NULL', 3, N'340223', N'NanLingXian', N'WuHuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_948', N'龙子湖区', N'2_100', N'蚌埠市', N'NULL', 3, N'340302', N'LongZiHuQu', N'BangBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_949', N'蚌山区', N'2_100', N'蚌埠市', N'NULL', 3, N'340303', N'BangShanQu', N'BangBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_95', N'广平县', N'2_6', N'邯郸市', N'NULL', 3, N'130432', N'GuangPingXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_950', N'禹会区', N'2_100', N'蚌埠市', N'NULL', 3, N'340304', N'YuHuiQu', N'BangBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_951', N'淮上区', N'2_100', N'蚌埠市', N'NULL', 3, N'340311', N'HuaiShangQu', N'BangBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_952', N'怀远县', N'2_100', N'蚌埠市', N'NULL', 3, N'340321', N'HuaiYuanXian', N'BangBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_953', N'五河县', N'2_100', N'蚌埠市', N'NULL', 3, N'340322', N'WuHeXian', N'BangBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_954', N'固镇县', N'2_100', N'蚌埠市', N'NULL', 3, N'340323', N'GuZhenXian', N'BangBuShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_955', N'大通区', N'2_101', N'淮南市', N'NULL', 3, N'340402', N'DaTongQu', N'HuaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_956', N'田家庵区', N'2_101', N'淮南市', N'NULL', 3, N'340403', N'TianJiaAnQu', N'HuaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_957', N'谢家集区', N'2_101', N'淮南市', N'NULL', 3, N'340404', N'XieJiaJiQu', N'HuaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_958', N'八公山区', N'2_101', N'淮南市', N'NULL', 3, N'340405', N'BaGongShanQu', N'HuaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_959', N'潘集区', N'2_101', N'淮南市', N'NULL', 3, N'340406', N'PanJiQu', N'HuaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_96', N'馆陶县', N'2_6', N'邯郸市', N'NULL', 3, N'130433', N'GuanTaoXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_960', N'凤台县', N'2_101', N'淮南市', N'NULL', 3, N'340421', N'FengTaiXian', N'HuaiNanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_961', N'金家庄区', N'2_102', N'马鞍山市', N'NULL', 3, N'340502', N'JinJiaZhuangQu', N'MaAnShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_962', N'花山区', N'2_102', N'马鞍山市', N'NULL', 3, N'340503', N'HuaShanQu', N'MaAnShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_963', N'雨山区', N'2_102', N'马鞍山市', N'NULL', 3, N'340504', N'YuShanQu', N'MaAnShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_964', N'当涂县', N'2_102', N'马鞍山市', N'NULL', 3, N'340521', N'DangTuXian', N'MaAnShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_965', N'杜集区', N'2_103', N'淮北市', N'NULL', 3, N'340602', N'DuJiQu', N'HuaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_966', N'相山区', N'2_103', N'淮北市', N'NULL', 3, N'340603', N'XiangShanQu', N'HuaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_967', N'烈山区', N'2_103', N'淮北市', N'NULL', 3, N'340604', N'LieShanQu', N'HuaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_968', N'濉溪县', N'2_103', N'淮北市', N'NULL', 3, N'340621', N'SuiXiXian', N'HuaiBeiShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_969', N'铜官山区', N'2_104', N'铜陵市', N'NULL', 3, N'340702', N'TongGuanShanQu', N'TongLingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_97', N'魏县', N'2_6', N'邯郸市', N'NULL', 3, N'130434', N'WeiXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_970', N'狮子山区', N'2_104', N'铜陵市', N'NULL', 3, N'340703', N'ShiZiShanQu', N'TongLingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_971', N'郊区', N'2_104', N'铜陵市', N'NULL', 3, N'340711', N'JiaoQu', N'TongLingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_972', N'铜陵县', N'2_104', N'铜陵市', N'NULL', 3, N'340721', N'TongLingXian', N'TongLingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_973', N'迎江区', N'2_105', N'安庆市', N'NULL', 3, N'340802', N'YingJiangQu', N'AnQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_974', N'大观区', N'2_105', N'安庆市', N'NULL', 3, N'340803', N'DaGuanQu', N'AnQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_975', N'宜秀区', N'2_105', N'安庆市', N'NULL', 3, N'340811', N'YiXiuQu', N'AnQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_976', N'怀宁县', N'2_105', N'安庆市', N'NULL', 3, N'340822', N'HuaiNingXian', N'AnQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_977', N'枞阳县', N'2_105', N'安庆市', N'NULL', 3, N'340823', N'CongYangXian', N'AnQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_978', N'潜山县', N'2_105', N'安庆市', N'NULL', 3, N'340824', N'QianShanXian', N'AnQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_979', N'太湖县', N'2_105', N'安庆市', N'NULL', 3, N'340825', N'TaiHuXian', N'AnQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_98', N'曲周县', N'2_6', N'邯郸市', N'NULL', 3, N'130435', N'QuZhouXian', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_980', N'宿松县', N'2_105', N'安庆市', N'NULL', 3, N'340826', N'SuSongXian', N'AnQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_981', N'望江县', N'2_105', N'安庆市', N'NULL', 3, N'340827', N'WangJiangXian', N'AnQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_982', N'岳西县', N'2_105', N'安庆市', N'NULL', 3, N'340828', N'YueXiXian', N'AnQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_983', N'桐城市', N'2_105', N'安庆市', N'NULL', 3, N'340881', N'TongChengShi', N'AnQingShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_984', N'屯溪区', N'2_106', N'黄山市', N'NULL', 3, N'341002', N'TunXiQu', N'HuangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_985', N'黄山区', N'2_106', N'黄山市', N'NULL', 3, N'341003', N'HuangShanQu', N'HuangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_986', N'徽州区', N'2_106', N'黄山市', N'NULL', 3, N'341004', N'HuiZhouQu', N'HuangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_987', N'歙县', N'2_106', N'黄山市', N'NULL', 3, N'341021', N'XiXian', N'HuangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_988', N'休宁县', N'2_106', N'黄山市', N'NULL', 3, N'341022', N'XiuNingXian', N'HuangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_989', N'黟县', N'2_106', N'黄山市', N'NULL', 3, N'341023', N'YiXian', N'HuangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_99', N'武安市', N'2_6', N'邯郸市', N'NULL', 3, N'130481', N'WuAnShi', N'HanDanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_990', N'祁门县', N'2_106', N'黄山市', N'NULL', 3, N'341024', N'QiMenXian', N'HuangShanShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_991', N'琅琊区', N'2_107', N'滁州市', N'NULL', 3, N'341102', N'LangYaQu', N'ChuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_992', N'南谯区', N'2_107', N'滁州市', N'NULL', 3, N'341103', N'NanQiaoQu', N'ChuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_993', N'来安县', N'2_107', N'滁州市', N'NULL', 3, N'341122', N'LaiAnXian', N'ChuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_994', N'全椒县', N'2_107', N'滁州市', N'NULL', 3, N'341124', N'QuanJiaoXian', N'ChuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_995', N'定远县', N'2_107', N'滁州市', N'NULL', 3, N'341125', N'DingYuanXian', N'ChuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_996', N'凤阳县', N'2_107', N'滁州市', N'NULL', 3, N'341126', N'FengYangXian', N'ChuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_997', N'天长市', N'2_107', N'滁州市', N'NULL', 3, N'341181', N'TianChangShi', N'ChuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_998', N'明光市', N'2_107', N'滁州市', N'NULL', 3, N'341182', N'MingGuangShi', N'ChuZhouShi')
INSERT [dbo].[HgArea] ([ID], [Name], [ParentID], [ParentName], [ZipCode], [Level], [Code], [NameEN], [ParentNameEN]) VALUES (N'3_999', N'颍州区', N'2_108', N'阜阳市', N'NULL', 3, N'341202', N'YingZhouQu', N'FuYangShi')
GO
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'中国', N'中华人民共和国', N'CN', N'CHN', N'156', N'CN', N'86', N'China', N'People''s Republic of China', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'中国台湾', N'中国台湾', N'CT', N'CTN', N'158', N'NULL', NULL, N'Taiwan,China', N'Chinese Taiwan', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'香港', N'香港', N'HK', N'HKG', N'344', N'HK', N'852', N'Hong Kong', N'Hong Kong', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'澳门', N'澳门', N'MO', N'MAC', N'446', N'MO', N'853', N'Macau', N'Macau', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'阿尔巴尼亚', N'阿尔马尼亚共和国', N'AL', N'ALB', N'8', N'AL', N'355', N'Albania', N'Republic of Albania', N'AL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'阿尔及利亚', N'阿尔及利亚民主人民共和国', N'DZ', N'DZA', N'12', N'DZ', N'213', N'Algeria', N'Democratic People''s Republic of Algeria', N'DZ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'阿富汗', N'阿富汗伊斯兰国', N'AF', N'AFG', N'4', N'AF', N'93', N'Afghanistan', N'Islamic State of Afghanistan', N'AF', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'阿根廷', N'阿根廷共和国', N'AR', N'ARG', N'32', N'AR', N'54', N'Argentina', N'Republic of Argentina', N'AR', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'阿联酋', N'拉伯联合酋长国', N'AE', N'ARE', N'784', N'NULL', NULL, N'United Arab Emirates', N'United Arab Emirates', N'AE', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'阿鲁巴', N'阿鲁巴', N'AW', N'ABW', N'533', N'NULL', NULL, N'Aruba', N'Aruba', N'AW', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'阿曼', N'阿曼苏丹国', N'OM', N'OMN', N'512', N'OM', N'968', N'Oman', N'Sultanate of Oman', N'OM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'阿塞拜疆', N'阿塞拜疆共和国', N'AZ', N'AZE', N'31', N'AZ', N'994', N'Azerbaijan', N'Republic of Azerbaijan', N'AZ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'埃及', N'阿拉伯埃及共和国', N'EG', N'EGY', N'818', N'EG', N'20', N'Egypt', N'Arab Republic of Egypt', N'EG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'埃塞俄比亚', N'埃塞俄比亚', N'ET', N'ETH', N'231', N'ET', N'251', N'Ethiopia', N'Ethiopia', N'ET', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'爱尔兰', N'爱尔兰', N'IE', N'IRL', N'372', N'IE', N'353', N'Ireland', N'Ireland', N'IE', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'爱沙尼亚', N'爱沙尼亚共和国', N'EE', N'EST', N'233', N'EE', N'372', N'Estonia', N'Republic of Estonia', N'EE', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'安道尔', N'安道尔公国', N'AD', N'AND', N'20', N'NULL', NULL, N'Andorra', N'Principality of Andorra', N'AD', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'安哥拉', N'安哥拉共和国', N'AO', N'AGO', N'24', N'AO', N'244', N'Angola', N'Republic of Angola', N'AO', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'安圭拉', N'安圭拉', N'AI', N'AIA', N'660', N'NULL', NULL, N'Anguilla', N'Anguilla', N'AI', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'安提瓜和巴布达', N'安提瓜和巴布达', N'AG', N'ATG', N'28', N'AG', N'1268', N'Antigua and Barbuda', N'Antigua and Barbuda', N'AG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'奥地利', N'奥地利共和国', N'AT', N'AUT', N'40', N'AT', N'43', N'Austria', N'Republic of Austria', N'AT', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'澳大利亚', N'澳大利亚联邦', N'AU', N'AUS', N'36', N'AU', N'61', N'Australia', N'Commonwealth of Australia', N'AU', N'25')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'巴巴多斯', N'巴巴多斯', N'BB', N'BRB', N'52', N'BB', N'1246', N'Barbados', N'Barbados', N'BB', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'巴布亚新几内亚', N'巴布亚新几内亚独立国', N'PG', N'PNG', N'598', N'PG', N'675', N'Papua New Guinea', N'Independent State of Papua New Guinea', N'PG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'巴哈马', N'巴哈马联邦', N'BS', N'BHS', N'44', N'BS', N'1242', N'Bahamas', N'Commonwealth of the Bahamas', N'BS', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'巴基斯坦', N'巴基斯坦伊斯兰共和国', N'PK', N'PAK', N'586', N'PK', N'92', N'Pakistan', N'Islamic Republic of Pakistan', N'PK', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'巴拉圭', N'巴拉圭共和国', N'PY', N'PRY', N'600', N'PY', N'595', N'Paraguay', N'Republic of Paraguay', N'PY', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'巴勒斯坦', N'巴勒斯坦国', N'PS', N'PST', N'374', N'NULL', NULL, N'Palestine', N'State of Palestine', N'PS', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'巴林', N'巴林国', N'BH', N'BHR', N'48', N'BH', N'973', N'Bahrain', N'State of Bahrain', N'BH', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'巴拿马', N'巴拿马共和国', N'PA', N'PAN', N'591', N'PA', N'507', N'Panama', N'Republic of Panama', N'PA', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'巴西', N'巴西联邦共和国', N'BR', N'BRA', N'76', N'BR', N'55', N'Brazil', N'Federative Republic of Brazil', N'BR', N'24')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'白俄罗斯', N'白俄罗斯共和国', N'BY', N'BLR', N'112', N'BY', N'375', N'Belarus', N'Republic of Belarus', N'BY', N'34')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'百慕大', N'百慕大群岛', N'BM', N'BMU', N'60', N'NULL', NULL, N'Bermuda', N'Bermuda Islands', N'BM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'保加利亚', N'保加利亚共和国', N'BG', N'BGR', N'100', N'BG', N'359', N'Bulgaria', N'Republic ov Bulgaria', N'BG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'北马里亚纳', N'北马里亚纳自由联邦', N'MP', N'MNP', N'580', N'NULL', NULL, N'Northern Marianas', N'Commonwealth of the Northern Marianas', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'贝劳', N'贝劳共和国', N'PW', N'PLW', N'585', N'NULL', NULL, N'Palau', N'Republic of Palau', N'PW', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'贝宁', N'贝宁共和国', N'BJ', N'BEN', N'204', N'BJ', N'229', N'Benin', N'Republic of Benin', N'BJ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'比利时', N'比利时王国', N'BE', N'BEL', N'56', N'BE', N'32', N'Belgium', N'Kingdom of belgium', N'BE', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'冰岛', N'冰岛共和国', N'IS', N'ISL', N'352', N'IS', N'354', N'Iceland', N'Republic of Iceland', N'IS', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'波多黎各', N'波多黎各自由联邦', N'PR', N'PRI', N'630', N'PR', N'1787', N'Puerto Rico', N'Commonwealth of Puerto Rico', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'波兰', N'波兰共和国', N'PL', N'POL', N'616', N'PL', N'48', N'Poland', N'Republic of Poland', N'PL', N'40')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'玻利维亚', N'玻利维亚共和国', N'BO', N'BOL', N'68', N'BO', N'591', N'Bolivia', N'Republic of Bolivia', N'BO', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'波斯尼亚和黑塞哥维那', N'波斯尼亚和黑塞哥维那共和国', N'BA', N'BIH', N'70', N'NULL', NULL, N'Bosnia and Herzegovina', N'Republic of Bosnia and Herzegovina', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'博茨瓦纳', N'博茨瓦纳共和国', N'BW', N'BWA', N'72', N'BW', N'267', N'Botswana', N'Republic of Botswana', N'BW', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'伯利兹', N'伯利兹', N'BZ', N'BLZ', N'84', N'BZ', N'501', N'Belize', N'Belize', N'BZ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'不丹', N'不丹王国', N'BT', N'BTN', N'64', N'NULL', NULL, N'Bhutan', N'Kingdom of Bhutan', N'BT', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'布基纳法索', N'布基纳法索', N'BF', N'BFA', N'854', N'BF', N'226', N'Burkina Faso', N'Burkina Faso', N'BF', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'布隆迪', N'布隆迪共和国', N'BI', N'BDI', N'108', N'BI', N'257', N'Burundi', N'Republic of Burundi', N'BI', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'布维岛', N'布维岛', N'BV', N'BVT', N'74', N'NULL', NULL, N'Bouvet Island', N'Bouvet Island', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'朝鲜', N'朝鲜民主主义人民共和国', N'KP', N'PRK', N'408', N'NULL', NULL, N'North Korea', N'Democratic People''s Republic of Korea', N'KP', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'赤道几内亚', N'赤道几内亚共和国', N'GQ', N'GNQ', N'226', N'NULL', NULL, N'Equatorial Guinea', N'Republic of Equatorial Guinea', N'GQ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'丹麦', N'丹麦王国', N'DK', N'DNK', N'208', N'DK', N'45', N'Denmark', N'Kingdom of Denmark', N'DK', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'德国', N'德意志联邦共和国', N'DE', N'DEU', N'276', N'DE', N'49', N'Germany', N'Federal Republic of Germany', N'DE', N'31')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'东帝汶', N'东帝汶', N'TP', N'TMP', N'626', N'NULL', NULL, N'East Timor', N'East Timor', N'TP', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'多哥', N'多哥共和国', N'TG', N'TGO', N'768', N'TG', N'228', N'Togo', N'Republic of Tago', N'TG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'多米尼加共和国', N'多米尼加共和国', N'DO', N'DOM', N'214', N'DO', N'1890', N'Dominican Republic', N'Dominican Republic', N'DO', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'多米尼克', N'多米尼克联邦', N'DM', N'DMA', N'212', N'NULL', NULL, N'Dominica', N'Commonwealth of Dominica', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'俄罗斯', N'俄罗斯联邦', N'RU', N'RUS', N'643', N'RU', N'7', N'Russia', N'Russian Federation', N'RU', N'21')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'厄瓜多尔', N'厄瓜多尔共和国', N'EC', N'ECU', N'218', N'EC', N'593', N'Ecuador', N'Republic of Ecuador', N'EC', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'厄立特里亚', N'厄立特里亚国', N'ER', N'ERI', N'232', N'NULL', NULL, N'Eritrea', N'State of Eritrea', N'ER', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'法国', N'法兰西共和国', N'FR', N'FRA', N'250', N'FR', N'33', N'France', N'French Republic', N'FR', N'26')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'法罗群岛', N'法罗群岛', N'FO', N'FRO', N'234', N'NULL', NULL, N'Faroe Islands', N'Faroe Islands', N'FO', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'法属波利尼西亚', N'法属波利尼西亚', N'PF', N'PYF', N'258', N'NULL', NULL, N'French Polynesia', N'French Polynesia', N'PF', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'法属圭亚那', N'法属圭亚那', N'GF', N'GUF', N'254', N'GF', N'594', N'French Guiana', N'French Guiana', N'GF', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'法属南部领土', N'法属南部领土', N'TF', N'ATF', N'260', N'NULL', NULL, N'French Southern Territo-ries', N'French Southern Territories', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'梵蒂冈', N'梵蒂冈城国', N'VA', N'VAT', N'336', N'NULL', NULL, N'Vatican', N'Vatican City State', N'VA', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'菲律宾', N'菲律宾共和国', N'PH', N'PHL', N'608', N'PH', N'63', N'Philippines', N'Republic of the Philippines', N'PH', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'斐济', N'斐济共和国', N'FJ', N'FJI', N'242', N'FJ', N'679', N'Fiji', N'Republic of Fiji', N'FJ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'芬兰', N'芬兰共和国', N'FI', N'FIN', N'246', N'FI', N'358', N'Finland', N'Republic of Finland', N'FI', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'佛得角', N'佛得角共和国', N'CV', N'CPV', N'132', N'NULL', NULL, N'Cape Verde', N'Republic of Cape Verde', N'CV', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'冈比亚', N'冈比亚共和国', N'GM', N'GMB', N'270', N'GM', N'220', N'Gambia', N'Republic of Gambia', N'GM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'刚果（金）', N'刚果民主共和国', N'CD', N'COD', NULL, N'CD', N'243', N'Congo', N'Democratic Republic of the Congo', N'CD', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'刚果（布）', N'刚果共和国', N'CG', N'COG', N'178', N'CG', N'242', N'Congo', N'Republic of Congo', N'CG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'哥伦比亚', N'哥伦比亚共和国', N'Co', N'COL', N'170', N'CO', N'57', N'Colombia', N'Republic of Colombia', N'CO', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'哥斯达黎加', N'哥斯达黎加共和国', N'CR', N'CR', N'188', N'CR', N'506', N'Costa Rica', N'Republic of Costa Rica', N'CR', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'格林纳达', N'格林纳达', N'GD', N'GRD', N'308', N'GD', N'1809', N'Grenada', N'Grenada', N'GD', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'格陵兰', N'格陵兰', N'GL', N'GRL', N'304', N'NULL', NULL, N'Greenland', N'Greenland', N'GL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'格鲁吉亚', N'格鲁吉亚共和国', N'GE', N'GEO', N'268', N'GE', N'995', N'Georgia', N'Republic of Georgia', N'GE', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'古巴', N'古巴共和国', N'CU', N'CUB', N'192', N'CU', N'53', N'Cuba', N'Republic of Cuba', N'CU', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'瓜德罗普', N'瓜德罗普', N'GP', N'GLP', N'312', N'NULL', NULL, N'Guadeloupe', N'Guadeloupe', N'GP', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'关岛', N'关岛', N'GU', N'GUM', N'316', N'GU', N'1671', N'Guam', N'Guam', N'GU', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'圭亚那', N'圭亚那合作共和国', N'GY', N'GUY', N'328', N'GY', N'592', N'Guyana', N'Cooperative Republic of Guyana', N'GY', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES ( N'哈萨克斯坦', N'哈萨克斯坦共和国', N'KZ', N'KAZ', N'398', N'KZ', N'327', N'Kazakhstan', N'Republic of Kazakhstan', N'KZ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'海地', N'海地共和国', N'HT', N'HTI', N'332', N'HT', N'509', N'Haiti', N'Republic of Haiti', N'HT', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'黑山', N'黑山共和国', N'ME', N'MNE', NULL, N'ME', N'382', N'Montenegro', N'Montenegro', N'ME', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'韩国', N'大韩民国', N'KR', N'KOR', N'410', N'KR', N'82', N'South Korea', N'Republic of Korea', N'KR', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'荷兰', N'荷兰王国', N'NL', N'NLD', N'528', N'NL', N'31', N'Netherlands', N'Kingdom of the Netherlands', N'NL', N'36')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (  N'荷属安的列斯', N'荷属安的列斯', N'AN', N'ANT', N'530', N'NULL', NULL, N'Netherlands Antilles', N'Netherlands Antilles', N'AN', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'赫德岛和麦克唐纳岛', N'赫德岛和麦克唐纳岛', N'HM', N'HMD', N'334', N'NULL', NULL, N'Heard islands and Mc Donald Islands', N'Heard islands and Mc Donald Islands', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'洪都拉斯', N'洪都拉斯共和国', N'HN', N'HND', N'340', N'HN', N'504', N'Honduras', N'Republic of honduras', N'HN', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'基里巴斯', N'基里巴斯共和国', N'KI', N'KIR', N'296', N'NULL', NULL, N'Kiribati', N'Republic of Kiribati', N'KI', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'吉布提', N'吉布提共和国', N'DJ', N'DJI', N'262', N'DJ', N'253', N'Djibouti', N'Republic of Djibouti', N'DJ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'吉尔吉斯斯坦', N'吉尔吉斯共和国', N'KG', N'KGZ', N'417', N'NULL', NULL, N'Kyrgyzstan', N'Kyrgyz Republic', N'KG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'几内亚', N'几内亚共和国', N'GN', N'GIN', N'324', N'GN', N'224', N'Guinea', N'Republic of Guinea', N'GN', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'几内亚比绍', N'几内亚比绍共和国', N'GW', N'GNB', N'624', N'NULL', NULL, N'Guine-bissau', N'Republic of Guine-bissau', N'GW', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'加拿大', N'加拿大', N'CA', N'CAN', N'124', N'CA', N'1', N'Canada', N'Canada', N'CA', N'28')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'加纳', N'加纳共和国', N'GH', N'GHA', N'288', N'GH', N'233', N'Ghana', N'Republic of Ghana', N'GH', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'加蓬', N'加蓬共和国', N'GA', N'GAB', N'266', N'GA', N'241', N'Gabon', N'Gabonese Republic', N'GA', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'柬埔寨', N'柬埔寨王国', N'KH', N'KHM', N'116', N'KH', N'855', N'Cambodia', N'Kingdom of Cambodia', N'KH', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'捷克', N'捷克共和国', N'CZ', N'CZE', N'203', N'CZ', N'420', N'Czech Repoublic', N'Czech Republic', N'CZ', NULL)
GO

INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'津巴布韦', N'津巴布韦共和国', N'ZW', N'ZWE', N'716', N'ZW', N'263', N'Zimbabwe', N'Republic of Zimbabwe', N'ZW', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'喀麦隆', N'喀麦隆共和国', N'CM', N'CMR', N'120', N'CM', N'237', N'Cameroon', N'Republic of Cameroon', N'CM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'卡塔尔', N'卡塔尔国', N'QA', N'QAT', N'634', N'QA', N'974', N'Qatar', N'State of Qatar', N'QA', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'开曼群岛', N'开曼群岛', N'KY', N'CYM', N'136', N'KY', N'1345', N'Cayman Islands', N'Cayman Islands', N'KY', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'科科斯(基林)群岛', N'科科斯(基林)群岛', N'CC', N'CCK', N'166', N'NULL', NULL, N'Cocos Keeling Islands', N'Cocos Keeling Islands', N'CC', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'科摩罗', N'科摩罗伊斯兰联邦共和国   ', N'KM', N'COM', N'174', N'NULL', NULL, N'Comoros', N'Federal Islamic Republic of the Co-moros', N'KM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'科特迪瓦', N'科特迪瓦共和国', N'CI', N'CIV', N'384', N'CI', N'225', N'Cote d''Ivoire', N'Republic of Cote d''Ivire', N'CI', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'科威特', N'科威特国', N'KW', N'KWT', N'414', N'KW', N'965', N'Kuwait', N'State of Kuwait', N'KW', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'克罗地亚', N'克罗地亚共和国', N'HR', N'HRV', N'191', N'NULL', NULL, N'Croatia', N'Republic of Croatia', N'HR', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'肯尼亚', N'肯尼亚共和国', N'KE', N'KEN', N'404', N'KE', N'254', N'Kenya', N'Republic of Kenya', N'KE', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'库克群岛', N'库克群岛', N'CK', N'COK', N'184', N'CK', N'682', N'Cook Islands', N'Cook Islands', N'CK', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'拉脱维亚', N'拉脱维亚共和国', N'LV', N'LVA', N'428', N'LV', N'371', N'Latvia', N'Republic of Latvia', N'LV', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'莱索托', N'莱索托王国', N'LS', N'LSO', N'426', N'LS', N'266', N'Lesotho', N'Kingdom of Lesoto', N'LS', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'老挝', N'老挝人民民主共和国', N'LA', N'LAO', N'418', N'LA', N'856', N'Lao', N'Lao People''s Democratic Republic', N'LA', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'黎巴嫩', N'黎巴嫩共和国', N'LB', N'LBN', N'422', N'LB', N'961', N'Lebanon', N'Republic of Lebanon', N'LB', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'利比里亚', N'利比里亚共和国', N'LR', N'LBR', N'430', N'LR', N'231', N'Liberia', N'Republic of Liberia', N'LR', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'利比亚', N'大阿拉伯利比亚人民社会主义民众国', N'LY', N'LBY', N'434', N'LY', N'218', N'Libya', N'Great Socialist People''s Libyan Arab jamahiriya', N'LY', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'立陶宛', N'立陶宛共和国', N'LT', N'LTU', N'440', N'LT', N'370', N'Lithuania', N'Republic of Lithuania', N'LT', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'列支敦士登', N'列支敦士登公国', N'LI', N'LIE', N'438', N'LI', N'423', N'Liechtenstein', N'Principality of Liechtenstein', N'LI', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'留尼汪', N'留尼汪', N'RE', N'REU', N'638', N'NULL', NULL, N'Reunion', N'Reunion', N'RE', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'卢森堡', N'卢森堡大公国', N'LU', N'LUX', N'442', N'LU', N'352', N'Luxembourg', N'Grand Duchy of Luxembourg', N'LU', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'卢旺达', N'卢旺达共和国', N'RW', N'RWA', N'646', N'NULL', NULL, N'Rwanda', N'Republic of Rwanda', N'RW', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'罗马尼亚', N'罗马尼亚', N'RO', N'ROM', N'642', N'RO', N'40', N'Romania', N'Romania', N'RO', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'马达加斯加', N'马达加斯加共和国', N'MG', N'MDG', N'450', N'MG', N'261', N'Madagascar', N'Republic of Madagascar', N'MG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'马耳他', N'马耳他共和国', N'MT', N'MLT', N'470', N'MT', N'356', N'Malta', N'Republic of Malta', N'MT', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'马尔代夫', N'马尔代夫共和国', N'MV', N'MDV', N'462', N'MV', N'960', N'Maldives', N'Republic of maldives', N'MV', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'马尔维纳斯群岛(福克兰群岛)', N'马尔维纳斯群岛(福克兰群岛)', N'FK', N'FLK', N'238', N'NULL', NULL, N'Malvinas islands (Falkland Islands)', N'Malvinas islands (Falkland Islands)', N'FK', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'马拉维', N'马拉维共和国', N'MW', N'MWI', N'454', N'MW', N'265', N'Malawi', N'Republic of Malawi', N'MW', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'马来西亚', N'马来西亚', N'MY', N'MYS', N'458', N'MY', N'60', N'Malaysia', N'Malaysia', N'MY', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'马里', N'马里共和国', N'ML', N'MLI', N'466', N'ML', N'223', N'Mali', N'Republic of Mali', N'ML', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'马斯顿', N'马其顿共和国', N'MK', N'MKD', N'807', N'NULL', NULL, N'Macedonia', N'Republic of Macedonia', N'MK', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'马绍尔群岛', N'马绍尔群岛共和国', N'MH', N'MHL', N'584', N'NULL', NULL, N'Marshall Islands', N'Republic of the marshall Islands', N'MH', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'马提尼克', N'马提尼克', N'MQ', N'MTQ', N'474', N'NULL', NULL, N'Martinique', N'Martinique', N'MQ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'马约特', N'马约特', N'YT', N'MYT', N'175', N'NULL', NULL, N'Mayotte', N'Mayotte', N'YT', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'毛里求斯', N'毛里求斯共和国', N'MU', N'MUS', N'480', N'MU', N'230', N'Mauritius', N'Republic of Mauritius', N'MU', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'毛里塔尼亚', N'毛里求斯共和国', N'MR', N'MRT', N'478', N'NULL', NULL, N'Mauritania', N'Republic of Mauritius', N'MR', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'美国', N'美利坚合众国', N'US', N'USA', N'840', N'US', N'1', N'United States', N'United States of America', N'US', N'22')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'美属萨摩亚', N'美属萨摩亚', N'AS', N'ASM', N'16', N'NULL', NULL, N'American Samoa', N'American Samoa', N'AS', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'美属维尔京群岛', N'美属维尔京群岛', N'VI', N'VIR', N'850', N'NULL', NULL, N'United States Virgin Is-lands', N'United States Virgin Islands', N'VI', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'蒙古', N'蒙古国', N'MN', N'MNG', N'496', N'MN', N'976', N'Mongolia', N'Mongolia', N'MN', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'蒙特塞拉特', N'蒙特塞拉特', N'MS', N'MSR', N'500', N'NULL', NULL, N'Montserrat', N'Montserrat', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'孟加拉国', N'孟加拉人民共和国', N'BD', N'BGD', N'50', N'BD', N'880', N'Bangladesh', N'People''s Republic of Bangladesh', N'BD', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'秘鲁', N'秘鲁共和国', N'PE', N'PER', N'604', N'PE', N'51', N'Peru', N'Republic of Peru', N'PE', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'密克罗尼西亚', N'密克罗尼西亚联邦', N'FM', N'FSM', N'583', N'NULL', NULL, N'Micronesia', N'Federated States of Micronesia', N'FM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'缅甸', N'缅甸联邦', N'MM', N'MMR', N'104', N'MM', N'95', N'Myanmar', N'Union of Myanmar', N'MM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'摩尔多瓦', N'摩尔多瓦共和国', N'MD', N'MDA', N'498', N'MD', N'373', N'Moldova', N'Republic of Moldova', N'MD', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'摩洛哥', N'摩洛哥王国', N'MA', N'MAR', N'504', N'MA', N'212', N'Morocco', N'Kingdom of Morocco', N'MA', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'摩纳哥', N'摩纳哥公国', N'MC', N'MCO', N'492', N'MC', N'377', N'Monaco', N'Principality of Monaco', N'MC', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'莫桑比克', N'莫桑比克共和国', N'MZ', N'MOZ', N'508', N'MZ', N'258', N'Mozambique', N'Republic of Mozambique', N'MZ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'墨西哥', N'墨西哥合众国', N'MX', N'MEX', N'484', N'MX', N'52', N'Mexico', N'United States of Mexico', N'MX', N'39')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'纳米比亚', N'纳米比亚共和国', N'NA', N'NAM', N'516', N'NA', N'264', N'Namibia', N'Republic of Namibia', N'NA', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'南非', N'南非共和国', N'ZA', N'ZAF', N'710', N'ZA', N'27', N'South Africa', N'Republic of South Africa', N'ZA', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'南极洲', N'南极洲', N'AQ', N'ATA', N'10', N'NULL', NULL, N'Antarctica', N'Antarctica', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'南乔治亚岛和南桑德韦奇岛', N'南乔治亚岛和南桑德韦奇岛', N'GS', N'SGS', N'239', N'NULL', NULL, N'South Georgia and South Sandwich Islands', N'South Georgia and South Sandwich Islands', N'SGS', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'南斯拉夫', N'南斯拉夫联盟共和国', N'YU', N'YUG', N'891', N'YU', N'381', N'Yugoslavia', N'Federal Republic of Yugoslavia', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'瑙鲁', N'瑙鲁共和国', N'NR', N'NRU', N'520', N'NR', N'674', N'Nauru', N'Republic of Nauru', N'NR', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'尼泊尔', N'尼泊尔王国', N'NP', N'NPL', N'524', N'NP', N'977', N'Nepal', N'Kingdom of Nepal', N'NP', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'尼加拉瓜', N'尼加拉瓜共和国', N'NI', N'NIC', N'558', N'NI', N'505', N'Nicaragua', N'Republic of Nicaragua', N'NI', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'尼日尔', N'尼日尔共和国', N'NE', N'NER', N'562', N'NE', N'227', N'Niger', N'Republic of Niger', N'NE', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'尼日利亚', N'尼日利亚联邦共和国', N'NG', N'NGA', N'566', N'NG', N'234', N'Nigeria', N'Federal Republic of Nigeria', N'NG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'纽埃', N'纽埃', N'NU', N'NIU', N'570', N'NULL', NULL, N'Niue', N'Niue', N'NU', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'挪威', N'挪威王国', N'NO', N'NOR', N'578', N'NO', N'47', N'Norway', N'Kingdom of Norway', N'NO', N'35')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'诺福克岛', N'诺福克岛', N'NF', N'NFK', N'574', N'NULL', NULL, N'Norfolk Island', N'Norfolk Island', N'NF', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'皮特凯恩群岛', N'皮竺凯恩群岛', N'PN', N'PCN', N'612', N'NULL', NULL, N'Pitcairn Islands Group', N'Pitcairn Islands Group', N'PN', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'葡萄牙', N'葡萄牙共和国', N'PT', N'PRT', N'620', N'PT', N'351', N'Portugal', N'Pirtuguese Republic', N'PT', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'日本', N'日本国', N'JP', N'JPN', N'392', N'JP', N'81', N'Japan', N'Japan', N'JP', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'瑞典', N'瑞典王国', N'SE', N'SWE', N'752', N'SE', N'46', N'Sweden', N'Kingdom of Sweden', N'SE', N'33')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'瑞士', N'瑞士联邦', N'CH', N'CHE', N'756', N'CH', N'41', N'Switzerland', N'Swiss Confederation', N'CH', N'38')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'萨尔瓦多', N'萨尔瓦多共和国', N'SV', N'SLV', N'222', N'SV', N'503', N'El Salvador', N'Republic of El Salvador', N'SV', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'塞拉利昂', N'塞拉利昂共和国', N'SL', N'SLE', N'694', N'SL', N'232', N'Sierra leone', N'Republic of Sierra Leone', N'SL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'塞内加尔', N'塞内加尔共和国', N'SN', N'SEN', N'686', N'SN', N'221', N'Senegal', N'Republic of Senegal', N'SN', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'塞浦路斯', N'塞浦路斯共和国', N'CY', N'CYP', N'196', N'CY', N'357', N'Cyprus', N'Republic of Cyprus', N'CY', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'塞舌尔', N'塞舌尔共和国', N'SC', N'SYC', N'690', N'SC', N'248', N'Seychells', N'Republic of Seychelles', N'SC', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'沙竺阿拉伯', N'沙特阿拉伯王国', N'SA', N'SAU', N'682', N'NULL', NULL, N'Saudi Arabia', N'Kingdom of Saudi Arabia', N'SA', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'圣诞岛', N'圣诞岛', N'CS', N'CSR', N'162', N'NULL', NULL, N'Christmas Island', N'Christmas Island', N'CX', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'圣多美和普林西比', N'圣多美和普林西比民主共和国', N'St', N'STp', N'678', N'ST', N'239', N'Sao Tome and Principe', N'Democratic Republic of Sao Tome and Principe', N'ST', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'圣赫勒拿', N'对赫勒拿', N'Sh', N'SHN', N'654', N'NULL', NULL, N'Saint helena', N'Saint Helena', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'圣基茨和尼维斯', N'圣革茨和尼维斯联邦', N'KN', N'KNA', N'659', N'NULL', NULL, N'Saint Kitts and nevis', N'Federation of Saint Kitts and nevis', N'KN', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'圣卢西亚', N'圣卢西亚', N'LC', N'LCA', N'662', N'LC', N'1758', N'Saint lucia', N'Saint Lucia', N'LC', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'圣马力诺', N'圣马力诺共和国', N'SM', N'SMR', N'674', N'SM', N'378', N'San Marion', N'Republic of San Marino', N'SM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'圣皮埃尔和密克隆', N'圣皮埃尔和密克隆', N'PM', N'SPM', N'666', N'NULL', NULL, N'Saint Pierre and Miquelon', N'Saint Pierre and Miquelon', N'PM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'圣文森特和格林纳丁斯', N'圣文森特和格林纳丁斯', N'VC', N'VCT', N'670', N'NULL', NULL, N'Saint Vincent and the Grenadines', N'Saint Vincent and the Grenadines', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'斯里兰卡', N'斯里兰卡民主社会主义共和国', N'LK', N'LKA', N'144', N'LK', N'94', N'Sri Lanka', N'Democratic Socialist Republic of Srilanka', N'LK', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'斯洛伐克', N'斯洛伐克共和国', N'SK', N'SVK', N'703', N'SK', N'421', N'Slovakia', N'Slovak Republic', N'SK', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'斯洛文尼亚', N'斯洛文尼亚共和国', N'SI', N'SVN', N'705', N'SI', N'386', N'Slovenia', N'Republic of Slovenia', N'SI', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'斯瓦尔巴群岛', N'斯瓦尔巴群岛', N'SJ', N'SJM', N'744', N'NULL', NULL, N'Svalbard and jan Mayen Islands', N'Svalbard and Jan mayen islands', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'斯威士兰', N'斯威士兰王国', N'SZ', N'SWZ', N'748', N'SZ', N'268', N'Swaziland', N'Kingdom of Swaziland', N'SZ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'苏丹', N'苏丹共和国', N'SD', N'SDN', N'736', N'SD', N'249', N'Sudan', N'Republic of the Sudan', N'SD', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'苏里南', N'苏里南共和国', N'SR', N'SUR', N'740', N'SR', N'597', N'Suriname', N'Republic of Suriname', N'SR', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'索马里', N'索马里共和国', N'SO', N'SOM', N'706', N'SO', N'252', N'Somalia', N'Somali Republic', N'SO', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'所罗门群岛', N'年罗门群岛', N'SB', N'SLB', N'90', N'SB', N'677', N'Solomon Islands', N'Solomon Islands', N'SB', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'塔吉克斯坦', N'塔吉克斯坦共和国', N'TJ', N'TJK', N'762', N'TJ', N'992', N'Tajikistan', N'Republic of Tajikistan', N'TJ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'泰国', N'泰王国', N'TH', N'THA', N'764', N'TH', N'66', N'Thailand', N'Kingdom of Thailand', N'TH', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'坦桑尼亚', N'坦桑尼亚联合共和国', N'TZ', N'TZA', N'834', N'TZ', N'255', N'Tanzania', N'United Republic of Tanzania', N'TZ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'汤加', N'汤加王国', N'TO', N'TON', N'776', N'TO', N'676', N'Tonga', N'Kingdom of Tonga', N'TO', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'特克斯科斯群岛', N'特克斯和凯科斯群岛', N'TC', N'TCA', N'796', N'NULL', NULL, N'Turks and Caicos Islands', N'Turks and Caicos Islands', N'TC', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'特立尼达和多巴哥', N'特立尼达和多巴哥共和国', N'TT', N'TTO', N'780', N'TT', N'1809', N'Trinidad and Tobago', N'Republic of Trinidad and Tobago', N'TT', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'突尼斯', N'突尼斯共和国', N'TN', N'TUN', N'788', N'TN', N'216', N'Tunisia', N'Republic of Tunisia', N'TN', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'图瓦卢', N'图瓦卢', N'TV', N'TUV', N'798', N'NULL', NULL, N'Tuvalu', N'Tuvalu', N'TV', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'土耳其', N'土耳其共和国', N'TR', N'TUR', N'792', N'TR', N'90', N'Turkey', N'Republic of Turkey', N'TR', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'土库曼斯坦', N'土库曼斯坦', N'TM', N'TKM', N'795', N'TM', N'993', N'Turkmenistan', N'Turkmenistan', N'TM', NULL)
GO
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'托克劳', N'托克劳', N'TK', N'TKL', N'772', N'NULL', NULL, N'Tokelau', N'Tokelau', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'瓦利斯和富图纳群岛', N'瓦利斯和富图纳群岛', N'WF', N'WLF', N'876', N'NULL', NULL, N'Wallis and Futuna Is-lands', N'Wallis and Futuna Islands', N'WF', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'瓦努阿图', N'瓦努阿图共和国', N'VU', N'VUT', N'548', N'NULL', NULL, N'Vanuatu', N'Republic of Vanuatu', N'VU', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'危地马拉', N'危地马拉共和国', N'GT', N'GTM', N'320', N'GT', N'502', N'Guatemala', N'Republic of Guatemala', N'GT', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'委内瑞拉', N'委内瑞拉共和国', N'VE', N'VEN', N'862', N'VE', N'58', N'Venezuela', N'Republic of Venezuela', N'VE', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'文莱', N'文莱达鲁萨兰国', N'BN', N'BRN', N'96', N'BN', N'673', N'Brunei Darussalam', N'Brunei Darussalam', N'BN', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'乌干达', N'乌干达共和国', N'UG', N'UGA', N'800', N'UG', N'256', N'Uganda', N'Republic of Uganda', N'UG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'乌克兰', N'乌克兰', N'UA', N'UKR', N'804', N'UA', N'380', N'Ukraine', N'Ukraine', N'UA', N'37')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'乌拉圭', N'乌拉圭东岸共和国', N'UY', N'URY', N'858', N'UY', N'598', N'Uruguay', N'Oriental Republic of Uruguay', N'UY', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'乌兹别克斯坦', N'乌兹别克斯坦共和国', N'UZ', N'UZB', N'860', N'UZ', N'233', N'Uzbekistan', N'Republic of Uzbekistan', N'UZ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'西班牙', N'西班牙', N'ES', N'ESP', N'724', N'ES', N'34', N'Spain', N'Spain', N'ES', N'27')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'西撒哈拉', N'西撒哈拉', N'EH', N'ESH', N'732', N'NULL', NULL, N'Western Sahara', N'Western Sahara', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'西萨摩亚', N'西萨摩亚独立国', N'WS', N'WSM', N'882', N'NULL', N'685', N'Western Samoa', N'Independent State of Western Samoa', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'希腊', N'希腊共和国', N'GR', N'GRC', N'300', N'GR', N'30', N'Greece', N'Hellenic Republic', N'GR', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'新加坡', N'新加坡共和国', N'SG', N'SGP', N'702', N'SG', N'65', N'Singapore', N'Republic of Singapore', N'SG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'新喀里多尼亚', N'新喀里多尼亚', N'NC', N'NCL', N'540', N'NULL', NULL, N'New Caledonia', N'New Caledonia', N'NC', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'新西兰', N'新西兰', N'NZ', N'NZL', N'554', N'NZ', N'64', N'New Zealand', N'New Zealand', N'NZ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'匈牙利', N'匈牙利共和国', N'HU', N'HUN', N'348', N'HU', N'36', N'Hungary', N'Republic of Hungary', N'HU', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'叙利亚', N'阿拉伯叙利亚共和国', N'SY', N'SYR', N'760', N'SY', N'963', N'Syria', N'Syrian Arab Republic', N'SY', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'牙买加', N'牙买加', N'JM', N'JAM', N'388', N'JM', N'1876', N'Jamaica', N'Jamaica', N'JM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'亚美尼亚', N'亚美尼亚共和国', N'AM', N'ARM', N'51', N'AM', N'374', N'Armenia', N'Republic of Armenia', N'AM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'也门', N'也门共和国', N'YE', N'YEM', N'887', N'YE', N'967', N'Yemen', N'Republic of Yemen', N'YE', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'伊拉克', N'伊拉克共和国', N'IQ', N'IRQ', N'368', N'IQ', N'964', N'Iraq', N'Republic of Iraq', N'IQ', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'伊朗', N'伊朗伊斯兰共和国', N'IR', N'IRN', N'364', N'IR', N'98', N'Iran', N'Islamic Rupublic of Iran', N'IR', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'以色列', N'以色列国', N'IL', N'ISR', N'376', N'IL', N'972', N'Israel', N'State of Israel', N'IL', N'29')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'意大利', N'意大利共和国', N'IT', N'ITA', N'380', N'IT', N'39', N'Italy', N'Republic of Italy', N'IT', N'30')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'印度', N'印度共和国', N'IN', N'IND', N'356', N'IN', N'91', N'India', N'Republic of India', N'IN', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'印度尼西亚', N'印度尼西亚共和国', N'ID', N'IDN', N'360', N'ID', N'62', N'Indonesia', N'Republic of Indonesia', N'ID', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'英国', N'大不列颠及北爱尔兰联合王国', N'GB', N'GBR', N'826', N'GB', N'44', N'United Kingdom', N'United Kingdom of Great Britain and Northern ireland', N'UK', N'23')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'英属维尔京群岛', N'英属维尔京群岛', N'VG', N'VGB', N'92', N'NULL', NULL, N'British Virgin Islands', N'British Virgin Islands', N'VG', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'英属印度洋领土', N'英属印度洋领土', N'IO', N'IOT', N'86', N'NULL', NULL, N'British indian Ocean Ter-ritory', N'British Indian Ocean Territory', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'约旦', N'约旦哈希姆王国', N'JO', N'JOR', N'400', N'JO', N'962', N'Jordan', N'Hashemite Kingdom of Jordan', N'JO', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'越南', N'越南社会主席共和国', N'VN', N'VNM', N'704', N'VN', N'84', N'Viet Nam', N'Socialist Republic of Viet Nam', N'VN', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'赞比亚', N'赞比亚共和国', N'ZM', N'ZMB', N'894', N'ZM', N'260', N'Zambia', N'Republic of Zambia', N'ZM', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'扎伊尔', N'扎伊尔共和国', N'ZR', N'ZAR', N'180', N'ZR', N'243', N'Zaire', N'Republic of Zaire', N'NULL', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'乍得', N'乍得共和国', N'TD', N'TCD', N'148', N'TD', N'235', N'Chad', N'Republic of Chad', N'TD', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'直布罗陀', N'直布罗陀', N'GI', N'GIB', N'292', N'GI', N'350', N'Gibraltar', N'Gibraltar', N'GI', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'智利', N'智利共和国', N'CL', N'CHL', N'152', N'CL', N'56', N'Chile', N'Republic of Chile', N'CL', N'32')
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'中非', N'中非共和国', N'CF', N'CAF', N'140', N'NULL', NULL, N'Central Africa', N'Central African Republic', N'CF', NULL)
INSERT [dbo].[HgCountry] ( [Name], [FullName], [DoubleCharacterCode], [ThreeCharacterCode], [ThreeNumberCode], [Domain], [PhoneCode], [EnglishName], [EnglishFullName], [Abbreviation], [NationalSortingCode]) VALUES (N'塞尔维亚', N'塞尔维亚共和国', N'RS', N'SRB', N'688', N'NULL', N'381', N'Serbia', N' Republic of Serbia', N'NULL', NULL)
GO
--2015/06/10 chenrong汇率管理
if not exists(select * from [HgCurrency] where CurrencyName='AUD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'AUD', N'澳大利亚元',450.15000, '2015/7/29 11:19:02', 450.15000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='BRL')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'BRL', N'巴西里亚尔', 184.91000, '2015/7/29 11:19:02', 184.91000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='CAD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'CAD', N'加拿大元', 472.78000, '2015/7/29 11:19:02', 472.78000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='CHF')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'CHF', N'瑞士法郎', 646.19000, '2015/7/29 11:19:02', 646.19000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='CNY')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'CNY', N'人民币', 100.00000, '2015/7/29 11:19:02', 100.00000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='DKK')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'DKK', N'丹麦克朗', 92.18000, '2015/7/29 11:19:02', 92.18000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='EUR')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'EUR', N'欧元', 678.50000, '2015/7/29 11:19:02', 678.50000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='GBP')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'GBP', N'英镑', 957.01000, '2015/7/29 11:19:02', 957.01000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='HKD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'HKD', N'港币', 78.89000, '2015/7/29 11:19:02', 78.89000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='IDR')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'IDR', N'印尼卢比', 0.04620, '2015/7/29 11:19:02', 0.04620, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='JPY')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'JPY', N'日元', 4.96630, '2015/7/29 11:19:02', 4.96630, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='KRW')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'KRW', N'韩国元', 0.53640, '2015/7/29 11:19:02', 0.53640, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='MOP')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'MOP', N'澳门元', 77.82000, '2015/7/29 11:19:02', 77.82000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='MYR')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'MYR', N'林吉特', 162.69000, '2015/7/29 11:19:02', 162.69000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='NOK')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'NOK', N'挪威克朗', 76.14000, '2015/7/29 11:19:02', 76.14000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='NZD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'NZD', N'新西兰元', 411.44000, '2015/7/29 11:19:02', 411.44000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='PHP')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'PHP', N'菲律宾比索', 13.66000, '2015/7/29 11:19:02', 13.66000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='RUB')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'RUB', N'卢布', 10.33000, '2015/7/29 11:19:02',10.33000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='SEK')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'SEK', N'瑞典克朗', 72.61000, '2015/7/29 11:19:02', 72.61000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='SGD')
 INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'SGD', N'新加坡元', 450.30000, '2015/7/29 11:19:02', 450.30000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='THB')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'THB', N'泰国铢', 17.84000, '2015/7/29 11:19:02', 17.84000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='TWD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'TWD', N'新台币', 19.77000, '2015/7/29 11:19:02', 19.77000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='USD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'USD', N'美元', 611.50000, '2015/7/29 11:19:02', 611.50000, N'Y', NULL)

GO
--更新表 添加 tutu 2015-7-13

-- 银行目录管理catalog_photoba
INSERT [dbo].[HgCatalogType] ([TypeCode], [TypeName], [RootId], [ContentTable], [OrderNo], [Remarks]) VALUES (N'PhotoBank', N'图片银行目录', 1, N'HgPhotoBank', 1, N'图片银行目录')
GO
INSERT [dbo].[HgCatalog] ( [CatalogName], [TypeCode], [ParentCatalogId], [CatalogIdPath], [HasChild], 
[LevelNum], [OrderNo], [Remarks], [CreateTime], [Creator]) VALUES ( N'图片银行目录', N'PhotoBank', 0,N''+CONVERT(varchar(54),IDENT_CURRENT('HgCatalog'))+'/', 0, 0, 1, NULL, NULL, NULL)
GO
--更新表 end  添加 tutu 2015-7-13 

INSERT [dbo].[HgCatalogType] ([TypeCode], [TypeName], [RootId], [ContentTable], [OrderNo], [Remarks]) VALUES (N'cmsfiles', N'文件分类', 49, N'CmsFiles', 2, N'文件分类')
INSERT [dbo].[HgCatalogType] ([TypeCode], [TypeName], [RootId], [ContentTable], [OrderNo], [Remarks]) VALUES (N'cmsnews', N'新闻分类', 16, N'CmsNews', 2, N'新闻分类')
SET IDENTITY_INSERT [dbo].[HgCatalog] ON
INSERT [dbo].[HgCatalog] ([CatalogId], [CatalogName], [TypeCode], [ParentCatalogId], [CatalogIdPath], [HasChild], [LevelNum], [OrderNo], [Remarks], [CreateTime], [Creator]) VALUES (16, N'新闻分类', N'cmsnews', 0, N'16/', 0, 0, 1, NULL, NULL, NULL)
INSERT [dbo].[HgCatalog] ([CatalogId], [CatalogName], [TypeCode], [ParentCatalogId], [CatalogIdPath], [HasChild], [LevelNum], [OrderNo], [Remarks], [CreateTime], [Creator]) VALUES (49, N'文件分类', N'cmsfiles', 0, N'49/', 0, 0, 1, NULL, NULL, NULL)
SET IDENTITY_INSERT [dbo].[HgCatalog] OFF
GO

/*start 添加微信权限 bunny*/
if not exists(select SettingGroup from hgSysSetting where SettingGroup='WeChatSetting' and SettingKey='AppId' )
INSERT [dbo].[hgSysSetting] (SettingGroup, SettingKey, SettingTitle, SettingValue, SettingType, SettingOption, AllowEdit, OrderNo, Remarks)
values('WeChatSetting','AppId','应用ID','wxfd257995fc302df4',1,'',1,1,'微信公众号应用ID');
go

if not exists(select SettingGroup from hgSysSetting where SettingGroup='WeChatSetting' and SettingKey='AppSecret' )
INSERT [dbo].[hgSysSetting] (SettingGroup, SettingKey, SettingTitle, SettingValue, SettingType, SettingOption, AllowEdit, OrderNo, Remarks)
values('WeChatSetting','AppSecret','应用密钥','90649e70be50cb9a522ec1d859068e09 ',1,'',1,2,'微信公众号应用秘钥');
go
if not exists(select SettingGroup from hgSysSetting where SettingGroup='WeChatSetting' and SettingKey='UserToken' )
INSERT [dbo].[hgSysSetting] (SettingGroup, SettingKey, SettingTitle, SettingValue, SettingType, SettingOption, AllowEdit, OrderNo, Remarks)
values('WeChatSetting','UserToken','授权秘钥','ceshizhuanyong ',1,'',1,3,'微信公众号授权秘钥');
go
 
/*end添加微信权限*/


-----------------------------------------------------------------------------------------------------
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='Ebay')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','Ebay','Ebay','Ebay',1,'',1,1,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='Amazon')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','Amazon','亚马逊','Amazon',1,'',1,2,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='Wish')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','Wish','Wish','Wish',1,'',1,3,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='Aliexpress')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','Aliexpress','速卖通','Aliexpress',1,'',1,4,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='DHgate')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','DHgate','敦煌网','DHgate',1,'',1,5,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='Import')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','Import','进口电商','Import',1,'',1,6,'')
END
-----------------------------------------------------------------------------------------------------------------------------
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcReport' and SettingKey='Advertisement')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcReport','Advertisement','广告等垃圾信息','Advertisement',1,'',1,1,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcReport' and SettingKey='Unfriendly')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcReport','Unfriendly','不友善内容','Unfriendly',1,'',1,2,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcReport' and SettingKey='Crime')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcReport','Crime','违反法律法规','Crime',1,'',1,3,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcReport' and SettingKey='Political')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcReport','Political','政治问题','Political',1,'',1,4,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcReport' and SettingKey='Other')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcReport','Other','其他','Other',1,'',1,5,'')
END
----END 添加标签管理 luobin 2016-03-11

--HgUser新增字段 chenrong 2016-4-25
if not exists(select * from syscolumns where id=object_id('HgUser') and name='QQOpenId') begin
	alter table HgUser add QQOpenId  nvarchar(50)  NULL
end
if not exists(select * from syscolumns where id=object_id('HgUser') and name='UserSex') begin
	alter table HgUser add UserSex  nvarchar(2)  NULL
end

--初始化HgColumnCode表数据
insert into dbo.HgColumnCode(TableName, ColumnName, TableTitle, ColumnTitle, Prefixion, PrefixionConnect, DateFormat, Identify, IdentityBit)  VALUES (N'ProTrain', N'TrainNo', N'活动安排表', N'活动编号', N'PRO', N'-', 'yyyyMMdd', 1, 4)
insert into dbo.HgColumnCode(TableName, ColumnName, TableTitle, ColumnTitle, Prefixion, PrefixionConnect, DateFormat, Identify, IdentityBit)  VALUES (N'ResLectuer', N'LectuerCode', N'讲师表', N'讲师编号', N'T', N'-',  'yyyyMMdd', 1, 4)
insert into dbo.HgColumnCode(TableName, ColumnName, TableTitle, ColumnTitle, Prefixion, PrefixionConnect, DateFormat, Identify, IdentityBit)   VALUES (N'ResLesson', N'LessonCode', N'学习系统课程表', N'课程编号', N'CO', N'-',  'yyyyMMdd', 1, 4)
insert into dbo.HgColumnCode(TableName, ColumnName, TableTitle, ColumnTitle, Prefixion, PrefixionConnect, DateFormat, Identify, IdentityBit)  VALUES (N'ResPaper', N'PaperNo', N'学习系统试卷表', N'试卷编号', N'RP', N'-',  'yyyyMMdd', 1, 4)
insert into dbo.HgColumnCode(TableName, ColumnName, TableTitle, ColumnTitle, Prefixion, PrefixionConnect, DateFormat, Identify, IdentityBit)   VALUES (N'ResQuestion', N'QuestionCode', N'学习系统题库表', N'题编号', N'Q', N'-',  'yyyyMMdd', 1, 4)
--END
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AppSetting', N'Copyright', N'版权信息', N'深圳市华海软件有限公司 - 联系电话：0755-23219920 - 粤ICP备15068257号', 1, N'', 0, 1000, N'')
GO
