﻿if not exists(select * from syscolumns where id=object_id('HgViewSource') and name='OrderNo') begin
	alter table HgViewSource  add OrderNo int  null
end
--菜单
if not exists(select * from HgSysSetting where SettingGroup='EmailSetting' and SettingKey='EmailSender')
	INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'EmailSender', N'电子邮件', N'', 1, N'', 1, 1, N'此配置用于发送电子邮件的发件人')
if not exists(select * from HgSysSetting where SettingGroup='EmailSetting' and SettingKey='DisplayName')
	INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'DisplayName', N'显示名称', N'', 1, N'', 1, 2, N'发送邮件时显示发件人的名称')
if not exists(select * from HgSysSetting where SettingGroup='EmailSetting' and SettingKey='ServerName')
	INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'ServerName', N'邮件服务器', N'', 1, N'', 1, 3, N'用于发送电子邮件的服务器')
if not exists(select * from HgSysSetting where SettingGroup='EmailSetting' and SettingKey='ServerPort')
	INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'ServerPort', N'端口号', N'', 2, N'', 1, 4, N'邮件服务器的端口号，如果不填写则使用默认端口')
if not exists(select * from HgSysSetting where SettingGroup='EmailSetting' and SettingKey='AccountName')
	INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'AccountName', N'邮件帐号', N'', 1, N'', 1, 5, N'发送电子邮件的帐号')
if not exists(select * from HgSysSetting where SettingGroup='EmailSetting' and SettingKey='AccountPwd')
	INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'AccountPwd', N'帐号密码', N'', 1, N'', 1, 6, N'对应帐号的密码')
if not exists(select * from HgSysSetting where SettingGroup='EmailSetting' and SettingKey='IsEnableSSL')
	INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'EmailSetting', N'IsEnableSSL', N'安全邮件', N'false', 3, N'', 1, 7, N'邮件服务器是否支持安全连接协议')
GO

IF OBJECT_ID(N'[dbo].[HgNotifyType]', 'U') IS NULL
BEGIN
CREATE TABLE [dbo].[HgNotifyType] (
    [TypeCode] nvarchar(32)  NOT NULL,
    [TypeName] nvarchar(64)  NOT NULL,
    [IsMail] bit  NOT NULL,
    [MailTitleTemplate] nvarchar(256)  NULL,
    [MailContentTemplate] nvarchar(max)  NULL
);
ALTER TABLE [dbo].[HgNotifyType] ADD CONSTRAINT [PK_HgNotifyType]
    PRIMARY KEY CLUSTERED ([TypeCode] ASC);
END
GO
IF OBJECT_ID(N'[dbo].[HgNotifyMail]', 'U') IS NULL
BEGIN
CREATE TABLE [dbo].[HgNotifyMail] (
    [NotifyId] bigint IDENTITY(1,1) NOT NULL,
    [MallAddress] nvarchar(64)  NOT NULL,
    [DisplayName] nvarchar(64)  NOT NULL,
    [Title] nvarchar(256)  NOT NULL,
    [Content] nvarchar(max)  NOT NULL,
    [IsSend] bit  NOT NULL,
    [IsSuccess] bit  NOT NULL,
    [TrySendTimer] int  NOT NULL,
    [SendTime] datetime  NULL,
    [NotifyType] nvarchar(32)  NOT NULL,
    [RelativeId] int  NULL,
    [Outtime] datetime  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateId] int  NULL,
    [CreateTime] datetime  NOT NULL
);
ALTER TABLE [dbo].[HgNotifyMail] ADD CONSTRAINT [PK_HgNotifyMail]
    PRIMARY KEY CLUSTERED ([NotifyId] ASC);
END
GO
--End Rick 2015-05-19 电子邮件及通知设置----

IF OBJECT_ID(N'[dbo].[HgComment]', 'U') IS NULL
BEGIN
CREATE TABLE [dbo].[HgComment] (
    [CommentId] bigint IDENTITY(1,1) NOT NULL,
    [UserId] int  NOT NULL,
    [CommentType] nvarchar(32)  NOT NULL,
    [RelationId] int  NOT NULL,
    [Context] nvarchar(max)  NULL,
    [IPAddress] nvarchar(64)  NOT NULL,
    [Creator] nvarchar(64)  NOT NULL,
    [CreateTime] datetime  NOT NULL
);
ALTER TABLE [dbo].[HgComment]
ADD CONSTRAINT [PK_HgComment]
    PRIMARY KEY CLUSTERED ([CommentId] ASC);
END
GO

/*Begin 修改官方汇率小数点位数*/
alter table HgCurrency alter column MiddleRate decimal(18, 5)
alter table HgCurrency alter column SystemRate decimal(18, 5)
GO
/*End*/

IF OBJECT_ID(N'[dbo].[FK_HgReRolePermission]', 'F') IS NULL
BEGIN
ALTER TABLE [dbo].[HgRolePermission] WITH NOCHECK
ADD CONSTRAINT [FK_HgReRolePermission]
    FOREIGN KEY ([RoleId])
    REFERENCES [dbo].[HgRole]
        ([RoleId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE [dbo].[HgRolePermission] NOCHECK CONSTRAINT [FK_HgReRolePermission];
END
GO

/*Begin chenrong2015/06/10汇率管理*/
UPDATE HgCurrency SET SystemRate=MiddleRate WHERE SystemRate=0
if not exists(select * from [HgCurrency] where CurrencyName='AUD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'AUD', N'澳大利亚元',450.15000, '2015/7/29 11:19:02', 450.15000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='BRL')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'BRL', N'巴西里亚尔', 184.91000, '2015/7/29 11:19:02', 184.91000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='CAD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'CAD', N'加拿大元', 472.78000, '2015/7/29 11:19:02', 472.78000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='CHF')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'CHF', N'瑞士法郎', 646.19000, '2015/7/29 11:19:02', 646.19000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='CNY')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'CNY', N'人民币', 100.00000, '2015/7/29 11:19:02', 100.00000, N'Y', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='DKK')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'DKK', N'丹麦克朗', 92.18000, '2015/7/29 11:19:02', 92.18000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='EUR')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'EUR', N'欧元', 678.50000, '2015/7/29 11:19:02', 678.50000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='GBP')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'GBP', N'英镑', 957.01000, '2015/7/29 11:19:02', 957.01000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='HKD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'HKD', N'港币', 78.89000, '2015/7/29 11:19:02', 78.89000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='IDR')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'IDR', N'印尼卢比', 0.04620, '2015/7/29 11:19:02', 0.04620, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='JPY')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'JPY', N'日元', 4.96630, '2015/7/29 11:19:02', 4.96630, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='KRW')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'KRW', N'韩国元', 0.53640, '2015/7/29 11:19:02', 0.53640, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='MOP')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'MOP', N'澳门元', 77.82000, '2015/7/29 11:19:02', 77.82000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='MYR')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'MYR', N'林吉特', 162.69000, '2015/7/29 11:19:02', 162.69000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='NOK')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'NOK', N'挪威克朗', 76.14000, '2015/7/29 11:19:02', 76.14000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='NZD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'NZD', N'新西兰元', 411.44000, '2015/7/29 11:19:02', 411.44000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='PHP')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'PHP', N'菲律宾比索', 13.66000, '2015/7/29 11:19:02', 13.66000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='RUB')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'RUB', N'卢布', 10.33000, '2015/7/29 11:19:02',10.33000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='SEK')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'SEK', N'瑞典克朗', 72.61000, '2015/7/29 11:19:02', 72.61000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='SGD')
 INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'SGD', N'新加坡元', 450.30000, '2015/7/29 11:19:02', 450.30000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='THB')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'THB', N'泰国铢', 17.84000, '2015/7/29 11:19:02', 17.84000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='TWD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'TWD', N'新台币', 19.77000, '2015/7/29 11:19:02', 19.77000, N'N', NULL)
if not exists(select * from [HgCurrency] where CurrencyName='USD')
	INSERT [dbo].[HgCurrency] ([CurrencyName], [CurrencyNameCN], [MiddleRate], [PubTime], [SystemRate], [IsMain], [Symbol]) VALUES (N'USD', N'美元', 611.50000, '2015/7/29 11:19:02', 611.50000, N'N', NULL)
GO
/*End*/
--Begin 修改HgCountry表PhoneCode字段长度，添加Abbreviation国家缩写字段 Lopping 2015-06-16--
alter table HgCountry alter column PhoneCode nvarchar(10)
GO
IF NOT EXISTS(SELECT * FROM syscolumns WHERE id=object_id('HgCountry') AND name='Abbreviation')
BEGIN
	ALTER TABLE HgCountry ADD Abbreviation nvarchar(10) NULL
END
--End 修改HgCountry表PhoneCode字段长度，添加Abbreviation国家缩写字段 Lopping 2015-06-16--




--Begin: Rick 2015-06-18 添加任务管理功能--------
IF OBJECT_ID(N'[dbo].[HgTask]', 'U') IS NULL
BEGIN
CREATE TABLE [dbo].[HgTask] (
    [TaskId] int IDENTITY(1,1) NOT NULL,
    [TypeCode] nvarchar(32)  NOT NULL,
    [TaskName] nvarchar(64)  NOT NULL,
    [IsActive] bit  NOT NULL,
    [TaskPeriod] smallint  NOT NULL,
    [PeriodUnit] smallint  NOT NULL,
    [PeriodValue] nvarchar(64)  NULL,
    [LastRunTime] datetime  NULL,
    [NextRunTime] datetime  NULL,
    [TaskOption1] nvarchar(64)  NULL,
    [TaskOption2] nvarchar(64)  NULL,
    [TaskOption3] nvarchar(64)  NULL,
    [TaskOption4] nvarchar(64)  NULL,
    [TaskOption5] nvarchar(64)  NULL,
    [CreateTime] datetime  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [Remorks] nvarchar(max)  NULL
);
ALTER TABLE [dbo].[HgTask]
ADD CONSTRAINT [PK_HgTask]
    PRIMARY KEY CLUSTERED ([TaskId] ASC);
END
GO

IF OBJECT_ID(N'[dbo].[HgTaskType]', 'U') IS NULL
BEGIN
CREATE TABLE [dbo].[HgTaskType] (
    [TypeCode] nvarchar(32)  NOT NULL,
    [TypeName] nvarchar(max)  NOT NULL,
    [Component] nvarchar(128)  NULL,
    [TaskOption1] nvarchar(64)  NULL,
    [TaskOption2] nvarchar(64)  NULL,
    [TaskOption3] nvarchar(64)  NULL,
    [TaskOption4] nvarchar(64)  NULL,
    [TaskOption5] nvarchar(64)  NULL,
    [Remarks] nvarchar(max)  NULL
);
ALTER TABLE [dbo].[HgTaskType]
ADD CONSTRAINT [PK_HgTaskType]
    PRIMARY KEY CLUSTERED ([TypeCode] ASC);
END
GO

IF OBJECT_ID(N'[dbo].[FK_HgReTaskType]', 'F') IS NULL
BEGIN
-- Creating foreign key on [TypeCode] in table 'HgTask'
ALTER TABLE [dbo].[HgTask] WITH NOCHECK
ADD CONSTRAINT [FK_HgReTaskType]
    FOREIGN KEY ([TypeCode])
    REFERENCES [dbo].[HgTaskType]
        ([TypeCode])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
ALTER TABLE [dbo].[HgTask] NOCHECK CONSTRAINT [FK_HgReTaskType];
-- Creating non-clustered index for FOREIGN KEY 'FK_HgReTaskType'
CREATE INDEX [IX_FK_HgReTaskType] ON [dbo].[HgTask]([TypeCode]);
END
GO
--End: Rick 2015-06-18 添加任务管理功能--------
--start chenrong 2015-06-18
  if not exists(select * from syscolumns where id=object_id('HgComment') and name='TypeCode')
		alter table HgComment add TypeCode  varchar(50)  null 
  GO
--end

--End: lopping 添加Wish接口设置菜单 2015-06-23
 
--start 国家列表更新 tutu -2015-7-1
IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Saint Kitts-Nevis' and DoubleCharacterCode='KN')
BEGIN
UPDATE HgCountry SET EnglishName='Saint Kitts-Nevis' where DoubleCharacterCode='KN' --Saint Kitts-Nevis 圣基茨和尼维斯
END
IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Falkland Islands (Islas Malvinas)' and DoubleCharacterCode='FK')
BEGIN
update HgCountry set EnglishName='Falkland Islands (Islas Malvinas)' where DoubleCharacterCode='FK' --马尔维纳斯群岛(福克兰群岛)
END
IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Korea, South' and DoubleCharacterCode='KR')
BEGIN
update HgCountry set EnglishName=N'Korea, South' where DoubleCharacterCode='KR' --Korea,Republic of 韩国
END
IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Azerbaijan Republic' and DoubleCharacterCode='AZ')
BEGIN
update HgCountry set EnglishName=N'Azerbaijan Republic' where DoubleCharacterCode='AZ' --Azerbaijan 阿塞拜疆
END
IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Guinea-Bissau'  and DoubleCharacterCode='GW')
BEGIN
update HgCountry set EnglishName=N'Guinea-Bissau' where DoubleCharacterCode='GW' -- Guine-bissau 几内亚比绍
END
IF not exists(SELECT * FROM HgCountry WHERE EnglishName='San Marino'  and DoubleCharacterCode='SM')
BEGIN
update HgCountry set EnglishName=N'San Marino' where DoubleCharacterCode='SM' -- San Marion圣马力诺
END
IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Central African Republic'  and DoubleCharacterCode='CF')
BEGIN
update HgCountry set EnglishName=N'Central African Republic' where DoubleCharacterCode='CF' --Central Africa中非 
END
IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Reunion Island'  and DoubleCharacterCode='RE')
BEGIN
update HgCountry set EnglishName=N'Reunion Island' where DoubleCharacterCode='RE' --Reunion 留尼汪
END

IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Vatican City State'  and DoubleCharacterCode='VA')
BEGIN
update HgCountry set EnglishName=N'Vatican City State' where DoubleCharacterCode='VA' --梵蒂冈 Vatican
END

IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Cote d Ivoire (Ivory Coast)'  and DoubleCharacterCode='CI')
BEGIN
update HgCountry set EnglishName=N'Cote d Ivoire (Ivory Coast)' where DoubleCharacterCode='CI' -- Cote d'Ivoire 科特迪瓦
END
IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Croatia, Republic of'  and DoubleCharacterCode='HR')
BEGIN
update HgCountry set EnglishName=N'Croatia, Republic of' where DoubleCharacterCode='HR' --Croatia Republic of Croatia 克罗地亚
END
IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Taiwan'   and DoubleCharacterCode='CT')
BEGIN
update HgCountry set EnglishName=N'Taiwan' where DoubleCharacterCode='CT' --Taiwan,China 中国台湾
END

IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Gambia'   and DoubleCharacterCode='GM')
BEGIN
update HgCountry set EnglishName=N'Gambia' where DoubleCharacterCode='GM'  -- 冈比亚Gambia  冈比亚
END

IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Russian Federation'   and DoubleCharacterCode='RU')
BEGIN
update HgCountry set EnglishName=N'Russian Federation' where DoubleCharacterCode='RU' --Russia 俄罗斯
END
IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Wallis and Futuna'  and DoubleCharacterCode='WF')
BEGIN
update HgCountry set EnglishName=N'Wallis and Futuna' where DoubleCharacterCode='WF' -- Wallis and Futuna Is-lands 瓦利斯和富图纳群岛
END

IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Gabon Republic'  and DoubleCharacterCode='GA')
BEGIN
update HgCountry set EnglishName=N'Gabon Republic' where DoubleCharacterCode='GA'  -- Gabon 加蓬
END

IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Czech Republic' and DoubleCharacterCode='CZ')
BEGIN
update HgCountry set EnglishName=N'Czech Republic' where DoubleCharacterCode='CZ' --捷克
END

IF not exists(SELECT * FROM HgCountry WHERE EnglishName='Vietnam' and DoubleCharacterCode='VN')
BEGIN
update HgCountry set EnglishName=N'Vietnam' where DoubleCharacterCode='VN' --越南
END


IF  exists(SELECT * FROM HgCountry WHERE   DoubleCharacterCode='CD')
BEGIN
update HgCountry set EnglishName=EnglishFullName where DoubleCharacterCode='CD' --刚过金
END
IF  exists(SELECT * FROM HgCountry WHERE   DoubleCharacterCode='CG')
BEGIN
update HgCountry set EnglishName=EnglishFullName where DoubleCharacterCode='CG' --刚过金
END


--end 国家列表更新 tutu -2015-7-1
-- start 新增字段 hgcountry  tutu -2015-7-7
GO
if not exists(select * from syscolumns where id=object_id('HgCountry') and name='NationalSortingCode') begin
	alter table HgCountry  add NationalSortingCode nvarchar(64)  null 
end
-- end 新增字段 hgcountry  tutu -2015-7-7
GO
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='AU')  begin update HgCountry set NationalSortingCode='25' where DoubleCharacterCode='AU' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='BR')  begin update HgCountry set NationalSortingCode='24' where DoubleCharacterCode='BR' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='BY')  begin update HgCountry set NationalSortingCode='34' where DoubleCharacterCode='BY' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='PL')  begin update HgCountry set NationalSortingCode='40' where DoubleCharacterCode='PL' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='DE')  begin update HgCountry set NationalSortingCode='31' where DoubleCharacterCode='DE' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='RU')  begin update HgCountry set NationalSortingCode='21' where DoubleCharacterCode='RU' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='FR')  begin update HgCountry set NationalSortingCode='26' where DoubleCharacterCode='FR' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='NL')  begin update HgCountry set NationalSortingCode='36' where DoubleCharacterCode='NL' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='CA')  begin update HgCountry set NationalSortingCode='28' where DoubleCharacterCode='CA' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='US')  begin update HgCountry set NationalSortingCode='22' where DoubleCharacterCode='US' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='MX')  begin update HgCountry set NationalSortingCode='39' where DoubleCharacterCode='MX' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='NO')  begin update HgCountry set NationalSortingCode='35' where DoubleCharacterCode='NO' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='SE')  begin update HgCountry set NationalSortingCode='33' where DoubleCharacterCode='SE' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='CH')  begin update HgCountry set NationalSortingCode='38' where DoubleCharacterCode='CH' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='UA')  begin update HgCountry set NationalSortingCode='37' where DoubleCharacterCode='UA' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='ES')  begin update HgCountry set NationalSortingCode='27' where DoubleCharacterCode='ES' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='IL')  begin update HgCountry set NationalSortingCode='29' where DoubleCharacterCode='IL' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='IT')  begin update HgCountry set NationalSortingCode='30' where DoubleCharacterCode='IT' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='GB')  begin update HgCountry set NationalSortingCode='23' where DoubleCharacterCode='GB' end 
if exists(select * from HgCountry where NationalSortingCode is  null and DoubleCharacterCode='CL')  begin update HgCountry set NationalSortingCode='32' where DoubleCharacterCode='CL' end 

--新增表 速猫银行 tutu 2015-7-13 start 
GO
if not exists(select * from syscolumns where id=object_id('HgPhotoBank') ) 
begin
-- Creating table 'ErpLogisticModePrintParam'
CREATE TABLE [dbo].[HgPhotoBank] (
    [PhotoBankId] bigint IDENTITY(1,1) NOT NULL,
    [DisplayName] nvarchar(256)  NULL,
    [CatalogId] bigint  NOT NULL,
    [FileSize] decimal(18,2)  NOT NULL,
    [Width] int  NOT NULL,
    [Height] int  NOT NULL,
    [PhotoSource] nvarchar(256)  NULL,
    [Url] nvarchar(512)  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL
);
end
GO
if not exists(select * from syscolumns where id=object_id('HgPhotoBankUse') ) 
begin
-- Creating table 'HgPhotoBankUse'
CREATE TABLE [dbo].[HgPhotoBankUse] (
    [PhotoBankUseId] bigint IDENTITY(1,1) NOT NULL,
    [PhotoBankId] bigint  NOT NULL,
    [UseTable] nvarchar(64)  NULL,
    [UseColumn] nvarchar(64)  NULL,
    [UseId] bigint  NOT NULL,
    [IsMain] bit  NOT NULL,
    [ListOrder] int  NOT NULL
);
end
GO

IF(EXISTS(SELECT * FROM HgCatalog where TypeCode = 'PhotoBank'))
BEGIN
DELETE FROM HgCatalog WHERE TypeCode = 'PhotoBank'
END
GO
-- start 更新 银行目录
--更新 图片银行目录 表
IF NOT EXISTS(SELECT * FROM HgCatalogType WHERE TypeCode='PhotoBank' )
BEGIN
INSERT [dbo].[HgCatalogType] ([TypeCode], [TypeName], [RootId], [ContentTable], [OrderNo], [Remarks]) VALUES (N'PhotoBank', N'图片银行分类', 1, N'HgPhotoBank', 1, N'图片银行分类')
END
GO
IF NOT EXISTS(SELECT * FROM HgCatalog WHERE  TypeCode='PhotoBank')
BEGIN
INSERT [dbo].[HgCatalog] ( [CatalogName], [TypeCode], [ParentCatalogId], [CatalogIdPath], [HasChild], 
[LevelNum], [OrderNo], [Remarks], [CreateTime], [Creator]) VALUES ( N'图片银行目录', N'PhotoBank', 0,N'/'+CONVERT(varchar(54),IDENT_CURRENT('HgCatalog'))+'/', 0, 0, 1, NULL, NULL, NULL)
END
GO
--end

--Begin:创建表 HgUserPreference 存储用户偏好  Jockey 2015-7-13
IF NOT EXISTS(SELECT * FROM syscolumns WHERE id=object_id('HgUserPreference') ) 
BEGIN
CREATE TABLE [dbo].[HgUserPreference] (
    [PreferenceId] int IDENTITY(1,1) NOT NULL,
    [UserId] int  NOT NULL,
    [PreferenceItem] nvarchar(256)  NOT NULL,
    [PreferenceValue] nvarchar(256)  NULL,
    [UpdateTime] datetime  NULL,
    [Remarks] nvarchar(512)  NULL
);
ALTER TABLE [dbo].[HgUserPreference]
ADD CONSTRAINT [PK_HgUserPreference]
    PRIMARY KEY CLUSTERED ([PreferenceId] ASC);
END
GO
IF NOT exists(SELECT * FROM syscolumns WHERE id=object_id('HgUserPreference') and name='UserId')
BEGIN
	ALTER TABLE HgUserPreference ADD UserId INT not null DEFAULT 0
END
GO

--End:创建表 HgUserPreference 存储用户偏好  Jockey 2015-7-13 

--Begin:创建标记表 HgMark Lopping 2015-07-23
IF NOT EXISTS(SELECT * FROM syscolumns WHERE id=object_id('HgMark') ) 
BEGIN
CREATE TABLE [dbo].[HgMark] (
    [MarkId] int IDENTITY(1,1) NOT NULL,
    [MarkGroup] nvarchar(64)  NULL,
    [MarkKey] nvarchar(64)  NULL,
    [MarkTitle] nvarchar(max)  NULL,
    [MarkColor] nvarchar(max)  NULL,
    [IsSystem] bit  NULL,
    [Creator] nvarchar(64)  NULL,
    [CreateTime] datetime  NULL
);
ALTER TABLE [dbo].[HgMark]
ADD CONSTRAINT [PK_HgMark]
    PRIMARY KEY CLUSTERED ([MarkId] ASC);
END
GO
--End:创建标记表 HgMark Lopping 2015-07-23

--Begin:删除HgRelation表，重新创建关联表HgMarkRelation Lopping 2015-07-28
IF EXISTS(SELECT * FROM syscolumns WHERE id=object_id('HgRelation')) 
DROP TABLE HgRelation
GO

IF NOT EXISTS(SELECT * FROM syscolumns WHERE id=object_id('HgMarkRelation') ) 
BEGIN
CREATE TABLE [dbo].[HgMarkRelation] (
    [MarkRelationId] int IDENTITY(1,1) NOT NULL,
    [RelationId] nvarchar(64)  NULL,
    [MarkId] nvarchar(64)  NULL,
    [MarkGroup] nvarchar(64)  NULL
);
ALTER TABLE [dbo].[HgMarkRelation]
ADD CONSTRAINT [PK_HgMarkRelation]
    PRIMARY KEY CLUSTERED ([MarkRelationId] ASC);
END
GO
--Begin:删除HgRelation表，重新创建关联表HgMarkRelation Lopping 2015-07-28

--Begin:HgMark表添加OrderNo排序字段 Lopping 2015-07-27
IF NOT EXISTS(SELECT * FROM syscolumns WHERE id=object_id('HgMark') and name='OrderNo' ) 
BEGIN
ALTER TABLE HgMark ADD OrderNo int null
END
GO
--END:HgMark表添加OrderNo排序字段 Lopping 2015-07-27
--End:添加订单标记菜单 Lopping 2015-07-29


--Begin: Jockey 2015-07-30 操作日志修改OperateTitle长度--------
IF exists(SELECT * FROM syscolumns WHERE id=object_id('HgOperateLog') and name='OperateTitle' and length<256)
	ALTER TABLE HgOperateLog ALTER COLUMN OperateTitle NVARCHAR(256) null
GO
--End:   Tutu 2015-8-3 图片银行目录菜单修改--------

--Begin:修改HgMarkRelation表字段类型 Lopping 2015-08-03
IF EXISTS(SELECT * FROM information_schema.columns WHERE table_name='HgMarkRelation' AND column_name='RelationId' AND data_type='nvarchar') BEGIN
	alter table HgMarkRelation alter column RelationId int null;
END
GO
IF EXISTS(SELECT * FROM information_schema.columns WHERE table_name='HgMarkRelation' AND column_name='MarkId' AND data_type='nvarchar') BEGIN
	alter table HgMarkRelation alter column MarkId int null;
END
GO
--End:修改HgMarkRelation表字段类型 Lopping 2015-08-03
 
 
--END:判断功能是否试用 tomato 2015-08-10

--Begin:修改韩国和朝鲜名称 Lopping 2015-08-15
IF EXISTS(SELECT * FROM HgCountry where EnglishName='Democratic People''s Republic of Korea')
UPDATE HgCountry SET EnglishName='North Korea',EnglishFullName='Democratic People''s Republic of Korea' WHERE DoubleCharacterCode='KP'
GO
IF EXISTS(SELECT * FROM HgCountry where EnglishName='Korea, South')
UPDATE HgCountry SET EnglishName='South Korea' WHERE DoubleCharacterCode='KR'
GO
--End:修改韩国和朝鲜名称 Lopping 2015-08-15

--Begin:修改国家名称 Lopping 2015-08-17
IF EXISTS(SELECT * FROM HgCountry WHERE EnglishName='冈比亚Gambia')
UPDATE HgCountry SET EnglishName='Gambia' WHERE DoubleCharacterCode='GM'
GO
IF EXISTS(SELECT * FROM HgCountry WHERE EnglishName='Cocos(KeelingIslands')
UPDATE HgCountry SET EnglishName='Cocos Keeling Islands',EnglishFullName='Cocos Keeling Islands' WHERE DoubleCharacterCode='CC'
GO
--End:修改国家名称 Lopping 2015-08-17
--End:修改操作日志路径 Jockey 2015-08-19

--Begin:HgArea表添加字段 Lopping 2015-10-09
IF NOT EXISTS(SELECT * FROM syscolumns WHERE id=object_id('HgArea') and name='NameEN') 
BEGIN
ALTER TABLE HgArea ADD NameEN nvarchar(100) null
END
GO
IF NOT EXISTS(SELECT * FROM syscolumns WHERE id=object_id('HgArea') and name='ParentNameEN') 
BEGIN
ALTER TABLE HgArea ADD ParentNameEN nvarchar(100) null
END
GO
--End:HgArea表添加字段 Lopping 2015-10-09
--Begin：修改塞尔维亚二字码 Lopping 2015-10-14
IF EXISTS (SELECT * FROM HgCountry WHERE DoubleCharacterCode='TS')
UPDATE HgCountry SET DoubleCharacterCode='RS' WHERE DoubleCharacterCode='TS'
--End：修改塞尔维亚二字码 Lopping 2015-10-14

--Begin：tomato 增加邮件发送时的消息 2015-10-19
IF NOT EXISTS(SELECT * FROM syscolumns WHERE id=object_id('HgNotifyMail') AND name='Message') 
BEGIN
	ALTER TABLE HgNotifyMail ADD Message nvarchar(MAX)  NULL		 
END
--End：tomato 增加邮件发送时的消息 2015-10-19

--Begin：tomato 增加邮件日志 2015-10-19
IF NOT EXISTS(SELECT * FROM [HgMenu] WHERE [MenuCode]='hg_mail_manage')
	INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'hg_mail_manage', N'邮件日志', 6, 3, NULL, N'hg_role', N'Notify/MailManage', N'glyphicon glyphicon-calendar', 1)
IF NOT EXISTS(SELECT * FROM [HgPermission] WHERE [PermissionCode]='hg_mail_manage')
	INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'hg_mail_manage', N'邮件日志', NULL, NULL, N'hg_role', 1, NULL)
delete FROM [HgPermission] WHERE [PermissionCode]='hg_mail_index' 
	INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'hg_mail_index', N'浏览邮件日志', N'Notify', N'MailManage', N'hg_mail_manage', 2, NULL)
GO
IF NOT EXISTS(SELECT * FROM [HgPermission] WHERE [PermissionCode]='hg_mail_resend')
	INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'hg_mail_resend', N'重新发送邮件', N'Notify', N'ReSendMailData', N'hg_mail_manage', 2, NULL)

--End：tomato 增加邮件日志 2015-10-19
--Begin: Rick 2015-10-29 修改首页面
IF NOT EXISTS(SELECT * FROM HgSysSetting WHERE SettingGroup=N'AppSetting' AND SettingKey=N'VersionCode')
 INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AppSetting', N'VersionCode', N'版本号', N'', 1, N'', 0, 1000, N'')
GO
--End: Rick 2015-10-29 修改首页面


--BEGIN 添加标签管理 luobin 2016-03-11
-----------------------------------------------------------------------------------------------------
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='Ebay')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','Ebay','Ebay','Ebay',1,'',1,1,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='Amazon')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','Amazon','亚马逊','Amazon',1,'',1,2,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='Wish')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','Wish','Wish','Wish',1,'',1,3,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='Aliexpress')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','Aliexpress','速卖通','Aliexpress',1,'',1,4,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='DHgate')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','DHgate','敦煌网','DHgate',1,'',1,5,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcForum' and SettingKey='Import')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcForum','Import','进口电商','Import',1,'',1,6,'')
END
-----------------------------------------------------------------------------------------------------------------------------
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcReport' and SettingKey='Advertisement')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcReport','Advertisement','广告等垃圾信息','Advertisement',1,'',1,1,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcReport' and SettingKey='Unfriendly')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcReport','Unfriendly','不友善内容','Unfriendly',1,'',1,2,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcReport' and SettingKey='Crime')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcReport','Crime','违反法律法规','Crime',1,'',1,3,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcReport' and SettingKey='Political')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcReport','Political','政治问题','Political',1,'',1,4,'')
END
if not exists (SELECT * FROM HgSysSetting where SettingGroup='EbcReport' and SettingKey='Other')
BEGIN
INSERT HgSysSetting (SettingGroup,SettingKey,SettingTitle,SettingValue,SettingType,SettingOption,AllowEdit,OrderNo,Remarks)
VALUES ('EbcReport','Other','其他','Other',1,'',1,5,'')
END
----END 添加标签管理 luobin 2016-03-11
--BEGIN 添加问答模块管理目录及权限 2016-03-16 
IF NOT EXISTS(SELECT * FROM HgMenu WHERE MenuCode='cms_forum_reply')
BEGIN
INSERT HgMenu (MenuCode,MenuName,OrderNo,LevelNo,MenuType,ParentMenuCode,MenuLink,MenuStyle,IsActive,IsTryout)VALUES('cms_forum_reply','问答管理',2,3,null,'cms_message','Forum/Index','glyphicon glyphicon-th',1,null)
END
IF NOT EXISTS(SELECT * FROM HgPermission WHERE PermissionCode='cms_forum_reply')
BEGIN
INSERT HgPermission(PermissionCode,PermissionName,ControllerName,ActionName,ParentPermissionCode,PermissionType,Remarks,IsTryout)VALUES('cms_forum_reply','问答管理',null,null,'cms_message',1,null,null)
END
IF NOT EXISTS(SELECT * FROM HgPermission WHERE PermissionCode='cms_forum_reply_index')
BEGIN
INSERT HgPermission(PermissionCode,PermissionName,ControllerName,ActionName,ParentPermissionCode,PermissionType,Remarks,IsTryout)VALUES('cms_forum_reply_index','问答管理','Forum','Index','cms_forum_reply',1,null,null)
END
IF NOT EXISTS(SELECT * FROM HgPermission WHERE PermissionCode='cms_forum_reply_lookforum')
BEGIN
INSERT HgPermission(PermissionCode,PermissionName,ControllerName,ActionName,ParentPermissionCode,PermissionType,Remarks,IsTryout)VALUES('cms_forum_reply_lookforum','问答管理','Forum','LookForum','cms_forum_reply',1,null,null)
END
--END 添加问答模块管理目录及权限 2016-03-16
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_LessonManage_batchdelete' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_LessonManage_batchdelete','课程批量删除','LessonManage','DeleteBatchLesson','rs_LessonManage',2,NULL,NULL);  --课程批量删除
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_LessonManage_mark' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_LessonManage_mark','设置标记','LessonManage','MarkLesson','rs_LessonManage',2,NULL,NULL);  --课程设置标记
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_LessonManage_deletemark' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_LessonManage_deletemark','删除标记','LessonManage','DeleteProductMark','rs_LessonManage',2,NULL,NULL);  --课程删除标记
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_LessonManage_markrefresh' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_LessonManage_markrefresh','刷新标记','LessonManage','MarkRefresh','rs_LessonManage',2,NULL,NULL);  --课程刷新标记
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_AccountTestGrade_creategrade' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_AccountTestGrade_creategrade','考试答案生成','AccountTestGrade','CreateGrade','rs_AccountTestGrade',2,NULL,NULL);  --考试答案生成
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_AccountTestGrade_deletegrade' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_AccountTestGrade_deletegrade','考试删除答案','AccountTestGrade','DelCreateGrade','rs_AccountTestGrade',2,NULL,NULL);  --考试删除答案
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_AccountTestGrade_examlist' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_AccountTestGrade_examlist','人员列表','AccountTestGrade','ProExamListUser','rs_AccountTestGrade',2,NULL,NULL);  --活动试卷考试人员列表信息
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_AccountTestGrade_viewxxamdata' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_AccountTestGrade_viewxxamdata','加载试卷','AccountTestGrade','ViewExamData','rs_AccountTestGrade',2,NULL,NULL);  --加载试卷
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_AccountTestGrade_loadexamdata' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_AccountTestGrade_loadexamdata','加载试卷','AccountTestGrade','LoadExamData','rs_AccountTestGrade',2,NULL,NULL);  --加载试卷
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_AccountTestGrade_delgrade' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_AccountTestGrade_delgrade','删除成绩','AccountTestGrade','DelGrade','rs_AccountTestGrade',2,NULL,NULL);  --删除成绩
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_AccountTestGrade_editinfo' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_AccountTestGrade_editinfo','编辑成绩','AccountTestGrade','EditGradeInfo','rs_AccountTestGrade',2,NULL,NULL);  --编辑成绩
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_AccountTrainGrade_trainlist' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_AccountTrainGrade_trainlist','考试人员列表','AccountTrainGrade','ProTrainListUser','rs_AccountTrainGrade',2,NULL,NULL);  --考试人员列表
go
if not exists(select PermissionCode from HgPermission where PermissionCode='res_comment_delete' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('res_comment_delete','删除评论','Comment','Delete','res_comment',2,NULL,NULL);  --删除评论
go
if not exists(select PermissionCode from HgPermission where PermissionCode='res_comment_deletereply' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('res_comment_deletereply','删除评论回复','Comment','DeleteReply','res_comment',2,NULL,NULL);  --删除评论回复
go
if not exists(select PermissionCode from HgPermission where PermissionCode='res_comment_commentreply' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('res_comment_commentreply','评论回复','Comment','CommentReply','res_comment',2,NULL,NULL);  --评论回复
go
if not exists(select PermissionCode from HgPermission where PermissionCode='res_comment_lookcomment' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('res_comment_lookcomment','评论回复','Comment','LookComment','res_comment',2,NULL,NULL);  --查看评论
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_ExamPaper_batchdelete' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_ExamPaper_batchdelete','批量删除','PaperManage','DeletePaperByPaperIds','rs_ExamPaper',2,NULL,NULL);  --批量删除
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_ExamPaper_deletedata' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_ExamPaper_deletedata','批量删除','PaperManage','DeleteBatchPaper','rs_ExamPaper',2,NULL,NULL);  --批量删除
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_ExamPaper_editdata' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_ExamPaper_editdata','批量修改题库','PaperManage','BatchEditPaper','rs_ExamPaper',2,NULL,NULL);  --批量修改题库
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_ExamPaper_editpaper' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_ExamPaper_editpaper','批量修改题库','PaperManage','BatchEditPaper','rs_ExamPaper',2,NULL,NULL);  --批量修改题库
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTestJudge_examuser' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTestJudge_examuser',' 人员列表信息','ProTestJudge','ProExamUser','Pro_TestJudge',2,NULL,NULL);  --人员列表信息
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTestJudge_updateexamdata' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTestJudge_updateexamdata',' 修改试卷信息','ProTestJudge','UpdateExamData','Pro_TestJudge',2,NULL,NULL);  --修改试卷信息
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTestJudge_loadexamdata' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTestJudge_loadexamdata',' 加载试卷信息','ProTestJudge','LoadExamData','Pro_TestJudge',2,NULL,NULL);  --加载试卷信息
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTestJudge_autoscore' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTestJudge_autoscore',' 自动评分','ProTestJudge','AutoPostJudgeScore','Pro_TestJudge',2,NULL,NULL);  --自动评分
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTestGrade_creategrade' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTestGrade_creategrade','考试答案生成','ProTestGrade','CreateGrade','Pro_TestGrade',2,NULL,NULL);  --考试答案生成
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTestGrade_delcreategrade' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTestGrade_delcreategrade','考试删除答案','ProTestGrade','DelCreateGrade','Pro_TestGrade',2,NULL,NULL);  --考试删除答案
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTestGrade_proexamlistuser' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTestGrade_proexamlistuser','人员列表','ProTestGrade','ProExamListUser','Pro_TestGrade',2,NULL,NULL);  --活动试卷考试人员列表信息
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTestGrade_viewxxamdata' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTestGrade_viewxxamdata','加载试卷','ProTestGrade','ViewExamData','Pro_TestGrade',2,NULL,NULL);  --加载试卷
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTestGrade_loadexamdata' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTestGrade_loadexamdata','加载试卷','ProTestGrade','LoadExamData','Pro_TestGrade',2,NULL,NULL);  --加载试卷
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTestGrade_delgrade' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTestGrade_delgrade','删除成绩','ProTestGrade','DelGrade','Pro_TestGrade',2,NULL,NULL);  --删除成绩
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTestGrade_editgradeinfo' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTestGrade_editgradeinfo','编辑成绩','ProTestGrade','EditGradeInfo','Pro_TestGrade',2,NULL,NULL);  --编辑成绩
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTrainGrade_process' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTrainGrade_process','学习进度','ProTrainGrade','Process','Pro_TrainGrade',2,NULL,NULL);  --学习进度
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTrainGrade_nothasstudyuser' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTrainGrade_nothasstudyuser','未学习','ProTrainGrade','NotHasStudyUser','Pro_TrainGrade',2,NULL,NULL);  --学习进度
go
if not exists(select PermissionCode from HgPermission where PermissionCode='ProTrainGrade_hasstudyuser' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('ProTrainGrade_hasstudyuser','学习','ProTrainGrade','HasStudyUser','Pro_TrainGrade',2,NULL,NULL);  --学习进度
go
if not exists(select PermissionCode from HgPermission where PermissionCode='pro_ActivityPlanManage_batchdel' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('pro_ActivityPlanManage_batchdel','批量删除','ProTrainManage','DeleteTrainByIds','pro_ActivityPlanManage',2,NULL,NULL);  --批量删除
go
if not exists(select PermissionCode from HgPermission where PermissionCode='pro_ActivityPlanManage_mark' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('pro_ActivityPlanManage_mark','设置标记','ProTrainManage','MarkTrain','pro_ActivityPlanManage',2,NULL,NULL);  --课程设置标记
go
if not exists(select PermissionCode from HgPermission where PermissionCode='pro_ActivityPlanManage_delmark' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('pro_ActivityPlanManage_delmark','删除标记','ProTrainManage','DeleteMark','pro_ActivityPlanManage',2,NULL,NULL);  --课程删除标记
go
if not exists(select PermissionCode from HgPermission where PermissionCode='pro_ActivityPlanManage_refresh' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('pro_ActivityPlanManage_refresh','刷新标记','ProTrainManage','MarkRefresh','pro_ActivityPlanManage',2,NULL,NULL);  --课程刷新标记
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_Question_viewassociation' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_Question_viewassociation','查看关联','QuestionManage','ViewAssociation','rs_Question',2,NULL,NULL);  --查看关联
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_Question_connactive' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_Question_connactive','关联活动','QuestionManage','ConnectionActive','rs_Question',2,NULL,NULL);  --关联活动
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_Question_batchdelete' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_Question_batchdelete','批量删除','QuestionManage','BatchDelete','rs_Question',2,NULL,NULL);  --批量删除
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_Question_export' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_Question_export','批量导出','QuestionManage','Export','rs_Question',2,NULL,NULL);  --批量导出
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_Question_exportExcl' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_Question_exportExcl','批量导出题库','QuestionManage','ExportExcel','rs_Question',2,NULL,NULL);  --批量导出
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_Question_importwordmodule' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_Question_importwordmodule','下载模板','QuestionManage','ImportWordModule','rs_Question',2,NULL,NULL);  --批量导出
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_Question_mark' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_Question_mark','设置标记','QuestionManage','MarkQuestion','rs_Question',2,NULL,NULL);  --课程设置标记
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_Question_deletemark' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_Question_deletemark','删除标记','QuestionManage','DeleteMark','rs_Question',2,NULL,NULL);  --课程删除标记
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_Question_markrefresh' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_Question_markrefresh','刷新标记','QuestionManage','MarkRefresh','rs_Question',2,NULL,NULL);  --课程刷新标记
go
if not exists(select PermissionCode from HgPermission where PermissionCode='rs_Question_batchedit' )
INSERT [dbo].HgPermission (PermissionCode, PermissionName, ControllerName, ActionName, ParentPermissionCode, PermissionType, Remarks, IsTryout)
values('rs_Question_batchedit','批量修改','QuestionManage','BatchEditQuestion','rs_Question',2,NULL,NULL);  --课程批量修改
go

if not exists(select * from HgSysSetting where SettingGroup='AppSetting' and SettingKey='Copyright')
INSERT [dbo].[HgSysSetting] ([SettingGroup], [SettingKey], [SettingTitle], [SettingValue], [SettingType], [SettingOption], [AllowEdit], [OrderNo], [Remarks]) VALUES (N'AppSetting', N'Copyright', N'版权信息', N'深圳市华海软件有限公司 - 联系电话：0755-23219920 - 粤ICP备15068257号', 1, N'', 0, 1000, N'')
GO
