﻿
IF OBJECT_ID(N'[dbo].[FK_MngEditionMngEditionApp]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[MngEditionApp] DROP CONSTRAINT [FK_MngEditionMngEditionApp];
GO
IF OBJECT_ID(N'[dbo].[FK_ReMngEnterpriseApp]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[MngEnterpriseApp] DROP CONSTRAINT [FK_ReMngEnterpriseApp];
GO
IF OBJECT_ID(N'[dbo].[FK_ReMngEnterpriseRental]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[MngEnterpriseRental] DROP CONSTRAINT [FK_ReMngEnterpriseRental];
GO

IF OBJECT_ID(N'[dbo].[MngEnterprise]', 'U') IS NOT NULL
    DROP TABLE [dbo].[MngEnterprise];
GO
IF OBJECT_ID(N'[dbo].[MngEnterpriseApp]', 'U') IS NOT NULL
    DROP TABLE [dbo].[MngEnterpriseApp];
GO
IF OBJECT_ID(N'[dbo].[MngApp]', 'U') IS NOT NULL
    DROP TABLE [dbo].[MngApp];
GO
IF OBJECT_ID(N'[dbo].[MngEnterpriseRental]', 'U') IS NOT NULL
    DROP TABLE [dbo].[MngEnterpriseRental];
GO
IF OBJECT_ID(N'[dbo].[MngAccountApply]', 'U') IS NOT NULL
    DROP TABLE [dbo].[MngAccountApply];
GO
IF OBJECT_ID(N'[dbo].[MngEdition]', 'U') IS NOT NULL
    DROP TABLE [dbo].[MngEdition];
GO
IF OBJECT_ID(N'[dbo].[MngEditionApp]', 'U') IS NOT NULL
    DROP TABLE [dbo].[MngEditionApp];
GO
IF OBJECT_ID(N'[dbo].[MngPasswordApply]', 'U') IS NOT NULL
    DROP TABLE [dbo].[MngPasswordApply];
GO
-- --------------------------------------------------
-- Creating all tables
-- --------------------------------------------------

-- Creating table 'MngEnterprise'
CREATE TABLE [dbo].[MngEnterprise] (
    [EnterpriseId] int IDENTITY(1,1) NOT NULL,
    [EnterpriseCode] nvarchar(32)  NOT NULL,
    [EnterpriseName] nvarchar(64)  NULL,
    [EnterpriseState] smallint  NULL,
    [CatalogId] int  NOT NULL,
    [Contact] nvarchar(64)  NULL,
    [Mobile] nvarchar(32)  NULL,
    [Telphone] nvarchar(32)  NULL,
    [Email] nvarchar(64)  NULL,
    [Birthday] datetime  NULL,
    [Address] nvarchar(128)  NULL,
    [RentalTime] datetime  NULL,
    [RentalEndTime] datetime  NULL,
    [Rental] decimal(18,2)  NOT NULL,
    [LimitUserNum] int  NOT NULL,
    [DatabaseName] nvarchar(64)  NULL,
    [DatafileName] nvarchar(64)  NULL,
    [LogfileName] nvarchar(64)  NULL,
    [AccountType] smallint  NOT NULL,
    [Remarks] nvarchar(max)  NULL,
    [CreateTime] datetime  NULL,
    [Creator] nvarchar(42)  NULL,
    [TryoutEndTime] datetime  NULL
);
GO

-- Creating table 'MngEnterpriseApp'
CREATE TABLE [dbo].[MngEnterpriseApp] (
    [EnterpriseId] int  NOT NULL,
    [AppCode] nvarchar(32)  NOT NULL
);
GO

-- Creating table 'MngApp'
CREATE TABLE [dbo].[MngApp] (
    [AppCode] nvarchar(32)  NOT NULL,
    [AppName] nvarchar(64)  NOT NULL,
    [ParentAppCode] nvarchar(32)  NULL,
    [OrderNo] int  NOT NULL,
    [LevelNo] int  NOT NULL,
    [AppType] nvarchar(16)  NULL
);
GO

-- Creating table 'MngEnterpriseRental'
CREATE TABLE [dbo].[MngEnterpriseRental] (
    [RentalId] int IDENTITY(1,1) NOT NULL,
    [EnterpriseId] int  NOT NULL,
    [UserId] int  NOT NULL,
    [PayType] nvarchar(64)  NULL,
    [PayAccount] nvarchar(128)  NULL,
    [Rental] decimal(18,2)  NOT NULL,
    [EentalEndTime] datetime  NULL,
    [LimitUserNum] int  NOT NULL,
    [RentalState] smallint  NOT NULL,
    [Remarks] nvarchar(max)  NULL,
    [CreateTime] datetime  NULL,
    [Creator] nvarchar(64)  NULL
);
GO

-- Creating table 'MngAccountApply'
CREATE TABLE [dbo].[MngAccountApply] (
    [ApplyId] int IDENTITY(1,1) NOT NULL,
    [EnterpriseCode] nvarchar(32)  NULL,
    [EnterpriseName] nvarchar(64)  NULL,
    [ApplyType] smallint  NOT NULL,
    [Contact] nvarchar(64)  NULL,
    [Mobile] nvarchar(32)  NULL,
    [Telphone] nvarchar(32)  NULL,
    [Email] nvarchar(64)  NULL,
    [IsVerify] bit default(0) NOT NULL,
    [VerifyTime] datetime  NULL,
    [VerifyCode] nvarchar(256)  NULL,
    [VerifyOuttime] datetime  NULL,
    [Platform] nvarchar(32)  NULL,
    [LoginName] nvarchar(32)  NULL,
    [Password] nvarchar(32)  NULL,
    [ApplyState] smallint default(0) NOT NULL,
    [Examiner] nvarchar(64)  NULL,
    [ExamineTime] datetime  NULL,
    [ExamineResult] nvarchar(max)  NULL,
    [CreateTime] datetime  NULL,
    [Remarks] nvarchar(max)  NULL
);
GO

-- Creating table 'MngEdition'
CREATE TABLE [dbo].[MngEdition] (
    [EditionId] int IDENTITY(1,1) NOT NULL,
    [EditionName] nvarchar(64)  NOT NULL,
    [IsActive] bit  NOT NULL,
    [CreateTime] datetime  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [Remarks] nvarchar(512)  NULL
);
GO

-- Creating table 'MngEditionApp'
CREATE TABLE [dbo].[MngEditionApp] (
    [EditionId] int  NOT NULL,
    [AppCode] nvarchar(32)  NOT NULL
);
GO

-- Creating table 'MngPasswordApply'
CREATE TABLE [dbo].[MngPasswordApply] (
    [ApplyId] int IDENTITY(1,1) NOT NULL,
    [EnterpriseId] int  NOT NULL,
    [EnterpriseCode] nvarchar(32)  NOT NULL,
    [EnterpriseName] nvarchar(64)  NULL,
    [LoginName] nvarchar(32)  NULL,
    [Email] nvarchar(64)  NULL,
    [IsVerify] bit  NOT NULL,
    [VerifyTime] datetime  NULL,
    [VerifyCode] nvarchar(256)  NULL,
    [VerifyOuttime] datetime  NULL,
    [CreateTime] datetime  NULL,
    [IpAddress] nvarchar(64)  NULL,
    [Remarks] nvarchar(max)  NULL
);
GO
-- --------------------------------------------------
-- Creating all PRIMARY KEY constraints
-- --------------------------------------------------

-- Creating primary key on [EnterpriseId] in table 'MngEnterprise'
ALTER TABLE [dbo].[MngEnterprise]
ADD CONSTRAINT [PK_MngEnterprise]
    PRIMARY KEY CLUSTERED ([EnterpriseId] ASC);
GO

-- Creating primary key on [AppCode], [EnterpriseId] in table 'MngEnterpriseApp'
ALTER TABLE [dbo].[MngEnterpriseApp]
ADD CONSTRAINT [PK_MngEnterpriseApp]
    PRIMARY KEY CLUSTERED ([AppCode], [EnterpriseId] ASC);
GO

-- Creating primary key on [AppCode] in table 'MngApp'
ALTER TABLE [dbo].[MngApp]
ADD CONSTRAINT [PK_MngApp]
    PRIMARY KEY CLUSTERED ([AppCode] ASC);
GO

-- Creating primary key on [RentalId] in table 'MngEnterpriseRental'
ALTER TABLE [dbo].[MngEnterpriseRental]
ADD CONSTRAINT [PK_MngEnterpriseRental]
    PRIMARY KEY CLUSTERED ([RentalId] ASC);
GO

-- Creating primary key on [ApplyId] in table 'MngAccountApply'
ALTER TABLE [dbo].[MngAccountApply]
ADD CONSTRAINT [PK_MngAccountApply]
    PRIMARY KEY CLUSTERED ([ApplyId] ASC);
GO
-- Creating primary key on [EditionId] in table 'MngEdition'
ALTER TABLE [dbo].[MngEdition]
ADD CONSTRAINT [PK_MngEdition]
    PRIMARY KEY CLUSTERED ([EditionId] ASC);
GO

-- Creating primary key on [EditionId], [AppCode] in table 'MngEditionApp'
ALTER TABLE [dbo].[MngEditionApp]
ADD CONSTRAINT [PK_MngEditionApp]
    PRIMARY KEY CLUSTERED ([EditionId], [AppCode] ASC);
GO

-- Creating primary key on [ApplyId] in table 'MngPasswordApply'
ALTER TABLE [dbo].[MngPasswordApply]
ADD CONSTRAINT [PK_MngPasswordApply]
    PRIMARY KEY CLUSTERED ([ApplyId] ASC);
GO

-- --------------------------------------------------
-- Creating all FOREIGN KEY constraints
-- --------------------------------------------------

-- Creating foreign key on [EditionId] in table 'MngEditionApp'
ALTER TABLE [dbo].[MngEditionApp] ADD CONSTRAINT [FK_MngEditionMngEditionApp]
    FOREIGN KEY ([EditionId])
    REFERENCES [dbo].[MngEdition]
        ([EditionId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating foreign key on [EnterpriseId] in table 'MngEnterpriseApp'
ALTER TABLE [dbo].[MngEnterpriseApp] ADD CONSTRAINT [FK_ReMngEnterpriseApp]
    FOREIGN KEY ([EnterpriseId])
    REFERENCES [dbo].[MngEnterprise]
        ([EnterpriseId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ReMngEnterpriseApp'
CREATE INDEX [IX_FK_ReMngEnterpriseApp] ON [dbo].[MngEnterpriseApp]
    ([EnterpriseId]);
GO

-- Creating foreign key on [EnterpriseId] in table 'MngEnterpriseRental'
ALTER TABLE [dbo].[MngEnterpriseRental] ADD CONSTRAINT [FK_ReMngEnterpriseRental]
    FOREIGN KEY ([EnterpriseId])
    REFERENCES [dbo].[MngEnterprise]
        ([EnterpriseId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_ReMngEnterpriseRental'
CREATE INDEX [IX_FK_ReMngEnterpriseRental] ON [dbo].[MngEnterpriseRental]
    ([EnterpriseId]);
GO
