﻿if not exists(select * from [dbo].[MngApp] where AppCode='erp_message_template')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_message_template', N'信息模板设置', 4, 3, N'hg_businessplatform_setting')
if not exists(select * from MngApp where AppCode='hg_email_setting')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'hg_email_setting', N'邮件设置', 8, 3, N'hg_framework_setting')
if not exists(select * from MngApp where AppCode='hg_notify_setting')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'hg_notify_setting', N'通知设置', 9, 3, N'hg_framework_setting')
GO
--Begin Rick 2015-05-19 电子邮件及通知设置----
if not exists(select * from HgNotifyType where TypeCode='EnterpriseApplyVerify')
	INSERT INTO [dbo].[HgNotifyType]([TypeCode],[TypeName],[IsMail],[MailTitleTemplate],[MailContentTemplate]) VALUES (N'EnterpriseApplyVerify',N'企业帐号申请验证',1,null,null)
GO
if not exists(select * from HgNotifyType where TypeCode='EnterpriseApplySuccess')
	INSERT INTO [dbo].[HgNotifyType]([TypeCode],[TypeName],[IsMail],[MailTitleTemplate],[MailContentTemplate]) VALUES (N'EnterpriseApplySuccess',N'企业帐号申请成功',1,null,null)
GO
if not exists(select * from syscolumns where id=object_id('MngAccountApply') and name='EnterpriseCode')
	alter table MngAccountApply add EnterpriseCode nvarchar(32) null
if not exists(select * from syscolumns where id=object_id('MngAccountApply') and name='IsVerify')
	alter table MngAccountApply add IsVerify bit default(0) NOT NULL
if not exists(select * from syscolumns where id=object_id('MngAccountApply') and name='VerifyTime')
	alter table MngAccountApply add VerifyTime datetime  NULL
if not exists(select * from syscolumns where id=object_id('MngAccountApply') and name='VerifyCode')
	alter table MngAccountApply add VerifyCode nvarchar(256)  NULL
if not exists(select * from syscolumns where id=object_id('MngAccountApply') and name='VerifyOuttime')
	alter table MngAccountApply add VerifyOuttime datetime  NULL
GO
--End Rick 2015-05-19 电子邮件及通知设置----

--Begin Rick 2015-05-22 添加版本管理功能---------
IF OBJECT_ID(N'[dbo].[MngEdition]', 'U') IS NULL
BEGIN
CREATE TABLE [dbo].[MngEdition] (
    [EditionId] int IDENTITY(1,1) NOT NULL,
    [EditionName] nvarchar(64)  NOT NULL,
    [IsActive] bit  NOT NULL,
    [CreateTime] datetime  NOT NULL,
    [Creator] nvarchar(64)  NULL,
    [Remarks] nvarchar(512)  NULL
);
ALTER TABLE [dbo].[MngEdition]
ADD CONSTRAINT [PK_MngEdition]
    PRIMARY KEY CLUSTERED ([EditionId] ASC);
END
GO
IF OBJECT_ID(N'[dbo].[MngEditionApp]', 'U') IS NULL
BEGIN
CREATE TABLE [dbo].[MngEditionApp] (
    [EditionId] int  NOT NULL,
    [AppCode] nvarchar(32)  NOT NULL
);
ALTER TABLE [dbo].[MngEditionApp]
ADD CONSTRAINT [PK_MngEditionApp]
    PRIMARY KEY CLUSTERED ([EditionId], [AppCode] ASC);
END
GO

IF OBJECT_ID(N'[dbo].[FK_MngEditionMngEditionApp]', 'F') IS NULL
ALTER TABLE [dbo].[MngEditionApp]
ADD CONSTRAINT [FK_MngEditionMngEditionApp]
    FOREIGN KEY ([EditionId])
    REFERENCES [dbo].[MngEdition]
        ([EditionId])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO
IF NOT EXISTS(SELECT * FROM HgMenu WHERE MenuCode='mng_edition_manage')
	INSERT [dbo].[HgMenu] ([MenuCode], [MenuName], [OrderNo], [LevelNo], [MenuType], [ParentMenuCode], [MenuLink], [MenuStyle], [IsActive]) VALUES (N'mng_edition_manage', N'版本管理', 5, 3, NULL, N'mng_manage_manage', N'Edition/Index', N'glyphicon glyphicon-book', 1)

IF NOT EXISTS(SELECT * FROM HgPermission WHERE PermissionCode='mng_edition_manage')
	INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'mng_edition_manage', N'版本管理', NULL, NULL, N'mng_manage_manage', 1, NULL)
IF NOT EXISTS(SELECT * FROM HgPermission WHERE PermissionCode='mng_edition_manage_index')
	INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'mng_edition_manage_index', N'浏览版本管理', N'Edition', N'Index', N'mng_edition_manage', 2, NULL)
IF NOT EXISTS(SELECT * FROM HgPermission WHERE PermissionCode='mng_edition_manage_edit')
	INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'mng_edition_manage_edit', N'编辑版本信息', N'Edition', N'Edit', N'mng_edition_manage', 2, NULL)
IF NOT EXISTS(SELECT * FROM HgPermission WHERE PermissionCode='mng_edition_manage_delete')
	INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'mng_edition_manage_delete', N'删除版本信息', N'Edition', N'Delete', N'mng_edition_manage', 2, NULL)
GO
--End Rick 2015-05-22 添加版本管理功能---------

--Begin Rick 2015-05-27 添加找回企业管理员密码功能---------
IF OBJECT_ID(N'[dbo].[MngPasswordApply]', 'U') IS NULL
BEGIN
CREATE TABLE [dbo].[MngPasswordApply] (
    [ApplyId] int IDENTITY(1,1) NOT NULL,
    [EnterpriseId] int  NOT NULL,
    [EnterpriseCode] nvarchar(32)  NOT NULL,
    [EnterpriseName] nvarchar(64)  NULL,
    [LoginName] nvarchar(32)  NULL,
    [Email] nvarchar(64)  NULL,
    [IsVerify] bit  NOT NULL,
    [VerifyTime] datetime  NULL,
    [VerifyCode] nvarchar(256)  NULL,
    [VerifyOuttime] datetime  NULL,
    [CreateTime] datetime  NULL,
    [IpAddress] nvarchar(64)  NULL,
    [Remarks] nvarchar(max)  NULL
);
ALTER TABLE [dbo].[MngPasswordApply] ADD CONSTRAINT [PK_MngPasswordApply]
    PRIMARY KEY CLUSTERED ([ApplyId] ASC);
END
GO
if not exists(select * from HgNotifyType where TypeCode='ResetPasswordVerify')
	INSERT INTO [dbo].[HgNotifyType]([TypeCode],[TypeName],[IsMail],[MailTitleTemplate],[MailContentTemplate]) VALUES (N'ResetPasswordVerify',N'重设置密码验证',1,null,null)
GO
--End Rick 2015-05-27 添加找回企业管理员密码功能---------

--Begin Rick 2015-06-04 添加配置向导功能--
IF NOT EXISTS(SELECT * FROM [MngApp] WHERE [AppCode]=N'erp_order_setting')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_order_setting', N'订单模块设置', 4, 3, N'hg_framework_setting')
GO
--End Rick 2015-06-04 添加配置向导功能--
IF NOT EXISTS(SELECT * FROM HgPermission WHERE PermissionCode=N'mng_account_apply_delete')
	INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'mng_account_apply_delete', N'删除帐户申请', N'AccountApply', N'Delete', N'mng_account_apply', 2, NULL)
GO

--Rick 2015-06-09 添加站内信菜单---
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_order_sitemessage')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_order_sitemessage', N'站内信', 7, 3, N'erp_order')
GO
--End 2015-06-09 添加站内信菜单---

--Jockey 2015-06-09 添加跟踪号号码池菜单---
IF not exists(select * from MngApp where AppCode='erp_TrackingNumPool' )
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_TrackingNumPool',N'跟踪号号码池',5,3,N'erp_logistic')
GO
--End 2015-06-09 添加跟踪号号码池菜单---

--Jockey 2015-06-09 添加默认报关信息菜单---
if not exists(select AppCode from MngApp where AppCode='erp_logistic_custominfo_setting' )
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_logistic_custominfo_setting',N'默认报关信息',4,3,'erp_logistic');
GO
--End 2015-06-09 添加默认报关信息菜单---
/*Start 添加"退单管理、退款及纠纷"菜单 lopping 2015-06-10*/
if not exists(select AppCode from MngApp where AppCode='erp_order_issue' )
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_order_issue',N'退款及纠纷',45,3,'erp_order');
GO
/*End 添加"退单管理、退款及纠纷"菜单 lopping 2015-06-10*/

IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='hg_Task_setting')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'hg_Task_setting', N'任务设置', 10, 3, N'hg_framework_setting')
GO



/*Amazon*/
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_amazon_api_setting')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_amazon_api_setting', N'Amazon接口设置', 10, 3, N'hg_businessplatform_setting')
GO

--Begin:lopping 添加虚拟发货、Wish接口设置菜单 2015-06-23
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_ordervirtual')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_ordervirtual', N'虚拟发货', 20, 3, N'erp_order')
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_wish_api_setting')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_wish_api_setting', N'Wish接口设置', 2, 3, N'hg_businessplatform_setting')
GO
--End:lopping 添加虚拟发货、Wish接口设置菜单 2015-06-23

--begin 添加微信菜单 bunny 2015-07-13

if not exists(select * from MngApp where AppCode='cms_weChat')
INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'cms_weChat', N'微信平台', 1, 2, N'mng_manage_manage')
GO
if not exists(select * from MngApp where AppCode='cms_weChat_Index')
INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'cms_weChat_Index', N'微信公众号信息', 2, 3, N'cms_weChat')
GO
if not exists(select * from MngApp where AppCode='cms_weChat_Setting')
INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'cms_weChat_Setting', N'微信接口设置', 1, 3, N'cms_weChat')
GO
--end 添加微信菜单

--Begin Rick 修改商品同步功能，添加在线商品表为以后商品刊登做准备---
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode=N'erp_online_product')
INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_online_product', N'线上商品', 2, 2, 'erp_product')
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode=N'erp_online_product_manage')
INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_online_product_manage', N'线上商品管理', 1, 3, 'erp_online_product')
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode=N'erp_match_product')
INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_match_product', N'匹配产品', 2, 3, 'erp_online_product')
GO
--End Rick 修改商品同步功能，添加在线商品表为以后商品刊登做准备---
--begin bunny 添加盘盈盘亏菜单  2015-07-23
IF NOT EXISTS(SELECT * FROM [MngApp] WHERE [AppCode]=N'erp_CheckingSub')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_CheckingSub', N'盘亏单', 5, 3, N'erp_stock')
GO

IF NOT EXISTS(SELECT * FROM [MngApp] WHERE [AppCode]=N'erp_CheckingAdd')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_CheckingAdd', N'盘盈单', 5, 3, N'erp_stock')
GO
--end


--BEGIN 新增报表菜单 chenrong 2015-07-27
IF EXISTS(SELECT AppCode FROM MngApp WHERE AppCode='hg_framework' and OrderNo=7 )
UPDATE MngApp SET orderno=8 WHERE AppCode='hg_framework' 
GO

IF NOT EXISTS(SELECT AppCode FROM MngApp WHERE AppCode='erp_salereport' )
INSERT [dbo].[MngApp] ([AppCode], [AppName],[ParentAppCode],[OrderNo], [LevelNo]) VALUES('erp_salereport','统计报表',NULL,7,1);
IF NOT EXISTS(SELECT AppCode FROM MngApp WHERE AppCode='erp_salereport_manage' )
INSERT [dbo].[MngApp] ([AppCode], [AppName],[ParentAppCode], [OrderNo], [LevelNo]) VALUES('erp_salereport_manage','统计报表','erp_salereport',1,2);
IF NOT EXISTS(SELECT AppCode FROM MngApp WHERE AppCode='erp_product_report' )
INSERT [dbo].[MngApp] ([AppCode], [AppName],[ParentAppCode],[OrderNo], [LevelNo]) VALUES('erp_product_report','产品销量统计','erp_salereport_manage',1,3);
IF NOT EXISTS(SELECT AppCode FROM MngApp WHERE AppCode='erp_product_salesreport' )
INSERT [dbo].[MngApp] ([AppCode], [AppName],[ParentAppCode],[OrderNo], [LevelNo]) VALUES('erp_product_salesreport','产品销量排行榜','erp_salereport_manage',2,3);
--END
--Begin: Rick 添加SKU映射管理功能 2015-07-29--
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode=N'erp_sku_mapping')
INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_sku_mapping', N'SKU映射', 15, 3, 'erp_online_product')
GO
--End: Rick 添加SKU映射管理功能 2015-07-29--

--Begin: Jockey 修改产品供应商为供应商报价 2015-07-29--
UPDATE MngApp SET AppName='供应商报价' WHERE AppCode='erp_supplier_product' AND AppName='产品供应商'
--End: Jockey 修改产品供应商为供应商报价 2015-07-29--

--Begin 新增“标记设置”菜单 Lopping 2015-07-30
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='hg_mark_setting')
INSERT [dbo].[MngApp] ([AppCode], [AppName],[ParentAppCode],[OrderNo], [LevelNo]) VALUES('hg_mark_setting','标记设置','hg_framework_setting',15,3);
--END 新增“标记设置”菜单 Lopping 2015-07-30

--Begin: Jockey 新增加采购菜单 2015-08-01
UPDATE MngApp SET OrderNo=15 WHERE AppCode='erp_pur_order'
UPDATE MngApp SET OrderNo=20 WHERE AppCode='erp_pur_return'
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_pur_plan')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_pur_plan', N'采购计划',  10, 3, N'erp_pur_manage')
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_outofstock_order')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_outofstock_order', N'缺货订单', 25, 3, N'erp_pur_manage')
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_outofstock_product')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_outofstock_product', N'缺货产品', 30, 3, N'erp_pur_manage')
--End: Jockey 新增加采购菜单 2015-08-01

--Begin: Jockey 图片银行菜单 2015-08-01
IF NOT EXISTS(SELECT AppCode FROM MngApp WHERE AppCode='hg_photobank' )
	INSERT [dbo].[MngApp] ([AppCode], [AppName],[ParentAppCode],[OrderNo], [LevelNo]) VALUES('hg_photobank','图片银行','erp_product_module',20,3)
IF NOT EXISTS(SELECT AppCode FROM MngApp WHERE AppCode='catalog_photobank' )
	INSERT [dbo].[MngApp] ([AppCode], [AppName],[ParentAppCode],[OrderNo], [LevelNo]) VALUES('catalog_photobank','图片银行目录','erp_product_module',25,3)
--End: Jockey 图片银行菜单 2015-08-01

--BEGIN:判断功能是否试用 增加企业试用结束时间属性 tomato 2015-8-10
if not exists(select * from syscolumns where id=object_id('MngEnterprise') and name='TryoutEndTime') begin
	alter table MngEnterprise  add TryoutEndTime datetime  null
end
--END:判断功能是否试用 tomato 2015-08-10

--BEGIN:增加发送推广邮件功能 tomato 2015-8-24
if not exists(select * from HgNotifyType where TypeCode='EnterpriseSendEmail')
	INSERT INTO [dbo].[HgNotifyType]([TypeCode],[TypeName],[IsMail],[MailTitleTemplate],[MailContentTemplate]) VALUES (N'EnterpriseSendEmail',N'企业推广邮件',1,null,null)
GO
if not exists(select * from HgPermission where PermissionCode='mng_enterprise_sendemail')
	INSERT [dbo].[HgPermission] ([PermissionCode], [PermissionName], [ControllerName], [ActionName], [ParentPermissionCode], [PermissionType], [Remarks]) VALUES (N'mng_enterprise_sendemail', N'发送企业推广邮件', N'Enterprise', N'SendEmail', N'mng_enterprise_manage', 2, NULL)
--END:增加发送推广邮件功能 tomato 2015-08-24

--BEGIN 新增“订单利润统计”报表 Lopping 2015-09-10
IF NOT EXISTS (SELECT * FROM MngApp WHERE AppCode='erp_orderprofit_report')
INSERT [dbo].[MngApp] ([AppCode], [AppName],[ParentAppCode],[OrderNo], [LevelNo]) VALUES('erp_orderprofit_report','订单利润统计','erp_salereport_manage',5,3);
--END 新增“订单利润统计”报表 Lopping 2015-09-10

--Begin 删除产品模块 财务模块设置 Jockey 2015-10-12
DELETE FROM MngApp WHERE AppCode='erp_product_setting'
DELETE FROM MngApp WHERE AppCode='erp_financial_setting'
GO
--End 删除产品模块 财务模块设置 Jockey 2015-10-12

--Begin 修改菜单排序 Jockey 2015-10-12
UPDATE HgMenu SET OrderNo=40 WHERE MenuCode='mng_manage'
UPDATE MngApp SET OrderNo=5 WHERE AppCode='erp_product'
UPDATE MngApp SET OrderNo=10 WHERE AppCode='erp_sale'
UPDATE MngApp SET OrderNo=20 WHERE AppCode='erp_pur'
UPDATE MngApp SET OrderNo=25 WHERE AppCode='erp_manage'
UPDATE MngApp SET OrderNo=30 WHERE AppCode='erp_salereport'
UPDATE MngApp SET OrderNo=35 WHERE AppCode='hg_framework'
UPDATE MngApp SET OrderNo=40 WHERE AppCode='mng_manage'
GO
--End 修改菜单排序 Jockey 2015-10-12

--Begin 增加客服管理 Jockey 2015-10-12
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_cs')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_cs', N'客服管理', 15, 1, NULL)
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_cs_aliexpress')
	INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_cs_aliexpress', N'速卖通客服', 5, 2, 'erp_cs')
UPDATE MngApp SET ParentAppCode='erp_cs_aliexpress',OrderNo=5 WHERE AppCode='erp_order_sitemessage'
UPDATE MngApp SET ParentAppCode='erp_cs_aliexpress',OrderNo=10 WHERE AppCode='erp_order_issue'
UPDATE MngApp SET AppName='站内信及留言' WHERE AppCode='erp_order_sitemessage'
GO
--End 增加客服管理 Jockey 2015-10-12


--begin:添加催付和评价菜单 bunny 2015-10-19
if not exists(select * from MngApp where AppCode='erp_order_autoevaluation')
BEGIN
INSERT INTO [dbo].[MngApp]([AppCode],[AppName],[ParentAppCode],[OrderNo],[LevelNo])VALUES('erp_order_autoevaluation','自动评价','erp_cs_aliexpress',45,3)
END
GO
if not exists(select * from MngApp where AppCode='erp_order_remindpayment')
BEGIN
INSERT INTO [dbo].[MngApp]([AppCode],[AppName],[ParentAppCode],[OrderNo],[LevelNo])VALUES('erp_order_remindpayment','自动催付','erp_cs_aliexpress',35,3)
END
GO
--end

--Begin：移动客户管理菜单到客服管理 Jockey 2015-10-26
UPDATE MngApp SET ParentAppCode='erp_cs',OrderNo=20 WHERE AppCode='erp_customer'
UPDATE MngApp SET AppName='订单管理' WHERE AppCode='erp_sale'
UPDATE MngApp SET AppName='仓库管理' WHERE AppCode='erp_manage'
UPDATE MngApp SET AppName='统计分析' WHERE AppCode='erp_salereport'
UPDATE MngApp SET AppName='本地产品' WHERE AppCode='erp_product_module'
UPDATE MngApp SET AppName='仓库设置' WHERE AppCode='erp_store_manage'
UPDATE MngApp SET ParentAppCode='erp_express' WHERE AppCode='erp_logistic'
GO
--End：移动客户管理菜单到客服管理 Jockey 2015-10-26

--Begin: Rick 2015-10-26 添加物流跟踪菜单
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode=N'erp_package_track')
 INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_package_track', N'物流追踪', 50, 2, 'erp_sale')
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode=N'erp_package_track_search')
 INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_package_track_search', N'批量查询', 50, 3, 'erp_package_track')
GO
--End: Rick 2015-10-26 添加物流跟踪菜单

--begin 添加采购建议菜单 bunny 2015-10-29
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_pur_advice')
INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_pur_advice', N'采购建议',  5, 3, N'erp_pur_manage')
GO

--BEGIN：添加Ebay客服菜单 Lopping 2015-10-29
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_cs_ebay')
BEGIN
INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_cs_ebay', N'Ebay客服', 10, 2, 'erp_cs')
END
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_ebay_order_sitemessage')
BEGIN
INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_ebay_order_sitemessage', N'站内信', 5, 3, N'erp_cs_ebay')
END
IF NOT EXISTS(SELECT * FROM MngApp WHERE AppCode='erp_ebay_sitemessage')
BEGIN
INSERT [dbo].[MngApp] ([AppCode], [AppName], [OrderNo], [LevelNo], [ParentAppCode]) VALUES (N'erp_ebay_sitemessage', N'Ebay消息', 10, 3, N'erp_cs_ebay')
END