﻿window.track = {
    postUrl: "http://www.17track.net/zh-cn/result/post.shtml",
    trackUrl: "http://www.17track.net/r/handlertrack.ashx",
    enumPackageStauts: [
        { code: 0, enName: "None", name: "查询不到" },
        { code: 10, enName: "Shipment", name: "运输途中" },
        { code: 20, enName: "Warn", name: "运输过久" },
        { code: 30, enName: "NoticeLeft", name: "到达待取" },
        { code: 40, enName: "Delivered", name: "成功签收" },
        { code: 50, enName: "Returned", name: "可能异常" }
    ],
    enumTrackingStatus: [
        { code: -1, enNameb: "NoResult", name: "未返回结果" },
        { code: 0, enNameb: "None", name: "无法跟踪" },
        { code: 1, enName: "Normal", name: "查有信息" },
        { code: 2, enName: "Null", name: "查无信息" },
        { code: 10, enName: "WebError", name: "网络错误" },
        { code: 11, enName: "ProcessError", name: "处理错误" },
        { code: 12, enName: "ServiceError", name: "查询错误" },
        { code: 20, enName: "CacheWebError", name: "网络错误" },
        { code: 21, enName: "CacheProcessError", name: "处理错误" },
        { code: 22, enName: "CacheServiceError", name: "查询错误" }
    ],
    defaultTrackData:{
        "ret": 1,
        "msg": "Ok",
        "dat": {
            "a": "RF104959999CN",
            "b": 301,
            "c": 0,
            "d": 1,
            "e": 0,
            "f": -1,
            "ln1": "zh-CHS",
            "ln2": "",
            "is1": 2,
            "is2": 0,
            "ygt1": 157,
            "ygt2": 0,
            "ylt1": "2079-01-01 00:00:00",
            "ylt2": "2079-01-01 00:00:00",
            "yt": null,
            "z0": null,
            "z1": [],
            "z2": []
        }
    },
    getPackageStauts: function (code) {
        var status = null;
        $.each(track.enumPackageStauts, function (index, item) {
            if (item.code == code) {
                status = item;
                return false;
            }
        });
        return status;
    },
    getlogisticServiceCode: function (logisticCode, serviceName) {
        if (logisticCode == null || typeof (logisticCode) == "undefined")
            logisticCode = "";
        if (serviceName == null || typeof (serviceName) == "undefined")
            serviceName = "";

        var serviceCode = "";
        switch (serviceName.toLowerCase()) {
            //速卖通
            case "cpap":
            case "cpam":
            case "e_ems":
            case "ems":
            case "ems_zx_xz_us":
            case "cpam_hrb":
                serviceCode = "0";
                break;
            case "dhl":
            case "ems_sh_zx_us":
            case "dhl_de":
            case "dhl_es":
            case "dhl_fr":
            case "dhl_it":
            case "dhl_uk":
                serviceCode = "100001";
                break;
            case "fedex_ie":
            case "fedex":
                serviceCode = "100003";
                break;
            case "sf":
                serviceCode = "100012";
                break;
            case "ups":
            case "upse":
            case "ups_us":
                serviceCode = "100002";
                break;
            case "sinotrans_am":
                serviceCode = "190012";
                break;
                //Ebay
            case "fedex2day":
            case "fedexexpresssaver":
            case "fedexhomedelivery":
            case "fedexpriorityovernight":
            case "fedexsmartpost":
            case "fedexstandardovernight":
                serviceCode = "100003";
                break;
            case "ups2ndday":
            case "ups3rdday":
            case "upsground":
            case "upsnextday":
            case "upsnextdayair":
                serviceCode = "100002";
                break;
                //amazon
            case "china post":
                serviceCode = "0";
                break;
                //wish
            case "chinaairpost":
            case "chinapost-wishpost":
                serviceCode = "0";
                break;
        }

        if (serviceCode.length == 0 && logisticCode.length > 0) {
            switch (logisticCode.toLowerCase()) {
                case "sfexpress":
                    serviceCode = "100012";
                    break;
                case "huanhan":
                    serviceCode = "190003";
                    break;
                case "yanwen":
                    serviceCode = "190012";
                    break;
            }
        }
        return serviceCode;
    },
    getTrackingStatus: function (code) {
        var status = null;
        $.each(track.enumTrackingStatus, function (index, item) {
            if (item.code == code) {
                status = item;
                return false;
            }
        });
        return status;
    },
    requestPost: function (trackingNos, callback) {
        //请求总页面
        var url = track.postUrl + "?nums=" + trackingNos;
        $.ajax({
            type: "get",
            dataType: "jsonp",
            global: false,
            url: url,
            complete: function (requestResult, textStatus) {
                if (typeof (callback) == "function") {
                    callback();
                }
            }
        });
    },
    formatDateTime: function (strDate) {
        if (strDate == null || typeof (strDate) != "string" || strDate.length == 0) {
            return "";
        }
        var formatTimeItem = function (num) {
            var str = "00" + num;
            return str.substr(str.length - 2, 2);
        }
        var timeSpan = parseInt(strDate.replace("/Date(", "").replace(")/", ""));
        var dateTime = new Date(timeSpan);
        return dateTime.getFullYear() + "-" + formatTimeItem(dateTime.getMonth() + 1) + "-" + formatTimeItem(dateTime.getDate()) + " " + formatTimeItem(dateTime.getHours()) + ":" + formatTimeItem(dateTime.getMinutes());
    },
    searchTrack: function (trackingItem, callback) {
        //获取请求数据
        var serviceCode = track.getlogisticServiceCode(trackingItem.LogisticCode, trackingItem.ServiceName);
        if (serviceCode == null || serviceCode.length == 0) { //如果未查询到则返回默认值
            var defaultValue = track.defaultTrackData;
            defaultValue.dat.a = trackingItem.LogisticTransitNo;
            if (typeof (callback) == "function") {
                callback(trackingItem, defaultValue);
            }
            return;
        }

        //请求数据
        var postData = { num: trackingItem.LogisticTransitNo, et: serviceCode };

        //发送请求
        $.ajax({
            type: "get",
            dataType: "jsonp",
            global: false,
            url: track.trackUrl,
            crossDomain: !0,
            timeout: 14e4,
            data: postData,
            success: function (data) {
                if (typeof (callback) == "function") {
                    callback(trackingItem, data);
                }
            },
            error: function (e, t, n) {
                if (typeof (callback) == "function") {
                    callback(trackingItem, { ret: -100, msg: "请求出错：" + n });
                }
            }
        });
    },
    renderTrackPostResult: function (packageTrack, trPanel) {
        var packageStatus = track.getPackageStauts(packageTrack.PackageStauts);
        var fromStatus = track.getTrackingStatus(packageTrack.FromStatus);
        var toStatus = track.getTrackingStatus(packageTrack.ToStatus);
        
        var renderItem = function (trackInfo, itemList) {
            var formatTimeItem = function (num) {
                var str = "00" + num;
                return str.substr(str.length - 2, 2);
            }
            var formatDateTime = function (strDate) {
                var timeSpan = parseInt(strDate.replace("/Date(", "").replace(")/", ""));
                var dateTime = new Date(timeSpan);
                return dateTime.getFullYear() + "-" + formatTimeItem(dateTime.getMonth() + 1) + "-" + formatTimeItem(dateTime.getDate()) + " " + formatTimeItem(dateTime.getHours()) + ":" + formatTimeItem(dateTime.getMinutes());
            };
            var text = "<dl>";
            if (trackInfo.hasToResult) {
                var countryLabel = "目标国家";
                if (trackInfo.isFrom)
                    countryLabel = "发件国家";
                text += "<dt>" + countryLabel + "：<a href='javascript:void(0)'>" + trackInfo.countryName + "</a>，" + trackInfo.status.name + "</dt>";
            }
            else {
                text += "<dt>从 <a href='javascript:void(0)'>" + trackInfo.countryName + "</a> 发往 <a href='javascript:void(0)'>" + trackInfo.toCountryName + "</a>，" + trackInfo.status.name + "</dt>";
            }

            var isFirst = true;
            for (var i = itemList.length - 1; i >= 0; i--) {
                if (trackInfo.hasToResult==true) {
                    if (itemList[i].IsFrom != trackInfo.isFrom) {
                        continue;
                    }
                }

                var cl = "";
                if (isFirst) {
                    cl = " class='new'";
                    isFirst = false;
                }

                var arrEvent = [];
                var item = itemList[i];
                var formatTime = formatDateTime(item.TrackTime);
                item.Address1 && arrEvent.push(item.Address1),
                item.Address2 && arrEvent.push(item.Address2),
                item.EventString && arrEvent.push(item.EventString);
                text += '<dd' + cl + '><i></i><time>' + formatTime + '</time> <p>' + arrEvent.join('，') + '</p></dd>';
            }
            text += "</dl>";
            return text;
        };
        trPanel.find("#hidLogisticTransitStatus").val(packageStatus.name);
        var html = "";
        if (packageStatus.code == 0) {
            html = "<div>";
            html += "查询不到当前的物流跟踪号，可能由以下几个原因引起：<br />";
            html += "1、当前物流的服务商不在本系统的支持范围之内；<br />";
            html += "2、当前物流服务商的平台还未录入此信息，请稍后再试；<br />";
            html += "如有需要请与我们的客服人员联系。<br />";
            html += "</div>";
        }
        else {
            var hasToResult = (packageTrack.ToStatus === -1) ? false : true;
            if (hasToResult) {
                var fromTracking = {
                    hasToResult: hasToResult,
                    country: packageTrack.FromCountry,
                    countryName: packageTrack.FromCountryName,
                    status: fromStatus,
                    isFrom: true
                };
                var toTracking = {
                    hasToResult: hasToResult,
                    country: packageTrack.ToCountry,
                    countryName: packageTrack.ToCountryName,
                    status: toStatus,
                    isFrom: false
                };
                html = renderItem(toTracking, packageTrack.ErpPackageTrackItem);
                html += renderItem(fromTracking, packageTrack.ErpPackageTrackItem);
            }
            else {
                var trackData = {
                    hasToResult: hasToResult,
                    country: packageTrack.FromCountry,
                    countryName: packageTrack.FromCountryName,
                    toCountry: packageTrack.ToCountry,
                    toCountryName: packageTrack.ToCountryName,
                    status: fromStatus,
                    isFrom: true
                };
                html = renderItem(trackData, packageTrack.ErpPackageTrackItem);
            }
        }
        return html;
    }
};
