﻿//页面初始化
jQuery(function () {
    redgle.tab.init({ tabPanel: "divTabPanel", contentPanel: "divTabContentPanel" });
    $('.date input').datepicker();
    $("#divChooseItems > span").each(function () {
        if ($(this).attr("itemid") == "OrderNO") {
            $(this).addClass("active");
            var selectedItems = $(this).attr("itemid");
            $("#txtSearchKey").attr({ placeholder: "请输入搜索内容,多个单号请用逗号隔开" });
            $("#hidChoose").val(selectedItems);
        }
        if ($(this).attr("itemid") == "SKU") {
            $(this).addClass("active");
            var selectedItems = $(this).attr("itemid");
            $("#txtSearchKey").attr({ placeholder: "请输入搜索内容" });
            $("#hidChoose").val(selectedItems);
        }
    });
    //获取订单状态
    doLoadOrderMessage();

});
//查询完成后触发
function doCompleteSearchData() {
    doLoadOrderMessage();
}
//高级筛选
function doShowMoreSearchPanel(event) {
    $("#divMoreSearach").toggle("slow");
    var src = event.target || window.event.srcElement;
    if ($(src).attr("class").indexOf("search-down") > 0) {
        $(src).removeClass("search-down").addClass("search-up").text("收起");
    }
    else {
        $(src).removeClass("search-up").addClass("search-down").text("高级筛选");
    }
}

//加载站内信
function doLoadOrderMessage() {
    $("#divOrderDataList a[message]").each(function () {
        var orderId = $(this).attr("message");
        $.ajax({
            type: "POST",
            url: "../Order/OrderMessageNum",
            data: { id: orderId },
            datatype: "json",
            global: false,
            success: function (data) {
                if (!data.HasError) {
                    var sMessage = "";
                    if (data.MapData.newCount > 0) {
                        sMessage = "<span class='label label-danger' style='font-size:13px;' title='有新的站内信（" + data.MapData.newCount + "/" + data.MapData.allCount + "）'>信</span>";
                    }
                    else if (data.MapData.allCount > 0) {
                        sMessage = "<span class='label label-success' style='font-size:13px;' title='包含有站内信（" + data.MapData.allCount + "）'>信</span>";
                    }

                    if (sMessage != "") {
                        $("#divOrderDataList a[message='" + data.MapData.orderId + "']").css("display", "").html(sMessage);
                    }
                }
            },
            error: function () {
                //alert("操作失败！");
            }
        });
    });
}

//下拉框改变获取值（物流方式）
$(function () {
    $('#LogisticMode').bind('change', function () {
        $("#hidLogisticMode").val($('#LogisticMode option:selected').val());
        $("#searchForm").submit();
    })
})

//仓库
$(function () {
    $('#StoreId').bind('change', function () {
        $("#hidStore").val($('#StoreId option:selected').val());
        $("#searchForm").submit();
    })
})
//sku
$("#divSkuItems > span").each(function () {
    $(this).click(function () {
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divSkuItems > span").removeClass("active");
            $(this).addClass("active");
        }
        else {
            $(this).removeClass("active");
        }

        var selectedItems = "";
        $("#divSkuItems > span").each(function () {
            var cls = $(this).attr("class");
            if (typeof (cls) != "undefined" && cls.indexOf("active") >= 0) {
                selectedItems = $(this).attr("itemid");
            }
        });
        $("#hidSkus").val(selectedItems);
        $("#searchForm").submit();
    });
});

//国家
$("#divCountrysItems > span").each(function () {
    $(this).click(function () {
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divCountrysItems > span").removeClass("active");
            $(this).addClass("active");
        }
        else {
            $(this).removeClass("active");
        }

        var selectedItems = "";
        $("#divCountrysItems > span").each(function () {
            var cls = $(this).attr("class");
            if (typeof (cls) != "undefined" && cls.indexOf("active") >= 0) {
                selectedItems = $(this).attr("itemid");
            }
        });
        $("#hidCountrys").val(selectedItems);
        $("#searchForm").submit();
    });
});

//包裹状态
$("#divPackageStatus > span").each(function () {
    $(this).click(function () {
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divPackageStatus > span").removeClass("active");
            $(this).addClass("active");
        }
        else {
            $(this).removeClass("active");
        }

        var selectedItems = "";
        $("#divPackageStatus > span").each(function () {
            var cls = $(this).attr("class");
            if (typeof (cls) != "undefined" && cls.indexOf("active") >= 0) {
                selectedItems = $(this).attr("itemid");
            }
        });
        $("#hidPackageStatus").val(selectedItems);
        $("#searchForm").submit();
    });
});

$("#divDaysItems > span").each(function () {
    $(this).click(function () {
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divDaysItems > span").removeClass("active");
            //清空搜索内容
            $(this).addClass("active");
        }
        else {
            $(this).removeClass("active");
            $("#hidDays").val("");
            $("#hidSearch").val("");
        }
        var selectedItems = $(this).attr("itemvalue");
        var chooseItems = $(this).attr("chooseid");
        //获取
        $("#hidDays").val(selectedItems);
        $("#hidSearch").val(chooseItems)
    });
});

//选择平台账号
$("#divUserFormAndApiUserItems > span").each(function () {
    $(this).click(function () {
        var selectedItem = "";
        var apiuserid = "";
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divUserFormAndApiUserItems > span").removeClass("active");
            $(this).addClass("active");
            selectedItem = $(this).attr("userform")
            apiuserid = $(this).attr("apiuserid");
        }
        else {
            $(this).removeClass("active");
            $("#divUserFormAndApiUserItems > span").removeClass("active");
        }
        $("#hidUserForms").val(selectedItem);
        $("#hidApiAccountItems").val(apiuserid);
        $("#searchForm").submit();
    });
});
$("#divChooseItems > span").each(function () {
    $(this).click(function () {
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divChooseItems > span").removeClass("active");
            //清空搜索内容
            $("#txtSearchKey").val("");
            if ($("#txtDateBegin").length > 0)
                $("#txtDateBegin").val("");
            if ($("#txtDateEnd").length > 0)
                $("#txtDateEnd").val("");
            $(this).addClass("active");

        }
        else {
            $(this).removeClass("active");
        }
        var selectedItems = $(this).attr("itemid");
        var chooseItems = $(this).attr("chooseid")
        if (chooseItems == "Date") {
            $("#Date").css("display", "");
            $("#Search").css("display", "none");
        } else if (chooseItems == "Search") {
            $("#Date").css("display", "none");
            $("#Search").css("display", "");
        }
        //获取
        $("#txtSearchKey").attr({ placeholder: $(this).attr("name") });
        $("#hidChoose").val(selectedItems);
    });
});
//有留言备注
$("#divRemarksAndMessageItems > span").each(function () {
    $(this).click(function () {
        var selectedItems = "";
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divRemarksAndMessageItems > span").removeClass("active");
            $(this).addClass("active");
            selectedItems=$(this).attr("itemid");
        }
        else {
            $(this).removeClass("active");
        }
        $("#hidRemarksAndMessage").val(selectedItems);
        $("#searchForm").submit();
    });
});
//可合并
$("#divCanMergeItems > span").each(function () {
    $(this).click(function () {
        var selectedItems = "";
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divCanMergeItems > span").removeClass("active");
            $(this).addClass("active");
            selectedItems = $(this).attr("itemid");
        }
        else {
            $(this).removeClass("active");
        }
        $("#hidCanMerge").val(selectedItems);
        $("#searchForm").submit();
    });
});
//收货信息不全
$("#divAddressErrorItems > span").each(function () {
    $(this).click(function () {
        var selectedItems = "";
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divAddressErrorItems > span").removeClass("active");
            $(this).addClass("active");
            selectedItems = $(this).attr("itemid");
        }
        else {
            $(this).removeClass("active");
        }
        $("#hidAddressError").val(selectedItems);
        $("#searchForm").submit();
    });
});
//未关联本地产品
$("#divNotRelationProductItems > span").each(function () {
    $(this).click(function () {
        var selectedItems = "";
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divNotRelationProductItems > span").removeClass("active");
            $(this).addClass("active");
            selectedItems = $(this).attr("itemid");
        }
        else {
            $(this).removeClass("active");
        }
        $("#hidNotRelationProduct").val(selectedItems);
        $("#searchForm").submit();
    });
});
//未配货
$("#divAccordingStateItems > span").each(function () {
    $(this).click(function () {
        var selectedItems = "";
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divAccordingStateItems > span").removeClass("active");
            $(this).addClass("active");
            selectedItems = $(this).attr("itemid");
        }
        else {
            $(this).removeClass("active");
        }
        $("#hidAccordingState").val(selectedItems);
        $("#searchForm").submit();
    });
});
$("#divOrderStatusItems > span").each(function () {
    $(this).click(function () {
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divOrderStatusItems > span").removeClass("active");
            $(this).addClass("active");
        }
        else {
            $(this).removeClass("active");
        }

        var selectedItems = "";
        $("#divOrderStatusItems > span").each(function () {
            var tt = $(this).attr("class");
            if (typeof (tt) != "undefined" && tt.indexOf("active") >= 0) {
                selectedItems += $(this).attr("itemid") + ",";
            }
        });
        if (selectedItems.length > 0) {
            selectedItems = selectedItems.substr(0, selectedItems.length - 1);
        }
        $("#hidOrderStatusCodes").val(selectedItems);
        $("#searchForm").submit();
    });
});
$("#divPaymentStatusItems > span").each(function () {
    $(this).click(function () {
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divPaymentStatusItems > span").removeClass("active");
            $(this).addClass("active");
        }
        else {
            $(this).removeClass("active");
        }

        var selectedItems = "";
        $("#divPaymentStatusItems > span").each(function () {
            var tt = $(this).attr("class");
            if (typeof (tt) != "undefined" && tt.indexOf("active") >= 0) {
                selectedItems += $(this).attr("itemid") + ",";
            }
        });
        if (selectedItems.length > 0) {
            selectedItems = selectedItems.substr(0, selectedItems.length - 1);
        }
        $("#hidPaymentCodes").val(selectedItems);
        $("#searchForm").submit();
    });
});
$("#divIsPrint > span").each(function () {
    $(this).click(function () {
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divIsPrint > span").removeClass("active");
            $(this).addClass("active");
        }
        else {
            $(this).removeClass("active");
        }

        var selectedItems = "";
        $("#divIsPrint > span").each(function () {
            var tt = $(this).attr("class");
            if (typeof (tt) != "undefined" && tt.indexOf("active") >= 0) {
                selectedItems += $(this).attr("itemid") + ",";
            }
        });
        if (selectedItems.length > 0) {
            selectedItems = selectedItems.substr(0, selectedItems.length - 1);
        }
        $("#hidIsPrint").val(selectedItems);
        $("#searchForm").submit();
    });
});
$("#divIsPrintDeclare > span").each(function () {
    $(this).click(function () {
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divIsPrintDeclare > span").removeClass("active");
            $(this).addClass("active");
        }
        else {
            $(this).removeClass("active");
        }

        var selectedItems = "";
        $("#divIsPrintDeclare > span").each(function () {
            var tt = $(this).attr("class");
            if (typeof (tt) != "undefined" && tt.indexOf("active") >= 0) {
                selectedItems += $(this).attr("itemid") + ",";
            }
        });
        if (selectedItems.length > 0) {
            selectedItems = selectedItems.substr(0, selectedItems.length - 1);
        }
        $("#hidIsPrintDeclare").val(selectedItems);
        $("#searchForm").submit();
    });
});
//选择标记
$("#divMark > span").each(function () {
    $(this).click(function () {
        var selectedItems = "";
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divMark > span").removeClass("active");
            $(this).addClass("active");
            selectedItems = $(this).attr("itemid");
        }
        else {
            $(this).removeClass("active");
        }
        $("#hidMark").val(selectedItems);
        $("#searchForm").submit();
    });
});
//系统标记
$("#divSystemMark > span").each(function () {
    $(this).click(function () {
        var selectedItems = "";
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divSystemMark > span").removeClass("active");
            $(this).addClass("active");
            selectedItems = $(this).attr("itemid");
        }
        else {
            $(this).removeClass("active");
        }
        $("#hidSystemMark").val(selectedItems);
        $("#searchForm").submit();
    });
});
//选择排序
$("#divSort > span").each(function () {
    $(this).click(function () {
        var selectedItems = "";
        var sortType = "";
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divSort > span").removeClass("active");
            $("#divSort > span").attr("sorttype", "");
            $(this).addClass("active");
            $("#divSort > span > span").removeClass().addClass("glyphicon glyphicon-resize-vertical");
        }
        selectedItems = $(this).attr("itemid");
        sortType = $(this).attr("sorttype");
        if (sortType == "" || sortType == "DESC") {
            $(this).attr("sorttype", "ASC");
            $("#hidSortType").val("ASC");
            $("#" + selectedItems + "SortMark").removeClass().addClass("glyphicon glyphicon-arrow-up");
        }
        else {
            $(this).attr("sorttype", "DESC");
            $("#hidSortType").val("DESC");
            $("#" + selectedItems + "SortMark").removeClass().addClass("glyphicon glyphicon-arrow-down");
        }
        $("#hidSort").val(selectedItems);
        $("#searchForm").submit();
    });
});

//复选框
function doSetCheckBox(obj) {
    $("input[name=chk_list]").prop("checked", $(obj).prop("checked"));
}
//获取选中的订单Id
function doGetSelectedOrderIds() {
    var orderList = new Array();
    $('input[name="chk_list"]:checked').each(function () {
        var order = {
            OrderId: $(this).val(),
            OrderNo: $(this).parent().find("#item_OrderNo").val(),
            OrderColumn8: $(this).parent().parent().find("#hidOrderColumn8").val(),
            RelationType: $(this).parent().parent().find("#hidRelationType").val()
        };
        orderList.push(order);
    });
    return orderList;
}
//检测删除订单，订单删除必须经过该步
function doCheckDeleteOrder(pageKey, id) {
    var batchDeleteOrderIds = "";
    var hasAlert = false;
    var alertMessage = "";
    if (id != undefined && id != "")
        batchDeleteOrderIds = id;
    else {
        $('input[name="chk_list"]:checked').each(function () {
            batchDeleteOrderIds += $(this).val() + ",";
            var orderNo = $(this).attr("orderno");
            var orderMark = $(this).attr("ordermark");
            if (orderMark == "CombinPackage") {
                hasAlert = true;
                alertMessage += "订单：" + orderNo + "为合并包裹<br/>";
            }
            if (orderMark == "SplitPackage") {
                hasAlert = true;
                alertMessage += "订单：" + orderNo + "为拆分包裹<br/>";
            }
        });
    }
    if (batchDeleteOrderIds.length == 0) {
        redgle.showMessage("请选择需要删除的订单！");
        return;
    }
    if (hasAlert == true) {
        redgle.showConfirm(alertMessage + "您确认要删除吗？", "doDeleteOrder('" + pageKey + "','" + batchDeleteOrderIds + "')");
    } else {
        redgle.showConfirm("您确认要删除吗？", "doDeleteOrder('" + pageKey + "','" + batchDeleteOrderIds + "')");
    }
}
//删除订单信息
function doDeleteOrder(pageKey, orderIds) {
    $.ajax({
        type: "POST",
        url: "../Order/DeleteOrder",
        datatype: "json",
        data: { orderIds: orderIds },
        success: function (data) {
            if (data.HasError) {
                alert("删除失败:" + data.Message);
            } else {
                redgle.showMessage("删除订单成功！");
                eval(pageKey + "doReloadData()");//刷新页面
            }
        },
        error: function () {
            alert("操作失败！");
        }
    });
}
//订单重审
function drReturnOrderApprove(pageKey) {
    var orderList = doGetSelectedOrderIds();
    if (orderList.length == 0) {
        redgle.showMessage("请至少选择一个订单！");
        return;
    }
    orderList = JSON.stringify(orderList);
    $.ajax({
        type: "POST",
        url: "../Order/ReturnOrderApprove",
        data: { orderList: orderList },
        datatype: "json",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            } else {
                if (data.MapData.ReturnNum > 0) {
                    if (data.MapData.ReturnNum == data.MapData.OrderNum)
                        redgle.showConfirm(data.Message + "<br />订单重审成功，是否转向待处理？<br />", "doGotoOrderApprove()", "");
                    else
                        redgle.showConfirm(data.Message + "<br />部分订单重审成功，是否转向待处理？<br />", "doGotoOrderApprove()", "");
                } else {
                    redgle.showConfirm(data.Message);
                }
                try {
                    eval(pageKey + "doReloadData()");//刷新页面
                } catch (e) { redgle.showMessage("重新加载数据失败！"); }
            }
        },
        error: function () {
            redgle.showMessage("订单重审失败！");
        }
    });
}
//虚拟发货
function doVirtualDeliver(pageKey) {
    var orderIds = "";
    var error = false;
    var orderList = doGetSelectedOrderIds();
    if (orderList.length == 0) {
        redgle.showMessage("请至少选择一个订单！");
        return;
    }

    var orderList = JSON.stringify(orderList);
    $.ajax({
        type: "POST",
        url: "../Order/VirtualDeliver",
        data: { orderList: orderList },
        datatype: "json",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            }
            else {
                redgle.showMessage("虚拟发货成功！<br/>" + data.Message);
                try {
                    eval(pageKey + "doReloadData()");//刷新页面
                } catch (e) { redgle.showMessage("重新加载数据失败！"); }
            }
        },
        error: function () {
            redgle.showMessage("虚拟发货失败！");
        }
    });
}
//标记发货
function doActualDeliver(pageKey) {
    var orderIds = "";
    var error = false;
    var orderList = doGetSelectedOrderIds();
    if (orderList.length == 0) {
        redgle.showMessage("请至少选择一个订单！", "错误提示");
        return;
    }
    var orderList = JSON.stringify(orderList);
    $.ajax({
        type: "POST",
        url: "../Order/ActualDeliver",
        data: { orderList: orderList },
        datatype: "json",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            }
            else {
                redgle.showMessage("发货成功！<br/>" + data.Message);
                try {
                    eval(pageKey + "doReloadData()");//刷新页面
                } catch (e) { redgle.showMessage("重新加载数据失败！"); }
            }
        },
        error: function () {
            redgle.showMessage("发货失败！", "错误提示");
        }
    });
}
//释放库存
function doClearAllocation(pageKey) {
    var orderIds = "";
    var orderList = doGetSelectedOrderIds();
    if (orderList.length == 0) {
        redgle.showMessage("请至少选择一个订单！");
        return;
    }
    var orderList = JSON.stringify(orderList);
    $.ajax({
        type: "POST",
        url: "../Order/ClearAllocation",
        data: { orderList: orderList },
        datatype: "json",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            }
            else {
                redgle.showMessage("释放库存成功！<br/>" + data.Message);
                try {
                    eval(pageKey + "doReloadData()");//刷新页面
                } catch (e) { redgle.showMessage("重新加载数据失败！"); }
            }
        },
        error: function () {
            redgle.showMessage("释放库存失败！");
        }
    });
}
//跳转到站内信或订单留言
function doJumpOrderMessagePanel() {
    if ($("#ulOrderMessageTabTitle").length > 0) {
        document.getElementById('ulOrderMessageTabTitle').scrollIntoView(true);
    }
}
function doJumpSiteMessagePanel() {
    if ($("#ulOrderMessageTabTitle").length > 0) {
        $("#ulOrderMessageTabTitle > li").removeClass("active").eq(1).addClass("active");
        $("#divOrderMessageTabContent >div").css("display", "none").eq(1).css("display", "");
        document.getElementById('ulOrderMessageTabTitle').scrollIntoView(true);
    }
}
function doJumpOrderMemoPanel() {
    var tabliLength=$("#ulOrderMessageTabTitle > li").length;
    if (tabliLength > 0) {
        if (tabliLength == 1) {
            //是线下订单，线下订单只有一个tab标签
            $("#ulOrderMessageTabTitle > li").eq(0).addClass("active");
            $("#divOrderMessageTabContent > div").eq(0).css("display", "");
            document.getElementById('ulOrderMessageTabTitle').scrollIntoView(true);
        }
        else {
            $("#ulOrderMessageTabTitle > li").removeClass("active").eq(2).addClass("active");
            $("#divOrderMessageTabContent > div").css("display", "none").eq(2).css("display", "");
            document.getElementById('ulOrderMessageTabTitle').scrollIntoView(true);
        }
    }
}
//编辑订单
function doEditOrderData(id) {
    var title = "编辑订单";
    var url = "../Order/Edit/" + id;
    redgle.tab.create("liOrderDetail", url, title);
}
//显示线上订单详情
function doViewOnlineOrder(orderId) {
    var url = "../Order/ViewOnlineOrder/" + orderId;
    redgle.tab.create("liOrderDetail", url, "详情");
}

//显示线下订单详情
function doViewOfflineOrder(orderId) {
    var url = "../Order/OrderDetails/" + orderId;
    redgle.tab.create("liOrderDetail", url, "详情");
}
//转向待发货
function doGotoOrderPrint() {
    window.location.href = "../Order/OrderPrint";
}
//转向待处理
function doGotoOrderApprove() {
    window.location.href = "../Order/OrderApprove";
}
function doEditProductData(id) {
    if (id == null || id == "")
        id = "";
    var url = "../Product/Edit/" + id;
    redgle.tab.create("liProductEdit", url, "产品编辑");
}
function doViewOrderMessage(orderId) {
    var url = "../Order/ViewOnlineOrder/" + orderId;
    redgle.tab.create("liOrderDetail", url, "详情", null, doJumpOrderMessagePanel);
}
function doViewSiteMessage(orderId) {
    var url = "../Order/ViewOnlineOrder/" + orderId;
    redgle.tab.create("liOrderDetail", url, "详情", null, doJumpSiteMessagePanel);
}
function doViewOrderMemo(orderId) {
    var url = "../Order/ViewOnlineOrder/" + orderId;
    redgle.tab.create("liOrderDetail", url, "详情", null, doJumpOrderMemoPanel);
}
//关闭模态窗口
function doCloseModal() {
    try {
        var divModal = $("div[id^='divModalPanel']");
        divModal.each(function () {
            redgle.modal.closeModal($(this).attr("id"));
        });
    }
    catch (e)
    { }
}
//回车搜索
$("#txtSearchKey").keyup(function () {
    var searchkey = $("#txtSearchKey").val();
    var oldValue = searchkey;
    while (oldValue.indexOf("，") != -1)//寻找每一个中文逗号，并替换
    {
        searchkey = oldValue.replace("，", ",");
        oldValue = searchkey;
    }
    $("#txtSearchKey").val(oldValue);
});
var selectLogisticModeStoreModal;
var batchEditOrderIds = "";
var orderPageKey = "";
//选择物流方式
function doSelectLogisticModeStore(pageKey, orderId, storeId, logisticModeId, callbackScript) {
    orderPageKey = pageKey;
    batchEditOrderIds = "";
    if (orderId != undefined && orderId != "")
        batchEditOrderIds = orderId;
    else {
        $('input[name="chk_list"]:checked').each(function () {
            batchEditOrderIds += $(this).val() + ",";
        });
        orderId = 0;
    }
    if (storeId == undefined && storeId == "")
        storeId = 0;
    if (logisticModeId == undefined && logisticModeId == "")
        logisticModeId = 0;
    if (batchEditOrderIds.length == 0) {
        redgle.showMessage("请至少选择一个订单！");
        return;
    }
    if (callbackScript == undefined) {
        callbackScript = "";
    }
    var url = "../LogisticMode/SelectLogisticModeStore?storeId=" + storeId + "&logisticModeId=" + logisticModeId + "&callbackScript=" + callbackScript + "&orderId=" + orderId;
    selectLogisticModeStoreModal = new redgle.modal({ type: "iframe", content: url, title: "分配物流方式", width: 550, height: 250 });
    selectLogisticModeStoreModal.show();
}
//接收返回的物流方式
function doLogisticModeStoreSelected(storeId, logisticModeId, stroreName, logisticAndModeName, LogisticColumn1, LogisticColumn2, LogisticColumn3, PackageLength, PackageWidth, PackageHeight, DomesticLogisticsCompany, DomesticLogisticsCompanyId, DomesticTrackingNo) {
    selectLogisticModeStoreModal.close();
    $.ajax({
        type: "POST",
        url: "../Order/BatchEditLogistic",
        data: { orderIds: batchEditOrderIds, storeId: storeId, logisticModeId: logisticModeId, LogisticColumn1: LogisticColumn1, LogisticColumn2: LogisticColumn2, LogisticColumn3: LogisticColumn3, PackageLength: PackageLength, PackageWidth: PackageWidth, PackageHeight: PackageHeight, DomesticLogisticsCompany: DomesticLogisticsCompany, DomesticLogisticsCompanyId: DomesticLogisticsCompanyId, DomesticTrackingNo: DomesticTrackingNo },
        datatype: "json",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            }
            else {
                doCloseModal();
                redgle.showMessage("分配物流方式成功！");
                eval(orderPageKey + "doReloadData()");
            }
        },
        error: function () {
            redgle.showMessage("分配物流方式失败！");
        }
    });
}

//批量修改报关信息
function doBatchEditDeclare(parentPageKey, orderId) {
    batchEditOrderIds = "";
    if (orderId != undefined && orderId != "")
        batchEditOrderIds = orderId;
    else {
        $('input[name="chk_list"]:checked').each(function () {
            batchEditOrderIds += $(this).val() + ",";
        });
    }
    if (batchEditOrderIds.length == 0) {
        redgle.showMessage("请至少选择一个订单！");
        return;
    }
    var url = "../Order/BatchEditDeclare?parentPageKey=" + parentPageKey;
    var selectOrderModal = new redgle.modal({ type: "iframe", content: url, title: "修改报关信息" });
    selectOrderModal.show();
}

//打印地址标签
function doPrintView(parentPageKey) {
    var orderIds = "";
    var error = false;
    $('input[name="chk_list"]:checked').each(function () {
        if (orderIds == "")
            orderIds = $(this).val();
        else
            orderIds += "," + $(this).val();
    });
    if (orderIds.length == 0) {
        redgle.showMessage("请至少选择一个订单！");
        return;
    }
    $("#btnOpenWindow").attr("href", "../Order/PrintView?orderIds=" + orderIds);
    document.getElementById("btnOpenWindow").click();
}

//打印商业发票
function doPrintInvoice(parentPageKey) {
    var orderIds = "";
    $('input[name="chk_list"]:checked').each(function () {
        orderIds += $(this).val() + ",";
    });
    if (orderIds.length == 0) {
        redgle.showMessage("请至少选择一个订单！");
        return;
    }
    $.ajax({
        type: "POST",
        url: "../Order/PrintInvoice",
        data: { orderIds: orderIds},
        datatype: "text",
        success: function (data) {
            if (!data.HasError) {
                $("#btnOpenWindow").attr("href", "../Order/ViewPdf?fileName=" + escape(data.ResultObject));
                document.getElementById("btnOpenWindow").click();
                eval(parentPageKey + "doReloadData()");
            }
            else {
                redgle.showMessage("打印出错:" + data.Message);
            }
        },
        error: function () {
            redgle.showMessage("打印出错.");
        }
    });
}


//打印拣货单
function doPrintPicking(parentPageKey, option) {
    var orderIds = "";
    $('input[name="chk_list"]:checked').each(function () {
        orderIds += $(this).val() + ",";
    });
    if (orderIds.length == 0) {
        redgle.showMessage("请至少选择一个订单！");
        return;
    }
    $.ajax({
        type: "POST",
        url: "../Order/PrintPicking",
        data: { orderIds: orderIds, option: option },
        datatype: "text",
        success: function (data) {
            if (!data.HasError) {
                $("#btnOpenWindow").attr("href", "../Order/ViewPdf?fileName=" + escape(data.ResultObject));
                document.getElementById("btnOpenWindow").click();
                eval(parentPageKey + "doReloadData()");
            }
            else {
                redgle.showMessage("打印拣货单出错:" + data.Message);
            }
        },
        error: function () {
            redgle.showMessage("打印拣货单出错.");
        }
    });
}
//合并订单
function doMergeOrder(parentPageKey) {
    var mergeOrderIdAndNos = "";//存放订单ID和订单编号
    var mergeIds = "";
    $('input[name="chk_list"]:checked').each(function () {
        mergeIds += $(this).val() + ",";
        mergeOrderIdAndNos += $(this).val() + "," + $(this).attr("orderNo") + "|";
    });
    mergeIds = mergeIds.substring(0, mergeIds.lastIndexOf(','));
    mergeOrderIdAndNos = mergeOrderIdAndNos.substring(0, mergeOrderIdAndNos.lastIndexOf('|'));
    var arrMerageOrderIdAndNos = mergeOrderIdAndNos.split('|');
    if (arrMerageOrderIdAndNos.length <= 1) {
        redgle.showMessage("请至少选择两个订单！");
        return;
    }
    var html = "";
    html += '<div class="form-horizontal">';
    html += '<div class="form-group"><div class="col-sm-2"></div><div class="col-sm-10"><label title="以该订单基本信息为准产生新订单">请选择主订单</label></div></div>';
    for (var i = 0; i < arrMerageOrderIdAndNos.length; i++) {
        var arrIdAndNo = arrMerageOrderIdAndNos[i].split(',');
        html += '<div class="form-group">';
        html += '    <div class="col-sm-2"></div>';
        html += '    <div class="col-sm-10">';
        if (i == 0)
            html += '<input name="OrderNoGroup" id="' + arrIdAndNo[0] + '" value="' + arrIdAndNo[0] + '" checked="checked" style="cursor:pointer" type="radio"><label for="' + arrIdAndNo[0] + '" style="cursor:pointer">' + arrIdAndNo[1] + '</label>';
        else
            html += '<input name="OrderNoGroup" id="' + arrIdAndNo[0] + '" value="' + arrIdAndNo[0] + '" style="cursor:pointer" type="radio"><label for="' + arrIdAndNo[0] + '" style="cursor:pointer">' + arrIdAndNo[1] + '</label>';
        html += '    </div>';
        html += '</div>';
    }
    html += '<div class="form-group">';
    html += '    <div class="col-sm-2"></div>';
    html += '    <div class="col-sm-10"><button class="btn btn-primary btn-sm" onclick="doSaveMergeOrder(\'' + parentPageKey + '\',\'' + mergeIds + '\')">确定</button>&nbsp;<button class="btn btn-default" onclick="doCloseModal()">取消</button></div>';
    html += '</div>';
    html += '</div>';
    var selectOrderModal = new redgle.modal({ type: "html", content: html, title: "合并订单", height: 230, width: 400 });
    selectOrderModal.show();
}
//保存合并的订单
function doSaveMergeOrder(parentPageKey, batchMergeOrderIds) {
    doCloseModal();
    var checkedOrderId = $("input[name='OrderNoGroup']:checked").val();
    $.ajax({
        type: "POST",
        url: "../Order/MergeOrder",
        data: { orderIds: batchMergeOrderIds, mainOrderId: checkedOrderId },
        datatype: "text",
        success: function (data) {
            if (!data.HasError) {
                eval(parentPageKey + "doReloadData()");
                redgle.showMessage("订单合并成功！");
            }
            else {
                redgle.showMessage(data.Message);
            }
        },
        error: function () {
            redgle.showMessage("合并订单出错.");
        }
    });
}

//撤销合并订单确认提示框
function doShowConfirmCancelMergeOrder(parentPageKey, orderId) {
    redgle.showConfirm("您确认要撤销合并的包裹吗？", "doCancelMergeOrder('" + parentPageKey + "','" + orderId + "')");
}

//撤销合并订单
function doCancelMergeOrder(parentPageKey, orderId) {
    $.ajax({
        type: "POST",
        url: "../Order/CancelMergeOrder",
        data: { orderId: orderId },
        datatype: "text",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            }
            else {
                eval(parentPageKey + "doReloadData()");
                redgle.showMessage("订单撤销合并成功！");
            }
        },
        error: function () {
            redgle.showMessage("订单撤销合并失败！");
        }
    });
}

//拆分订单弹出的确认界面
function doSplitOrder(parentPageKey) {
    var orderIds = "";
    $('input[name="chk_list"]:checked').each(function () {
        orderIds += $(this).val() + ",";
    });
    if (orderIds.length == 0) {
        redgle.showMessage("请至少选择一个订单！");
        return;
    }
    orderIds = orderIds.substring(0, orderIds.lastIndexOf(','));
    var arrOrderId = orderIds.split(',');
    if (arrOrderId.length > 1) {
        redgle.showMessage("只能选择一个订单进行操作！");
        return;
    }
    $.ajax({
        type: "POST",
        url: "../Order/GetOrderDetailForSplit",
        data: { orderId: orderIds },
        datatype: "json",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            }
            else {
                var contentHtml = "";
                contentHtml += '<table class="table table-bordered" style="width:780px">';
                contentHtml += '   <thead>';
                contentHtml += '       <tr>';
                contentHtml += '           <th><button type="button" id="btnAddCustomer" style="float:left;" class="btn btn-info btn-xs" onclick="doAddNewOrderForSplit()"><i class="glyphicon glyphicon-plus"></i> 创建订单</button>商品列表</th>';
                contentHtml += '           <th>订单列表<button type="button" id="btnAddCustomer" style="float:right;" class="btn btn-info btn-xs" onclick="doSubmitSplitOrder(\'' + parentPageKey + '\')"><i class="glyphicon glyphicon-floppy-save"></i> 提交</button></th>';
                contentHtml += '       </tr>';
                contentHtml += '   </thead>';
                contentHtml += '   <tr>';
                contentHtml += '       <td style="width:350px">';
                contentHtml += '           <table id="tbProductForSplitOrder" class="table-hover" style="width:350px">';
                contentHtml += '               <tbody>';
                //循环产品
                $(data.ResultObject).each(function (i, orderDetail) {
                    contentHtml += '                   <tr style="cursor:pointer">';
                    contentHtml += '                       <td style="width:40px;"><input type="checkbox" name="chk_list" orderid="' + orderDetail.OrderId + '" value="' + orderDetail.OrderDetailId + '"></td>';
                    contentHtml += '                       <td style="width:60px;">';
                    contentHtml += '                           <img class="img-thumbnail" style="width:50px; height:50px;" src="' + orderDetail.ProductPictureUrl + '">';
                    contentHtml += '                       </td>';
                    contentHtml += '                       <td style="text-align:left !important;word-wrap:break-word;word-break:break-all;width:250px;vertical-align:middle !important">';
                    contentHtml += '                           <a href="javascript:void(0)" class="text-overflow" style="max-width:240px;" title="' + orderDetail.ProductName + '">' + orderDetail.ProductName + '</a>';
                    contentHtml += '                           <br /><span id="spProductSku">' + orderDetail.Sku + '</span> / ' + orderDetail.DeclareWeight + 'kg';
                    contentHtml += '                        </td>';
                    contentHtml += '                    </tr>';
                });
                contentHtml += '                </tbody>';
                contentHtml += '            </table>';
                contentHtml += '        </td>';
                contentHtml += '        <td style="width:430px;vertical-align:top !important" id="tdForNewOrder"></td>';
                contentHtml += '    </tr>';
                contentHtml += '</table>';

                var selectOrderModal = new redgle.modal({ type: "html", content: contentHtml, title: "拆分订单&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;提示：选择左侧商品后，点击[创建订单]按钮产生新订单", height: 260, width: 800 });
                selectOrderModal.show();
                //给商品列表中的行绑定单击事件方便选中
                $("#tbProductForSplitOrder tr").slice(0).each(function () {
                    var p = this;
                    $(this).children().slice(1).click(function () {

                        $($(p).children()[0]).children().each(function () {
                            if (this.type == "checkbox") {
                                if ($(this).attr("disabled") != "disabled") {
                                    if (!this.checked) {
                                        this.checked = true;
                                    } else {
                                        this.checked = false;
                                    }
                                }
                            }
                        });
                    });
                });
            }
        },
        error: function () {
            redgle.showMessage("拆分订单出错！");
        }
    });
}

//拆分订单确认界面中“创建订单”
function doAddNewOrderForSplit() {
    var selectedId = "";
    var contentHtml = '<div class="alert alert-success" role="alert" style="padding:5px;margin-bottom:10px"><table style="width:390px">';
    var trHasHtml = false;
    $("#tbProductForSplitOrder input[name='chk_list']:checked").each(function () {
        if ($(this).attr("disabled") != "disabled") {
            $(this).attr("disabled", "disabled");
            var thisTrHtml = $(this).parent().parent().html();
            if (thisTrHtml != "")
                trHasHtml = true;
            contentHtml += '<tr>' + thisTrHtml + '</tr>';
        }
    });
    if (trHasHtml == true) {
        contentHtml += '</table></div>';
        $("#tdForNewOrder").append(contentHtml);
    }
}
//拆分订单确认界面中“提交”
function doSubmitSplitOrder(parentPageKey) {
    var hasError = false;
    $("#tbProductForSplitOrder input[name='chk_list']").each(function () {
        if ($(this).attr("disabled") != "disabled") {
            hasError = true;
            alert("请分配完商品在提交！");
            return false;
        }
    });
    if (hasError == true)
        return;

    var arrGroupList = new Array();
    var orderId = "";
    //按产生的新订单分组循环取数据 一个<div class="alert alert-success">标签为一组
    $("#tdForNewOrder .alert-success").each(function () {
        var groupOrderDetailIds = "";
        //循环当前分组中所有订单明细ID
        $(this).find("input[name='chk_list']").each(function () {
            groupOrderDetailIds += $(this).val() + ',';
            orderId = $(this).attr("orderid");
        })
        var group = { groupOrderDetailIds: groupOrderDetailIds }
        arrGroupList.push(group);
    });
    if (arrGroupList.length == 1) {
        alert("订单拆分有误！");
        return;
    }
    var jsonGroupOrder = JSON.stringify(arrGroupList);
    $.ajax({
        type: "POST",
        url: "../Order/SubmitSplitOrder",
        data: { orderId: orderId, groupOrderList: jsonGroupOrder },
        datatype: "text",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            }
            else {
                doCloseModal();
                eval(parentPageKey + "doReloadData()");
                redgle.showMessage("订单拆分成功！");
            }
        },
        error: function () {
            redgle.showMessage("订单拆分失败！");
        }
    });
}
//订单作废确认提示框
function doShowConfirmAbandonedOrder(parentPageKey) {
    var orderIds = "";
    $('input[name="chk_list"]:checked').each(function () {
        orderIds += $(this).val() + ",";
    });
    if (orderIds.length == 0) {
        redgle.showMessage("请至少选择一个订单！");
        return;
    }
    //redgle.showConfirm("您确定要作废订单吗？", "doAbandonedOrder('" + parentPageKey + "','" + orderIds + "')");
    redgle.showRemarkConfirm("您确定要作废订单吗？", "doAbandonedOrder('" + parentPageKey + "','" + orderIds + "')");
}
//订单作废
function doAbandonedOrder(parentPageKey, orderIds) {
    $.ajax({
        type: "POST",
        url: "../Order/AbandonedOrder",
        data: { orderIds: orderIds, remark: $("#remarkText").val() },
        datatype: "text",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            }
            else {
                eval(parentPageKey + "doReloadData()");
                redgle.showMessage("订单作废操作成功！" + (data.Message != null ? data.Message : ""));
            }
        },
        error: function () {
            redgle.showMessage("订单作废操作失败！");
        }
    });
}
//订单撤消拆分
function doCancelSplitOrder(parentPageKey, orderId) {
    $.ajax({
        type: "POST",
        url: "../Order/CancelSplitOrder",
        data: { orderId: orderId },
        datatype: "text",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            }
            else {
                eval(parentPageKey + "doReloadData()");
                redgle.showMessage("订单撤销拆分成功！");
            }
        },
        error: function () {
            redgle.showMessage("订单撤销拆分失败！");
        }
    });
}
//撤销拆分订单确认提示框
function doShowConfirmCancelSplitOrder(parentPageKey, orderId) {
    redgle.showConfirm("您确认要撤销拆分的包裹吗？", "doCancelSplitOrder('" + parentPageKey + "','" + orderId + "')");
}

//撤销拆分订单
function doCancelSplitOrder(parentPageKey, orderId) {
    $.ajax({
        type: "POST",
        url: "../Order/CancelSplitOrder",
        data: { orderId: orderId },
        datatype: "text",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            }
            else {
                eval(parentPageKey + "doReloadData()");
                redgle.showMessage("订单撤销拆分成功！");
            }
        },
        error: function () {
            redgle.showMessage("订单撤销拆分失败！");
        }
    });
}
//还原订单提示框
function doShowConfirmCancelAbandonedOrder(parentPageKey, orderId, orderMark) {
    redgle.showConfirm("还原之后订单将进入[待处理]中<br/>确定还原吗？", "doCancelAbandonedOrder('" + parentPageKey + "','" + orderId + "','" + orderMark + "')");
}
//还原订单
function doCancelAbandonedOrder(parentPageKey, orderId, orderMark) {
    $.ajax({
        type: "POST",
        url: "../Order/CancelAbandonedOrder",
        data: { orderId: orderId, orderMark: orderMark },
        datatype: "text",
        success: function (data) {
            if (data.HasError) {
                redgle.showMessage(data.Message);
            }
            else {
                eval(parentPageKey + "doReloadData()");
                redgle.showConfirm("还原成功！<br />您提交的订单已还原成功，是否进入[待处理]页面中<br />", "doGotoOrderApprove()", "", "提示");
            }
        },
        error: function () {
            redgle.showMessage("订单还原失败！");
        }
    });
}
//转向待处理
function doGotoOrderApprove() {
    window.location.href = "../Order/OrderApprove";
}
//订单标记
function doMarkOrder(parentPageKey, markId) {
    var orderIds = "";
    $('input[name="chk_list"]:checked').each(function () {
        orderIds += $(this).val() + ",";
    });
    if (orderIds.length == 0) {
        redgle.showMessage("请至少选择一个订单！");
        return;
    }
    $.ajax({
        type: "POST",
        url: "../Order/MarkOrder",
        data: {
            orderIds: orderIds, markId: markId
        },
        datatype: "text",
        success: function (data) {
            if (!data.HasError) {
                eval(parentPageKey + "doReloadData()");
            }
            else {
                redgle.showMessage("标记订单出错:" + data.Message);
            }
        },
        error: function () {
            redgle.showMessage("标记订单出错.");
        }
    });
}
//取消订单标记
function doDeleteOrderMark(parentPageKey, markRelationId) {
    $.ajax({
        type: "POST",
        url: "../Order/DeleteOrderMark",
        data: {
            markRelationId: markRelationId
        },
        datatype: "text",
        success: function (data) {
            if (!data.HasError) {
                eval(parentPageKey + "doReloadData()");
            }
            else {
                redgle.showMessage("取消标记出错:" + data.Message);
            }
        },
        error: function () {
            redgle.showMessage("取消标记出错.");
        }
    });
}
//有无跟踪号
$("#divTrackNum > span").each(function () {
    $(this).click(function () {
        var cls = $(this).attr("class");
        if (typeof (cls) == "undefined" || cls.indexOf("active") < 0) {
            $("#divTrackNum > span").removeClass("active");
            $(this).addClass("active");
        }
        else {
            $(this).removeClass("active");
        }
        var selectedItems = "";
        $("#divTrackNum > span").each(function () {
            var cls = $(this).attr("class");
            if (typeof (cls) != "undefined" && cls.indexOf("active") >= 0) {
                selectedItems = $(this).attr("itemid");
            }
        });
        $("#hidTrackNum").val(selectedItems);
        $("#searchForm").submit();
    });
});
//订单导入
function doImportData(parentPageKey) {
    var url = "../Order/Import";
    redgle.tab.create("liorderImport", url, "导入订单");
}
//订单导出
function doExportData(viewName, pagekey) {
    var OrderIds = "";
    $('input[name="chk_list"]:checked').each(function () {
        OrderIds += $(this).val() + ",";
    });
    if (OrderIds.length == 0) {
        redgle.showMessage("请至少选择一个订单导出！");
        return;
    }
    var width = 950;
    var height = 560;
    var url = "../Order/Export?viewName=" + viewName + "&pagekey=" + pagekey;
    var DownsTemplateModal = new redgle.modal({ type: "iframe", content: url, title: "选择导出值", width: width, height: height });
    DownsTemplateModal.show();
}
//订单导出
function doExport(filePath) {
    var OrderIds = "";
    parent.window.$('input[name="chk_list"]:checked').each(function () {
        OrderIds += $(this).val() + ",";
    });
    if (OrderIds.length == 0) {
        redgle.showMessage("请至少选择一个订单导出！");
        return;
    }
    var fieldName = "";
    $('input[name="chk_list"]:checked').each(function () {
        fieldName += $(this).val() + ",";
    });
    if (fieldName.length == 0) {
        redgle.showMessage("请至少选择一个字段导出！");
        return;
    }
    $.ajax({
        type: "POST",
        url: "../Order/ExportOrderExcel",
        data: {
            viewName: "Order",
            pageKey: "Order/Export",
            txtSearchKey: parent.window.$("#txtSearchKey").val(),
            hidChoose: parent.window.$("#hidChoose").val(),
            hidStore: parent.window.$("#hidStore").val(),
            hidApiAccountItems: parent.window.$("#hidApiAccountItems").val(),
            hidUserForms: parent.window.$("#hidUserForms").val(),
            hidCountrys: parent.window.$("#hidCountrys").val(),
            txtDateBegin: parent.window.$("#txtDateBegin").val(),
            txtDateEnd: parent.window.$("#txtDateEnd").val(),
            hidSkus: parent.window.$("hidSkus").val(),
            hidRemarks: parent.window.$("hidRemarks").val(),
            hidPaymentCodes: parent.window.$("hidPaymentCodes").val(),
            hidOrderStatusCodes: parent.window.$("hidOrderStatusCodes").val(),
            hidMessages: parent.window.$("hidMessages").val(),
            OrderIds: OrderIds,
            fieldName: fieldName
        },
        datatype: "json",
        success: function (data) {
            if (data.HasError) {
                alert("操作失败:" + data.Message);
            } else {
                window.open(filePath + "/" + data.ResultObject);
            }
        },
        error: function () {
            alert("操作失败！");
        }
    });
}
//扫描验货
function doScanValidateOrder() {
    var url = "../Order/ScanValidateOrder";
    redgle.tab.create("liScanValidateOrder", url, "扫描验货");
}

//扫描发货
function doScanDelivery(parentPage) {
    var url = "../Order/ScanDelivery?parentPage=" + parentPage;
    redgle.tab.create("liScanDelivery", url, "扫描发货");
}

function doShowPackageTrack(event) {
    var src = event.target || window.event.srcElement;
    var trPanel = $(src).parents("tr");
    var orderId = trPanel.find("input[type='checkbox']").val();
    var trackingNo = trPanel.find("#hidLogisticTransitNo").val();
    var panel = trPanel.find("#divPackageTrackPanel");
    var loadContent = function (src,parentPanel, trackingNo) {
        var status = parentPanel.find("#divPackageTrackPanel").attr("status");
        if (status == "loaded") {
            parentPanel.find(".popover-title").html(trackingNo + "【" + parentPanel.find("#hidLogisticTransitStatus").val() + "】<a class='reloadtrack' href='javascript:void(0)'>重新查询</a><span class='closePopover' style='float:right;cursor:pointer' title='关闭'>[×]</span>");
            parentPanel.find("#divPopoverContent").html(parentPanel.find("#divPackageTrackPanel").html());

            parentPanel.find(".closePopover").click(function () {
                $(src).click();
            });
            parentPanel.find(".reloadtrack").click(function () {
                var text = "正在通过接口重新查询物流信息，此过程会比较慢，请耐心等候...";
                trPanel.find("#divPackageTrackPanel").html(text);
                trPanel.find("#divPopoverContent").html(text);
                $.ajax({
                    type: "POST",
                    url: "../PackageTrack/SyncOrderTrack",
                    global: false,
                    data: {
                        orderId: orderId,
                        trackingNo: trackingNo
                    },
                    datatype: "json",
                    success: function (data) {
                        if (data.HasError) {
                            panel.html(data.Message);
                            loadContent(src, trPanel, trackingNo);
                        }
                        else {
                            syncPackageTrack(data.ResultObject);
                        }
                    },
                    error: function () {
                        alert("操作失败！");
                    }
                });
            });
        }
        else {
            parentPanel.find("#divPopoverContent").html("正在加载中...");
        }
    };
    var syncPackageTrack = function (trackingItem) {
        track.searchTrack(trackingItem, function (trackingItem, result) {
            if (result.ret != 1) {
                panel.html("执行出错：id=" + result.ret + "，msg=" + result.msg);
            }
            else {
                trackingItem.TrackData = JSON.stringify(result);
                $.ajax({
                    type: "POST",
                    url: "../PackageTrack/UpdateTrack",
                    data: trackingItem,
                    datatype: "json",
                    global: false,
                    success: function (data2) {
                        if (data2.HasError) {
                            panel.html(data2.Message);
                            loadContent(src, trPanel, trackingNo);
                        }
                        else {
                            var html = track.renderTrackPostResult(data2.ResultObject, trPanel);
                            panel.html(html);
                            loadContent(src, trPanel, trackingNo);
                        }
                    },
                    error: function (requestResult) {
                        var html = "服务器返回错误信息：" + requestResult.status + "，" + requestResult.statusText;
                        panel.html(html);
                        loadContent(src, trPanel, trackingNo);
                    }
                });
            }
        });
    }

    if (panel.attr("status") == "uncreate") {
        $(src).popover({
            content: "<div style='height:380px;width:470px;overflow-y: auto;' id='divPopoverContent' class='message-details'></div>",
            html: true,
            placement: 'left',
            trigger: 'click',
            title: "查看包裹物流状态"
        });
        panel.attr("status", "unload");
       
        $(src).on('shown.bs.popover', function () {
            if (panel.attr("status") == "unload") {
                panel.attr("status", "loading");

                trPanel.find("#divPopoverContent").html("正在加载中...");

                $.ajax({
                    type: "POST",
                    url: "../Order/LoadPackageTrack",
                    global:false,
                    data: {
                        orderId: orderId,
                        trackingNo: trackingNo
                    },
                    datatype: "json",
                    success: function (data) {
                        panel.attr("status", "loaded");
                        if (data.HasError) {
                            panel.html(data.Message);
                            loadContent(src, trPanel, trackingNo);
                        }
                        else {
                            if (data.ErrorCode == "0") {
                                var text = "本地未发现此物流跟踪信息，正在通过接口查询，此过程会比较慢，请耐心等候...";
                                trPanel.find("#divPackageTrackPanel").html(text);
                                trPanel.find("#divPopoverContent").html(text);
                                syncPackageTrack(data.ResultObject);
                            }
                            else {
                                var html = track.renderTrackPostResult(data.ResultObject, trPanel);
                                panel.html(html);

                                loadContent(src, trPanel, trackingNo);
                            }
                        }
                    },
                    error: function (requestResult) {
                        panel.attr("status", "unload");
                        var html = "服务器返回错误信息：" + requestResult.status + "，" + requestResult.statusText;
                        panel.html(html);
                    }
                });
            }
            else {
                loadContent(src, trPanel, trackingNo);
            }
        });
    }
}

