﻿if (typeof (redgle) == "undefined")
    redgle = new Object();

redgle.request = {
    getFormData: function (formId) {
        var postData = {};
        $("#" + formId).find("input[type!='submit'][type!='button']").each(function () {
            postData[$(this).attr("name")] = $(this).val();
        });
        $("#" + formId).find("select").each(function () {
            postData[$(this).attr("name")] = $(this).val();
        });

        return postData;
    },
    ajaxExtend: function () {
        //加载公共事件
        $(document).ajaxStart(function () {
            $("#divAjaxLoadingPanel").modal({ keyboard: false, backdrop: false }).modal('show');
        });
        $(document).ajaxStop(function () {
            $("#divAjaxLoadingPanel").modal('hide');
        });
    }
}
redgle.request.ajaxExtend();

/*
数字操作类
*/
redgle.math = {
    round: function (num, length) {
        length = length ? parseInt(length) : 0;
        if (length <= 0) return Math.round(num);
        num = Math.round(num * Math.pow(10, length)) / Math.pow(10, length);
        return num;
    }
}
/*
option用于显示模态对话框的参数
width:显示对话框的宽度
height:高度
title:标题
content:显示的内容
type:显示内容类型（html|iframe）
*/
redgle.modal = function (option) {
    if (typeof (option) == "undefined")
        option = {};
    var modalPanel = null;

    this.show = function () {
        Init();
        var _x, _y, m;
        modalPanel = document.createElement('div');
        modalPanel.id = option.panelName;
        modalPanel.className = "modal fade";
        //弹出消息提示框的高度需要自适应
        if (option.isShowMessage == true || option.isShowConfirm == true || option.type == "html") {
            modalPanel.innerHTML = '<div class="modal-dialog" style="height:auto !important;height:' + option.height + 'px;min-height:' + option.height + 'px;width:' + option.width + 'px"><div class="modal-content" style="height:auto !important;min-height:' + option.height + 'px;height:' + option.height + 'px;width:' + option.width + 'px"><div class="modal-header"><button type="button" class="close" btnType="forClose"><span aria-hidden="true">&times;</span></button><h4 class="modal-title"> ' + option.title + '</h4></div><div class="modal-body"></div></div></div>';
        } else {
            modalPanel.innerHTML = '<div class="modal-dialog" style="height:' + option.height + 'px;width:' + option.width + 'px"><div class="modal-content" style="height:' + option.height + 'px;width:' + option.width + 'px"><div class="modal-header"><button type="button" class="close" btnType="forClose"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" style="font-size:12px !important; margin-top:5px;"> ' + option.title + '</h4></div><div class="modal-body"></div></div></div>';
        }
        document.body.appendChild(modalPanel);
        $(modalPanel).find(".modal-body").eq(0).html(option.content);

        //设置样式
        $(modalPanel).find(".modal-header").css({ padding: "5px 15px", cursor: "move", background: "#438EB9 none repeat scroll 0% 0%", color: "white" });
        if (option.type == "iframe" && option.content.length > 0) {
            var height = parseInt(option.height) - 60;
            $(modalPanel).find("iframe").css("height", height);
        }
        var marginLeft = parseInt(option.width / 2);
        var marginTop = parseInt(option.height / 2.2);

        var winHeight = parseInt($(window).height() / 2.2);
        var winWidth = parseInt($(window).width() / 2);
        var left = winWidth - marginLeft;
        var top = winHeight - marginTop;
        $(modalPanel).children(".modal-dialog").css({ margin: "0px 0px 0px 0px", top: top, left: left });

        //设置事件
        $(modalPanel).find("button[btnType='forClose']").click(function () {
            $(modalPanel).modal("hide");
        });
        //如果是弹出的确认窗口，则绑定关闭事件时进行下列判断
        if (option.isShowConfirm == true) {
            $(modalPanel).find("button[btnType='forOK']").click(function () {
                $(modalPanel).modal("hide");
                if (option.OkCallbackScript != "")
                    eval(option.OkCallbackScript);
            });
            $(modalPanel).find("button[btnType='forCancel']").click(function () {
                $(modalPanel).modal("hide");
                if (option.CancelCallbackScript != "")
                    eval(option.CancelCallbackScript);
            });
        }
        $(modalPanel).on('hidden.bs.modal', function () {
            $(modalPanel).html("").remove();
        });

        $(modalPanel).modal({ show: true, backdrop: true, keyboard: false });
        if (option.onClosed != null && typeof (option.onClosed) == "function") {
            $(modalPanel).on('hide.bs.modal', option.onClosed);
        }
        $(modalPanel).find(".modal-header").mousedown(function (e) {
            if (e.which) {
                m = true;
                _x = e.pageX - parseInt($(modalPanel).children(".modal-dialog").css('left'));
                _y = e.pageY - parseInt($(modalPanel).children(".modal-dialog").css('top'));
            }
        });
        $(modalPanel).find(".modal-header").mousemove(function (e) {
            if (m) {
                var x = e.pageX - _x;
                var y = e.pageY - _y;
                $(modalPanel).children(".modal-dialog").css({ left: x });
                $(modalPanel).children(".modal-dialog").css({ top: y });
            }
        });
        $(modalPanel).mouseup(function () {
            m = false;
        });
    }

    this.close = function () {
        if (modalPanel == null)
            return;
        $(modalPanel).modal("hide");
    }

    function Init() {
        option = $.extend({}, {
            panelName: "divModalPanel" + Math.floor(Math.random() * 100 + 1),
            width: "800",
            height: "560",
            title: "",
            content: "",
            type: "html",
            isShowConfirm: false,
            isShowMessage: false,
            OkCallbackScript: "",
            CancelCallbackScript: ""
        }, option);

        if (option.type == "iframe" && option.content.length > 0) {
            option.content += "#" + option.panelName;
            option.content = "<iframe src=\"" + option.content + "\" width=\"100%\" height=\"100%\" frameborder=\"0\"></iframe>";
        }
    }
}
redgle.modal.closeModal = function (modalPanelId) {
    $("#" + modalPanelId).modal("hide");
}

redgle.showMessage = function (message, title) {
    if (title == undefined || title == "")
        title = "提示";
    var content = "<table style='height:190px;min-height:190px;width:340px'><tr><td valign='middle' align='center'><font size='3' style='word-break:break-all'>" + message + "</font></td></tr><tr><td style='height:35px;' align='center' valign='top'><button style='width:70px' class='btn btn-default btn-sm' btnType='forClose'>关闭</button></td></tr></table>";
    var messageModal = new redgle.modal({ type: "html", title: title, content: content, width: 360, height: 245, isShowMessage: true });
    messageModal.show();
}
redgle.showConfirm = function (message, OkCallbackScript, CancelCallbackScript, title) {
    if (title == undefined || title == "")
        title = "提示";
    var content = "<table style='height:190px;min-height:190px;width:340px'><tr><td valign='middle' align='center'><font size='3' style='word-break:break-all'>" + message + "</font></td></tr><tr><td style='height:35px;' align='center' valign='top'><button style='width:70px' class='btn btn-primary btn-sm' btnType='forOK'>确定</button>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<button style='width:70px' class='btn btn-default btn-sm' btnType='forCancel'>关闭</button></td></tr></table>";
    var messageModal = new redgle.modal({ type: "html", title: title, content: content, width: 360, height: 245, isShowConfirm: true, OkCallbackScript: (OkCallbackScript != undefined ? OkCallbackScript : ""), CancelCallbackScript: (CancelCallbackScript != undefined ? CancelCallbackScript : "") });
    messageModal.show();
}
//带备注的提示
redgle.showRemarkConfirm = function (message, OkCallbackScript, CancelCallbackScript, title) {
    if (title == undefined || title == "")
        title = "提示";
    var content = "<table style='height:190px;min-height:190px;width:340px'><tr><td valign='middle' align='center'  colspan='2'><font size='3'>" + message + "</font></td></tr><tr><td ><font size='3'  style=padding-left:10px>备注</font></td><td><textarea class='form-control' id='remarkText' style='width:280PX'  rows='4'></textarea></td></tr> <tr><td style='height:35px;' align='center' valign='top'  colspan='2'><button style='width:70px' class='btn btn-primary btn-sm' btnType='forOK'>确定</button>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<button style='width:70px' class='btn btn-default btn-sm' btnType='forCancel'>关闭</button></td></tr></table>";
    var messageModal = new redgle.modal({ type: "html", title: title, content: content, width: 360, height: 245, isShowConfirm: true, OkCallbackScript: (OkCallbackScript != undefined ? OkCallbackScript : ""), CancelCallbackScript: (CancelCallbackScript != undefined ? CancelCallbackScript : "") });
    messageModal.show();
}
/*
组织分类树目录
*/
redgle.tree = function (option) {
    if (typeof (option) == "undefined")
        option = {};
    option = $.extend({}, {
        contentPanelExpr: "",
        navigatePanelExpr: "",
        allowNavigate: true,
        fnLoadChildren: null,
        fnNodeClick: null
    }, option);

    _self = this;

    this.addItemsToNavigate = function (dataList, navigatePanel) {
        if (navigatePanel == null || typeof (navigatePanel) == "undefined")
            navigatePanel = option.navigatePanelExpr;

        for (var i = 0; i < dataList.length; i++) {
            var dataItem = dataList[i];

            if ($(navigatePanel + " > li").length > 0) {
                if (dataItem.parentId == 0)
                    $(navigatePanel + " > li").remove();
                else
                    $(navigatePanel + " #item_" + dataItem.parentId).nextAll().remove();
            }
            if ($(navigatePanel + " #item_" + dataItem.id).length == 0) {
                $(navigatePanel + " #item_" + dataItem.parentId).nextAll().remove();

                var item = $("<li></li>").appendTo(navigatePanel).attr({ id: "item_" + dataItem.id, item_id: dataItem.id, item_name: dataItem.name, item_parent: dataItem.parentId, item_path: dataItem.path });
                $("<a href=\"javascript:javascript:void(0)\"> " + dataItem.name + " </a>").appendTo(item).click(function () {
                    onNavigateNodeCllick(this);
                });
            }
        }
    }

    this.AddElementItem = function (dataItem) {
        if ($(option.contentPanelExpr + " #content_" + dataItem.id).length == 0) {
            var contentPanel = null;
            if (dataItem.parentId == 0) {
                $("<ul></ul>").appendTo(option.contentPanelExpr);
                contentPanel = $("<li></li>").attr({ id: "content_" + dataItem.id, item_id: dataItem.id, item_name: dataItem.name, item_parent: dataItem.parentId, item_path: dataItem.path }).appendTo(option.contentPanelExpr + " > ul");
            }
            else {
                contentPanel = $("<li></li>").attr("id", "content_" + dataItem.id).appendTo(option.contentPanelExpr + " #content_" + dataItem.parentId);
            }

            var contentItem = $("<span></span>").appendTo(contentPanel);
            if (dataItem.hasChild) {
                if (typeof (dataItem.children) == "undefined") {
                    $("<i class=\"glyphicon glyphicon-plus\"></i>").appendTo(contentItem).click(function () {
                        onExpandChild(this);
                    });
                }
                else {
                    $("<i class=\"glyphicon glyphicon-minus\"></i>").appendTo(contentItem).click(function () {
                        onExpandChild(this);
                    });
                }
            }
            $("<a href=\"javascript:javascript:void(0)\"> " + dataItem.name + " </a>").appendTo(contentItem).click(function () {
                onTreeNodeClick(this);
            });
        }

        if (typeof (dataItem.children) != "undefined" && $(option.contentPanelExpr + " #content_" + dataItem.id + " > ul").length == 0) {
            var childContentPanel = $("<ul></ul>").appendTo(option.contentPanelExpr + " #content_" + dataItem.id);
            for (var i = 0; i < dataItem.children.length; i++) {
                var child = dataItem.children[i];
                var childContent = $("<li></li>").attr({ id: "content_" + child.id, item_id: child.id, item_name: child.name, item_parent: child.parentId, item_path: child.path }).appendTo(childContentPanel);
                var childContentItem = $("<span></span>").appendTo(childContent);
                if (child.hasChild) {
                    $("<i class=\"glyphicon glyphicon-plus\"></i>").appendTo(childContentItem).click(function () {
                        onExpandChild(this);
                    });
                }
                $("<a href=\"javascript:javascript:void(0)\"> " + child.name + " </a>").appendTo(childContentItem).click(function () {
                    onTreeNodeClick(this);
                });
            }

            var ico = $(option.contentPanelExpr + " #content_" + dataItem.id + " > span > i");
            if ($(ico).hasClass("glyphicon-asterisk")) {
                $(ico).removeClass("glyphicon-asterisk").addClass("glyphicon-minus");
            }
        }
    }

    this.getElementData = function (element) {
        return {
            id: $(element).attr("item_id"),
            name: $(element).attr("item_name"),
            parentId: $(element).attr("item_parent"),
            path: $(element).attr("item_path")
        }
    }

    this.convertDataToDept = function (data) {
        if (typeof (data.length) != "undefined") {
            var dept = new Array();
            for (var i = 0; i < data.length; i++) {
                dept.push(dataToDept(data[i]));
            }
            return dept;
        }
        else {
            return dataToDept(data);
        }
    }

    this.convertDeptToData = function (dept) {
        if (typeof (dept.length) != "undefined") {
            var data = new Array();
            for (var i = 0; i < dept.length; i++) {
                data.push(deptToData(dept[i]));
            }
            return data;
        }
        else {
            return deptToData(dept);
        }
    }

    this.convertDataToCatalog = function (data) {
        if (typeof (data.length) != "undefined") {
            var catalog = new Array();
            for (var i = 0; i < data.length; i++) {
                catalog.push(dataToCatalog(data[i]));
            }
            return catalog;
        }
        else {
            return dataToCatalog(data);
        }
    }

    this.convertCatalogToData = function (catalog) {
        if (typeof (catalog.length) != "undefined") {
            var data = new Array();
            for (var i = 0; i < catalog.length; i++) {
                data.push(catalogToData(catalog[i]));
            }
            return data;
        }
        else {
            return catalogToData(catalog);
        }
    }

    function onExpandChild(element) {
        var currentPanel = $(element).parentsUntil("ul").filter("li");
        if ($(element).hasClass("glyphicon-plus")) {
            if (currentPanel.children("ul").length > 0) {
                $(element).removeClass("glyphicon-plus").addClass("glyphicon-minus");
                currentPanel.children("ul").show();
            }
            else {
                $(element).removeClass("glyphicon-plus").addClass("glyphicon-asterisk");
                var itemData = _self.getElementData(currentPanel);
                option.fnLoadChildren(itemData.id);
            }
        }
        else {
            $(element).removeClass("glyphicon-minus").addClass("glyphicon-plus");
            if (currentPanel.children("ul").length > 0) {
                currentPanel.children("ul").hide();
            }
        }
    }

    function onNavigateNodeCllick(obj) {
        var currentPanel = $(obj).parent();
        var currData = _self.getElementData(currentPanel);
        option.fnNodeClick(currData);

        currentPanel.nextAll().remove();
    }

    function onTreeNodeClick(obj) {
        var currentPanel = $(obj).parentsUntil("ul").filter("li");
        var currData = _self.getElementData(currentPanel);
        option.fnNodeClick(currData);

        if (option.allowNavigate) {
            var dataList = new Array();
            dataList.push(currData);
            $(currentPanel).parents("li[item_id]").each(function () {
                var data = _self.getElementData(this);
                dataList.push(data);
            });
            var navigatePanel = $(obj).parents("[navigategroup]").attr("navigategroup");
            _self.addItemsToNavigate(dataList.reverse(), navigatePanel);
        }
    }

    function dataToDept(data) {
        return {
            DeptId: data.id,
            DeptName: data.name,
            ParentDeptId: data.parentId,
            DeptIdPath: data.path
        }
    }

    function deptToData(dept) {
        var data = {
            id: dept.DeptId,
            name: dept.DeptName,
            parentId: dept.ParentDeptId,
            path: dept.DeptIdPath,
            hasChild: dept.HasChild
        };
        if (typeof (dept.Children) != "undefined") {
            data.children = new Array();
            for (var i = 0; i < dept.Children.length; i++) {
                data.children.push(deptToData(dept.Children[i]));
            }
        }

        return data;
    }

    function dataToCatalog(data) {
        return {
            CatalogId: data.id,
            CatalogName: data.name,
            ParentCatalogId: data.parentId,
            CatalogIdPath: data.path
        }
    }

    function catalogToData(catalog) {
        var data = {
            id: catalog.CatalogId,
            name: catalog.CatalogName,
            parentId: catalog.ParentCatalogId,
            path: catalog.CatalogIdPath,
            hasChild: catalog.HasChild
        }

        if (typeof (catalog.Children) != "undefined") {
            data.children = new Array();
            for (var i = 0; i < catalog.Children.length; i++) {
                data.children.push(catalogToData(catalog.Children[i]));
            }
        }

        return data;
    }
}

/*
Tab标签管理功能
*/
redgle.tab = {
    tabPanel: "divTabPanel",
    contentPanel: "divTabContentPanel",
    init: function (option) {
        if (option == null)
            return;
        if (option.tabPanel != null)
            tabPanel = option.tabPanel;
        if (option.contentPanel != null)
            contentPanel = option.contentPanel;
        if (option.showItemId != null)
            showItemId = option.showItemId;
        $("#" + tabPanel + " li > a").each(function () {
            var id = $(this).parent().attr("id");
            $(this).click(function () {
                redgle.tab.open(id);
            });
        });
    },
    open: function (tabItemId) {
        if ($("#" + tabItemId).length) {
            $("#" + tabPanel + " li").each(function () {
                $(this).removeClass("active");
            });
            $("#" + contentPanel + " > div").each(function () {
                $(this).removeClass("active").removeClass("in");
            });
            $("#" + tabItemId).addClass("active");
            $("#tabContent_" + tabItemId).addClass("active").addClass("in");
        }
    },
    create: function (tabItemId, url, title, returnItem, successEvent) {
        if ($("#" + tabItemId).length) {
            $("#tabContent_" + tabItemId).html("");
        }
        else {
            //创建元素
            var tabItem = $("<li></li>").attr({ id: tabItemId, url: url, role: "presentation" }).appendTo($("#" + tabPanel));
            if (returnItem != null)
                tabItem.attr("return", returnItem);
            var link = $("<a></a>").attr({ role: "tab" }).css("cursor", "pointer").html(title + " ").appendTo(tabItem);
            var closeIco = $("<span class=\"glyphicon glyphicon-remove\"></span>").css("cursor", "pointer").appendTo(link);
            var contentItem = $("<div></div>").attr({ role: "tabpanel", id: "tabContent_" + tabItemId }).addClass("tab-pane fade").appendTo($("#" + contentPanel));
            contentItem.html("数据正在加载中...");

            //设置事件
            link.click(function () {
                redgle.tab.open(tabItemId);
            });
            closeIco.click(function () {
                redgle.tab.close(tabItemId);
            });
        }



        //异步请求数据
        $.ajax({
            type: "GET",
            url: url,
            cache: false,
            data: { ajaxType: "text" },
            datatype: "text",
            success: function (data) {
                $("#tabContent_" + tabItemId).html(data);
                if (successEvent != null && typeof (successEvent) == "function") {
                    successEvent();
                }
            },
            error: function (XMLHttpRequest) {
                $("#tabContent_" + tabItemId).html("请求地址出错：" + XMLHttpRequest.status + " - " + XMLHttpRequest.statusText);
            }
        });

        //显示面板
        redgle.tab.open(tabItemId);
    },
    close: function (tabItemId, showItemId) {
        if (showItemId != null && $("#" + showItemId).length) {
            redgle.tab.open(showItemId);
        }
        else {
            var id = $("#" + tabItemId).attr("return");
            if (typeof (id) == "undefined" || id.length == 0) {
                id = $("#" + tabPanel + " li").first().attr("id");
            }
            redgle.tab.open(id);
        }

        if ($("#editor").length) {
            //发现有高级编辑器则移除掉
            KindEditor.remove('textarea[name="editor"]');
        }

        if ($("#" + tabItemId).length) {
            $("#tabContent_" + tabItemId).html("").remove();
            $("#" + tabItemId).remove();
        }
    },
    createiframe: function (tabItemId, url, title, Addheight, returnItem, successEvent, loadid) {
        if ($("#" + tabItemId).length) {
            $("#tabContent_" + tabItemId).html("");
        }
        else {
            //创建元素
            var tabItem = $("<li></li>").attr({ id: tabItemId, url: url, role: "presentation" }).appendTo($("#" + tabPanel));
            if (returnItem != null)
                tabItem.attr("return", returnItem);
            var link = $("<a></a>").attr({ role: "tab" }).css("cursor", "pointer").html(title + " ").appendTo(tabItem);
            var closeIco = $("<span class=\"glyphicon glyphicon-remove\"></span>").css("cursor", "pointer").appendTo(link);
            var contentItem = $("<div></div>").attr({ role: "tabpanel", id: "tabContent_" + tabItemId }).addClass("tab-pane fade").appendTo($("#" + contentPanel));
            contentItem.html("数据正在加载中...");

            //设置事件
            link.click(function () {
                redgle.tab.open(tabItemId);
            });
            closeIco.click(function () {
                redgle.tab.close(tabItemId);
            });
        }
        var newIframeObject = document.createElement("IFRAME");
        newIframeObject.src = url;
        newIframeObject.scrolling = "no";
        newIframeObject.frameBorder = 0;
        newIframeObject.width = "100%";
        newIframeObject.id = "iframe_" + tabItemId;
        $("#tabContent_" + tabItemId).html(newIframeObject);
        var ifr = document.getElementById('iframe_' + tabItemId)
        ifr.onload = function () {
            var subWeb = document.frames ? document.frames[newIframeObject.id].document : ifr.contentDocument;
            if (ifr != null && subWeb != null) {
                debugger;
                if (loadid) {
                    ifr.height = $(subWeb).find("#bodyHeight").height();
                }
                else {
                    ifr.height = subWeb.body.scrollHeight;
                }
            }
        }
        if (successEvent != null && typeof (successEvent) == "function") {
            successEvent();
        }
        //显示面板
        redgle.tab.open(tabItemId);
    }
}
function calcPageHeight(doc) {
    var cHeight = Math.max(doc.body.clientHeight, doc.documentElement.clientHeight)
    var sHeight = Math.max(doc.body.scrollHeight, doc.documentElement.scrollHeight)
    var height = Math.max(cHeight, sHeight)
    return height
}
/*
内容页折叠标签
*/
function panelshow() {
    $(".panel-title>span").addClass("glyphicon glyphicon-triangle-bottom");
    $(".panel-body").addClass("collapse in");
    $(".panel-heading").click(function () {
        var thisSpan = $(this).find("span");
        if (thisSpan.attr("class").indexOf("glyphicon-triangle-bottom") > 0) {
            thisSpan.removeClass("glyphicon-triangle-bottom").addClass("glyphicon-triangle-right");
            $(this).parent().find(".panel-body").removeClass("in");
        } else {
            thisSpan.removeClass("glyphicon-triangle-right").addClass("glyphicon-triangle-bottom");
            $(this).parent().find(".panel-body").addClass("in");
        }
    });
}
jQuery(function () {
    $(".dropdown-toggle").bind("mouseover", function () {
        if ($(this).parent().is(".open")) {
            return
        }
        $(this).dropdown("toggle")
    });
});


