﻿/*******************************************************
* 
* 创建人：Quber
* 创建日期：2013年6月21日
* 创建说明：jQuery Uploadify Plugin Demo
* 修改人：
* 修改日期：
* 修改说明：
*
* 联系方式：
*     QQ：757200834
*     邮箱：qubernet@163.com
*     博客：http://qubernet.blog.163.com/
*
*******************************************************/

$(function () {
    //initUploadify();
});

function initUploadify() {
    var path = $("#targetFolder").val();
    var uploadifySet = {
        isShowTip: true,
        isShowFileMoreError: true,
        isShowCompletedInfo: true,
        isShowCancelBtn: true,
        comPath: "/Scripts/",
        ajaxPath: "/Upload/UploadMultipleFile",
        filePath: path,
        fileSize: 1024 * 1024 * 1024 * 1.0,
        fileCount: 5,
        fileTypeText: "上传的文件类型(*.flv;,*.mp4)",
        fileExt: "*.flv;,*.mp4"
    };
    //选择文件
    $("#uploadifySelectFile").uploadify({
        'method': 'Post',
        'queueID': 'showUploadFile',
        'wmode': 'transparent',
        'auto': false,
        'multi': true,
        'uploader': uploadifySet.comPath + 'jQueryUploadify/Swf/uploadify.swf',
        'cancelImg': uploadifySet.comPath + 'jQueryUploadify/Image/uploadifyCancelSmall.png',
        'buttonImg': uploadifySet.comPath + 'jQueryUploadify/Image/uploadifySelect.png',
        'script': uploadifySet.ajaxPath,
        'folder': uploadifySet.filePath,
        'sizeLimit': uploadifySet.fileSize,
        'queueSizeLimit': uploadifySet.fileCount,
        'fileDesc': uploadifySet.fileTypeText,
        'fileExt': uploadifySet.fileExt,
        'onSelect': function (e, id, fileObj) {
          
        },
        'onCancel': function (e, id, fileObj, data, remove, clearFast) {
            if (getSingleFileCount() - 1 == 0) {
                $("#showUploadFile div,#showUploadifyInfo div,#showUploadifyInfo ul,.uploadify-status").fadeOut(250, "", function () {
                    $("#showUploadifyInfo,.uploadify-status").html("");
                });
            }
        },
        'onSelectOnce': function (e, data) {
            $(".pleseSelectFile,.uploadify-status").fadeOut(1000, "", function () {
                $(".pleseSelectFile").html("");
        });
            $(".uploadify-status").fadeIn(1000, "", function () {
            }).html("上传状态：等待上传！");
            $("#lbtnUploadifyC").css("display", "");
        },
        'onComplete': function (e, id, fileObj, response, data) {
        },
        'onQueueFull': function (e, count) {
            //是否显示文件过多提示信息
            if (uploadifySet.isShowFileMoreError) {
                $("#showUploadifyInfo").html("<div>提示：选择的文件过多，最多上传数量为：" + count + "，多余的文件将省略</div>");
            }
        },
        'onAllComplete': function (e, data) {
            //是否显示上传完毕提示信息
            if (uploadifySet.isShowCompletedInfo) {
                var fileCount = data.filesUploaded;
                var fileBytes = data.allBytesLoaded;
                var fileSpeed = data.speed;
                var fileError = data.errors;
                var info = "";
                info += "<ul>";
                //                info += "<li>文件上传完毕：</li>";
                info += "<li class='completedinfo right'>上传成功文件总数量：" + fileCount + "个</li>";
                info += "<li class='completedinfo error'>上传失败文件总数量：" + fileError + "个</li>";
                info += "<li class='completedinfo time'>文件上传平均速度：" + keepTwoDecimal(fileSpeed) + "KB/s</li>";
                info += "<li class='completedinfo size'>上传文件总容量：" + getFileSize(fileBytes) + "</li>";
                info += "</ul>";
                $(".uploadify-status").fadeIn(1000, "", function () {
                    $("#showUploadifyInfo").html(info);
                    $(".uploadify-info .info ul").fadeIn(1000, "", function () {
                    });
                }).html("上传状态：上传完成！");
            }
            $("#lbtnUploadifyC").css("display", "none");
        }
    });

    initSomeBtnClick(uploadifySet);
}

//Init Btn Click
function initSomeBtnClick(jsonSet) {
    //开始上传
    $("#lbtnUploadifyS").click(function () {
        var isTrue = $(".uploadify-status").html() == "上传状态：上传完成！";

        if ($.trim($("#showUploadFile").html()).length != 0 && !isTrue) {
            $(".uploadify-status").fadeIn(1000, "", function () {
            }).html("上传状态：上传中&nbsp;&nbsp;<img src=\"" + jsonSet.comPath + "jQueryUploadify/Css/Image/loading.gif\" alt=\"\" />");
            $("#uploadifySelectFile").uploadifyUpload();
            $("#lbtnUploadifyC").css("display", "none");
        }
        else {
            $("#showUploadifyInfo").html("<div class=\"pleseSelectFile\">请选择需要上传的文件</div>");
            $(".uploadify-info .info .pleseSelectFile").fadeIn(1000, "", function () {
            });
        }
        return false;
    });

    //取消上传
    $("#lbtnUploadifyC").click(function () {
        $("#showUploadFile div,#showUploadifyInfo div,#showUploadifyInfo ul,.uploadify-status").fadeOut(250, "", function () {
            $("#showUploadifyInfo,.uploadify-status").html("");
        });
        $("#uploadifySelectFile").uploadifyClearQueue();
    });
  
    //是否显示友情提示信息
    if (jsonSet.isShowTip) {
        $(".uploadify-tip").html("友情提示：一次最多上传" + jsonSet.fileCount + "个文件，单文件大小不超过" + getFileSize(jsonSet.fileSize) + ",上传文件格式主要是：flv、mp4");
    } else {
        $(".uploadify-tip").css("display", "none");
    }

    //是否显示取消按钮
    if (!jsonSet.isShowCancelBtn) {
        $("#lbtnUploadifyC").css("display", "none");
    }
}

//获取面板中文件总数量
function getSingleFileCount() {
    var count = 0;
    $(".uploadifyQueueItem .cancel").each(function () {
        var hrefCancel = $(this).find("a").attr("href");
        if (hrefCancel.length > 0) count++;
    });
    return count;
}

//根据文件的字节得到文件大小
function getFileSize(fileByte) {
    var fileSizeByte = fileByte;
    var fileSizeMsg = "";
    if (fileSizeByte < 1048576) fileSizeMsg = keepTwoDecimal(fileSizeByte / 1024) + "KB";
    else if (fileSizeByte == 1048576) fileSizeMsg = "1MB";
    else if (fileSizeByte > 1048576 && fileSizeByte < 1073741824) fileSizeMsg = keepTwoDecimal(fileSizeByte / (1024 * 1024)) + "MB";
    else if (fileSizeByte > 1048576 && fileSizeByte == 1073741824) fileSizeMsg = "1GB";
    else if (fileSizeByte > 1073741824 && fileSizeByte < 1099511627776) fileSizeMsg = keepTwoDecimal(fileSizeByte / (1024 * 1024 * 1024)) + "GB";
    else fileSizeMsg = "文件超过1TB";
    return fileSizeMsg;
}

//四舍五入保留2位小数（若第二位小数为0，则保留一位小数）
function keepTwoDecimal(num) {
    var result = parseFloat(num);
    if (isNaN(result)) {
        alert('传递参数错误，请检查！');
        return false;
    }
    result = Math.round(num * 100) / 100;
    return result;
}