/******************************************************************************* 
 *  Copyright 2011 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *  Licensed under the Apache License, Version 2.0 (the "License"); 
 *  
 *  You may not use this file except in compliance with the License. 
 *  You may obtain a copy of the License at: http://aws.amazon.com/apache2.0
 *  This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR 
 *  CONDITIONS OF ANY KIND, either express or implied. See the License for the 
 *  specific language governing permissions and limitations under the License.
 * ***************************************************************************** 
 *
 *  Marketplace Web Service Javascript Scratchpad
 */

// Initialize scratchpad APIs as a global variable
var ScratchpadApis = { };
var ScratchpadEnums = { };
var PostedAction = '';

/* Perform natural-byte comparison */
function naturalByteCompare(a, b) {
    for(var i=0;i<a.length;i++) {
        if(a.charCodeAt(i) != b.charCodeAt(i)) {
            return a.charCodeAt(i) > b.charCodeAt(i) ? 1 : -1;
        }
    }
    if(a.length == b.length) return 0;
    return a.length > b.length ? 1 : -1;
}

/* Performs URL encoding compatible with MWS http requests */
function urlEncode(str) {
    str = encodeURIComponent(str);
    str = str.replace(/\*/g, '%2A');
    str = str.replace(/\(/g, '%28');
    str = str.replace(/\)/g, '%29');
    str = str.replace(/'/g, '%27');
    str = str.replace(/\!/g, '%21');
    return str;
}

/* Formats a string to appear as if it were in a <pre> tag */
function formatPre(str) {
    return str.replace(/\n/g, '<br/>');
}

/* Gets a parameter from the URL */
function getParameter(name) {
    name = name.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
    var regexS = "[\\?&]"+name+"=([^&#]*)";
    var regex = new RegExp( regexS );
    var results = regex.exec( window.location.href );
    if( results == null ) return "";
    return results[1];
}

/* Converts an object to JSON format. */
function toJSON(obj) {
    var json = '';
    if(obj.length && typeof obj != 'string') {
        json = '[';
        for(var i=0;i<obj.length;i++) {
            if(i != 0) json += ',';
            json += toJSON(obj[i]);
        }
        json += ']';
        return json;
    }
    else if(typeof obj == 'object') {
        json += '{';
        $.each(obj, function(k, v) {
            json += k + ':' + toJSON(obj[k]) + ',';
        });
        json = json.slice(0, -1) + '}';
        return json;
    }
    else {
        if(typeof obj == 'string') return json + "'" + obj + "'";            
        return json + obj;
    }
}

/*
 * Creates a select field from either an array of values or from a javascript
 * object
 */
function createSelect(field, values) {
    var ret = '<select id="' + field.Name + '">';
    
    // Blank selectable value for non-required items
    if(!field.Required) ret += '<option value=""></option>';
    if(values.length) {
        // list is an array
        for(var i=0;i<values.length;i++) {
            ret += '<option value="' + values[i] + '">' + values[i] + '</option>';
        }
    }
    else {
        // list is a keyvalue pair object
        for(var k in values) {
            ret += '<optgroup label="' + k + '">';
            for(var j in values[k]) {
                ret += '<option value="' + j + '">' + j + '</option>';                
            }
            ret += '</optgroup>';
        }
    }
    ret += '</select>';
    return ret;
}

/*
   When fields have "list" set, since they're ordered sequentially and display the name
   of the parameter they're supposed to represent, renaming them is necessary when
   entries are removed from arbitrary positions within the list.
*/

function renameListFields(fields, list)
{
        if(!fields) {
                var apiCallOption = $('#apicall option:selected');
                var apiGroup = apiCallOption.data('apigroup');
                var apiCall = apiCallOption.data('apicall');
                if(!apiGroup || !apiCall) return;
                fields = apiCall.Parameters;
        }
        for(var i=0;i<fields.length;i++) {
                var p = fields[i];

                // if the field type is an enumerated field, select "select" elements,
                // otherwise select input elements
                var select = ':input';
                for(var e in ScratchpadEnums) if(e == p.Type) select = 'select';

                var index = 1;
                if(p.Type == 'Complex') {
                        renameListFields(p.Parameters, p.List);
                }
                else if(p.List || list) {
                        $(select).each(function() {
                                if(p.Name == $(this)[0].id) {
                                        var newName = p.Name.replace(/\-/, index);
                                        $('.left', $(this)[0].parentNode.parentNode).text(newName);
                                        index++;
                                }
                        });
                
                }
        }

}

//This was an attempt to add list indexes to support listDepth > 1, needs revising
//retaining this code in comments in a hope to get back to this some day -
//marri@
/*function renameListFields(fields, list, listDepth)
  {
      if(!fields) {
              var apiCallOption = $('#apicall option:selected');
              var apiGroup = apiCallOption.data('apigroup');
              var apiCall = apiCallOption.data('apicall');
              if(!apiGroup || !apiCall) return;
              fields = apiCall.Parameters;
              listDepth = 1;
      }
      for(var i=0;i<fields.length;i++) {
                var p = fields[i];
                var hyphenPattern = new RegExp("\\.\-{"+listDepth+"}\\.");
                // if the field type is an enumerated field, select "select" elements,
                // otherwise select input elements
                var index = 1;

                var select = ':input';
                for(var e in ScratchpadEnums) if(e == p.Type) select = 'select';
                var newName = p.Name;
                $(select).each(function() {
                    if(p.List || list) {
                             if(p.Name == $(this)[0].id && hyphenPattern.test(p.Name)){
                                  newName = p.Name.replace(hyphenPattern, "."+index+".");
                                  $('.left', $(this)[0].parentNode.parentNode).text(newName);
                                  index++;            
                             }

                    }
                    if(p.Type == 'Complex') {
                        renameListFields(p.Parameters, p.List,listDepth);
                    }
                });
                if(list && p.List){
                          matchAndReplace(p,listDepth+1,select,newName);
                }
      }
  }

  // matches -{innerLoop} regular expression and replaces with the index 
  function matchAndReplace(paramater,innerLoop,select,name){
         var index = 1;
         var hyphenPattern = new RegExp("\.\-{"+innerLoop+"}\.");
         $(select).each(function() {
                  if(paramater.Name == $(this)[0].id && hyphenPattern.test(name)) {
                        var newName=name.replace(hyphenPattern,"."+index+".");
                        $('.left', $(this)[0].parentNode.parentNode).text(newName);
                        index++;
                  }
              });
  }

// Remove trailing . 
function cleanTrailingDots(){
          var fields;
          var trailingDot = new RegExp("\.$");
          var apiCallOption = $('#apicall option:selected');
          var apiGroup = apiCallOption.data('apigroup');
          var apiCall = apiCallOption.data('apicall');
          if(!apiGroup || !apiCall) return;
          fields = apiCall.Parameters;
          for(var i=0;i<fields.length;i++) {
                  var p = fields[i];
                  var newName=p.Name.replace(trailingDot,""); //get rid of trailing .
                  $('.left', $(this)[0].parentNode.parentNode).text(newName);
          }
}
*/

/* Creates a field.  "field" is a javascript object with the keys 'required', 'name', and 'type'. */
function createField(field, isRemovable)
{
    var fieldDisplayTooltip = field.DisplayName ? field.DisplayName : field.Name;
    var fieldDisplayName = field.Name;
    
    var divRow = $('<div class="row" title="' + fieldDisplayTooltip + '">');    
    var divLeft = $('<div class="left">');
    divRow.append(divLeft);
    divLeft.append(fieldDisplayName);
    var divRight = $('<div class="right">');
    divRow.append(divRight);
    
    var isEnum = false;
    for(var e in ScratchpadEnums) if(e == field.Type) isEnum = true;
    if(isEnum) {
        // Create a drop-down list based on the enumeration type
        var select = createSelect(field, ScratchpadEnums[field.Type]);
        select = $(select);
        if($.browser.msie) {
            // In IE, a fixed width dropdown cuts off longer text so expand it and reset
            // the CSS when the input focus leaves the dropdown.
            select.click(function() {
                if(!$(this).data('oldWidth')) {
                    $(this).data('oldWidth', $(this).width() + 'px'); $(this).css("width", "auto");
                }
            });
            select.blur(function() {
                if($(this).data('oldWidth')) {
                    $(this).css("width", $(this).data('oldWidth'));
                    $(this).data('oldWidth', null);
                }
            });
        }
        divRight.append(select);
    }
    else if(field.Type == 'Checkbox') {
        // Simple true/false checkbox        
        divRight.append($('<input type="checkbox" id="' + field['Name'] + '"></input>'));
    }
    else if(field.Type == 'Timestamp') {
        // Place a jQuery Datepicker in an input field.
        var input = $('<input type="text" id="' + field['Name'] + '"></input>');
        divRight.append(input);
        
        input.datepicker({ dateFormat: "yy-mm-dd" });
        var input = $('<input class="hasTimepicker" type="text" id="' + field['Name'] + '_time"></input>');
        divRight.append(input);

        input.attr('value', '00:00');
    }
    else if(field.Type == 'DateString'){
        // tt0034049277, The tyep of FreightReadyDate is DateString in coral model.
        // See: http://tiny/ggeiqf5m/codeamazpackFBAIblobmainmode
        var input = $('<input type="text" id="' + field['Name'] + '"></input>');
        divRight.append(input);

        input.datepicker({ dateFormat: "yy-mm-dd" });
    }
    else if(field.Type == 'Complex') {
        var ret = $('<div></div>');
        var h5 = $('<h5><div style="float: left">' + fieldDisplayName + '</div></h5>');
        var h5div = $('<div class="row"></div>');
        h5div.append(h5);
        ret.append(h5div);
        for(var i=0;i<field.Parameters.length;i++) {
            if(field.Parameters[i]) {
                ret.append(createField(field.Parameters[i]));
            }
        }
        
        if(field.List) {
            var img;

            if(isRemovable) img = $('<img src="' + imageMinus + '" />');
            else img = $('<img src="' + imagePlus + '" />"');
            var a = $('<a href="javascript://"></a>');
            a.append(img);
            a.data('field', field);
            if(isRemovable) {
                // if the field is removable, then clicking on it should remove it
                a.click(function() {
                    $(this).parent().parent().remove();
                    renameListFields();
                });
            }
            else {
                // otherwise clicking on this field should create a removable duplicate
                a.click(function() {
                    $(this).parent().parent().parent().append(createField($(this).data('field'), true));
                    renameListFields();
                });
            }
            a.attr('style', 'float: right');
            h5div.append(a);
        }
        return ret;
    }
    else {
        // Default to a text field
        divRight.append($('<input type="text" id="' + field['Name'] + '"></input>'));
    }    
    if(field.List) {
        var img;

        if(isRemovable) img = $('<img src="' + imageMinus + '" />');
        else img = $('<img src="' + imagePlus + '" />"');
        var a = $('<a href="javascript://"></a>');
        a.append(img);
        a.data('field', field);
        if(isRemovable) {
            // if the field is removable, then clicking on it should remove it
            a.click(function() {
                $(this).parent().parent().remove();
                renameListFields();
            });
        }
        else {
            // otherwise clicking on this field should create a removable duplicate
            a.click(function() {
                $(this).parent().parent().parent().append(createField($(this).data('field'), true));
                renameListFields();
            });
                } 
        divRight.append(a);
    }

    return divRow;
}

function initFields(fields)
{
    // Hide SubmitFeed specific fields.
    $('#tabs').tabs('option', 'disabled', [ 0 ]);
    $('#tabs').tabs('select', 1);
    $('#tab-feed-li').hide();
    $('#form-feed').hide();
    $('#contentmd5').hide();
    $('#contentmd5header').hide();
    $('#contentmd5b64header').hide();
    $('#contentmd5b64').hide();

    // Erase all optional field elements    
    $('#required-parameters-content div').remove();
    $('#optional-parameters-content div').remove();
    $('#optional-parameters-content h5').remove();
    $('#required-parameters-content h5').remove();
    $('#optional-parameters-content a').remove();
    $('#required-parameters-content a').remove();
    
    var apiCallOption = $('#apicall option:selected');
    var apiGroup = apiCallOption.data('apigroup');
    var apiCall = apiCallOption.data('apicall');
    
    if(!apiGroup || !apiCall) return;
    $('#request-path').attr('value', apiGroup.Path);
    
    for(var i=0;i<apiCall['Parameters'].length;i++) {
            var field = createField(apiCall['Parameters'][i]);
            if(apiCall['Parameters'][i].Required) $('#required-parameters-content').append(field);
            else $('#optional-parameters-content').append(field);
    }
    renameListFields();
    
    if($('#required-parameters-content').get(0).children.length == 0) {
        $('#required-parameters-content').append("<h5>" + stringNoRequiredParams + "</h5>");
    }
    if($('#optional-parameters-content').get(0).children.length == 0) {
        $('#optional-parameters-content').append("<h5>" + stringNoOptionalParams + "</h5>");
    }
    // Show SubmitFeed input forms
    if(apiCall.ShowFeed) {
        $('#tab-feed-li').show();
        $('#tabs').tabs('option', 'disabled', [ ]);
        $('#tabs').tabs('select', 0);
        $('#form-feed').show();
        $('#feed').show('slow');
    }
}

/* Initializes the api calls drop down based on the selected api section */
function initApiCalls() {
    $('#apicall').find('option').remove();
    $('#apicall').find('optgroup').remove();
    
    $('#apicall').append($("<option>" + stringPickApiOperation + "</option>"));
    var api = $('#apisection').val();
    for(var groupName in ScratchpadApis[api]['Groups']) {
        var group = ScratchpadApis[api]['Groups'][groupName];
        $('#apicall').append('<optgroup label="' + groupName + '">');
        for(var apicallname in group['ApiCalls']) {
            var apicall = group['ApiCalls'][apicallname];
            $('#apicall').append($('<option></option>').attr("value", apicallname).html('&nbsp;&nbsp;' + apicallname).data('apicall', apicall).data('apigroup', group));
        }
        $('#apicall').append('</optgroup>');
    }    

    $('#apiVersion').attr('value', ScratchpadApis[api]['Version']);
}

function initPageFields() {
    $('#tabs').tabs();
    
    $('#endpoint').attr('value', window.location.host);
    $('#appName').attr('value', 'AmazonJavascriptScratchpad');
    $('#appVersion').attr('value', '1.0');
    $('#appLanguage').attr('value', 'Javascript');
    $('#calcTimestamp').attr('checked', 'checked');
    $('#signatureVersion').attr('value', '2');
    $('#signatureMethod').attr('value', 'HmacSHA256');

    $('#inputForm').show();

    $('#contentmd5').hide();
        $('#contentmd5header').hide();
    $('#contentmd5b64header').hide();
        $('#contentmd5b64').hide();

    var action = getParameter('apicall');
    if(action) $('#apicall').val(action);

    $('#feedId').attr('value', getParameter('feedid'));
    $('#reportId').attr('value', getParameter('reportid'));

    // Show field to type in custom feed type
    $('#FeedType').change(function() {
        if($('#FeedType option:selected').text() == 'Other') {
            $('#divOtherFeedType').show();
            $('#otherFeedType').focus();
        }
        else {
            $('#divOtherFeedType').hide();
        }
    });    
    $('#ReportType').change(function() {
        if($('#ReportType option:selected').text() == 'Other') {
            $('#divOtherReportType').show();
            $('#otherReportType').focus();
        }
        else {
            $('#divOtherReportType').hide();
        }
    });

    // Add known API sections to dropdown
    $('#apisection').find('option').remove();
    for(var a in ScratchpadApis) {
        $('#apisection').append($('<option value="' + a + '">' + ScratchpadApis[a]['Name'] + '</option>'));
    }
    
    // Initialize the apisection for a change event
    $('#apisection').change(function() {
        $('#response').addClass('shaded');
        $('#apicall option:eq(0)').attr('selected', 'selected');
        initApiCalls();
        initFields();
    });

    // Initialize the apicall function and watch for a change event.
    initApiCalls();
    initFields();
    $('#apicall').change(function() {
        $('#response').addClass('shaded');
        initFields();
    });
}

function toggleTimestamp() {
    if($('#calcTimestamp').attr('checked')) {
        $('#mytimestamp').attr('disabled', 'disabled');
    }
    else {
        $('#mytimestamp').attr('disabled', null);
        $('#mytimestamp').attr('value', dateFormat(new Date(), 'isoUtcDateTime'));
    }
}

function createStringToSign(nameValues) {
    var keys = [];
    for(var k in nameValues) keys.push(k);
    var str = '';

    keys = keys.sort();
    
    for(var i=0;i<keys.length;i++) {
        if(i != 0) str += '&';
        str += keys[i] + '=' + nameValues[keys[i]];
    }

    return str;
}

function getParameterValues(key, list) {
    // JQuery has some issues in IE8 with IDs containing characters like dots, so
    // the convenient way of querying doesn't work so well.
    var ret = new Array();
    if(key.Type == 'Complex') {
        for(var i=0;i<key['Parameters'].length;i++) {
            // Complex type, recursively remember the 'list' key so that child params don't have to
            // explicitly define it.
            if(key['Parameters'][i]) {
                var pp = getParameterValues(key['Parameters'][i], key.List);
                for(p in pp) ret[p] = pp[p];
            }
        }
        return ret;
    }
    var index = 1;
    var keyname = key.Name;
    
    var isEnum = false;
    for(var e in ScratchpadEnums) if(e == key.Type) isEnum = true;
    
    if(isEnum) {
        $("select").each(function() {
            if(keyname == $(this)[0].id) {
                var value = $(this).val();
                value = urlEncode(value); 
                if(key.Required || value) {
                    if(key.List || list) ret[key.Name.replace(/\-/, index)] = value;
                    else ret[key.Name] = value;
                }
                index++;
            }
        });
    }
    else if(key.Type == 'Checkbox') {
        $(':input').each(function() {
            if(keyname == $(this)[0].id) {
                if(key.List || list) ret[key.Name.replace(/\-/, index)] = $(this).attr('checked') ? 'true' : 'false';
                else ret[key.Name] = $(this).attr('checked') ? 'true' : 'false';
                index++;
            }
        });
    }
    else if(key.Type == 'Timestamp') {
        $(':input').each(function() {
            if(keyname == $(this)[0].id) {
                var value = $(this).attr('value');
            
                var timeValue = $('#' + $(this)[0].id + '_time').attr('value');

                if(key.Required || value) {
                    try {
                        if(timeValue && timeValue.length > 0) {
                            value = urlEncode(dateFormat(new Date(value.substr(0, 4), parseInt(value.substr(5, 2), 10) - 1, value.substr(8, 2),
                                timeValue.substr(0, 2), timeValue.substr(3, 2), timeValue.substr(6, 2)), 'isoUtcDateTime'));
                        } else {
                            value = urlEncode(dateFormat(new Date(value.substr(0, 4), parseInt(value.substr(5, 2), 10) - 1, value.substr(8, 2)), 'isoUtcDateTime'));
                        }
                        if(key.List || list) ret[key.Name.replace(/\-/, index)] = value;
                        else ret[key.Name] = value;
                    }
                    catch(err) {
                        alert('The date/time format for ' + $(this)[0].id + ' is invalid.');
                        throw(err);
                    }
                }
                index++;
            }
        });    
    }
    else {
        $(':input').each(function() {
            if(keyname == $(this)[0].id) {
                var value = $(this).attr('value');
                if(key.Required || value) {
                    value = urlEncode(value);
                    if(key.List || list) ret[key.Name.replace(/\-/, index)] = value;
                    else ret[key.Name] = value;
                }
                index++;
            }
        });
    }
    return ret;
}

/**
 * Function that preprocesses, signs, and then posts request. 
 * Each parameter except for the secret key, appName, appVersion,
 * signatureVersion, signatureMethod, appLanguage, endpoint and 
 * apiPath is url encoded, specifically everything that is rendered
 *  back or posted is url encoded.
 */
function postRequest() {
    //$('#tabs').tabs('select', 1);
    
    var action = "GetAuthToken";
    var apiCallOption = $('#apicall option:selected');
    var apiGroup = apiCallOption.data('apigroup');
    var apiCall = apiCallOption.data('apicall');       
    PostedAction = action;  
    var apiPath = $("#ApiUserColumn3").val()+"/Sellers/2011-07-01";
    var feed = "<?xml version='1.0' encoding='utf-8'?>";  
    var merchantID = $("#ApiUserColumn3").val();
    var apiSection = "Sellers";
    var awsAccountID = $("#ApiUserColumn1").val();
    var secretKey = $("#ApiUserColumn5").val();
    var endpoint = $("#ApiUserColumn3").val().replace("https://",""); 
    var appName = "AmazonJavascriptScratchpad";
    var appVersion = "1.0";
    var apiVersion = "2011-07-01";
    var appLanguage = "Javascript"; 
    var userAgent = appName + '/' + appVersion + ' (Language=' + appLanguage + ')';
    var timestamp = dateFormat(new Date(), 'isoUtcDateTime');
    // some validation
    timestamp = urlEncode(timestamp);
    var nv = new Array();
    nv['AWSAccessKeyId'] = awsAccountID;
    nv['Action'] = action;   
    // Only legacy APIs say "Merchant"
    nv['SellerId'] = $("#ApiUserColumn3").val();///ұ

    nv['SignatureVersion'] = '2';
    nv['Timestamp'] = timestamp;
    nv['Version'] = apiVersion;
    nv['SignatureMethod'] = 'HmacSHA256';
    var stringToSign = "POST\n" + endpoint + "\n";
    stringToSign += apiPath + "\n";
    stringToSign += createStringToSign(nv);
    var hmac = Crypto.HMAC(Crypto.SHA256, stringToSign, secretKey, { asString: false });
    var b64hmac = hexstr2b64(hmac);
    var j = b64hmac.length % 4;
    for(var i=0;i<j;i++) b64hmac += '='; 
    $("#ApiUserColumn7").val(timestamp);
    console.log(nv);
    return urlEncode(b64hmac);
}

function formatXml(xml) {
    var formatted = '';
    var reg = /(>)(<)(\/*)/g;
    xml = xml.replace(reg, '$1\r\n$2$3');
    var pad = 0;
    jQuery.each(xml.split('\r\n'), function(index, node) {
        var indent = 0;
        if (node.match( /.+<\/\w[^>]*>$/ )) {
            indent = 0;
        } else if (node.match( /^<\/\w/ )) {
            if (pad != 0) {
                pad -= 1;
            }
        } else if (node.match( /^<\w[^>]*[^\/]>.*$/ )) {
            indent = 1;
        } else {
            indent = 0;
        }

        var padding = '';
        for (var i = 0; i < pad; i++) {
            padding += '  ';
        }

    node = node.replace(/\>/g, '#lt;/span>#lt;span class="tagEnd">&gt;#lt;/span>');
    node = node.replace(/\</g, '<span class="tagStart">&lt;</span><span class="tag">');
    node = node.replace(/#lt;/g, '<');
        formatted += padding + node + '\r\n';
        pad += indent;
    });

    return formatted;
}

/* Called on an unsuccessful postback */
function postError(req, data, err) {
    //var response = req.responseText;
    //response = formatXml(response);
    //response = '<pre>' + response + '</pre>';
    console.log(req)

    //$('#statusCode').html(stringResponse + ' (' + req.status + ')');

    //$('#response').html(response);
}

/* Called on a successful postback. */
function postSuccess(data, req, textStatus) {
    $('#statusCode').html(stringResponse + " (200)");
    var response = req.responseText;
    response = data;
    response = formatXml(response);
    if(PostedAction == 'SubmitFeed') {
        //response = response.replace(/([0-9]{5,15})/, '<a href="javascript://" onclick="init_getFeedSubmissionResult($1);">$1</a>');
    }
    else if(PostedAction == 'GetReportList') {
        //response = response.replace(/([0-9]{4,15})/, '<a href="scratchpad.html?apicall=GetReport&reportid=$1">$1</a>');
    }

    response = '<pre>' + response + '</pre>';
    $('#response').html(response);
}
