﻿$(function () {
    //加载站点地图
    SiteMaps();

    //左侧菜单栏效果
    $("#WebLeftTree > ul > li").each(function (i, node1) {
        $(node1).click(function () {
            $("#WebLeftTree > ul > li").each(function (k, node2) {
                if ($(node2).hasClass("open") && i != k)
                    $(node2).toggleClass("open").find("ul").slideToggle(200);
            });

            $(node1).toggleClass("open").find("ul").slideToggle(200);
        });
    });

    //展开或隐藏左侧菜单    
    var wbefore = "210px";
    var wafter = "35px";
    var wtime = 500;

    var l = $('#MainLeft');
    var r = $('#MainRight');
    var c = $('#MainTags');
    var t = $('#MainTop');
    var lt = $("#WebLeftTop");

    $("#WebLeftTop").click(function () {
        if (l.css('width') == wafter) { //展开
            l.animate({ width: wbefore }, wtime);
            r.animate({ left: wbefore }, wtime);
            c.animate({ left: wbefore }, wtime);
            t.animate({ left: wbefore }, wtime);
            window.setTimeout(function () {
                lt.find("i").attr("class", "icon-double-angle-left");
                $("#WebLeftTree .arrow").show();
            }, wtime);
        } else {    //隐藏
            l.animate({ width: wafter }, wtime);
            r.animate({ left: wafter }, wtime);
            c.animate({ left: wafter }, wtime);
            t.animate({ left: wafter }, wtime);
            window.setTimeout(function () {
                lt.find("i").attr("class", "icon-double-angle-right");
                $("#WebLeftTree .arrow").hide();
            }, wtime);
        };
    });

    /* 新建标签栏 */
    $("#WebLeftTree ul ul li a").each(function (i) {
        $(this).click(function () {
            AddTags(this, (i + 1));
            return false;
        });
    });
    /* 默认选中标签 点击事件 */
    $("#tagsdef").click(function () {
        ActiveTags("def");
    });
    $("#pwd").click(function () {
        AddTags(this, "pwd");
        return false;
    });

    //加载多语言
    GetLanguage();
});

//加载站点地图导航
function SiteMaps() {
    $.ajax({
        type: "get",
        dataType: "json",
        url: "dataajax.aspx?stype=json&type=sitemaps" + "&r=" + Math.random(),
        async: false,
        beforeSend: function (XMLHttpRequest) { },
        success: function (data) {
            var html = "";
            for (var i = 0; i < data.json.length; i++) {
                if (data.json[i].parent == "true") {
                    if (data.json[i].show == "true")
                        html += "<li class='open' >";
                    else
                        html += "<li>";

                    html += "<a class='dropdown-toggle'><i class='" + data.json[i].ico + "'></i>";
                    html += "<span class='menu-text'>" + data.json[i].text + "</span><b class='arrow icon-angle-down'></b></a>";

                    if (data.json[i].show == "true")
                        html += "<ul style='display:block;' >";
                    else
                        html += "<ul>";

                    if (i < data.json.length - 1)
                        i++;
                    while (!(data.json[i].parent == "true")) {
                        html += "<li>";
                        html += "<a href=\"datapage.aspx?type=" + data.json[i].parm + "\">";
                        html += "<i class='icon-double-angle-right'></i>";
                        html += "<span>" + data.json[i].text + "</span>";
                        html += "</a></li>";
                        if (i < data.json.length - 1)
                            i++;
                        else
                            break;
                    }
                    i--;
                    html += "</ul>";
                    html += "</li>";
                }
            }
            $("#WebLeftTree ul.nav-list").append(html);
        },
        error: function () { }
    });
}

//添加节点
function AddTags(obj, id) {
    //active  <span data-href="product-brand.html">品牌管理</span><i></i><em></em>
    //<iframe id="mainFrame" name="mainFrame" frameborder="0" src="datapage.aspx?type=syslink"></iframe>
    if (!document.getElementById("mainFrame" + id)) {
        $("#MainTags ul").append("<li id=\"tags" + id + "\" onclick=\"ActiveTags('" + id + "')\" class='active'><span>"
            + $(obj).find("span").html() + "</span><i onclick=\"DeleteTags('" + id + "')\" ></i><em></em></li>");
        $("#MainRight").append("<iframe id=\"mainFrame" + id + "\" class=\"mainFrame\" name=\"mainFrame\" frameborder=\"0\" src=\"" + $(obj).attr("href") + "\"></iframe>");
    }

    ActiveTags(id);
}

//选中节点
function ActiveTags(id) {
    if (document.getElementById("mainFrame" + id)) {
        $("#MainTags ul li").removeClass("active");
        $("#MainRight iframe").hide();
        $("#tags" + id).addClass("active");
        $("#mainFrame" + id).show();
    }
}

//移除节点
function DeleteTags(id) {
    $("#tags" + id).prev().click();
    $("#tags" + id).remove();
    $("#mainFrame" + id).remove();
    return false;
}

//退出登录
function LoginOut() { if (confirm('确定退出系统吗?')) { location.href = 'login.aspx?type=logout'; } }


//获取多语言
function GetLanguage() {
    var languageCookie = $("#languageCookie").val();
    $.ajax({
        type: "get",
        dataType: "json",
        url: "dataajax.aspx?type=languages&stype=json&r=" + Math.random(),
        async: false,
        beforeSend: function (XMLHttpRequest) { },
        success: function (data) {
            var html = "";
            $.each(data.json, function (k, obj) {
                html += "<a id='lang" + obj.Key + "' href='javascript:SetLanguage(\"" + obj.Key + "\")' class='" + (obj.On == 'True' ? "on" : "") + "' >" + obj.Value + "</a>";
                if (k + 1 < data.json.length)
                    html += "<span class='spansplit'>|</span>";
            });
            $("#TopLanguage").html(html);
        },
        error: function () { }
    });
}

//设置多语言
function SetLanguage(key) {
    $.ajax({
        type: "get",
        dataType: "html",
        url: "dataajax.aspx?type=languageset&lang=" + key + "&r=" + Math.random(),
        async: false,
        beforeSend: function (XMLHttpRequest) { },
        success: function (data) {
            $("#TopLanguage a").removeClass("on");
            $("#lang" + key).addClass("on");
            $("#MainRight iframe").each(function () {
                $(this).attr('src', $(this).attr('src'));
            });
        },
        error: function () { }
    });
}