﻿/* 
 * 分页处理显示
*/
CmsData.Pager = {
    pageIndex: CmsData.Common.QueryString("page") == "" ? 1 : Number(CmsData.Common.QueryString("page")),    //当前页码
    pageSize: CmsData.Common.QueryString("pagesize") == "" ? 20 : Number(CmsData.Common.QueryString("pagesize")),    //每页显示纪录数
    recordCount: 0,  //总纪录数
    numberCount: 9,      //数字页码显示数目
    firstText: '首页',    //首页文本
    prevText: "上一页",   //上一页文本
    nextText: "下一页",   //下一页文本
    lastText: "尾页",     //尾页文本
    customHtml: "共 %RecordCount% 纪录,每页 %PageSizeSelect% 条, 当前第 %PageIndex% / %PageCount% 页",   //自定义显示文本    
    showPager: true,         //当纪录为1页时 是否显示分页
    showCustomPageSize: true, //是否显示自定义每页纪录数
    showCustomHtml: true,    //是否显示自定义文本
    showRefurbishHtml: true,    //是否显示刷新文本
    showSelectHtml: true,    //是否显示下拉菜单文本
    showFirstLastText: true, //是否显示首页尾页文本
    showPrevNextText: true,  //是否显示上一页下一页文本
    showNumberHtml: false,   //是否显示数字页码
    pageCount: function ()  //总页数
    {
        if (CmsData.Pager.recordCount <= CmsData.Pager.pageSize)
            return 1;
        else {
            if (CmsData.Pager.recordCount % CmsData.Pager.pageSize == 0)
                return Math.floor(CmsData.Pager.recordCount / CmsData.Pager.pageSize);
            else
                return Math.floor(CmsData.Pager.recordCount / CmsData.Pager.pageSize) + 1;
        }
    },
    Render: function () {  //输出分页代码
        if (CmsData.Pager.showPager == false && CmsData.Pager.pageCount() == 1)
            return "";
        else {
            var str = "";
            str += "<div class=\"pager\" >";
            str += "<div class=\"pagerright\" >";
            str += CmsData.Pager.GetReloadHtml();
            str += CmsData.Pager.GetCustomHtml();
            str += "</div>";
            str += "<div class=\"pagerleft\" >";
            str += CmsData.Pager.GetNumberHtml();
            str += "</div>";
            str += "</div>";
            return str;
        }
    },
    PageUrlHref: function (page) {     //分页路径        
        if (page == undefined)
            page = CmsData.Pager.pageIndex;
        return "CmsData.Pager.PageUrlClick(" + page + ")"; //点击重新加载
    },
    PageUrlClick: function (page) {
        CmsData.Pager.pageIndex = page;
        CmsData.DataList();
    },
    GetCustomPageSize: function (val) {   //自定义每页纪录数 重新加载数据源
        CmsData.Pager.pageSize = val;
        CmsData.Pager.pageIndex = 1;
        CmsData.DataList();
    },
    GetReloadHtml: function () {
        if (CmsData.Pager.showRefurbishHtml == true)
            return "<a class='ico reload' href='javascript:" + CmsData.Pager.PageUrlHref() + "' ><span>&nbsp;</span></a>";
        else
            return "";
    },
    GetCustomHtml: function () {    //自定义文本
        if (CmsData.Pager.showCustomHtml == true) {
            var strselect = "";
            if (CmsData.Pager.pageCount() > 1) {
                strselect = "<select onchange='CmsData.Pager.GetCustomPageSize(this.value)' >";
                for (var i = 1; i < 6; i++) {
                    if (i * 10 == CmsData.Pager.pageSize)
                        strselect += "<option value='" + i * 10 + "' selected='selected' >" + i * 10 + "</option>";
                    else
                        strselect += "<option value='" + i * 10 + "' >" + i * 10 + "</option>";
                }
                strselect += "</select>";
            } else { strselect = "-"; }
            var str = CmsData.Pager.customHtml;

            if (CmsData.Pager.pageCount() > 1) {
                str = str.replace("%PageIndex%", CmsData.Pager.GetSelectHtml());
                str = str.replace("%PageCount%", CmsData.Pager.pageCount());
            } else {
                str = str.replace("%PageIndex%", 1);
                str = str.replace("%PageCount%", 1);
            }

            str = str.replace("%RecordCount%", "<label>" + CmsData.Pager.recordCount + "</label>");
            str = str.replace("%PageSize%", CmsData.Pager.pageSize);
            str = str.replace("%PageSizeSelect%", strselect);
            return str;
        } else
            return "";
    },
    GetNumberHtml: function () {
        var s1 = "";   //上一页
        var s2 = "";   //首页
        var s3 = "";   //尾页
        var s4 = "";   //下一页

        if (CmsData.Pager.pageCount() > 1) {
            if (CmsData.Pager.pageIndex == 1) {
                s2 = "<span>" + CmsData.Pager.firstText + "</span>";
                s1 = "<span>" + CmsData.Pager.prevText + "</span>";
                s3 = "<a href=\"javascript:" + CmsData.Pager.PageUrlHref(CmsData.Pager.pageCount()) + "\" >" + CmsData.Pager.lastText + "</a>";
                s4 = "<a href=\"javascript:" + CmsData.Pager.PageUrlHref(CmsData.Pager.pageIndex + 1) + "\" >" + CmsData.Pager.nextText + "</a>";
            }
            else if (CmsData.Pager.pageIndex == CmsData.Pager.pageCount()) {
                s1 = "<a href=\"javascript:" + CmsData.Pager.PageUrlHref(CmsData.Pager.pageIndex - 1) + "\" >" + CmsData.Pager.prevText + "</a>";
                s2 = "<a href=\"javascript:" + CmsData.Pager.PageUrlHref(1) + "\" >" + CmsData.Pager.firstText + "</a>";
                s3 = "<span>" + CmsData.Pager.lastText + "</span>";
                s4 = "<span>" + CmsData.Pager.nextText + "</span>";
            }
            else {
                s1 = "<a href=\"javascript:" + CmsData.Pager.PageUrlHref(CmsData.Pager.pageIndex - 1) + "\" >" + CmsData.Pager.prevText + "</a>";
                s2 = "<a href=\"javascript:" + CmsData.Pager.PageUrlHref(1) + "\" >" + CmsData.Pager.firstText + "</a>";
                s3 = "<a href=\"javascript:" + CmsData.Pager.PageUrlHref(CmsData.Pager.pageCount()) + "\" >" + CmsData.Pager.lastText + "</a>";
                s4 = "<a href=\"javascript:" + CmsData.Pager.PageUrlHref(CmsData.Pager.pageIndex + 1) + "\" >" + CmsData.Pager.nextText + "</a>";
            }
        }
        else {
            s2 = "<span>" + CmsData.Pager.firstText + "</span>";
            s1 = "<span>" + CmsData.Pager.prevText + "</span>";
            s3 = "<span>" + CmsData.Pager.lastText + "</span>";
            s4 = "<span>" + CmsData.Pager.nextText + "</span>";
        }

        if (CmsData.Pager.showFirstLastText == false)
            s2 = s3 = "";

        if (CmsData.Pager.ShowPrevNextText == false)
            s1 = s4 = "";

        var str = "";

        if (CmsData.Pager.showNumberHtml == true) {
            if (CmsData.Pager.pageCount() < CmsData.Pager.numberCount) {
                for (var i = 1; i <= CmsData.Pager.pageCount() ; i++) {
                    if (i == CmsData.Pager.pageIndex)
                        str += "<span>" + i + "</span>";
                    else
                        str += "<a href=\"javascript:" + CmsData.Pager.PageUrlHref(i) + "\" >" + i + "</a>";
                }
            }
            else if (CmsData.Pager.pageIndex + CmsData.Pager.numberCount / 2 > CmsData.Pager.pageCount()) {
                for (var i = CmsData.Pager.pageCount() - CmsData.Pager.numberCount + 1; i <= CmsData.Pager.pageCount() ; i++) {
                    if (i == CmsData.Pager.pageIndex)
                        str += "<span>" + i + "</span>";
                    else
                        str += "<a href=\"javascript:" + CmsData.Pager.PageUrlHref(i) + "\" >" + i + "</a>";
                }
            }
            else {
                var k = CmsData.Pager.pageIndex - CmsData.Pager.numberCount / 2 - 1;
                if (k < 0) k = 0;
                for (var i = 1; i <= CmsData.Pager.numberCount; i++) {
                    if (k + i == CmsData.Pager.PageIndex)
                        str += "<span>" + i + "</span>";
                    else
                        str += "<a href=\"javascript:" + CmsData.Pager.PageUrlHref(k + i) + "\" >" + (k + i) + "</a>";
                }
            }
        }

        return s2 + s1 + str + s4 + s3;
    },
    GetSelectHtml: function () {    //输出下拉框
        if (CmsData.Pager.showSelectHtml == true) {
            if (document.getElementById("DataList")) {
                var str = "";
                var str = "<select onchange=\"" + CmsData.Pager.PageUrlHref("this.value") + "\"  >";
                for (var i = 1; i <= CmsData.Pager.pageCount() ; i++) {
                    if (i == CmsData.Pager.pageIndex)
                        str += "<option value=\"" + i + "\" selected=\"selected\" >" + i + "</option>";
                    else
                        str += "<option value=\"" + i + "\" >" + i + "</option>";
                }
                str += "</select>";
                return str;
            }
            else
                return "1";
        } else
            return "";
    }
};