﻿/*
    上传图片
*/
CmsData.UpFiles = {
    Init: function () { //初始加载
        $(".swfupload").each(function () {
            CmsData.UpFiles.InitImage(this.id);
        });

        $(".swfuploads").each(function () {
            CmsData.UpFiles.InitImages(this.id);
        });
    },
    InitImage: function (id) {    //单张图片 初始化事件
        var src = $("#" + id).val();
        if (src != "")
            CmsData.UpFiles.ShowImage(id, src);
    },
    ShowImage: function (id, src) { //单张图片 加载显示
        if (src != "") {
            var srcd = CmsData.UpFiles.ImageName(src, id);
            $("#divimage" + id).html('<a href="' + srcd + '" target="_blank" ><img src="' + srcd + '" /></a>');
        }
    },
    InitImages: function (id) { //多张图片 初始化事件
        var src = $("#" + id).val();
        if (src != "") {
            var table = src.split(',');
            $("#divimages" + id).html("");
            for (var i = 0; i < table.length; i++) {
                CmsData.UpFiles.ShowImages(id, table[i]);
            }
        }
    },
    ShowImages: function (id, src) {    //多张图片 加载显示
        if (src != "") {
            var str = "";
            str += '<div class="filelist" >';
            str += '<a href="' + CmsData.UpFiles.ImageName(src, id) + '" target="_blank" class="filelistimg" >';
            str += '<img src="' + CmsData.UpFiles.ImageNameThumbs(src, id) + '" /></a>';
            str += "<input type='hidden' value='" + src + "' />";
            str += "<a class='upico icon' title='上移' onclick=\"CmsData.UpFiles.SortUp('" + id + "',this)\" >上移</a>";
            str += "<a class='downico icon' title='下移' onclick=\"CmsData.UpFiles.SortDown('" + id + "',this)\" >下移</a>";
            str += "<a class='delico icon' title='移除' onclick=\"CmsData.UpFiles.FileRemove('" + id + "',this)\" >移除</a>";

            var k = $("#divimages" + id).children(".filelist").length + 1;
            var index = Number($("#" + id + "Index").val());
            if (index == 0)
                index = 1;

            if (k == index)
                str += "<a class='defaultico' title='默认图' >默认图</a>";
            else
                str += "<a class='defaulticoset' title='默认图' onclick=\"CmsData.UpFiles.SelectDefaultIndex('" + id + "'," + k + ")\" >点此设为默认图</a>";

            str += '</div>';
            $(str).appendTo($("#divimages" + id));
        }
    },
    SortUp: function (id, obj) {  //向上移动
        if ($(obj).parent().prev().html() != null) {
            $(obj).parent().insertBefore($(obj).parent().prev());
            CmsData.UpFiles.LoadImagesValue(id);
        }
    },
    SortDown: function (id, obj) {  //向上移动
        if ($(obj).parent().next().html() != null) {
            $(obj).parent().insertAfter($(obj).parent().next());
            CmsData.UpFiles.LoadImagesValue(id);
        }
    },
    DeleteImage: function (id) {  //单张图片 删除事件
        var val = $("#" + id).val();
        if (confirm("确定删除当前选中文件?此操作不可恢复!")) {
            if (val.indexOf("http://") == -1) {
                $.ajax({
                    type: "get",
                    dataType: "html",
                    async: false,
                    url: "dataajax.aspx?type=imagesdelete&val=" + escape(val) + "&r=" + Math.random(),
                    beforeSend: function (XMLHttpRequest) { },
                    success: function (data) {
                        $("#" + id).val("");
                        $("#divimage" + id).html("");
                    },
                    error: function () { }
                });
            } else {
                $("#" + id).val("");
                $("#divimage" + id).html("");
            }
        }
    },
    DeleteImages: function (id) { //多张图片 删除事件
        var val = $("#" + id).val();
        if (confirm("确定清空当前图片?此操作不可恢复!")) {
            $.ajax({
                type: "get",
                dataType: "html",
                async: false,
                url: "dataajax.aspx?type=imagesdelete&val=" + escape(val) + "&r=" + Math.random(),
                beforeSend: function (XMLHttpRequest) { },
                success: function (data) {
                    $("#" + id).val("");
                    $("#divimages" + id).html("");
                },
                error: function () { }
            });
        }
    },
    FileRemove: function (id, obj) {  //移除文件
        if (confirm("是否删除当前图片?此操作不可恢复!")) {
            var val = $(obj).parent().find("input[type=hidden]").val();
            if (CmsData.UpFiles.IsHttp(val) == false) {
                $.ajax({
                    type: "get",
                    dataType: "html",
                    async: false,
                    url: "dataajax.aspx?type=imagesdelete&val=" + escape(val) + "&r=" + Math.random(),
                    beforeSend: function (XMLHttpRequest) { },
                    success: function (data) {
                        $(obj).parent().remove();
                        CmsData.UpFiles.LoadImagesValue(id);
                    },
                    error: function () { }
                });
            } else {
                $(obj).parent().remove();
                CmsData.UpFiles.LoadImagesValue(id);
            }
        }
    },
    SelectDefaultIndex: function (id, k) {   //文件选中 设为默认图片
        $("#" + id + "Index").val(k);
        CmsData.UpFiles.InitImages(id);
    },
    LoadImagesValue: function (id) {	//重新加载值
        var f = "";
        $("#divimages" + id + " .filelist").each(function () {
            f += $(this).find("input[type=hidden]").val() + ",";
        });

        $("#" + id).val(f);
    },
    OpenImage: function (id) {    //打开单张图片上传文本框
        if (CmsData.Common.TransIsExists(id) == false) {
            var html = "<div id=\"Trans" + id + "Image" + "\"class='transCenter transImage' style='height:80px;overflow-y:auto;' >";
            html += "<div>";
            html += "<span class=\"spanaddimage\">图片地址：</span>"
            html += "<input id=\"" + id + "1" + "\" type=\"text\" class=\"inputtext w400\" value=\"\" />";
            html += "</div>";
            html += "</div>";
            html += "<div class='transBottom' >";
            html += "<input type=\"button\" class=\"btn btnsure\" value=\" 确 定 \" onclick=\"CmsData.UpFiles.ClickImage('" + id + "')\" />";
            html += "<input type=\"button\" class=\"btn btnclose\" value=\" 取 消 \" onclick=\"CmsData.Common.TransToggle('" + id + "')\" />";
            html += "</div>";
            CmsData.Common.TransCreate("远程图片(输入图片地址，站内可用相对地址)", id, "width:650px;left:100px;top:150px; position:fixed;", 2, html);
        }
        $("#" + id + "1").val($("#" + id).val());
        CmsData.Common.TransToggle(id);
    },
    OpenImages: function (id) {    //打开多张图片上传文本框
        if (CmsData.Common.TransIsExists(id) == false) {
            var html = "";
            html += "<div id=\"Trans" + id + "Images" + "\" class='transCenter transImage' style='height:250px;overflow-y:auto;' >";
            html += "<div>";
            html += "<span class=\"spanaddimage\">图片地址1：</span>"
            html += "<input id=\"" + id + "1" + "\" type=\"text\" class=\"inputtext w400\" value=\"\" />";
            html += "<input type=\"button\" class=\"btnaddimage\" value=\"添加新地址\" onclick=\"CmsData.UpFiles.AddImagesNode('" + id + "')\" />";
            html += "</div>";
            html += "</div>";
            html += "<div class='transBottom' >";
            html += "<input type=\"button\" class=\"btn btnsure\" value=\" 确 定 \" onclick=\"CmsData.UpFiles.ClickImages('" + id + "')\" />";
            html += "<input type=\"button\" class=\"btn btnclose\" value=\" 取 消 \" onclick=\"CmsData.Common.TransToggle('" + id + "')\" />";
            html += "</div>";
            CmsData.Common.TransCreate("远程图片(输入图片地址，站内可用相对地址)", id, "width:650px;left:100px;top:150px; position:fixed;", 2, html);
        } else {
            $("#Trans" + id + "Images div").each(function (i) {
                if (i > 0)
                    $(this).remove();
            });
        }

        var src = $("#" + id).val();    //这边多图片应该重新初始化
        var sp = src.split(',');
        var len = sp.length;
        $("#" + id + "1").val(sp[0]);
        if (len > 1) {
            for (var i = 2; i <= len; i++) {
                if (sp[i - 1] != "") {
                    CmsData.UpFiles.AddImagesNode(id);
                    $("#" + id + i).val(sp[i - 1]);
                }
            }
        }

        CmsData.Common.TransToggle(id);
    },
    AddImagesNode: function (id) {
        var len = $("#Trans" + id + "Images div").length + 1;
        var html = "";
        html += "<div id=\"div" + id + len + "\" >";
        html += "<span class=\"spanaddimage\">图片地址" + len + "：</span>"
        html += "<input id=\"" + id + len + "\" type=\"text\" class=\"inputtext w400\" value=\"\" />";
        html += "<input type=\"button\" class=\"btndeleteimage\" value=\"删除\" onclick=\"CmsData.UpFiles.RemoveImagesNode('" + id + "','" + len + "')\" />";
        html += "</div>";
        $(html).appendTo($("#Trans" + id + "Images"));
    },
    RemoveImagesNode: function (id, node) {
        $("#div" + id + node).remove();
    },
    ClickImage: function (id) { //单张远程图片确定
        $("#" + id).val($("#" + id + "1").val());
        CmsData.UpFiles.InitImage(id);
        CmsData.Common.TransToggle(id);
    },
    ClickImages: function (id) { //多张远程图片确定
        var src = "";
        $("#Trans" + id + "Images input[type=text]").each(function (i) {
            if ($(this).val() != "")
                src += $(this).val() + ",";
        });
        $("#" + id).val(src);
        CmsData.UpFiles.InitImages(id);
        CmsData.Common.TransToggle(id);
    },
    IsHttp: function (src) {
        return (src.indexOf("http://") > -1 || src.indexOf("https://") > -1);
    },
    ImageName: function (src, id) { //返回显示图片地址
        if (CmsData.UpFiles.IsHttp(src) == false)
            src = $("#" + id + "Domain").val() + src;
        return src;
    },
    ImageNameThumbs: function (src, id) {   //返回显示缩略图片地址
        if (CmsData.UpFiles.IsHttp(src) == false) {
            src = src.substring(0, src.lastIndexOf("/") + 1) + "_thumbs" + src.substring(src.lastIndexOf("/") + 1, src.length);
            src = $("#" + id + "Domain").val() + src;
        }
        return src;
    }
};