﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ExtractFiles.aspx.cs" Inherits="Webdisk.ExtractFiles" %>

<%@ Register TagPrefix="uc" TagName="uc1" Src="~/Top.ascx" %>
<%@ Register TagPrefix="uc" TagName="uc2" Src="bottom.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <script src="js/jquery-1.7.1.min.js" type="text/javascript"></script>
    <link href="css/common.css" rel="stylesheet" type="text/css" />
	<link rel="stylesheet" type="text/css" href="themes/default/easyui.css"/>
    <script src="js/jquery.easyui.min.js" type="text/javascript"></script>
    <title>提取文件</title>
    <script type="text/javascript">
        function btnPick_click() {
            var code = $("#code").val();
            if (code == undefined || code == "undefined" || code == "") {
                alert("请输入提取码！");
                return false;
            }
            CheckCode(code);
        }
        //检查提取码是否有效
        function CheckCode(code) {
            $.ajax({
                type: "post",
                contentType: "application/json;utf-8",
				cache:false,
                url: "FileSpaceHandler.ashx?cmd=ExistsFileByPickCode&pickcode=" + code,
                success: function (data) {
                    if (data == "true") {
                        $("#pickFile").attr("style","clear:both");
                        loadPickCodeFile();
                    }
                    else if (data == "false") {
                        alert("提取码已过期或文件不存在！");
                        return false;
                    }
                    else {
                        alert("文件不存在！");
                        return false;
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    alert("错误:" + XMLHttpRequest.responseText);
                    return false;
                }
            });
        }
    </script>
</head>
<body>
    <!-- Header Start -->
    <div>
        <uc:uc1 ID="top" runat="server" />
    </div>
    <!-- Header End -->
    <!-- Content Start -->
    <div class="content">
        <div class="block01 mt30">
            <div class="upload" id="pickCode">
                <ul>
                    <li>
                        <h2>
                            提取文件</h2>
                    </li>
                    <li>
                        <input class="input_1" name="" id="code" runat="server" type="text" /><input class="but_1" value="提取文件" name=""
                            type="button" id="btnPick" runat="server" onclick="btnPick_click()" /></li>
                </ul>
                <p>
                    <img src="images/img_02.png" /></p>
            </div>
            <div id="pickFile">
                <table width="100%" class="fileTab" id="pickFileDG" border="0" cellspacing="0" cellpadding="0">
                </table>
            </div>

        </div>
    </div>
    <!-- Content End -->
    <!-- Footer Start -->
    <div id="foot">
        <div class="foot">
            <uc:uc2 ID="bootom" runat="server" />
        </div>
    </div>
    <!-- Footer End -->
</body>
</html>
<script type="text/javascript">
    setHeadMenu(4);
    function loadPickCodeFile() {
        $("#pickFileDG").css("height", $("#pickCode").height() + "px");
        window.setTimeout(
        function() {
            $("#pickFileDG").datagrid({
                title: "以下是您提取的文件，请点击文件名下载！",
                loadMsg: "数据加载中，请稍后……",
                nowrap: false,
                striped: true,
                showHeader:true,
                showFooter: true,
                url: 'FileSpaceHandler.ashx?cmd=GetPickList&pickcode=' + $("#code").val(),
                pageList: [10, 15, 20, 25, 30, 40, 50],
                pageSize: 20,
                sortName: 'lasttime',
                sortOrder: 'desc',
                remoteSort: true,
                fitColumns: true,
                idField: 'id',
                columns: [[
                        { field: 'kind', title: '分类', width: 150, align: 'center', fixed: true, sortable: true},
                        { field: 'FileName', title: '文件名称', width: 200, align: 'left', sortable: true,
                            styler: function (value, row, index) {
                                return ""; 
                            }
                        },
                        { field: 'downcount', title: '下载量', width: 50, align: 'center', sortable: true},
                        { field: 'lasttime', title: '上传时间', width: 100, align: 'center', sortable: true },
                        { field: 'FileSize', title: '文件大小', width: 50, align: 'center', sortable: true }
                ]],
                rowStyler: function () {
                    return "tdList";
                },
                pagination: true,
                rownumbers: true,
                onLoadSuccess: function () {
                }
            });
            $("#pickFileDG").datagrid("getPager").pagination({
                beforePageText: '第', //页数文本框前显示的汉字  
                afterPageText: '页    共 {pages} 页',
                displayMsg: '当前显示从第{from}条到{to}条 共{total}条记录',
                onBeforeRefresh: function (pageNumber, pageSize) {
                    $(this).pagination('loading');
                    $(this).pagination('loaded');
                }
            });
        }, 100);
    }
</script>
