﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="FileSpaceLayout.aspx.cs"
    Inherits="Webdisk.FileSpaceLayout" %>
<%@ Import Namespace="Webdisk.DAL" %>
<%@ Register Src="Top.ascx" TagName="top" TagPrefix="uc1" %>
<%@ Register Src="bottom.ascx" TagName="bottom" TagPrefix="uc2" %>
<!DOCTYPE html>
<html >
<head runat="server">
    <link href="themes/default/easyui.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" type="text/css" href="themes/icon.css" />
    <link href="css/demo.css" rel="stylesheet" type="text/css" />
    <link href="css/common.css" rel="stylesheet" type="text/css" />
    <link rel="stylesheet" href="js/artDialog/css/ui-dialog.css" />

    <script src="js/jquery-1.7.1.min.js" type="text/javascript"></script>
    <script src="js/artDialog/dist/dialog-plus.js" type="text/javascript"></script>
    <script src="js/jquery.easyui.min.js" type="text/javascript"></script>
    <script src="js/jquery.pagination.js" type="text/javascript"></script>
    <script src="js/jquery.zclip.min.js" type="text/javascript"></script>
    <script src="js/FileSpaceMng.js" type="text/javascript"></script>
    <script src="js/Common.js" type="text/javascript"></script>
		<link href="css/jquery.datepick.css" type="text/css" rel="stylesheet">
	    <script src="js/jquery.plugin.min.js" type="text/javascript"></script>
	    <script src="js/jquery.datepick.min.js" type="text/javascript"></script>
    <title> <%=title%></title>
</head>
<body>
    <uc1:top ID="top" runat="server" />
    <div class="content">
		<table class="menuTab">
			<tr>
				<td class="menuBox"  valign="top">
					<!-- 树状菜单 -->
					<link rel="stylesheet" href="css/treeview.css" />
					<script src="js/treeview.js" type="text/javascript"></script>
					<div class="menuTop"><a href="#">隐藏菜单</a></div>
					<div class="menu">
						<div id="sidetreecontrol" class="menuBut"><a href="?#" class="close">收起</a><a href="?#" class="open">展开</a></div>
					<ul id="tree" class="treeview">
                      <%=template.getMenu("spaceMenu", Session["usernam e"] == null ? "" : Session["username"].ToString())%>
					 </ul>
				  </div>
				</td>
			<td class="tabClose" width="20">显示菜单</td>
			<td width="10"></td>
			<td  valign="top" id="wdContent" width="810" style="background:#fff;border: 1px solid #eee;">
				
			</td>
			</tr>
			</table>
	</div>
	<uc2:bottom ID="bottom" runat="server" />
    <input type="hidden" value="" id="hid" runat="server" />
</body>
</html>
<script type="text/javascript">
	$.datepick.setDefaults({prevText:"上月",todayText :"今天",clearText:"清除",nextText:"下月",closeText:"关闭",dateFormat :"yyyy-mm-dd",dayNamesMin :["日","一","二","三","四","五","六"],
	monthNames:["一月","二月","三月","四月","五月","六月","七月","八月","九月","十月","十一月","十二月"]});
    setHeadMenu(6);
	var sessionUser = '<%=Session["username"] == null ? "" : Session["username"].ToString()%>';
    $(function () {
		initTree();
        $("#tree .link").live("click",function () {
            var href = $(this).data("href");
            
            if (href != "") {
               getHtml(href);

            }
        });
		getHtml("right.aspx");
		$(".menuTop").click(function(){
			$(".menuBox").hide();
			$(".tabClose").show();
		});
		$(".tabClose").click(function(){
			$(".tabClose").hide();
			$(".menuBox").show();
		});
    });
	function initTree(){
		$("#tree").treeview({
		  collapsed: true,
		  animated: "medium",
		  control:"#sidetreecontrol",
		  persist: "location"
		});
	}
		function getHtml(href){
			//var d = dialog();
			var tag = $("#wdContent");
			$("#wdContent").attr("src", href);
			$.ajax({
                    url: href,
                    dataType: "html",
                    type: "GET",
                    cache:false,
                    beforeSend: function () {
                       // d.show();
                    },
                    success: function (data) {
                      //  d.close().remove() ;
                        tag.empty().html(data);
                    }
                })
		
		}
	function getTree(){
		$.ajax({
			url:'FileSpaceLeftTree.aspx?user='+sessionUser,
			dataType:"html",
			type:"GET",
			cache:false,
			success : function(data){
				$("#tree").empty().append(data);
				initTree();
			}
		});
	
	}
</script>
