﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="RelevanceSearchList.aspx.cs" Inherits="Webdisk.RelevanceSearchList" %>

<head runat="server">
    <title></title>
    <link rel="stylesheet" type="text/css" href="themes/icon.css" />
    <link href="themes/default/easyui.css" rel="stylesheet" type="text/css" />
    <script src="js/jquery-1.7.1.min.js" type="text/javascript"></script>
    <script src="js/easyloader.js" type="text/javascript"></script>
    <link href="css/demo.css" rel="stylesheet" type="text/css" />
    <script src="js/Common.js" type="text/javascript"></script>
</head>
<body>
    <div class="menuBlock">
	<div title="关联" style="padding:2px;" id="009999" >
             <div id="divSearchMyFile" class="easyui-panel" title="" data-options="border:false,fit:true"  style="overflow-x:hidden; overflow-y:auto">
                <div id="divSearchReleance" style="overflow-y:auto; overflow-x:hiddne"></div>
            </div>
		</div>
    </div>
</body>
<script language="javascript" type="text/javascript">
    $(function () {
        $("#divSearchMyFile").css("width", common.PageWidth());
        $("#divSearchMyFile").css("height", common.PageHeight()-100);
        var userName = '<%=strUserName %>';
        var fileName=escape('<%=strFileName %>');
        using(['datagrid','messager', 'pagination'], function () {
            $('#divSearchReleance').datagrid({
                title: '',
                loadMsg: "数据加载中，请稍后……",
                nowrap: true,
                striped: true,
                collapsible: true,
                rownumbers: true,
                showFooter: true,
                striped: true,
                fitColumns: true,
                url: 'RelevanceHandler.ashx?cmd=GetAllpathByUser&username=' + userName,
                queryParams: {
                    filename:fileName,
		            size1:'<%=Request["size1"]==null?"":Request["size1"].ToString() %>',
		            size2:'<%=Request["size2"]==null?"":Request["size2"].ToString() %>',
                    time1:'<%=Request["time1"]==null?"":Request["time1"].ToString() %>',
                    time2:'<%=Request["time2"]==null?"":Request["time2"].ToString() %>',
                    type:'<%=Request["type"]==null?"":Request["type"].ToString() %>'
	            },
                pageList: [10, 15, 20, 25, 30, 40, 50],
                pageSize: 10,
                pagination: true,
                sortName: 'FileName',
                sortOrder: 'asc',
                remoteSort: false,
                idField: 'id',
                columns: [[
                    { field: 'ck', checkbox: 'true', align: 'center', width: '30' },
                    { field: 'FileName', title: '文件名', align: 'left', width: 400, fixed: true, sortable: true },
                    {
                        field: 'FileSize', title: '大小', width: 80, align: 'center', sortable: true,
                        formatter: function (value, row, index) {
                            if (value > 1073741824)
                                return Math.round(value / 1073741824, 2) + "GB";
                            else if (value > 1048576)
                                return Math.round(value / 1048576, 2) + "MB";
                            else if (value > 1024)
                                return Math.round(value / 1024) + " KB";
                            else return "0 KB";
                        }
                    },
                    { field: 'FileExt', title: '文件类型', width: 80, align: 'center', sortable: true },
                    { field: 'UserName', title: '所属用户', width: 80, align: 'center', sortable: true }
                ]],
                pagination: true,
                rownumbers: true,
                toolbar: [
                 {
                     id: 'btnadd',
                     text: '确定关联',
                     iconCls: 'icon-add',
                     handler: function () {
                         var ids = getSelections();
                         if (ids == '') {
                             $.messager.alert('提示消息', '请选择要关联的数据！', 'info');
                         } else {
                             $.messager.confirm('提示消息', '确定要关联所选数据吗？', function (r) {
                                 if (r) {
                                     $('#processWindow').window('open', 'aadasdsads');
                                     $.ajax({
                                         url: "RelevanceHandler.ashx?cmd=save&sourid="+<%=strID %>+"&ids=" + ids,
                                         type: 'post',
										 cache:false,
                                         datatype: 'text',
                                         success: function (returnValue) {
                                             if (returnValue) {
                                                $.messager.show({
	                                                title:'提示消息',
	                                                msg:'关联成功！',
	                                                timeout:2000,
	                                                showType:'slide'
                                                });
                                                window.parent.parent.reloadFile();
                                             }
                                         }
                                     });
                                 }
                             });
                         }
                     }
                 }
                ]

            });
            $("#divSearchReleance").datagrid("getPager").pagination({
                beforePageText: '第', //页数文本框前显示的汉字  
                afterPageText: '页    共 {pages} 页',
                displayMsg: '当前显示从第{from}条到{to}条 共{total}条记录',
                onBeforeRefresh: function (pageNumber, pageSize) {
                    $(this).pagination('loading');
                }
            });
        })
    });

    function getSelections() {
        var ids = [];
        var rows = $("#divSearchReleance").datagrid("getSelections");
        for (var i = 0; i < rows.length; i++) {
            ids.push(rows[i].id);
        }
        return ids.join(',');
    }
</script>