﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ResourceDetail.aspx.cs"
    Inherits="Webdisk.ResourceDetail" %>

<%@ Register TagPrefix="uc" TagName="uc1" Src="~/Top.ascx" %>
<%@ Register TagPrefix="uc" TagName="uc2" Src="bottom.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<%@ Import Namespace="Webdisk.DAL" %>
<%@ Import Namespace="Global" %>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link href="css/common.css" rel="stylesheet" type="text/css" />
	<link rel="stylesheet" href="js/artDialog/css/ui-dialog.css" />
    <link rel="stylesheet" href="css/treeview.css" />

	<script src="js/jquery-1.7.1.min.js" type="text/javascript"></script>
    <script src="js/artDialog/dist/dialog-plus.js" type="text/javascript"></script>
    <script src="js/treeview.js" type="text/javascript"></script>
    <title><%=strFileName%></title>
</head>
<body>
    <!-- Header Start -->
    <div>
        <uc:uc1 ID="top" runat="server" />
    </div>
    <% info.GetFile(); %>
    <!-- Header End -->
    <!-- Content Start -->
    <div class="content">
        <div class="cLeft mt30">
            <div class="block06 " style=" width: 250px;">
                <div class="title02">
                    <h4>
                        热门分类</h4>
                </div>
                <div id="sidetreecontrol" class="menuBut2 mt10">
                    <a href="?#" class="close">收起</a><a href="?#" class="open">展开</a>
                </div>
                <ul id="tree" class="mt10 ml20 treeview">
                    <%=template.getMenu("shareKind", Session["username"] == null ? "" : Session["username"].ToString()) %>
                </ul>
            </div>
        </div>
        <div class="cRight2">
            <div class="zyTitle mt50">
                <span><%=info.ViewCount %>次浏览 <%=info.DownCount %>次下载&nbsp; 鲜花(<asp:Label
                        ID="lblFlowers" runat="server" Text="" style="float:none;color:#1ea7de;"></asp:Label>) &nbsp; 
                        鸡蛋(<asp:Label ID="lblEgg" runat="server" Text="" style="float:none;color:#1ea7de;"></asp:Label>) | 上传时间：<%=info.LastTime %> </span>
                <h2 class="ico_rar" style="width:300px;">
                    <%=info.FileName %></h2>
            </div>
            <div class="zyblock">
                <ul class="zyInfo">
                    <li>所属用户：<%=info.UserName %></li>
                    <li>文件类型：<%=info.FileExt %></li>
                    <li>文件大小：<%=info.FileSize %></li>
                    <li>上传时间：<%=info.LastTime %></li>
                    <li>下载次数：<%=info.DownCount %></li>
                    <%--<li>文件注释：<%=info.Note %></li>--%>
                    <li class="mt30"><span>资源介绍：<%=info.Note %></span></li>
                </ul>
                <img src="<%=info.ImgPath %>" alt=""/>
            </div>
            <ul class="zyBut">
                <li class="zybut1"><a href="<%=info.Url %>">立即下载</a></li>
                <li class="zybut2 islikes <%=strFlowerUser %>" id="liflowers" title="<%=lblFlowers.Text %>" onclick = "setFavor(1,this)"><a href="javascript:void(0);">鲜花</a></li>
                <li class="zybut3 islikes <%=strEggUser %>" title="<%=strEggCount %>" onclick = "setFavor(0,this)"><a href="javascript:void(0);">鸡蛋</a></li>
                <li class="zybut4 ml30"><a href="#">新浪微博</a></li>
                <li class="zybut5"><a href="#">腾讯微博</a></li>
                <li class="zybut6"><a href="#">微信</a></li>
            </ul>
            <script type="text/javascript" src="http://v3.jiathis.com/code/jia.js?uid=1406254751398650" charset="utf-8"></script>
        </div>
		<input type="hidden" id="hiddenUser" value ='<%=Session["username"]==null?"":Session["username"].ToString() %>'/>  
		<input type="hidden" id="hiddenFileid" runat="server"/>  
    </div>
    <!-- Content End -->
    <!-- Footer Start -->
    <div id="foot">
        <div class="foot">
            <uc:uc2 ID="bootom" runat="server" />
        </div>
    </div>
	<script type="text/javascript">
		function setFavor(isLike,tag){
			var _user = $("#hiddenUser").val();
			var _fileid = $("#hiddenFileid").val();
			if(_user == "" ){
				alert("您没有登录系统或服务器超时，请重新登录系统！")
				location.href="login.aspx";
				return false;
			}
            if ($(tag).hasClass("disabled")) {
                alert("你已经评论！");
				return false;
			}
			$.ajax({
			    url: "ResourceHandler.ashx?cmd=FileComment",
			    data: { fileid: _fileid, comment: isLike, user: _user },
				cache:false,
			    dataType: "json",
			    type: "POST",
			    success: function (data) {
			        var html = "您" + (isLike == 0 ? "扔鸡蛋" : "送鲜花")
			        if (data.code == "0") {
			            html += "成功!";
						var sum ;
						if(isLike == "0"){
							sum = parseInt($("#lblEgg").text()) + 1 ;
							$("#lblEgg").text(sum);
							
						}else{
							sum = parseInt($("#lblFlowers").text()) + 1 ;
							$("#lblFlowers").text(sum);
						}
						$(tag).attr("title",sum);
						$(".islikes").addClass("disabled");
			        } else {
			            html += "失败！请稍后再试"
			        }
			        var d = dialog({ content: html }).showModal();
			        setTimeout(function () { d.close().remove(); }, 2000);
			    }
			});
}
    function init(Kind) {
        if (Kind != undefined)
            window.location = "shareMng.aspx?kind="+Kind;
    };
	
    $(function () {
        //树状菜单
        $("#tree").treeview({
            collapsed: true,
            animated: "medium",
            control: "#sidetreecontrol",
            persist: "location"
        });
		
		
    });
	</script>
    <!-- Footer End -->
</body>
</html>
