﻿<%@ Page Language="c#" Inherits="Install.install" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>配置数据库</title>
    <link rel="stylesheet" href="main.css" type="text/css" media="all" />
    <script type="text/javascript" src="js/jquery.js"></script>
    <link rel="stylesheet" href="js/jquery_boxy/css/common.css" type="text/css" />
    <link rel="stylesheet" href="js/jquery_boxy/css/boxy.css" type="text/css" />
    <script type="text/javascript" src="js/jquery_boxy/js/jquery.boxy.js"></script>
</head>
<body>
<div class="wrap cl">
	<h2><img alt="桃园校园文件管理系统" src="images/logo_top.png" /><cite>安装程序</cite></h2>
	<div class="nav">
        <ul>
		    <li <%if(stepNum==0){ %> class="cur"<%}else{ %> class="finish"<%} %>><span id="index">欢迎</span></li>
		    <li <%if(stepNum==1){ %> class="cur"<%}else if(stepNum>1){ %> class="finish"<%} %>><span>环境检测</span></li>
		    <li <%if(stepNum==2){ %> class="cur"<%}else if(stepNum>2){ %> class="finish"<%} %>><span>数据库配置</span></li>
		    <li <%if(stepNum==3){ %> class="cur"<%}else if(stepNum>3){ %> class="finish"<%} %>><span>设置管理员</span></li>
		    <li <%if(stepNum==4){ %> class="cur"<%}else if(stepNum>4){ %> class="finish"<%} %>><span>安装</span></li>
        </ul>
	</div>
    <%if(stepNum==0){ %>
	<div class="main cl">
		<strong>使用许可</strong><br />
　　您可以在完全遵守本最终用户授权协议的基础上，将本安装包中的软件应用于非商业用途，而不必支付费用。 <br />
　　您可以在协议规定的约束和限制范围内修改界面风格以适应您的网站要求。<br />
　　您拥有使用本软件构建的全部信息和文件的所有权，并独立承担与内容的相关法律义务。<br />
　　获得商业授权之后，您可以将本软件应用于商业用途，同时依据所购买的授权类型中确定的技术支持期限、技术支持方式和技术支持内容，自购买时刻起，在技术支持期限内拥有通过指定的方式获得指定范围内的技术支持服务。商业授权用户享有反映和提出意见的权力，相关意见将被作为首要考虑，但没有一定被采纳的承诺或保证。  <br />
<br />
<strong>授权许可</strong><br />
　　个人用户：非商业用途时可以免费使用本产品，可以将本产品经过修改后自行分发，但请保留本站标识或字样；但如个人用户使用本产品于商业用途时，需获得商业授权，视同企业用户许可准则。<br />
　　企业用户：包括任何公司、单位等经济实体，需获得商业授权后才可以使用本产品，任何企业用户如未经许可使用视为无效许可，将不具备任何使用本产品的法律效力，许可约定参见以下说明。<br />
<br />
<strong>许可约定</strong><br />
　　在获得许可的范围内，可于授权的域名内使用本程序，超过约定，将需要获得更多授权。授权用户不得经过再次修改分发本程序，用户可以在有限期限内修改以适合用户自有系统需求，授权用户可以获得关于本产品的各种支持，及应技术优先服务支持。<br />
<br />
<strong>用户限制</strong><br />
　　任何免费用户均不得删除桃源产品官方的网站链接。禁止无原作者网站信息的任何形式的二次分发，更不得利用非法二次分发获利。授权仅对单一用户有效，不得将授权信息用于其他个人或团体使用。<br />
<br />
<strong>本协议的使用规定</strong><br />
　　在您开始使用《桃源网络硬盘(校园版)》产品时，视为您已阅读并同意遵守协议书的全部条款，因此，我们对不遵守本协议造成的任何损失均不负责。作者保留追究违反本协议书的法律权利。本协议书不允许被部分引用，不允许有任何修改。<br />
<br />
<strong>本协议的终止</strong><br />
　　如果您没有遵守上述约定，则本协议将自动终止。<br />
<br />
<strong>解释权</strong><br />
　　本协议的最终解释权归属于桃源网络。您可以复制和发布这一协议书的副本，但绝对不允许对之进行任何修改。如果您不同意本协议，请您不要安装、使用本协议项下的相应软件；如果您已经开始安装或使用，则视为您完全同意本协议内的所有内容。<br />

	</div>
	<div class="btn cl">
		<a href="javascript:window.close();" class="back">退出安装</a>
		<a href="index.aspx?step=servertest" class="next">接受协议</a>
	</div></div>
    <%}else if(stepNum==1){ %>
	<div class="main cl">
		<h1>环境检测</h1>
		<div class="inner">
			<ul id="resultlist" class="list">
			</ul>
		</div>
	</div>
	<div class="btn cl">
		<a href="javascript:history.back();" class="back">上一步</a>
		<a id="nextlink" href="index.aspx?step=dbset" class="next" disabled="true">下一步</a>		
	</div>
    <script type="text/javascript">
        var resultlist = <%=testResult%>;
        var errorcount = 0;
        for (i = 0; i < resultlist.length; i++) {
            var icon, iconname;
            if (resultlist[i].result == 'true') {
                icon = 'ok';
                iconname = '成功';
            }
            else {
                icon = 'error';
                iconname = '失败';
                errorcount++;
            }
            $('#resultlist').append('<li><img src="images/' + icon + '.gif" alt="' + iconname + '"/><a href="#">' + resultlist[i].msg + '</a></li>');
        }
        if(errorcount <= 0){
            $('#nextlink').attr("disabled","");
        }
    </script>
    <%}else if(stepNum==2){ %>
    <div class="main cl">
		<h1>数据库配置</h1>
		<div class="inner">
			<form action="" method="post">
			    <table width="100%" cellspacing="0" cellpadding="0" summary="数据库配置">
			        <tbody>
			            <tr>
				            <td class="title">数据库地址:</td><td><input id="sql_ip" name="sql_ip" class="txt" type="text" value="<%=sqlServerIP %>"/></td>
			            </tr>
			            <tr>
				            <td class="title">数据库名称:</td><td><input id="sql_name" name="sql_name" class="txt" type="text" value="<%=dataBaseName %>"/><span>填写不存在的数据库名称会尝试自动创建</span></td>
			            </tr>
			            <tr>
				            <td class="title">数据库用户名:</td><td><input id="sql_username" name="sql_username" class="txt" type="text" value="<%=sqlUID %>"/></td>
			            </tr>
			            <tr>
				            <td class="title">数据库密码:</td><td><input id="sql_password" name="sql_password" class="txt" type="password" value="<%=sqlPassword %>"/></td>
			            </tr>
                    </tbody>
			    </table>
			</form>
		</div>
	</div>
	<div class="btn cl">
		<a href="javascript:history.back();" class="back">上一步</a>
		<a href="#" onclick="checkDbset();" class="next">下一步</a>		
	</div>
    <script type="text/javascript">
        var showbox;
        var alerthead = "<p style=\"width:300px;font-size:14px;\"><img src=\"../images/loading.gif\" alt=\"loading\" />";
        var createdDb = 0;
        var runstep = 0;
        var steptime = 700;

        function checkDbset() {
            var sqlip = $('#sql_ip').val();
            var sqlname = $('#sql_name').val();
            var loginname = $('#sql_username').val();
            var password = $('#sql_password').val();
            var tableprefix = $('#table_prefix').val();

            if (sqlip == "") {
                Boxy.alert('数据库地址不能为空', false, { width: 400 });
                return;
            }
            if (sqlname == "") {
                Boxy.alert('数据库名称不能为空', false, { width: 400 });
                return;
            }
            if (loginname == "") {
                Boxy.alert('数据库登录名不能为空', false, { width: 400 });
                return;
            }
            if (password == "") {
                Boxy.alert('数据库登录密码不能为空', false, { width: 400 });
                return;
            }

            showbox = new Boxy(alerthead + "正在检测数据库连接,该检测可能比较耗时,请耐心等待......</p>", { closeable: false, modal: true, center: true });

            checkDbAjax(sqlip, sqlname, loginname, password, tableprefix);
        }

        function checkDbAjax(sqlip, sqlname, loginname, password, tableprefix) {
            showbox.setContent(alerthead + "正在检测数据库连接,该检测可能比较耗时,请耐心等待......</p>");
            showbox.show();
            jQuery.get('ajax.aspx', { 't': 'checkdbconnection', 'ip': sqlip, 'name': sqlname, 'loginname': loginname, 'loginpwd': password, 'time': Math.random() },
            function (data) {
                var callback = eval("(" + data + ")");
                if (callback.code == "0") {
                    showbox.hide();
                    Boxy.alert("系统检测到数据库'" + sqlname + "'已经存在，请输入新的数据库名继续安装！");
                    return;
                }
                if (!callback.result) {
                    if (createdDb == 0 && callback.code == "4060") {
                        showbox.hide();
                        Boxy.confirm("您填写的数据库\""+sqlname+"\"不存在,是否尝试在数据库自动创建该名称的数据库?",
                        function on() {
                            runstep = 0;
                            createDbAjax(sqlip, sqlname, loginname, password, tableprefix);
                        }, { title: "是否创建数据库" });
                    }
                    else if (callback.code == "53") {
                        setTimeout(function on() {
                            showbox.hide();
                            Boxy.alert("数据库连接超时,请检查数据库地址是否正确", null, { width: 400 });
                            runstep = 0;
                        }, ++runstep * steptime);
                    }
                    else {
                        setTimeout(function on() {
                            showbox.hide();
                            Boxy.alert(callback.message, null, { width: 400 });
                            runstep = 0;
                        }, ++runstep * steptime);
                    }
                } else {
                    setTimeout(function on() {
                        checkDBCollation(sqlip, sqlname, loginname, password, tableprefix);
                    }, ++runstep * steptime);
                }
            });
        }

        function DBSourceExist(sqlip, sqlname, loginname, password, tableprefix) {
            showbox.show();
            showbox.setContent(alerthead + "正在检测数据库已有数据......</p>");
            jQuery.get('ajax.aspx', { 't': 'dbsourceexist', 'ip': sqlip, 'name': sqlname, 'loginname': loginname, 'loginpwd': password, 'prefix': tableprefix, 'time': Math.random() },
                function (data) {
                    var callback = eval("(" + data + ")");
                    if (callback.result) {
                        showbox.hide();
                        runstep = 0;
                        Boxy.confirm('系统检测到数据库"' + sqlname + '"已经包含所需的数据表,继续安装会清空之前数据,是否继续?',
                        function on() {
                            saveDbSet(sqlip, sqlname, loginname, password, tableprefix);
                        }
                        , { title: "是否继续安装?" });
                    }
                    else {
                        if (callback.code = '208') {
                            setTimeout(function on() {
                                saveDbSet(sqlip, sqlname, loginname, password, tableprefix);
                            }, ++runstep * steptime);
                        } else {
                            showbox.hide();
                            Boxy.alert(callback.message, null, { width: 400 });
                            runstep = 0;
                        }
                    }
                });
        }

        function checkDBCollation(sqlip, sqlname, loginname, password, tableprefix) {
            showbox.show();
            showbox.setContent(alerthead + "正在检测数据库排序规则......</p>");
            jQuery.get('ajax.aspx', { 't': 'checkdbcollation', 'ip': sqlip, 'name': sqlname, 'loginname': loginname, 'loginpwd': password, 'time': Math.random() },
                function (data) {
                    var callback = eval("(" + data + ")");
                    if (callback.result) {
                        setTimeout(function on() {
                            DBSourceExist(sqlip, sqlname, loginname, password, tableprefix);
                        }, ++runstep * steptime);
                    }
                    else {
                        showbox.hide();
                        Boxy.alert(callback.message, null, { width: 400 });
                        runstep = 0;
                    }
            });
        }

        function createDbAjax(sqlip, sqlname, loginname, password, tableprefix) {
            showbox.show();
            showbox.setContent(alerthead + "正在创建数据库......</p>");
            jQuery.get('ajax.aspx', { 't': 'createdb', 'ip': sqlip, 'name': sqlname, 'loginname': loginname, 'loginpwd': password, 'time': Math.random() },
                function (data) {
                    var callback = eval("(" + data + ")");
                    if (callback.result) {
                        createdDb = 1;
                        setTimeout(function on() {
                            checkDbAjax(sqlip, sqlname, loginname, password, tableprefix);
                        }, ++runstep * steptime);
                    } else if (callback.code = "262") {
                        createdDb = 0;
                        setTimeout(function on() {
                            showbox.hide();
                            Boxy.alert('数据库用户 \'' + loginname + '\' 没有创建数据库的权限,创建新数据库失败,请填写已有的数据库 ', null, { width: 400 });
                            runstep = 0;
                        }, ++runstep * steptime);
                    } else {
                        createdDb = 0;
                        setTimeout(function on() {
                            showbox.hide();
                            Boxy.alert(callback.message, null, { width: 400 });
                            runstep = 0;
                        }, ++runstep * steptime);
                    }
                }
            );
        }

        function saveDbSet(sqlip, sqlname, loginname, password, tableprefix) {
            showbox.show();
            showbox.setContent(alerthead + "正在保存数据库配置......</p>");
            jQuery.get('ajax.aspx', { 't': 'savedbset', 'ip': sqlip, 'name': sqlname, 'loginname': loginname, 'loginpwd': password, 'prefix': tableprefix, 'time': Math.random() },
                function (data) {
                    var callback = eval("(" + data + ")");
                    if (callback.result) {
                        setTimeout(function on() {
                            showbox.hide();
                            Boxy.alert(callback.message, function on() { location.href = 'index.aspx?step=forumset'; }, { width: 400 });
                            runstep = 0;
                        }, ++runstep * steptime);
                    }
                }
            );
        }
    </script>
    <%} else if (stepNum == 3) {%>
	<div class="main cl">
		<h1>设置管理员</h1>
		<div class="inner">
			<form id="forumset" action="" method="post">
				<table width="100%" cellspacing="0" cellpadding="0" summary="论坛配置">
				<tbody>
					<tr>
						<td class="title">管理员名称:</td><td><input id="adminname" name="adminname" class="txt" type="text"/></td>
					</tr>
					<tr>
						<td class="title">管理员密码:</td><td><input id="adminpassword" name="adminpassword" class="txt" type="password"/></td>
					</tr>
					<tr>
						<td class="title">管理员密码确认:</td><td><input id="confirmpassword" name="confirmpassword" class="txt" type="password"/></td>
					</tr>
				</tbody>
				</table>
			</form>
		</div>
	</div>
	<div class="btn cl">
		<a href="javascript:history.back();" class="back">上一步</a>
		<a href="###" onclick="checkforumset();" class="next">下一步</a>		
	</div>
    <script type="text/javascript">
        function checkforumset() {
            var adminname = $('#adminname').val();
            var adminpassword = $('#adminpassword').val();
            var confirmpassword = $('#confirmpassword').val();

            if (adminname == "") {
                Boxy.alert('管理员名称不能为空', false, { width: 400 });
                return;
            }
            if (adminpassword == "") {
                Boxy.alert('管理员密码不能为空', false, { width: 400 });
                return;
            }
            if (adminpassword != confirmpassword) {
                Boxy.alert('两次输入的密码不一致', false, { width: 400 });
                return;
            }

            $('#forumset').attr("action", "index.aspx?step=initial");
            $('#forumset').submit();
        }
    </script>
    <%} else if (stepNum == 4) {%>
    <div class="main cl">
		<h1>数据库安装</h1>
		<div class="inner">
			<ul id="processlist" class="list">
            </ul>
		</div>
        <input type="hidden" id="adminname" name="adminname" value="<%=adminName %>" />
        <input type="hidden" id="adminpassword" name="adminpassword" value="<%=adminPassword %>" />

	</div>
	<div class="btn cl">
		<a href="#" class="back">上一步</a>
		<a id="successlink" href="#" class="back">完成</a>
	</div>
    <script type="text/javascript">
        var adminname = $('#adminname').val();
        var adminpassword = $('#adminpassword').val();

        var runstep = 0;
        var steptime = 500;
        function runinstall() {
            $('#processlist').append('<li><img alt="成功" src="images/ok.gif"/>资源准备中......</li>');

            if (adminname == "" || adminpassword == "") {
                $('#processlist').append('<li><img alt="失败" src="images/error.gif"/>管理员帐号数据异常,安装失败......</li>');
                return;
            }
            createTable();
        }

        function createTable() {
            jQuery.get('ajax.aspx', { 't': 'createtable', 'time': Math.random() },
                function (data) {
                    var callback = eval("(" + data + ")");
                    if (callback.result) {
                        setTimeout(function on() {
                            $('#processlist').append('<li><img alt="成功" src="images/ok.gif"/>数据表,约束和索引创建成功......</li>');
                        }, ++runstep * steptime);
                        createSP();
                    }
                    else {
                        setTimeout(function on() {
                            $('#processlist').append('<li><img alt="失败" src="images/error.gif"/>内部异常,数据表创建失败......</li>');
                        }, ++runstep * steptime);
                    }
                }
            );
        }

        function createSP() {
            jQuery.get('ajax.aspx', { 't': 'createsp', 'time': Math.random() },
                function (data) {
                    var callback = eval("(" + data + ")");
                    if (callback.result) {
                        setTimeout(function on() {
                            $('#processlist').append('<li><img alt="成功" src="images/ok.gif"/>选择创建SqlServer ' + callback.message + ' 版本存储过程......</li>');
                        }, ++runstep * steptime);

                        setTimeout(function on() {
                            $('#processlist').append('<li><img alt="成功" src="images/ok.gif"/>存储过程创建成功......</li>');
                        }, ++runstep * steptime);

                        initSource();
                    }
                    else {
                        setTimeout(function on() {
                            $('#processlist').append('<li><img alt="失败" src="images/error.gif"/>内部异常,存储过程创建失败......</li>');
                        }, ++runstep * steptime);
                    }
                }
            );
        }

        function initSource() {
            jQuery.get('ajax.aspx', { 't': 'initsource', 'admin': adminname, 'pwd': adminpassword, 'time': Math.random() },
                function (data) {
                    var callback = eval("(" + data + ")");
                    if (callback.result) {
                        setTimeout(function on() {
                            $('#processlist').append('<li><img alt="成功" src="images/ok.gif"/>初始数据添加成功......</li>');
                        }, ++runstep * steptime);
                        showSuccessLink();
                    }
                    else {
                        setTimeout(function on() {
                            $('#processlist').append('<li><img alt="失败" src="images/error.gif"/>内部异常,' + callback.message + ',请检查......</li>');
                        }, ++runstep * steptime);
                    }
                }
                        );
        }

        function showSuccessLink() {
            setTimeout(function on(){
                $('#successlink').attr('class', 'next');
                $('#successlink').attr('href', '../Index.aspx');
                $('#processlist').append('<li><img alt="成功" src="images/ok.gif"/>安装成功,点击"完成"进入首页......<font color=red>请手动删除install目录</font></li>');
            }, ++runstep * steptime);
        }

        runinstall();
    </script>
    <%} %>
	
<div id="foot">
	<div class="foot">
       <div align="center">
            <p>Copyright &copy; 2004-2014  <a href="http://www.mytaoyuan.com/">www.MyTaoYuan.com</a>  All Rights Reserved</p>
            <p><a href="http://www.mytaoyuan.com/">深圳市盛世桃源网络科技有限公司</a> 版权所有 <a href="http://www.miibeian.gov.cn/state/outPortal/loginPortal.action;jsessionid=clFST5wMXJkJZR1GJjWVC1gJQkqCvxJTHrtTLlfxRhmXyPsh7nQF!1658063959">粤ICP备10101762号</a></p>
        </div>
    </div>
</div>
</body>
</html>