﻿<%@ Page Title="文章管理" Language="C#" MasterPageFile="~/Others/AdminMasterPage.Master" AutoEventWireup="true" CodeBehind="ArticleManage.aspx.cs" Inherits="Web.Admin.Contents.ArticleManage" %>
<%@ Register Assembly="BX.Common" Namespace="Common" TagPrefix="BX" %>
<asp:Content ID="Content1" ContentPlaceHolderID="AdminContentHead" runat="server">
    <script src="../Script/admin.js"></script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="AdminContentCenter" runat="server">
    <form id="form1" runat="server">
        <asp:ObjectDataSource ID="ObjectDataSourceArticle" runat="server" EnablePaging="True"
            SelectMethod="ListByGroup" TypeName="Logic.Article" SelectCountMethod="CountByGroup">
            <SelectParameters>
                <asp:QueryStringParameter DefaultValue="0" Name="conditional" QueryStringField="conditional"
                    Type="string" />
                <asp:QueryStringParameter DefaultValue="0" Name="category" QueryStringField="category"
                    Type="String" />
                <asp:QueryStringParameter DefaultValue="0" Name="keywords" QueryStringField="keywords"
                    Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <div class="DivRightCenter">
            <div class="listdiv">
                <div class="grid-title">
                    <div class="grid-title-text">
                        <h4>
                            <span>文章管理</span>
                        </h4>
                    </div>
                    <div class="grid-title-menu">
                        <ul>
                            <li><a href="ArticleManage.aspx">所有文章</a></li>
                            <li><a href="ArticleManage.aspx?conditional=equare&category=Recommend&keywords=1"><span>推荐文章</span></a></li>
                            <li><a href="ArticleManage.aspx?conditional=equare&category=A.Status&keywords=1"><span>草稿</span></a></li>
                            <li><a href="ArticleManage.aspx?conditional=equare&category=A.Status&keywords=2"><span>待审核</span></a></li>
                            <li><a href="ArticleManage.aspx?conditional=equare&category=A.Status&keywords=3"><span>已审核</span></a></li>
                        </ul>
                    </div>
                </div>
                <div class="grid-list">
                    <BX:ExtendedGridView ID="ExtendedGridView1" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                        CssClass="grid" PageSize="20" DataSourceID="ObjectDataSourceArticle" EnableTheming="False" ItemName="文章管理列表" CheckBox="False" CheckBoxDataIndex="0" DisableShortcuts="False">
                        <Columns>
                            <asp:BoundField DataField="ArticleID" HeaderText="ID" />
                            <asp:BoundField DataField="CategoryName" HeaderText="类别" />
                            <asp:BoundField DataField="Title" HeaderText="标题" />
                            <asp:TemplateField HeaderText="推荐">
                                <ItemTemplate>
                                    <%# DataBinder.Eval(Container.DataItem, "Recommend").Equals(1)?"推荐":""%>
                                </ItemTemplate>
                                <ItemStyle Width="50px" Wrap="False" />
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="状态">
                                <ItemTemplate>
                                    <%#DataBinder.Eval(Container.DataItem, "Status").Equals(3)?"已审核":DataBinder.Eval(Container.DataItem, "Status").Equals(2)?"待审核":"草稿"%>
                                </ItemTemplate>
                                <ItemStyle Width="50px" Wrap="False" />
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="操作">
                                <ItemTemplate>
                                    <div>
                                        <ul id='Menu<%#Eval("ArticleID")%>'>
                                            <li><a href='<%#"ArticleEdit.aspx?id="+DataBinder.Eval(Container.DataItem,"ArticleID") %>'>修改</a></li>
                                            <%--<li><a href='<%#"ArticleManage.aspx?cmd=delete&id="+DataBinder.Eval(Container.DataItem,"ArticleID") %>' onclick="return confirm('确定删除?');">删除</a> </li>--%>
                                            <li><a href="javascript:" onclick="if(confirm('确定删除?')){alert('删除成功!');};">删除</a> </li>
                                        </ul>
                                        <script type="text/javascript">DownMenu.load(document.getElementById("Menu<%#Eval("ArticleID")%>"))</script>
                                    </div>
                                </ItemTemplate>
                                <ItemStyle Width="100px" Wrap="False" />
                            </asp:TemplateField>
                        </Columns>
                    </BX:ExtendedGridView>
                  <script type="text/javascript">DownMenu.load()</script>
                </div>
            </div>
            <br />
            <div class="FormButtonArea">
                <asp:Button ID="Button1" runat="server" UseSubmitBehavior="false" OnClientClick="AddNew();return false;"
                    Text="添加新文章" />&nbsp;&nbsp;
                <script type="text/javascript">
                    function AddNew() {
                        document.location.href = 'ArticleEdit.aspx?UserID='+<%=Request.QueryString["UserID"]%>+'&CategoryID='+<%=Request.QueryString["CategoryID"]%>;
                    }
                </script>
            </div>
        </div>
        <br />
        <br />
    </form>
</asp:Content>