﻿<%@ Page Title="表字段编辑" StylesheetTheme="AdminSkin" Language="C#" MasterPageFile="~/Others/AdminMasterPage.Master" AutoEventWireup="true" CodeBehind="FieldEdit.aspx.cs" Inherits="Solution.Admin.Contents.FieldEdit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="AdminContentHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="AdminContentCenter" runat="server">
    <form id="form11" runat="server" method="post" enctype="multipart/form-data">
        <div class="formtextfield">
            <div class="title">
                <h4><span>表字段编辑</span></h4>
            </div>
            <div class="content">
                <table width="100%" border="0" cellpadding="0" cellspacing="0">
                    <tr>
                        <td class="fieldname">字段名称:
                        </td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="txtFieldName" runat="server" Width="288" MaxLength="25" CssClass="text form-validate" />
                            <asp:CustomValidator ControlToValidate="txtFieldName" ClientValidationFunction="Validator.NonEmpty" ErrorMessage="不能为空" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                        </td>
                        <td class="fielddescription"></td>
                    </tr>
                    <tr>
                        <td class="fieldname">字段别名:
                        </td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="txtFieldProperty" runat="server" Width="288" MaxLength="100" CssClass="text form-validate" />
                            <asp:CustomValidator ControlToValidate="txtFieldProperty" ClientValidationFunction="Validator.NonEmpty" ErrorMessage="不能为空" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                        </td>
                        <td class="fielddescription">尽量不要与数据库的关键词冲突,否则会增加失败的机率</td>
                    </tr>
                    <tr>
                        <td class="fieldname">字段描述:</td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="txtDescription" runat="server" Rows="3" Width="288" MaxLength="100" TextMode="MultiLine" /></td>
                        <td class="fielddescription">可选,可以用来对字段信息进行描述,会显示在最右侧一列</td>
                    </tr>
                    <tr>
                        <td class="fieldname">占位符:</td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="Placeholder" runat="server" Rows="3" Width="288" MaxLength="100" TextMode="MultiLine" /></td>
                        <td class="fielddescription">可选,填写后会出现在文本框里面</td>
                    </tr>
                    <tr>
                        <td class="fieldname">字段标签:</td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="PropertyLabel" runat="server" Width="288" MaxLength="100" /></td>
                        <td class="fielddescription">可选,紧跟控件后面的文本,可用来作为字段的单位等</td>
                    </tr>
                    <tr>
                        <td class="fieldname">所属模板:</td>
                        <td class="fieldvalue">
                            <asp:DropDownList ID="ddlFormTemplate" DataTextField="TemplateName" DataValueField="TemplateID" runat="server">
                            </asp:DropDownList>

                        </td>
                        <td class="fielddescription"></td>
                    </tr>
                    <tr>
                        <td class="fieldname">html控件:
                        </td>
                        <td class="fieldvalue">
                            <asp:DropDownList ID="ddlHtmlControl" DataTextField="Name" DataValueField="HtmlID" runat="server" AutoPostBack="True" OnSelectedIndexChanged="ddlHtmlControl_SelectedIndexChanged">
                            </asp:DropDownList>
                            <asp:DropDownList ID="ddlControlOptionGroup" runat="server" DataTextField="GroupName" DataValueField="GroupID">
                            </asp:DropDownList>
                        </td>
                        <td class="fielddescription"></td>
                    </tr>
                    <tr>
                        <td class="fieldname">数据类型:</td>
                        <td class="fieldvalue">
                            <asp:DropDownList ID="ddlDataType" runat="server">
                            </asp:DropDownList>
                        </td>
                        <td class="fielddescription">建议根据此类型来写验证规则,保存之后则不可修改</td>
                    </tr>
                    <tr>
                        <td class="fieldname">验证规则:
                        </td>
                        <td class="fieldvalue">
                            <asp:DropDownList ID="ddlVerification" DataTextField="Name" DataValueField="VerificationID" runat="server">
                            </asp:DropDownList>
                        </td>
                        <td class="fielddescription"></td>
                    </tr>
                    <tr>
                        <td class="fieldname">内容长度:</td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="txtMax" runat="server" Width="88" MaxLength="4" Text="10" />
                            <asp:CustomValidator ControlToValidate="txtMax" ClientValidationFunction="Validator.Digit" ErrorMessage="请填写整数" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                        </td>
                        <td class="fielddescription">限制输入最大字符个数,不可再次修改</td>
                    </tr>
                    <tr>
                        <td class="fieldname">允许为空:
                        </td>
                        <td class="fieldvalue">
                            <asp:CheckBox ID="ckbIsNull" runat="server" Checked="true" Text="允许为空" />
                        </td>
                        <td class="fielddescription">仅控制表单填写,可以随时更改</td>
                    </tr>
                    <tr>
                        <td class="fieldname">字段状态:
                        </td>
                        <td class="fieldvalue">
                            <div>
                                <asp:CheckBox ID="ckbFieldStatus" runat="server" Text="隐藏" />
                            </div>
                        </td>
                        <td class="fielddescription"></td>
                    </tr>
                    <tr>
                        <td class="fieldname">字段排序:
                        </td>
                        <td class="fieldvalue">
                            <asp:TextBox ID="txtFieldOrder" runat="server" Width="88" MaxLength="4" Text="0" />
                            <asp:CustomValidator ControlToValidate="txtFieldOrder" ClientValidationFunction="Validator.Digit" ErrorMessage="请填写整数" ValidateEmptyText="true" CssClass="fielderror" runat="server"></asp:CustomValidator>
                        </td>
                        <td class="fielddescription"></td>
                    </tr>
                </table>
            </div>
            <table width="100%" border="0" cellpadding="2" cellspacing="1">
                <tr>
                    <td colspan="2" align="center">
                        <asp:Button ID="btnSaveInfo" runat="server" Text="保存" OnClick="btnSaveInfo_Click" SkinID="ButtonSave" />
                        <asp:Button ID="btnCancel" runat="server" Text="取消" SkinID="ButtonCancel" CausesValidation="false" OnClick="Cancel_Click" />
                    </td>
                </tr>
            </table>
        </div>
    </form>
</asp:Content>
