﻿<%@ Page Title="友情链接管理" StylesheetTheme="AdminSkin" Language="C#" MasterPageFile="~/Others/AdminMasterPage.Master" AutoEventWireup="true" CodeBehind="FriendLinkList.aspx.cs" Inherits="Solution.Admin.Contents.FriendLinkList" %>

<%@ Register Assembly="BX.Common" Namespace="Common" TagPrefix="cc1" %>
<asp:Content ID="Content1" ContentPlaceHolderID="AdminContentHead" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="AdminContentCenter" runat="server">
    <form id="Form1" runat="server">
        <asp:ObjectDataSource ID="ObjectDataSourceFriendLink" runat="server" EnablePaging="True"
            SelectCountMethod="Count" SelectMethod="List" TypeName="Logic.FriendLink"
            OldValuesParameterFormatString="original_{0}">
            <SelectParameters>
                <asp:QueryStringParameter DefaultValue="0" Name="category" QueryStringField="category"
                    Type="String" />
                <asp:QueryStringParameter DefaultValue="0" Name="keywords" QueryStringField="keywords"
                    Type="String" />
                <asp:QueryStringParameter DefaultValue="0" Name="conditional" QueryStringField="conditional"
                    Type="String" />
            </SelectParameters>
        </asp:ObjectDataSource>
        <div class="DivRightCenter">
            <div class="listdiv">
                <div class="grid-title">
                    <div class="grid-title-text">
                        <h4>
                            <span>友情链接管理</span>
                        </h4>
                    </div>
                    <div class="grid-title-menu">
                        <ul>
                            <li><a href="FriendLinkList.aspx"><span>所有内容</span></a></li>
                            <li><a href="FriendLinkList.aspx?conditional=equals&category=LinkStatus&keywords=1">
                                <span>显示状态</span></a></li>
                            <li><a href="FriendLinkList.aspx?conditional=equals&category=LinkStatus&keywords=2">
                                <span>隐藏状态</span></a></li>
                        </ul>
                    </div>
                </div>
                <div class="grid-search">
                    Search:
                       <div class="grid-searchcontent">
                           <div class="userddl">
                               <ul>
                                   <li class="userddl-li">
                                       <input style="width: 40px;" class="ddltext" value="" id="ddlSearchOption" type="text" /><a href="javascript:" class="ddlarrow"></a></li>
                               </ul>
                           </div>
                           <input class="searchtext" id="txtKeywords" onkeypress="if(event.keyCode==13){ListSearch();}" type="text" /><input class="searchbutton" id="Button6" type="button" value="" onclick="ListSearch();" />
                       </div>
                </div>
                <div class="grid-list">
                    <cc1:ExtendedGridView ID="ExtendedGridView1" runat="server" AllowPaging="True" AutoGenerateColumns="False"
                        CssClass="grid" DataSourceID="ObjectDataSourceFriendLink"
                        CheckBox="False" EnableTheming="False" ItemName="友情链接" PageSize="20">
                        <Columns>
                            <asp:BoundField DataField="LinkID" HeaderText="ID">
                                <HeaderStyle Wrap="False" />
                                <ItemStyle Wrap="False" Width="50px" />
                            </asp:BoundField>
                            <asp:BoundField DataField="LinkName" HeaderText="链接名称">
                                <ItemStyle Wrap="False" HorizontalAlign="Left" />
                            </asp:BoundField>
                            <asp:BoundField DataField="CategoryName" HeaderText="类别">
                                <ItemStyle Width="100px" Wrap="False" />
                            </asp:BoundField>
                            <asp:TemplateField HeaderText="类型">
                                <ItemStyle Width="50px" Wrap="False" />
                                <ItemTemplate>
                                    <%#Convert.ToInt32(DataBinder.Eval(Container.DataItem, "LinkType")) == 1 ? "文字" : "图片"%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="首页">
                                <ItemStyle Width="50px" Wrap="False" />
                                <ItemTemplate>
                                    <%#Convert.ToInt32(DataBinder.Eval(Container.DataItem, "IsRecommend")) == 1 ? "是" : "否"%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="状态">
                                <ItemStyle Width="50px" Wrap="False" />
                                <ItemTemplate>
                                    <%#Convert.ToInt32(DataBinder.Eval(Container.DataItem, "LinkStatus")) == 1 ? "显示" :Convert.ToInt32(DataBinder.Eval(Container.DataItem, "LinkStatus")) ==3?"新申请":"隐藏"%>
                                </ItemTemplate>
                            </asp:TemplateField>
                            <asp:TemplateField HeaderText="操作">
                                <ItemStyle Width="100px" Wrap="False" />
                                <ItemTemplate>
                                    <a href='FriendLinkList.aspx?cmd=delete&id=<%#DataBinder.Eval(Container.DataItem, "LinkID")%>'
                                        onclick="return confirm('确认删除?');">删除</a>&nbsp; <a href='FriendLinkInfo.aspx?cmd=modify&id=<%#DataBinder.Eval(Container.DataItem, "LinkID")%>'>修改</a>
                                </ItemTemplate>
                            </asp:TemplateField>
                        </Columns>
                    </cc1:ExtendedGridView>
                </div>
            </div>
            <div class="FormButtonArea">
                <asp:Button ID="Button2" runat="server" Text="添加信息" OnClientClick="window.location.href='FriendLinkInfo.aspx';return false;" />&nbsp;&nbsp;
                        <asp:Button ID="Button1" runat="server" Text="添加分类" OnClientClick="window.location.href='FriendLinksCategoryInfo.aspx';return false;" />&nbsp;&nbsp;
            <asp:Button ID="Button3" runat="server" Text="分类管理" OnClientClick="window.location.href='FriendLinksCategoryList.aspx';return false;" />

            </div>
            <br />
            <script type="text/javascript">
                var searchOption = new DropDownList("ddlSearchOption");
                searchOption.initial({ "名称": "LinkName" }, { "extend": true });
                function ListSearch() {
                    var keywords = document.getElementById("txtKeywords").value;
                    if (keywords != "") {
                        window.location.href = "FriendLinkList.aspx?category=" + searchOption.get() + "&keywords=" + encodeURI(keywords);
                    } else {
                        window.location.href = "FriendLinkList.aspx";
                    }
                }
            </script>
        </div>
    </form>
</asp:Content>
